/*ALC--   Albert Crosby's Directory Indexing code.    */

/* ----------------------------------------------------------------------- */
/* BUILDDIR: Builds a directory map on the fly.                            */
/* ----------------------------------------------------------------------- */
/*builddir: procedure expose Dir. tempfile sel	*/
  parse arg dir, sel, Dir.Describe, Dir.Info, Dir.Exclude

/*say 'Attempting to build directory for 'dir	*/

  fulldir=translate(dir,'\','/')
  message = ''
/*say 'fulldir = ['fulldir']'	*/

  description.=""
  if Dir.Describe\="" then
    do while lines(fulldir||Dir.Describe)
      line=linein(fulldir||Dir.Describe)
      if left(line,1)='"' then parse var line '"'name'"' desc
      else parse var line name desc
      name=translate(translate(name,'_',' '))
      description.name=desc
    end

  crlf = '0a0d'x
  message = 	'<!doctype html public "-//IETF//DTD HTML 2.0//EN">'crlf,
  		"<html><head><title>Contents of "sel"</title></head>"crlf,
  		"<body><h2>Contents of "sel"</h2>"crlf,
  		"<hr>"crlf

  if stream(fulldir||Dir.Info, 'c', 'query exists')\='' then do
    msg = charin(fulldir||Dir.Info,,chars(fulldir||Dir.Info))
    message = message || msg || "<hr>" || crlf
/*    address cmd 'type 'fulldir||Dir.Info'>>'tempfile 
    call lineout tempfile, "<hr>"*/
    end
  call SysFileTree fulldir||'*.*','files.','D','*+-*-'
  message = message || '<pre><img src="/icons/dblank.gif" alt="      " width=24 height=24>' left("Name",20) left("Last Modified",17) right("Size",10) '</pre>'crlf
  parent=translate(filespec('path',left(fulldir,length(dir)-1)),'/','\')
  if (length(sel) > 0) then _sel = left(sel, length(sel) -1)
  else _sel = sel
  if dir\=sel then parent='/'||translate( filespec('path', _sel),'/','\')
  message = message || '<hr><dt><pre><img src="/icons/back.gif" alt="[back]" width=24 height=24> <a href="'parent'">Parent directory</a></pre>'crlf
  do i=1 to files.0
    parse var files.i date time size attribs fullname
    name=filespec('name',fullname)
    dname=name||"/"
    message = message || '<dt><pre><img src="/icons/menu.gif" alt="[dir] " width=24 height=24> <a href="'dname'">'dname'</a></pre>'crlf
    name=translate(translate(name,'_',' '))
    if description.name\='' then
      message = message || '<dd><i>'description.name'</i>'crlf
  end
  call SysFileTree fulldir||'*.*','files.','F','**-*-'
  do i=1 to files.0
    parse var files.i date time size attribs name
    name=filespec('name',name)
    /* Don't display excluded files */
    if (wordpos(translate(name),translate(Dir.Exclude)) \= 0) then iterate
    message = message || '<dt><pre>'imagetype(name),
		'<a href="'name'">'strip(left(name,20))'</a>'copies(' ',max(0,20-length(name))),
		right(date,8) right(time,8) right(size,10)'</pre>'crlf
    name=translate(translate(name,'_',' '))
    if description.name\='' then
      message = message || '<dd><i>'description.name'</i>'crlf
  end

  return message || "</dl>"crlf

/*******/
/* IMAGETYPE: Return the name of the image file to use based on file type */
/*******/

imagetype: procedure
  size='width=24 height=24'

  e=extension(arg(1))

  select
    when e='TXT' | e='CMD' | e='DOC' | e='FAQ' | e='SAS'
      then return '<img src="/icons/text.gif"' size 'alt="[text]">'
    when e='HTM' | e='HTML'
      then return '<img src="/icons/text.gif"' size 'alt="[html]">'
    when e='PS'
      then return '<img src="/icons/text.gif"' size 'alt="[ps]  ">'
    when e='EXE' | e='ZIP' | e='ARC' | e='ARJ'
      then return '<img src="/icons/binary.gif"' size 'alt="[bin] ">'
    when e="AU" | e="WAV" | e="MID"  | e="SND"
      then return '<img src="/icons/sound.gif"' size 'alt="[snd] ">'
    when e="GIF" | e="JPG" | e="JPEG" | e="TIF" | e="TIFF" | e="BMP"
      then return '<img src="/icons/image.gif"' size 'alt="[img] ">'
    when e="MPG" | e="MPEG" | e="AVI"
      then return '<img src="/icons/movie.gif"' size 'alt="[mov] ">'
    otherwise
      return '<img src="/icons/unknown.gif"' size 'alt="[file]">'
  end


extension: procedure
arg filename
/* If no period or only period is first char, then return "" */
if lastpos(".",filename)<2 then return ""
return translate(substr(filename, lastpos('.',filename)+1))

/*ALC--   Albert Crosby's Directory Indexing code.   --End   */
