:userdoc.
:title.FtpServer documentation
:docprof toc=12.

.***********************************
.*   INTRODUCTION
.***********************************

:h1.Introduction
:p.
FtpServer is an ftp daemon for OS/2.  It is distributed as
:link reftype=hd refid=register.optional shareware:elink..
This documentation is for version 0.85.
:p.
:hp2.Disclaimer of Warranty:ehp2.

:sl compact.
:li.
:hp8.
This Product is provided "as-is", without warranty of any
kind, either expressed or implied, including, but not limited to,
the implied warranties of merchantability and fitness for a
particular purpose.  The entire risk as to the quality and
performance of the Product is with you.  Should the Product prove
defective, the full cost of repair, servicing, or correction lies
with you.
:ehp8.
:esl.

:p.
The author of FtpServer is Peter Moylan, peter@ee.newcastle.edu.au.

:p.
The latest version of FtpServer is normally kept at ftp&colon.&slash.&slash.eepjm.newcastle.edu.au/software
.br
Information about other software on this site may be found at
http&colon.&slash.&slash.eepjm.newcastle.edu.au/os2/software.html.

:p.I keep a mailing list of people who receive e-mail notification of
new versions of my software.  If you want to be put on this list, let me
know by e-mail to peter@ee.newcastle.edu.au.
The mailing list is not used for any other purposes, and the addresses will not
be passed on to anyone else.

.***********************************
.*   REGISTRATION
.***********************************

:h1 id=register.Registration

:hp2.Registration:ehp2.

:p.This software is "optional shareware".  What this means is that you
decide whether you want to register as a paid owner of the software.
The software is not crippled in any way, and I will continue to provide
support and free releases of new versions to all users, whether or
not they are registered, for at least the short-term future.

:p.If you decide that this software is worth supporting, you have the
following payment options.
:p.
:hp2.Payment through BMT Micro:ehp2.

:p.This is likely to be the most convenient method for most people,
because BMT Micro has a number of different payment methods, including
credit cards.  It also has agents in several countries.  For full
details, see the BMTMicro folder included in the FtpServer distribution.
(This includes a program that simplifies registration by e-mail, if
you want to do it that way.)  The price is $20 (US dollars).

:p.
:hp2.From Europe:ehp2.

:p.This works best for people living in the European Union.  (Warning:
check first whether your bank is going to charge you transfer fees.
They shouldn't, but I've heard of exceptions.)  You have two options:
:ul.
:li.Transfer 20, or the equivalent in Belgian francs, to the following bank account
:sl.
:li.Marion Gevers
.br
Account number 220-0586389-60
.br
G&ea.n&ea.rale de Banque (Belgium)
.br
Mention: FtpServer
:esl.
:p.and send an e-mail to peter@ee.newcastle.edu.au to confirm that you've done it.

:li.Send a Eurocheque for 750 Belgian francs to
:sl.
:li.Peter Moylan
.br
91 Harriet Street
.br
Waratah, NSW 2298
.br
Australia
:esl.
:eul.

:p.
:hp2.Payment directly to me in Australia:ehp2.

:p.This is a more attractive option for people in Australia.  From
other countries, it's not a good idea because of the bank charges on
international transfers.  (Please don't send non-Australian currency
to an Australian bank, because then I get hit with exorbitant bank fees.)
You can do it in either of two ways.

:ul.
:li.Send a cheque, or equivalent, for $25 (Australian dollars) to
:sl.
:li.Peter Moylan
.br
91 Harriet Street
.br
Waratah, NSW 2298
.br
Australia
:esl.

:li.Transfer the amount of $25 (Australian dollars) to the following bank
account.
:sl.
:li.Marion Gevers
.br
Account number (06 2831) 00626468
.br
Commonwealth Bank
.br
University of Newcastle, Australia
:esl.
:eul.

.*************************************
.*   DOCUMENTATION IN OTHER LANGUAGES
.*************************************

:h1.Documentation in other languages
:hp2.Documentation in other languages:ehp2.
:p.
To simplify the distribution, the FtpServer zip file normally contains only
English-language documentation.  To get documentation in another language,
go to ftp&colon.&slash.&slash.eepjm.newcastle.edu.au/inf and look for
a file called ftpserver.inf.xxx, where xxx indicates the language.
If you want to volunteer to do another translation, you will find the original
document source (FtpServer.IPF) in source.zip, which is included as part
of the FtpServer distribution.

:p.The copyright on the translations belongs to the people who did
the translations.

:p.The versions that are now available are
:table cols='19 19 23'.
:row.
:c.Italiano/Italian
:c.ftpserver.inf.it
:c.Andrea Brancatelli
:row.
:c.Pyccku&ug./Russian
:c.ftpserver.inf.866
:c.Konstantin Boyandin
:etable.

.***********************************
.*   SERVER FEATURES
.***********************************

:h1 res=002.Server features

FtpServer is an ftp server program that implements most of the ftp standard,
RFC 959.  It supports re-get and passive mode transfers.  The system manager
can control which directories are visible to users, and the kind of
access (read, write, delete) allowed in each directory.

:p.
For further details, see
:ul compact.
:li.:link reftype=hd refid=special.What's special about FtpServer:elink.
:li.:link reftype=hd refid=limitations.Limitations and missing features:elink.
:li.:link reftype=hd refid=quirks.Quirks:elink.
:li.:link reftype=hd refid=troublesome.Troublesome clients:elink.
:li.:link reftype=hd refid=nonstandard.Nonstandard features:elink.
:eul.

:h2 id=special.What's special about FtpServer?

:ul.
:li.Supports essentially all of what's in the FTP standard, including re-get and
passive mode.

:li.Fast and compact.

:li.Compatible with all FTP clients that I've been able to test.

:li.Separate read, write, and delete permission for each directory
the user can see.  You can also make directories invisible.
Users can be given access to multiple drives or network drives, if desired.

:li.The directories seen by a user can include symbolic links.

:li.You can restrict the IP addresses from which clients can log in,
and you can restrict the number of simultaneous logins from the
same address.

:li.Can be run from inetd.

:li.Can be run detached.

:eul.

.**************************************
.*   LIMITATIONS AND MISSING FEATURES
.**************************************

:h2 id=limitations.Limitations and missing features
LIMITATIONS AND MISSING FEATURES

:p.
These are things I might fix up when I have the time, though some
have higher priority than others.

:ul.

:li. Transfer types: only Ascii, Image, and "Local 8" are supported.
Support for Fortran carriage control and EBCDIC will probably
never be added.

:li. Page-structured files will probably never be supported.
(As far as I know, only PDP-10 systems support this feature.)

:li. The only supported transmission mode is stream mode.  I might
or might not add support for block mode and compressed mode
at a later stage.  For the moment, there doesn't seem to be
any demand for these extras - I haven't come across any ftp
client that uses them.

:eul.

:p.The only command from RFC 959 that is not implemented is STAT.

.***********************************
.*   QUIRKS
.***********************************

:h2 id=quirks.Quirks
QUIRKS

:p.
These might be seen as errors, but there's no need to fix them
because they don't have a harmful effect.

:ul.
:li. Can CD to a directory that doesn't exist, if that directory is
shown as visible in the user's permission file.  Not a real
problem, because the user sees an empty listing and can't do
any operations in that directory.

:eul.

.***********************************
.*   TROUBLESOME CLIENTS
.***********************************

:h2 id=troublesome.Troublesome clients
TROUBLESOME CLIENTS

:p.
Different ftp clients work differently, and some of them don't
bother to adhere to the standards, so there will probably always
be some client incompatibilities.  The ones I know about so
far are:

:ol.
:li.One of the MS-Windows ftp clients (for the moment I've forgotten
which one) gives unreasonable time delays when listing a short
directory, although long listings are quite fast.  The tests
I've been able to do suggest that this problem occurs only
when the client and server machines are physically close to
each other.  Once the network delays rise to more typical
values, the problem goes away.

:li.I've been told of a problem when using ws-ftp, involving a
"can't change directory" symptom when fetching the entire
contents of a directory; but I've been unable to
reproduce the problem and I'm still not quite sure of the
precise nature of the problem.

:li.Apparently some proxy servers can't handle multiline responses
to FTP commands. If you hit this problem, you might be able to
solve it by deleting the file WELCOME.MSG.
:eol.

.***********************************
.*   NON-STANDARD FEATURES
.***********************************

:h2 id=nonstandard.Non-standard features
NON-STANDARD FEATURES

:p.
The program violates RFC959 in the following ways:

:ol.
:li. Extra commands SIZE and MDTM are implemented.

:li. The SYST command returns a reply of UNIX rather than OS/2.
I had to do this because the "correct" reply causes
WebExplorer to misinterpret the directory listings, and
I'm told that at least one Microsoft ftp client will refuse
to connect to a server that identifies itself as OS/2.

:li. The obsolete and non-official commands XMKD, XRMD, XPWD, XCUP,
and XCWD are implemented.  (These became obsolete more than
10 years ago, and most ftp clients don't use them; but
apparently one of the clients for Windows NT hasn't yet been
updated to the current standard.)

:eol.

.***********************************
.*   INSTALLATION
.***********************************

:h1.Installation
:hp2.Installation:ehp2.
:p.
See also :link reftype=hd refid=deinstall.De-installation:elink.

:p.
You should have received this package in the form of a zip file.
To install it, simply unzip the file into a directory of your choice.
(Presumably you've already done this.)  The server is now ready to
run.

:p.
The server itself is the program called ftpd.exe.  You can run it
either by double-clicking on the desktop icon, or by entering the
command "ftpd" in a command-line session.  (In the latter case, make
sure you're in the right directory, otherwise you'll end up running
the ftpd that was supplied with OS/2.)  Most people will want to
put a program object or shadow for ftpd into the startup folder,
so that the server will run each time the system is booted; but that's
up to you.

:p.
Even though the server will work "out of the box", you still need to
define the user permissions so that clients can connect to the server.
You can do this either before running the server, or while it's
running.  See :link reftype=hd refid=setupusers.Setting up the User
Permissions:elink..

:p.The file source.zip is optional.  If you're not interested in the
source code, you can delete it.
:p.
For some other options, see
:ul compact.
:li.:link reftype=hd refid=parameters.Command line parameters:elink.
:li.:link reftype=hd refid=inetd.Running from inetd:elink.
:li.:link reftype=hd refid=detached.Running FtpServer detached:elink.
:li.:link reftype=hd refid=welcome.Welcome messages:elink.
:eul.

.***********************************
.*   DEINSTALLATION
.***********************************

:h1 id=deinstall.De-installation
:hp2.De-installation:ehp2.
:p.
FtpServer does not tamper with CONFIG.SYS or with other system files.
If you decide that you don't want to keep FtpServer, simply delete
the directory into which you installed it.

.***********************************
.*   SETTING UP THE USER PERMISSIONS
.***********************************

:h1 id=setupusers.Setting up the User Permissions

:hp2.User Permissions:ehp2.

:ul compact.
:li.:link reftype=hd refid=UPconcepts.General concepts:elink.
:li.:link reftype=hd refid=PMconfiguser.Setting up users with the PMSetup program:elink.
:li.:link reftype=hd refid=configuser.Setting up users with the VIOSetup program:elink.
:li.:link reftype=hd refid=configmanual.Manual configuration:elink.
:eul.

.***********************************
.*   GENERAL CONCEPTS
.***********************************

:h2 id=UPconcepts.User permissions: General concepts

:hp2.GENERAL CONCEPTS:ehp2.

:p.
Each user of the server has a login name (username), a password, and
a tree of accessible directories.  Typically this tree consists of
one home directory and all of its subdirectories, but more complex
arrangements are possible.  The system manager may, by the use
of symbolic links, allow the tree to cross multiple drives or even
multiple nodes on the local area network.  The system manager may also
allow access to a directory but block access to specified subdirectories
of that directory.  In all cases, a user is restricted to using the
directories that the system manager has specified for that user.  Users
cannot get at, or even see, any other directories in the machine's file
system.  Furthermore, users are not told the true physical paths of
those directories that they are allowed to see.

:note.
In this context, "user" refers to a username rather than to
a person.  For example, you might have a number of different
people all accessing the server via the username "anonymous".
As far as the server is concerned, they are not separate users,
but rather separate instances of the user called "anonymous".

:p.
The server looks up the user information in an INI file called FTPD.INI,
which should be in the same directory as ftpd.exe. This INI file is created
and maintained by the PMSetup or VIOSetup utility, as explained below.

:p.
There are two ways to create and edit the user permissions.
:ol.
:li.By using the VIOSetup or PMSetup program that is supplied with FtpServer.
(VIOSetup and PMSetup do the same job, except that one of them is a
text-mode program and the other isn't.)
This is the recommended method, for compatibility with future releases
of FtpServer, and also because this method ensures that you produce
syntactically correct permission data.  The procedure is described
in the sections :link reftype=hd refid=PMconfiguser.Using the PMSetup utility:elink.
and :link reftype=hd refid=configuser.Using the VIOSetup utility:elink..
:li.Manually, using any text editor.  The details can be found in the section
:link reftype=hd refid=configmanual.Manual configuration:elink..  Manual
configuration is supported for the benefit of existing FtpServer users who
have become used to doing it this way; but it is not the recommended method,
because it's too easy to make mistakes.
:eol.

:p.
:hp2.User categories:ehp2.

:p.
Each user is classified as one of the following.

:dl break=none.
:dt.   G
:dd.Guest user, who has to provide an e-mail address as a password.
:dt.   U
:dd.Normal user, who has to supply a password
:dt.   N
:dd.User who does not need a password.
:dt.   M
:dd.Manager: same as U, except that a manager gets some
:link reftype=hd refid=manager.extra privileges:elink..
:edl.

:p.
Normally you would create one "manager" account for yourself, and use
the G or U categories for all other users.  The N category is for those
rare cases where you don't need to control access with a password.

:p.
:hp2.Directory permissions:ehp2.

:p.
Each directory that is accessible to the user is described by some
combination of the following five permission attributes.

:dl break=none.
:dt.   V
:dd.Directory visible.  This should be set in most cases.  When it's not
set, the client can't do a "change directory" to this directory, and it
won't appear in directory listings.
:dt.   R
:dd.Read permission.  If this is set then the client can download files
from this directory.
:dt.   W
:dd.Write permission.  If this is set then the client can upload files
to this directory.
:dt.   D
:dd.Delete permission.  If this is set then the client can delete files
from this directory.  Note: to overwrite an existing file, both W and D
permissions are needed.
:dt.   N
:dd.Rename permission.  If this is set then the client can rename files
in this directory.  Note: if the rename results in moving a file to a
different directory, then the N permission flag is no longer relevant.  In that
case, the user needs a D permission for the source directory and a
W permission for the destination directory.
:edl.

:nt text='Remark'. It is possible for a user to be given read, write,
delete, and/or rename privileges to an invisible directory.  In such cases the users can
perform the permitted operations only if they know the correct file name,
including the directory name,
because they won't see the directory name in a directory listing.
:p.
It's also possible for an invisible directory to have visible subdirectories.
Users can get to those directories only if they know the path name, including
the name of the invisible directory.
:ent.
:p.
:hp2.Symbolic links:ehp2.
:p.
A symbolic link is a pointer to some other part of the machine's file system.
You - the system manager - can insert symbolic links in any directory.
From the user's point of view, a symbolic link looks like just another
subdirectory.
:p.
A symbolic link has a name (which is what the user sees) and a physical
path (which is known only to the system manager).  The physical path must
be either a null string, or a full path name including the drive letter.
:p.
A symbolic link normally points to a directory, but it is also possible
to create a symbolic link to a file that is not a directory.
:p.
Note that the user cannot see any difference between a symbolic link and
an ordinary file or subdirectory name.  All that the user sees is a single
directory tree that starts with a root node called "/".

:p.
:hp2.Pseudo-directories:ehp2.
:p.
It is possible to specify a symbolic link whose physical path is unspecified.
(That is, it is an empty string.)  This creates a pseudo-directory:
something that ftp clients will see as a directory, but which does not
correspond to any physical directory.  A pseudo-directory cannot hold any
real files, but it can contain symbolic links.
:p.
The main use for a pseudo-directory is for the case where you want to give
a user access to several unrelated directories, possibly on different
drives.  To do this, you make the user's top-level directory a
pseudo-directory, and then put links in that directory to the directories
that the user is allowed to see.

.***********************************
.*   MANUAL CONFIGURATION
.***********************************

:h2 id=configmanual.Manual configuration

:hp2.Manual configuration of users:ehp2.

:p.
This section describes how to edit a permission file.  It can be skipped
by most people, because in most cases it's better to use the
:link reftype=hd refid=PMconfiguser.PMSetup:elink. or
:link reftype=hd refid=configuser.VIOSetup:elink. program to automate the editing.

:p.If the user information is already in the server's INI file (e.g.
because you used the PMSetup utility to add this user), then the first
thing you need to do is to use
the :link reftype=hd refid=loadstore.StorePRM utility:elink. to create
a PRM file for this user. (Of course this step is not needed if you have
an existing PRM file for the user.)  After editing the PRM file, which
you can do with any text editor, you can use the
:link reftype=hd refid=loadstore.LoadPRM utility:elink. to load the
information back into the INI file.

:p.
A PRM file is free-format, i.e. the exact formatting is not
important; but, for the sake of readability, I suggest that
you use indentation etc. to make its structure clearer.

:p.
The file can include comments.  A comment is anything from the
'%' sign to the end of the current line.  Note, however, that comments
will be stripped out when the LoadPRM program loads the data into the
server's INI file.

:p.
File names containing spaces or special characters should be
delimited by either double quote marks ("...") or single
quote marks ('...').  For "normal" file names the quotation
marks are optional.  (But see the warning later in this page.)

:p.
The first five things in a permission file are:

:ol.
:li.The user category code (G, U, N, M), as described in the
:link reftype=hd refid=UPconcepts.General concepts:elink. section.
:li.The password.  For a guest user, put "@" as the password.
For an 'N' user, just supply a dummy entry here.
:li.The user limit (a numeric value).
:li.This user's speed limit (a numeric value).
:li.The user's real name.
:eol.
:p.Next, you may have some notes - up to 2048 characters - starting
with the character pair '(*' and finishing with '*)'.  If the
strings (* and *) occur inside the notes, they must occur as
properly nested matched pairs.

:p.Finally you specify the directory information, in the format
:p.
       <directory name> <directory descriptor>
:p.
where <directory name> specifies the user's root directory.  There
are two possible ways to specify a <directory&rbl.name>:
:ul compact.
:li.<namestring>
:li.<namestring> = <namestring>
:eul.
:p.where a <namestring> is any string of characters, optionally enclosed
in quotation marks.  The first alternative - the one without the '='
sign - would not normally be used in specifying the root directory,
but it is the normal form for specifying a subdirectory (see below).
The second alternative specifies a symbolic link.  In that case the
<namestring> before the '=' sign is the directory name as seen by the
ftp client, and the <namestring> after the '=' sign is a full path name,
starting with a drive letter.
:p.
At the root level, the directory name is not seen by the user in any
case, and the full path name is very often a null string, in order to
specify a pseudo-directory.  Thus, a very common form of specification
for the root-level directory is simply
:p.
       ""=""
:p.
A <directory descriptor> gives the permissions for this home directory
and all of its subdirectories.  It has the form

:p.
       <code> <subdirectory info>

:p.
Both of these are optional.  The <code> can be any combination of

:dl compact break=none.
:dt.   V+
:dd.Directory visible
:dt.   V-
:dd.Directory invisible
:dt.   R+
:dd.Allow reads (i.e. downloads) of files in this directory
:dt.   R-
:dd.Deny read
:dt.   W+
:dd.Allow write
:dt.   W-
:dd.Deny write
:dt.   D+
:dd.Allow delete
:dt.   D-
:dd.Deny delete
:dt.   N+
:dd.Allow rename
:dt.   N-
:dd.Deny rename
:edl.

:p.
The permission codes are always to be interpreted relative to
the parent directory's permission code.  That is, a directory has
the same permissions as its parent, unless explicitly changed
by adding and&slash.or deleting permissions.

:p.
(For the root directory, the default permissions are: visible,
read, no write, no delete, no rename.)

:p.
The <subdirectory info> is defined recursively.  It has the form

:p.
       (  <item> ,  <item> ,  ...  , <item> )
:p.
i.e. it is a comma-separated list of items, surrounded by
parentheses.  Each <item> has the form
:p.
       <directory name>  <directory descriptor>
:p.
That is, it follows exactly the same rules as described above
for the root directory.  The recursive nature of the rules means,
of course, that the <directory&rbl.descriptor> for any
subdirectory may contain specifications of further subdirectories,
down to any desired level.
:p.
If this sounds complicated, take a look at the supplied *.PRM
files, and you'll soon pick up the pattern.

:note.You don't have to list all of the subdirectories - only the
ones whose permissions are different from the permissions of the
parent directory.

:p.
:hp2.Example 1:ehp2.
:p.Suppose you want the user "anonymous" to have read access to
the directory C&colon.\users\pub; read and write access to
C&colon.\users\pub\upload; no access at all to C&colon.\users\pub\private;
and read access to all other subdirectories
of C&colon.\users\pub.  Then the permission file ANONYMOUS.PRM should
have the following contents.
:xmp.
    G                         % user category = guest
    @                         % password = e-mail address
    10                        % user limit
    2000                      % speed limit
    ""                        % no real name recorded
    (*This is a guest account*)   % notes to store in INI file
    pub="C&colon./users/pub/" V+R+  % user's root directory
      ( upload W+,            % allow write access to upload directory
        private V-R- )        % deny all access to private directory
:exmp.

:p.
:hp2.Example 2:ehp2.
:p.Suppose you want the user "user1" to have read and write access to
drive A&colon.; read-only access to directory C&colon.\users\pub and all of
its subdirectories; read and write access to D&colon.\abc and all of
its subdirectories; and read and delete access to E&colon.\Apps.
To make the example more interesting, let us suppose that we want to
make the directory on E&colon. look like a subdirectory of
D&colon.\abc\def.  You can do this by creating a permission file
USER1.PRM with the following contents.
:xmp.
    U                         % normal user
    secret                    % password
    2                         % user limit
    6000                      % speed limit
    "Bart MacHomer"           % real name
    (*Created April 1999*)    % notes to store in INI file
    ""="" W+                  % root directory is a pseudo-directory
       ("A"="A:",
        "pub"="C&colon./users/pub" W-,
        "dir1"="D&colon./abc"
          (def
            ("apps"="E&colon./Apps" W-D+)
          )
       )
:exmp.

:p.
Remark: FtpServer considers the forward slash (/) and backslash (\) to
be equivalent in filename strings.
:p.
:hp2.Warning about potential syntax errors:ehp2.
:p.
The software that parses a permission file tries to be
as non-rigid as possible; for example, it does not insist
that the characters in passwords, directory names, etc.
be alphanumeric characters.  This flexibility comes at a
price: you can write permission files that seem to be
correct, but which are syntactically ambiguous.
:p.
To avoid problems, it is a good idea always to enclose
directory and file names in quotation marks.
:p.
:hp2.Converting from older formats:ehp2.
:p.The rules for specifying directories, as described on this page, were
introduced in version 0.71 of FtpServer.  For version 0.70 and earlier,
the rules were slightly different.  Both the old and new formats will be
supported in versions 0.71 up to 0.80, but after that the old format will
no longer be accepted.  Thus, you should convert all your old PRM files
to the new format.
:p.
The conversion can be done with the LoadPRM utility, which can read
PRM files in either the old or new format but will store the data (in FTPD.INI)
in the new format.  A quick way to convert all your PRM files into the
new format is to execute the two commands
:xmp.
        loadprm *
        storeprm *
:exmp.
:p.Note that this will strip all comments out of the files.  If you want to
keep the comments, you will have to do some manual editing.

.***********************************
.*   MANAGER PRIVILEGES
.***********************************

:h2 id=manager.Manager privileges
:hp2.Manager privileges:ehp2.
:p.
A manager account is the same as a normal user account, except that
a manager has a few extra privileges.
:ul.
:li.Managers can see system and hidden files in directory listings;
other users cannot.
:li.Managers are allowed to use the :link reftype=hd refid=SITE.SITE MNGR:elink. commands.
:eul.

.***********************************
.*   THE PMSETUP UTILITY
.***********************************

:h1 id=PMconfiguser.The PMSetup utility
:hp2.The PMSetup utility:ehp2.

:p.When you run PMSetup, you get a notebook that controls all of the
configuration details of FtpServer.  The parameter settings are stored
in a file FTPD.INI.  The server reads its
INI file as it starts up, so any changes you make will not take effect until
the next time you start the server.

:p.
Exception: the user permissions are not read until a user attempts
to log in.  You may therefore alter the user permissions while the server
is running, and the alterations will affect the next user to log in.

:p.The opening screen of PMSetup gives you a choice between local and
remote configuration.  (The remote case is described in a
:link reftype=hd refid=remoteconfig.later section:elink..)
If you want to bypass this choice, you can use the command
:xmp.         pmsetup -G

:exmp.
and this will skip the opening dialogue and continue as if you had
pressed the "GO" button.  In this case, the local/remote option remains
as it was the last time you ran PMSetup.

:p.The setup details are divided into four groups.

:ul compact.
:li.:link reftype=hd refid=PMconfiguser1.Basic:elink.
:li.:link reftype=hd refid=PMconfiguser1a.Options:elink.
:li.:link reftype=hd refid=PMsecurity.Security:elink.
:li.:link reftype=hd refid=PMconfiguser2.Users:elink.
:eul.

.***********************************
.*   THE BASIC PMSETUP SETTINGS
.***********************************

:h2 id=PMconfiguser1.The basic server settings
:hp2.The basic server settings:ehp2.
:p.
The first part of the "Basic" page controls the following parameters.

:dl break=all.
:dt.Port number
:dd.This is the tcp port on which FtpServer listens for new connections.
Unless you are doing something nonstandard (for example, running two ftp servers
on the same machine) this should always be 21.
:dt.Maximum number of users
:dd.This specifies how many clients will be allowed to use the server simultaneously.
I usually set this to 10.  Higher values will, of course, increase the potential
load on your processor.
:p.Note: this is a global maximum.  You may also set this to a very high value, and then
control the number of users on a per-username basis.
:dt.Maximum number of guest users
:dd.This typically should be slightly less than the number specified for the maximum
number of users, to reserve one or more login slots for the system manager and other
non-guest users.
:dt.Free space threshold (MB)
:dd.This specifies the amount of free space that must be available on a drive for
uploads to be enabled.  If the free space, in megabytes, falls below this level then
uploads will be disabled.
:dt.Timeout (seconds)
:dd.The time that a client session may remain idle before the user is evicted.
You will find that many ftp clients, especially web browsers, don't log out properly,
so their sessions have to be killed with the timeout mechanism.
:edl.

:p.:hp2.Transfer logging:ehp2.
:p.You can ask the server to
produce a user log (FTPUSERS.LOG) and/or a log in common log format (COMMON.LOG).
(If you delete these files, they will be re-created.  It would be a good idea to
delete them periodically, or move them to an archive, so that they do not grow
too large.)  The user log produces a list of files that have been uploaded
or downloaded.  The common log contains similar information, but in a format
used by many http servers.  This allows you to use log analysis tools that
have been designed for web servers.

:p.You can select how much detail gets written to these two logs.

:dl break=all.
:dt.No transfer logging
:dd.This effectively disables the transfer logging.
:dt.Log successful transfers
:dd.The log includes entries for all uploads and downloads that completed
successfully, but the operations that failed are not logged.
:dt.Log all file transfers
:dd.With this option, you get log entries even for transfers that were
aborted before they completed.
:dt.Log all clients
:dd.This creates user log entries for all users, even those who didn't transfer any files.
:edl.

:p.:hp2.Transaction logging:ehp2.
:p.The transaction log is a much more detailed log.  You can choose to send it
to the screen, or to a disk file, or both.
The disk file is called FTPTRANS.LOG, and it is updated approximately once every
15 minutes if this feature is enabled.
:p.Warning: Transaction logging can create very large log files.  I suggest that
you don't enable transaction logging to a file unless you're trying to track down a problem.
Logging to the screen, on the other hand, will give you some idea of how busy
the server is.

.***********************************
.*   MORE SETUP OPTIONS (PM)
.***********************************

:h2 id=PMconfiguser1a.Options
:hp2.Options:ehp2.

:p.In the present version, the only option on this page is a choice between
binding to all local interfaces, or binding to a specific IP address.  If you
choose the "specific address", you should enter an IP address in the
standard format (four decimal numbers, separated by dots).

:p.For most applications, the best choice is "all interfaces".  With this
choice the server listen for ftp requests on all your network interfaces,
even if your machine has multiple IP addresses.

:p.The "specific address" option is for the case where you have two or more
IP addresses, but you want the server to respond to only one of them.  In
this case you could, if you wished, run several independent ftp servers on
the same machine, each responding to a different address.

:p.(Another way to run several ftp servers is to make each one listen on
a different port.  That's a less attractive option, however, because most
ftp clients expect to find the server on the standard port 21.)

:p.If you do run multiple copies of ftpd.exe, put each of them in a
different directory.  This is because ftpd.exe expects to find its INI file
in the same directory as the executable, and for multiple copies you
would want to have a different INI file for each one.

.***********************************
.*   SECURITY SETTINGS (PM)
.***********************************

:h2 id=PMsecurity.Security settings
:hp2.Security settings:ehp2.
:p.
The first item on the "Security" page is a field called
"Max connections from same address".  This specifies the
maximum number of users that can be connected simultaneously from the same IP
address.  It is primarily a protection against users who hog the server by
logging in more than once.  I usually set it to 2 or 3.  If you do not
want this protection, set the number to a very large value.

:p.:hp2.Restricting access to certain IP addresses:ehp2.
:p.
The large box on this page defines a filter for IP addresses.  This is for
putting restrictions on which remote hosts are allowed to log into the server.
(If you don't need this feature, just use a single "Allow all" entry.)  When a
client tries to connect, the server searches this list, starting at the
beginning, for the first entry that matches the client's IP address.  There will
always be a match, because the last entry is always an "everything else" entry.
The allow/refuse flag on the matching entry is used to decide whether the
client should be allowed to connect.  If the flag value is "refuse", the
connection attempt is rejected.

:p.Each list entry has an allow/refuse flag and two numeric components, an address
and a mask.  Each of these is expressed in "dotted quad" notation: a four-byte value
where each byte has its value
written out in decimal. (This is a standard convention for writing IP addresses.)
A client address matches an entry if
:p.       (client IP address) :hp2.AND:ehp2. mask = (IP address in the list)
:p.where :hp2.AND:ehp2. means the bit-by-bit Boolean "logical AND" operation.
:p.Note, in particular, the two extreme cases:
:ul.
:li.If the mask is 255.255.255.255, then we are specifying an exact match between
the client IP address and the address in the list.
:li.If the mask were 0.0.0.0, then any IP address would match this entry. The last
entry in the list is implicitly of this form, to specify an "everything else" condition.
:eul.
:p.
:p.:hp2.Example 1.:ehp2. If you want to lock out all machines with IP address in
the range 123.45.67.0 to 123.45.67.127, your list would look like this.
:sl compact.
:li.Refuse   123.45.67.0   255.255.255.128
:li.Allow    all others
:esl.

:p.:hp2.Example 2.:ehp2. Suppose you want to give access only to your local network,
which has addresses in the range 123.45.66.0 to 123.45.67.255.  You can do this as
follows.
:sl compact.
:li.Allow    123.45.66.0   255.255.254.0
:li.Refuse   all others
:esl.

:p.:hp2.Example 3.:ehp2. To allow access to 123.45.67.89, but to lock out everyone
else in 123.45.67.*, you can use the rules
:sl compact.
:li.Allow    123.45.67.89   255.255.255.255
:li.Refuse   123.45.67.0    255.255.255.0
:li.Allow    all others
:esl.

:p.Notice that the list always finishes with an "all others" entry.  The PMSetup
program will allow you to change the allow/refuse flag on this final entry, but
it will not allow you to delete it.

.***********************************
.*   MODIFYING USER PERMISSIONS (PM)
.***********************************

:h2 id=PMconfiguser2.Adding and removing users
:hp2.Adding and removing users:ehp2.
:p.
The "Users" page controls who is allowed to log in to the server.
:p.
:hp2.Deleting a user:ehp2.
:p.
Select the entry you want to delete, then click on the "Delete" button.
:p.
:hp2.Adding a new user:ehp2.
:p.
Click on the "Add" button, and then proceed as for :link reftype=hd refid=PMedituser.Editing a user's permissions:elink..
:p.
:hp2.Cloning an existing user:ehp2.
:p.
First select the user whose details you want to duplicate, then click on the "Clone"
button, and then proceed as for :link reftype=hd refid=PMedituser.Editing a user's permissions:elink..
This is the same as adding a new user, except that the new user's attributes are copied from
those for an existing user.
:p.
:hp2.Editing the permissions of an existing user:ehp2.
:p.
Select the user name, click on the "Edit" button, and then follow the instructions
in the section :link reftype=hd refid=PMedituser.Editing a user's permissions:elink..
Alternatively, just double-click on the user name.

.***********************************
.*   EDITING A USER'S PERMISSIONS (PM)
.***********************************

:h2 id=PMedituser.Editing a user's permissions
:hp2.Editing a user's permissions:ehp2.
:p.
You get to this point by running the PMSetup program and choosing any of the
options (except "Delete") on the "Users" notebook page.
:p.
The first item in the resulting dialogue is a client category - NoPassword, Guest, User,
or Manager.  The categories are explained in the
:link reftype=hd refid=UPconcepts.General concepts:elink. section.

:p.Below this you have several entry fields.
:dl break=all.
:dt.    Speed limit
:dd.An approximate upper bound on the file transfer speed for this user,
in case you want to restrict how much of the processor power this user
can get.  If you don't want such a control, just make this a large
number.
:dt.    User limit
:dd.The maximum number of simultaneous sessions with this user name.
(If you don't want such a control, just make this number larger than the
global user limit.)
:dt.    Real name
:dd.This field is purely for your own records.  It is not used by FtpServer.
:dt.    Username
:dd.The name that the user will use when logging in.
:dt.    Password
:dd.This user's password.  Note that this entry field is disabled if the
user category is "NoPassword" or "Guest".
:dt.    Notes
:dd.Use this for any purpose you wish.
:edl.

:p.Warning: If you change the user name, the permissions for the previous
user name will be deleted.  You should also avoid using a user name
that is the same as for some other user.

:p.The small window near the bottom of this dialogue gives a summary - but not a complete
description - of the top level of this user's directory tree.  To see
the complete details, and to modify those details, click on the "Edit directories"
button or double-click on the summary window.

:p.Instructions for modifying the user's tree are on the
:link reftype=hd refid=PMedittree.next page:elink. of this document.

:p.Note that none of your changes will be stored until you have confirmed
them with the "OK" button.  To leave this dialogue without making any
changes, use the "Cancel" button.

:p.:hp2.Converting from older formats:ehp2.
:p.Some details of the format of user information in FTPD.INI were
changed in version 0.71 of FtpServer.  Both the old and new formats are
supported in versions 0.71 up to 0.80, but support for the old format is
gradually being withdrawn.  Thus, you should convert all your user permission
data to the new format.
:p.
The PMSetup program will automatically perform the conversion each time
you edit a user.  If you have a small number of users defined, then the
way to do the conversion is to run PMSetup and edit each user (without
necessarily making any changes).
:p.
If you have a large number of users, it is easier to use the LoadPRM
program to do the conversion.  This can be done with the following
sequence of commands.
:xmp.
        storeprm *
        loadprm *
        del *.prm
:exmp.
:p.(The final deletion can be omitted if you prefer to keep a copy of
the PRM files.  If ever your INI file is damaged or destroyed, you can
use the LoadPRM utility to re-load user data from PRM files.)

.***********************************
.*   EDITING A DIRECTORY TREE (PM)
.***********************************

:h2 id=PMedittree.Editing a directory tree
:hp2.Editing a directory tree:ehp2.

:p.You get to this point while
:link reftype=hd refid=PMedituser.editing a user's permissions:elink..
The picture that is shown on the screen is a representation of the
directory tree for this user.  Initially it will show enough subtrees
to reveal all symbolic links, and all entries for which the user's
permissions are different from the parent node's permissions.  (For
a new user, there will be nothing except an empty root node.)  In
the course of editing this tree you can expand or collapse nodes to
control how much detail is shown on the screen.
:p.
The top of the screen shows both a physical path and a virtual path
for the current entry.  The physical path is the true location of
the file or directory on your disk.  The virtual path is the path
as the client sees it.
:p.
Each entry describes one directory or file.  At the left of each line,
you will see a code consisting of one or more of the letters "VRWDN".
The meanings of these user permission codes are explained in the
:link reftype=hd refid=UPconcepts.General concepts:elink.
section.
:p.
To the right of the VRWDN code, some entries have one or more of the
following codes.
:dl.
:dt.   +
:dd.This directory is collapsed, i.e. its subdirectories (if any)
are not at present displayed on the screen.
:dt.   *
:dd.This entry is a symbolic link or pseudo-directory.
:dt.   #
:dd.This entry describes a file rather than a directory.
:dt.   ?
:dd.There is no file or directory on the disk that matches this entry.
This might mean that you have made an error in the name; alternatively,
it might mean that you are specifying a directory or file that you
haven't yet created.
:edl.
:p.
To edit the tree, you have the following options.
:ul.
:li.You can navigate through the list of directories with mouse clicks, with the
cursor up/down keys, and also with the Home, End, PageUp, and
PageDown keys.
:li.To change a permission, type one of the characters V, R, W, D, or N, or
click on the buttons with these labels.
This toggles the state of the corresponding permission code for the
currently selected directory.
:li.The "-" key or button collapses a directory by removing its subdirectories
from the screen listing. (The subdirectories are still there, and are still affected
by things like the "Propagate" option.  They simply aren't shown on the screen.)
To get the subdirectories back, type the "+" key or button.
:li.The "Add child" button adds a new child node under the current node.
:li.The "Edit" button allows you to edit the details for the current entry.
(Instructions for doing this are given later in this page.)  You can also
edit by double-clicking on the entry.
This option is disabled if the current entry describes a file or directory
that is physically present on the disk.
:li.The "Delete" button deletes the current node and all of its subtrees.
This option is disabled if the current entry describes a file or directory
that is physically present on the disk.
:li.The "Inherit" button gives the selected entry a copy of the
current permissions of its parent.
:li.The "Propagate" button copies the permissions of the currently selected directory
to all of its subdirectories. Use this if you want to change an entire
subtree in one operation.
:eul.
:p.
When you've finished editing the permissions, click on the "Done" button
to go back to the previous dialogue.  If you've made a mistake, you still have
the option of using the "Cancel" button on that previous dialogue.

:p.:hp2.Modifying the details for one entry:ehp2.

:p.The "Edit" and "Add child" options will bring up a screen window that
describes one tree node. The radio buttons at the top let you specify
one of three kinds of node.
:dl break=all.
:dt.    subdirectory or file
:dd.This refers to a subdirectory or file that is contained within the
parent directory.  The "Name" field gives the name of the subdirectory or file.
Note that you cannot choose this option for the top-level directory,
because the top-level directory has no parent.
:dt.    link
:dd.This creates a symbolic link.  In the "Name" field, put a name of
your own choice; this will be the name of the directory as seen by the
client.  In the "Path" field, put the full physical path (including
drive letter) for this directory or file.
:dt.    pseudo-directory
:dd.This is a special case of a link, where there is no physical path.
A pseudo-directory should contain only links and other pseudo-directories.
:edl.

:p.:hp2.Setting permissions for individual files:ehp2.

:p.The access permissions used by FtpServer are normally given to directories,
and the permissions for a directory apply to all non-directory files in that
directory.  However, PMSetup will let you define an entry for a non-directory
file, and give it access permissions.  (It would be tedious to do this for
every file, but this feature can be used for special cases.)  This gives you
a method for making the permissions for a file different from the permissions
of the directory that it is in.

:p.If you create a link or pseudo-directory with the same name as a real
file or subdirectory, your link will take precedence over the real name.
In effect, the real file or subdirectory will become invisible as far as
the user is concerned.

.*************************************************************************
.*   REMOTE CONFIGURATION
.***********************************

:h1 id=remoteconfig.Remote configuration

:p.PMSetup also offers the option of remote setup.  That
is, you can run PMSetup on one computer and use it to configure a copy
of FtpServer that is installed on a different computer.  To do this, you have
to have the freeware utility INIServe running on the same computer as
FtpServer.  You can find INIServe at http&colon.&slash.&slash.eepjm.newcastle.edu.au&slash.os2.

:p.If you select the "Remote" radio button after starting PMSetup, a "Setup"
pushbutton is enabled.  Clicking on this gives you four fields to fill in&colon.

:dl break=all.
:dt.    Hostname
:dd.The name (or IP address) of the machine on which FtpServer is running.
:dt.    INIServe port
:dd.The TCP port that INIServe has been configured to listen on.  The default
value is 8000.
:dt.    INIServe password
:dd.The password needed to log in to your copy of INIServe.
:dt.    FtpServer directory
:dd.The full path name of the directory, on the remote machine, where FtpServer
is installed.
:edl.

:p.When you close the Setup window, you can click on the "GO" button to connect
to the remote machine.  If this gives a "failed to connect" or similar error
message, it probably means that you don't have INIServe running on the
remote machine, or that you've done something like specifying an incorrect
port number.

:p.Once the connection is made, the operation is the same as for the
case of local configuration.

.***********************************
.*   THE VIOSETUP UTILITY
.***********************************

:h1 id=configuser.The VIOSetup utility
:hp2.The VIOSetup utility:ehp2.
:p.
The program VIOSETUP.EXE has three functions:
:ul compact.
:li.To set the parameters that the server will use when it starts up.
:li.To place controls on which IP addresses may access the server.
:li.To create and edit user permissions.
:eul.

:p.
Use the F4 and F5 function keys on the keyboard to toggle among these functions.

:p.
The parameter settings are stored in a file FTPD.INI.  The server reads its
INI file as it starts up, so any changes you make will not take effect until
the next time you start the server.
:p.
Exception: the user permissions are not read until a user attempts
to log in.  You may therefore alter the user permissions while the server
is running, and the alterations will affect the next user to log in.

:p.
Now read

:ul compact.
:li.:link reftype=hd refid=configuser1.Setting the server parameters:elink.
:li.:link reftype=hd refid=security.Security settings:elink.
:li.:link reftype=hd refid=configuser1a.More setup options:elink.
:li.:link reftype=hd refid=configuser2.Modifying user permissions:elink.
:eul.

.***********************************
.*   SETTING THE SERVER PARAMETERS
.***********************************

:h2 id=configuser1.Setting the server parameters
:hp2.Setting the server parameters:ehp2.
:p.
When you run VIOSETUP.EXE, you get a screen showing the following items.

:dl break=all.
:dt.Server port
:dd.Unless you are doing something nonstandard (for example, running two ftp servers
on the same machine) this should always be 21.
:dt.Maximum number of users
:dd.This specifies how many clients will be allowed to use the server simultaneously.
I usually set this to 10.  Higher values will, of course, increase the load on your
processor.
:p.Note: this is a global maximum.  You may also set this to a high value, and then
control the number of users on a per-username basis.
:dt.Maximum number of guest users
:dd.This typically should be slightly less than the number specified for the maximum
number of users, to reserve one or more login slots for the system manager and other
non-guest users.
:dt.Free space threshold (MB)
:dd.This specifies the amount of free space that must be available on a drive for
uploads to be enabled.  If the free space, in megabytes, falls below this level then
uploads will be disabled.
:dt.Timeout (seconds)
:dd.The time that a client session may remain idle before the user is evicted.
You will find that many ftp clients, especially web browsers, don't log out properly,
so their sessions have to be killed with the timeout mechanism.
:dt.Transfer log format
:dd.In addition to the detailed transaction log, you can ask the server to
produce a user log (FTPUSERS.LOG) and/or a log in common log format (COMMON.LOG).
(If you delete these files, they will be re-created.  It would be a good idea to
delete them periodically, or move them to an archive, so that they do not grow
too large.)  The user log produces a list of files that have been uploaded
or downloaded.  The common log contains similar information, but in a format
used by many http servers.  This allows you to use log analysis tools that
have been designed for web servers.
:dt.Transfer logging level
:dd.The logging level controls how much detail gets written to the user log.
:dl.
:dt.     0
:dd.No logging
:dt.     1
:dd.Log successful file transfers
:dt.     2
:dd.Log successful and unsuccessful file transfers
:dt.     3
:dd.Log all users, even those who didn't transfer any files
:edl.
:dt.Transaction logging
:dd.The transaction log is a much more detailed log.  You can choose to send it
to the screen, or to a disk file, or both.
The disk file is called FTPTRANS.LOG, and it is updated approximately once every
15 minutes if this feature is enabled.
:p.Warning: Transaction logging can create very large log files.  I suggest that
you don't enable this feature unless you're trying to track down a problem.
:edl.

:p.
To modify any of these parameters, use the up/down arrow keys to get to the
desired item, then type in the new value.  (The backspace, Insert, Delete, Home,
and End keys
will also work during editing.)  The new value is accepted when you type the
Enter key, or when you use the function keys to go to another field.
:p.
When you've finished editing, use the Esc key to exit from the VIOSetup program, or
type F5 to get to the :link reftype=hd refid=security.security screen:elink..

.***********************************
.*   SECURITY SETTINGS
.***********************************

:h2 id=security.Security settings
:hp2.Security settings:ehp2.
:p.
To modify the security settings, run VIOSETUP.EXE, and then type the F5 function key
on the keyboard to get to the "Security" screen page.
:p.At the top of this page there is a field called the "Same IP limit".  This specifies the
maximum number of users that can be connected simultaneously from the same IP
address.  It is primarily a protection against users who hog the server by
logging in more than once.
:p.Set this value to whatever you want, finishing with the "Enter" or "cursor down"
key to confirm the new value.  The "cursor down" key will take you to the IP address
controls, as described below.  When you've finished setting the values on this
page, type F5 to get to
:link reftype=hd refid=configuser1a.more setup options:elink..
:p.
:hp2.Restricting access to certain IP addresses:ehp2.
:p.
The large box on this screen page defines a filter for IP addresses.  This is for
putting restrictions on which remote hosts are allowed to log into the server.
(If you don't need this feature, just use a single "Allow all" entry.)  When a
client tries to connect, the server searches this list, starting at the
beginning, for the first entry that matches the client's IP address.  There will
always be a match, because the last entry is always an "everything else" entry.
The allow/refuse flag on the matching entry is used to decide whether the
client should be allowed to connect.  If the flag value is "refuse", the
connection attempt is rejected.

:p.Each list entry has an allow/refuse flag and two numeric components, an address
and a mask.  Each of these is expressed in "dotted quad" notation: a four-byte value
where each byte has its value
written out in decimal. (This is a standard convention for writing IP addresses.)
A client address matches an entry if
:p.       (client IP address) :hp2.AND:ehp2. mask = (IP address in the list)
:p.where :hp2.AND:ehp2. means the bit-by-bit Boolean "logical AND" operation.
:p.Note, in particular, the two extreme cases:
:ul.
:li.If the mask is 255.255.255.255, then we are specifying an exact match between
the client IP address and the address in the list.
:li.If the mask is 0.0.0.0, then any IP address will match this entry. You can use
this to specify an "everything else" condition.
:eul.
:p.
:p.:hp2.Example 1.:ehp2. If you want to lock out all machines with IP address in
the range 123.45.67.0 to 123.45.67.127, your list would look like this.
:sl compact.
:li.Refuse   123.45.67.0   255.255.255.128
:li.Allow    all others
:esl.

:p.:hp2.Example 2.:ehp2. Suppose you want to give access only to your local network,
which has addresses in the range 123.45.66.0 to 123.45.67.255.  You can do this as
follows.
:sl compact.
:li.Allow    123.45.66.0   255.255.254.0
:li.Refuse   all others
:esl.

:p.:hp2.Example 3.:ehp2. To allow access to 123.45.67.89, but to lock out everyone
else in 123.45.67.*, you can use the rules
:sl compact.
:li.Allow    123.45.67.89   255.255.255.255
:li.Refuse   123.45.67.0    255.255.255.0
:li.Allow    all others
:esl.

:p.Notice that the list always finishes with an "all others" entry.  The VIOSetup
program will allow you to change the allow/refuse flag on this final entry, but
it will not allow you to delete it.

.***********************************
.*   MORE VIOSETUP OPTIONS
.***********************************

:h2 id=configuser1a.More setup options
:hp2.More setup options:ehp2.

:p.In the present version, the only option on this page is a choice between
binding to all interfaces, or binding to a specific IP address.  Use the
cursor left/right keys to highlight the option you want.  If you highlight
"specific address", you will be given the opportunity to edit the address.
After editing it, use the Enter key or a cursor up/down key to confirm that
you've finished editing.  When you've finished setting the values on this
page, type F5 to get to the
:link reftype=hd refid=configuser2.user permission editor:elink..

:p.For most applications, the best choice is "all interfaces".  With this
choice the server listen for ftp requests on all your network interfaces,
even if your machine has multiple IP addresses.

:p.The "specific address" option is for the case where you have two or more
IP addresses, but you want the server to respond to only one of them.  In
this case you could, if you wished, run several independent ftp servers on
the same machine, each responding to a different address.

:p.(Another way to run several ftp servers is to make each one listen on
a different port.  That's a less attractive option, however, because most
ftp clients expect to find the server on the standard port 21.)

:p.If you do run multiple copies of ftpd.exe, put each of them in a
different directory.  This is because ftpd.exe expects to find its INI file
in the same directory as the executable, and for multiple copies you
would want to have a different INI file for each one.

.***********************************
.*   MODIFYING USER PERMISSIONS
.***********************************

:h2 id=configuser2.Modifying user permissions
:hp2.Modifying user permissions:ehp2.
:p.
To modify the user permissions, run VIOSETUP.EXE, and then type the F4 function key
- or type F5 twice - to get to the "Users" screen page.  This will give you a list of
all existing users.  The first time you run the program, the list will probably
be empty.
:p.
From this screen, you can add, delete, or modify users.  When you've finished,
use the F4 or F5 function key to get to the other setup screens, or type X to
exit from the VIOSetup program.
:p.
:hp2.Deleting a user:ehp2.
:p.
Use the up/down arrow keys to get to the user you want to delete, and type
the Del (delete) key.
:p.
:hp2.Adding a new user:ehp2.
:p.
Type A, and then proceed as for :link reftype=hd refid=edituser.Editing a user's permissions:elink..
:p.
:hp2.Cloning an existing user:ehp2.
:p.
Type C, and then proceed as for :link reftype=hd refid=edituser.Editing a user's permissions:elink..
This is the same as adding a new user, except that the new user's attributes are copied from
those for the user that was selected when the C command was typed.
:p.
:hp2.Editing the permissions of an existing user:ehp2.
:p.
Type E, and then follow the instructions in the section :link reftype=hd refid=edituser.Editing a user's permissions:elink..

.***********************************
.*   EDITING A USER'S PERMISSIONS
.***********************************

:h2 id=edituser.Editing a user's permissions
:hp2.Editing a user's permissions:ehp2.
:p.
You get to this point by running the VIOSetup program, typing F4 or F5 to get to
the user editor, and then using one of the "A" (add user) or "E" (edit user)
options.
:p.
By now you should have six fields near the top of the screen.
:dl break=all.
:dt.    User name
:dd.The name that the user will use when logging in.
:dt.    Real name
:dd.This field is not used by FtpServer; it is purely for your own records.
:dt.    Category
:dd.One of User, Guest, NoPassword, or Manager.
:dt.    Password
:dd.This user's password.
:dt.    User limit
:dd.The maximum number of simultaneous sessions with this user name.
(If you don't want such a control, just make this number larger than the
global user limit.)
:dt.    Speed limit
:dd.An approximate upper bound on the file transfer speed for this user,
in case you want to restrict how much of the processor power this user
can get.  If you don't want such a control, just make this a large
number.
:edl.
:p.
Use the up/down arrow keys to get to the field you want to edit, and
then modify it as necessary.  For the "Category" field, use the
left/right arrow keys to select a category.

:p.Warning: If you change the user name, the permissions for the previous
user name will be deleted.  You should also avoid using a user name
that is the same as for some other user.

:p.The bottom half of this screen gives a summary - but not a complete
description - of the top level of this user's directory tree.  To see
the complete details, and to modify those details, use the "cursor down"
key to move to this part of the screen.

:p.Instructions for modifying the user's tree are on the
:link reftype=hd refid=edittree.next page:elink. of this document.

:p.:hp2.Converting from older formats:ehp2.
:p.Some details of the format of user information in FTPD.INI were
changed in version 0.71 of FtpServer.  Both the old and new formats are
supported in versions 0.71 up to 0.80, but in later versions the old format will
probably no longer be accepted.  Thus, you should convert all your user permission
data to the new format.
:p.
The VIOSetup program will automatically perform the conversion each time
you edit a user.  If you have a small number of users defined, then the
way to do the conversion is to run VIOSetup and edit each user (without
necessarily making any changes).
:p.
If you have a large number of users, it is easier to use the LoadPRM
program to do the conversion.  This can be done with the following
sequence of commands.
:xmp.
        storeprm *
        loadprm *
        del *.prm
:exmp.
:p.(The final deletion can be omitted if you prefer to keep a copy of
the PRM files.  If ever your INI file is damaged or destroyed, you can
use the LoadPRM utility to re-load user data from PRM files.)

.***********************************
.*   EDITING A DIRECTORY TREE
.***********************************

:h2 id=edittree.Editing a directory tree
:hp2.Editing a directory tree:ehp2.

:p.You get to this point while
:link reftype=hd refid=edituser.editing a user's permissions:elink..
The picture that is shown on the screen is a representation of the
directory tree for this user.  Initially it will show enough subtrees
to reveal all symbolic links, and all entries for which the user's
permissions are different from the parent node's permissions.  (For
a new user, there will be nothing except an empty root node.)  In
the course of editing this tree you can expand or collapse nodes to
control how much detail is shown on the screen.
:p.
The top of the screen shows both a physical path and a virtual path
for the current entry.  The physical path is the true location of
the file or directory on your disk.  The virtual path is the path
as the client sees it.
:p.
Each entry describes one directory or file.  At the left of each line,
you will see a code consisting of one or more of the letters "VRWDN".
The meanings of these user permission codes are explained in the
:link reftype=hd refid=UPconcepts.General concepts:elink.
section.
:p.
To the right of the VRWDN code, some entries have one or more of the
following codes.
:dl.
:dt.   +
:dd.This directory is collapsed, i.e. its subdirectories (if any)
are not at present displayed on the screen.
:dt.   *
:dd.This entry is a symbolic link.
:dt.   #
:dd.This entry describes a file rather than a directory.
:dt.   ?
:dd.There is no file or directory on the disk that matches this entry.
This might mean that you have made an error in the name; alternatively,
it might mean that you are specifying a directory or file that you
haven't yet created.
:edl.
:p.
To edit the tree, you have the following options.
:ul.
:li.You can navigate through the list of directories with the
cursor up/down keys, and also with the Home, End, PageUp, and
PageDown keys.
:li.To change a permission, type one of the characters V, R, W, or D.
This toggles the state of the corresponding permission code for the
currently selected directory.
:li.Typing the "I" key gives the selected entry a copy of the
current permissions of its parent.
:li.The "P" key copies the permissions of the currently selected directory
to all of its subdirectories. Use this if you want to change an entire
subtree in one operation.
:li.The "-" key collapses a directory by removing its subdirectories
from the screen listing. (But these subdirectories will still be affected
by the "P" option.) To get the subdirectories back, type the "+" key.
:li.The "A" key adds a new child node under the current node.
:li.The "Del" key deletes the current node and all of its subtrees.
This option is disabled if the current entry describes a file or directory
that is physically present on the disk.
:li.The "E" key allows you to edit the details for the current entry.
(Instructions for doing this are given later in this page.)
This option is disabled if the current entry describes a file or directory
that is physically present on the disk.
:eul.
:p.
When you've finished editing the permissions, type B to go back to
the previous screen, or X to exit completely from VIOSetup.

:p.:hp2.Modifying the details for one entry:ehp2.

:p.The "E" or "A" command will bring up a screen window with three
details that you can modify.  Use the cursor up/down keys to go from
one field to another.
:ol.
:li.The Name field gives the subdirectory or file name.
:li.The Link field should have value "no" for an ordinary subdirectory
or file, and "yes" for a symbolic link.  Use the cursor left/right keys
to change the value of this field.
:li.The Path is the physical path (including drive letter) for this
directory or file.  You can modify this only if the Link field is set
to "yes".  If you leave the Path blank, you are defining a pseudo-directory.
:eol.
:p.When you have finished editing these details, type the Esc key to
return to the tree.

:p.:hp2.Setting permissions for individual files:ehp2.

:p.The access permissions used by FtpServer are normally given to directories,
and the permissions for a directory apply to all non-directory files in that
directory.  However, VIOSetup will let you define an entry for a non-directory
file, and give it access permissions.  (It would be tedious to do this for
every file, but this feature can be used for special cases.)  This gives you
a method for making the permissions for a file different from the permissions
of the directory that it is in.

.***********************************
.*   RUNNING THE SERVER
.***********************************

:h1.Running the server
:hp2.Running the server:ehp2.
:p.
The server executable is called FTPD.EXE.  You can run this the way you run
any other OS/2 program: from the command-line, by clicking on an icon, from
the Startup folder, etc.  If you're running several server applications, then
the most obvious choice is to put a command to start the server in the
command file \TCPIP\BIN\TCPSTART.CMD.
:p.
Normally the server takes its configurable parameters from the INI file
created by the :link reftype=hd refid=PMconfiguser.setup program:elink..  You may, however,
override these parameters by specifying :link reftype=hd refid=parameters.command-line parameters:elink..
:p.
You also have the options of :link reftype=hd refid=inetd.running the server from inetd:elink.
or :link reftype=hd refid=detached.running the server as a detached program:elink..
:p.
Once the server is running, two keyboard commands are available.
:dl.
:dt.    G
:dd.Gradual shutdown.  No new users are accepted.  The program
will terminate when the existing users have logged off
(or timed out), or when a Q comand is issued.
:dt.    Q
:dd.Quick shutdown.  The program closes down even if there are logged-in users.
:edl.

.***********************************
.*   COMMAND LINE PARAMETERS
.***********************************

:h2 id=parameters.Command line parameters
:hp2.Command line parameters:ehp2.
:p.
Normally you don't need any parameters when invoking FTPD.EXE, because the server
takes its parameters from the INI file.  (And the contents of the INI file are
controlled by the setup program.)  You may, however, override the parameters in
the INI file by giving command-line parameters.
:p.
There are several optional parameters. These all have the form of a letter followed
by a (decimal) number, and they can be given in any order.
:dl.
:dt.   D
:dd.Detailed transaction logging (default 0).
:dl compact.
:dt.         0
:dd.No logging
:dt.         1
:dd.Logging to the disk file FTPTRANS.LOG
:dt.         2
:dd.Logging to the screen
:dt.         3
:dd.Logging to both the screen and the disk file
:edl.

:dt.   F
:dd.Free space threshold (megabytes).  Users can't upload to a
drive that has less than this amount of free space available.
The default is 10.

:dt.   G
:dd.Maximum number of guest users.  If you make this smaller than
the value for M (see below), you effectively reserve some
slots for non-guest users.  The default is M-1.

:dt.   L
:dd.User logging option (default 1).
:dl compact.
:dt.         0
:dd.No logging
:dt.         1
:dd.Logging of successful file transfers
:dt.         2
:dd.Logging of successful and unsuccessful file transfers
:dt.         3
:dd.Logging of all users
:edl.
:p.The log is a text file called FTPUSERS.LOG.  You can edit it
or delete it without doing any harm.

:dt.   M
:dd.Maximum number of simultaneous users.  To limit the number
to 12, for example, use the command
.br
             ftpd m12
.br
The default is 10.

:dt.   P
:dd.The server's port number.  To make the server listen on port 5003,
for example, you start the program with the command
.br
             ftpd p5003
.br
The default port number is 21.

:dt.   T
:dd.Timeout limit, i.e. the time before an inactive user is forcibly
removed.  The value is in seconds, and the default is 900.

:edl.

.***********************************
.*   RUNNING FROM INETD
.***********************************

:h2 id=inetd.Running from inetd
:hp2.Running the server from inetd:ehp2.
:p.
Inetd, which is part of the Warp 4 distribution, is a "listener"
program that can intercept incoming connection attempts, and
start up a server when needed.
:p.
The advantage is that FtpServer doesn't actually get loaded into
main memory until a client wants to connect.  Thus, it might be
a good option if you expect clients to connect only occasionally.
:p.
The disadvantage is that a separate copy of the server is
started for each logged-in user.  This makes inetd a bad choice
if you expect lots of connections.
:p.
If you want to run FtpServer from inetd, the way to do it is
as follows:
:ol.
:li.Ensure that inetd will be run the next time you boot.
The usual way of doing this is to include the line
.br
           start /min inetd
.br
in your TCPSTART.CMD, and to invoke TCPSTART.CMD from
your startup folder.  TCPSTART.CMD may be found in the
directory \tcpip\bin.

:li.Edit the file \mptn\etc\inetd.lst so that it contains the line
.br
     ftp tcp start /C /min d&colon.\Apps2\FtpServer\ftpd.exe
.br
(adjusting the path so that it refers to the directory
where you've installed FtpServer).
:eol.

:note.In earlier releases the inetd users had to use a file called ftpd.cmd.
That command file is now obsolete.
:p.
You may also include parameters on the inetd.lst line
that invokes ftpd.exe, subject to the following conditions:
:ol.
:li.The M parameter is useless, because in this mode of
operation the program is handling exactly one user.
:li.The P parameter, if present, will be ignored.  When
running from inetd, you don't get a choice of ports.
:eol.

:p.In principle you can now start inetd.  In practice I've found
that inetd doesn't release ports reliably, so if you already
have inetd running you'll probably have to re-boot.
:p.
Remark: I'm starting to suspect that inetd adds more overhead
than it saves, so I've reverted to not using it on my own
machine.

.***********************************
.*   RUNNING FTPSERVER DETACHED
.***********************************

:h2 id=detached.Running FtpServer detached
:hp2.Running the server as a detached program:ehp2.

:p.If you want to run the server detached, the appropriate command is
.br
       DETACH FTPD
.br
(with parameters, if desired).  Note that a detached program
does not have any way of doing screen output or keyboard input,
so you can't get any screen messages in this case.  Nor can you use
the keyboard G and Q commands.

:p.Although you can't shut down the server from the keyboard in this
case, you can still shut it down by using the
:link reftype=hd refid=SITE.SITE MNGR:elink. commands.

.***********************************
.*   WELCOME MESSAGES
.***********************************

:h2 id=welcome.Welcome messages
:hp2.Welcome messages:ehp2.

:p.If you want to give a message to users when they log in, put a
plain text file called WELCOME.MSG or WELCOME0.MSG in the
same directory as ftpd.exe.
:ul compact.
:li.WELCOME0.MSG, if present, is displayed to the user when the initial connection
is made.
:li.WELCOME.MSG, if present, is displayed to the user after the username and
password have been accepted.
:eul.
:p.You can use both of these options together, if you wish, but it would
probably be less confusing to the users if you had only one message.

:p.You can also put a text file called DIR.MSG in any user directory.
Users will get this message the first time they go to that directory.

:p.There is a limited form of macro expansion available in these message
files.  The following macros may be included.
:dl break=fit.
:dt.    %i"filename"
:dd.Includes the contents of the given file in the message. Nesting is
permitted; that is, the included file may also contain a %i macro.  In the
case of WELCOME.MSG or WELCOME0.MSG the filename may be given as an
absolute pathname, but if relative then it is relative to the directory
in which ftpd.exe is running.  (Note that you should never give
non-trusted users access to this directory.) In the case of DIR.MSG, the filename
is interpreted in the way the client sees the file system - i.e. if
relative then it is relative to the client's current directory - and
the client must have permission to read this file.
:dt.    %m
:dd.Expands to a character string giving the maximum allowed number of users
with the current username.
:dt.    %M
:dd.Expands to a character string giving the global maximum allowed number of users.
:dt.    %t
:dd.Expands to a string giving the local time.
:dt.    %T
:dd.For now, this is the same as %t.
:dt.    %u
:dd.Expands to a string giving a user number within this user's group.
:dt.    %U
:dd.Expands to a string giving this user's global user number.
:dt.    %%
:dd.The '%' character.
:edl.

.***********************************
.*   THE SITE COMMANDS
.***********************************

:h2 id=SITE.The SITE commands
:hp2.The SITE commands:ehp2.

:p.:hp2.The SITE PERM command:ehp2.

:p.The command SITE PERM returns a three-character string showing whether
you have read, write, and/or delete permission for the current directory.
(This command was added while I was testing a new feature.  It might be
withdrawn in future versions, because it's not particularly useful for
most users.)

:p.:hp2.The SITE MNGR commands:ehp2.

:p.Commands in this group may be used only from a manager account.
Currently the following options are available.

:dl break=all.
:dt.SITE MNGR EXEC
:dd.Runs another program.  See below for further details.
:dt.SITE MNGR EXIT
:dd.Shuts down the server.  (Don't do this unless you really mean it!)
:dt.SITE MNGR GXIT
:dd.Shuts down the server after the current users have logged out - i.e.
the same action as for the keyboard G command.
:dt.SITE MNGR KILL nnn
:dd.Forcibly logs out user number nnn. The number must match the one
returned by the SITE MNGR LIST command.
:dt.SITE MNGR LIST
:dd.Returns a list of currently logged-in users. The main purpose of this
command is to support the Monitor utility.
:edl.

:p.The SITE MNGR EXEC command starts a new program in a separate session.
(If FtpServer is running detached, then the new program must also run
detached.)  For example, you could zip up the user log with the command

:xmp.      site mngr exec zip.exe today.zip ftpusers.log
:exmp.

:p.If you want to run a batch file then you need to start a suitable
command shell.  For OS/2 command files and Rexx programs, the appropriate
shell is cmd.exe, as in the following example.

:xmp.      site mngr exec cmd.exe /c test.cmd parameter1 parameter2
:exmp.

.***********************************
.*   THE MONITOR UTILITY
.***********************************

:h1.The Monitor utility
:hp2.The Monitor utility:ehp2.
:p.
The program MONITOR.EXE allows the system manager to see who is currently
logged in, and to kill sessions where necessary.  This program can be run
either on the same machine as the server, or remotely.

:p.There is one optional parameter, which is the name of this program's
INI file. Normally you don't have to specify this, because the name
MONITOR.INI is assumed by default.  This option exists for the case
where you want to run multiple copies of the monitor to monitor
different servers, or to use a different font or screen size/position.
:p.
When you start the program, it attempts to connect to the server.  If it
fails to establish a connection, this might mean that the server is not
running.  Alternatively, it might mean that you are attempting to connect
to the wrong machine, or to the right machine with the wrong manager account.
In the latter case, see the setup instructions below.

:p.Once the program has made a connection to the server, it displays one
line per client session. This shows the time the session started, the
IP address of the client, and the username. Once you select one item of
this display, you will also see the last command issued, and in some
cases a display of how many bytes have been transferred in the current
operation.
:p.
Clicking on the "kill user" button will terminate that client session
and forcibly log out the user.
:p.
The "kill server" button allows you to shut down the server.  (Don't do
this unless you really mean it.)  You will be asked to confirm the shutdown
by selecting either "gradual shutdown" or "quick shutdown".  The difference
is that the "gradual shutdown" doesn't terminate the server until all
existing clients have logged out.

.**************************************
.*   SETTING UP THE MONITOR PARAMETERS
.**************************************

:p.:hp2.Setting up the Monitor parameters:ehp2.
:p.
Clicking on the setup button gives you a dialogue with the following items.
:dl break=all.
:dt.  Hostname
:dd.This specifies the machine on which the server is running, for example
mymachine.here.net.  If the machine has a fixed IP address, you can avoid a
nameserver lookup by specifying a numeric address, for example 123.45.67.89
:dt.  Port
:dd.This should normally be 21, but you might have set up the server to accept
connections from a non-standard port.
:dt.  Username
:dd.This must be the username for a manager account.
:dt.  Password
:dd.The password for the manager account.
:dt.  Update interval
:dd.The time (in seconds) between queries to the server to get the user
details.  The smaller this value, the more load you're putting on the
server.  A value between 5 and 10 seconds is usually a good compromise.
:edl.
:p.When you've finished filling in these details, close this window (or
type the Enter key) to return to the Monitor main display.

.***********************************
.*   THE TMONITOR UTILITY
.***********************************

:h1.The TMonitor utility
:hp2.The TMonitor utility:ehp2.
:p.
TMONITOR.EXE is an older version of the monitor program.  It is included
in this distribution for those who prefer to have a text-mode application.
:p.
When you start the program, it attempts to connect to the server.  If it
fails to establish a connection, this might mean that the server is not
running.  Alternatively, it might mean that you are attempting to connect
to the wrong machine, or to the right machine with the wrong manager account.
In the latter case, see the instructions for
:link reftype=hd refid=tmonitorsetup.Setting up the Monitor parameters:elink..
:p.
To kill a client session, use the cursor up/down keys to get to the desired
session, and then type the K key.
:p.
To shut down the server, type Ctrl/K.  (Hold down the Ctrl key while
typing K.)  You will be asked to confirm the shutdown by typing either
G (for a gradual shutdown) or Q (for a quick shutdown).
:p.
To close the TMonitor program, type the X key.
:p.
:note text='Hint:'.If you want to use less screen space, issue the command
.br
         MODE CO80,10
.br
before running TMonitor.exe.

.**************************************
.*   SETTING UP THE TMONITOR PARAMETERS
.**************************************

:h2 id=tmonitorsetup.Setting up the Monitor parameters
:hp2.Setting up the Monitor parameters:ehp2.
:p.
When running TMONITOR.EXE, typing S on the keyboard takes you to the setup screen.
There you will see four fields that have to be filled in.
:dl break=all.
:dt.  Server hostname
:dd.This specifies the machine on which the server is running, for example
mymachine.here.net.  If the machine has a fixed IP address, you can avoid a
nameserver lookup by specifying a numeric address, for example 123.45.67.89
:dt.  Server port
:dd.This should normally be 21, but you might have set up the server to accept
connections from a non-standard port.
:dt.  User name
:dd.This must be the username for a manager account.
:dt.  Password
:dd.The password for the manager account.
:edl.
:p.When you've finished filling in these details, press the Esc key to return to
the TMonitor main screen.

.***************************************
.*   THE LOADPRM AND STOREPRM UTILITIES
.***************************************

:h1 id=loadstore.The LoadPRM and StorePRM utilities
:hp2.The LoadPRM utility:ehp2.
:p.
This utility is needed if you want to manually edit user permission files.
It copies information from a PRM file into the server's FTPD.INI.  For
example, the command
:xmp.       loadprm example
:exmp.
:p.takes the information in the file EXAMPLE.PRM and creates or updates an
entry in the INI file for a user called "example".

:p.Wildcards are permitted. To load the information from :hp3.all:ehp3.
the PRM files in the current directory, use the command
:xmp.       loadprm *
:exmp.

:p.You do not have to restart the server. The updated user information will
take effect the next time a user logs in.

:p.:hp2.The StorePRM utility:ehp2.
:p.
This utility creates a PRM file by copying the user information from
FTPD.INI. You would use it if the INI file already contains user data
that you want to edit manually. For example, the command
:xmp.       storeprm example
:exmp.
:p.takes the information in the INI file for the user called "example",
and uses it to create a file EXAMPLE.PRM. (If EXAMPLE.PRM already exists,
the original copy is renamed EXAMPLE.BAK.)

:p.Wildcards are permitted. To create PRM files for :hp3.all:ehp3.
the existing users, use the command
:xmp.       storeprm *

:exmp.

.***************************************
.*   THE LOGANALYSIS UTILITY
.***************************************

:h1.The LogAnalysis utility
:hp2.The LogAnalysis utility:ehp2.

:p.LogAnalysis.exe is a utility to produce a summary from the
FtpServer user log.  You run it with the command

:xmp.        LogAnalysis logfilename:exmp.

:p.where "logfilename" is the name of the user log file.  If no
parameter is supplied, it assumes that the log file name is
FTPUSERS.LOG.

:p.The results are written to standard output.  You can redirect
this to a file, for example

:xmp.        LogAnalysis AUGUST.LOG >August.summary
:exmp.

.***********************************
.*   DEVELOPMENT NOTES
.***********************************

:h1.Development notes

:ul.
:li.:link reftype=hd refid=tools.Development tools:elink.
:li.:link reftype=hd refid=whyM2.Why Modula-2?:elink.
:li.:link reftype=hd refid=bugs.Known bugs:elink.
:li.:link reftype=hd refid=unresolved.Unresolved issues:elink.
:li.:link reftype=hd refid=reporting.Reporting errors:elink.
:li.:link reftype=hd refid=Y2K.Year 2000 compliance:elink.
:eul.

.***********************************
.*   DEVELOPMENT TOOLS
.***********************************

:h2 id=tools.Development tools
:hp2.Development tools:ehp2.

:p.Some people have asked about the compiler I'm using.  (I guess a
lot of people didn't realise that there were Modula-2 compilers
for OS/2.)  It's XDS Modula-2, OS/2 native mode version.

You can find out about this, and other Modula-2 compilers for OS/2,
at the web page
.br
     http&colon.//www.ee.newcastle.edu.au/users/staff/peter/os2/os2m2.html
.br
(I'm getting a little behind on keeping my web pages up to date,
but the information is still basically correct, only the version
numbers have changed.)
:p.The XDS home page is at
.br
      http&colon.//www.xds.ru/
.br
This is well worth visiting, because the XDS development team often
has "try before you buy" versions of their compilers available for download.
:p.
FtpServer uses some of the modules from the PMOS/2 library.
If you want to know more about PMOS/2, you'll also find that on
my web pages.  Source code is available.  My web pages are at
http&colon.//www.ee.newcastle.edu.au/users/staff/peter/Moylan.html.
:p.
This documentation was prepared with IBM's IPFC help compiler.

.***********************************
.*   WHY MODULA-2?
.***********************************

:h2 id=whyM2.Why Modula-2?
:hp2.Why Modula-2?:ehp2.
:p.
I'm often asked why I chose to code FtpServer in Modula-2.  Everyone
else seems to be using C or C++, so why don't I?
:p.
The short answer is that I don't think much of the "everyone else uses it"
argument.  If popularity was more important to me than technical merit,
I wouldn't be using OS/2.
:p.
The long answer is contained in a document called "The Case Against C",
which can be found at
http&colon.//murray.newcastle.edu.au/users/ftp/pub/reports/CaseAgainstC.ps.Z.
This is a compressed Postscript file.  If you can't handle compressed
Postscript, a text-only version (CaseAgainstC.txt) can be found in the
same directory.
:p.
And the medium-length answer is on this page.
:p.
To begin with, run-time efficiency is not as big an issue as most people
seem to think it is.  With modern compiler technology, the main programming
languages (apart from things like BASIC and its derivatives) give about
the same run-time efficiency.  C and C++ lose out a little because their
low-level constructs make it hard for the compiler to do a good job at
optimisation; the figures I've seen tend to suggest that a program written in
Modula-2 runs a little faster than the same program written in C or C++.
However, the difference is typically less than 5%, and hardly worth worrying
about.
:p.
So the big issue is development efficiency.  For a job like this we can
rule out languages like BASIC and REXX because they're a little too crude;
and we can rule out languages like Fortran because of their poor support
for "systems programming" tasks.  We can also rule out a host of lesser-known
languages because of the unavailability of OS/2 compilers.  That leaves us
with Pascal, Ada, Oberon, Modula-2, C, and C++.
:p.
I don't use Pascal because Modula-2 is basically an upgraded Pascal, and I
might as well use the improved version.
:p.
I haven't looked into the availability of Ada compilers for OS/2; but in any
case I don't like Ada because of its complexity.  The bigger a language is,
the more things there are to go wrong.
:p.
Oberon is a more subjective matter.  Some people will tell you that Oberon
is the successor to Modula-2, and is a superior programming language.  My
personal opinion is that Oberon has deleted some of the features that make
Modula-2 a good language.  I agree, however, that this issue is not entirely
clear-cut.
:p.
That brings us to C and C++.  I've done a lot of C and C++ programming over
the years, and it's left me with the feeling that those languages are major
barriers to programming efficiency.  It takes me roughly twice the time
to get a C or C++ program working as it does to get a comparable Modula-2
program working.  (On some projects I've kept logs to verify this.)  The
coding time is roughly the same, but there's a major difference in
debugging time.  Everyone I know writes buggy software in C and C++, and
then they take forever trying to track down the bugs.  Some developers
give up, and sell the software with the bugs still included.
:p.
There are two main reasons why C software is so bug-prone.
:ol.
:li.Lack of type safety.  C is designed in such a way that the compiler can't
do much error checking, so the compiler gives no warnings for things that, in
a type-safe language, would be reported as errors at compile time.  You don't
see the errors until execution time, and then you're left wondering what caused
the error.
:li.Poor support for modular programming.  You can break up a C program into
modules, but they're not truly independent of one another.  A slight change
in one module can have catastrophic effects on other modules.  Once a project
grows moderately large, you lose control of your own code.
:eol.
:p.
C++ is a little better in these two respects, but C++ has problems of its own.
The language designers tried to graft high-level features onto a low-level
language, and the result is a mass of inconsistency.  A C++ reference manual
is typically several times as thick as manuals for other programming languages,
because every rule has a maze of exceptions and special cases.
:p.
In addition, I've noticed that a lot of C++ programmers seem to have
adopted the philosophy of "let's try this, and hope that it works".  The notion
that you shouldn't write code that you don't understand seems to have become
unfashionable.  Maybe that's the fault of the language (and its libraries),
maybe not.  In any case, it's not the way I prefer to work.
:p.
Ultimately, the reason I use Modula-2 is that it lets me get applications
working quickly, it gives me control of large projects, and it doesn't force
me to spend huge amounts of time on debugging.  I'm too old to enjoy the
thrill of tracking down obscure bugs.  I like to get something working, and
then be free to move on to other projects.
:p.
Of course, it's difficult to guarantee that any piece of software is bug-free,
no matter what development tools you use.  But I can have the next-best
thing, which is an acceptably small error rate.

.***********************************
.*   KNOWN BUGS
.***********************************

:h2 id=bugs.Known bugs
KNOWN BUGS IN SERVER

:ul.

:li.Server shutdown does not work correctly when using
version 4.02k of the TCP/IP stack, although it does work with
earlier versions.  Other information I've received seems to
indicate that *ALL* server applications misbehave with
version 4.02k, so it looks as if the fault lies in the
TCP/IP implementation.
I have fixed the problem for version 4.02o, but the fix might
not work with 4.02k - my impression is that versions between
k and o are seriously buggy.

:li.Uploads not accepted if your free disk space is greater than
about 4000 gigabytes.  There doesn't seem to be any urgent
need to fix this just yet, but at the rate disk sizes
are growing ...

:eul.

:p.See also :link reftype=hd refid=unresolved.Unresolved issues:elink.

.***********************************
.*   UNRESOLVED ISSUES
.***********************************

:h2 id=unresolved.Unresolved issues
:hp2.Unresolved issues:ehp2.

:p.These are problems that various people have reported, but which
I haven't been able to duplicate. I'd be interested in hearing from
anyone who can confirm either that the problem really exists, or that
it's now fixed.
:p.
:ul.

:li.Reported: the server can be crashed by a client running JavaScript.
This problem is still a mystery to me, I haven't been able to track down
what's going on.

:eul.

.***********************************
.*   YEAR 2000 COMPLIANCE
.***********************************

:h2 id=Y2K.Year 2000 compliance
:hp2.Year 2000 compliance:ehp2.

:p.According to my tests, FtpServer should continue running correctly
until 31 December 2079.  (It might also continue working after that;
but the OS/2 system clock will not allow me to set the date to
2080 or later.)  This assumes that you are using HPFS disks.

:p.Systems using the FAT file system will stop working in 2038.
This has nothing to do with FtpServer; it's a fundamental limitation
of FAT.

.***********************************
.*   REPORTING ERRORS
.***********************************

:h2 id=reporting.Reporting errors

:p.If you find any error that's not mentioned
in this document, please report it to peter@ee.newcastle.edu.au.  The
following information would be useful in tracking down the cause of
the error:
:ul.
:li.The version number of the version you are using.
:li.The file errinfo.$$$, if it exists.
:li.Some information about what the server was doing at the time the
problem occurred; for example, the last few lines of the transaction log.
:eul.

:euserdoc.

