/* REXX Script to create FtpServer folder on desktop. */
/*     Thanks to Garey Smiley for providing this.     */

/* Register with REXX API extensions. */
Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
Call SysLoadFuncs

/* Get creation disposition. */
Call SysCls
Say
Say 'Create FTPServer folder and icons.'
Say
Say 'NOTE: This program needs to be executed from the directory'
Say '      FTPServer is installed in.'
Say
/* '@pause' */
CreateCollision = 'Update'
/* CreateCollision = 'Replace' */
Say

Call CreateObjects
Exit


CreateObject: procedure
    Parse Arg Class, Title, Location, Setup, Collision
    Say 'Creating ['Title']'
    rc = SysCreateObject( Class, Title, Location, Setup, Collision )
    If rc <> 1 Then
        Say ' > failed to create ['Title' | 'Class'] at location ['Location']'
    return rc


FileExists: procedure
    Parse Arg Filename
    Call SysFileTree Filename, filelist, 'F'
    IF filelist.0 = 1 THEN
        rc = 1
    ELSE
        rc = 0
    RETURN rc

/*
 * Another way to do FileExists
 *
FileExists:
    return( stream( arg(1), 'c', 'query exists' ) <> '' )
*/

DirectoryExists: procedure
    Parse Arg Dirname
    Call SysFileTree Dirname, dirlist, 'D'
    IF dirlist.0 = 1 THEN
        rc = 1
    ELSE
        rc = 0
RETURN rc


CreateObjects:

current_dir = directory()
foldername = 'FtpServer'
folderid = '<FTPServer_0>'

rc = CreateObject( 'WPFolder',,
    foldername,,
    '<WP_DESKTOP>',,
    'ALWAYSSORT=YES;'||,
        'SHOWALLINTREEVIEW=YES;'||,
        'OBJECTID='||folderid,,
    CreateCollision )

  rc = CreateObject( 'WPShadow',,
      'changes.doc',,
      folderid,,
      'SHADOWID='||current_dir||'\doc\changes.doc',,
      CreateCollision )

  rc = CreateObject( 'WPProgram',,
      'Setup',,
      folderid,,
      'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'EXENAME='||current_dir||'\PMSETUP.EXE;'||,
          'STARTUPDIR='||current_dir||';',,
      CreateCollision )

  rc = CreateObject( 'WPProgram',,
      'VIO Setup',,
      folderid,,
      'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'EXENAME='||current_dir||'\VIOSETUP.EXE;'||,
          'STARTUPDIR='||current_dir||';'||,
          'PROGTYPE=WINDOWABLEVIO',,
      CreateCollision )

  rc = CreateObject( 'WPShadow',,
      'purchase.doc',,
      folderid,,
      'SHADOWID='||current_dir||'\BMTMicro\purchase.doc',,
      CreateCollision )

  rc = CreateObject( 'WPShadow',,
      'purchase.exe',,
      folderid,,
      'SHADOWID='||current_dir||'\BMTMicro\purchase.exe',,
      CreateCollision )

  rc = CreateObject( 'WPProgram',,
      'FTPD',,
      folderid,,
      'NOPRINT=YES;'||,
          'MINWIN=VIEWER;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'EXENAME='||current_dir||'\FTPD.EXE;'||,
          'STARTUPDIR='||current_dir||';'||,
          'PROGTYPE=WINDOWABLEVIO;'||,
          'MINIMIZED=YES',,
      CreateCollision )

  rc = CreateObject( 'WPShadow',,
      'readme',,
      folderid,,
      'SHADOWID='||current_dir||'\readme',,
      CreateCollision )

  rc = CreateObject( 'WPProgram',,
      'FtpServer^Documentation',,
      folderid,,
      'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'EXENAME=view.exe;'||,
          'STARTUPDIR='||current_dir||';'||,
          'PARAMETERS=ftpserver.INF;'||,
          'PROGTYPE=PM',,
      CreateCollision )

  rc = CreateObject( 'WPProgram',,
      'Monitor',,
      folderid,,
      'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'EXENAME='||current_dir||'\MONITOR.EXE;'||,
          'STARTUPDIR='||current_dir||';',,
      CreateCollision )

  rc = CreateObject( 'WPProgram',,
      'VIO Monitor',,
      folderid,,
      'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'EXENAME='||current_dir||'\TMONITOR.EXE;'||,
          'STARTUPDIR='||current_dir||';'||,
          'PROGTYPE=WINDOWABLEVIO',,
      CreateCollision )

  if FileExists(current_dir||'\FTPUSERS.LOG') THEN DO
    rc = CreateObject( 'WPShadow',,
        'FTPUSERS.LOG',,
        folderid,,
        'SHADOWID='||current_dir||'\FTPUSERS.LOG',,
        CreateCollision )
  END

  if FileExists(current_dir||'\FTPTRANS.LOG') THEN DO
    rc = CreateObject( 'WPShadow',,
        'FTPTRANS.LOG',,
        folderid,,
        'SHADOWID='||current_dir||'\FTPTRANS.LOG',,
        CreateCollision )
  END

return

