MODULE Setup;

        (********************************************************)
        (*                                                      *)
        (*             FtpServer set-up utility                 *)
        (*                                                      *)
        (*  Programmer:         P. Moylan                       *)
        (*  Started:            22 January 1998                 *)
        (*  Last edited:        20 January 1999                 *)
        (*  Status:             OK                              *)
        (*                                                      *)
        (********************************************************)

IMPORT EditUsers, Security, Setup2, OS2;

FROM LowLevel IMPORT
    (* proc *)  EVAL;

FROM Windows IMPORT
    (* type *)  Window, Colour, FrameType, DividerType,
    (* proc *)  OpenWindow, CloseWindow, WriteChar, WriteString, WriteLn,
                SetCursor, GetKey, GetScreenSize;

FROM InetUtilities IMPORT
    (* proc *)  INIGet, INIPut;

FROM Menus IMPORT
    (* type *)  Menu, ItemText,
    (* proc *)  CreateMenu, MenuColours;

FROM ScreenEditor IMPORT
    (* type *)  Structure,
    (* proc *)  CardinalField, MenuField, Combine, ScreenEdit, DeleteStructure;

FROM MultiScreen IMPORT
    (* proc *)  EnableHotKeys;

FROM SetupINI IMPORT
    (* proc *)  OurINIHandle;

(************************************************************************)

VAR
    (* Number of display rows on screen.  *)

    ScreenRows: CARDINAL;

    (* Prompt line at bottom of screen.  *)

    bottombar: Window;

(************************************************************************)
(*                        INI FILE EDITING                              *)
(************************************************************************)

PROCEDURE EditDefaultParameters;

    VAR w: Window;
        R: Structure;
        port, MaxUsers, GuestLimit, FreeSpaceThreshold,
              UserLogging, TimeoutLimit, TransactionLogLevel: CARDINAL;
        abort: BOOLEAN;  ch: CHAR;
        hini: OS2.HINI;
        M: Menu;
        TrlOption: ARRAY [0..4] OF ItemText;

    (********************************************************************)

    PROCEDURE LoadINIData;

        (* Loads setup parameters from "ftpd.ini". *)

        PROCEDURE GetItem (name: ARRAY OF CHAR;
                             VAR (*OUT*) variable: CARDINAL): BOOLEAN;

            BEGIN
                RETURN INIGet (hini, "$SYS", name, variable);
            END GetItem;

        (****************************************************************)

        BEGIN
            hini := OurINIHandle();
            IF hini = OS2.NULLHANDLE THEN
                WriteString (w, "Could not open FTPD.INI");
                WriteLn (w);
            ELSE
                TransactionLogLevel := 1;
                IF NOT GetItem ("ServerPort", port) THEN
                    port := 21;
                END (*IF*);
                IF NOT GetItem ("MaxUsers", MaxUsers) THEN
                    MaxUsers := 10;
                END (*IF*);
                IF NOT GetItem ("GuestLimit", GuestLimit) THEN
                    GuestLimit := MaxUsers - 1;
                END (*IF*);
                IF GetItem ("DebugLevel", TransactionLogLevel) THEN
                    TransactionLogLevel := 2*TransactionLogLevel + 1;
                END (*IF*);
                IF GetItem ("TransLevel", TransactionLogLevel) THEN
                    INC (TransactionLogLevel);
                END (*IF*);
                IF NOT GetItem ("SpaceThreshold", FreeSpaceThreshold) THEN
                    FreeSpaceThreshold := 10;
                END (*IF*);
                IF NOT GetItem ("LogLevel", UserLogging) THEN
                    UserLogging := 1;
                END (*IF*);
                IF NOT GetItem ("TimeOut", TimeoutLimit) THEN
                    TimeoutLimit := 900;
                END (*IF*);
            END (*IF*);
        END LoadINIData;

    (********************************************************************)

    PROCEDURE StoreINIData;

        (* Writes data back to the INI file. *)

        PROCEDURE PutItem (name: ARRAY OF CHAR;  VAR (*OUT*) variable: CARDINAL);

            BEGIN
                INIPut (hini, "$SYS", name, variable);
            END PutItem;

        (****************************************************************)

        BEGIN
            IF hini <> OS2.NULLHANDLE THEN
                PutItem ("ServerPort", port);
                PutItem ("MaxUsers", MaxUsers);
                PutItem ("GuestLimit", GuestLimit);
                IF TransactionLogLevel > 0 THEN
                    DEC (TransactionLogLevel);
                END (*IF*);
                PutItem ("TransLevel", TransactionLogLevel);
                PutItem ("SpaceThreshold", FreeSpaceThreshold);
                PutItem ("LogLevel", UserLogging);
                PutItem ("TimeOut", TimeoutLimit);

                (* Get rid of the obsolete "DebugLevel" entry. *)

                OS2.PrfWriteProfileData (hini, "$SYS", "DebugLevel", NIL, 0);

            END (*IF*);
        END StoreINIData;

    (********************************************************************)

    BEGIN
        OpenWindow (w, white, blue, ScreenRows DIV 2 - 5, ScreenRows DIV 2 + 5,
                                                  19, 60, noframe, nodivider);
        LoadINIData;

        SetCursor (w, 1, 2);  WriteString (w, "Server port");
        SetCursor (w, 2, 2);  WriteString (w, "Maximum number of users");
        SetCursor (w, 3, 2);  WriteString (w, "Maximum number of guest users");
        SetCursor (w, 4, 2);  WriteString (w, "Free space threshold (MB)");
        SetCursor (w, 5, 2);  WriteString (w, "User logging level");
        SetCursor (w, 6, 2);  WriteString (w, "Timeout (seconds)");
        SetCursor (w, 8, 2);  WriteString (w, "Transaction logging");

        R := CardinalField (port, 1, 32, 8);
        Combine (R, CardinalField (MaxUsers, 2, 32, 8));
        Combine (R, CardinalField (GuestLimit, 3, 32, 8));
        Combine (R, CardinalField (FreeSpaceThreshold, 4, 32, 8));
        Combine (R, CardinalField (UserLogging, 5, 32, 8));
        Combine (R, CardinalField (TimeoutLimit, 6, 32, 8));

        (* Create the menu of transaction log options. *)

        TrlOption[1] := "None";
        TrlOption[2] := "Disk";
        TrlOption[3] := "Screen";
        TrlOption[4] := "Both";
        CreateMenu (M, 4, TrlOption, 4);
        MenuColours (M, white, blue, blue, cyan, yellow);
        Combine (R, MenuField (TransactionLogLevel, 9, 8, 1, 28, M));

        SetCursor (w, 1, 32);
        LOOP
            ScreenEdit (w, R, abort);
            IF abort THEN EXIT(*LOOP*) END(*IF*);

            (* Consume the character that took us off the edge. *)

            ch := GetKey (w);
            IF ch = CHR(0) THEN
                EVAL (GetKey (w));
            END (*IF*);

        END (*LOOP*);

        DeleteStructure (R);
        StoreINIData;
        CloseWindow (w);

    END EditDefaultParameters;

(************************************************************************)
(*                              MAIN PROGRAM                            *)
(************************************************************************)

PROCEDURE RunTheProgram;

    CONST Esc = CHR(1BH);

    VAR w0, w1: Window;

    BEGIN
        OpenWindow (w0, yellow, red, 0, 5, 2, 38, noframe, nodivider);
        WriteLn (w0);
        WriteString (w0, "        FTPSERVER SETUP");
        WriteLn (w0);  WriteLn (w0);
        WriteString (w0, "    Type F5 to edit users");
        WriteLn (w0);
        WriteString (w0, "     Esc to exit program");

        OpenWindow (w1, black, green, 0, 5, 44, 76, noframe, nodivider);
        WriteLn (w1);
        WriteString (w1, "  NOTE: Parameters set on this");  WriteLn (w1);
        WriteString (w1, "   page will take effect the");  WriteLn (w1);
        WriteString (w1, "  next time the server is run");  WriteLn (w1);
        WriteString (w1, "        on this machine");

        EditDefaultParameters;
        CloseWindow (w1);
        CloseWindow (w0);

    END RunTheProgram;

(************************************************************************)

VAR dummy: CARDINAL;

BEGIN
    GetScreenSize (ScreenRows, dummy);
    EnableHotKeys (TRUE, CHR(62), TRUE, CHR(63), TRUE, CHR(64));
    OpenWindow (bottombar, yellow, red, ScreenRows-1, ScreenRows-1, 0, 79, noframe, nodivider);
    WriteString (bottombar, " Esc exit");
    SetCursor (bottombar, 0, 55);
    WriteString (bottombar, "F4,F5 previous/next page");
    RunTheProgram;
FINALLY
    CloseWindow (bottombar);
END Setup.

