IMPLEMENTATION MODULE EditUsers;

        (********************************************************)
        (*                                                      *)
        (*             FtpServer user editor                    *)
        (*                                                      *)
        (*  Programmer:         P. Moylan                       *)
        (*  Started:            22 January 1998                 *)
        (*  Last edited:        09 July 1998                    *)
        (*  Status:             OK                              *)
        (*                                                      *)
        (********************************************************)

IMPORT OS2, Strings;

FROM MultiScreen IMPORT
    (* type *)  ScreenGroup, VirtualScreen,
    (* proc *)  CreateScreenGroup, CreateVirtualScreen, MapToVirtualScreen,
                RemoveVirtualScreen, RemoveScreenGroup;

FROM ListBoxes IMPORT
    (* type *)  ListBox,
    (* proc *)  CreateListBox, DestroyListBox, CursorMovements,
                LBAppend, LBCurrent, HighlightOn, LBDeleteCurrent,
                LBInsertAfter, ReplaceCurrent, LBSort;

FROM Users IMPORT
    (* proc *)  EditUser, RemoveUser;

FROM PermissionEditor IMPORT
    (* type *)  CharArrayPointer;

FROM SetupINI IMPORT
    (* proc *)  OurINIHandle;

FROM Windows IMPORT
    (* type *)  Window, Colour, FrameType, DividerType,
    (* proc *)  OpenWindowHidden, CloseWindow, SetCursor,
                WriteString, WriteLn, GetKey, GetScreenSize;

FROM Keyboard IMPORT
    (* proc *)  StuffKeyboardBuffer, StuffKeyboardBuffer2;

FROM LowLevel IMPORT
    (* proc *)  EVAL;

FROM TaskControl IMPORT
    (* proc *)  CreateTask;

FROM Storage IMPORT
    (* proc *)  ALLOCATE, DEALLOCATE;

(************************************************************************)

CONST Nul = CHR(0);

TYPE
    NameStringIndex = [0..31];
    NameString = ARRAY NameStringIndex OF CHAR;

VAR
    (* Number of display rows on screen.  *)

    ScreenRows: CARDINAL;

    (* The screen group for our screen page.  *)

    OurGroup: ScreenGroup;

    (* The screen page used by this module. *)

    OurPage: VirtualScreen;

    (* Header and footer windows. *)

    TopBar, BottomBar: Window;

(************************************************************************)
(*                  DISPLAYING THE LIST OF USERS                        *)
(************************************************************************)

PROCEDURE FillList (LB: ListBox);

    (* Adds all known users to the listbox. *)

    VAR hini: OS2.HINI;
        bufptr: CharArrayPointer;
        BufferSize: CARDINAL;
        name: NameString;
        j, k: CARDINAL;

    BEGIN
        (* Get the list of users from the INI file. *)

        hini := OurINIHandle();
        IF (hini <> OS2.NULLHANDLE)
                  AND OS2.PrfQueryProfileSize (hini, NIL, NIL, BufferSize)
                  AND (BufferSize > 0) THEN
            ALLOCATE (bufptr, BufferSize);
            OS2.PrfQueryProfileData (hini, NIL, NIL, bufptr, BufferSize);
            j := 0;

            (* Each time around this loop we extract one user name. *)

            WHILE (j < BufferSize) AND (bufptr^[j] <> Nul) DO
                k := 0;
                REPEAT
                    name[k] := bufptr^[j];
                    INC (k);  INC (j);
                UNTIL (j >= BufferSize) OR (bufptr^[j-1] = Nul)
                                        OR (k > MAX(NameStringIndex));
                IF NOT Strings.Equal (name, "$SYS") THEN
                    LBAppend (LB, name);
                END (*IF*);
            END (*WHILE*);
            DEALLOCATE (bufptr, BufferSize);
            LBSort (LB);

        END (*IF*);
    END FillList;

(************************************************************************)
(*                          MAIN EDITING TASK                           *)
(************************************************************************)

PROCEDURE UserEditor;

    (* Runs as an autonomous task. *)

    CONST Esc = CHR(1BH);
        BoxTop = 8;  BoxLeft = 2;  BoxWidth = 35;

    VAR ListWindow: Window;  UserList: ListBox;
        ch: CHAR;
        UserName: ARRAY [0..BoxWidth-1] OF CHAR;
        info: Window;
        BoxHeight: CARDINAL;

    BEGIN
        BoxHeight := ScreenRows - BoxTop - 4;
        OpenWindowHidden (info, black, green, 2, 6, 10, 70, noframe, nodivider);
        MapToVirtualScreen (info, OurPage);
        WriteLn (info);
        WriteString (info, " NOTE: This version no longer uses PRM files.");
        WriteLn (info);
        WriteString (info, " Use the LoadPRM utility to recover the information");
        WriteLn (info);
        WriteString (info, "   from your old *.PRM files");

        OpenWindowHidden (ListWindow, black, white, BoxTop, BoxTop+BoxHeight+1,
                      BoxLeft, BoxLeft+BoxWidth+2, noframe, nodivider);
        MapToVirtualScreen (ListWindow, OurPage);
        UserList := CreateListBox (ListWindow, 1, 1, BoxHeight, BoxWidth);
        FillList (UserList);
        HighlightOn (UserList);

        LOOP
            EVAL (CursorMovements (UserList));
            ch := GetKey(ListWindow);
            IF ch = Nul THEN
                ch := GetKey(ListWindow);
                IF ch = 'S' THEN                      (* Del = delete *)
                    LBCurrent (UserList, UserName);
                    RemoveUser (UserName);
                    LBDeleteCurrent (UserList);
                END (*IF*);
            ELSIF CAP(ch) = 'A' THEN                       (* A = add *)
                UserName := "";
                EditUser (OurPage, UserName);
                LBInsertAfter (UserList, UserName);
            ELSIF (CAP(ch) = 'E') OR (ch = CHR(13)) THEN   (* E = edit *)
                LBCurrent (UserList, UserName);
                EditUser (OurPage, UserName);
                ReplaceCurrent (UserList, UserName);
            ELSIF CAP(ch) = 'X' THEN                       (* X = exit *)
                StuffKeyboardBuffer2 (CHR(63));
                StuffKeyboardBuffer (CHR(27));
            END (*IF*);
        END (*LOOP*);

    END UserEditor;

(************************************************************************)
(*                         INITIALISATION                               *)
(************************************************************************)

PROCEDURE CreateHeadings;

    BEGIN
        OpenWindowHidden (TopBar, yellow, red, 0, 0, 0, 79, noframe, nodivider);
        MapToVirtualScreen (TopBar, OurPage);
        WriteString (TopBar, "    FTPSERVER USER EDITOR");
        OpenWindowHidden (BottomBar, yellow, red, ScreenRows-1, ScreenRows-1, 0, 79, noframe, nodivider);
        MapToVirtualScreen (BottomBar, OurPage);
        WriteString (BottomBar, " A add  E edit  Del delete  X exit");
        SetCursor (BottomBar, 0, 67);
        WriteString (BottomBar, "F5 next page");
    END CreateHeadings;

(************************************************************************)

VAR dummy: CARDINAL;

BEGIN
    GetScreenSize (ScreenRows, dummy);
    OurGroup := CreateScreenGroup (1);
    OurPage := CreateVirtualScreen (OurGroup);
    CreateHeadings;
    CreateTask (UserEditor, 2, "User editor");
FINALLY
    CloseWindow (BottomBar);
    CloseWindow (TopBar);
    RemoveVirtualScreen (OurPage);
    RemoveScreenGroup (OurGroup);
END EditUsers.

