:userdoc.
:title.FtpServer documentation
:docprof toc=12.

.***********************************
.*   INTRODUCTION
.***********************************

:h1.Introduction
:p.
FtpServer is an ftp daemon for OS/2.  It is distributed as
:link reftype=hd refid=register.optional shareware:elink..
This documentation is for version 0.70.
:p.
:hp2.Disclaimer of Warranty:ehp2.

:sl compact.
:li.
:hp8.
This Product is provided "as-is", without warranty of any
kind, either expressed or implied, including, but not limited to,
the implied warranties of merchantability and fitness for a
particular purpose.  The entire risk as to the quality and
performance of the Product is with you.  Should the Product prove
defective, the full cost of repair, servicing, or correction lies
with you.
:ehp8.
:esl.

:p.
The author of FtpServer is Peter Moylan, peter@ee.newcastle.edu.au.

:p.
The latest version of FtpServer is normally kept at ftp&colon.&slash.&slash.eepjm.newcastle.edu.au/software
.br
Information about other software on this site may be found at
http&colon.&slash.&slash.eepjm.newcastle.edu.au/html/software

:p.I keep a mailing list of people who receive e-mail notification of
new versions of my software.  If you want to be put on this list, let me
know by e-mail to peter@ee.newcastle.edu.au.
The mailing list is not used for any other purposes, and the addresses will not
be passed on to anyone else.

.***********************************
.*   REGISTRATION
.***********************************

:h1 id=register.Registration

:hp2.Registration:ehp2.

:p.This software is "optional shareware".  What this means is that you
decide whether you want to register as a paid owner of the software.
The software is not crippled in any way, and I will continue to provide
support and free releases of new versions to all users, whether or
not they are registered, for at least the short-term future.

:p.If you decide that this software is worth supporting, you have the
following payment options.
:p.
:hp2.Payment through BMT Micro:ehp2.

:p.This is likely to be the most convenient method for most people,
because BMT Micro has a number of different payment methods, including
credit cards.  It also has agents in several countries.  For full
details, see the BMTMicro folder included in the FtpServer distribution.
(This includes a program that simplifies registration by e-mail, if
you want to do it that way.)

:p.
:hp2.From Europe:ehp2.

:p.This works best for people living in the European Union.  (Warning:
check first whether your bank is going to charge you transfer fees.
They shouldn't, but I've heard of exceptions.)  You have two options:
:ul.
:li.Transfer 750 Belgian francs to the following bank account
:sl.
:li.Marion Gevers
.br
Account number 210-0384103-35
.br
G&ea.n&ea.rale de Banque (Belgium)
.br
Mention: FtpServer
:esl.
:p.and send an e-mail to peter@ee.newcastle.edu.au to confirm that you've done it.

:li.Send a Eurocheque for 750 Belgian francs to
:sl.
:li.Peter Moylan
.br
91 Harriet Street
.br
Waratah, NSW 2298
.br
Australia
:esl.
:eul.

:p.
:hp2.Payment directly to me in Australia:ehp2.

:p.This is a more attractive option for people in Australia.  From
other countries, it's not a good idea because of the bank charges on
international transfers.  (Please don't send non-Australian currency
to an Australian bank, because then I get hit with exorbitant bank fees.)
You can do it in either of two ways.

:ul.
:li.Send a cheque, or equivalent, for $25 (Australian dollars) to
:sl.
:li.Peter Moylan
.br
91 Harriet Street
.br
Waratah, NSW 2298
.br
Australia
:esl.

:li.Transfer the amount of $25 (Australian dollars) to the following bank
account.
:sl.
:li.Marion Gevers
.br
Account number (06 2831) 00626468
.br
Commonwealth Bank
.br
University of Newcastle, Australia
:esl.
:eul.

.*************************************
.*   DOCUMENTATION IN OTHER LANGUAGES
.*************************************

:h1.Documentation in other languages
:hp2.Documentation in other languages:ehp2.
:p.
To simplify the distribution, the FtpServer zip file normally contains only
English-language documentation.  To get documentation in another language,
go to ftp&colon.&slash.&slash.eepjm.newcastle.edu.au/inf and look for
a file called ftpserver.inf.xxx, where xxx indicates the language.
:p.
At present, the only languages available are English and Russian.  (The
Russian version is ftpserver.inf.866.)  If you
want to volunteer to do another translation, you will find the original
document source (FtpServer.IPF) in source.zip, which is included as part
of the FtpServer distribution.

:p.The copyright on the translations belongs to the people who did
the translations.  The Russian translation belongs to
Konstantin Boyandin.

.***********************************
.*   SERVER FEATURES
.***********************************

:h1 res=002.Server features

FtpServer is an ftp server program that implements most of the ftp standard,
RFC 959.  It supports re-get and passive mode transfers.  The system manager
can control which directories are visible to users, and the kind of
access (read, write, delete) allowed in each directory.

:p.
For further details, see
:ul compact.
:li.:link reftype=hd refid=special.What's special about FtpServer:elink.
:li.:link reftype=hd refid=limitations.Limitations and missing features:elink.
:li.:link reftype=hd refid=quirks.Quirks:elink.
:li.:link reftype=hd refid=troublesome.Troublesome clients:elink.
:li.:link reftype=hd refid=nonstandard.Nonstandard features:elink.
:eul.

:h2 id=special.What's special about FtpServer?

:ul.
:li.Supports most of what's in the FTP standard, including re-get and
passive mode.

:li.Fast and compact.

:li.Compatible with all FTP clients that I've been able to test.

:li.Separate read, write, and delete permission for each directory
the user can see.  You can also make directories invisible.
Users can be given multiple home directories, if desired.

:li.You can restrict the IP addresses from which clients can log in,
and you can restrict the number of simultaneous logins from the
same address.

:li.Can be run from inetd.

:li.Can be run detached.

:eul.

:h2 id=limitations.Limitations and missing features
LIMITATIONS AND MISSING FEATURES

:p.
These are things I might fix up when I have the time, though some
have higher priority than others.

:ul.

:li. Transfer types: only Ascii, Image, and "Local 8" are supported.
Support for Fortran carriage control and EBCDIC will probably
never be added.

:li. Page-structured files will probably never be supported.
(As far as I know, only PDP-10 systems support this feature.)

:li. The only supported transmission mode is stream mode.  I might
or might not add support for block mode and compressed mode
at a later stage.  For the moment, there doesn't seem to be
any demand for these extras - I haven't come across any ftp
client that uses them.

:eul.

:p.The only command from RFC 959 that is not implemented is STAT.

:h2 id=quirks.Quirks
QUIRKS

:p.
These might be seen as errors, but there's no need to fix them
because they don't have a harmful effect.

:ul.
:li. Can CD to a directory that doesn't exist, if that directory is
shown as visible in the user's permission file.  Not a real
problem, because the user sees an empty listing and can't do
any operations in that directory.

:eul.

:h2 id=troublesome.Troublesome clients
TROUBLESOME CLIENTS

:p.
Different ftp clients work differently, and some of them don't
bother to adhere to the standards, so there will probably always
be some client incompatibilities.  The ones I know about so
far are:

:ol.
:li.One of the MS-Windows ftp clients (for the moment I've forgotten
which one) gives unreasonable time delays when listing a short
directory, although long listings are quite fast.  The tests
I've been able to do suggest that this problem occurs only
when the client and server machines are physically close to
each other.  Once the network delays rise to more typical
values, the problem goes away.

:li.I've been told of a problem when using ws-ftp, involving a
"can't change directory" symptom when fetching the entire
contents of a directory; but I've been unable to
reproduce the problem and I'm still not quite sure of the
precise nature of the problem.

:li.Apparently some proxy servers can't handle multiline responses
to FTP commands. If you hit this problem, you might be able to
solve it by deleting the file WELCOME.MSG.
:eol.

:h2 id=nonstandard.Non-standard features
NON-STANDARD FEATURES

:p.
The program violates RFC959 in the following ways:

:ol.
:li. Extra commands SIZE and MDTM are implemented.

:li. The SYST command returns a reply of UNIX rather than OS/2.
I had to do this because the "correct" reply causes
WebExplorer to misinterpret the directory listings, and
I'm told that at least one Microsoft ftp client will refuse
to connect to a server that identifies itself as OS/2.

:li. The obsolete and non-official commands XMKD, XRMD, XPWD, XCUP,
and XCWD are implemented.  (These became obsolete more than
10 years ago, and most ftp clients don't use them; but
apparently one of the clients for Windows NT hasn't yet been
updated to the current standard.)

:eol.

.***********************************
.*   INSTALLATION
.***********************************

:h1.Installation
:hp2.Installation:ehp2.
:p.
See also :link reftype=hd refid=deinstall.De-installation:elink.

:p.
You should have received this package in the form of a zip file.
To install it, simply unzip the file into a directory of your choice.
(Presumably you've already done this.)  The server is now ready to
run.

:p.
The server itself is the program called ftpd.exe.  You can run it
either by double-clicking on the desktop icon, or by entering the
command "ftpd" in a command-line session.  (In the latter case, make
sure you're in the right directory, otherwise you'll end up running
the ftpd that was supplied with OS/2.)  Most people will want to
put a program object or shadow for ftpd into the startup folder,
so that the server will run each time the system is booted; but that's
up to you.

:p.
Even though the server will work "out of the box", you still need to
define the user permissions so that clients can connect to the server.
You can do this either before running the server, or while it's
running.  See :link reftype=hd refid=setupusers.Setting up the User
Permissions:elink..

:p.The file source.zip is optional.  If you're not interested in the
source code, you can delete it.
:p.
For some other options, see
:ul compact.
:li.:link reftype=hd refid=parameters.Command line parameters:elink.
:li.:link reftype=hd refid=inetd.Running from inetd:elink.
:li.:link reftype=hd refid=detached.Running FtpServer detached:elink.
:li.:link reftype=hd refid=welcome.Welcome messages:elink.
:eul.

.***********************************
.*   DEINSTALLATION
.***********************************

:h1 id=deinstall.De-installation
:hp2.De-installation:ehp2.
:p.
FtpServer does not tamper with CONFIG.SYS or with other system files.
If you decide that you don't want to keep FtpServer, simply delete
the directory into which you installed it.

.***********************************
.*   SETTING UP THE USER PERMISSIONS
.***********************************

:h1 id=setupusers.Setting up the User Permissions

:hp2.User Permissions:ehp2.

:ul compact.
:li.:link reftype=hd refid=UPconcepts.General concepts:elink.
:li.:link reftype=hd refid=configuser.Setting up users with the Setup program:elink.
:li.:link reftype=hd refid=configmanual.Manual configuration:elink.
:eul.

.***********************************
.*   GENERAL CONCEPTS
.***********************************

:h2 id=UPconcepts.User permissions: General concepts

:hp2.GENERAL CONCEPTS:ehp2.

:p.
Each user of the server has a login name (username), a password, and
one or more home directories.  Users may access their home
directories, including any subdirectories, but they cannot
get at, or even see, any other directories in the machine's
file system.  Optionally, you can also block access to
specified subdirectories of their home directory.

:note.
In this context, "user" refers to a username rather than to
a person.  For example, you might have a number of different
people all accessing the server via the username "anonymous".
As far as the server is concerned, they are not separate users,
but rather separate instances of the user called "anonymous".

:p.
The server looks looks up the user information in an INI file called FTPD.INI, which should
be in the same directory as ftpd.exe. This INI file is created
and maintained by the Setup utility, as explained below.

:p.
There are two ways to create and edit the user permissions.
:ol.
:li.By using the Setup program that is supplied with FtpServer.
This is the recommended method, for compatibility with future releases
of FtpServer, and also because this method ensures that you produce
syntactically correct permission files.  The procedure is described
in the section :link reftype=hd refid=configuser.Using the Setup utility:elink..
:li.Manually, using any text editor.  The details can be found in the section
:link reftype=hd refid=configmanual.Manual configuration:elink..  Manual
configuration is supported for the benefit of existing FtpServer users who
have become used to doing it this way; but it is not the recommended method,
because it's too easy to make mistakes.
:eol.

:p.
:hp2.User categories:ehp2.

:p.
Each user is classified as one of the following.

:dl break=none.
:dt.   G
:dd.Guest user, who has to provide an e-mail address as a password.
:dt.   U
:dd.Normal user, who has to supply a password
:dt.   N
:dd.User who does not need a password.
:dt.   M
:dd.Manager: same as U, except that a manager gets some
:link reftype=hd refid=manager.extra privileges:elink..
:edl.

:p.
Normally you would create one "manager" account for yourself, and use
the G or U categories for all other users.  The N category is for those
rare cases where you don't need to control access with a password.

:p.
:hp2.Directory permissions:ehp2.

:p.
Each directory that is accessible to the user is described by some
combination of the following four permission attributes.

:dl break=none.
:dt.   V
:dd.Directory visible.  This should be set in most cases.  When it's not
set, the client can't do a "change directory" to this directory, and it
won't appear in directory listings.
:dt.   R
:dd.Read permission.  If this is set then the client can download files
from this directory.
:dt.   W
:dd.Write permission.  If this is set then the client can upload files
to this directory.
:dt.   D
:dd.Delete permission.  If this is set then the client can delete files
from this directory.  Note: to overwrite an existing file, both W and D
permissions are needed.
:edl.

:nt text='Remark'. It is possible for a user to be given read, write, and/or
delete privileges to an invisible directory.  In such cases the users can
perform the permitted operations only if they know the correct file name,
including the directory name,
because they won't see the directory name in a directory listing.
:p.
It's also possible for an invisible directory to have visible subdirectories.
Users can get to those directories only if they know the path name, including
the name of the invisible directory.
:ent.
:p.
:hp2.Multiple home directories:ehp2.
:p.
When a user has just one home directory, that directory appears to the
user to be the root directory.  (The user does not see the true name of
the directory.)  There is no way for users to see any directories other
than the home directory and its subdirectories.

:p.
When a user has more than one home directory, each home directory has
a "volume name" chosen by the system manager.  One use for multiple home
directories is to give a user access to files on more than one disk drive.
In that case, you might choose to use the drive letter as the volume name;
but that's not compulsory, you can choose the volume names arbitrarily.

:p.
When the user logs in, each volume appears to be a subdirectory of the
user's root directory.  Thus, the normal "change directory" commands can
be used to step through the different volumes.

:p.Remark: the volume name is irrelevant in the case of a single home
directory, because in that case the user never gets to see the volume name.

.***********************************
.*   MANUAL CONFIGURATION
.***********************************

:h2 id=configmanual.Manual configuration

:hp2.Manual configuration of users:ehp2.

:p.
This section describes how to edit a permission file.  It can be skipped
by most people, because in most cases it's better to use the
:link reftype=hd refid=configuser.Setup:elink. program to automate the editing.

:p.If the user information is already in the server's INI file (e.g.
because you used the Setup utility to add this user), then the first
thing you need to do is to use
the :link reftype=hd refid=loadstore.StorePRM utility:elink. to create
a PRM file for this user. (Of course this step is not needed if you have
an existing PRM file for the user.)  After editing the PRM file, which
you can do with any text editor, you can use the
:link reftype=hd refid=loadstore.LoadPRM utility:elink. to load the
information back into the INI file.

:p.
A PRM file is free-format, i.e. the exact formatting is not
important; but, for the sake of readability, I suggest that
you use indentation etc. to make its structure clearer.

:p.
The file can include comments.  A comment is anything from the
'%' sign to the end of the current line.  Note, however, that comments
will be stripped out when the LoadPRM program loads the data into the
server's INI file.

:p.
File names containing spaces or special characters should be
delimited by either double quote marks ("...") or single
quote marks ('...').  For "normal" file names the quotation
marks are optional.  (But see the warning at the end of this
page.)

:p.
The first two things in a permission file are:

:ol.
:li.The user category code (G, U, N, M), as described in the
:link reftype=hd refid=UPconcepts.General concepts:elink. section.

:li.The password.  For a guest user, put "@" as the password.
For an 'N' user, just supply a dummy entry here.

:eol.

:p.
After that, you specify one or more volumes.  The volume information is
in the form
:p.
       <volume name> = <home directory> <directory descriptor>
:p.
The home directory must be given as a full path name, starting with
a drive name and ending with the '/' character.

:p.
A <directory descriptor> gives the permissions for this home directory
and all of its subdirectories.  It has the form

:p.
       <code> <subdirectory info>

:p.
Both of these are optional.  The <code> can be any combination of

:dl compact break=none.
:dt.   V+
:dd.Directory visible
:dt.   V-
:dd.Directory invisible
:dt.   R+
:dd.Allow reads (i.e. downloads) of files in this directory
:dt.   R-
:dd.Deny read
:dt.   W+
:dd.Allow write
:dt.   W-
:dd.Deny write
:dt.   D+
:dd.Allow delete
:dt.   D-
:dd.Deny delete
:edl.

:p.
The permission codes are always to be interpreted relative to
the parent directory's permission code.  That is, a directory has
the same permissions as its parent, unless explicitly changed
by adding and&slash.or deleting permissions.

:p.
(For the home directory, the default permissions are: visible,
read, no write, no delete.)

:p.
The <subdirectory info> is defined recursively.  It has the form

:p.
       (  <item> ,  <item> ,  ...  , <item> )
:p.
i.e. it is a comma-separated list of items, surrounded by
parentheses.  Each <item> has the form
:p.
       <directory name>  <directory descriptor>
:p.
where the <directory descriptor> follows exactly the same rules
as the <directory descriptor> for the home directory.  That is,
it can also contain things like comma-separated lists of
subdirectory information.
:p.
If this sounds complicated, take a look at the supplied *.PRM
files, and you'll soon pick up the pattern.

:note.You don't have to list all of the subdirectories - only the
ones whose permissions are different from the permissions of the
parent directory.

:p.
:hp2.Example:ehp2.
:p.
Suppose you want the user "anonymous" to have read access to
the directory C&colon.\users\pub; read and write access to
C&colon.\users\pub\upload; no access at all to C&colon.\users\pub\private;
and read access to all other subdirectories
of C&colon.\users\pub.  Then the permission file ANONYMOUS.PRM should
have the following contents.
:xmp.
    G                    % user category = guest
    @                    % password = e-mail address
    "C&colon./users/pub/" V+R+  % home directory
      ( upload W+,       % allow write access to upload directory
        private V-R- )   % deny all access to private directory
:exmp.
:p.
Remark: FtpServer considers the forward slash (/) and backslash (\) to
be equivalent in filename strings.
:p.
:hp2.WARNING ABOUT POTENTIAL SYNTAX ERRORS:ehp2.
:p.
The software that parses a permission file tries to be
as non-rigid as possible; for example, it does not insist
that the characters in passwords, directory names, etc.
be alphanumeric characters.  This flexibility comes at a
price: you can write permission files that seem to be
correct, but which are syntactically ambiguous.
:p.
For example, suppose that a permission file contains two
home directory specifications:
:xmp.
    C&colon./PUB/
    D&colon./XYZ/UVW/
:exmp.
:p.This looks OK, but in fact it confuses the parser.  When
the parser sees the "D" on the second line, it thinks you're
trying to enable delete permission for the home directory
on the preceding line.  Having consumed the "D", it then
decides that the drive name for the second directory is ":".
:p.
The way to solve this problem is to put a semicolon at
the end of the first line (or the beginning of the second
line), to separate the two specifications.


.***********************************
.*   MANAGER PRIVILEGES
.***********************************

:h2 id=manager.Manager privileges
:hp2.Manager privileges:ehp2.
:p.
A manager account is the same as a normal user account, except that
a manager has a few extra privileges.
:ul.
:li.Managers can see system and hidden files in directory listings;
other users cannot.
:li.Managers are allowed to use the :link reftype=hd refid=SITE.SITE MNGR:elink. commands.
:eul.

.***********************************
.*   THE SETUP UTILITY
.***********************************

:h1 id=configuser.The Setup utility

The program SETUP.EXE has three functions:
:ul compact.
:li.To set the parameters that the server will use when it starts up.
:li.To place controls on which IP addresses may access the server.
:li.To create and edit user permissions.
:eul.

:p.
Use the F5 function key on the keyboard to toggle among these functions.

:p.
The parameter settings are stored in a file FTPD.INI.  The server reads its
INI file as it starts up, so any changes you make will not take effect until
the next time you start the server.
:p.
Exception: the user permissions are not read until a user attempts
to log in.  You may therefore alter the user permissions while the server
is running, and the alterations will affect the next user to log in.

:p.
Now read

:ul compact.
:li.:link reftype=hd refid=configuser1.Setting the server parameters:elink.
:li.:link reftype=hd refid=security.Security settings:elink.
:li.:link reftype=hd refid=configuser2.Modifying user permissions:elink.
:eul.

:h2 id=configuser1.Setting the server parameters
:hp2.Setting the server parameters:ehp2.
:p.
When you run SETUP.EXE, you get a screen showing the following items.

:dl break=all.
:dt.Server port
:dd.Unless you are doing something nonstandard (for example, running two ftp servers
on the same machine) this should always be 21.
:dt.Maximum number of users
:dd.This specifies how many clients will be allowed to use the server simultaneously.
I usually set this to 10.  Higher values will, of course, increase the load on your
processor.
:p.Note: this is a global maximum.  You may also set this to a high value, and then
control the number of users on a per-username basis.
:dt.Maximum number of guest users
:dd.This typically should be slightly less than the number specified for the maximum
number of users, to reserve one or more login slots for the system manager and other
non-guest users.
:dt.Free space threshold (MB)
:dd.This specifies the amount of free space that must be available on a drive for
uploads to be enabled.  If the free space, in megabytes, falls below this level then
uploads will be disabled.
:dt.User logging level
:dd.The server creates a log file called FTPUSERS.LOG.  (If you delete the file, it
will be re-created.  It would be a good idea to delete it, or move it to an archive,
every month or so, so that it does not grow too large.)  The user logging level controls
how much detail gets written to this file.
:dl.
:dt.     0
:dd.No logging
:dt.     1
:dd.Log successful file transfers
:dt.     2
:dd.Log successful and unsuccessful file transfers
:dt.     3
:dd.Log all users, even those who didn't transfer any files
:edl.
:dt.Timeout (seconds)
:dd.The time that a client session may remain idle before the user is evicted.
You will find that many ftp clients, especially web browsers, don't log out properly,
so their sessions have to be killed with the timeout mechanism.
:dt.Transaction logging
:dd.You can choose to send a detailed log to the screen, or to a disk file, or both.
The disk file is called FTPTRANS.LOG, and it is updated approximately once every
15 minutes if this feature is enabled.
:p.Warning: Transaction logging can create very large log files.  I suggest that
you don't enable this feature unless you're trying to track down a problem.
:edl.

:p.
To modify any of these parameters, use the up/down arrow keys to get to the
desired item, then type in the new value.  (The backspace, Insert, Delete, Home,
and End keys
will also work during editing.)  The new value is accepted when you type the
Enter key, or when you use the function keys to go to another field.
:p.
When you've finished editing, use the Esc key to exit from the Setup program, or
type F5 to get to the :link reftype=hd refid=security.security screen:elink..

:h2 id=security.Security settings
:hp2.Security settings:ehp2.
:p.
To modify the security settings, run SETUP.EXE, and then type the F5 function key
on the keyboard to get to the "Security" screen page.
:p.At the top of this page there is a field called the "Same IP limit".  This specifies the
maximum number of users that can be connected simultaneously from the same IP
address.  It is primarily a protection against users who hog the server by
logging in more than once.
:p.Set this value to whatever you want, finishing with the "Enter" or "cursor down"
key to confirm the new value.  The "cursor down" key will take you to the IP address
allow/deny lists, as described below.  When you've finished setting the values on this
page, type F5 to get to the
:link reftype=hd refid=configuser2.user permission editor:elink..
:p.
:hp2.Restricting access to certain IP addresses:ehp2.
:p.
The two large boxes on this screen page are the "allow" and "deny" lists of IP
addresses.  These are for putting restrictions on which remote hosts are allowed to
log into the server. (If you don't need this feature, just leave the two lists empty.)
The server interprets the lists as follows.
:ul.
:li.If a client address matches one of the entries in the "allow" list, then the
client is allowed to proceed, and the "deny" list is ignored.
:li.Otherwise, the client is allowed to connect only if its IP address does :hp1.not:ehp1.
match any of the entries in the "deny" list.
:eul.
:p.Each list entry consists of two components, an address and a mask.  Each of these is
expressed in "dotted quad" notation: a four-byte value where each byte has its value
written out in decimal. (This is a standard convention for writing IP addresses.)
A client address matches an entry if
:p.       (client IP address) :hp2.AND:ehp2. mask = (IP address in the list)
:p.where :hp2.AND:ehp2. means the bit-by-bit Boolean "logical AND" operation.
:p.Note, in particular, the two extreme cases:
:ul.
:li.If the mask is 255.255.255.255, then we are specifying an exact match between
the client IP address and the address in the list.
:li.If the mask is 0.0.0.0, then any IP address will match this entry. You can use
this to specify an "everything else" condition.
:eul.
:p.
:p.:hp2.Example 1.:ehp2. If you want to lock out all machines with IP address in
the range 123.45.67.0 to 123.45.67.127, put an entry in the "deny" list with
address 123.45.67.0 and mask 255.255.255.128.  The "allow" list can be left empty in
this case.
:p.:hp2.Example 2.:ehp2. Suppose you want to give access only to your local network,
which has addresses in the range 123.45.66.0 to 123.45.67.255.  You can do this by putting
an entry in the "allow" list with address 123.45.66.0 and mask 255.255.254.0.  To lock
out everyone else, put an entry in the "deny" list with mask 0.0.0.0.
:p.:hp2.Example 3.:ehp2. To allow access to 123.45.67.89, but to lock out everyone
else in 123.45.67.*, you can
:ul compact.
:li.put an entry in the "allow" list with address 123.45.67.89 and mask 255.255.255.255
:li.put an entry in the "deny" list with address 123.45.67.0 and mask 255.255.255.0
:eul.

:h2 id=configuser2.Modifying user permissions
:hp2.Modifying user permissions:ehp2.
:p.
To modify the user permissions, run SETUP.EXE, and then type the F5 function key
twice to get the the "Users" screen page.  This will give you a list of
all existing users.  (The first time you run the program, the list will probably
be empty.)
:p.
From this screen, you can add, delete, or modify users.  When you've finished,
use the F5 function key to get back to the main Setup screen.
:p.
:hp2.Deleting a user:ehp2.
:p.
Use the up/down arrow keys to get to the user you want to delete, and type
the Del (delete) key.
:p.
:hp2.Adding a new user:ehp2.
:p.
Type A, and then proceed as for :link reftype=hd refid=edituser.Editing a user's permissions:elink..
:p.
:hp2.Editing the permissions of an existing user:ehp2.
:p.
Type E, and then follow the instructions in the section :link reftype=hd refid=edituser.Editing a user's permissions:elink..

:h2 id=edituser.Editing a user's permissions
:hp2.Editing a user's permissions:ehp2.
:p.
You get to this point by running the Setup program, typing F5 to get to
the user editor, and then using one of the "A" (add user) or "E" (edit user)
options.
:p.
By now you should have four fields near the top of the screen.
:dl break=all.
:dt.    User name
:dd.The name that the user will use when logging in.
:dt.    Category
:dd.One of User, Guest, NoPassword, or Manager.
:dt.    Password
:dd.This user's password.
:dt.    User limit
:dd.The maximum number of simultaneous sessions with this user name.
(If you don't want such a control, just make this number larger than the
global user limit.)
:edl.
:p.
Use the up/down arrow keys to get to the field you want to edit, and
then modify it as necessary.  For the "Category" field, use the
left/right arrow keys to select a category.

:warning.If you change the user name, the permissions for the previous
user name will be deleted.  You should also avoid using a user name
that is the same as for some other user.:ewarning.
:p.Next, you have to go to the list of home directories, in the bottom
half of the screen.  (For a new user, this list will initially be
empty.)  Use the down-arrow key to get to the list, and then type
either A (to add a home directory) or E (to modify an existing entry
in the list of home directories).
:p.
This gives you a new screen, where the top two lines are
:dl break=all.
:dt.  Virtual drive name
:dd.This is the name that the user will see as the "directory name"
for this home directory.
:dt.  Home directory
:dd.This should be a full path name, starting with a physical drive name
and finishing with the '/' character.  For example, it could be
"C&colon./users/pub/" (without the quotation marks).  In this field, the
software considers the characters '/' and '\' to be equivalent.
:edl.
:p.
After editing these two fields, use the "cursor down" key to go to
the "directories" box on the screen.  There will be a short pause while
the program builds a list of all subdirectories.  (If you have many
subdirectories, it will be a long pause.)
:p.
You are then presented with a list of subdirectories of this home
directory.  To the left of each directory name, you will see a code
consisting of one or more of the letters "VRWD".  The meanings of
these user permission codes are explained in the
:link reftype=hd refid=UPconcepts.General concepts:elink.
section.
:p.
You might also see a "+" in front of some directory names.  This
indicates that this directory is collapsed, i.e. it has subdirectories
which are not at present displayed on the screen.
:p.
At this point, you have the following options.
:ul.
:li.You can navigate through the list of directories with the
cursor up/down keys, and also with the Home, End, PageUp, and
PageDown keys.
:li.To change a permission, type one of the characters V, R, W, or D.
This toggles the state of the corresponding permission code for the
currently selected directory.
:li.Typing the "I" key gives the selected directory a copy of the
current permissions of its parent.
:li.The "P" key copies the permissions of the currently selected directory
to all of its subdirectories. Use this if you want to change an entire
subtree in one operation.
:li.The "-" key collapses a directory by removing its subdirectories
from the screen listing. (But these subdirectories will still be affected
by the "P" option.) To get the subdirectories back, type the "+" key.
:eul.
:p.
When you've finished editing the permissions, type X to return to
the previous screen.  Alternatively, you can get to the previous
screen with the "cursor up" key.
:p.
Now you're back in the list of home directories.  At this point you
have the choice of adding more home directories, or leaving this
list with the "Esc" or "cursor up" keys.
:p.
When you've finished setting up all users, type the F5 key to get
back to the main page of the Setup program.

.***********************************
.*   RUNNING THE SERVER
.***********************************

:h1.Running the server
:hp2.Running the server:ehp2.
:p.
The server executable is called FTPD.EXE.  You can run this the way you run
any other OS/2 program: from the command-line, by clicking on an icon, from
the Startup folder, etc.  If you're running several server applications, then
the most obvious choice is to put a command to start the server in the
command file \TCPIP\BIN\TCPSTART.CMD.
:p.
Normally the server takes its configurable parameters from the INI file
created by the :link reftype=hd refid=configuser.Setup program:elink..  You may, however,
override these parameters by specifying :link reftype=hd refid=parameters.command-line parameters:elink..
:p.
You also have the options of :link reftype=hd refid=inetd.running the server from inetd:elink.
or :link reftype=hd refid=detached.running the server as a detached program:elink..
:p.
Once the server is running, two keyboard commands are available.
:dl.
:dt.    G
:dd.Gradual shutdown.  No new users are accepted.  The program
will terminate when the existing users have logged off
(or timed out), or when a Q comand is issued.
:dt.    Q
:dd.Quick shutdown.  The program closes down even if there are logged-in users.
:edl.

:h2 id=parameters.Command line parameters
:hp2.Command line parameters:ehp2.
:p.
Normally you don't need any parameters when invoking FTPD.EXE, because the server
takes its parameters from the INI file.  (And the contents of the INI file are
controlled by the Setup program.)  You may, however, override the parameters in
the INI file by giving command-line parameters.
:p.
There are several optional parameters. These all have the form of a letter followed
by a (decimal) number, and they can be given in any order.
:dl.
:dt.   D
:dd.Detailed transaction logging (default 0).
:dl compact.
:dt.         0
:dd.No logging
:dt.         1
:dd.Logging to the disk file FTPTRANS.LOG
:dt.         2
:dd.Logging to the screen
:dt.         3
:dd.Logging to both the screen and the disk file
:edl.

:dt.   F
:dd.Free space threshold (megabytes).  Users can't upload to a
drive that has less than this amount of free space available.
The default is 10.

:dt.   G
:dd.Maximum number of guest users.  If you make this smaller than
the value for M (see below), you effectively reserve some
slots for non-guest users.  The default is M-1.

:dt.   L
:dd.User logging option (default 1).
:dl compact.
:dt.         0
:dd.No logging
:dt.         1
:dd.Logging of successful file transfers
:dt.         2
:dd.Logging of successful and unsuccessful file transfers
:dt.         3
:dd.Logging of all users
:edl.
:p.The log is a text file called FTPUSERS.LOG.  You can edit it
or delete it without doing any harm.

:dt.   M
:dd.Maximum number of simultaneous users.  To limit the number
to 12, for example, use the command
.br
             ftpd m12
.br
The default is 10.

:dt.   P
:dd.The server's port number.  To make the server listen on port 5003,
for example, you start the program with the command
.br
             ftpd p5003
.br
The default port number is 21.

:dt.   T
:dd.Timeout limit, i.e. the time before an inactive user is forcibly
removed.  The value is in seconds, and the default is 900.

:edl.

:h2 id=inetd.Running from inetd
:hp2.Running the server from inetd:ehp2.
:p.
Inetd, which is part of the Warp 4 distribution, is a "listener"
program that can intercept incoming connection attempts, and
start up a server when needed.
:p.
The advantage is that FtpServer doesn't actually get loaded into
main memory until a client wants to connect.  Thus, it might be
a good option if you expect clients to connect only occasionally.
:p.
The disadvantage is that a separate copy of the server is
started for each logged-in user.  This makes inetd a bad choice
if you expect lots of connections.
:p.
If you want to run FtpServer from inetd, the way to do it is
as follows:
:ol.
:li.Ensure that inetd will be run the next time you boot.
The usual way of doing this is to include the line
.br
           start /min inetd
.br
in your TCPSTART.CMD, and to invoke TCPSTART.CMD from
your startup folder.  TCPSTART.CMD may be found in the
directory \tcpip\bin.

:li.Edit the file \mptn\etc\inetd.lst so that it contains the line
.br
     ftp tcp start /C /min d&colon.\Apps2\FtpServer\ftpd.exe
.br
(adjusting the path so that it refers to the directory
where you've installed FtpServer).
:eol.

:note.In earlier releases the inetd users had to use a file called ftpd.cmd.
That command file is now obsolete.
:p.
You may also include parameters on the inetd.lst line
that invokes ftpd.exe, subject to the following conditions:
:ol.
:li.The M parameter is useless, because in this mode of
operation the program is handling exactly one user.
:li.The P parameter, if present, will be ignored.  When
running from inetd, you don't get a choice of ports.
:eol.

:p.In principle you can now start inetd.  In practice I've found
that inetd doesn't release ports reliably, so if you already
have inetd running you'll probably have to re-boot.
:p.
Remark: I'm starting to suspect that inetd adds more overhead
than it saves, so I've reverted to not using it on my own
machine.

:h2 id=detached.Running FtpServer detached
:hp2.Running the server as a detached program:ehp2.

:p.If you want to run the server detached, the appropriate command is
.br
       DETACH FTPD
.br
(with parameters, if desired).  Note that a detached program
does not have any way of doing screen output or keyboard input,
so you can't get any screen messages in this case.  Nor can you use
the keyboard G and Q commands.

:p.Although you can't shut down the server from the keyboard in this
case, you can still shut it down by using the
:link reftype=hd refid=SITE.SITE MNGR:elink. commands.

:h2 id=welcome.Welcome messages
:hp2.Welcome messages:ehp2.

:p.If you want to give a message to users when they log in, put a
plain text file called WELCOME.MSG or WELCOME2.MSG in the same directory as ftpd.exe.
WELCOME.MSG, if present, is displayed to the user when the initial connection
is made.  WELCOME2.MSG, if present, is displayed to the user after the username
and password have been accepted.  To avoid confusion, you should probably choose
to have only one of these two options.

:p.You can also put a text file called DIR.MSG in any user directory.
Users will get this message the first time they go to that directory.

:p.There is a limited form of macro expansion available in these message
files.  The following macros may be included.
:dl.
:dt.    %m
:dd.Expands to a character string giving the maximum allowed number of users
with the current username.
:dt.    %M
:dd.Expands to a character string giving the global maximum allowed number of users.
:dt.    %t
:dd.Expands to a string giving the local time.
:dt.    %T
:dd.For now, this is the same as %t.
:dt.    %u
:dd.Expands to a string giving a user number within this user's group.
:dt.    %U
:dd.Expands to a string giving this user's global user number.
:dt.    %%
:dd.The '%' character.
:edl.

:h2 id=SITE.The SITE commands
:hp2.The SITE commands:ehp2.

:p.:hp2.The SITE PERM command:ehp2.

:p.The command SITE PERM returns a three-character string showing whether
you have read, write, and/or delete permission for the current directory.
(This command was added while I was testing a new feature.  It might be
withdrawn in future versions, because it's not particularly useful for
most users.)

:p.:hp2.The SITE MNGR commands:ehp2.

:p.Commands in this group may be used only from a manager account.
Currently the following options are available.

:dl break=all.
:dt.SITE MNGR EXIT
:dd.Shuts down the server.  (Don't do this unless you really mean it!)
:dt.SITE MNGR GXIT
:dd.Shuts down the server after the current users have logged out - i.e.
the same action as for the keyboard G command.
:dt.SITE MNGR KILL nnn
:dd.Forcibly logs out user number nnn. The number must match the one
returned by the SITE MNGR LIST command.
:dt.SITE MNGR LIST
:dd.Returns a list of currently logged-in users. The main purpose of this
command is to support the Monitor utility.
:edl.

.***********************************
.*   THE MONITOR UTILITY
.***********************************

:h1.The Monitor utility
:hp2.The Monitor utility:ehp2.
:p.
The program MONITOR.EXE allows the system manager to see who is currently
logged in, and to kill sessions where necessary.  This program can be run
either on the same machine as the server, or remotely.
:p.
When you start the program, it attempts to connect to the server.  If it
fails to establish a connection, this might mean that the server is not
running.  Alternatively, it might mean that you are attempting to connect
to the wrong machine, or to the right machine with the wrong manager account.
In the latter case, see the instructions for
:link reftype=hd refid=monitorsetup.Setting up the Monitor parameters:elink..
:p.
To kill a client session, use the cursor up/down keys to get to the desired
session, and then type the K key.
:p.
To shut down the server, type Ctrl/K.  (Hold down the Ctrl key while
typing K.)  You will be asked to confirm the shutdown by typing either
G (for a gradual shutdown) or Q (for a quick shutdown).
:p.
To close the Monitor program, type the X key.
:p.
:note text='Hint:'.If you want to use less screen space, issue the command
.br
         MODE CO80,10
.br
before running Monitor.exe.

:h2 id=monitorsetup.Setting up the Monitor parameters
:hp2.Setting up the Monitor parameters:ehp2.
:p.
When running MONITOR.EXE, typing S on the keyboard takes you to the setup screen.
There you will see four fields that have to be filled in.
:dl break=all.
:dt.  Server hostname
:dd.This specifies the machine on which the server is running, for example
mymachine.here.net.  If the machine has a fixed IP address, you can avoid a
nameserver lookup by specifying a numeric address, for example 123.45.67.89
:dt.  Server port
:dd.This should normally be 21, but you might have set up the server to accept
connections from a non-standard port.
:dt.  User name
:dd.This must be the username for a manager account.
:dt.  Password
:dd.The password for the manager account.
:edl.
:p.When you've finished filling in these details, press the Esc key to return to
the Monitor main screen.

:h1 id=loadstore.The LoadPRM and StorePRM utilities
:hp2.The LoadPRM utility:ehp2.
:p.
This utility is needed if you want to manually edit user permission files.
It copies information from a PRM file into the server's FTPD.INI.  For
example, the command
:xmp.       loadprm example
:exmp.
:p.takes the information in the file EXAMPLE.PRM and creates or updates an
entry in the INI file for a user called "example".

:p.Wildcards are permitted. To load the information from :hp3.all:ehp3.
the PRM files in the current directory, use the command
:xmp.       loadprm *
:exmp.

:p.You do not have to restart the server. The updated user information will
take effect the next time a user logs in.

:p.:hp2.The StorePRM utility:ehp2.
:p.
This utility creates a PRM file by copying the user information from
FTPD.INI. You would use it if the INI file already contains user data
that you want to edit manually. For example, the command
:xmp.       storeprm example
:exmp.
:p.takes the information in the INI file for the user called "example",
and uses it to create a file EXAMPLE.PRM. (If EXAMPLE.PRM already exists,
the original copy is renamed EXAMPLE.BAK.)

:p.Wildcards are permitted. To create PRM files for :hp3.all:ehp3.
the existing users, use the command
:xmp.       storeprm *

:exmp.

.***********************************
.*   DEVELOPMENT NOTES
.***********************************

:h1.Development notes

:ul.
:li.:link reftype=hd refid=tools.Development tools:elink.
:li.:link reftype=hd refid=whyM2.Why Modula-2?:elink.
:li.:link reftype=hd refid=bugs.Known bugs:elink.
:li.:link reftype=hd refid=unresolved.Unresolved issues:elink.
:li.:link reftype=hd refid=reporting.Reporting errors:elink.
:li.:link reftype=hd refid=Y2K.Year 2000 compliance:elink.
:eul.

:h2 id=tools.Development tools
:hp2.Development tools:ehp2.

:p.Some people have asked about the compiler I'm using.  (I guess a
lot of people didn't realise that there were Modula-2 compilers
for OS/2.)  It's XDS Modula-2, OS/2 native mode version.

You can find out about this, and other Modula-2 compilers for OS/2,
at the web page
.br
     http&colon.//www.ee.newcastle.edu.au/users/staff/peter/os2/os2m2.html
.br
(I'm getting a little behind on keeping my web pages up to date,
but the information is still basically correct, only the version
numbers have changed.)
:p.The XDS home page is at
.br
      http&colon.//www.xds.ru/
.br
This is well worth visiting, because the XDS development team often
has "try before you buy" versions of their compilers available for download.
:p.
FtpServer uses some of the modules from the PMOS/2 library.
If you want to know more about PMOS/2, you'll also find that on
my web pages.  Source code is available.  My web pages are at
http&colon.//www.ee.newcastle.edu.au/users/staff/peter/Moylan.html.
:p.
This documentation was prepared with IBM's IPFC help compiler.

:h2 id=whyM2.Why Modula-2?
:hp2.Why Modula-2?:ehp2.
:p.
I'm often asked why I chose to code FtpServer in Modula-2.  Everyone
else seems to be using C or C++, so why don't I?
:p.
The short answer is that I don't think much of the "everyone else uses it"
argument.  If popularity was more important to me than technical merit,
I wouldn't be using OS/2.
:p.
The long answer is contained in a document called "The Case Against C",
which used to be found at ftp&colon.//ee.newcastle.edu.au/.  This server
is temporarily unavailable at present, so I'll try to find a new home
for the document.
:p.
And the medium-length answer is on this page.
:p.
To begin with, run-time efficiency is not as big an issue as most people
seem to think it is.  With modern compiler technology, the main programming
languages (apart from things like BASIC and its derivatives) give about
the same run-time efficiency.  C and C++ lose out a little because their
low-level constructs make it hard for the compiler to do a good job at
optimisation; the figures I've seen tend to suggest that a program written in
Modula-2 runs a little faster than the same program written in C or C++.
However, the difference is typically less than 5%, and hardly worth worrying
about.
:p.
So the big issue is development efficiency.  For a job like this we can
rule out languages like BASIC and REXX because they're a little too crude;
and we can rule out languages like Fortran because of their poor support
for "systems programming" tasks.  We can also rule out a host of lesser-known
languages because of the unavailability of OS/2 compilers.  That leaves us
with Pascal, Ada, Oberon, Modula-2, C, and C++.
:p.
I don't use Pascal because Modula-2 is basically an upgraded Pascal, and I
might as well use the improved version.
:p.
I haven't looked into the availability of Ada compilers for OS/2; but in any
case I don't like Ada because of its complexity.  The bigger a language is,
the more things there are to go wrong.
:p.
Oberon is a more subjective matter.  Some people will tell you that Oberon
is the successor to Modula-2, and is a superior programming language.  My
personal opinion is that Oberon has deleted some of the features that make
Modula-2 a good language.  I agree, however, that this issue is not entirely
clear-cut.
:p.
That brings us to C and C++.  I've done a lot of C and C++ programming over
the years, and it's left me with the feeling that those languages are major
barriers to programming efficiency.  It takes me roughly twice the time
to get a C or C++ program working as it does to get a comparable Modula-2
program working.  (On some projects I've kept logs to verify this.)  The
coding time is roughly the same, but there's a major difference in
debugging time.  Everyone I know writes buggy software in C and C++, and
then they take forever trying to track down the bugs.  Some developers
give up, and sell the software with the bugs still included.
:p.
There are two main reasons why C software is so bug-prone.
:ol.
:li.Lack of type safety.  C is designed in such a way that the compiler can't
do much error checking, so the compiler gives no warnings for things that, in
a type-safe language, would be reported as errors at compile time.  You don't
see the errors until execution time, and then you're left wondering what caused
the error.
:li.Poor support for modular programming.  You can break up a C program into
modules, but they're not truly independent of one another.  A slight change
in one module can have catastrophic effects on other modules.  Once a project
grows moderately large, you lose control of your own code.
:eol.
:p.
C++ is a little better in these two respects, but C++ has problems of its own.
The language designers tried to graft high-level features onto a low-level
language, and the result is a mass of inconsistency.  A C++ reference manual
is typically several times as thick as manuals for other programming languages,
because every rule has a maze of exceptions and special cases.
:p.
In addition, I've noticed that a lot of C++ programmers seem to have
adopted the philosophy of "let's try this, and hope that it works".  The notion
that you shouldn't write code that you don't understand seems to have become
unfashionable.  Maybe that's the fault of the language (and its libraries),
maybe not.  In any case, it's not the way I prefer to work.
:p.
Ultimately, the reason I use Modula-2 is that it lets me get applications
working quickly, it gives me control of large projects, and it doesn't force
me to spend huge amounts of time on debugging.  I'm too old to enjoy the
thrill of tracking down obscure bugs.  I like to get something working, and
then be free to move on to other projects.
:p.
Of course, it's difficult to guarantee that any piece of software is bug-free,
no matter what development tools you use.  But I can have the next-best
thing, which is an acceptably small error rate.

:h2 id=bugs.Known bugs
KNOWN BUGS IN SERVER

:ul.

:li.Server shutdown does not work correctly when using
version 4.02k of the TCP/IP stack, although it does work with
earlier versions.  Other information I've received seems to
indicate that *ALL* server applications misbehave with
version 4.02k, so it looks as if the fault lies in the
TCP/IP implementation.
I have fixed the problem for version 4.02o, but the fix might
not work with 4.02k - my impression is that versions between
k and o are seriously buggy.

:li.Uploads not accepted if your free disk space is greater than
about 4000 gigabytes.  There doesn't seem to be any urgent
need to fix this just yet, but at the rate disk sizes
are growing ...

:eul.

:p.See also :link reftype=hd refid=unresolved.Unresolved issues:elink.

:h2 id=unresolved.Unresolved issues
:hp2.Unresolved issues:ehp2.

:p.These are problems that various people have reported, but which
I haven't been able to duplicate. I'd be interested in hearing from
anyone who can confirm either that the problem really exists, or that
it's now fixed.
:p.
:ul.

:li.Reported: the server can be crashed by a client running JavaScript.
This problem is still a mystery to me, I haven't been able to track down
what's going on.

:eul.

:h2 id=Y2K.Year 2000 compliance
:hp2.Year 2000 compliance:ehp2.

:p.According to my tests, FtpServer should continue running correctly
until 31 December 2079.  (It might also continue working after that;
but the OS/2 system clock will not allow me to set the date to
2080 or later.)  This assumes that you are using HPFS disks.

:p.Systems using the FAT file system will stop working in 2038.
This has nothing to do with FtpServer; it's a fundamental limitation
of FAT.

:h2 id=reporting.Reporting errors

:p.If you find any error that's not mentioned
in this document, please report it to peter@ee.newcastle.edu.au.  The
following information would be useful in tracking down the cause of
the error:
:ul.
:li.The version number of the version you are using.
:li.The file errinfo.$$$, if it exists.
:li.Some information about what the server was doing at the time the
problem occurred; for example, the last few lines of the transaction log.
:eul.

:euserdoc.

