/* ICEFX.CMD: mr2ice filter export utility - jt Sept 1997 */
/* new (mr2i 1.34) filter format; fif level 1.34 */
/* new more readable FIF format */

call RxFuncAdd 'SysLoadFuncs','RexxUtil','SysLoadFuncs'
call SysLoadFuncs
arg outfile fltfile .

proglev= 0.6
fiflev="1.35nf1"
indelim='01'x
wid=40

say 'ICEFX level' proglev 'creating fiflevel' fiflev
/* based on doc from Nick in filter.doc  */
if outfile='' then do
   say 'Usage is ICEFX outfile [infile]'
   say ''
   say 'Run this program in the directory that contains your mr2i.flt'
   say 'file (even if you explicitly specify a different infile).'
   say ''
   say 'If infile is not present, mr2i.flt is used as input.  The'
   say 'extension .fif [Filter Interchange Format] is reccommended for'
   say 'outfile.  This program reads <infile> and the folder index'
   say 'file (either folder.ndx or mail\folder.ndx; converts each'
   say 'filter entry to interchange format and writes to <outfile>.'
   say 'The folder index file entries contain both the folder'
   say 'directory and the name of the folder (as read from the'
   say 'folder.ndx file); interchange files identify folders by name'
   say '(the raw filter file identifies them by directory name).  A'
   say 'fair amount of checking is done to ensure that the filter'
   say 'item is legal.'
   exit 
  end

fld. = ''

if outfile="MR2I.FLT" then do
   say "You don't really want to clobber mr2i.flt, do you?"
   say 'Usage is ICEFX OUTFILE [filterfile]'
   say 'Please respecify.'
   exit
   end

call readndx  /* read ndx reads the folder.ndx file and sets names */
              /* into fld.F003 etc. */

if fltfile = '' then filterfile='mr2i.flt'
   else filterfile=fltfile
signal on notready
which = filterfile
if lines(filterfile) = 0 then signal notready
firstlin=linein(filterfile)  /* to determine indelim */
call lineout(filterfile)   /* close file */
which = ''
xx=pos(indelim,firstlin)
xx=pos(indelim,firstlin,xx+1)
yy=pos('\',firstlin)
yy=pos('\',firstlin,yy+1)
if xx=0 then indelim='\'
if (xx=0) & (yy=0) then do
   say filterfile 'does not appear to be in MR2I.FLT file format'
   exit
   end

infile = filterfile
if stream(outfile,C,QUERY EXISTS) > '' then do 
   say 'output file' outfile 'exists'
   say 'press enter to delete and rewrite it'
   say 'enter X to quit'
   say 'enter anything else to append to' outfile
   pull q
   select
      when q='' then '@del' outfile '> NUL'
      when translate(q)='X' then exit
      otherwise ;
      end /*select */
   end /* outfile exists */
/* set up search type literal descriptors */
sx.0='From'
sx.1='To'
sx.2='Subject'
sx.3='Header'
sx.4='Body'
sx.5='UUencoded'
sx.6='MIME'
sx.7='BinHex'
sx.8='MsgSize'
sx.9='MsgLines'

/* flag text variables */
/* watch out for single letter variables! */

txf1.I='Inbound'
txf1.O='Outbound'
txf1.B='Both (In and Out)'
txf1.S='PreSend'
txf1.T='ToOutbox'
txf1.F='PreFetch'
txf1.D='OnDemand'

txf2.F='Freeform'
txf2.R='Rexx'
txf2.P='Special'
txf2.S='Simple'

txf3.N='NoMatch'
txf3.A='Always'
txf3.M='Match'

txf13.N='No delete'
txf13n.N='Get message'
txf13.A='Delete AFTER other filters'
txf13n.A='Get header'
txf13.Y='Delete NOW'
txf13n.Y='Delete header now'

txf14.M='Filter Mail only'
txf14.N='Filter NEWS only'
txf14.B='Filter Mail and News'

lineno=0
do while lines(infile)
   line = linein(infile)
   lineno=lineno+1
   errmsg = ''
   f. = '\\\\'
   ff13. = indelim
   residue = line
   do ii=1 to 13
      parse var residue f.ii (indelim) residue 
      end

   ff13.14='M'  /* in case it's not there */
   do ii=1 to length(f.13)
      ff13.ii = substr(f.13,ii,1)
      end

   ok=checker()
   if ok then call process
      else do
         say f.1 f.2 errmsg
         end
   end /* processing of line */
call lineout outfile,'---------- END end_of_last_Filter  ----------'
call lineout(outfile)   /* close output file */
say "all done"
exit

checker:
/* enough fields ? */
if f.13 = '\\\\' then do
   errmsg='not enough fields'
   return 0
   end
/* enabled sw; description */
enabled=substr(f.1,1,1)
if pos(enabled,'+-')=0 then do
   errmsg = 'enabled flag must be + or -'
   return 0
   end
/* search mode check */
if ((f.3<>'')&(datatype(f.3)='CHAR'))|((f.3)>1023) then do
   errmsg = 'bad search type numeric value field 3'
   return 0
   end
/* flags check */
if (length(f.13)<13) | (length(f.13)>14) then do
   errmsg = 'flags field wrong length shld be 13 or 14'
   return 0
   end
if pos(ff13.1,'IOBSTFD')=0 then do
   errmsg = 'bad filter type flag 13.1'
   return 0
   end
if pos(ff13.2,'FRPS')=0 then do
   errmsg = 'bad search type flag 13.2'
   return 0
   end
if pos(ff13.3,'NAM')=0 then do
   errmsg = 'bad match type flag 13.3'
   return 0
   end
if pos(ff13.7,'YN')=0 then do
   errmsg = 'bad copy to folder flag 13.7'
   return 0
   end
if pos(ff13.8 ,'YN')=0 then do
   errmsg = 'bad autoreply flag 13.8'
   return 0
   end
if pos(ff13.12,'YN')=0 then do
   errmsg = 'bad link to Rexx flag 13.12'
   return 0
   end
if pos(ff13.13,'YNA')=0 then do
   errmsg = 'bad disposition_is_delete flag 13.13'
   return 0
   end
if pos(ff13.14,'MNB')=0 then do
   errmsg = 'bad mail/news flag 13.14'
   return 0
   end
xx=substr(f.13,5,2) /* 13.4 smartsearch not used but default = Y */
zz=substr(f.13,9,3)
if (xx||zz)<>'NNNNN' then do
   say 'WARNING' f.1 f.2  'unused flags 13.5-6' x 'or 9-11' z 'not all N'
   end
return 1

process:
j=1
if enabled='-' then outline = '"Not enabled"' 
   else outline='"Enabled"'
out.j=left(outline,wid,' ') 'f1.1 1' enabled
j=j+1

outline=left('"Filter description"',wid,' ')
out.j = outline 'f1.2 *' substr(f.1,2);j=j+1

outline=left('"Filter alias"',wid,' ')
out.j = outline 'f2 *' f.2;j=j+1

valu=f.3
sm = ''
do k=9 to 0 by -1
   if valu%(2**k)>0 then do
      sm=sm sx.k
      valu=valu-(2**k)
      end
   end
outline = left('"Search modes::' sm '"',wid,' ')
out.j = outline 'f3 #' f.3
j=j+1

if ff13.2='F' then do 
     outline=left('"Search expression"',wid,' ') 'f4 *'
     call splitter f.4
     end  /* search expression */
     else do 
     outline=left('"Search text"',wid,' ') 'f4 *' 
     call splitter f.4
     end


if length(f.5)>0 then do
   if indelim='\' then f.5=pathsep(f.5)
   out.j=left('"Rexx cmd for criteria search"',wid,' ') 'f5 *' f.5
   j=j+1
   end
if (length(f.6)>0)&(ff13.7='Y')  then do
   folderdir=f.6
   out.j=left('"Folder for copy ::' f.6 '"',wid,' ') 'f6 *' fld.folderdir
   j=j+1
   end
if (length(f.7)>0)&(ff13.8='Y') then do
   out.j=left('"Auto reply template"',wid,' ') 'f7 *' f.7
   j=j+1
   end
if length(f.8)>0 then do
   out.j=left('"Email notify address"',wid,' ') 'f8 *' f.8
   j=j+1
   end
/* link to filter name; not used */
/* if length(f.9)>0 then do 
   if indelim='\' then f.9=pathsep(f.9)
   out.j= left('"Link-to filter name"',wid,' ') 'f9 *' f.9
   j=j+1
   end */
if (length(f.10)>0)&(ff13.12='Y')  then do
   if indelim='\' then f.10=pathsep(f.10)
   out.j=left('"Rexx cmd to call on match"',wid,' ') 'f10 *' f.10 ;j=j+1
   end
if f.11>0 then do
   out.j=left('"Msg size to exceed (bytes)"',wid,' ') 'f11 #' f.11
   j=j+1
   end
if f.12>0 then do
   out.j=left('"Msg size to exceed (lines)"',wid,' ') 'f12 #' f.12
   j=j+1
   end

/* field 13 flags */
q=ff13.1
out.j=left('"Filter type::' txf1.q '"',wid,' ') 'f13.1 1' q;j=j+1
q=ff13.2
out.j=left('"Search type::' txf2.q '"',wid,' ') 'f13.2 1' q;j=j+1
q=ff13.3
out.j=left('"Match type::' txf3.q '"',wid,' ') 'f13.3 1' q;j=j+1
/* 
q=ff13.4 5 6
   out.j=left('"Smart Search (not used)::' txf?.q '"',wid,' ') 'f13.4 1' q;j=j+1
   out.j=left('"Translate (not used)::' txf?.q '"',wid,' ') 'f13.5 1' q;j=j+1
   out.j=left('"Autodetach (not used)::' txf?.q '"',wid,' ') 'f13.6 1' q;j=j+1
*/

if ff13.7 = 'Y' then do
   out.j=left('"Copy to folder"',wid,' ') 'f13.7 1' ff13.7;j=j+1
   end
if ff13.8 = 'Y' then do
   out.j=left('"Autoreply"',wid,' ') 'f13.8 1' ff13.8;j=j+1
   end
/*
  out.j=left('"Notify by email (not used)"',wid,' ') 'f13.9 1' ff13.9;j=j+1
  out.j=left('"Notify by popup (not used)"',wid,' ') 'f13.10 1' ff13.10;j=j+1
  out.j=left('"Link to filter (not used)"',wid,' ') 'f13.11 1' ff13.11;j=j+1
*/
if ff13.12 = 'Y' then do
   out.j=left('"Link to Rexx"',wid,' ') 'f13.12 1' ff13.12;j=j+1
   end

q=ff13.13
if ff13.14='N' then outline=left('"Disposition::' txf13n.q '"',wid,' ')
    else outline=left('"Disposition::' txf13.q '"',wid,' ')
out.j=outline 'f13.13 1' q;j=j+1
q=ff13.14
if q<>'M' then do
   out.j=left('"Mail/news flag::' txf14.q '"',wid,' ') 'f13.14 1' q;j=j+1
   end


call lineout outfile,'---------- Filter' lineno ' FIF-level' fiflev '----------'
do jj=1 to j -1
   call lineout outfile,out.jj
   end
return

readndx:

infile='folders.ndx'  /* for secondary account */
if lines(infile) = 0 then do
   infile = 'mail\folders.ndx'  /* default account */
   if lines(infile)=0 then do
      say "can't find folders.ndx or mail\folders.ndx"
      exit
      end
   end
call lineout(infile)   /* close file */
which = ''

do while lines(infile)
   line = linein(infile)
   parse var line name '' tab '' folder '' rest
   fld.folder=name
   end
return

pathsep: procedure
   parse arg inarg
   z=1
   do until z=0
      z=pos('/',inarg)
      if z>0 then inarg=left(inarg,z-1)||'\'||substr(inarg,z+1)
      end
   return inarg

notready:
say which " file error"
exit

splitter:
  parse arg xpr 
  if length(f.4)<(72-wid) then do
         out.j=outline xpr
	 j=j+1
	 end    /* short expression */
	 else do    /* parse f.4 and put out multiple lines */
	 out.j=outline;j=j+1
	 do while length(xpr)>0
	    ll=min(length(xpr),72)
	    if length(xpr)>ll then do
	         out.j=' '||left(xpr,ll);j=j+1
	         xpr=substr(xpr,ll+1)
		 end
	         else do 
	         out.j=' '||xpr;j=j+1
		 xpr=''
		 end
	    end  /* spitting out pieces */
	 end
   return
	 
