/* ICEFI.cmd:  filter import from interchange format jt Sept 1997 */
/* companion to icefx.cmd; reads its interchange format and rebuilds */
/* lines for mr2i.flt which are written either in a separate file or */
/* appended to the end of mr2i.flt */
/* September 1997 with new FIF format for mr2i 1.34 new filter format */

/* filters are left not enabled  unless a + flag is used */

arg infile rest 

proglev=0.7
fiflev="1.35nf1"
say 'ICEFI program level' proglev '; requires FIF level' fiflev

if infile='' then do
   say 'usage is:  ICEFI  infile [outfile] [+] [-]'
   say ''
   say 'Run this program in the directory that contains your mr2i.flt'
   say 'file (even if you explicitly specify a different outfile).'
   say ''
   say 'If outfile is omitted, lines are appended to mr2i.flt.  If the +'
   say 'switch is not present, filters are left disabled regardless of'
   say 'setting of the enabled flag in the interchange file.  If the + is'
   say 'present, the enabled state is copied from the input.  '
   say 'If folders.ndx or mail\folders.ndx file is found, will try to'
   say 'match folder NAME (not directory) in interchange file and use'
   say 'corresponding folder directory on target system; if no match'
   say 'found you will be asked to select a folder directory for this'
   say 'case [and optionally, any subsequent cases where there is no'
   say 'folder name match].'
   say ''
   say 'Unless the - switch is present, the output will be in 1.34 and later'
   say 'filterfile format.'
   say 'If the - switch is present, output will be in old format.'
   exit
  end

fieldsep='01'x
lpiece=72       /* set in icefx */
enable=0
old=0
outfile='mr2i.flt'
if length(rest)>0 then do
  parse var rest a b
  if pos(left(a,1),'-+')=0 then parse var rest outfile a b
  if left(a,1)='+' then enable=1 
  if left(b,1)='+' then enable=1
  if left(b,1)='-' then old=1
  if left(a,1)='-' then old=1
  if a='+-' then old=1
  end

if old=1 then fieldsep='\'

fldnam.=''
flddir.=''

call readndx
folderask=''

signal on notready
which = infile
if lines(infile) = 0 then signal notready
call lineout(infile)   /* close file */
which = ''

line=linein(infile)  /* the delimiter is the last line read by process */
parse var line x x filtno x iflev x  /* for error messages */
if fiflev <> iflev then do
   say 'FIF level mismatch.  Input file' infile 'was level' iflev
   say 'This version of the program requires level' fiflev
   call lineout infile  /* close it */
   exit
   end

do while lines(infile)
   if substr(line,1,10)='----------' then do
        call process
        parse var line x x filtno x iflev x  /* for error messages */
	end
   else do
      say 'last filter completely processed was number' filtno-1
      say 'lost place in input file; last line read:'
      say line
      /* close files */
      call lineout infile
      call lineout outfile
      exit
      end
   end
/* close files */
call lineout infile
call lineout outfile
say 'ICEFI done'
exit

finit:
/* init the templates for the output filter line */
f.=''
ff.=''
ff.4='Y'
ff.14='M'
do i=5 to 12
   ff.i='N'
   end
return /* finit */

process:
call finit   /* init the template for the output filter */
enflag=''
do while lines(infile)
   line = linein(infile)
   if substr(line,1,10)='----------' then do
      /* assemble check and output */
      if checkit() then call writeit
      else do 
         say 'error[s] in processing filter number' filtno
         say 'not written'
	 say 'fiflevel of input filter was ' fiflev
	 end
      return
      end
   /* parse for "xxx " field size value  */
   parse var line '"' text '"' field size value
   select
      when field='f1.1' then enflag=value
      when field='f1.2' then do
          if enable then f.1=enflag||value
          else f.1='-'||value
          end
      when (field='f5') & (old=1)  then do
         value=pathsep(value)
	 f.5=value
         end
      when (field='f10') & (old=1)  then do
         value=pathsep(value)
	 f.10=value
         end
      when field='f4' then do
         /* new split format for search text */
	 eloop=0
	 if value='' then do until eloop>0
	      nxx=stream(infile,'c','seek +0')
	      l2=linein(infile)
	      if left(l2,1)<>' ' then do
	          /* we are done; back out the line */
		  njunk=stream(infile,'c','seek =' nxx)
		  eloop=1
		  f.4=strip(value,'T')
		  end   /* backout and quit */
              else do 
	          l2= substr(l2,2,lpiece,' ')
		  /* we pad it out in case trailing blanks got lost
		  somewhere... */
	          value=value||l2
		  end
	      end /* multiline value */
	 else f.4=value
	 end  /* f4 */
      when field='f6' then do
      /* rework for new format here */
         do until f.6<>''
            f.6= folderfix()
	    end /* do until */
	 end /* f6 */
      when substr(field,1,4)='f13.' then do
         /* process f13.# lines */
         parse var field . '.' subfield .
	 ff.subfield=substr(value,1,1)
	 end
      otherwise do
         fieldno=substr(field,2)
         f.fieldno=value
         end
      end /* select */
   end /* end of infile */
say 'premature end of input file in filter number' filtno
say 'last line read:'
say line
return /* abend process */

checkit:
   rv=1
   if old=1 then do
      if pos('\',f.1) + pos('\',f.2) + pos('\',f.4) >0 then do
         say 'Backslash in f.1 f.2 or f.4 not allowed in old format'
	 rv=0
	 end
      end
   /* f1 */   
   if (pos(enflag,'+-')=0)|(length(f.1)<2) then do
      say 'bad input enabled flag or filter name'
      rv=0
      end
   /* f2 */ 
   if length(f.2)=0 then do
      say 'filter alias field f.2 missing in input'
      rv=0
      end
   if (datatype(f.3)=char)|(f.3<1)|(f.3>1023) then do
      say 'search mode field not numeric or out of range'
      rv=0
      end
   /* needs to be dependent on old/new format !! */
   if pos('\',f.4)>0 then do
      say 'search expression field contains one or more \ characters'
      rv=0
      end
   if ((ff.2='S')&(length(f.4)>80))|((ff.2='F')&(length(f.4)>1024)) then do
       say 'Search expression too long'
       rv=0
       end
   if (ff.2='R')&(f.5='') then do
      say 'Rexx search specified but no command name f.5 present'
      rv=0
      end
   if (ff.7='Y')&(f.6='') then do
      say 'Copy to folder flag specified but no folder f.6 present'
      rv=0
      end
   if (ff.8='Y')&(f.7='') then do
      say 'Autoreply flag specified but no autoreply template f.7'
      rv=0
      end
   if (ff.12='Y')&(f.10='') then do
      say 'Link to rexx on match flag specified but no cmd file f.10'
      rv=0
      end
   if pos(ff.1,'IOBSTDF')=0 then do
      say 'filter type flag invalid value'
      rv=0
      end
   if pos(ff.2,'FRPS')=0 then do
      say 'search type flag invalid value'
      rv=0
      end
   if pos(ff.3,'NAM')=0 then do
      say 'match type flag invalid value'
      rv=0
      end
   if pos(ff.13,'YNA')=0 then do
      say 'Disposition is delete flag invalid value'
      rv=0
      end
   do i=4 to 9
      if pos(ff.i,'YN')=0 then do
         say 'flag' i 'invalid value; not Y or N'
         rv=0
         end
      end /* 4 to 9 */
   if pos(ff.10,'YNV')=0 then do
         say 'flag 10 invalid value; not Y N or V'
         rv=0
         end
   do i=11 to 12
      if pos(ff.i,'YN')=0 then do
         say 'flag' i 'invalid value; not Y or N'
         rv=0
         end
      end /* 11 to 12 */
   return rv

writeit:
   outline=''
   do i=1 to 12 
      outline=outline||f.i||fieldsep
      end
   do i=1 to 14
      outline=outline||ff.i
      end
   call lineout outfile,outline
   return

readndx: procedure expose fldnam. flddir. 
/* reads in the folders.ndx file and sets 2 arrays for lookup */

infile = 'folders.ndx'  /* same directory for a 2ndary acct */
if lines(infile) = 0 then do
   infile='mail\folders.ndx'  /* look in mail if default acct */
   if lines(infile)=0 then do
      say "can't find folders.ndx or mail\folders.ndx"
      exit
      end
   end
call lineout(infile)   /* close file */
which = ''
lineno=0

do while lines(infile)
   line = linein(infile)
   lineno=lineno+1
   parse var line name '' tab '' folder '' rest
   fldnam.lineno=name
   flddir.lineno=folder
   end
fldnam.0=lineno
return  /* readndx */

folderfix:
/* we have an f6 line parsed out.  value is a folder name */
/* let's see if it exists locally; if so we will set value */
/* to the folder directory on this system for which the name matches. */
/* if no match, get a folder to use; ask whether for once */
/* or all subsequent cases of no match */
/* we are working on filter number filtno */
hit=0
search=translate(value)  /* will use case-insensitive match */
do jj=1 to fldnam.0
  if search=translate(fldnam.jj) then do
     hit=1
     return flddir.jj
     end
   if hit=1 then leave
   end  /* loop through tables */
if hit=1 then return
if folderask<>'' then do
   say 'filter' filtno 'specified folder name' value
   say 'using fallback folder' folderask fallbackname
   return folderask
   end
/* we need to ask for the fallback folder value */
say 'filter ' filtno 'specifies folder name' value
say 'which does not match any of your folder names'
say 'pick a folder to use for this filter'
done=0
do jk=1 to fldnam.0
   say jk fldnam.jk flddir.jk
   if jk=fldnam.0 then do
      done=1
      end
   if  done | (jk//15)=0 then do
       say 'enter a number or press enter to see more choices'
       pull xxx
       if xxx<>'' then do
          folderans=flddir.xxx
	  fallbackname=fldnam.xxx
	  say 'Do you want to use this folder for any subsequent mismatches?'
	  do until pos(xxy,'YN')>0
	     say 'Enter Y[es] or N[o]'
	     pull xxx
	     xxy=translate(substr(xxx,1))
	     end
	  if xxy='Y' then  folderask=folderans
	  return folderans
	  end
       end
   end jk
if folderask='' then do
   say '07'X 'you must specify a folder; try again'
   return ''
   end
/* end folderfix */


pathsep: procedure
   parse arg inarg
   z=1
   do until z=0
      z=pos('\',inarg)
      if z>0 then inarg=left(inarg,z-1)||'/'||substr(inarg,z+1)
      end
   return inarg

notready:
say which " file error"
exit
