/*  IDENTC.CMD ver 1.0 (1-19-1994)
      REXX Program to Request a User ID for Identication
        by R L Samuell  (samuell@cis.uab.edu)
*/

PARSE ARG server, serverport, clientport .; endline = d2c(13) || d2c(10);
port = 113; verbose = 1 /* is OFF */;
IF RxFuncQuery('SockLoadFuncs') THEN DO;
rc = RxFuncAdd('SockLoadFuncs', 'RxSock', 'SockLoadFuncs');
rc = SockLoadFuncs(); END;
socket = SockSocket('AF_INET', 'SOCK_STREAM', 0); IF (socket = -1) THEN DO;
IF verbose THEN; SAY 'IDENTC: Socket OPEN error: 'errno' !'; EXIT *1; END;
server.!family = 'AF_INET'; server.!port   = port; server.!addr   = server;
rc = SockConnect(socket, 'server.!'); IF (rc = -1) THEN DO;
IF verbose THEN; SAY 'IDENTC: Socket CONNECT error: 'errno' !';
rc = SockSoClose(socket); EXIT 2; END;
data = serverport',' clientport || endline; rc = SockSend(socket, data);
IF (rc = -1) THEN DO; IF verbose THEN;
SAY 'IDENTC: Socket SEND error: 'errno' !'; rc = SockSoClose(socket);
EXIT 3; END; IF (rc <= 0) THEN DO; IF verbose THEN;
SAY 'IDENTC: Connection closed by server !'; rc = SockSoClose(socket);
EXIT 4; END; rc = SockRecv(socket, 'data', 8000); IF (rc = -1) THEN DO;
IF verbose THEN; SAY 'IDENTC: Socket RECEIVE error: 'errno' !';
rc = SockSoClose(socket); EXIT 5; END; rc = SockSend(socket, 'quit');
rc = SockSoClose(socket); IF verbose THEN; SAY data;
PARSE VAR data portpair ':' replytype ':' reply;
IF (replytype = 'USERID') THEN DO; PARSE VAR reply opsys ':' userid;
report = STRIP(TRANSLATE(userid, '  ', endline)); END;
IF (replytype = 'ERROR') THEN; report = TRANSLATE(reply, '  ', endline);
RETURN report

