/*  FINGERD.CMD ver 1.1 (5/28/1994)
      REXX Program to Service FINGER Requests (FINGER Server)
        by R L Samuell  (samuell@cis.uab.edu)

      NOTE: -- FINGERD.CMD requires OS/2 2.0 GA or later, TCPIP 1.2.1
                  with April 1993 CSDs or later, and the latest version of
                  the RxSock IBM EWS Freeware package.

      NOTICE -- COPYRIGHT 1993, 1994 by Robert L. Samuell, III
              -- All Rights Reserved.  Publication of this document in
                    whole or in part in any form, electronic or printed,
                    in any forum, public or private, is expressly prohibited
                    without the explicit permission of the author.
              -- The latest version of documentation for FINGERD may obtained
                    from URL gopher://twinbrook.cis.uab.edu/1FINGERD.70

      LICENSE -- TERMS and CONDITIONS
              -- You are not allowed to modify any portion of this program
                    other than the values of variables defined in the section
                    entitled 'Parameterize.'
              -- This program is available for you to use free of charge.
              -- Any distribution of this program must include both program
                    and documentation, in the latest versions, unchanged.
              -- Commercial sale or re-sale of this program is allowed only
                    with the approval of the author.
              -- DISCLAIMER: No warranties or guarantees are expressed or 
                    implied.  And the author assumes no liability for ANY damage
                    or loss whatsoever arising from the use of this program.
                    Furthermore, the author is under no obligation to provide
                    support of any kind.  This disclaimer applies to any support
                    that is provided.
              -- ACCEPTANCE:  By using or distributing this program, you 
                    agree to these terms.
*/

PARSE ARG switches

SAY 'FINGERD:  A FINGER Server for OS/2'
SAY 'NOTICE -- COPYRIGHT 1993, 1994 by Robert L. Samuell, III'

/* Parameterize -- ATTENTION:  
      Only values of the following code variables may be modified by the user. */

fpath = 'C:\FINGER\'
password = ''  /* NOTE:  must be 0 or 6 characters & alphas must be upper */

allow = 0; bheading = 0; bhfile = fpath'HEADING.BUL'; blank = D2C(32);
bonly = 0; bofile = fpath'ONLY.BUL'; btrailing = 0;
btfile = fpath'TRAILING.BUL'; disallow = 0; endline = D2C(13) || D2C(10);
executing = 0; fver = '1.1'; hostfile = fpath'FINGERD.HST'; identing = 0;
internetd = 0; lastclient = ''; logfile = fpath'FINGERD.LOG'; logging = 0;
mapfile = fpath'FINGERD.MAP'; mapping = 0; notify = 0;
parmfile = fpath'FINGERD.PAR'; port = 79; rcontrol = 0; restricted = 0;
tab = D2C(9); tcount = 0; verbose = 0;
IF RxFuncQuery('SockLoadFunc') THEN DO;
rc = RxFuncAdd('SockLoadFuncs','RxSock','SockLoadFuncs');
rc = SockLoadFuncs(); END; IF DATATYPE(switches, 'W') THEN DO;
ns = switches; switches = ''; internetd = 1; END;
IF access(parmfile, -1) THEN; IF LINES(parmfile) > 0 THEN DO;
parmline = LINEIN(parmfile); switches = parmline switches;
rc = STREAM(parmfile, 'C', 'CLOSE'); END; IF switches <> '' THEN DO;
DO i = 1 TO WORDS(switches); option = TRANSLATE(WORD(switches, i)); SELECT;
WHEN ABBREV('/BHEADING',option) THEN; bheading = 1;
WHEN ABBREV('/BONLY',option) THEN; bonly = 1;
WHEN ABBREV('/BTRAILING',option) THEN; btrailing = 1;
WHEN (option = '/C') & (password <> '')  THEN; rcontrol = 1;
WHEN option = '/I'  THEN; identing = 1; WHEN option = '/L'  THEN;
logging = 1; WHEN option = '/M'  THEN; mapping = 1;
WHEN option = '/N' THEN; notify = 1;
WHEN ABBREV('/RDISALLOW', option) THEN DO; restricted = 1;
disallow = 1 /* listed */; allow = 0; END;
WHEN ABBREV('/RALLOW', option) THEN DO; restricted = 1;
allow = 1 /* listed */; disallow = 0; END; WHEN option = '/V' THEN;
verbose = 1; WHEN option = '/X' THEN; executing = 1; OTHERWISE;
SAY '"'option'" option is not recognized by FINGERD and has been ignored !';
END; END; END; IF restricted THEN DO; IF verbose THEN; IF allow THEN;
SAY 'Only the following hosts allowed...'; ELSE;
SAY 'The following hosts not allowed...'; rlist = '';
IF access(hostfile, -2) THEN DO; DO WHILE LINES(hostfile) > 0;
rline = TRANSLATE(LINEIN(hostfile), blank, tab);
PARSE VAR rline rid (blank) rest; IF verbose THEN; SAY rid;
rlist = rlist || rid || blank; END; rc = STREAM(hostfile, 'C', 'CLOSE');
END; rlist = rlist || 'RHE'; END; SIGNAL ON halt;; IF \internetd THEN DO;
s  = SockSocket('AF_INET','SOCK_STREAM',0); IF (s = -1) THEN DO;
SAY 'SockSocket error: 'errno' !'; endcode = 1; SIGNAL halt2;; END; END;
server.!family = 'AF_INET'; server.!port   = port;
server.!addr   = 'INADDR_ANY'; IF \internetd THEN DO;
rc = SockBind(s,'server.!'); IF (rc = -1) THEN DO;
SAY 'SockBind error: 'errno' !'; endcode = 2; SIGNAL halt2;; END; END;
IF \internetd THEN DO; rc = SockListen(s,10); IF (rc = -1) THEN DO;
SAY 'SockListen error: 'errno' !'; endcode = 3; SIGNAL halt2;; END; END;
SAY 'FINGERD has started...'; IF logging THEN DO;
logentry = DATE('S') TIME('N') 'S' switches;
IF STREAM(logfile, 'C', 'OPEN WRITE') = 'READY:' THEN;
CALL LINEOUT logfile, logentry; ELSE DO; SAY 'Log File OPEN error !';
endcode = -3; SIGNAL halt2;; END; END; DO FOREVER; data = ''; ordered = 0;
tcount = tcount + 1; order = 0;
IF verbose THEN SAY 'FINGERD is waiting for a client.';
IF \internetd THEN DO; ns = SockAccept(s,'client.!'); IF (ns = -1) THEN DO;
SAY 'SockAccept error: 'errno' !'; endcode = 4; SIGNAL halt2;; END; END;
rc = SockGetPeerName(ns,'peer.!'); IF (rc = -1) THEN DO;
SAY 'SockGetPeerName error: 'errno' !'; SAY 'ns='ns; endcode = 5;
IF internetd THEN; SIGNAL halt2;; ELSE DO; CALL handlerror endcode;
ITERATE; END; END; IF verbose THEN SAY 'PeerAddr: 'peer.!addr;
IF SockGetHostByAddr(peer.!addr,'host.!') THEN; clientName = host.!name;
ELSE; clientName = 'Unknown'; userID = 0; IF identing THEN;
userID = IDENTC(peer.!addr, peer.!port, server.!port);
cinfo = peer.!addr clientName userID;
IF verbose THEN SAY 'Accepted client: 'cinfo;
rc = SockRecv(ns,'data',1000); IF (rc = -1) THEN DO;
SAY 'SockRecv error: 'errno' !'; endcode = 7; IF internetd THEN;
SIGNAL halt2;; ELSE DO; CALL handlerror endcode; ITERATE; END; END;
IF verbose THEN SAY 'Received: 'data; IF WORDS(data) > 1 THEN;
IF LENGTH(WORD(data, 1)) < 3 THEN; data = SUBWORD(data, 2); id = '';
reply = ''; DO 1; IF data = endline | LENGTH(data) < 3 THEN DO;
replyfile = fpath'NULL.FNG';
IF executing & access(fpath'NULL.CMD', -4) THEN DO;
rc = STREAM(fpath'NULL.CMD', 'C', 'CLOSE'); ADDRESS CMD;
'@CALL 'fpath'NULL.CMD >FING'tcount; replyfile = 'FING'tcount; END;
code = 'N' /* indicates that no user ID provided */; lastclient = cinfo;
LEAVE; END; i = 1;
DO WHILE (i <= LENGTH(data)) & (SUBSTR(data,i,1) <> D2C(13));
id = id || SUBSTR(data,i,1); i = i + 1; END; id = TRANSLATE(id);
IF LENGTH(id) <= 8 THEN; id2 = id; ELSE; id2 = LEFT(id, 8);
idfile = fpath''id2'.FNG'; xidfile = fpath''id2'.CMD';
IF mapping | LENGTH(id) > 8 THEN; IF access(mapfile, -5) THEN;
IF LINES(mapfile) > 0 THEN DO; DO WHILE LINES(mapfile) > 0;
mapline = LINEIN(mapfile); IF id = WORD(mapline, 1) THEN DO;
IF WORD(mapline, 2) = 'FILE' THEN; idfile = WORD(mapline, 3); ELSE;
xidfile = WORD(mapline, 3); LEAVE; END; END;
rc = STREAM(mapfile, 'C', 'CLOSE'); END; IF access(idfile, -6) THEN;
IF LINES(idfile) > 0 THEN DO; rc = STREAM(idfile, 'C', 'CLOSE');
replyfile = idfile;
code = 'I' /* indicates that a known user ID provided */;
lastclient = cinfo; LEAVE; END;
IF executing & (id <> 'FINGERD') & access(xidfile, -7) THEN DO;
rc = STREAM(xidfile, 'C', 'CLOSE'); ADDRESS CMD;
'CALL' xidfile '>FING'tcount; replyfile = 'FING'tcount;
code = 'X' /* indicates that an executable user ID provided */; LEAVE; END;
IF rcontrol & (LENGTH(id) > 6) & (SUBSTR(id,1,6) = password) THEN DO;
ordered = 1; report = ''; order = SUBSTR(id,7,1); SELECT;
WHEN SUBSTR(id,7,2) = 'BH' THEN; bheading = \bheading;
WHEN SUBSTR(id,7,2) = 'BO' THEN; bonly = \bonly;
WHEN SUBSTR(id,7,2) = 'BT' THEN; btrailing = \btrailing;
WHEN order = 'C' THEN; rcontrol = \rcontrol; WHENorder = 'I' THEN;
identing = \identing; WHEN order = 'L' THEN; logging = \logging;
WHEN order = 'M' THEN; mapping = \mapping; WHEN order = 'N' THEN;
notify = \notify; WHEN order = 'R' THEN DO; IF allow <> disallow THEN;
restricted = \restricted; END; WHEN order = 'V' THEN; verbose =  \verbose;
WHEN order = 'X' THEN; executing = \executing; WHEN order = '1' THEN;
report = tcount; WHEN order = '2' THEN; report = lastclient;
WHEN order = '9' THEN; report = tcount; OTHERWISE; END; replyfile = '';
code = 'C' || order; LEAVE; END; replyfile = fpath'UNKNOWN.FNG';
IF executing & access(fpath'UNKNOWN.CMD', -8) THEN DO;
rc = STREAM(fpath'UNKNOWN.CMD', 'C', 'CLOSE'); ADDRESS CMD;
'CALL 'fpath'UNKNOWN.CMD >FING'tcount; replyfile = 'FING'tcount; END;
code = 'U' /* indicates that no known user ID provided */; END; reply = '';
IF \ordered THEN DO; IF bheading THEN; CALL readin bhfile;
CALL readin replyfile; IF replyfile = 'FING'tcount THEN;
'@ERASE FING'tcount' 2>nul'; IF btrailing THEN; CALL readin btfile; END;
ELSE DO; reply = '/Bh =' bheading || endline;
reply = reply || '/Bo =' bonly || endline;
reply = reply || '/Bt =' btrailing || endline;
reply = reply || '/C =' rcontrol || endline;
reply = reply || '/I =' identing || endline;
reply = reply || '/L =' logging || endline;
reply = reply || '/M =' mapping || endline;
reply = reply || '/N =' notify || endline;
reply = reply || '/R =' restricted allow disallow || endline;
reply = reply || '/V =' verbose || endline;
reply = reply || '/X =' executing || endline;
reply = reply || 'report'order' = 'report; END; IF restricted THEN DO;
rhost = ''; h = 1; DO WHILE rhost <> 'RHE'; rhost = WORD(rlist, h);
IF ABBREV(peer!addr, rhost) THEN; IF disallow & \ordered THEN DO;
reply = 'FINGER not allowed by FINGERD!'; code = code || '+'; LEAVE; END;
ELSE; LEAVE; h = h+1; END; IF (rhost = 'RHE') & allow & \ordered THEN DO;
reply = 'FINGER not allowed by FINGERD!!'; code = code || '-'; END; END;
IF bonly & \ordered THEN DO; reply = ''; CALL readin bofile;
code = code || '!'; END; IF id = 'FINGERD' THEN DO;
reply = 'FINGERD' fver':  A FINGER Server for OS/2' || endline;
reply = reply || 'NOTICE -- COPYRIGHT 1993, 1994 by Robert L. Samuell, III' || endline;
END; rc = SockSend(ns,reply); IF (rc = -1) THEN DO;
SAY 'SockSend error: 'errno' !'; endcode = 8; IF \internetd THEN DO;
CALL handlerror endcode; ITERATE; END; END; IF logging THEN DO;
IF rcontrol & (SUBSTR(id,1,6) = password) THEN; data = '';
logentry = DATE('S') TIME('N') code cinfo data;
CALL LINEOUT logfile, logentry; END; IF notify THEN;
SAY BEEP(600, 200) BEEP(300, 400); rc = SockSoClose(ns); ns = '';
IF (rc = -1) THEN DO; SAY 'SockSoClose error: 'errno' !'; endcode = 10;
SIGNAL halt2;; END; IF verbose THEN DO; SAY 'Closing connection.'; SAY;
END; IF ordered & (order = 9) THEN DO; endcode = 9; SIGNAL halt2;; END;
IF internetd THEN; LEAVE; END; EXIT 0; access:;
PARSE ARG filename, iferror;
IF STREAM(filename, 'C', 'QUERY EXISTS') <> '' THEN;
IF STREAM(filename, 'C', 'OPEN READ') <> 'READY:' THEN DO;
endcode = iferror; SIGNAL halt2;; END; ELSE; RETURN 1; ELSE; RETURN 0;
readin:; PARSE ARG infile; IF \access(infile, -9) THEN DO;
reply = 'FINGERD! No information is available !!!'; RETURN; END;
DO WHILE LINES(infile) > 0; sdata = LINEIN(infile);
reply = reply || sdata || endline; END; rc = STREAM(infile, 'C', 'CLOSE');
RETURN; handlerror:; PARSE ARG errcode; IF DATATYPE(ns,'W') THEN;
rc = SockSoClose(ns); IF logging THEN DO;
logentry = DATE('S') TIME('N') 'E'endcode cinfo data;
CALL LINEOUT logfile, logentry; END; RETURN; halt:; endcode = 0; halt2:;
SAY; SAY 'FINGERD is quitting ...'; IF \internetd THEN;
rc = SockSoClose(s); IF DATATYPE(ns,'W') THEN; rc = SockSoClose(ns);
IF logging THEN DO; logentry = DATE('S') TIME('N') 'E'endcode;
CALL LINEOUT logfile, logentry; rc = STREAM(logfile, 'C', 'CLOSE'); END;
EXIT endcode
