#! /usr/bin/perl -w

# Mail Queue Summary
# Christoph Lameter, 21 May 1997
# Modified by Philip Hazel, June 1997
#
# Usage: mailq | exiqsumm [-a] [-c]
#   Default sorting is by domain name
#   -a sorts by age of oldest message
#   -c sorts by count of message

# Slightly modified sub from eximstats

sub print_volume_rounded {
my($x) = pop @_;
if ($x < 10000)
  {
  return sprintf("%6d", $x);
  }
elsif ($x < 10000000)
  {
  return sprintf("%4dKB", ($x + 512)/1024);
  }
else
  {
  return sprintf("%4dMB", ($x + 512*1024)/(1024*1024));
  }
}

sub s_conv {
  my($x) = @_;
  my($v,$s) = $x =~ /([\d\.]+)(\w)+/;
  if ($s eq "K") { return $v * 1024 };
  if ($s eq "M") { return $v * 1024 * 1024 };
  return $v;
}

sub older {
  my($x1,$x2) = @_;
  my($v1,$s1) = $x1 =~ /(\d+)(\w)/;
  my($v2,$s2) = $x2 =~ /(\d+)(\w)/;
  return $v1 > $v2 if ($s1 eq $s2);
  return ($s2 eq "m") ||
         ($s2 eq "h" && $s1 eq "d") ||
         ($s2 eq "d" && $s1 eq "w");
}

#
# Main Program
#

$sort_by_count = 0;
$sort_by_age = 0;

while (@ARGV > 0 && substr($ARGV[0], 0, 1) eq "-")
  {
  if ($ARGV[0] eq "-a") { $sort_by_age = 1; }
  if ($ARGV[0] eq "-c") { $sort_by_count = 1; }
  shift @ARGV;
  }

while (<>)
{
# Skip already delivered lines

if (/\s*D\s\S+/) { next; }

# If it's the first line of a message, pick out the data. Note: it may
# have text after the final > (e.g. frozen) so don't insist that it ends >.

if (/^([\d\s]{2}\w)\s+(\S+)\s(\S+)\s\<(\S*)\>/)
  {
  ($age,$size,$id)=($1,$2,$3);
  }

# Else check for a recipient line: to handle source-routed addresses, just
# pick off the first domain.

elsif (/^\s+[^@]*\@([\w\d\.\-]*)/)
  {
  $domain = "\L$1";
  $queue{$domain}++;
  $q_oldest{$domain} = $age
    if (!defined $q_oldest{$domain} || &older($age,$q_oldest{$domain}));
  $q_recent{$domain} = $age
    if (!defined $q_recent{$domain} || &older($q_recent{$domain},$age));
  $q_size{$domain} = 0 if (!defined $q_size{$domain});
  $q_size{$domain} += &s_conv($size);
  }
}

print "\nCount  Volume  Oldest  Newest  Domain";
print "\n-----  ------  ------  ------  ------\n\n";

foreach $id (sort
            {
            $sort_by_age? &older($q_oldest{$b}, $q_oldest{$a}) :
            $sort_by_count? ($queue{$b} <=> $queue{$a}) :
            $a cmp $b
            }
            keys %queue)
  {
  printf("%5d  %.6s  %6s  %6s  %.80s\n",
    $queue{$id}, &print_volume_rounded($q_size{$id}), $q_oldest{$id},
    $q_recent{$id}, $id);
  }
print "\n";

# End
