#include "exim.h"

/*************************************************
*     Exim - an Internet mail transport agent    *
*************************************************/

/* Copyright (c) University of Cambridge 1996 */
/* See the file NOTICE for conditions of use and distribution. */

/*************************************************
*          Set up restarting signal              *
*************************************************/

/* This function has the same functionality as the ANSI C signal() function,
except that it arranges that, if the signal happens during a system call, the
system call gets restarted. Different versions of Unix have different defaults,
and different ways of achieving this. If the functionality is not available,
the signal should be set to be ignored. */

/* I don't know, but let's try. */

void
os_restarting_signal(int sig, void (*handler)(int))
{
signal(sig, handler);

/* If neither SA_RESTART nor SV_INTERRUPT is available we don't know how to
set up a restarting signal, so simply suppress the facility. */

/*
signal(sig, SIG_IGN);
*/
}

/***********************************************************
*                   Load average function                  *
***********************************************************/

/* We cannot yet get load averages under OS/2 */

int
os_getloadavg(void)
{
return -1;
}

/***********************************************************
*                open() abs pathname hackage               *
***********************************************************/

DB *os_dbopen(const char *name, int flags, int pmode, DBTYPE type, const void * something)
{
  if ((name[0] == '/') && (name[2] == ':'))
    return dbopen(name + 1, flags, pmode, type, something) ;
  else
    return dbopen(name, flags, pmode, type, something) ;
}

FILE *os_fopen(const char *name, const char *mode)
{
   if ((name[0] == '/') && (name[2] == ':'))
     return fopen(name + 1, mode) ;
   else
     return fopen(name, mode) ;
}

FILE *os_freopen(const char *fname, const char * mode, FILE * stream)
{
   if ((fname[0] == '/') && (fname[2] == ':'))
     return freopen(fname + 1, mode, stream) ;
   else
     return freopen(fname, mode, stream) ;
}

int os_open(const char *name, int oflag, int pmode)
{
   if ((name[0] == '/') && (name[2] == ':'))
     return open(name + 1, oflag, pmode) ;
   else
     return open(name, oflag, pmode) ;
}

int os_rename(const char *old_name, const char *new_name)
{
   const char * old_pass ;
   const char * new_pass ;

   if ((old_name[0] == '/') && (old_name[2] == ':'))
     old_pass = old_name + 1 ;
   else
     old_pass = old_name ;

   if ((new_name[0] == '/') && (new_name[2] == ':'))
     new_pass = new_name + 1 ;
   else
     new_pass = new_name ;

   return rename (old_pass, new_pass) ;
}

int os_unlink(const char * name)
{
   if ((name[0] == '/') && (name[2] == ':'))
     return unlink(name + 1) ;
   else
     return unlink(name) ;
}

/* End of os.c */

