/*************************************************
*     Exim - an Internet mail transport agent    *
*************************************************/

/* Copyright (c) University of Cambridge 1995 - 1997 */
/* See the file NOTICE for conditions of use and distribution. */


/* Source files for exim all #include this header, which drags in everything
that is needed. They don't all need everything, of course, but it's far too
messy to have each one importing its own list, and anyway, most of them need
most of these includes. */

/* modified for OS/2 by Alistair Young, December 1997 */

/* ANSI C standard includes */

#include <ctype.h>
#include <signal.h>
#include <stdarg.h>
#include <stddef.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

/* Unix includes */

#include <errno.h>
#include <limits.h>

#include <sys/types.h>
#include <dirent.h>
#include <netdb.h>

#include <pwd.h>

/* #include <syslog.h> */

#include <sys/time.h>
#include <sys/param.h>
#include <sys/resource.h>
#include <sys/socket.h>
#include <sys/ioctl.h>

#include <sys/sockio.h>

#include <sys/stat.h>
#include <sys/wait.h>
#include <sys/utsname.h>
#include <fcntl.h>

#include <unistd.h>

#include <utime.h>
#include <net/if.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <arpa/nameser.h>

#include <resolv.h>

#include <netinet/in_systm.h>
#include <netinet/ip.h>

#define EX_TEMPFAIL 75

/* The ident.h header defines __P(x) if it is not already defined (for handling
prototypes). Unfortunately, on some systems, db.h (which is included from
Exim's dbfn.h for native Berkeley DB 1.85 use) also defines it, without
checking for a previous definition. This leads to a warning message. However,
on other systems, db.h doesn't define it, expecting it to be done by other
headers. To avoid warnings and nevertheless keep things working in all cases,
we arrange to undefine __P if and only if ident.h defines it. */

#if defined(__P)
#define __P_WAS_DEFINED_BEFORE_IDENT
#endif

#include "libident/ident.h"

#if defined(__P) && ! defined (__P_WAS_DEFINED_BEFORE_IDENT)
#undef __P
#endif

/* If we are on an IPv6 system, the macro AF_INET6 will have been defined in
the sys/socket.h header. It is helpful to have this defined on an IPv4 system
so that it can appear in the code, even if it is never actually used when
the code is run. It saves some #ifdef occurrences. */

#ifndef AF_INET6
#define AF_INET6 24
#endif

#define SELECT_ARG2_TYPE fd_set
#define S_ADDR_TYPE u_long
#define DN_EXPAND_ARG4_TYPE char *


/* The header from the PCRE regex package */

#include "pcre/pcre.h"

/* Exim includes are in several files */

#include "macros.h"
#include "config.h"

#include "dbfn.h"
#include "structs.h"
#include "globals.h"
#include "functions.h"

/* If SPOOL_DIRECTORY, STDERR_FILE, LOG_FILE_PATH or PID_FILE_PATH have not
been defined, set them to the null string. */

#ifndef PID_FILE_PATH
  #define PID_FILE_PATH ""
#endif

/* End of exim.h */
