/*************************************************
*     Exim - an Internet mail transport agent    *
*************************************************/

/* Copyright (c) University of Cambridge 1995 - 1997 */
/* See the file NOTICE for conditions of use and distribution. */


#include "exim.h"


/* Tables of information about which directors, routers and transports are
included in the exim binary. This is controlled by macros defined in the
config.h file. */


/* Pull in the necessary header files */

#include "directors/aliasfile.h"
#include "directors/forwardfile.h"
#include "directors/localuser.h"
#include "directors/smartuser.h"

#include "routers/domainlist.h"
#include "routers/ipliteral.h"
#include "routers/iplookup.h"
#include "routers/lookuphost.h"
#include "routers/queryprogram.h"

#include "transports/appendfile.h"
#include "transports/autoreply.h"
#include "transports/debug.h"
#include "transports/pipe.h"
#include "transports/smtp.h"


/* Now set up the structures, terminated by an entry with a null name. */

director_info directors_available[] = {
  {
  "aliasfile",
  aliasfile_director_entry,
  aliasfile_director_init,
  NULL,    /* no tidyup entry */
  aliasfile_director_options,
  &aliasfile_director_options_count,
  &aliasfile_director_option_defaults,
  sizeof(aliasfile_director_options_block)
  },
  {
  "forwardfile",
  forwardfile_director_entry,
  forwardfile_director_init,
  NULL,    /* no tidyup entry */
  forwardfile_director_options,
  &forwardfile_director_options_count,
  &forwardfile_director_option_defaults,
  sizeof(forwardfile_director_options_block)
  },
  {
  "localuser",
  localuser_director_entry,
  localuser_director_init,
  NULL,    /* no tidyup entry */
  localuser_director_options,
  &localuser_director_options_count,
  &localuser_director_option_defaults,
  sizeof(localuser_director_options_block)
  },
  {
  "smartuser",
  smartuser_director_entry,
  smartuser_director_init,
  NULL,    /* no tidyup entry */
  smartuser_director_options,
  &smartuser_director_options_count,
  &smartuser_director_option_defaults,
  sizeof(smartuser_director_options_block)
  },
{ "", NULL, NULL, NULL, NULL, 0, NULL, 0 }
};



router_info routers_available[] = {
  {
  "domainlist",
  domainlist_router_entry,
  domainlist_router_init,
  NULL,    /* no tidyup entry */
  domainlist_router_options,
  &domainlist_router_options_count,
  &domainlist_router_option_defaults,
  sizeof(domainlist_router_options_block)
  },
  {
  "ipliteral",
  ipliteral_router_entry,
  ipliteral_router_init,
  NULL,    /* no tidyup entry */
  ipliteral_router_options,
  &ipliteral_router_options_count,
  &ipliteral_router_option_defaults,
  sizeof(ipliteral_router_options_block)
  },
  {
  "iplookup",
  iplookup_router_entry,
  iplookup_router_init,
  NULL,    /* no tidyup entry */
  iplookup_router_options,
  &iplookup_router_options_count,
  &iplookup_router_option_defaults,
  sizeof(iplookup_router_options_block)
  },
  {
  "lookuphost",
  lookuphost_router_entry,
  lookuphost_router_init,
  NULL,    /* no tidyup entry */
  lookuphost_router_options,
  &lookuphost_router_options_count,
  &lookuphost_router_option_defaults,
  sizeof(lookuphost_router_options_block)
  },
  {
  "queryprogram",
  queryprogram_router_entry,
  queryprogram_router_init,
  NULL,    /* no tidyup entry */
  queryprogram_router_options,
  &queryprogram_router_options_count,
  &queryprogram_router_option_defaults,
  sizeof(queryprogram_router_options_block)
  },
{ "", NULL, NULL, NULL, NULL, 0, NULL, 0 }
};



transport_info transports_available[] = {
  {
  "appendfile",                                /* driver name */
  appendfile_transport_entry,                  /* main entry point */
  appendfile_transport_init,                   /* init entry point */
  NULL,                                        /* no tidyup entry */
  appendfile_transport_options,                /* local options table */
  &appendfile_transport_options_count,         /* number of entries */
  &appendfile_transport_option_defaults,       /* private options defaults */
  sizeof(appendfile_transport_options_block),  /* size of private block */
  TRUE,                                        /* local flag */
  NULL                                         /* no closedown entry */
  },
  {
  "autoreply",                                 /* driver name */
  autoreply_transport_entry,                   /* main entry point */
  autoreply_transport_init,                    /* init entry point */
  NULL,                                        /* no tidyup entry */
  autoreply_transport_options,                 /* local options table */
  &autoreply_transport_options_count,          /* number of entries */
  &autoreply_transport_option_defaults,        /* private options defaults */
  sizeof(autoreply_transport_options_block),   /* size of private block */
  TRUE,                                        /* local flag */
  NULL                                         /* no closedown entry */
  },
  {
  "debug",                                     /* driver name */
  debug_transport_entry,                       /* main entry point */
  debug_transport_init,                        /* init entry point */
  NULL,                                        /* no tidyup entry */
  debug_transport_options,                     /* local options table */
  &debug_transport_options_count,              /* number of entries */
  &debug_transport_option_defaults,            /* private options defaults */
  sizeof(debug_transport_options_block),       /* size of private block */
  TRUE,                                        /* local flag */
  NULL                                         /* no closedown entry */
  },
  {
  "pipe",                                      /* driver name */
  pipe_transport_entry,                        /* main entry point */
  pipe_transport_init,                         /* init entry point */
  NULL,                                        /* no tidyup entry */
  pipe_transport_options,                      /* local options table */
  &pipe_transport_options_count,               /* number of entries */
  &pipe_transport_option_defaults,             /* private options defaults */
  sizeof(pipe_transport_options_block),        /* size of private block */
  TRUE,                                        /* local flag */
  NULL                                         /* no closedown entry */
  },
  {
  "smtp",                                      /* driver name */
  smtp_transport_entry,                        /* main entry point */
  smtp_transport_init,                         /* init entry point */
  NULL,                                        /* no tidyup entry */
  smtp_transport_options,                      /* local options table */
  &smtp_transport_options_count,               /* number of entries */
  &smtp_transport_option_defaults,             /* private options defaults */
  sizeof(smtp_transport_options_block),        /* size of private block */
  FALSE,                                       /* local flag */
  smtp_transport_closedown                     /* close down passed channel */
  },
{ "", NULL, NULL, NULL, NULL, 0, NULL, 0, FALSE }
};

/* End of drtables.c */
