/*************************************************
*     Exim - an Internet mail transport agent    *
*************************************************/

/* Copyright (c) University of Cambridge 1995 - 1997 */
/* See the file NOTICE for conditions of use and distribution. */

/* Header for the aliasfile director */

/* Structure for the private options. */

typedef struct {
  char *file;
  char *home_dir;
  char *current_dir;
  char *errors_to;
  char *syntax_errors_to;
  int   partial_match;
  int   search_type;
  BOOL  include_domain;
  BOOL  expand;
  BOOL  optional;
  BOOL  forbid_file;
  BOOL  forbid_pipe;
  BOOL  freeze_missing_include;
  BOOL  rewrite;
  BOOL  skip_syntax_errors;
  transport_instance *directory_transport;
  transport_instance *directory2_transport;
  transport_instance *file_transport;
  transport_instance *pipe_transport;
} aliasfile_director_options_block;

/* Data for reading the private options. */

extern optionlist aliasfile_director_options[];
extern int aliasfile_director_options_count;

/* Block containing default values. */

extern aliasfile_director_options_block aliasfile_director_option_defaults;

/* The main and initialization entry points */

extern int aliasfile_director_entry(director_instance *, address_item *,
  address_item **, address_item **, address_item **, address_item **, BOOL);
extern void aliasfile_director_init(director_instance *);

/* End of directors/aliasfile.h */
