/*************************************************
*     Exim - an Internet mail transport agent    *
*************************************************/

/* Copyright (c) University of Cambridge 1995 - 1997 */
/* See the file NOTICE for conditions of use and distribution. */

/* If debug_pid is nonzero, print the pid at the start of each message and add
a newline if there isn't one. This is for tidier output when running parallel
remote deliveries with debugging turned on. Must do the whole thing with a
single printf and flush, as otherwise output may get interleaved. */

#include "exim.h"

void
debug_printf(char *format, ...)
{
va_list ap;
char *ptr;
char buffer[1024];

if (debug_file == NULL) return;
va_start(ap, format);

/* Set up the pid if required */

ptr = buffer;
if (debug_pid > 0)
  {
  sprintf(buffer, "%6d ", (int)debug_pid);
  while(*ptr) ptr++;
  }

/* Use the checked formatting routine to ensure that the buffer
does not overflow. Ensure there's space for a newline at the end. */

if (!string_vformat(ptr, sizeof(buffer) - (ptr - buffer) - 1, format, ap))
  {
  char *s = "**** debug string overflowed buffer ****\n";
  char *p = buffer + (int)strlen(buffer);
  int maxlen = sizeof(buffer) - (int)strlen(s) - 3;
  if (p > buffer + maxlen) p = buffer + maxlen;
  if (p > buffer && p[-1] != '\n') *p++ = '\n';
  strcpy(p, s);
  }

if (debug_pid > 0)
  {
  while(*ptr) ptr++;
  if (ptr > buffer && ptr[-1] != '\n') strcat(ptr, "\n");
  }

fprintf(debug_file, "%s", buffer);
fflush(debug_file);
va_end(ap);
}

/* End of debug.c */
