/* This happy script autoextracts binaries from a number of newsgroups. */

/* Note that it requires John Steven's UNPOST utility. Source is widely */
/* available (consult archie), and a compiled version is available via  */
/* anonymous ftp from elvis.wicat.com (192.150.148.53)                  */

/* It makes several assumptions about directory structure; it is        */
/* assumed that there is a single incoming directory on the current     */
/* drive and that newsgroups are extraced to a series of                */
/* sub-directories under that directory.                                */
/* For instance, on my system, there is a c:\incoming directory, and    */
/* comp.binaries.os2 is extracted to c:\incoming\cbos2.                 */
/*                                                                      */
/* To put this script to your own use:                                  */
/*                                                                      */
/*      1: Set the four user variables defined below in this file to    */
/*         appropiate values. Make sure that any utilities you refrence */
/*         (os2zip, for instance) are on your path, and that any        */
/*         directories (\incoming, for instance) exist.                 */
/*                                                                      */
/*      2: Modify the supplied dumpgrp.cfg file to collect any groups   */
/*         you want and place them in an appropiate sub-directory of    */
/*         the INCOMING directory. Note that if you do not want to      */
/*         modify this script more than necessary, DumpGrp must write   */
/*         each group to a file with the same name as the sub-directory */
/*         and with the .UUE extension. For instance, on my system,     */
/*         DumpGrp writes comp.binaries.os2 to \incoming\cbos2\cbos2.uue*/
/*         Also create these sub-directories.                           */
/*                                                                      */
/*      3: For each sub-directory you created, add a call to the        */
/*         unpostit function after the "extract binaries" comment below.*/
/*                                                                      */
/*      4: If you are not using 4OS/2 or wish to keep zero-length files,*/
/*         remove the calls to the delemptyfiles function. Otherwise,   */
/*         add calls to delemptyfiles for any sub-directories you wish. */
/*                                                                      */
/*      5: Make sure that DUMPGRP.EXE, EXPIRE.EXE, and UNPOST.EXE are   */
/*         all on your path.                                            */
/*                                                                      */
/*      6: Place your modified version of this file and DUMPGRP.CFG in  */
/*         your INCOMING directory.                                     */
/*                                                                      */
/* Now start the script and watch the fun.                              */

/* Copyright 1993 Kevin Vigor.                                          */

/* User variables. */

/* This variable defines the line used to separate messages in the dump */
/* files. If it ever appears in a message, ugly things will result.     */
SEPARATOR = '***Kevins-Unique-Line-Separator-I-Hope***'

/* This variable defines the incoming directory. This is assumed to be  */
/* on the current drive and should *not* include a drive letter.        */
INCOMING = '\incoming'

/* The command line to compress a file.                                 */
/* You can plug in your own utility here. (LHA, ZOO, etc.)              */
COMPRESS = 'os2zip'

/* The command line to decompress a file from an archive.               */
UNCOMPRESS = 'os2unzip -o'

/* The extension produced by the compressor utility.                    */
COMPRESSEDEXT = '.ZIP'

/* User variables end. */

/* Add the SysSleep function. */
call RxFuncAdd 'SysSleep', 'RexxUtil', 'SysSleep'

/* The endless loop. */
make_run:

/* Dump newsgroups. */
"\dumpgrp\dumpgrp -swicat -r -l"SEPARATOR

/* Extract binaries. */
call unpostit "abpm"
call unpostit "cbos2"

/* Delete empty files. */
call delemptyfiles "abpm"

"cd "INCOMING

say 'Going to sleep @ 'TIME()
/* Sleep for an hour. */
call SysSleep 3600

/* Loop forever. */
signal make_run

/* FUnction to extract binaries for a sub-directory. */
unpostit:
"cd "INCOMING"\"ARG(1)

/* Extract any incomplete messages from the archive */
UNCOMPRESS "incomp"COMPRESSEDEXT

/* Unpost the latest batch, saving the incomplete messages to INCOMP.UUE */
"unpost -i incomp.uue -rg" ARG(1)".uue"
"del "ARG(1)".uue"

/* Unpost the incompletes, hoping some are now complete. The still-incomplete */
/* messages are saved to incomp2.uue */
"unpost -i incomp2.uue -rg incomp.uue"
"del incomp.uue"

/* Delete any remaining incomplete messages older than 5 days. The output */
/* is saved to incomp.uue */
"expire -d -l"SEPARATOR" incomp2.uue incomp.uue"
"del incomp2.uue"

/* zip up incomp.uue and my work here is done. */
COMPRESS "incomp"COMPRESSEDEXT" incomp.uue"
"del incomp.uue"
return

jpegtogif:
"cd "INCOMING"\"ARG(1)
"call \jpeg\cvtall"
return

delemptyfiles:
/* This function requires 4OS/2. */
"cd "INCOMING"\"ARG(1)
"for %%a in (*.*) do if %@filesize[%%a,b] == 0 del %%a"
return
