/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1994-1998 Electrotechnical Laboratry (ETL), AIST, MITI
Copyright (c) 1994-1998 Yutaka Sato

Permission to use, copy, and distribute this material for any purpose
and without fee is hereby granted, provided that the above copyright
notice and this permission notice appear in all copies.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
////////////////////////////////////////////////////////////////////////*/
#include <stdio.h>

#define VERSION	"5.8.6"
#define DATE	"January 6, 1999"
#define AUTHOR	"Yutaka Sato"
#define A_ORG	"Electrotechnical Laboratory"
#define A_EMAIL	"ysato@etl.go.jp"

#define COPYRIGHT "\
AIST Research Product No. 1994-ETL-8715-1\r\n\
Copyright (c) 1994-1998 Yutaka Sato\r\n\
Copyright (c) 1994-1998 Electrotechnical Laboratry (ETL), AIST, MITI"
char *DELEGATE_copyright(){ return COPYRIGHT; }

char *DELEGATE_ver()
{
	return VERSION;
}
char *DELEGATE_date()
{
	return DATE;
}
char *DELEGATE_verdate()
{	static char buf[64];

	if( buf[0] == 0 ) sprintf(buf,"DeleGate/%s (%s)",
		VERSION,DATE);
	return buf;
}
char *DELEGATE_version(){
	static char version[128];
	sprintf(version,"DeleGate/%s by %s", VERSION, A_EMAIL);
	return version;
}
char *DELEGATE_Ver()
{	static char Ver[128];
	sprintf(Ver,"DeleGate/%s (%s) by %s (%s)", VERSION,DATE, AUTHOR,A_ORG);
	return Ver;
}
char *DELEGATE_Version(){
	static char Version[128];
	sprintf(Version,"%s (%s) %s", DELEGATE_version(), AUTHOR, DATE);
	return Version;
}

char *DELEGATE_Distribution(){
	return "ftp://ftp.etl.go.jp/pub/DeleGate/";
}

char *DELEGATE_homepage(){
	return "http://wall.etl.go.jp/delegate/";
}

put_identification(out)
	FILE *out;
{
	fprintf(out,"%s\r\n",DELEGATE_verdate());
	fprintf(out,"%s\r\n",COPYRIGHT);
	fprintf(out,"--\r\n");
	fprintf(out,"FTP: <URL:%s>\r\n",DELEGATE_Distribution());
	fprintf(out,"WWW: %s\r\n","<URL:http://www.etl.go.jp/~ysato/>");
	fprintf(out,"Mailing-List: <URL:mailto:delegate@etl.go.jp>\r\n");
	fprintf(out,"              <URL:%sml/>\r\n",DELEGATE_homepage());
}

