/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1996 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, modify, and distribute this material for any
purpose and without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies, and
that the name of ETL not be used in advertising or publicity pertaining
to this material without the specific, prior written permission of an
authorized representative of ETL.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	unsock.c (AF_UNIX domain socket)
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	960604	extracted from distrib.c and inets.c
//////////////////////////////////////////////////////////////////////#*/
#include <stdio.h>
#include <string.h>
#include "vsocket.h"

extern char *strrpbrk();
extern FILE *dirfopen();
extern int errno;
typedef struct sockaddr *SAP;

int AF_UNIX_DISABLE = 0;
int AF_UNIX_SOCKETPAIR_DISABLE = 0;
static int un_seqno;

#define errlog	sv1log
extern int LOG_VERBOSE;
#define dbglog	LOG_VERBOSE==0 ? 0 : sv1vlog

#if defined(_SOCKADDR_LEN)/*OSF1*/ || defined(SUN_LEN)/*AIX*/
/* must set sockaddr_un.sun_len ? */
#else
#endif

Socketpair(sv)
	int sv[];
{
	sv[0] = sv[1] = -1;

	if( !AF_UNIX_DISABLE || !AF_UNIX_SOCKETPAIR_DISABLE ){
		if( socketpair(AF_UNIX,SOCK_STREAM,0,sv) == 0 )
			return 0;
		AF_UNIX_DISABLE = 1;
		AF_UNIX_SOCKETPAIR_DISABLE = 1;
		dbglog("#### Socketpair(AF_UNIX) failed (%d)\n",errno);
	}

	if( 0 <= socketpair(AF_INET,SOCK_STREAM,0,sv) )
		return 0;

	if( AF_UNIX_SOCKETPAIR_DISABLE )
		return -1;
	else	return socketpair(AF_UNIX,SOCK_STREAM,0,sv);
}

UDP_Socketpair(sv)
	int sv[];
{
	/*
	some system (Solaris) don't support SOCK_DGRAM on AF_UNIX sockets
	return socketpair(AF_UNIX,SOCK_DGRAM,0,sv);
	*/
	return socketpair(AF_INET,SOCK_DGRAM,0,sv);
}

server_open_localhost(what,path,nlisten)
	char *what,*path;
{	int sock;
	FILE *sockfp;
	char sockname[256];

	sock = server_open(what,"localhost",0,nlisten);
	if( sock < 0 )
	sock = server_open(what,NULL,0,nlisten);

	if( sock < 0 ){
		errlog("####LS cannot create local socket\n");
	}else{
		gethostName(sock,sockname,"%A:%P");
		sockfp = dirfopen(what,path,"w");
		if( sockfp == NULL ){
			errlog("####LS cannot create %s\n",path);
			close(sock);
			sock = -2;
		}else{
			if( lock_exclusiveTO(fileno(sockfp),3000,NULL) != 0 )
				errlog("####LS cannot lock %s\n",path);
			else{
				fprintf(sockfp,"%s\n",sockname);
/* DEBUG */{
char myhp[256];
Myhostport(myhp,sizeof(myhp));
fprintf(sockfp,"# %s\n",myhp);
fflush(sockfp);
}
				fflush(sockfp);
				lock_unlock(fileno(sockfp));
			dbglog("####LS bound local socket (%d) [%s] %s\n",
					sock,sockname,path);
			}
			fclose(sockfp);
		}
	}
	return sock;
}
client_open_localhost(what,path,timeout)
	char *what,*path;
{	int sock;
	FILE *sockfp;
	char sockname[256],host[256];
	int port;

	sockfp = fopen(path,"r");
	if( sockfp == NULL ){
		errlog("####LS cannot open %s\n",path);
		return -1;
	}
	if( lock_sharedNB(fileno(sockfp)) != 0 ){
		errlog("####LS cannot lock %s\n",path);
		fclose(sockfp);
		return -1;
	}

	sock = -1;
	if( fscanf(sockfp,"%[^\r\n]",sockname) != 1 )
		errlog("####LS cannot read %s\n",path);
	else
	if( sscanf(sockname,"%[^:]:%d",host,&port) != 2 )
		errlog("####LS cannot parse [%s] %s\n",sockname,path);
	else{
		sock = client_open(what,what,host,port);
		dbglog("####LS connected local socket (%d) [%s] %s\n",
			sock,sockname,path);
	}
	lock_unlock(fileno(sockfp));
	fclose(sockfp);
	return sock;
}

server_open_un(what,path,nlisten)
	char *what,*path;
{	struct sockaddr_un una;
	int sock;
	int rcode;
	char dir[1024],*dp;

	if( AF_UNIX_DISABLE )
		return server_open_localhost(what,path,nlisten);

	if( sizeof(una.sun_path) <= strlen(path) ){
		errlog("#### bind_un: too long path: %s\n",path);
		return -1;
	}

#ifndef __EMX__
		strcpy(dir,path);
		if( dp = strrpbrk(dir,"/\\") )
			*dp = 0;
		if( !fileIsdir(dir) ){
			mkdirR(dir,0777);
			if( !fileIsdir(dir) )
				errlog("bind_un: cannot mkdir %s\n",dir);
		}
#endif

	sock = socket(AF_UNIX,SOCK_STREAM,0);
	una.sun_family = AF_UNIX;
	strcpy(una.sun_path,path);

	rcode = bind(sock,(SAP)&una,sizeof(una));

	if( rcode == 0 ){
		rcode = listen(sock,nlisten);
		if( rcode != 0 )
			errlog("#### bind_un: cannot listen, errno=%d\n",errno);
		return sock;
	}else{
		close(sock);
		return -1;
	}
}
client_open_un(what,path,timeout)
	char *what,*path;
{	struct sockaddr_un una;
	int sock;
	int rcode;

	if( AF_UNIX_DISABLE )
		return client_open_localhost(what,path,timeout);

	if( sizeof(una.sun_path) <= strlen(path) )
		return -1;

	sock = socket(AF_UNIX,SOCK_STREAM,0);
	una.sun_family = AF_UNIX;
	strcpy(una.sun_path,path);

	rcode = connectTO(sock,&una,sizeof(una),timeout);

	if( rcode == 0 )
		return sock;
	else{
		dbglog("#### connect_un: cannot connect, errno=%d\n",errno);
		close(sock);
		return -1;
	}
}

static put_link(what,lpath,spath)
	char *what,*lpath,*spath;
{	FILE *lfp,*vfp;
	char xspath[2048],msg[2048];
	int eof;
	int rcode = -1;

	msg[0] = 0;
	if( (lfp = dirfopen(what,lpath,"w")) == NULL ){
		strcpy(msg,"can't create");
		goto EXIT;
	}
	if( lock_exclusiveTO(fileno(lfp),1000,NULL) != 0 ){
		strcpy(msg,"locked out");
		fclose(lfp);
		goto EXIT;
	}

	eof = 0;
	eof |= fputs(spath,lfp) == EOF;
	eof |= fflush(lfp) == EOF;
	lock_unlock(fileno(lfp));
	eof |= fclose(lfp) == EOF;
	if( eof ){
		strcpy(msg,"write failed");
		goto EXIT;
	}
	if( (vfp = fopen(lpath,"r")) == NULL ){
		strcpy(msg,"can't verify open");
		goto EXIT;
	}

	if( fgets(xspath,sizeof(xspath),vfp) == NULL )
		strcpy(msg,"can't verify read");
	else
	if( strcmp(xspath,spath) != 0 )
		sprintf(msg,"snatched [%s]=>[%s]",spath,xspath);
	else{
		sprintf(msg,"[%s]",spath);
		rcode = 0;
	}
	fclose(vfp);
EXIT:
	if( rcode != 0 )
		errlog("#### put_link FAILED: %s %s\n",lpath,msg);
	else	dbglog("#### put_link %s %s\n",lpath,msg);
	return rcode;
}
static get_link(what,lpath,spath,size,ntry)
	char *what,*lpath,*spath;
{	FILE *lfp = NULL;
	int try = 0;
	int opened = 0;

	spath[0] = 0;
	for(;;){
		if( lfp == NULL )
			lfp = fopen(lpath,"r");
		else{
			clearerr(lfp);
			fseek(lfp,0,0);
		}
		if( lfp != NULL ){
			opened++;
			if( lock_sharedNB(fileno(lfp)) != 0 )
				errlog("#### get_link: locked out %s\n",lpath);
			else{
				fgets(spath,size,lfp);
				lock_unlock(fileno(lfp));
			}
		}
		if( spath[0] || ntry <= ++try )
			break;
		msleep(100);
	}

	if( 1 < try )
	errlog("#### get_link [%d/%d] %x %s <%s>\n",opened,try,lfp,lpath,spath);

	if( lfp != NULL)
		fclose(lfp);
	if( spath[0] )
		return 0;
	else	return -1;
}

static is_owner(spath)
	char *spath;
{	char *dp;
	int ctime,owner;

	if( dp = strrchr(spath,'/') )
		dp++;
	else	dp = spath;
	if( sscanf(dp,"%d.%d",&ctime,&owner) == 2 )
		if( owner == getpid() )
			return 1;
	return 0;
}
bind_un(what,lpath,backlog,spath,size)
	char *what,*lpath,*spath;
{	char file[1024],stime[128];
	int pid;
	int sock;
	int try;

	if( free_un(what,lpath,spath,size,0) == 0 )
		errlog("#### bind_un: salvaged %s <%s>\n",lpath,spath);

	UnixSocketDir(spath);
	pid = getpid();
	sprintf(spath+strlen(spath),"%02d/",pid % 32);
	StrftimeLocal(stime,sizeof(stime),"%m%d%H%M%S",time(0));
	sprintf(spath+strlen(spath),"%s.%05d.%02d",stime,pid,++un_seqno);

	errno = 0;
	for( try = 0; try++ < 10; ){
		sock = server_open_un(what,spath,backlog);
		if( 0 <= sock )
			break;
		if( sock < -1 )
			break;
		msleep(100);
	}

	if( 1 < try || sock < 0 )
		errlog("#### bind_un: %d * bind() = %d, errno=%d, %s\n",
			try,sock,errno,spath);

	if( 0 <= sock ){
		if( 0 < File_size(lpath) )
			errlog("#### bind_un FAILED: snatched %s\n",lpath);
		else
		if( put_link(what,lpath,spath) != 0 )
			errlog("#### bind_un FAILED: can't link %s\n",lpath);
		else{
			dbglog("#### bind_un: bound [%s] %s\n",spath,lpath);
			return sock;
		}
		close(sock);
	}

	unlink(spath);
	return -1;
}
free_un(what,lpath,spath,size,if_owner)
	char *what,*lpath,*spath;
{	int rcode;
	int do_unlink;

	spath[0] = 0;
	rcode = 0;
	do_unlink = 1;

	if( get_link(what,lpath,spath,size,1) == 0 ){
		if( if_owner && !is_owner(spath) ){
			do_unlink = 0;
			rcode = -1;
		}else
		if( unlink(spath) == 0 ){
			rcode = 0;
			dbglog("#### free_un: freed %s\n",spath);
		}else	rcode = -2;
	}else{
		/* another process may be locking the file to write */
		do_unlink = 0;
		rcode = -3;
	}

	if( do_unlink )
		unlink(lpath);

	return rcode;
}
connect_un(what,lpath,timeout)
	char *what,*lpath;
{	char spath[1024];
	FILE *lfp;
	int sock;

	if( get_link(what,lpath,spath,sizeof(spath),20) == 0 ){
		sock = client_open_un(what,spath,timeout);
		if( 0 <= sock ){
			dbglog("#### connect_un: connected %s\n",spath);
			return sock;
		}
		errlog("#### connect_un: cannot connect(%d) %s\n",errno,spath);
		/*
		unlink(spath);
		unlink(lpath);
		*/
	}
	return -1;
}
