/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1996 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, modify, and distribute this material for any
purpose and without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies, and
that the name of ETL not be used in advertising or publicity pertaining
to this material without the specific, prior written permission of an
authorized representative of ETL.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	udprelay
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	961006	created (not functional X-)
	980525	total renewal
//////////////////////////////////////////////////////////////////////#*/
#include "delegate.h"
extern char *gethostaddr();

#define MAXASSOC 256

int UDPRELAY_MAXASSOC = MAXASSOC;
extern int IO_TIMEOUT;
extern int SERVER_TIMEOUT;

int UDPRELAY_RPORT_FIX; /* restrict server's response port to be
			   same with its request (accept) port */

typedef struct {
	char   *ua_svhost;	/* symbolic name of AF_INET or AF_UNIX */
unsigned
	short	ua_svport;
	char   *ua_clhost;
unsigned
	short	ua_clport;

	int	ua_id;
	int	ua_timeout;
	int	ua_ctime;
	int	ua_mtime;
	int	ua_upbytes;
	int	ua_upcnt;
	int	ua_downbytes;
	int	ua_downcnt;
	int	ua_svsock;
} UDP_Assoc;

static UDP_Assoc **uassocv;
static int uaid;

static UDP_Assoc *findUAbysrc(uav,clhost,clport,svhost,svport)
	UDP_Assoc *uav[];
	char *clhost,*svhost;
{	int ai;
	UDP_Assoc *ua;

	for( ai = 0; ua = uav[ai]; ai++ ){
		if( strcmp(ua->ua_clhost,clhost) == 0 )
		if( ua->ua_clport == clport )
			return ua;
	}
	return NULL;
}
static longestIdle(uav)
	UDP_Assoc *uav[];
{	int ai;
	int mtime;
	int mx;
	UDP_Assoc *ua;

	mtime = 0;
	mx = 0;
	for( ai = 0; ua = uav[ai]; ai++ ){
		if( ua->ua_mtime < mtime ){
			mtime = ua->ua_mtime;
			mx = ai;
		}
	}
	return mx;
}
static getsocks(uav,sockv)
	UDP_Assoc *uav[];
	int sockv[];
{	int ai;
	UDP_Assoc *ua;

	for( ai = 0; ua = uav[ai]; ai++ )
		sockv[ai] = ua->ua_svsock;
	return ai;
}
static msghead(msg,what,ua,ux)
	char *msg,*what;
	UDP_Assoc *ua;
{
	sprintf(msg,"UDPRELAY %-5s#%-4d[%d](%2d) %s:%d",
		what,ua->ua_id,ux,ua->ua_svsock,ua->ua_clhost,ua->ua_clport);
}
static permitted(clhost,clport,svhost,svport)
	char *clhost,*svhost;
{
	return service_permitted0(clhost,clport,"udprelay",svhost,svport);
}

static UDP_Assoc *newUA(uav,clhost,clport,svhost,svport)
	UDP_Assoc *uav[];
	char *clhost,*svhost;
{	int ux;
	UDP_Assoc *ua;
	int svsock;
	int rcode;
	char msg[128];

	if( !permitted(clhost,clport,svhost,svport) )
		return NULL;

	svsock = server_open("UDPRELAY",NULL,0,-1);
	if( svsock < 0 ){
		ux = longestIdle(uav);
		sv1log("push out longest idle 1 [%d]\n",ux);
		delUA(uav,ux,"NoMoreSocket");
		svsock = server_open("UDPRELAY",NULL,0,-1);
		if( svsock < 0 )
			return NULL;
	}

	if( UDPRELAY_RPORT_FIX ){
	rcode = __connectServer(svsock,"UDPRELAY","udprelay",svhost,svport,1);
	if( rcode < 0 ){
		sv1log("UDPRELAY: connect(%d) error %d\n",svsock,rcode);
		close(svsock);
		return NULL;
	}
	}

	for( ux = 0; uav[ux]; ux++ )
		;
	if( UDPRELAY_MAXASSOC <= ux ){
		ux = longestIdle(uav);
		sv1log("push out longest idle 2 [%d]\n",ux);
		delUA(uav,ux,"NoMoreClient");
	}

	ua = (UDP_Assoc*)calloc(1,sizeof(UDP_Assoc));
	ua->ua_id = ++uaid;
	ua->ua_ctime = time(0);
	ua->ua_clhost = strdup(clhost);
	ua->ua_clport = clport;
	ua->ua_svsock = svsock;
	ua->ua_svhost = strdup(svhost);
	ua->ua_svport = svport;
	uav[ux] = ua;

	msghead(msg,"start",ua,ux);
	sv1log("%s > %s:%d\n",msg,svhost,svport);
	return ua;
}
static delUA(uav,ux,why)
	UDP_Assoc *uav[];
	char *why;
{	int uy;
	UDP_Assoc *ua;
	char msg[128];

	ua = uav[ux];
	close(ua->ua_svsock);
	msghead(msg,"done",ua,ux);
	sv1log("%s > %s:%d (%d/%dup,%d/%ddown,%dsec) %s\n",
		msg,
		ua->ua_svhost,ua->ua_svport,
		ua->ua_upbytes,ua->ua_upcnt,
		ua->ua_downbytes,ua->ua_downcnt, time(0)-ua->ua_ctime,why);

	for( uy = ux; uav[uy]; uy++ )
		uav[uy] = uav[uy+1];
	free(ua->ua_svhost);
	free(ua->ua_clhost);
	free(ua);
}
static UDP_Assoc *findUAbysock(uav,svsock)
	UDP_Assoc *uav[];
{	int ai;
	UDP_Assoc *ua;

	for( ai = 0; ua = uav[ai]; ai++ )
		if( ua->ua_svsock == svsock )
			return ua;
	return NULL;
}
static killTimeouts(uav)
	UDP_Assoc *uav[];
{	int ux,uy,nkill;
	int now;
	UDP_Assoc *ua;

	nkill = 0;
	now = time(0);
	for( ux = 0; ua = uav[ux]; ux++ ){
		if( IO_TIMEOUT < (now - ua->ua_mtime) ){
			nkill++;
			delUA(uav,ux,"IdleTimeOut");
		}
	}
	return nkill;
}

udp_relay(Conn,clsock)
	Connection *Conn;
{	int svsock;
	int sockv[1+MAXASSOC],readyv[1+MAXASSOC],sx;
	int nsock;
	char buff[0x8000];
	int rcc,wcc;
	int nready;
	char ihost[64];
	int iport;
	char svhost[64];
	int svport;
	char *clhost;
	int clport;
	UDP_Assoc *ua;
	int lastrelay,idle;

	strcpy(svhost,gethostaddr(DST_HOST));
	svport = DST_PORT;

	uassocv = (UDP_Assoc**)calloc(MAXASSOC,sizeof(UDP_Assoc*));
	sockv[0] = clsock;
	nsock = 0;
	lastrelay = 0;

	for(;;){
		nready = PollIns(10*1000,1+nsock,sockv,readyv);
		if( nready < 0 ){
			sv1log("UDPRELAY: ABORT PollIns(%d) = %d\n",nready);
			break;
		}
		if( nready == 0 ){
			idle = time(0) - lastrelay;
			if( SERVER_TIMEOUT && lastrelay )
			if( SERVER_TIMEOUT < idle){
				sv1log("UDPRELAY: SERVER TIMEOUT (idle %ds)\n",
					idle);
				break;
			}
			killTimeouts(uassocv);
			nsock = getsocks(uassocv,&sockv[1]);
			continue;
		}
		lastrelay = time(0);

		if( 0 < readyv[0] ){
			rcc = RecvFrom(clsock,buff,sizeof(buff),ihost,&iport);
			if( rcc <= 0 ){
				sv1log("UDPRELAY: recv() == 0\n");
				break;
			}
			ua = findUAbysrc(uassocv,ihost,iport,svhost,svport);
			if( ua == NULL ){
				ua = newUA(uassocv,ihost,iport,svhost,svport);
				if( ua == NULL ){
					continue;
				}
				if( ua->ua_svsock < 0 )
					continue;
				nsock = getsocks(uassocv,&sockv[1]);
			}
			ua->ua_mtime = time(0);
			ua->ua_upcnt++;
			ua->ua_upbytes += rcc;
			if( UDPRELAY_RPORT_FIX )
				wcc = Send(ua->ua_svsock,buff,rcc);
			else	wcc = SendTo(ua->ua_svsock,buff,rcc,svhost,svport);
			Verbose("TO SERV#%d: %s:%d %3d> %s:%d\n",
				ua->ua_id,ihost,iport,rcc,svhost,svport);
			if( nready == 1 )
				continue;
		}

		for( sx = 1; sx <= nsock; sx++ ){
			if( readyv[sx] <= 0 )
				continue;
			svsock = sockv[sx];
			rcc = RecvFrom(svsock,buff,sizeof(buff),ihost,&iport);
			if( rcc <= 0 ){
				readyv[sx] = -1;
				continue;
			}

			ua = findUAbysock(uassocv,svsock);
			ua->ua_mtime = time(0);
			ua->ua_downcnt++;
			ua->ua_downbytes += rcc;
			clhost = ua->ua_clhost;
			clport = ua->ua_clport;
			wcc = SendTo(clsock,buff,rcc,clhost,clport);

			Verbose("TO CLNT#%d: %s:%d <%-3d %s:%d\n",
				ua->ua_id,clhost,clport,rcc,ihost,iport);
		}
	}
}
service_udprelay(Conn)
	Connection *Conn;
{
	udp_relay(Conn,FromC);
}

service_udprelay1(Conn)
	Connection *Conn;
{
	service_tcprelay(Conn);
}
