/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1995 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, modify, and distribute this material for any
purpose and without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies, and
that the name of ETL not be used in advertising or publicity pertaining
to this material without the specific, prior written permission of an
authorized representative of ETL.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	tcprelay.c
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	950701	extracted from service.c and iotimeout.c and merged
//////////////////////////////////////////////////////////////////////#*/
#include <stdio.h>
#include "delegate.h"
#include "fpoll.h"
#include <errno.h>

static int DUMP;
bdump(src,dst,buf,rcc)
	char *buf;
{	int rc,ch;

	printf("[%2d->%2d](%d) ",src,dst,rcc);
	for( rc = 0; rc < rcc; rc++ ){
		ch = buf[rc] & 0xFF;
		if( 0x21 <= ch && ch <= 0x7E )
			printf("%c",ch);
		else	printf(".");
	}
	printf(" ");
	for( rc = 0; rc < rcc; rc++ ){
		if( rc != 0 ) printf(" ");
		ch = buf[rc] & 0xFF;
		printf("%02x",ch);
	}
	printf("\n");
}
service_nbt(Conn)
	Connection *Conn;
{
	DUMP = 1;
	return relay_svcl(Conn,FromC,ToC,FromS,ToS);
}

service_tcprelay(Conn)
	Connection *Conn;
{
	if( ToS < 0 && FromS < 0  ){
		if( isMYSELF(DST_HOST) ){
			ToS = fileno(stdout);
			FromS = fileno(stdin);
		}else	return -1;
	}

	if( cur_codeconvCL(NULL) ){
		check_codeconv(1);
		return relay_lines(0,0,
			CCV_TOCL,FromS,ToC,
			CCV_TOSV,FromC,ToS,NULL);
	}else	return relay_svcl(Conn,FromC,ToC,FromS,ToS);
}

relay_lines(timeout,flush,C1,S1,D1,C2,S2,D2)
	char *C1,*C2;
{	FILE *rfv[2],*wfv[2];
	char *ccv[2],code;
	int wcv[2],rdv[2],nready;
	int fpc,fi;
	char iline[1024],xline[4096],*oline;

	ccv[0] = C1; rfv[0] = fdopen(S1,"r"); wfv[0] = fdopen(D1,"w");
	ccv[1] = C2; rfv[1] = fdopen(S2,"r"); wfv[1] = fdopen(D2,"w");
	wcv[0] = wcv[1] = 0;
	fpc = 2;

	for(;;){
		nready = 0;
		for( fi = 0; fi < fpc; fi++ )
			if( 0 < ready_cc(rfv[fi]) )
				nready++;
		if( nready == 0 )
			for( fi = 0; fi < fpc; fi++ ){
				fflush(wfv[fi]);
				wcv[fi] = 0;
			}

		if( fPollIns(timeout,fpc,rfv,rdv) < 0 )
			break;

		for( fi = 0; fi < fpc; fi++ ){
		    if( 0 < rdv[fi] ){
			if( fgets(iline,sizeof(iline),rfv[fi]) == NULL )
				goto gotEOF;

			if( ccv[fi] == NULL )
				oline = iline;
			else{
				do_codeconv(ccv[fi],iline,xline,"text/plain");
				oline = xline;
			}

			if( fputs(oline,wfv[fi]) == EOF )
				goto gotEOF;

			wcv[fi] += strlen(oline);
			if( 0 < flush && flush < wcv[fi] ){
				fflush(wfv[fi]);
				wcv[fi] = 0;
			}
		    }
		}
	}
gotEOF:
	for( fi = 0; fi < fpc; fi++ ){
		fclose(rfv[fi]);
		fclose(wfv[fi]);
	}
}

extern int IO_TIMEOUT;

relay_svcl(Conn,fromC,toC,fromS,toS)
	Connection *Conn;
{	int sdv[2][2];
	int cnt[2];

	sdv[0][0] = fromC; sdv[0][1] = toS;
	sdv[1][0] = fromS; sdv[1][1] = toC;
	relays(IO_TIMEOUT*1000,2,sdv,cnt);
	return cnt[1];
}
simple_relayTimeout(src,dst,timeout)
{	int rcc,wcc,rcc1,wcc1,nio;

	rcc = wcc = 0;
	for( nio = 0;; nio++ ){
		if( !IsWindows95() || file_ISSOCK(src) )
		if( timeout != 0 )
		if( PollIn(src,timeout) <= 0 )
			break;
		if( relay1(NULL,src,dst,&rcc1,&wcc1) <= 0 )
			break; 
		rcc += rcc1;
		wcc += wcc1;
	}
	sv1log("simple_relay [%d -> %d] = (%d -> %d) / %d\n",
		src,dst,rcc,wcc,nio);
	return rcc;
}
simple_relay(src,dst)
{
	return simple_relayTimeout(src,dst,IO_TIMEOUT*1000);
}
simple_relayfTimeout(src,dst,timeout)
	FILE *src,*dst;
{	int rcc,wcc,ch;

	for( rcc = 0; READYCC(src); rcc++ ){
		ch = getc(src);
		if( ch == EOF )
			return rcc;
		putc(ch,dst);
	}
	fflush(dst);
	sv1log("simple_relayf [%d -> %d] = %d\n",
		fileno(src),fileno(dst),rcc);
	return rcc + simple_relayTimeout(fileno(src),fileno(dst),timeout);
}
simple_relayf(src,dst)
	FILE *src,*dst;
{
	return simple_relayfTimeout(src,dst,IO_TIMEOUT*1000);
}

relay_tee(arg,src,dst1,dst2,rccp,wccp1,wccp2)
	char *arg;
	int *rccp,*wccp1,*wccp2;
{	int rcc,wcc,wc1;
	char buf[0x4000];

	*wccp1 = 0;
	if( wccp2 ) *wccp2 = 0;

	rcc = read(src,buf,sizeof(buf));
	*rccp = rcc;
	if( rcc <= 0 )
		return rcc;

	if( DUMP )
		bdump(src,dst1,buf,rcc);

	wcc = 0;
	while( wcc < rcc ){
		wc1 = write(dst1,buf,rcc);
		if( wc1 <= 0 )
			break;
		wcc += wc1;
	}
	*wccp1 = wcc;
	if( dst2 < 0 || wc1 <= 0 )
		return wc1;

	wcc = 0;
	while( wcc < rcc ){
		wc1 = write(dst2,buf,rcc);
		if( wc1 <= 0 )
			break;
		wcc += wc1;
	}
	*wccp2 = wcc;
	return wc1;
}
static relay1(arg,src,dst,rccp,wccp)
	char *arg;
	int *rccp,*wccp;
{
	return relay_tee(arg,src,dst,-1,rccp,wccp,NULL);
}

typedef int (*IFUNC)();
#define IGN_EOF	1

relaysx(timeout,sdc,sdv,sdx,rccs,funcv,argv)
	int sdv[][2];
	int sdx[];
	int rccs[];
	IFUNC funcv[];
	char *argv[];
{	int fi;
	int pc,pi,pfv[32],pxv[32];
	int fds[32],errv[32],rfds[32];
	int cntv[32];
	int rcode,rcc,wcc;
	IFUNC funcvb[32];
	char *argvb[32];
	int nready;

	sv1log("relays(%d) start: timeout=%dmsec\n",sdc,timeout);

	if( funcv == NULL ){
		funcv = funcvb;
		for( fi = 0; fi < sdc; fi++ )
			funcv[fi] = NULL;
	}
	if( argv == NULL ){
		argv = argvb;
		for( fi = 0; fi < sdc; fi++ )
			argv[fi] = NULL;
	}

	for( fi = 0; fi < sdc; fi++ ){
		fds[fi] = sdv[fi][0];
		errv[fi] = 0;
		rccs[fi] = 0;
		cntv[fi] = 0;
		if( funcv[fi] == NULL )
			funcv[fi] = relay1;
	}

	for(;;){
	    pc = 0;
	    for( fi = 0; fi < sdc; fi++ ){
		if( errv[fi] == 0 ){
			pfv[pc] = fds[fi];
			pxv[pc] = fi;
			pc++;
		}
	    }
	    if( pc == 0 )
		break;

	    errno = 0;
	    nready = PollIns(timeout,pc,pfv,rfds);
	    if( nready == 0 && errno == 0 ){
		int fi,sync;

		sync = 0;
		for( fi = 0; fi < sdc; fi++ )
			sync += relayOOB(sdv[fi][0],sdv[fi][1]);
		if( sync )
			continue;

		Usleep(1);
		nready = PollIns(1,pc,pfv,rfds);
		if( 0 < nready ){
			sv1log("## tcprelay: ignore OOB?\n");
			continue;
		}
	    }
	    if( nready <= 0 )
		break;

	    for( pi = 0; pi < pc; pi++ ){
		if( 0 < rfds[pi] ){
			fi = pxv[pi];
			rcode = (*funcv[fi])(argv[fi],sdv[fi][0],sdv[fi][1],&rcc,&wcc);
			rccs[fi] += wcc;
			cntv[fi] += 1;
			if( rcode <= 0 ){
				sv1log("relays(%d): EOF: %d(%di+%do)\n",
					fi,rcode,rcc,wcc);
				if( sdx == NULL || (sdx[fi] & IGN_EOF) == 0 )
					goto EXIT;
				else	errv[fi] = 1;
			}
		}
	    }
	}
EXIT:
	for( fi = 0; fi < sdc; fi++ )
		sv1log("relays[%d]: [%d->%d] %d bytes / %d\n",fi,
			sdv[fi][0],sdv[fi][1],rccs[fi],cntv[fi]);
}
relays(timeout,sdc,sdv,rccs)
	int sdv[][2];
	int rccs[];
{
	relaysx(timeout,sdc,sdv,NULL,rccs,NULL,NULL);
}
relay2(timeout,s1,d1,s2,d2)
{	int sdv[2][2];
	int rccs[2];

	sdv[0][0] = s1;
	sdv[0][1] = d1;
	sdv[1][0] = s2;
	sdv[1][1] = d2;
	relays(timeout,2,sdv,rccs);
}
relay2_cntl(timeout,s1,d1,s2,d2,s3,d3,cntlfunc,arg)
	IFUNC cntlfunc;
	char *arg;
{	int sdv[3][2];
	int rccs[3];
	IFUNC fnv[3];
	char *agv[3];

	sdv[0][0] = s1;
	sdv[0][1] = d1;
	fnv[0] = 0;
	agv[0] = 0;

	sdv[1][0] = s2;
	sdv[1][1] = d2;
	fnv[1] = 0;
	agv[1] = 0;

	sdv[2][0] = s3;
	sdv[2][1] = d3;
	fnv[2] = cntlfunc;
	agv[2] = arg;

	relaysx(timeout,3,sdv,NULL,rccs,fnv,agv);
}

/* relay OOB (maybe SYNCH signal of Telnet) */
relayOOB(in,out)
{	char buff[128];
	int rcc;
	int pi,nready;

	msleep(1);
	SetNonblockingIO("relayOOB",in,1);
	rcc = recvOOB(in,buff,sizeof(buff));
	SetNonblockingIO("relayOOB",in,0);
	if( rcc != 1 )
		return 0;

	Verbose("relay OOB: [%d]->[%d] %dbytes (%x)\n",in,out,rcc,buff[0]&0xFF);
	sendOOB(out,buff,rcc);

	/* if the protocol is Telnet,
	 *  in-band data should be ignored until the MARK(242) ... */
	for( pi = 0; pi < 50; pi++ ){
		if( nready = PollIn(in,1) )
			break;
		msleep(10);
	}
	Verbose("relay OOB: nready=%d after %dms\n",nready,pi*10);

	return 1;
}

