/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1994 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, modify, and distribute this material for any
purpose and without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies, and
that the name of ETL not be used in advertising or publicity pertaining
to this material without the specific, prior written permission of an
authorized representative of ETL.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	svport.c
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	961006	extracted from delegated.c
	961120	moved stuffs about DELEGATE_HOST/PORT from {conf,service}.c
//////////////////////////////////////////////////////////////////////#*/
#include <ctype.h>
#include <string.h>
extern char *strdup();
#include "delegate.h" /* Connection */

static char *serverHostPort   = 0;  /* my (maybe pseudo) host:port */
static char  serverHost1[128] = ""; /* host of primary port */
static int   serverPort1      = 0;  /* primary port (std I/O by default) */

extern int DELEGATE_LISTEN;

typedef struct {
	int	 sv_sock;
	char	*sv_host;
	int	 sv_port;
	int	 sv_udp;
	int	 sv_keep; /* keep bound, but don't use to accept */
	char	*sv_vsap; /* accepting via VSAP */
} ServerPort;
static ServerPort SVPorts[32] = { -1 };
static int SVPortN = 0;

#define SvSock(n)	SVPorts[n].sv_sock
#define SvPort(n)	SVPorts[n].sv_port
#define SvUDP(n)	SVPorts[n].sv_udp
#define SvHost(n)	SVPorts[n].sv_host
#define SvHostStr(n)	((SvHost(n) && SvHost(n)[0]) ? SvHost(n) : "")
#define SvKeep(n)	SVPorts[n].sv_keep
#define SvRoute(n)	SVPorts[n].sv_vsap

static scanServPort0(host,port,udp,sock,route)
	char *host;
	char *route;
{	int sx;
	int keep;

	if( port < 0 ){
		port = -port;
		keep = 1;
	}else	keep = 0;

	for( sx = 0; sx < SVPortN; sx++ )
		if( strcmp(SvHostStr(sx),host) == 0 )
		if( SvPort(sx) == port )
		if( SvUDP(sx) == udp )
			break;
	if( sx == SVPortN )
		SVPortN++;

	/* private-MASTER, exec on SIGHUP, from inetd */
	if( 0 <= sock )
		sockHostport(sock,&port);

	if( sx == 0 ){
		if( host[0] != 0 )
			sethostnameIF(host);
		if( 0 <= port )
			serverPort1 = port;
	}

	if( SvHost(sx) )
		free(SvHost(sx));
	SvHost(sx) = strdup(host);
	SvPort(sx) = port;
	SvUDP(sx) = udp;
	SvKeep(sx) = keep;
	SvRoute(sx) = strdup(route);

	if( 0 <= SvSock(sx) )
		close(SvSock(sx));
	SvSock(sx) = sock;
	return 0;
}

scanServPort1(portspec)
	char *portspec;
{	int sx;
	char host[128];
	char portname[128];
	char mod[128];
	int port;
	int udp;
	int sock;
	int route[128];

	if( streq(portspec,"-") ){
		serverPort1 = 0;
		return 0;
	}

	portname[0] = 0;
	route[0] = 0;
	host[0] = 0;
	mod[0] = 0;
	port = 0;
	udp = 0;
	sock = -1;

	if( portspec[0] == ':' )
		portspec++;

	sscanf(portspec,"%[^@]@%s",portname,route);
	if( strchr(portname,':') )
		sscanf(portname,"%[^:]:%d/%s",host,&port,mod);
	else	sscanf(portname,"%d/%s",&port,mod);

	if( mod[0] ){
		if( strcmp(mod,"udp") == 0 )
			udp = 1;
		else	sock = atoi(mod);
	}

	if( route[0] ){
		char vsap[256];
		sprintf(vsap,"%s/ACCEPT",route);
		scan_VSAP(NULL,vsap);
	}

	return scanServPort0(host,port,udp,sock,route);
}

scanServPort(portspecs)
	char *portspecs;
{
	SVPortN = 0;
	scan_commaList(portspecs,0,scanServPort1);
}

printServPort(port,prefix,whole)
	char *prefix,*port;
{	int sx;
	char *pp;

	port[0] = 0;

	pp = port;
	if( prefix ){
		strcpy(pp,prefix);
		pp += strlen(pp);
	}

	for( sx = 0; sx < SVPortN; sx++ ){
		if( 0 < sx ){
			*pp++ = ',';
			*pp = 0;
		}

		if( SvHostStr(sx)[0] ){
			sprintf(pp,"%s:",SvHost(sx));
			pp += strlen(pp);
		}

		if( SvKeep(sx) )
			sprintf(pp,"%d",-SvPort(sx));
		else	sprintf(pp,"%d",SvPort(sx));
		pp += strlen(pp);

		if( !whole )
			break;

		if( 0 <= SvSock(sx) ){
			sprintf(pp,"/%d",SvSock(sx));
			pp += strlen(pp);
		}
	}

	return SVPortN;
}

setServUDP()
{	int sx;

	for( sx = 0; sx < SVPortN; sx++ )
		SvUDP(sx) = 1;
}

openServPorts()
{	int sx;
	char msg[1024];
	int listen;

	for( sx = 0; sx < SVPortN; sx++ ){
		if( 0 <= SvSock(sx) )
			continue;

		if( SvHostStr(sx)[0] ){
			int fd;
			fd = nextFD();
			IsResolvable(SvHost(sx)); /* enter it to the cache */
			usedFD(fd);
		}

/* check ACTDIR/delegate/pid/PORT and kill if it exist ...
 * by trying fopen "r+" and lock exclusive
 */

		if( SvUDP(sx) )
			listen = -1;
		else	listen = DELEGATE_LISTEN;

		SvSock(sx) = server_open("delegate",
				SvHostStr(sx),SvPort(sx),listen);

		if( SvSock(sx) < 0 ){
			sprintf(msg,"cannot open server port %s:%d",
				SvHostStr(sx),SvPort(sx));
			ERRMSG("DeleGate: %s\n",msg);
			Exit(-1,"DeleGate: %s\n",msg);
		}
	}
}

closeServPorts()
{	int sx;

	for( sx = 0; sx < SVPortN; sx++ ){
		close(SvSock(sx));
		SvSock(sx) = -1;
		SvPort(sx) = 0;
		if( SvHost(sx) )
		SvHost(sx)[0] = 0;
	}
	SVPortN = 0;
}

static int Tio[2];
makeEntrance(){
	if( serverPort1 ){
		openServPorts();
	}else{
		Socketpair(Tio); /* dummy */
		SvSock(0) = Tio[0];
		SVPortN = 1;
		sv1log("TeleportTunnel[%d]\n",SvSock(0));
	}
}

pollServPort(timeout,rsockv,udpv)
	int *rsockv,*udpv;
{	int sx,sxa,rsx;
	int ssockv[256],readyv[256],nready;
	int sock;

	sxa = 0;
	for( sx = 0; sx < SVPortN; sx++ ){
		if( !SvKeep(sx) ){
			ssockv[sxa] = SvSock(sx);
			readyv[sxa] = 0;
			sxa++;
		}
	}
	nready = PollIns(timeout,sxa,ssockv,readyv);

	rsx = 0;
	for( sx = 0; sx < sxa; sx++ ){
		if( 0 < readyv[sx] ){
			rsockv[rsx] = ssockv[sx];
			udpv[rsx] = SvUDP(sx);
			rsx++;
		}
	}
	return nready;
}

inetdServPort()
{	int sock,port,osock,oport;

	sock = dup(0);
	setsockREUSE(sock,1);
	sockHostport(sock,&port);
	oport = SvPort(0);
	osock = SvSock(0);
	svlog("fromInetd/SVsock: %d/%d <= %d/%d\n",port,sock,oport,osock);
	setsid();

	if( oport != port || osock < 0 ){
		LOG_deletePortFile();
		LOG_closeall();
		closeServPorts();
		scanServPort0("",port,isUDPsock(sock),sock,"");
	}
	else	close(sock);
}

isServPort(port){
	int sx;

	for( sx = 0; sx < SVPortN; sx++ )
		if( SvPort(sx) == port )
			return !SvKeep(sx);
	return 0;
}

ServSockOf(host,port)
	char *host;
{	int sx;

	for( sx = 0; sx < SVPortN; sx++ )
		if( SvPort(sx) == port )
			return SvSock(sx);
	return -1;
}

activeServPort()
{	int nactive,sx;

	nactive = 0;
	for( sx = 0; sx < SVPortN; sx++ )
		if( 0 <= SvSock(sx) )
			if( !SvKeep(sx) )
				nactive++;
	return nactive;
}

ServSock()
{
	return SvSock(0);
}

typedef struct {
	int    pid;
	int    ppid;
	int    time;
} CloseOnTime;
static CloseOnTime cot;

/*
 *	close a file descriptor (parallel server's socket for accept)
 *	(1) on specified timeout
 *	(2) after fork
 *	(3) after the death of the parent
 */
setCloseOnTimeout(timeout)
{
	cot.time = time(0) + timeout;
	cot.ppid = getppid();
	cot.pid = getpid();
}
checkCloseOnTimeout(checktime)
{
	if( cot.time == 0 )
		return 1;

	if( getpid() == cot.pid )
	if( getppid() == cot.ppid )
	if( checktime && time(0) < cot.time )
		return 0;

	closeServPorts();
	sv1log("ClosedOnTimeout(%d): time=%d/%d ppid=%d/%d pid=%d/%d\n",
		checktime,
		time(0),cot.time,
		getppid(),cot.ppid,
		getpid(),cot.pid);

	bzero(&cot,sizeof(cot));
	return 1;
}


/*
 *
 */
sethostnameIF(host)
	char *host;
{
	strcpy(serverHost1,host);
	if( serverHostPort != NULL )
		free(serverHostPort);
	serverHostPort = strdup(host);
}
gethostnameIFIF(host,size)
	char *host;
{
	if( serverHost1[0] ){
		strncpy(host,serverHost1,size);
		return 0;
	}
	host[0] = 0;
	return -1;
}
gethostnameIF(host,size)
	char *host;
{
	if( gethostnameIFIF(host,size) == 0 )
		return 0;
	else	return GetHostname(host,size);
}
Myhostport(myhp,size)
	char *myhp;
{
	gethostnameIF(myhp,size);
	sprintf(myhp+strlen(myhp),":%d",serverPort1);
}

char *gethostaddr();
myhostport(myhost,size)
	char *myhost;
{	char *delegate;
	int myport;
	char *addr;

	myport = serverPort1;
	if( delegate = serverHostPort )
		sscanf(delegate,"%[^:]:%d",myhost,&myport);
	else	gethostnameIF(myhost,size);

	if( delegate == 0 || use_numaddress() ){
		if( addr = gethostaddr(myhost) )
			strcpy(myhost,addr);
	}
	return myport;
}

HostPortIFclnt(Conn,clsock,name,addr,port)
	Connection *Conn;
	char *name,*addr;
	int *port;
{
	if( Conn->cl_sockHOST )
		goto EXIT;
		/*return Conn->cl_sockHOST;*/

	gethostNAME(clsock,Conn->cl_sockHOSTname,&Conn->cl_sockHOST,
		&Conn->cl_sockHOSTport);
	inetNtoah(Conn->cl_sockHOST,Conn->cl_sockHOSTaddr);

	Verbose("-- SockHost: [%s] %s:%d\n",
		Conn->cl_sockHOSTaddr, Conn->cl_sockHOSTname,
		Conn->cl_sockHOSTport);

EXIT:
	if( name ) strcpy(name,Conn->cl_sockHOSTname);
	if( addr ) strcpy(addr,Conn->cl_sockHOSTaddr);
	if( port ) *port = Conn->cl_sockHOSTport;
	return Conn->cl_sockHOST;
}

static _clientIF(Conn,hostport,host,clsock,byaddr)
	Connection *Conn;
	char *hostport,*host;
{	char hostb[256],addr[256];
	int port;

	if( host == NULL )
		host = hostb;

	if( serverHostPort )
		port = myhostport(host,sizeof(host));
	else{
		HostPortIFclnt(Conn,clsock,host,addr,&port);
		if( byaddr && addr[0] != 0 )
			strcpy(host,addr);
	}
	if( hostport != NULL )
		sprintf(hostport,"%s:%d",host,port);

	return port;
}
ClientIF_name(Conn,clsock,name)
	Connection *Conn;
	char *name;
{
	return _clientIF(Conn,NULL,name,clsock,0);
}
ClientIF_HP(Conn,hostport)
	Connection *Conn;
	char *hostport;
{
	return _clientIF(Conn,hostport,NULL,Conn->cl_sock,1);
}
ClientIF_H(Conn,host)
	Connection *Conn;
	char *host;
{
	return _clientIF(Conn,NULL,host,Conn->cl_sock,1);
}

ServerIF_name(Conn,host)
	Connection *Conn;
{
	if( 0 < ToS )
		gethostNAME(ToS,host,NULL,NULL);
	else	gethostname(host,256);
}

static isme(myhost,myport,rhost,rport)
	char *myhost,*rhost;
{	int myhosti,rhosti;

	if( rport != myport )
		return 0;

	if( strcasecmp(myhost,rhost) == 0 )
		return 1;

	myhosti = gethostintMin(myhost);
	rhosti = gethostintMin(rhost);

	if( myhosti == -1 || rhosti == -1 )
		return 0; /* maybe safer (resolver seems wrong) */

	if( myhosti == rhosti )
		return 1;

	if( serverHost1[0] != 0 ) /* if interface host is limited */
		return 0;

	return IsMyself(rhost);
}

Ismyself(Conn,rproto,rhost,rport)
	Connection *Conn;
	char *rproto,*rhost;
{	char myhost[256];
	int myport;

	/* Local path cannot be the procol between client / DeleGate ...
	 * (this was temporary patch to avoid being treated as a internal
	 *  URL at httpd.c:HttpToMyself() ...
	 */
	if( localPathProto(rproto) )
		return 0;

	if( isMYSELF(rhost) )
		return 1;

	/*
	 * A virtual address can be given by DELEGATE parameter and is set
	 * to serverHostPort.  The address can be one of followings:
	 *   1. (one of) physical address of myself
	 *   2. (one of) physical address of another server's host:port
	 *   3. pseudo address bound to myself
	 */
	if( serverHostPort != NULL ){
		myport = myhostport(myhost,sizeof(myhost));
		if( isme(myhost,myport,rhost,rport) )
			return 1;
	}

	/*
	 * In physicall address matching, the server port of the
	 * delegated is one of real ports specified in -Pp1,p2,...
	 */
	if( !isServPort(rport) )
		return 0;
	HostPortIFclnt(Conn,Conn->cl_sock,myhost,NULL,&myport);
	return isme(myhost,myport,rhost,rport);
}

scan_DELEGATE(Conn,dhps)
	Connection *Conn;
	char *dhps;
{	char hostport[1024],host[1024];
	int port;
	char proto[1024],dst[1024],src[1024];
	int ni;

	if( dhps == NULL )
		return;

	host[0] = 0;
	port = 0;
	proto[0] = dst[0] = src[0] = 0;
	ni = sscanf(dhps,"%[^:]:%d:%[^:]:%[^:]:%s",host,&port,proto,dst,src);

	if( isMYSELF(host) && Conn != NULL )
		gethostAddr(ClientSock,host);
	if( port == 0 )
		port = serverPort1;
	if( proto[0] )
		scan_CALLBACK(proto);

	sprintf(hostport,"%s:%d",host,port);
	dhps = strdup(hostport);
	serverHostPort = dhps;
}

printPrimaryPort(port)
	char *port;
{
	if( serverHost1[0] )
		sprintf(port,"%s:%d",serverHost1,serverPort1);
	else	sprintf(port,"%d",serverPort1);
}

SERVER_PORT()
{
	return serverPort1;
}
setSERVER_PORT(port,sock)
{
	if( 0 <= sock )
		scanServPort0("",port,isUDPsock(sock),sock,"");
	else	serverPort1 = port;
}



static struct {
	int	port;
	int	sock;
} portsV[128];
static int portsX;
static scanports(hostport)
	char *hostport;
{	char host[256];
	int port1,port2,port;
	int sock;
	int pi;

	host[0] = 0;
	port1 = 0;
	port2 = 0;
	if( strchr(hostport,':') )
		sscanf(hostport,"%[^:]:%d-%d",host,&port1,&port2);
	else	sscanf(hostport,"%d-%d",&port1,&port2);
	if( port2 == 0 )
		port2 = port1;

	for( port = port1; port <= port2; port++ ){
		sock = server_open("reservePORT",host,port,DELEGATE_LISTEN);
		if( sock < 0 ){
			fprintf(stderr,"CANNOT BIND PORT %d\r\n",port);
			exit(1);
		}
		portsV[portsX].port = port;
		portsV[portsX].sock = sock;
		portsX++;
	}
	return 0;
}
scan_PORT(Conn,ports)
	Connection *Conn;
	char *ports;
{
	scan_commaList(ports,0,scanports);
}
ReservedPortSock(host,port)
	char *host;
{	int sx;

	for( sx = 0; sx < portsX; sx++ )
		if( portsV[sx].port == port )
			return portsV[sx].sock;
	return -1;
}
