/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1996 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, modify, and distribute this material for any
purpose and without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies, and
that the name of ETL not be used in advertising or publicity pertaining
to this material without the specific, prior written permission of an
authorized representative of ETL.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	svconf.c
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	961029	extracted from service.c
//////////////////////////////////////////////////////////////////////#*/

#include "service.h"

extern char SERV_HTTP[];
extern char SERV_WAIS[];
extern char SERV_GOPHER[];

extern int service_ftp();
extern int service_ftpget();
extern int service_telnet();
extern int service_gopher();
extern int service_http();
extern int service_https();
extern int service_nntp();
extern int service_delegate();
extern int service_pop();
extern int service_smtp();
extern int service_dump();
extern int service_X();
extern int service_wais();
extern int service_whois();
extern int service_domain();
extern int service_tcprelay();
extern int service_udprelay();
extern int service_coupler();
extern int service_teleport();
extern int service_file();
extern int service_socks();
extern int service_sh();
extern int service_nbt();
extern int service_syslog();
extern int service_pgps();
extern int service_nsh();
extern int service_cgi();
extern int service_cfi();
extern int service_vsap();
extern int service_shell();
extern int service_system();
extern int service_exec();
extern int service_udprelay1();
extern int service_admin();
extern int service_icp();
extern int service_lpr();
extern int service_ldap();

/*
int service_tunnel();
*/

Service services[] = {
    {0},
    {1,0, "ftp",          21,service_ftp	},
    {0,0, "telnet",       23,service_telnet	},
    {0,0, "smtp",         25,service_smtp	},
    {1,0, "whois",	  43,service_whois	},
    {1,0, "domain",       53,service_domain	},
    {1,0, "dns",          53,service_domain	},
    {1,0, "gopher",	  70,service_gopher,	SERV_GOPHER },
    {0,0, "finger",	  79,service_tcprelay	},
    {1,1, "http",	  80,service_http,	SERV_HTTP },
    {1,0, "https",       443,service_https	},
    {1,0, "pop",         110,service_pop	},
    {0,0, "ident",       113,service_tcprelay	},
    {1,0, "nntp",	 119,service_nntp	},
    {1,0, "news",	 119,service_nntp	},
    {0,0, "nbt",	 139,service_nbt	},
    {0,0, "prospero",    191,service_udprelay	},
    {0,0, "archie",      191,service_udprelay	},
    {0,0, "wais",	 210,service_wais,	SERV_WAIS },
    {0,0, "ldap",        389,service_ldap	},
    {1,0, "lpr",         515,service_lpr	},
    {0,0, "X",	        6000,service_X		},
    {0,0, "syslog",      514,service_syslog	},

    {1,0, "ftpget",       21,service_ftpget	},
    {0,0, "talk",        517,service_tcprelay	},
    {1,0, "socks",      1080,service_socks	},
    {1,0, "thruway",    8715,0			},
    {0,0, "cuseeme",    7648,service_tcprelay	},

    {0,0, "delegate",   9999,service_delegate	},
    {0,0, "tcprelay",      0,service_tcprelay	},
    {0,0, "udprelay",      0,service_udprelay	},
    {0,0, "udprelay1",     0,service_udprelay1	},
    {0,0, "icp",        3130,service_icp	},

    {0,0, "coupler",       0,service_coupler	},
    {0,0, "teleport",   8000,service_teleport	},
    {1,0, "vsap",          0,service_vsap	},

/*  {0,0, "tunnel",   VPROTO,service_tunnel	}, */
    {0,0, "dump",     VPROTO,service_dump	},
    {0,0, "pgps",     VPROTO,service_pgps	},
    {0,0, "file",     VPROTO,service_file	},
    {0,0, "cfi",      VPROTO,service_cfi	},
    {0,0, "cgi",      VPROTO,service_cgi	},
    {0,0, "sh",       VPROTO,service_sh		},
    {0,0, "nsh",      VPROTO,service_nsh	},
    {1,0, "shell",    VPROTO,service_shell	},
    {1,0, "system",   VPROTO,service_system	},
    {1,0, "exec",     VPROTO,service_exec	},
    {1,0, "admin",    VPROTO,service_admin	},

    {0,0, "builtin",  VPROTO,0			},
    {0,0, "override", VPROTO,0			},
    {0,0, "readonly", VPROTO,0			},

    {0}
};
