/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1994 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, modify, and distribute this material for any
purpose and without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies, and
that the name of ETL not be used in advertising or publicity pertaining
to this material without the specific, prior written permission of an
authorized representative of ETL.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	smtp.c (SMTP proxy)
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	941016	created
//////////////////////////////////////////////////////////////////////#*/
#include <stdio.h>
#include <ctype.h>
#include "delegate.h"
#define LNSIZE  1024

extern char *TIMEFORM_RFC822;
extern char *wordscan();

/*
 *	RCPT To: recipients -> Recipients[]
 *	MAIL From: originator -> Sender[]
 */
static char Sender[256];
static char RecipientLocal[256];

static char *Recipients;
static int   RecipientsSize;

extern char *getClientUserH();
extern char *malloc();

SMTP_lfprintf(log,tosc,fmt,a,b,c,d,e,f,g,h,i,j,k,l,m,n)
	FILE *log,*tosc;
	char *fmt,*a,*b,*c,*d,*e,*f,*g,*h,*i,*j,*k,*l,*m,*n;
{	char stime[32];
	char stat[0x8000];

	getTimestamp(stime);
	sprintf(stat,fmt,a,b,c,d,e,f,g,h,i,j,k,l,m,n);

	if( log != NULL ){
		fprintf(log,"%s [%d] ",stime,Getpid());
		if( tosc == NULL
		&& *stat != '<' && *stat != '>' && !isdigit(*stat) )
			fprintf(log,"* "); /* internal action */
		fprintf(log,fmt,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
	}

	sv1log(fmt,a,b,c,d,e,f,g,h,i,j,k,l,m,n);

	if( tosc )
	fprintf(tosc,fmt,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
}
#define lfprintf	SMTP_lfprintf

SMTP_relay_stat(fs,tc,resp)
	FILE *fs,*tc;
	char *resp;
{	char rcode[4];
	char respb[1024];

	if( resp == 0 )
		resp = respb;

	rcode[0] = 0;
	for(;;){
		if( fgets(resp,LNSIZE,fs) == NULL ){
			sv1log("SC-EOF.\n");
			return -1;
		}
		sv1log("SMTP > %s",resp);
		if( tc != NULL )
			if( Fputs(resp,tc) == EOF )
				return -1;

		if( resp[3] == '-' ){
			if( rcode[0] == 0 )
				strncpy(rcode,resp,3);
		}else{
			if( rcode[0] == 0 || strncmp(resp,rcode,3) == 0 )
				break;
		}
	}
	return atoi(resp);
}

SMTP_mount_rcpt(req)
	char *req;
{	char com[256],field[256],rcpt[1024],CLRF[256];
	char url[1024],login[1024];

	CLRF[0] = 0;
	if( sscanf(req,"%s %[^:]: %[^\r\n]%[\r\n]",com,field,rcpt,CLRF) < 3 )
		return 0;

	canon_mbox(rcpt,url);
	mount_url_to("POST",url);

	if( strcmp(rcpt,url) != 0 ){
		sv1log("%s => %s\n",rcpt,url);
		if( sscanf(url,"smtp://%[^:/]",login) ){
			if( strcmp(login,"-") == 0 )
				return -1;

			sprintf(req,"%s %s:<%s>%s",com,field,login,CLRF);
			sv1log(">>>> %s",req);
		}
	}
	return 0;
}

SMTP_relay_req(fc,tc,ts,req)
	FILE *fc,*tc,*ts;
	char *req;
{	char xreq[LNSIZE],*jp,*ap,jc;
	char com[LNSIZE];

	if( fgets(req,LNSIZE,fc) == NULL ){
		sv1log("CS-EOF.\n");
		Fputs("QUIT\r\n",ts);
		return -1;
	}
	sv1log("SMTP < %s",req);
	sscanf(req,"%s",com);

	if( strcasecmp(com,"HELO") == 0 ){
		char domain[1024],CLRF[8];
		if( sscanf(req,"%*s %[^\r\n]%[\r\n]",domain,CLRF) )
			sprintf(req,"HELO %s SMTP-DeleGate/%s%s",domain,
				DELEGATE_ver(),CLRF);
	}else
	if( strcasecmp(com,"RCPT") == 0 ){
		if( SMTP_mount_rcpt(req) < 0 ){
			fputs("553 Forbidden.\r\n",tc);
			fflush(tc);
			sv1log("Rejected: %s",req);
			return -1;
		}
	}

	/* JIS codes shuld not be passed to the SMTP server... */
	TO_EUC(req,xreq);
	if( strcmp(req,xreq) != 0 ){
		ap = req;
		for( jp = xreq; jc = *jp; jp++ )
			if( (jc & 0x80) == 0 )
				*ap++ = jc;
		*ap = 0;
		sv1log("SMTP < %s",req);
	}

	if( Fputs(req,ts) == EOF )
		return -1;
	return 0;
}

static doRCPT(Conn,indata,tc,arg,log)
	Connection *Conn;
	FILE *tc;
	char *arg;
	FILE *log;
{	char *tp;
	char domain[1024],recipient[1024];

	RecipientLocal[0] = domain[0] = 0;
	if( tp = strchr(arg,'<') )
		sscanf(tp,"<%[^@>]@%[^>]",RecipientLocal,domain);
	else	sscanf(arg,"%*[^:]: %[^@]@%s",RecipientLocal,domain);

	strcpy(recipient,RecipientLocal);
	if( domain[0] ){
		strcat(recipient,"@");
		strcat(recipient,domain);
	}
	if( Recipients == NULL ){
		RecipientsSize = 0x8000;
		Recipients = malloc(RecipientsSize);
		Recipients[0] = 0;
	}
	if( Recipients[0] != 0 )
		strcat(Recipients,",");
	strcat(Recipients,recipient);

	sv1log("Recipient: <%s> %s\n",recipient,arg);
	lfprintf(log,tc,"250 %s... Recipient ok\r\n",arg);
	return 0;
}
static doMAIL(Conn,tc,arg,log)
	Connection *Conn;
	FILE *tc;
	char *arg;
{	char *tp;

	Sender[0] = 0;
	if( tp = strchr(arg,'<') )
		sscanf(tp,"<%[^>]",Sender);
	else	sscanf(arg,"%*[^:]: %s",Sender);
	sv1log("Sender: <%s> %s\n",Sender,arg);
	lfprintf(log,tc,"250 %s... Sender ok\r\n",Sender);
	return 0;
}

char *MAILGATE = "mailgate";
static doDATA(Conn,indata,tc,fc,myhost,clhost,log)
	Connection *Conn;
	FILE *indata;
	FILE *tc,*fc;
	char *myhost,*clhost;
	FILE *log;
{	char line[1024];
	int off1;
	int off2;
	char *cpath;
	int sent;
	char *rb,*rv[0x2000];
	int ri,rc;
	char header,fname[1024],fvalue[1024],Cte[256];

	if( Recipients == NULL ){
		lfprintf(log,tc,"503 Need RCPT (recipient)\r\n");
		fflush(tc);
		return -1;
	}
	if( Sender[0] == NULL ){
		lfprintf(log,tc,"503 Need MAIL (sender)\r\n");
		fflush(tc);
		return -1;
	}

	lfprintf(log,tc,
		"354 Enter mail, end with \".\" on a line by itself\r\n");
	fflush(tc);

	off1 = ftell(indata);
	Cte[0] = 0;
	header = 1;
	while( fgets(line,sizeof(line),fc) ){
		if( line[0] == '.' && (line[1] == '\r' || line[1] =='\n') ){
			lfprintf(log,NULL,">>> %s",line);
			break;
		}

		if( header )
		if( line[0] == '\r' || line[0] == '\n' )
			header = 0;
		else
		if( strncasecmp(line,"Content-Transfer-Encoding",25) == 0 ){
			fvalue[0] = 0;
			sscanf(line,"%[^ :]%*[ :]%s",fname,fvalue);
			if( Cte[0] ){
				lfprintf(log,NULL,"ignored -- dup. %s: %s %s\n",
					fname,Cte,fvalue);
				continue;
			}
			strcpy(Cte,fvalue);
		}

		fputs(line,indata);
	}

	off2 = ftell(indata);
	sent = 0;

	if( Sender[0] && strcaseeq(RecipientLocal,MAILGATE) ){
		fseek(indata,0,0);
		sent = MAILGATE_returnUID(Conn,tc,indata,myhost,clhost,log);
		return sent;
	}

	rb = strdup(Recipients);

#ifdef OPTIMIZE
	fseek(indata,off1,0);
	sent = SMTPgateway(Conn,tc,indata,Sender,Recipients,log);
	if( sent < 0 )
		goto EXIT;
#else
	rc = stoV(rb,0x2000,rv,',');
	for( ri = 0; ri < rc; ri++ ){
		fseek(indata,off1,0);
		sent = SMTPgateway(Conn,tc,indata,Sender,rv[ri],log);
		if( sent < 0 )
			goto EXIT;
	}
#endif
	if( 0 < sent )
		lfprintf(log,tc,"250 Mail accepted\r\n");
	else	lfprintf(log,tc,"550 <%s> User Unknown\r\n",Recipients);
	fflush(tc);

	free(Recipients);
	Recipients = 0;
	fseek(indata,off2,0);

EXIT:
	free(rb);
	return sent;
}

char *MailGate(Conn)
	Connection *Conn;
{	static char *mbox;
	char buf[128],host[128],dom[128];

	if( mbox )
		return mbox;
	ClientIF_H(Conn,host);
	getFQDN(host,dom);
	if( IsInetaddr(dom) )
		sprintf(buf,"%s@[%s]",MAILGATE,dom);
	else	sprintf(buf,"%s@%s",MAILGATE,dom);
	mbox = strdup(buf);
	return mbox;
}

extern FILE *SMTP_POST();
MAILGATE_returnUID(Conn,tc,indata,myhost,clhost,log)
	Connection *Conn;
	FILE *tc;
	FILE *indata;
	char *myhost,*clhost;
{	FILE *fp;
	char from[128],muid[128],date[128];

	if( streq(myhost,clhost) && SERVER_PORT() == 25 ){
		lfprintf(log,tc,"500 don't connect with myself to deliver.\r\n");
		return -1;
	}

	mboxid(Sender,clhost,muid,date);
	if( (fp = SMTP_POST(clhost,25,Sender,MailGate(Conn))) == NULL ){
		lfprintf(log,tc,"500 cannot connect SMTP server to return.\r\n");
		return -1;
	}

lfprintf(log,fp,"To: %s\r\n",Sender);
lfprintf(log,fp,"Subject: receipt to your mail\r\n");
 fprintf(fp,"\r\n");
lfprintf(log,fp,"YOUR MAIL ADDRESS IS REGISTERED AND ASSIGNED A UNIQUE IDENTIFIER:\r\n");
 fprintf(fp,"\r\n");
lfprintf(log,fp,"MUID: %s\r\n",muid);
lfprintf(log,fp,"MBOX: <%s>\r\n",Sender);
lfprintf(log,fp,"DATE: %s\r\n",date);
 fprintf(fp,"\r\n");
 fprintf(fp,"--INPUT--\r\n");
	copyfile1(indata,fp);
 fprintf(fp,"--\r\n");
	pclose(fp);

	lfprintf(log,tc,"250 Mail accepted\r\n",Recipients);
	return 1;
}

extern FILE *openMbox();
mboxid(mbox,mailer,muid,date)
	char *mbox,*mailer,*muid,*date;
{	char src[256],md5id[128],sdate[32];
	char line[1024];
	int now;
	FILE *fp;
	int exist;

	muid[0] = date[0] = 0;
	fp = openMbox(0,mbox,muid);
	if( fp != NULL ){
		fgets(line,sizeof(line),fp); sscanf(line,"MUID: %s",muid);
		fgets(line,sizeof(line),fp); sscanf(line,"DATE: %[^\r\n]",date);
	}
	if( muid[0] && date[0] )
		return 1;

	now = time(0);
	StrftimeGMT(date,sizeof(date),TIMEFORM_RFC822,now);
	sprintf(src,"%d<%s>",now,Sender);
	toMD5(src,md5id);
	md5id[6] = 0;
	strtoupper(md5id,md5id);
	StrftimeGMT(sdate,sizeof(sdate),"%y%m%d",now);
	sprintf(muid,"%s-%s",sdate,md5id);

	fp = openMbox(1,mbox,muid);
	if( fp == NULL )
		return -1;

	fprintf(fp,"MUID: %s\r\n",muid);
	fprintf(fp,"DATE: %s\r\n",date);
	fprintf(fp,"MAILER: %s\r\n",mailer);
	fclose(fp);
	return 0;
}

static SMTPserver(Conn,fc,tc)
	Connection *Conn;
	FILE *fc,*tc;
{	char myhost[256],clhost[128],stime[128];
	char req[1024],*wp,com[1024],arg[1024];
	FILE *indata,*log,*TMPFILE();
	int sent = 0;

	getClientHostPort(Conn,clhost);
	ClientIF_name(Conn,FromC,myhost);
	getFQDN(myhost,myhost);

	StrftimeLocal(stime,sizeof(stime),TIMEFORM_RFC822,time(0));
	indata = TMPFILE("SMTP/DATA");
	log = TMPFILE("SMTP/LOG");

	lfprintf(log,tc,"220 %s SMTP/DeleGate/%s ready at %s\r\n",
		myhost,DELEGATE_ver(),stime);
	fflush(tc);

	for(;;){
		if( fgets(req,sizeof(req),fc) == 0 )
			break;
		fputs(req,indata);
		lfprintf(log,NULL,">>> %s",req);

		wp = wordscan(req,com);
		linescan(wp,arg,sizeof(arg));
		sv1log("SMTP [%s][%s]\r\n",com,arg);

		if( strcaseeq(com,"HELO") ){
			lfprintf(log,tc,"250 %s Hello %s (%s)\r\n",myhost,arg,
				clhost);
		}else
		if( strcaseeq(com,"RCPT") ){ /* To */
			if( (sent = doRCPT(Conn,indata,tc,arg,log)) < 0 )
				break;
		}else
		if( strcaseeq(com,"MAIL") ){ /* From */
			if( (sent = doMAIL(Conn,tc,arg,log)) < 0 )
				break;
		}else
		if( strcaseeq(com,"DATA") ){
			if( (sent = doDATA(Conn,indata,tc,fc,myhost,clhost,log)) < 0 )
				break;
			fflush(tc);
			fseek(log,0,0);
		}else
		if( strcaseeq(com,"QUIT") ){
			lfprintf(log,tc,"221 %s closing connection\r\n",myhost);
			break;
		}else{
			lfprintf(log,tc,"500 Command unrecognized\r\n");
		}
		fflush(tc);
	}
	fflush(tc);
}

service_smtp(Conn)
	Connection *Conn;
{	FILE *fc,*ts,*fs,*tc;
	char req[LNSIZE],stat[LNSIZE];
	int rcode;

	fc = fdopen(FromC,"r");
	tc = fdopen(ToC,  "w");
	fs = NULL;
	ts = NULL;

	if( ToS < 0 || FromS < 0 ){
		if( isMYSELF(DFLT_HOST) )
			SMTPserver(Conn,fc,tc);
		goto EXIT;
	}else{
		fs = fdopen(FromS,"r");
		if( SMTP_relay_stat(fs,tc,stat) < 0 )
			goto EXIT;
		ts = fdopen(ToS,  "w");
	}

	for(;;){
		if( SMTP_relay_req(fc,tc,ts,req) < 0 )
			break;

		if( (rcode = SMTP_relay_stat(fs,tc,stat)) < 0 )
			break;

		if( rcode == 354 ){ /* DATA */

			if( filter_withCFI(Conn,XF_FTOSV) )
				putMESSAGEline(ts,"mime","DATA");

			PGPencodeMIME(fc,ts);
			fflush(ts);
			if( (rcode = SMTP_relay_stat(fs,tc,stat)) < 0 )
				break;
		}
		if( strcasecmp(req,"QUIT\r\n") == 0 ){
			sv1log("CS-QUIT\n");
			break;
		}
	}
EXIT:
	fclose(fc);
	fclose(tc);
	if( fs != NULL ) fclose(fs);
	if( ts != NULL ) fclose(ts);
	return 0;
}

SMTP_putserv(log,fs,ts,resp,fmt,a,b,c,d)
	FILE *log;
	FILE *fs,*ts;
	char *fmt,*a,*b,*c,*d;
	char *resp;
{	char req[1024];

	sprintf(req,fmt,a,b,c,d);
	fputs(req,ts);
	fflush(ts);

	if( log != NULL )
		lfprintf(log,NULL,"<<< %s",req);
	else	sv1log("SMTP < %s",req);

	SMTP_relay_stat(fs,NULL,resp);
	if( log != NULL )
		lfprintf(log,NULL,"%s",resp);
}

canon_mbox(addr,xaddr)
	char *addr,*xaddr;
{	char *dp,*np;
	int lev;

	strcpy(xaddr,addr);
	if( dp = strchr(xaddr,'<') ){
		strcpy(xaddr,dp+1);
		if( dp = strchr(xaddr,'>') )
			*dp = 0;
	}else
	if( dp = strchr(xaddr,'(') ){
		lev = 0;
		for( np = dp+1; *np; np++ ){
			if( *np == ')' ){
				if( lev == 0 ){
					np++;
					break;
				}else	lev--;
			}
			if( *np == '(' )
				lev++;
		}
		strcpy(dp,np);
	}
}
static opening(fs,ts,to,from,dodata,log)
	FILE *fs,*ts;
	char *to,*from;
	FILE *log;
{	char myhost[128];
	char xto[1024],xfrom[1024];
	char resp[2048];

	SMTP_relay_stat(fs,NULL,resp);

	if( gethostName(fileno(ts),myhost,"%H") <= 0 )
		gethostname(myhost,sizeof(myhost));
	getFQDN(myhost,myhost);
	SMTP_putserv(log,fs,ts,resp,"HELO %s SMTP-DeleGate/%s\r\n",
		myhost,DELEGATE_ver());

	if( from ){
		canon_mbox(from,xfrom);
		sv1log("SMTP : From: %s -- %s\n",xfrom,from);
		SMTP_putserv(log,fs,ts,resp,"MAIL From: %s\r\n",xfrom);
		if( resp[0] == '5' )
			return -1;
	}
	if( to && to[0] ){
		canon_mbox(to,xto);
		sv1log("SMTP : To: %s -- %s\n",xto,to);
		SMTP_putserv(log,fs,ts,resp,"RCPT To: %s\r\n",xto);
		if( resp[0] == '5' )
			return -1;
	}
	if( dodata )
		SMTP_putserv(log,fs,ts,resp,"DATA\r\n");
	return 0;
}

SMTP_open(Conn,fpv,host,port,to,from,dodata,log)
	Connection *Conn;
	FILE *fpv[];
	char *host;
	char *to,*from;
	FILE *log;
{	FILE *fs,*ts;

	set_realserver(Conn,"smtp",host,port);
	if( connect_to_serv(Conn,FromC,ToC,0) < 0 )
		return -1;

	fs = fdopen(FromS,"r");
	ts = fdopen(ToS,"w");

	if( opening(fs,ts,to,from,dodata,log) != 0 ){
		char resp[1024];
		SMTP_putserv(log,fs,ts,resp,"QUIT\r\n");
		fclose(ts);
		fclose(fs);
		return -1;
	}

	fpv[0] = fs;
	fpv[1] = ts;
	return ToS;
}

extern FILE *TMPFILE();
validateEmailAddr(addr,checkuser)
	char *addr;
{	Connection ConnBuf,*Conn = &ConnBuf;
	FILE *fpv[2],*log;
	int svsock;
	char user[256],host[256],mxhost[256];
	char addrb[256];

	RFC822_strip_comment(addr,addrb);
	addr = addrb;

	if( sscanf(addr,"%[^@]@%s",user,host) != 2 )
		return -1;
	if( strcmp("localhost",host) == 0 )
		return -1;
	if( gethostint_nbo("localhost") == gethostint_nbo(host) )
		return -1;

	sprintf(mxhost,"-MX.%s",host);
	if( gethostint_nbo(mxhost) != -1 )
		strcpy(host,mxhost);

	if( checkuser == 0 )
		user[0] = 0;

	ConnInit(Conn);
	Conn->from_myself = 1;
	Conn->co_mask |= CONN_NOPROXY;

	log = TMPFILE("emailValid");
	svsock = SMTP_open(Conn,fpv,host,25,user,DELEGATE_MANAGER,0,log);
	fclose(log);

	if( svsock < 0 )
		return -1;
	else{
		char resp[1024];
		SMTP_putserv(log,fpv[0],fpv[1],resp,"QUIT\r\n");
		fclose(fpv[0]);
		fclose(fpv[1]);
		return 0;
	}
}

FILE *SMTP_POST(host,port,to,from)
	char *host,*to,*from;
{	int io[2];
	int server;
	FILE *ts,*fs,*fc;
	char line[1024],resp[1024];

	sv1log("SMTP_POST at %s:%d to:%s from:%s\n",host,port,to,from);
	server = client_open("openMailPoster","smtp",host,port);
	if( server < 0 ){
		sv1log("SMTP: cannot connect: %s:%d.\n",host,port);
		return NULL;
	}

	Socketpair(io);
	if( Fork("SMTP_POST") != 0 ){
		close(io[0]);
		close(server);
		return fdopen(io[1],"w");
	}

	close(io[1]);
	fc = fdopen(io[0],"r");

	fs = fdopen(server,"r");
	ts = fdopen(server,"w");

	opening(fs,ts,to,from,1,NULL);

	for(;;){
		if( fgets(line,sizeof(line),fc) == NULL )
			break;
		fputs(line,ts);
	}
	SMTP_putserv(NULL,fs,ts,resp,".\r\n");
	SMTP_putserv(NULL,fs,ts,resp,"QUIT\r\n");

	fclose(fc);
	fclose(ts);
	fclose(fs);
	_Finish(0); /* avoid duplicate flush of stream buffer ... */
}

/*
MAIL_verify(addr)
	char *addr;
{	char user[256],domain[256];
	int svsock;
	FILE *ts,*fs;
	char myhost[128],resp[1024];

	sscanf(addr,"%[^@]@%s",usr,domain);

	svsock = connect_to("smtp",host,port,-1,-1,0);
	if( svsock < 0 )
		return -1;
	ts = fdopen(svsock,"w");
	fs = fdopen(svsock,"r");


	gethostname(myhost,sizeof(myhost));
	fprintf(ts,"HELO %s (SMTP-DeleGate/%s)\r\n",myhost,DELEGATE_ver());
	fflush(ts);
	SMTP_relay_stat(fs,NULL,resp);

	fprintf(ts,"VRFY %s\r\n",addr);
	fflush(ts);
	SMTP_relay_stat(fs,NULL,resp);

	fclose(ts);
	fclose(fs);
}
*/

char *DELEGATE_SMTPSERVER;
scan_SMTPSERVER(smtpserver)
	char *smtpserver;
{
	if( smtpserver )
		Strdup(&DELEGATE_SMTPSERVER,smtpserver);
}

#define MAILER	"/usr/lib/sendmail -t"
FILE *openMailPoster(to,from)
	char *to,*from;
{	FILE *out;
	char mailer[1024];
	int host[512];
	int port;

	out = NULL;
	if( DELEGATE_SMTPSERVER ){
		sprintf(mailer,"SMTPSERVER %s",DELEGATE_SMTPSERVER);
		port = 25;
		sscanf(DELEGATE_SMTPSERVER,"%[^:]:%d",host,&port);
		out = SMTP_POST(host,port,to,from);
		sv1log("#### SMTPSERVER [%x] %s\n",out,DELEGATE_SMTPSERVER);
	}
	if( out == NULL ){
		sprintf(mailer,MAILER,to);
		out = popen(mailer,"w");
	}
	if( out != NULL )
		fprintf(out,"X-Mailer: %s\n",mailer);
	return out;
}


FILE *SMTP_getEXPN(addr)
	char *addr;
{	char user[256],host[256];
	int server;
	FILE *ts,*fs;
	char stat[256];
	FILE *afp,*TMPFILE();
	int nlines;

	user[0] = host[0] = 0;
	sscanf(addr,"%[^@]@%s",user,host);
	server = client_open("SMTPGATE/EXPN","smtp",host,25);
	if( server < 0 ){
		sv1log("#### cannot EXPN <%s>\n",addr);
		return NULL;
	}

	fs = fdopen(server,"r");
	if( fgets(stat,sizeof(stat),fs) == NULL ){
		sv1log("#### EXPN error -- server closed\n");
		fclose(fs);
		return NULL;
	}
	sv1log("#### %s",stat);
	if( atoi(stat) != 220 ){
		fclose(fs);
		return NULL;
	}

	ts = fdopen(server,"w");
	fprintf(ts,"EXPN %s\r\n",user);
	fflush(ts);

	if( fgets(stat,sizeof(stat),fs) == NULL ){
		sv1log("#### EXPN error -- server closed\n");
		fclose(afp);
		afp = NULL;
	}else
	if( atoi(stat) != 250 ){
		sv1log("#### EXPN error -- %s",stat);
		fclose(afp);
		afp = NULL;
	}else{
		afp = TMPFILE("SMTPGATE/EXPN");
		fputs(stat,afp);
		for( nlines = 1; strncmp(stat,"250-",4) == 0; nlines++ ){
			if( fgets(stat,sizeof(stat),fs) == NULL )
				break;
			fputs(stat,afp);
		}
		fflush(afp);
		fseek(afp,0,0);
		sv1log("#### EXPN got <%s> -- %d lines\n",addr,nlines);
		return afp;
	}
	fclose(ts);
	fclose(fs);
	return afp;
}
