/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1994 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, modify, and distribute this material for any
purpose and without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies, and
that the name of ETL not be used in advertising or publicity pertaining
to this material without the specific, prior written permission of an
authorized representative of ETL.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	service.c (DeleGatable services)
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	940303	created
	940623	made per port restriction configurable
//////////////////////////////////////////////////////////////////////#*/
#include "delegate.h"

#include "service.h"
extern Service services[];

extern char *stralloc();
extern char *wordscan();

char D_SERVICE_BYPORT[] = "-";

extern int IamPrivateMASTER;
extern int myPrivateMASTER;
extern int BREAK_STICKY;
static sv1mlog(fmt,a,b,c,d,e,f,g)
	char *fmt,*a,*b,*c,*d,*e,*f,*g;
{
	if( IamPrivateMASTER || myPrivateMASTER )
		return;
	sv1log(fmt,a,b,c,d,e,f,g);
}

static servicex(service)
	char *service;
{	int si;
	Service *sp;
	char *name;

	for( si = 1; services[si].s_name; si++ ){
		sp = &services[si];
		if( strcaseeq(sp->s_name,service) )
			return si;
	}
	return 0;
}
serviceport(service)
	char *service;
{	int si;

	if( si = servicex(service) )
		return services[si].s_iport;
	else	return 0;
}
static withcache(proto)
	char *proto;
{	int si;

	if( si = servicex(proto) )
		return services[si].s_withcache;
	else	return 0;
}

extern int service_delegate();
static IFUNC get_servfunc(Conn, clsock, withcachep, selfackp )
	Connection *Conn;
	int *withcachep;
	int *selfackp;
{	int si;
	Service *sp;
	char *service;
	int iport;
	int byport;

	*withcachep = 0;
	*selfackp = 0;

	service = DFLT_PROTO;

	iport = DFLT_PORT;
	byport = streq(service,D_SERVICE_BYPORT);

	for( si = 1; services[si].s_name; si++ ){
	    sp = &services[si];
	    if( !byport && strcaseeq(sp->s_name,service)
	     ||  byport && iport && sp->s_iport == iport
	    ){
		if( byport )
			strcpy(DFLT_PROTO,sp->s_name);

		if( DFLT_PORT == 0 )
			DFLT_PORT = sp->s_iport;
		*withcachep = sp->s_withcache;
		*selfackp = sp->s_selfack;

		if( DFLT_HOST[0] == 0 )
			if( sp->s_host )
				strcpy(DFLT_HOST,sp->s_host);

		return sp->s_client;
	    }
	}
	return service_delegate;
}

scan_FORCEON1(proto)
	char *proto;
{	int relay;
	int si;

	relay = 1;
	if( *proto == '-' ){ relay = 0;  proto++; }
	if( *proto == '!' ){ relay = -1; proto++; }
	if( strcaseeq(proto,"all") ){
		for( si = 1; services[si].s_name; si++ )
			services[si].s_forcerelay = relay;
	}else
	if( si = servicex(proto) ){
		services[si].s_forcerelay = relay;
		Verbose("FORCEON: %s\n",proto);
	}else	sv1log("FORCEON: %s ?\n",proto);
	return 0;
}
static callback1(proto)
	char *proto;
{	int callback;
	int si;

	callback = 1;
	if( *proto == '-' ){
		callback = 0;
		proto++;
	}
	if( strcaseeq(proto,"all") ){
		for( si = 1; services[si].s_name; si++ )
			services[si].s_nocallback = !callback;
	}else
	if( si = servicex(proto) )
		services[si].s_nocallback = !callback;
	else	sv1log("CALLBACK: %s ?\n",proto);
	return 0;
}

scan_PERMIT(Conn,protolist)
	Connection *Conn;
	char *protolist;
{	char *pn,*pv[64];
	int si,pi;

	pi = 0;
	for( si = 1; pn = services[si].s_name; si++ )
		pv[pi++] = pn;
	pv[pi] = 0;
	scan_PERMITV(Conn,protolist,pv);
}

extern int ClientsideHost;
extern int ClientSockHost;

pushClientInfo(Conn)
	Connection *Conn;
{	char addr[64];

	getClientHostPortAddr(Conn,NULL,addr);
	ClientsideHost = gethost_addr(1,addr,NULL);
	ClientSockHost = HostPortIFclnt(Conn,ClientSock,NULL,NULL,NULL);
}
popClientInfo()
{
	ClientsideHost = -1;
	ClientSockHost = -1;
}

permitted_readonly(Conn,proto)
	Connection *Conn;
	char *proto;
{
	if( method_permitted(Conn,"readonly",NULL)
	 || method_permitted(Conn,proto,"XXXX") == 0 /* explicitly defined */
	 && method_permitted(Conn,proto,"readonly") != 0 ){
		sv1log("#### %s: READ-ONLY\n",proto);
		return 1;
	}
	return 0;
}
method_permitted(Conn,proto,method)
	Connection *Conn;
	char *proto,*method;
{	char shost[512];
	int sport;
	char protomethod[512];
	int acceptable;

	sport = getClientHostPort(Conn,shost);
	pushClientInfo(Conn);
	if( method != NULL )
		sprintf(protomethod,"%s/%s",proto,method);
	else	strcpy(protomethod,proto);
	acceptable = DELEGATE_permit(Conn,protomethod,DST_HOST,DST_PORT,
			shost,sport,serviceport(proto));
	popClientInfo();
	return acceptable;
}

service_permitted2(Conn,service,silent)
	Connection *Conn;
	char *service;
{	int clsock;
	int acceptable;
	char shost[512];
	int sport;

	if( Conn->from_myself )
		return 1;

	clsock = ClientSock;
	sport = getClientHostPort(Conn,shost);
	if( sport == 0 ){
		sv1log("Cannot get peer name: fd=[%d]\n",clsock);
		return 0;
	}
	pushClientInfo(Conn);
	acceptable = PERMITTED_ACCESS(Conn,shost,sport,serviceport(service));
	popClientInfo();

	if( acceptable && TeleportHost[0] ){
		strcpy(shost,TeleportHost);
		sport = TeleportPort;
		acceptable = PERMITTED_ACCESS(Conn,shost,sport,serviceport(service));
	}

	if( acceptable ){
		Verbose("PERMITTED: %s://%s\n",DST_PROTO,DST_HOST);
	}else{
		if( !silent ){
			logReject(Conn,1,shost,sport);
			delayReject(Conn,1,"DELEGATE",service,shost,sport,"","",
			"Forbidden by DeleGate");
		}
		Conn->co_error = CO_REJECTED;
	}
	return acceptable;
}

int DELAY_REJECT_S = 60;
int DELAY_UNKNOWN_S = 60;
int DELAY_REJECT_P = 0;
int DELAY_UNKNOWN_P = 0;
int DELAY_ERROR = 30;

static delay1(dspec)
	char *dspec;
{	char what[128];
	int delay;

	delay = 0;
	sscanf(dspec,"%[^:]:%d",what,&delay);

	if( strcaseeq(what,"reject")    ) DELAY_REJECT_S = delay; else
	if( strcaseeq(what,"unknown")   ) DELAY_UNKNOWN_S = delay; else
	if( strcaseeq(what,"reject_p")  ) DELAY_REJECT_P = delay; else
	if( strcaseeq(what,"unknown_p") ) DELAY_UNKNOWN_P = delay; else
	{
		sv1tlog("ERROR: unknown DELAY=%s\n",what);
	}
	return 0;
}
scan_DELAY(Conn,sdelay)
	Connection *Conn;
	char *sdelay;
{
	scan_commaList(sdelay,0,delay1);
}

static delayClose(path,clsock,delay)
	char *path;
{	char buf[1024];
	int start;
	int wsock;
	int fc,fv[2],rfv[2],nready;

	fc = 0;
	fv[fc++] = clsock;

	wsock = server_open_localhost("doDelay",path,1);
	if( 0 <= wsock )
		fv[fc++] = wsock;
	else	sv1log("#### doDelay: bind failed.\n");

	while( 0 < delay ){
		start = time(0L);
		if( 0 < (nready = PollIns(delay*1000,fc,fv,rfv)) )
		if( 1 < fc && 0 < rfv[1] ){
			sv1log("doDelay: pushed out.\n");
			break;
		}
		if( readTimeout(clsock,buf,sizeof(buf),1) <= 0 )
			break;
		sleep(1);
		delay = delay - (time(0L) - start) - 1;
	}
	close(wsock);
	unlink(path);
}

extern unsigned int FQDN_hash();
static doDelay(Conn,method,maxdelay,cpath,spath,countp)
	Connection *Conn;
	char *method,*cpath,*spath;
	int *countp;
{	char path[1024],file[256];
	char host[256],addr[256];
	long count,mtime,age,dodelay;
	int delays;
	int wsock;

	if( maxdelay <= 0 )
		return 0;

	/* The client host may make next connection without waiting the
	 * closing of the current connection.  In such case, delaying all
	 * connection to close will make a pile of waiting process for the
	 * client.  Thus push out previous process if exists.
	 */
	getClientHostPortAddr(Conn,host,addr);
	sprintf(file,"%02d/%s:%s",FQDN_hash(host)%32,addr,host);

	get_delaysock(file,spath);
	wsock = client_open_localhost("doDelay",spath,1);
	if( 0 <= wsock ){
		sv1log("doDelay: push out previous delay.\n");
		close(wsock);
	}

	/* peer count is not available ? */
	if( Conn->cl_count <= 0 )
		return 0;

	sprintf(path,"%s/%s",method,file);
	count = countUp(path,1,1,getpid(),&mtime,cpath);

	/* error counter is not available ? */
	if( count <= 0 || mtime == 0 )
		return 0;

	/* overlook the first error */
	if( count <= 1 )
		return 0;

	/* clear errors of long ago. */
	age = time(0L) - mtime;
	if( maxdelay < age ){
		sv1log("doDelay: clear old errors: count=%d,age=%d,delay=%d\n",
			count,age,maxdelay);
		count = countUp(path,1,0,getpid(),&mtime,cpath);
		return 0;
	}

	/* Do delay when errors occured in rapid succession.
	 * The age of the error coutner shows the interval of errors.
	 * The minimum interval should be long if the desirable delay is
	 * long, the situation where error is serious.
	 */
	dodelay = age <= maxdelay / 4 + 1;
	Verbose("doDelay: %d count=%d, age=%d, delay=%d\n",
		dodelay,count,age,maxdelay);
	if( !dodelay )
		return 0;

	/* reach the maximum delay in 20 errors. */
	*countp = count;
	delays = count * (maxdelay / 20 + 1);
	if( maxdelay < delays )
		delays = maxdelay;
	return delays;
}
logReject(Conn,self,shost,sport)
	Connection *Conn;
	char *shost;
{	char *what,*direct,server[256];

	HostPort(server,DST_PROTO,DST_HOST,DST_PORT);
	if( self ){
		what = "E-P: No permission";
		direct = "=>";
	}else{
		what = "E-R: Rejected";
		direct = "<=";
	}
	daemonlog("F","%s: %s:%d %s %s://%s\n",
		what, shost,sport, direct, DST_PROTO,server);
}
delayReject(Conn,self,method,sproto,shost,sport,dpath,referer,reason)
	Connection *Conn;
	char *method,*sproto;
	char *shost;
	char *dpath,*referer,*reason;
{	int delay;
	int delays,count;
	char cpath[1024],spath[1024];

	addRejectList(Conn,method,dpath,referer,"","",reason);

	if( self )
		delay = DELAY_REJECT_S;
	else	delay = DELAY_REJECT_P;
	delays = doDelay(Conn,"errors/reject",delay,cpath,spath,&count);
	if( delays == 0 )
		return;

	checkCloseOnTimeout(0);
	sv1log("doDelay: delaying reject*%d (%d/%dsecond) %s:%d[%d]\n",
		count, delays,delay, shost,sport,Conn->cl_count);
	ProcTitle(Conn,"(reject:%d)%s://%s/",delays,DST_PROTO,DST_HOST);
	delayClose(spath,FromC,delays);
	File_touch(cpath);
}
delayConnError(Conn,req)
	Connection *Conn;
	char *req;
{	int delay;
	char path[1024];
	char msg[0x4000];

/*
The delay should be done just after accept() ...

	delay = DELAY_ERROR;
	if( !doDelay(Conn,"error/comm",delay,path) )
		return;

	checkCloseOnTimeout(0);
	sv1log("delaying on communication error (%d)\n",delay);
	ProcTitle(Conn,"(error:%d)%s://%s/",delay,DST_PROTO,DST_HOST);
	delayClose(FromC,delay);
	File_touch(path);
*/
}
delayUnknown(Conn,self,req)
	Connection *Conn;
	char *req;
{	int delay;
	int delays,count;
	char cpath[1024],spath[1024];
	char shost[256];
	int sport;
	char *eol;

	eol = strtailchr(req) == '\n' ? "" : "\n";
	sport = getClientHostPort(Conn,shost);
	daemonlog("F","%s: %s:%d %s %s%s",
		"E-U: Unknown",shost,sport,"=>",req,eol);

	if( self )
		delay = DELAY_UNKNOWN_S;
	else	delay = DELAY_UNKNOWN_P;
	delays = doDelay(Conn,"errors/unknown",delay,cpath,spath,&count);
	if( delays == 0 )
		return;

	checkCloseOnTimeout(0);

	sv1log("doDelay: delaying unknown*%d (%d/%dseconds) %s%s",
		count, delays,delay, req,eol);

	ProcTitle(Conn,"(unknown:%d)%s://%s/",delays,DST_PROTO,DST_HOST);
	delayClose(spath,FromC,delays);
	File_touch(cpath);
}

service_permitted(Conn,service,silent)
	Connection *Conn;
	char *service;
{
	return service_permitted2(Conn,service,0);
}

scan_FORCEON(protolist)
	char *protolist;
{
	scan_commaList(protolist,0,scan_FORCEON1);
}
force_forward(Conn,proto)
	Connection *Conn;
	char *proto;
{	int si;

	if( si = servicex(proto) )
		return services[si].s_forcerelay;
	return 0;
}
scan_CALLBACK(protolist)
	char *protolist;
{	int si;

	for( si = 1; services[si].s_name; si++ )
		services[si].s_nocallback = 1;
	scan_commaList(protolist,0,callback1);
}
callback_it(proto)
	char *proto;
{	int si;

	if( si = servicex(proto) )
		return !services[si].s_nocallback;
	return 0;
}

/*
extern char D_SERVER[];
*/
extern char D_FROM[];
extern char D_USER[];
extern char D_SELECTOR[];

char *HelloWord(){ return "DeleGate-HELLO"; }
isHelloRequest(req)
	char *req;
{
	return strncmp(req,"DeleGate-HELLO",14) == 0;
}
static
scanHelloVer(resp,ver)
	char *resp;
	char *ver;
{
	ver[0] = 0;
	return sscanf(resp,"DeleGate-HELLO %[^ \t\r\n]",ver);
}

vercmp(ver1,ver2)
	char *ver1,*ver2;
{	int v1[3],v2[3],vi,diff;

	for( vi = 0; vi < 3; vi++ )
		v1[vi] = v2[vi] = 0;

	sscanf(ver1,"%d.%d.%d",&v1[0],&v1[1],&v1[2]);
	sscanf(ver2,"%d.%d.%d",&v2[0],&v2[1],&v2[2]);

	diff = 0;
	for( vi = 0; vi < 3; vi++ )
		if( diff = v1[vi] - v2[vi] )
			break;

	return diff;
}

extern int HELLO_TIMEOUT;
/*
 * -- HELLO_TIMEOUT COULD BE LONG ENOUGH IF NOT ALWAYS CHECKED
 * -- If already elapsed more than HELLO_TIMEOUT seconds since connection open
 * (= about since forked), then the client is no more waiting for HELLO reply,
 * and sending it is halmful for the client.
 */

static gotHELLO(Conn,tc,fieldname,value)
	Connection *Conn;
	FILE *tc;
	char *fieldname,*value;
{	char version[64],control[64];

	version[0] = control[0] = 0;
	sscanf(value,"%s %s",version,control);
	sv1mlog("CLIENT says: %s %s [%s]\n",fieldname,version,control);

	strcpy(ClientVER,version);
	if( streq(control,"NOACK") )   NoACK = 1; else
	if( streq(control,"NOSYNC") )  RespNOSYNC = 1;

	returnHELO(Conn,tc);
}
static toclnt(Conn,tc,fmt,a,b,c,d,e,f,g)
	Connection *Conn;
	FILE *tc;
	char *fmt;
	char *a,*b,*c,*d,*e,*f,*g;
{	char msg[1024];

	if( fileno(tc) == Conn->cl_sock ){
		fprintf(tc,fmt,a,b,c,d,e,f,g);
		fflush(tc);
	}else{
		sprintf(msg,fmt,a,b,c,d,e,f,g);
		write(Conn->cl_sock,msg,strlen(msg));
	}
}
static respHELO(Conn,tc)
	Connection *Conn;
	FILE *tc;
{
	toclnt(Conn,tc,"HELO DeleGate/%s\r\n",DELEGATE_ver());
}
static returnHELO(Conn,tc)
	Connection *Conn;
	FILE *tc;
{	char host[128],seed[128];

	if( NoACK )
		return;

	if( SaidHello )
		sv1log("#### ignore duplicate HELLO response.\n");

	if( !SaidHello ){
		if( RespNOSYNC ){
			/* Say HELLO later */
			SayHello = 1;
		}else{
			GetHostname(host,sizeof(host));
			sprintf(seed,"<%d.%d@%s>",getpid(),time((void*)0),host);
			toclnt(Conn,tc,"%s %s %s\r\n",
				HelloWord(),DELEGATE_ver(),seed);
			SayHello = 0;
		}
		SaidHello = 1;
	}
	ReturnACK = 1;
}
static returnAck(Conn,tc,fmt,a,b,c,d,e,f,g)
	Connection *Conn;
	FILE *tc;
	char *fmt,*a,*b,*c,*d,*e,*f,*g;
{	char msg[1024];

	if( NoACK )
		return;

	sprintf(msg,fmt,a,b,c,d,e,f,g);
	if( ReturnACK ){
		if( SayHello ){
			toclnt(Conn,tc,"%s %s\r\n",HelloWord(),DELEGATE_ver());
			SayHello = 0;
		}
		toclnt(Conn,tc,"%s",msg);
		ReturnACK = 0;
		sv1log("RETURNED ACK = %s",msg);
	}
}
returnAckOK(Conn,tc,reason)
	Connection *Conn;
	FILE *tc;
	char *reason;
{
	returnAck(Conn,tc,"200 OK: %s\r\n",reason);
}
returnAckCONTINUE(Conn,tc,reason)
	Connection *Conn;
	FILE *tc;
	char *reason;
{
	if( ReturnACK ){
		returnAck(Conn,tc,"201 CONTINUE: %s\r\n",reason);
		ReturnACK = 1;
	}
}
returnAckLOOP(Conn,tc,where)
	Connection *Conn;
	FILE *tc;
	char *where;
{
	returnAck(Conn,tc,"601 LOOP: %s\r\n",where);
}
returnAckDENIED(Conn,tc,reason)
	Connection *Conn;
	FILE *tc;
	char *reason;
{
	returnAck(Conn,tc,"602 DENIED: %s\r\n",reason);
}
returnAckUNKNOWN(Conn,tc,host)
	Connection *Conn;
	FILE *tc;
	char *host;
{
	returnAck(Conn,tc,"603 UNKNOWN_HOST: %s\r\n",host);
}
returnAckCANTCON(Conn,tc,host)
	Connection *Conn;
	FILE *tc;
	char *host;
{
	returnAck(Conn,tc,"604 CANT_CONNECT: %s\r\n",host);
}
returnAckBADREQ(Conn,tc,reason)
	Connection *Conn;
	FILE *tc;
	char *reason;
{
	returnAck(Conn,tc,"605 BAD_REQUEST: %s\r\n",reason);
}

static scan_server(url,host,proto,portp,sel)
	char *url,*host,*proto,*sel;
	int *portp;
{	char login[256];
	char xproto[1024],xhost[1024];
	int xport;
	char *dp,*hp;

	xproto[0] = 0;
	xhost[0] = 0;
	xport = 0;
	*sel = 0;

	if( sscanf(url,"%s %s %d",login,xproto,&xport) < 2 )
	if( sscanf(url,"%[^:]://%[^/]/%s",xproto,login,sel) < 2 ){ 
		sscanf(url,"%s",xproto);
		if( 0 < serviceport(xproto) )
			strcpy(login,"-");
		else{
			sv1log("ERROR: cannot scan SERVER=%s\n",url);
			return 0;
		}
	}
	if( xproto[0] && login[0] ){
		strcpy(proto,xproto);
		if( dp = strchr(login,'@') )
			hp = dp + 1;
		else	hp = login;
		sscanf(hp,"%[^:]:%d",xhost,&xport);
		strcpy(host,xhost);
	}else{
		sv1log("ERROR: cannot scan SERVER: %s\n",url);
		return 0;
	}
	if( xport == 0 )
		xport = serviceport(proto);
	*portp = xport;
	return 1;
}
scan_SERVER(Conn,env)
	Connection *Conn;
	char *env;
{	char sel[1024];

	if( scan_server(env,DFLT_HOST,DFLT_PROTO,&DFLT_PORT,sel) ){
		if( iSERVER_HOST[0] == 0 ){
			strcpy(iSERVER_PROTO,DFLT_PROTO);
			strcpy(iSERVER_HOST,DFLT_HOST);
			iSERVER_PORT = DFLT_PORT;
		}
		add_DGheader(Conn,D_SERVER,"%s",env);
		strcpy(D_SELECTOR,sel);
ProcTitle(Conn,"%s://%s/",DFLT_PROTO,DFLT_HOST);
		return 1;
	}
	return 0;
}

/*
extern char *gethostaddr();
resolve_SERVER(url,rurl)
	char *url,*rurl;
{	char proto[256],host[256],sel[256],*addr;
	int port;

	if( scan_server(url,host,proto,&port,sel) ){
		if( addr = gethostaddr(host) ){
			sprintf(rurl,"%s://%s:%d/%s",proto,addr,port,sel);
			return 1;
		}
	}
	strcpy(rurl,url);
	return 0;
}
*/
set_SERVER(Conn,proto,host,port)
	Connection *Conn;
	char *proto,*host;
{	char server[128];
	sprintf(server,"%s://%s:%d/",proto,host,port);

	scan_SERVER(Conn,server);
}
set_USER(Conn,clsock)
	Connection *Conn;
{	char clnthost[256];

	if( D_USER[0] == 0 ){
		if( getClientHostPort(Conn,clnthost) )
			add_DGheader(Conn,D_USER,"anonymous@%s",clnthost);
		else	add_DGheader(Conn,D_USER,"anonymous");
	}
}
form_server(server,host,service,port)
	char *server,*host,*service;
{
	sprintf(server,"%s://%s:%d",service,host,port);
}

set_realserver(Conn,rproto,rserver,riport)
	Connection *Conn;
	char *rproto,*rserver;
{	char header[256];

	set_realsite(Conn,rproto,rserver,riport);
	form_server(header,REAL_SITE,REAL_PROTO,REAL_PORT);
	scan_SERVER(Conn,header);
	set_USER(Conn,FromC); /* maybe unnecessary */
	Verbose("REAL SERVER %s\n",header);
}
set_realsite(Conn,rproto,rserver,riport)
	Connection *Conn;
	char *rproto,*rserver;
{	char *dp;

	strcpy(REAL_PROTO,rproto);
	strcpy(REAL_SITE,rserver);
	if( dp = strchr(rserver,'@') )
		rserver = dp + 1;
	strcpy(REAL_HOST,rserver);
	if( riport == 0 )
		riport = serviceport(rproto);
	REAL_PORT = riport;
}

Metamorphose(Conn,proto,host,line)
	Connection *Conn;
	char *proto,*host,*line;
{	char server[128],req[0x4000];

	Verbose("=======> Metamorphose: [%s]->[%s]://%s/\n",DFLT_PROTO,
		proto,host);

	ACT_SPECIALIST = 1;
	META_SPECIALIST = 1;
	sprintf(server,"%s://%s/",proto,host);
	scan_SERVER(Conn,server);
	strcpy(req,line);
	if( strstr(req,"\r\n") == NULL )
		strcat(req,"\r\n");
	DDI_pushCbuf(Conn,req,strlen(req));
}
MetamoFTPGET(Conn,line)
	Connection *Conn;
	char *line;
{	char host[512];
	int port;
	char path[1024];

	host[0] = path[0] = 0;
	port = 0;
	sscanf(line,"FTPGET //%[^:]:%d/%s",host,&port,path);
	Metamorphose(Conn,"ftpget",host,line);
}

static isGopherRequest(line)
	char *line;
{	char req[4098],flags[128],proto[128],host[128],path[4098];
	int port;
	int gtype;

	wordscan(line,req);
	if( url_derefer("?",req,NULL,flags,proto,host,&port) )
		if( strcasecmp(proto,"gopher") == 0 )
			return 1;
	return 0;
}

static beTeleportd(Conn,fromC,toC)
	Connection *Conn;
{	int iov[2];

	iov[0] = fromC;
	iov[1] = toC;
	ProcTitle(Conn,"teleportd");

	checkCloseOnTimeout(0);
	bindTeleportVehicle(0,iov,"private.vehicle",0,NULL,NULL);
}
beGeneralist(Conn,fc,tc,hello)
	Connection *Conn;
	FILE *fc,*tc;
	char *hello;
{	int fromC,toC;
	char buf[0x4000];
	int len;

	BORN_SPECIALIST = 0;
	ACT_GENERALIST = 1;
	sv1log("BE GENERALIST[%s]: %s",DFLT_PROTO,hello);
	strcpy(buf,hello);
	len = strlen(buf);
	fgetBuffered(buf+len,sizeof(buf)-len,fc);
	DDI_pushCbuf(Conn,buf,strlen(buf));

	toC = fcloseFILE(tc);
	fromC = fcloseFILE(fc);

	DFLT_HOST[0] = 0;
	execGeneralist(Conn,fromC,toC,-1);
}

extern int IO_TIMEOUT;

char *MY_HOSTPORT();
static execGeneralist0(Conn,tc,fromC,toC)
	Connection *Conn;
	FILE *tc;
{	char line[4095],*dp;
	char *fieldname,*value;
	int lines;
	int do_exit = 0;

	lines = 0;
	for(;;){
		line[0] = 0;
		if( DDI_fgetsFromCbuf(Conn,line,sizeof(line),NULL) == 0 )
		{
			if( PollIn(fromC,IO_TIMEOUT*1000) <= 0 ){
				sv1log("execGeneralist(): TIMEOUT\n");
				do_exit = 1;
				break;
			}
			if( RecvLine(fromC,line,sizeof(line)) < 0 )
				break;
		}
		if( dp = strpbrk(line,"\r\n") )
			*dp = 0;

		Verbose("DGHeader: %s\n",line);
		if( *line == 0 )
			break;

		if( lines == 0 ){
			if( HTTP_isMethod(line) ){
				Metamorphose(Conn,"http",SERV_HTTP,line);
				set_USER(Conn,fromC);
				break;
			}
			if( VSAP_isMethod(line) ){
				Metamorphose(Conn,"vsap",MY_HOSTPORT(),line);
				break;
			}
			if( strncmp(line,"FTPGET ",7) == 0 ){
				MetamoFTPGET(Conn,line);
				set_USER(Conn,fromC);
				break;
			}
			if( strncmp(line,"whois://",8) == 0 ){
				Metamorphose(Conn,"whois",MY_HOSTPORT(),line);
				set_USER(Conn,fromC);
				break;
			}
			if( isGopherRequest(line) ){
				Metamorphose(Conn,"gopher",MY_HOSTPORT(),line);
				set_USER(Conn,fromC);
				break;
			}
			Verbose("ImMaster: act as a MASTER\n");
			ImMaster = 1;
		}

		lines++;
		if( value = strpbrk(line,"\r\n\t ") )
			*value++ = 0;
		else	value = "";
		fieldname = line;


		if( streq(fieldname,"RPORT") ){
			strcpy(D_RPORTX,value);
		}else
		if( streq(fieldname,"TELEPORT") ){
			fflush(tc);
			beTeleportd(Conn,fromC,toC,value);
			Finish(0);
		}else
		if( streq(fieldname,"CPORT") ){
			char clhost[256],host[256];
			int clport,port,csock;

			clhost[0] = host[0] = 0;
			clport = port = 0;
			sscanf(value,"%[^:]:%d %[^:]:%d",clhost,&clport,
				host,&port);

			if( clhost[0] && sockFromMyself(fromC) ){
				sv1log("CPORT: %s:%d\n",clhost,clport);
				strcpy(TeleportHost,clhost);
				TeleportPort = clport;
				fprintf(tc,"200 Ok [%s:%d]\r\n",clhost,clport);
				fflush(tc);
			}
			if( host[0] == 0 )
				continue;

			csock = client_open("CPORT","delegate",host,port);
			if( 0 <= csock ){
				fclose(tc);
/*
close(toC);
don't close it here.
the descriptor number may be rused by DNS Resolvy, thus Resolvy will
be confused if the descriptor is closed by main...
*/
				fromC = toC = Conn->cl_sock = csock;
				tc = fdopen(toC,"w");
			}
		}else
		if( streq(fieldname,"HELO") ){
			respHELO(Conn,tc);
		}else
		if( streq(fieldname,HelloWord()) ){
			gotHELLO(Conn,tc,fieldname,value);
		}else
		if( strcaseeq(fieldname,"!SET") ){
			FILE *tc;
			tc = fdopen(toC,"w");
			do_exit = 1;
			break;
		}else
		if( streq(fieldname,"OUT") ){
			char buff[2048],UserHost[256];
			if( getClientUserMbox(Conn,UserHost) ){
				sprintf(buff,"%s %s\r\n",UserHost,value);
				put_shared(buff,strlen(buff),NULL);
				fflush(tc);
				write(toC,buff,strlen(buff));
			}
		}else
		if( streq(fieldname,"IN") ){
			char buff[2048];
			int rc;
			rc = get_shared(buff,sizeof(buff),NULL);
			fflush(tc);
			write(toC,buff,rc);
		}else
		if( streq(fieldname,"CLIENTS-PROXY") ){
			strcpy(CLIENTS_PROXY,value);
			Verbose("CLIENTS-PROXY: %d\n",1);
		}else
		if( streq(fieldname,"LOCAL-PROXY") ){
			ACT_TRANSLATOR = 1;
			/* no =@=, but only translator ... ?;-< */
		}else
		if( streq(fieldname,"LOCAL-DELEGATE") ){
			Verbose("LOCAL-DELEGATE: %s\n",value);
			sscanf(value,"%[^:]:%d",DELEGATE_LHOST,&DELEGATE_LPORT);
			ACT_SPECIALIST = 1;
		}else
		if( streq(fieldname,"LOCAL-FLAGS") ){
			Verbose("LOCAL-FLAGS: %s\n",value);
			strcpy(DELEGATE_FLAGS,value);
		}else
		if( streq(fieldname,"LOCAL-CHARCODE") ){
			Verbose("LOCAL-CHARCODE: %s\n",value);
			scan_CHARCODE(Conn,value);
		}else
		if( streq(fieldname,"PUBLIC-DELEGATE") ){
			keepPublic(Conn,value,fromC);
			add_DGheader(Conn,fieldname,"%s",value);
		}else
		if( streq(fieldname,"SERVER") ){
			scan_SERVER(Conn,value);
			set_USER(Conn,fromC);
		}else
		if( streq(fieldname,"REQUEST") ){
			setREQUEST(Conn,value);
		}else
		if( streq(fieldname,"MASTER") ){
			scan_MASTER(Conn,value);
			add_DGheader(Conn,fieldname,"%s",value);
		}else
		if( streq(fieldname,"CACHE") ){
			if( streq(value,"DONT_READ") ){
				Verbose("DontReadCache\n");
				DontReadCache = 1;
			}else
			if( streq(value,"DONT_WAIT") ){
				Verbose("DontWaitCache\n");
				DontWaitCache = 1;
			}else
			if( strncmp(value,"ONLY",4) == 0 ){
				CacheOnly = 1;
				CacheLastMod = atoi(value+5);
				Verbose("CacheOnly IfLastMod>%d\n",CacheLastMod);
			}else{
				/* DISABLE */

				DontUseCache = 1;
				DontWaitCache = 1;
				DontReadCache = 1;
				DontWriteCache = 1;
			}
			/* add_DGheader(Conn,fieldname,"%s",value); */

		}else
		if( streq(fieldname,"OVERRIDE") ){
			char nam[256],val[1024];
			nam[0] = val[0] = 0;
			if( 1 <= sscanf(value,"%[^=]=%[^\r\n]",nam,val) ){
char proto[64],ov[1024];
strcpy(proto,DST_PROTO);
strcpy(DST_PROTO,"override");
				if( service_permitted(Conn,"override") ){
					sv1mlog("OVERRIDE %s %s\n",nam,val);
					sprintf(ov,"*:%s",value);
					scan_OVERRIDE(ov);
					if( streq(nam,"TIMEOUT") )
						scan_TIMEOUT(Conn,val);
					else
					if( streq(nam,"CONNECT") ){
						if( streq(val,"cache") ){
							scan_CONNECT(Conn,val);
							CacheOnly = 1;
						}
					}
				}
strcpy(DST_PROTO,proto);
			}
		}else
		if( strcaseeq(fieldname,"PARAM") ){
			fflush(tc);
			add_params(Conn,tc,value);
			fflush(tc);
		}else
		if( strcaseeq(fieldname,"QUIT") ){
			do_exit = 1;
			break;
		}else	scan_header(Conn,fromC,fieldname,value);
	}

	return do_exit;
}

execGeneralist(Conn,fromC,toC,svsock)
	Connection *Conn;
	int fromC,toC;
{	FILE *tc;

	set_keepalive(fromC,1);
	tc = fdopen(toC,"w");

	if( !strcaseeq(DFLT_PROTO,"delegate") )
	if( DFLT_HOST[0] ){
		/* then it is Specialized already */
		Verbose("execGeneralist->execSpecialist\n");
		execSpecialist(Conn,fromC,tc,svsock);
		goto EXIT;
	}

ProcTitle(Conn,"(delegate)");

	if( execGeneralist0(Conn,tc,fromC,toC) != 0 )
		goto EXIT;

	if( streq(DST_PROTO,"http") )
		dynamic_config(Conn);

	fflush(tc);
	execSpecialist(Conn,fromC,tc,svsock);

EXIT:
	if( 0 <= FromS && ToS != FromS ){ /* FFROMMD filter inserted ... */
		close(FromS);
		Verbose("close FromS:%d (ToS=%d)\n",FromS,ToS);
	}
	fclose(tc);
}

DELEGATE_setenv(fc,tc,line)
	FILE *fc,*tc;
	char *line;
{
	fprintf(tc,"SET\r\n");
}

static setServ(Conn,svsock)
	Connection *Conn;
{
	/*Verbose("####setServ: %d %d\n",FromS,svsock);*/
	ToS   = svsock;
	if( FromSX < 0 && FromS < 0 )
		FromS = svsock;
	return svsock;
}
static setConn(Conn,fromC,toC,fromS,toS)
	Connection *Conn;
{
	/*Verbose("#### setConn: FromS:%d fromS:%d,toS:%d\n",FromS,fromS,toS);*/
	FromC = fromC;
	ToC   = toC;
	if( FromSX < 0 )
		FromS = fromS;
	ToS   = toS;
}

extern char *get_PATH();
extern char *add_PATH();

log_PATH(Conn,where)
	Connection *Conn;
	char *where;
{	char *path;
	char teleport[512];
	char dest[256];
	int loop;

	loop = 0;
	if( Conn->path_added == 0 ){
		char me[256];
		char hostport[256];
		int port;
		char *dp;
		int len;

		if( TeleportHost[0] && TeleportPort ){
			sprintf(teleport,"%s:%d.-.%s:%d",TelesockHost,TelesockPort,
				TeleportHost,TeleportPort);
		}else	teleport[0] = 0;

		Conn->path_added = 1;
		gethostName(Conn->cl_sock,me,PN_HOSTPORT);
		Strncpy(Conn->cl_myhp,me,sizeof(Conn->cl_myhp));

		len = strlen(me);
		if( 0 < (port = getClientHostPort(Conn,hostport)) )
			sprintf(hostport+strlen(hostport),":%d",port);
		else	strcpy(hostport,"?:0");

		path = add_PATH(me,hostport,teleport);

if( !Conn->from_myself )
if( SERVER_PORT() != 0 ) /* FTP/TUNNEL mistaken as loop by "0.0.0.0:0" */
		if( !isMYSELF(DST_HOST) )
		if( dp = strstr(path+len,me) ){
		    if( dp[-1] == '!' && dp[len] == '!' ){
			loop = 1;
			sv1log("ERROR: loop found in PATH: %s!%s\n",me,path);
		    }
		}
	}else	path = get_PATH();

	if( DST_HOST[0] )
		sprintf(dest,"%s://%s:%d",DST_PROTO,DST_HOST,DST_PORT);
	else	sprintf(dest,"%s",DST_PROTO);

	if( where[0] == ':' && streq(DFLT_PROTO,"http") )
		Verbose("PATH%s %s!%s\n",where,dest,path);
	else	sv1tlog("PATH%s %s!%s\n",where,dest,path);
	return loop;
}
static setClientInfo(Conn)
	Connection *Conn;
{	char username[64];
	char hostname[256],hostaddr[256];
	int cport;

	if( (cport = getClientHostPortAddr(Conn,hostname,hostaddr)) == 0 ){
		strcpy(hostname,"-");
		strcpy(hostaddr,"0.0.0.0");
	}

	strcpy(CLNT_PROTO,DFLT_PROTO);

	if( D_FROM[0] == 0 ){
		getUsernameCached(getuid(),username);
		setFROM(username,hostaddr,cport);
	}
}

execSpecialist(Conn,fromC,tc,toS)
	Connection *Conn;
	FILE *tc;
{	IFUNC client;
	int clsock;
	int withcache,selfack;
	int fromS;
	int rcode;

	fromS = -1;
	clsock = ClientSock;
	setClientInfo(Conn);

	if( log_PATH(Conn,":") != 0 ){
		returnAckLOOP(Conn,tc,"path loop found");
		return -1;
	}

	client = get_servfunc(Conn,clsock,&withcache,&selfack);
	if( withcache == 0 && isMYSELF(DFLT_HOST) ){
		sv1log("Free proxy -- %s://%s/\n",DFLT_PROTO,DFLT_HOST);
		withcache = 1;
	}

/*
	if( DELEGATE_SERVERSH ){
		int tsv[2],fsv[2];

		if( service_permitted(Conn,DST_PROTO) == 0 )
			return -1;

		pipe(tsv);
		pipe(fsv);
		if( Fork() == 0 ){
			close(tsv[1]); dup2(tsv[0],0);
			close(fsv[0]); dup2(fsv[1],1);
			system(DELEGATE_SERVERSH);
			exit(0);
		}
		close(tsv[0]); toS = tsv[1];
		close(fsv[1]); fromS = fsv[0];

		setConnX(Conn,fromC,fileno(tc),fromS,toS);
		ProcTitle(Conn,"%s://%s/",DST_PROTO,DST_HOST);
		fflush(tc);
		rcode = (*client)(Conn,0,0);
		return rcode;
	}
*/

	if( toS == -1 ){
	    if( isMYSELF(DFLT_HOST) && streq(DFLT_PROTO,"telnet") ){
	    }else
	    if( isMYSELF(DFLT_HOST) && (streq(DFLT_PROTO,"nntp") || streq(DFLT_PROTO,"news")) ){
	    }else
	    if( withcache ){
		/*
		should search caches here...
		 */
		if( ReturnACK ){
			extern int HAS_MASTER;
			if( !service_permitted(Conn,DFLT_PROTO) )
			{
				returnAckDENIED(Conn,tc,"access denied");
				return -1;
			}
			if( !HAS_MASTER )
			if( !IsResolvable(DFLT_HOST) )
			if( !isMYSELF(DFLT_HOST) && !streq(".",DFLT_HOST) )
			{
				sv1log("unknown host: %s [%d]\n",DFLT_HOST,HAS_MASTER);
				returnAckUNKNOWN(Conn,tc,DFLT_HOST);
				return -1;
			}
			/*
			if( connectOnlyCache )
			if( no-cache-available  )
				returnAckNOCACHE(Conn,tc,"cache unavailable\n");
			*/
		}
	    }else{
		toS = connect_to_serv(Conn,fromC,fileno(tc), 0);
		/*
		 * ToS and FromS may be set already differently by FTOSV
		 */
		if( 0 <= ToS && toS == ToSX && 0 <= FromS ){
			toS = ToS;
			fromS = FromS;
		}

		if( toMaster ){
Verbose("====> RETURN Ack <200 Ok.> from Mediator.\n");
			returnAckOK(Conn,tc,"connected to the master");

			/* ProcTitle(Conn,"(relay)"); */
			fflush(tc);
			setConnX(Conn,fromC,fileno(tc),fromS,toS);
			ProcTitle(Conn,"%s://%s/(relay)",DST_PROTO,DST_HOST);
			relay_svcl(Conn,FromC,ToC,FromS,ToS,1,512);
			return -1;
		}
	    }
	}
	if( !selfack || D_RPORTX[0] )
		returnAckOK(Conn,tc,"good");

	setConnX(Conn,fromC,fileno(tc),fromS,toS);
	ProcTitle(Conn,"%s://%s/",DST_PROTO,DST_HOST);

	fflush(tc);
	rcode = (*client)(Conn,0,0);

	/* close FFROMMD filter if exists */
	/* ... and if I'm not StickyServer ?? ... */
	if( 0 <= FromSX ){
		close(FromSX);
		FromSX = -1;
	}

	return rcode;
}

setConnX(Conn,fromC,toC,fromS,toS)
	Connection *Conn;
{
	insert_FPROTO(Conn,&toC,toS,&fromS);
	setConn(Conn,fromC,toC,fromS,toS);
}

service_dump(Conn)
	Connection *Conn;
{	FILE *fc,*out;
	int ch,nc;
	int totty;

	out = stdout;
	totty = isatty(out);
	fc = fdopen(FromC,"r");

	for(nc = 0; ; nc++){
		if( ready_cc(fc) <= 0 )
			fflush(out);
		if( fPollIn(fc,0) <= 0 )
			break;
		if( (ch = getc(fc)) == EOF )
			break;
		if( totty ){
			if( ch != '\t' && ch != '\n' && ch != '\r' )
			if( ch < ' ' || 0x7F < ch )
				ch = '?';
		}
		putc(ch,out);
	}
}

RecvLineTIMEOUT(sock,buff,size,timeout)
	char *buff;
{
	if( 0 < PollIn(sock,timeout) )
 		return RecvLine(sock,buff,size);
	return -1;
}

/*
 *	get_masterserv() could use a persistent data file shared among
 *	delegateds of the same access right.
 */
static reuseMASTER(Conn,mx,msock,version,server)
	Connection *Conn;
	char **version,**server;
{
	if( 0 <= RPORTsock )
		return 0;

	if( mx <= 0 )
		return 0;

	if( get_masterenv(mx,version,server) == 0 )
		return 0;

	if( vercmp(*version,"3.0.38") < 0 )
		return 0;

	return 1;
}

extern int CON_TIMEOUT;
static connect_master(Conn,mx,msock,cache_only,relay_input)
	Connection *Conn;
{	FILE *mfpo;
	char resp[128];
	int newver;
	int rcode = 0;
	int fromS;
	char Hello[128];
	int nHello;
	int reuse;
	char *version,*server;

	forward_RIDENT(Conn,'m',msock,NULL);

	set_keepalive(msock,1);
	reuse = reuseMASTER(Conn,mx,msock,&version,&server);

	if( reuse && strcmp(server,D_SERVER) == 0 ){
		sv1mlog("#### reuse MASTER[%d] Ver=%s SERVER=%s [NOACK]\n",
			mx,version,server);
		ToServ = fdopen(msock,"w");
		fprintf(ToServ,"%s %s NOACK\r\n",HelloWord(),DELEGATE_ver());
		D_RelayInput(Conn,ToServ,msock,cache_only,relay_input,0);
		goto EXIT;
	}

	nHello = 0;
	Hello[0] = 0;
	mfpo = fdopen(dup(msock),"w");
	if( mfpo == NULL )
		return -1;

	if( reuse ){
		sv1log("#### reuse MASTER[%d] Ver=%s [NOSYNC]\n",mx,version);
		fprintf(mfpo,"%s %s NOSYNC\r\n",HelloWord(),DELEGATE_ver());
		strcpy(MediatorVer,version);
		newver = 1;
	}else{
		fprintf(mfpo,"%s %s\r\n",HelloWord(),DELEGATE_ver());
		fflush(mfpo);
		if( 0 < RecvLineTIMEOUT(msock,resp,sizeof(resp),HELLO_TIMEOUT*1000) ){
			sv1log("MASTER[%d] says(1): %s",mx,resp);
			strcpy(Hello,resp);
			scanHelloVer(Hello,MediatorVer);
			nHello++;
			newver = 1;
		}else{
	sv1log("HELLO negotiation TIMEOUT: OLD version MASTER before 2.0 ?\n");
			strcpy(MediatorVer,"1");
			newver = 0;
		}
	}

	if( strncmp(D_SERVER,"https:",6) == 0 )
	if( vercmp(MediatorVer,"3.0.4") < 0 ){
		char buff[1024];
		strcpy(buff,D_SERVER+6);
		sprintf(D_SERVER,"tcprelay:%s",buff);
		sv1log("#### https -> %s\n",D_SERVER);
	}
	else
	if( vercmp(MediatorVer,"5.3.5") < 0 ){
		char buff[1024];
		strcpy(buff,D_SERVER+6);
		sprintf(D_SERVER,"http:%s",buff);
		sv1log("#### https -> %s\n",D_SERVER);
	}

	D_RelayInput(Conn,mfpo,msock,cache_only,relay_input,1);

	if( newver ){
	getresp:
		if( RecvLineTIMEOUT(msock,resp,sizeof(resp),CON_TIMEOUT*1000) <= 0 ){
			sv1log("MASTER closed\n");
			rcode = -1;
		}else{
			sv1log("MASTER[%d] says(2): %s",mx,resp);
			rcode = atoi(resp);
			if( *resp == '6' )
				rcode = -rcode;

			if( isHelloRequest(resp) ){
				if( 1 < ++nHello )
				sv1log("#### got duplicate HELLO response.\n");
				strcpy(Hello,resp);
				goto getresp;
			}
		}
	}
	fclose(mfpo);

	if( reuse ){
		if( Hello[0] )
			scanHelloVer(Hello,MediatorVer);

		if( strcmp(version,MediatorVer) != 0 ){
			sv1log("#### MASTER version [%s]->[%s]\n",
				version,MediatorVer);
			set_masterenv(mx,MediatorVer,"");
		}
	}

	if( rcode < 0 )
		return rcode;

	if( 0 <= mx && rcode == 200 )
		set_masterenv(mx,MediatorVer,D_SERVER);

EXIT:
	insert_FMASTER(Conn,msock);
	return 0;
}

forwardit(Conn,fromC,relay_input)
	Connection *Conn;
{	char clnt[128];
	int svaddr,claddr;
	int forw;
	char *proto,*host,*path;
	int port;
	int msock;

	if( Conn->co_mask & CONN_NOPROXY )
		return 0;

/* getpeerName(fromC,clnt,PN_HOST); */
if( getClientHostPort(Conn,clnt) == 0 )
	strcpy(clnt,"?");

	forw = DELEGATE_forward(Conn,DFLT_PROTO,DFLT_HOST,DFLT_PORT,clnt,&proto,&host,&port,&path);
	if( forw == 0 )
		return 0;

	if( findInPath(host,port) ){
		sv1log("don't make PROXY loop for %s:%d\n",host,port);
		return 0;
	}

	sv1log("ROUTE: %s://%s:%d%s\n",proto,host,port,path);
	SetStartTime();
	msock = connectToUpper(Conn,"Forward",proto,host,port);
	if( 0 <= msock ){
		strcpy(GatewayProto,proto);
		GatewayPath = stralloc(path);
		FromS = ToS = msock;

		if( streq(proto,"http")
		 || streq(proto,"ftp")
		 || streq(proto,"telnet")
		){
			toProxy = 1;
		}
		else /* if( streq(proto,"delegate")) */
		{
			if( connect_master(Conn,-1,msock,0,relay_input) == 0 )
				toMaster = 1;
			else{
				close(msock);
				FromS = ToS = msock = -1;
			}
		}
	}
	return forw;
}
Forwardit(Conn,fromC,toC,relay_input)
	Connection *Conn;
{
	if( Conn->co_mask & CONN_NOPROXY )
		return 0;

	FromS = ToS = -1;
	toMaster = 0;
	if( !service_permitted(Conn,DFLT_PROTO) )
		return -1;
	return forwardit(Conn,fromC,relay_input);
}

double Time();
static connect_to_server(Conn, proto,host,port, fromC,toC, relay_input)
	Connection *Conn;
	char *proto,*host;
{	int svsock;
	int forcef;
	double Start;

	FromS = ToS = svsock = -1;
	FromSX = -1;
	toMaster = 0;
	Start = Time();

	/* internal protocol */
	if( port == 0 )
		return -1;

	if( isMYSELF(host) && strcaseeq(proto,"smtp") )
		return -1;

	if( strcaseeq(proto,"dump") || strcaseeq(proto,"pgps") )
		return -1;

	if( !service_permitted(Conn,proto) )
		return -1;

	setupConnect(Conn); /* setup the order of connection types */
	ProcTitle(Conn,"%s://%s/",DST_PROTO,DST_HOST);

	if( forwardit(Conn,fromC,relay_input) ){
		svsock = ToS;
		goto CONNECTED;
	}

	SetStartTime();

	if( !streq(proto,"http") && connectToCache(Conn,"",&svsock) ){
		svsock = setServ(Conn,svsock);
		goto CONNECTED;
	}else
	if( tryCONNECT(Conn,relay_input,&svsock) ){
		svsock = setServ(Conn,svsock);
		goto CONNECTED;
	}else{
		forcef = force_forward(Conn,proto);
		if( forcef != 0 ){
			Verbose("FORCEON to the %s: %s\n","MASTER",proto);
		}else{
			if( 0 <= (svsock=ConnectToServer(Conn,relay_input)) ){
				ConnType = 'd';
				goto CONNECTED;
			}

			if( Conn->co_error == CO_REJECTED )
				return -1;
			if( Conn->co_direct )
				return -1;
		}
		if( 0 <= (svsock = ConnectViaICP(Conn)) ){
			if( toMaster
			 && connect_master(Conn,-1,svsock,0,relay_input) != 0 ){
				close(svsock);
			}else{
				svsock = setServ(Conn,svsock);
				ConnType = 'i';
				goto CONNECTED;
			}
		}
		if( 0 <= (svsock=open_master(Conn,1,host,port,1,relay_input))){
			svsock = setServ(Conn,svsock);
			ConnType = 'm';
			goto CONNECTED;
		}
		if( 0 <= (svsock = ConnectViaSSLtunnel(Conn,host,port)) ){
			svsock = setServ(Conn,svsock);
			ConnType = 'h';
			goto CONNECTED;
		}

		if( 0 <= (svsock = ConnectViaVSAP(Conn,relay_input)) ){
			ConnType = 'v';
			goto CONNECTED;
		}

		if( 0 < forcef )
		if( 0 <= (svsock=ConnectToServer(Conn,relay_input)) ){
			ConnType = 'd';
			goto CONNECTED;
		}

		if( 0 <= (svsock = ConnectViaSocks(Conn,relay_input)) ){
			ConnType = 's';
			goto CONNECTED;
		}
	}
	sv1log("ERROR: cannot connect to %s://%s:%d - %d\n",
		proto,host,port,svsock);
FAILED:
	return svsock;

CONNECTED:

	ServConnTime = Time();

	/* Currently, ToServ is supported only in HTTP */
	if( ToServ && !streq(proto,"http") )
		fflush(ToServ);
	ConnDelay = ServConnTime - Start;

	return svsock;
}
/*
 *	DFLT_... should be replaced by DST_...
 */
connect_to_serv(Conn, fromC,toC, relay_input)
	Connection *Conn;
{	int sock;

	sock = connect_to_server(Conn,DFLT_PROTO,DFLT_HOST,DFLT_PORT,
		fromC,toC,relay_input);

	if( sock < 0 ){
		char *reason;
		char server[256],shost[256];
		int sport;

		reason = "?";
		if( Conn->co_error & CO_CANTRESOLV ) reason = "unknown";
		if( Conn->co_error & CO_TIMEOUT    ) reason = "timeout";
		if( Conn->co_error & CO_REFUSED    ) reason = "refused";
		if( Conn->co_error & CO_UNREACH    ) reason = "unreach";

		sport = getClientHostPort(Conn,shost);
		HostPort(server,DST_PROTO,DST_HOST,DST_PORT);
		daemonlog("F","%s: %s:%d %s %s://%s (%s)\n",
		"E-C: Can't connect",shost,sport,"=>",DST_PROTO,server,reason);
	}

	insert_FSERVER(Conn,fromC);
	return sock;
}
connect_to(proto,host,port)
	char *proto,*host;
{	Connection ConnBuff,*Conn = &ConnBuff;
	int sv;

	Conn->from_myself = 1;
	sv = connect_to_server(&Conn,proto,host,port, -1,-1,0);
	return sv;
}

openMaster(Conn,svsock,server,relay_input)
	Connection *Conn;
	char *server;
{	int msock,sv[2];
	FILE *mfp;

	if( svsock == -1 )
	if( 0 <= (msock = open_master(Conn,0,server,0,1,relay_input) ) )
		return msock;

	if( svsock != -1 && toMaster ){
		if( relay_input )
			DG_relayInput(Conn,svsock);
		return  svsock;
	}

	Socketpair(sv);
	if( Fork("openMaster") == 0 ){
		close(sv[1]);
		sv1log("PRIVATE MASTER[%d/%d] svsock=%d\n",sv[0],sv[1],svsock);
		DFLT_HOST[0] = 0;
		clear_DGconn(Conn);
		execGeneralist(Conn,sv[0],sv[0],svsock);
		Finish(0);
	}
	close(sv[0]);
	mfp = fdopen(dup(sv[1]),"w");
	D_RelayInput(Conn,mfp,sv[1],0,relay_input,1);
	fclose(mfp);
	return sv[1];
}

open_master(Conn,try_direct,server,svport,sendhead,relay_input)
	Connection *Conn;
	int try_direct;
	char *server;
{	int msock;
	int mi,mx;
	char *master;
	int no_socks;
	int mport;
	int tport;
	int cache_only;
	char *hp;

	if( Conn->co_mask & CONN_NOMASTER )
		return -1;

	if( MasterIsPrivate && ACT_GENERALIST )
		return -1;

	SetStartTime();

	if( hp = strchr(server,'@') )
		server = hp + 1;

	no_socks = MasterIsPrivate;

	msock = -1;

	for(mi = 0; ;mi++){
		if( (mx = DELEGATE_master(mi,&master,&mport,&tport,&cache_only)) == 0 ){
			msock = -1;
			goto EXIT;
		}

		if( master == NULL )
			continue;/* Teleport */

		if( cache_only ){
			if( DontReadCache )
				continue;
			if( !withcache(DST_PROTO) )
				continue;
		}

		if( DELEGATE_Filter(mx,DST_PROTO,server,svport) != 0 )
			continue;

		if( findInPath(master,mport) ){
			sv1log("don't make MASTER loop for %s:%d\n",
				master,mport);
			continue;
		}

		if( streq(master,"*") ){
			if( !try_direct )
				continue;

			msock = ConnectToServer(Conn,relay_input);
			if( 0 <= msock )
				goto EXIT;
		}

		if( tport )
			msock = teleportOpen(mx,master,mport,
				server,Conn->cl_sock);
		else
		if( !no_socks )
			msock = connectToUpper(Conn,"MasterOpen","delegate",
				master,mport);
		else	msock = connectServer("MasterOpen","delegate",
				master,mport,no_socks);

		if( 0 <= msock ){
			if( !sendhead ){
				toMaster = 1;
				break;
			}

			if( connect_master(Conn,mx,msock,cache_only,relay_input) == 0 ){
				toMaster = 1;
				break;
			}
			close(msock);
			msock = -1;
		}
	}
EXIT:
	if( msock < 0 && withTmpMaster() ){
		msock = connectServer("MO-MasterOpen","delegate",
			MO_MasterHost,MO_MasterPort,no_socks);
		if( 0 <= msock ){
			if( connect_master(Conn,-1,msock,0,relay_input) == 0 )
				toMaster = 1;
		}
	}

	if( 0 <= msock )
		set_keepalive(msock,1);
	else{
		/* something wrong in private master...  (may be replaced)
		 */
		if( myPrivateMASTER != 0 )
			BREAK_STICKY = 1;
	}
	return msock;
}

extern int LOGIN_TIMEOUT;
extern int DNS_TIMEOUT;
extern int ACC_TIMEOUT;
extern int CON_TIMEOUT;
extern int LIN_TIMEOUT;
extern int IO_TIMEOUT;
extern int CC_TIMEOUT_FTP;
extern int CC_TIMEOUT_NNTP;
extern int HTTPMAIL_TIMEOUT;
extern int SERVER_TIMEOUT;
extern int SERVER_RESTART;
extern int STANDBY_TIMEOUT;
extern int HTTP_CKA_TIMEOUT;
extern int HTTP_CKA_TIMEOUT_MARGIN;
extern double IDENT_TIMEOUT;

extern double Scan_period();
static timeout1(to)
	char *to;
{	char name[128],period[128];
	double secs;

	if( sscanf(to,"%[^:]:%s",name,period) == 2 ){
		secs = Scan_period(period,'s',(double)0);

		if( streq(name,"hello")) HELLO_TIMEOUT = secs; else
		if( streq(name,"login")) LOGIN_TIMEOUT = secs; else
		if( streq(name,"dns") )	DNS_TIMEOUT = secs; else
		if( streq(name,"acc") )	ACC_TIMEOUT = secs; else
		if( streq(name,"con") )	CON_TIMEOUT = secs; else
		if( streq(name,"lin") )	LIN_TIMEOUT = secs; else
		if( streq(name,"ident")) IDENT_TIMEOUT = secs; else
		if( streq(name,"io") )	IO_TIMEOUT = secs; else
		if( streq(name,"idle"))	IO_TIMEOUT = secs; else
		if( streq(name,"restart"))   SERVER_RESTART = secs; else
		if( streq(name,"daemon"))    SERVER_TIMEOUT = secs; else
		if( streq(name,"standby")  ) STANDBY_TIMEOUT = secs; else
		if( streq(name,"ftpcc"))     CC_TIMEOUT_FTP = secs; else
		if( streq(name,"nntpcc"))    CC_TIMEOUT_NNTP = secs; else
		if( streq(name,"http-cka"))  HTTP_CKA_TIMEOUT = secs; else
		if( streq(name,"http-ckamg"))HTTP_CKA_TIMEOUT_MARGIN = secs;
		else
		if( streq(name,"httpmail"))  HTTPMAIL_TIMEOUT = secs;
	}
	if( SERVER_TIMEOUT )
	if( SERVER_TIMEOUT < ACC_TIMEOUT || ACC_TIMEOUT == 0 )
		ACC_TIMEOUT = SERVER_TIMEOUT;

	return 0;
}
scan_TIMEOUT(Conn,timeouts)
	Connection *Conn;
	char *timeouts;
{
	scan_commaList(timeouts,0,timeout1);
}


ConnectViaVSAP(Conn,relay_input)
        Connection *Conn;
{	int sock;
	char sockname[256],peername[256];

	sockname[0] = 0;
	sprintf(peername,"%s:%d",DST_HOST,DST_PORT);
	if( 0 <= (sock = VSAPconnect(sockname,peername)) )
		initConnected(Conn,sock,relay_input);

	return sock;
}

scan_OVERRIDE(ovparam)
	char *ovparam;
{	char master[256],port[256];

	sscanf(ovparam,"%[^:]:%[^:]:%s",master,port,D_OVERRIDE);
}

static lfprintf(fp,fmt,a,b,c,d,e,f,g)
	FILE *fp;
	char *fmt,*a,*b,*c,*d,*e,*f,*g;
{	char line[4096];
	int wc = -1;

	if( fp != NULL )
		wc = fprintf(fp,fmt,a,b,c,d,e,f,g);

	strcpy(line,"<= ");
	sprintf(line+strlen(line),fmt,a,b,c,d,e,f,g);
	Verbose("%s",line);
}

static D_RelayInput(Conn,mfp,msock,cache_only,relay_input,doflush)
	Connection *Conn;
	FILE *mfp;
{	char mhostport[256],me[256],dstaddr[512];
	int hi;

	getpeerName(msock,mhostport,PN_HOSTPORT);
	sv1log("forwarding to [%d] %s://%s\n",msock,"delegate",mhostport);
	gethostnameIF(me,sizeof(me));

	/* this should done before any name resolution occures */
	if( make_HOSTS(dstaddr,DST_HOST,1) )
		lfprintf(mfp,"HOSTS %s\n",dstaddr);

			     lfprintf(mfp,"MEDIATOR %s\r\n",me);
	if(D_RPORT[0])       lfprintf(mfp,"RPORT %s\r\n",  D_RPORT);
	if(D_FTPHOPS )	     lfprintf(mfp,"FTPHOPS %d\r\n",D_FTPHOPS);
	if(D_SERVER[0])      lfprintf(mfp,"SERVER %s\r\n", D_SERVER);
	if(D_REQUEST)        lfprintf(mfp,"REQUEST %s\r\n",D_REQUEST);
	if(D_FROM[0]  )      lfprintf(mfp,"FROM %s\r\n",   D_FROM);
	if(D_USER[0]  )      lfprintf(mfp,"USER %s\r\n",   D_USER);
	if(D_PATH[0]  )      lfprintf(mfp,"PATH %s\r\n",   D_PATH);
	if(D_EXPIRE[0])      lfprintf(mfp,"EXPIRE %s\r\n", D_EXPIRE);
	if(D_GTYPE[0] )      lfprintf(mfp,"LOCAL-GTYPE %c\r\n",D_GTYPE[0]);
	if(never_cache())    lfprintf(mfp,"CACHE DISABLE\r\n");
	if(DontReadCache)    lfprintf(mfp,"CACHE DONT_READ\r\n");
	if(DontWaitCache)    lfprintf(mfp,"CACHE DONT_WAIT\r\n");
	if(cache_only)       lfprintf(mfp,"CACHE ONLY %d\r\n",CacheLastMod);
	if(CLIENTS_PROXY[0]) lfprintf(mfp,"CLIENTS-PROXY %s\r\n",CLIENTS_PROXY);
	if(D_OVERRIDE[0])    lfprintf(mfp,"OVERRIDE %s\r\n",D_OVERRIDE);

	if( headerX ){
		for( hi = 0; hi < headerX; hi++ )
	        	lfprintf(mfp,"%s",headerB[hi]);
	}
	lfprintf(mfp,"\r\n");

	if(relay_input && inputsX ){
		for( hi = 0; hi < inputsX; hi++ )
			lfprintf(mfp,"%s",inputsB[hi]);
/*
Verbose("RelayInput: <= %d bytes\n%s\n",strlen(D_inputs),D_inputs);
*/
	}
	if( mfp != NULL && doflush )
		fflush(mfp);
}
