/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1995 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, modify, and distribute this material for any
purpose and without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies, and
that the name of ETL not be used in advertising or publicity pertaining
to this material without the specific, prior written permission of an
authorized representative of ETL.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	script.c (DeleGate Script)
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
	"..."		... is literal
	'...'		... is literal
	\c		c is litelal
	#...		... is comment
	CASE case	included when in the case
	ESAC [case]	end the case
	+=URL[#case-list]
History:
	950615	created
//////////////////////////////////////////////////////////////////////#*/
#include <stdio.h>
#include <string.h>
extern FILE *TMPFILE();
#include "log.h"
#define SELF	"_SELF_"
int SCRIPT_ASIS;

#define RELATIVE "+"
static char *pathv[32];
static int   pathx;

static inspath(path1)
	char *path1;
{
	pathv[pathx++] = path1;
	return 0;
}
scan_DGPATH(path)
	char *path;
{	char *dp;
	char home[1024],xpath[2048];

	getHOME(getuid(),home);
	strcpy(xpath,path);
	strsubst(xpath,"${HOME}",home);
	scan_List(xpath,':',1,inspath);
}

static eval_line(file,base,line,xline)
	char *file,*base,*line,*xline;
{	char ch,*sp,*xp,*fix,lit,*dp,*command;
	FILE *fp;

	lit = 0;
	xp = xline;
	fix = xline;

	for( sp = line; ch = *sp; sp++ )
		if( ch != ' ' && ch != '\t' && ch != '\r' )
			break;

	while( ch = *sp ){
		if( ch == '\\' && sp[1] != 0  && lit == 0 ){
			*xp++ = sp[1];
			fix = xp;
			sp += 2;
		}else
		if( (ch == '"' || ch == '\'') && lit == 0 ){
			lit = ch;
			sp++;
		}else
		if( (ch == '"' || ch == '\'') && lit == ch ){
			lit = 0;
			sp++;
			fix = xp;
		}else
		if( ch == '`' && lit == 0 ){
			lit = ch;
			sp++;
			command = xp;
		}else
		if( ch == '`' && lit == ch ){
			lit = 0;
			sp++;
			*xp = 0;

			if( fp = popen(command,"r") ){
				fgets(command,256,fp);
				pclose(fp);
				if( dp = strpbrk(command,"\r\n") )
					*dp = 0;
				xp = command+strlen(command);
				fix = xp;
			}
		}else
		if( ch == '#' && lit == 0 ){
			break;
		}else{
			*xp++ = *sp++;
			if( ch != ' ' && ch != '\t' && ch != '\r' )
				fix = xp;
		}
	}
	*fix = 0;
	if( lit != 0 )
		fprintf(stderr,"%s: unmatched (%c): %s\n",file,lit,line);
}

static case_match(ccase,tcase)
	char *ccase,*tcase;
{
	return strcmp(ccase,tcase) == 0;
}
static in_case(cases,case1)
	char *cases,*case1;
{	int match;

	match = scan_List(cases,'+',0,case_match,case1);
	return match;
}
static eval_script(sfp,name,base,url,cases)
	FILE *sfp;
	char *name,*base,*url,*cases;
{	char argb[0x4000],*argp,*vp,valueb[4096],*dp;
	char com[1024];
	char blocks[8][32],actives[8],block1[32];
	int blockx,bi;
	int nline;
	int active;

	if( name ){
		sprintf(argb,"%s=",name);
		argp = argb + strlen(argb);
	}else	argp = argb;

	vp = argp;
	blockx = 0;

	active = !in_case(cases,SELF);

/*
if( active )
 fprintf(stderr,"%d %s\n",active,url);
*/

	for( nline = 1; fgets(valueb,sizeof(valueb),sfp) != NULL; nline++ ){
		if( lARGDUMP() )
			fprintf(stderr,"%s: %s",url,valueb);
		if( dp = strpbrk(valueb,"\r\n") )
			*dp = 0;

		if( SCRIPT_ASIS )
			strcpy(vp,valueb);
		else	eval_line(url,base,valueb,vp);

		wordscan(vp,com);
		if( strcmp(com,"CASE") == 0 ){
			actives[blockx] = active;
			sscanf(vp,"%*s %s",blocks[blockx]);
			active = in_case(cases,blocks[blockx]);
			if( 0 < blockx )
				active &= actives[blockx];
			blockx++;
/*
if( active )
 fprintf(stderr,"%d [%d] %s\n",active,blockx,vp);
*/
		}else
		if( strcmp(com,"ESAC") == 0 ){
			block1[0] = 0;
			sscanf(vp,"%*s %s",block1);
			if( block1[0] ){
			    for( bi = blockx - 1; 0 <= bi; bi-- ){
				if( strcmp(block1,blocks[bi]) == 0 ){
					blockx = bi;
					break;
				}
			    }
			    if( bi < 0 ){
				fprintf(stderr,"\"%s\":%d unmatched ESAC %s\n",
					url,nline,block1);
				break;
			    }
			}else	blockx--;
			active = actives[blockx];
/*
 fprintf(stderr,"%d [%d] %s\n",active,blockx,vp);
*/
		}else
		if( active ){
			if( *argp )
				scan_arg1(url,argb);
		}
	}
}

typedef struct {
	char	*sf_furl;
	char	*sf_aurl;
	FILE	*sf_sfp;
	int	 sf_off;
} ScriptFile;
static ScriptFile scripts[32];
static char  scriptx;

FILE *openPurl(base,purl,aurl)
	char *base,*purl,*aurl;
{	char *dp;
	FILE *sfp,*psfp;
	int sfd;
	int ii;
	char line[1024];

	if( purl[0] == 0 )
		strcpy(aurl,base);
	else
	if( base == NULL || purl[0] == '/' || isLoadableURL(purl) )
		strcpy(aurl,purl);
	else{
		strcpy(aurl,base);
		strcat(aurl,"/");
		strcat(aurl,purl);
	}

	sfp = NULL;
	for( ii = 0; ii < scriptx; ii++ ){
	    if( strcmp(aurl,scripts[ii].sf_aurl) == 0 ){
		if( psfp = scripts[ii].sf_sfp ){
			sfd = dup(fileno(psfp));
			sfp = fdopen(sfd,"r");
			fseek(sfp,scripts[ii].sf_off,0);
		}
	    }
	}
	if( sfp == NULL ){
		if( isLoadableURL(aurl) ){
			sfp = TMPFILE("openPurl");
			URLget(aurl,1,sfp);
		}else	sfp = fopen(aurl,"r");
	}
	return sfp;
}
load_script(name,base,purl)
	char *name,*base,*purl;
{	FILE *sfp;
	char purlb[1024],aurl[1024],furl[1024],*furl1,*path1,dir1[1024];
	char cases[1024];
	char *dp;
	int pi,ii,jj;

	if( strchr(purl,'?') ){
		strcpy(purlb,purl);
		purl = purlb;
		dp = strchr(purlb,'?');
		strcpy(cases,dp+1);
		*dp = 0;
	}else	cases[0] = 0;

	for( pi = 0; path1 = pathv[pi]; pi++ ){
		if( strcmp(path1,"+") == 0 ){
			if( base == NULL )
				continue;
			if( purl[0] == 0 )
				path1 = base;
			else
			if( strrchr(base,'/') ){
				strcpy(dir1,base);
				*strrchr(dir1,'/') = 0;
				path1 = dir1;
			}else	path1 = "";
		}
		if( (sfp = openPurl(path1,purl,aurl)) != NULL )
			break;
	}
	if( sfp == NULL ){
		fprintf(stderr,"Cannot open %s\n",aurl);
		return -1;
	}
	if( cases[0] )
		sprintf(furl,"%s#%s",aurl,cases);
	else	sprintf(furl,"%s",aurl);

	for( ii = 0; ii < scriptx; ii++ ){
		furl1 = scripts[ii].sf_furl;
		if( strcmp(furl1,furl) == 0 ){
			fprintf(stderr,
				"DeleGate ERROR: loop in script: %s -> %s\n",
				base,purl);
			for( jj = 0; jj < scriptx; jj++ )
				fprintf(stderr,"[%d] %s\n",jj,scripts[jj].sf_furl);
			fprintf(stderr,"[%d] %s\n",jj,furl);
			return -1;
		}
	}

	if( base != NULL && strcmp(aurl,base) == 0 ){
		if( cases[0] != 0 )
			strcat(cases,"+");
		strcat(cases,SELF);
	}
	scripts[scriptx].sf_aurl = aurl;
	scripts[scriptx].sf_furl = furl;
	scripts[scriptx].sf_sfp = sfp;
	scripts[scriptx].sf_off = ftell(sfp);

	scriptx++;
	eval_script(sfp,name,base,aurl,cases);
	scriptx--;

	fclose(sfp);
	return 0;
}
