/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1997 Yutaka Sato
Copyright (c) 1997 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, and distribute this material for any purpose and
without fee is hereby granted, provided that the above copyright notice
and this permission notice appear in all copies.
//////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	rident.c (remote ident)
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	971217	created
//////////////////////////////////////////////////////////////////////#*/
#include <stdio.h>
#include "vsocket.h"
extern int ACC_TIMEOUT;

int RIDENT_CLIENT = 0;
int RIDENT_SERVER = 0;

#define RIDENT_SIZE	64
#define RIDENT_MAGIC		"RIDENT/"
#define RIDENT_MAGIC_LEN	(sizeof(RIDENT_MAGIC)-1)
#define RIDENT_VER		"0.9"

static rident1(spec)
	char *spec;
{
	if( *spec == 'c' ) RIDENT_CLIENT = 1;
	if( *spec == 's' ) RIDENT_SERVER = 1;
	return 0;
}
scan_RIDENT(specs)
	char *specs;
{
	if( specs != NULL )
		scan_commaListL(specs,0,rident1);
}

static char username[128];
RIDENT_send(sock,sockname,peername,ident)
	char *sockname,*peername;
	char *ident;
{	char rident[128];
	int wcc;

	if( RIDENT_SERVER == 0 )
		return;

	if( ident == NULL ){
		if( username[0] == 0 )
			getUsername(getuid(),username);
		ident = username;
	}
	sprintf(rident,"%s%s %s %s %s %64s",RIDENT_MAGIC,RIDENT_VER,
		sockname,peername,ident," ");
	strcpy(rident+62,"\r\n");
	wcc = write(sock,rident,RIDENT_SIZE);
	return wcc;
}
RIDENT_recv(clsock,sockname,peername)
	char *sockname,*peername;
{	unsigned char rident[128],ver[128],user[128];
	int rcc;
	int ready;

	if( RIDENT_CLIENT == 0 ){
		getpairName(clsock,sockname,peername);
		return 0;
	}

	rident[0] = 0;
	ready = PollIn(clsock,ACC_TIMEOUT*1000);
	if( ready <= 0 ){
		sv1log("#### getRIDENT TIMEOUT\n",clsock);
		close(clsock);
		return -1;
	}
	rcc = recv(clsock,rident,RIDENT_SIZE,MSG_PEEK);

	if( RIDENT_MAGIC_LEN <= rcc )
	if( strncmp(rident,RIDENT_MAGIC,RIDENT_MAGIC_LEN) == 0 ){
		rcc = read(clsock,rident,RIDENT_SIZE);
		sockname[0] = peername[0] = user[0] = 0;
		if( rcc == RIDENT_SIZE )
		if( 3 <= sscanf(rident+RIDENT_MAGIC_LEN,"%s %s %s %s",
			ver,sockname,peername,user) )
		if( strcmp(ver,RIDENT_VER) == 0 ){
			sv1log("#### getRIDENT %d[%s][%s][%s]\n",
				rcc,sockname,peername,user);
			return 1;
		}
		sv1log("#### getRIDENT Version/Syntax Error\n");
		return -1;
	}
	getpairName(clsock,sockname,peername);
	return 0;
}
