/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1996 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, modify, and distribute this material for any
purpose and without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies, and
that the name of ETL not be used in advertising or publicity pertaining
to this material without the specific, prior written permission of an
authorized representative of ETL.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	remote.c (delegated invocation from remote hosts)
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	960606	created
//////////////////////////////////////////////////////////////////////#*/
#include <stdio.h>
#include <signal.h>
extern char *getenv();
extern char *gethostaddr();
#define RHOSTS	".rhosts.delegate"

static file_issock(fd)
{	int ISSOCK;

	if( isatty(fd) || file_isreg(fd) )
		return -1;

	ISSOCK = file_ISSOCK(fd);
	if( 0 < ISSOCK )
		return ISSOCK;
	if( 0 < getsocktype(fd) )
		return 1;
	return -1;
}

static int _fromRsh;
fromRsh()
{	int hosti,porti,hosto,porto;

	if( 0 < _fromRsh ) return 1;
	if( 0 > _fromRsh ) return 0;

	_fromRsh = -1;

	if( getenv("HOME") == NULL ) return 0;
	if( getenv("SHELL") == NULL ) return 0;

	if( file_issock(0) < 0 ) return 0;
	if( file_issock(1) < 0 ) return 0;
	if( file_issock(2) < 0 ) return 0;

	hosti = peerHostport(0,&porti);
	if( hosti == -1 || porti<0 || porti<512 || 1023<porti )
		return 0;
	hosto = peerHostport(1,&porto);
	if( hosto == -1 || porto<0 || porto<512 || 1023<porto )
		return 0;
	if( hosti != hosto )
		return 0;

	_fromRsh = 1;
	return 1;
}

authRsh(bg)
	int *bg;
{	char *home,path[1024];
	FILE *fp;
	char paddr[1024],saddr[1024];
	char line[1024],hosts[1024];
	char phost1[1024],*paddr1; /* client's host */
	char shost1[1024],*saddr1; /* server's host (optional) */
	int ok;

	if( (home = getenv("HOME")) == NULL ){
		fprintf(stderr,"Permission denied: no $HOME set\n");
		return -1;
	}

	sprintf(path,"%s/%s",home,RHOSTS);
	fp = fopen(path,"r");
	if( fp == NULL ){
		fprintf(stderr,"Permission denied: no %s\n",RHOSTS);
		return 1;
	}

	getpeerAddr(0,paddr);
	gethostAddr(0,saddr);

	ok = 0;
	while( fgets(line,sizeof(line),fp) ){
		wordscan(line,hosts);
		if( hosts[0] == 0 )
			continue;
		phost1[0] = shost1[0] = 0;
		if( sscanf(hosts,"%[^:]:%s",phost1,shost1) < 1 )
			continue;

		if( phost1[0] && strcmp(phost1,"*") != 0 ){
			if( (paddr1 = gethostaddr(phost1)) == NULL )
				continue;
			if( strcmp(paddr,paddr1) != 0 )
				continue;
		}
		if( shost1[0] && strcmp(shost1,"*") != 0 ){
			if( (saddr1 = gethostaddr(shost1)) == NULL )
				continue;
			if( strcmp(saddr,saddr1) != 0 )
				continue;
		}
		ok = 1;
		break;
	}
	fclose(fp);
	if( ok ){
		return 0;
	}else{
		fprintf(stderr,"Permission denied: not in %s\n",RHOSTS);
		return -1;
	}
}

RshWatcher(ninvoke,port){
	/* echo dynamically allocated PORT number */
	/* fprintf(stdout,"%d\n",port); */

	/* if( foreground ) */
	if( ninvoke == 0 ){
		char host[256];
		getpeerNAME(0,host,NULL,NULL);
		proc_title("delegated/rsh/%s",host);

		if( Fork("RshWatcher") == 0 ){
			serverControl(stdin,stdout);
			_Finish(0);
		}
	}else{
		fprintf(stderr,"\r\nRESTARTED\r\n> ");
		fflush(stderr);
	}

	/*
	fclose(stdin);
	fclose(stdout);
	fclose(stderr);
	*/
}

serverControl(in,out)
	FILE *in,*out;
{	char line[1024];

	fprintf(out,"[enter q to kill the daemon]\r\n");
	for(;;){
		fprintf(out,"> ");
		fflush(out);
		if( fgets(line,sizeof(line),in) == NULL )
			break;
		fputs(line,out);
		if( line[0] == 'q' )
			break;
		if( line[0] == 'h' || line[0] == '?' )
			fprintf(out,"[enter q to kill the daemon]\r\n");
	}
	Kill(getppid(),SIGTERM);
}

fromInetd()
{	int iss0,iss1;

	if( isatty(0) || isatty(1) || file_isreg(0) || file_isreg(1) )
		return 0;

	if( fromRsh() )
		return 0;

	iss0 = file_issock(0);
	iss1 = file_issock(1);
	if( 0 < iss0 && 0 < iss1 ){
		int host,port;
		host = sockHostport(1,&port);
		if( host == -1 || port <= 1 )
			return 0;
		return 1;
	}
	return 0;
}
