/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1997 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, modify, and distribute this material for any
purpose and without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies, and
that the name of ETL not be used in advertising or publicity pertaining
to this material without the specific, prior written permission of an
authorized representative of ETL.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	process.c
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	970117	created
//////////////////////////////////////////////////////////////////////#*/
#include <stdio.h>
#include "delegate.h"
#include "param.h"
char EXEC_PATH[1024];

extern int LOG_type;
extern char **main_argv;

extern int sendHttpResponse();

#define CLEAR(m) (Conn->m = 0)

static clearConnPTR(Conn)
	Connection *Conn;
{
	CLEAR(sv_toServ);
	CLEAR(cl_user);
	CLEAR(cl_HOST);
	CLEAR(cl_ADDR);
	CLEAR(cl_USER);
	CLEAR(cl_FromCbuff);
	CLEAR(ma_REQUEST);
	CLEAR(gw_path);
	CLEAR(ht_LockedByClient);
}

callFilter(Conn,ac,av)
	Connection *Conn;
	char *av[];
{	int ein,eout,rcc;
	FILE *in,*out;
	char *args;
	int sock;
	int rcode;

	sscanf(av[2],"%d/%d",&ein,&eout);
	in = fdopen(ein,"r");

	rcc = fread(Conn,1,sizeof(Connection),in);
	if( Conn->cl_reqbuf ){
		Conn->cl_reqbuf = (char*)malloc(Conn->cl_reqbufsize);
		fread(Conn->cl_reqbuf,1,Conn->cl_reqbufsize,in);
	}
	clearConnPTR(Conn);
	fdopenLogFile(Conn->fi_logfd);

	if( 0 < Conn->fi_arglen ){
		args = (char*)malloc(Conn->fi_arglen);
		rcc = fread(args,1,Conn->fi_arglen,in);
	}else{
		args = NULL;
		rcc = 0;
	}

	Conn->cl_sock = -1;
	if( Conn->fi_issock ){
		if( (sock = getclientsock()) < 0 )
		sock = Conn->fi_topeer;
		if( Conn->fi_dupclsock )
			Conn->cl_sock = sock;
	}else	sock = Conn->fi_topeer;

	if( Conn->fi_iomode & 1 ){
		close(eout);
		out = fdopen(sock,"w");
	}else{
		fclose(in);
		in = fdopen(sock,"r");
		out = fdopen(eout,"w");
	}

	Verbose("## callFilter: %x[%d,%d]\n",Conn->fi_func,fileno(in),fileno(out));
	rcode = (*Conn->fi_func)(Conn,in,out,args,rcc);
	Finish(rcode?1:0);
}

spawnFilter(Conn,iomode,tofil,sock,func,args)
	Connection *Conn;
	int tofil[];
	int (*func)();
	char *args;
{	char ein[32];
	int ac;
	char *av[256],epath[1024];
	char logtype[64];
	int fin; /* input at the filter side */
	int fout; /* output at the DeleGate side */
	int pid;
	int wcc;
	int wi;

	fin = tofil[0];
	fout = tofil[1];
	sprintf(ein,"%d/%d",fin,fout);

	sprintf(epath,"%s=%s",P_EXEC_PATH,EXEC_PATH);
	ac = 0;
	av[ac++] = /*DeleGate1*/ "DeleGate";
	av[ac++] = /*FuncFILTER*/ "(Filter)";
	av[ac++] = ein;
	av[ac++] = epath;

	sprintf(logtype,"-L0x%x",LOG_type);
	av[ac++] = logtype;
	ac += copy_param("f",&av[ac],&main_argv[1]);
	av[ac] = NULL;

	Conn->fi_func = func;
	if( args == NULL )
		Conn->fi_arglen = 0;
	else	Conn->fi_arglen = strlen(args)+1;
	Conn->fi_iomode = iomode;
	Conn->fi_logfd  = curLogFd();

	Conn->fi_topeer = sock;
	Conn->fi_dupclsock = 0;
	if( Conn->fi_issock = file_ISSOCK(sock) ){
		setclientsock(sock);
		if( sock == Conn->cl_sock
		 || SocketOf(sock) == SocketOf(Conn->cl_sock) )
			Conn->fi_dupclsock = 1;
			
	}

	pid = Spawnvp("openFilter",EXEC_PATH,av);
	Verbose("## spawnFilter: %d -> %d\n",getpid(),pid);

	wcc = write(fout,Conn,sizeof(Connection));
	if( Conn->cl_reqbuf )
		write(fout,Conn->cl_reqbuf,Conn->cl_reqbufsize);
	if( args != NULL )
		write(fout,args,strlen(args)+1);

	/* If the iomode == READ then
	 * must wait till the client finish to read the written environment
	 * not to read it by myself.
	 * (in the case of FFROMCL, payload data may be ready, but cannot
	 *  identify whether or not it is env. data or payload data ...)
	 * If the iomode == WRITE and filter is direct system-command then
	 * must wait not to make buffered data be not passed to the filter.
	 */
	if( iomode == 0 || iomode != 0 && 0 < PollIn(fin,1) ){
		sv1log("## wait the filter finish reading enviroment\n");
		msleep(100);
	}

	return pid;
}

FILE *openFilter(Conn,fname,func,out,args)
	Connection *Conn;
	char *fname;
	int (*func)();
	FILE *out;
	char *args;
{	int pid;
	int toc[2];
	FILE *ioin;

	pipe(toc);
	if( INHERENT_fork() ){
		if( Fork("openFilter") == 0 ){
			close(toc[1]);
			ioin = fdopen(toc[0],"r");
			(*func)(Conn,ioin,out,args);
			Finish(0);
		}
	}else{
		fflush(out);
		pid = spawnFilter(Conn,1,toc,fileno(out),func,args);
	}
	close(toc[0]);
	return fdopen(toc[1],"w");
}
