/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1997 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, modify, and distribute this material for any
purpose and without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies, and
that the name of ETL not be used in advertising or publicity pertaining
to this material without the specific, prior written permission of an
authorized representative of ETL.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	nsh.c (network shell)
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
//////////////////////////////////////////////////////////////////////#*/

#include "delegate.h"
extern char *getClientUserMbox();
extern char *wordscan();

typedef struct {
	int	 c_lev;
	char	*c_com;
	int    (*c_func)();
} Coms;

static int HELP();
static int DATE();
static int CWD();
static int LIST();
static int MAKE();
static int QUIT();
static int UNKN();

static Coms coms[] = {
	{ 0, "UNKN",	UNKN},
	{ 0, "HELP",	HELP},
	{ 0, "DATE",	DATE},
	{ 1, "CWD",	CWD},
	{ 1, "LIST",	LIST},
	{ 2, "MAKE",	MAKE},
	{ 0, "QUIT",	QUIT},
	0
};
static int clev = 0;

service_nsh(Conn)
	Connection *Conn;
{	FILE *fc,*tc;
	char comline[2048],com[1024],arg[2048];
	int ci,rcode;
	int (*func)();
	char usermbox[256];

	tc = fdopen(ToC,"w");
	fc = fdopen(FromC,"r");

	if( getClientUserMbox(Conn,usermbox) ){
		sv1log("NSH: LOGIN %s\n",usermbox);
		fprintf(tc,"USER %s\r\n",usermbox);
		fflush(tc);
		clev = 1;
	}else{
		fprintf(tc,"USER %s\r\n",usermbox);
		fflush(tc);
	}

	while( fgets(comline,sizeof(comline),fc) ){
		wordscan(wordscan(comline,com),arg);
		rcode = -1;
		func = UNKN;
		for( ci = 0; coms[ci].c_com; ci++ ){
			if( strcasecmp(com,coms[ci].c_com) == 0 ){
				func = coms[ci].c_func;
				break;
			}
		}

		if( func == UNKN )
			ci = 0;
		if( clev < coms[ci].c_lev ){
			fprintf(tc,"Forbidden.\r\n");
			rcode = 0;
		}else	rcode = (func)(Conn,tc,fc,com,arg);
		fflush(tc);

		sv1log("NSH: %s = %d\n",com,rcode);
		if( rcode != 0 )
			break;
	}
}

static HELP(Conn,tc,fc)
	Connection *Conn;
	FILE *tc,*fc;
{	int ci;
	char *com;

	for( ci = 0; com = coms[ci].c_com; ci++ )
		fprintf(tc,"%1s %s\r\n",
			coms[ci].c_lev <= clev ? "+":"-",
			com);
	return 0;
}
static DATE(Conn,tc,fc)
	Connection *Conn;
	FILE *tc,*fc;
{	char date[128];

	StrftimeLocal(date,sizeof(date),"%y/%m/%d %H:%M:%S %z %a",time(0));
	fprintf(tc,"%s\r\n",date);
	return 0;
}
static CWD(Conn,tc,fc,com,arg)
	Connection *Conn;
	FILE *tc,*fc;
	char *com,*arg;
{	char cwd[128];

	if( arg[0] )
		chdir(arg);
	getcwd(cwd,sizeof(cwd));
	fprintf(tc,"%s\r\n",cwd);
	return 0;
}
static LIST(Conn,tc,fc)
	Connection *Conn;
	FILE *tc,*fc;
{
	ls_unix(tc,NULL,"%T%M%3L %-8O %8S %D %N",".",NULL);
	return 0;
}
static MAKE(Conn,tc,fc)
	Connection *Conn;
	FILE *tc,*fc;
{	int fd1,fd2,rcode;

	fd1 = dup(1); dup2(fileno(tc),1);
	fd2 = dup(2); dup2(fileno(tc),2);
	rcode = system("nmake");
	dup2(fd1,1); close(fd1);
	dup2(fd2,2); close(fd2);
	fprintf(tc,"EXIT %d\r\n");
	return 0;
}
static QUIT(Conn,tc,fc)
	Connection *Conn;
	FILE *tc,*fc;
{
	fprintf(tc,"BYE...\r\n");
	return 1;
}
static UNKN(Conn,tc,fc,com,arg)
	Connection *Conn;
	FILE *tc,*fc;
	char *com,*arg;
{
	fprintf(tc,"UNKNOWN\r\n");
	return 0;
}


service_shell(Conn)
	Connection *Conn;
{	FILE *fc,*tc;
	char command[1024];
	char *shell;

	if( service_permitted(Conn,"shell") == 0 )
		return;

	if( D_SELECTOR[0] )
		shell = D_SELECTOR;
	else	shell = getenv("SHELL");
	if( shell == NULL ){
		return;
	}

	nonxalpha_unescape(shell,command,1);
	sv1log("shell: command=[%s]\n",command);
	/* set CGI enviroment */

	fc = fdopen(FromC,"r");
	tc = fdopen(ToC,"w");

	if( streq(DST_HOST,"-") || streq(DST_HOST,"-.-") ){
		int fd2;
		/* fd2 = dup(2); dup2(ToC,2); */
		System(command,fc,tc);
		/* dup2(fd2,2); close(fd2); */
	}
}

service_system(Conn)
	Connection *Conn;
{	FILE *fc,*tc;
	char line[4096],*dp;
	char com[4096],*arg;
	char cwd[1024];
	int tofd[2];
	int fromfd[2];
	FILE *fromfp;
	int pid,wpid;

	if( service_permitted(Conn,"system") == 0 )
		return;

	fc = fdopen(FromC,"r");
	tc = fdopen(ToC,"w");

	for(;;){
		fprintf(tc,"SYSTEM> ");
		fflush(tc);

		if( fgets(line,sizeof(line),fc) == NULL )
			break;

		if( dp = strpbrk(line,"\r\n") )
			*dp = 0;
		arg = wordscan(line,com);
		if( *arg == ' ' )
			arg++;
		sv1log("#### [%s][%s]\n",com,arg);

		if( strcaseeq(com,"exit") )
			break;

		if( !method_permitted(Conn,DST_PROTO,com) ){
			fprintf(tc,"Forbidden: %s\r\n",com);
			fflush(tc);
			continue;
		}

		if( strcaseeq(com,"cd") || strcaseeq(com,"chdir") ){
			if( chdir(arg) != 0)
				fprintf(tc,"%s: No such directory\r\n",arg);
			else{
				getcwd(cwd,sizeof(cwd));
				fprintf(tc,"%s\r\n",cwd);
			}
			continue;
		}
		if( strcaseeq(com,"pwd") ){
			getcwd(cwd,sizeof(cwd));
			fprintf(tc,"%s\r\n",cwd);
			continue;
		}
		if( strcaseeq(com,"rm") ){
			if( unlink(arg) == 0 )
				fprintf(tc,"removed: %s\r\n",arg);
			else	fprintf(tc,"cannot remove: %s\r\n");
			continue;
		}

		if( !INHERENT_spawn() )
			systemFilter(line,fc,tc);
		else{
			pipe(fromfd);
			fromfp = fdopen(fromfd[1],"w");
			pid = systemFilterNowait(line,fc,fromfp,tofd);
			fclose(fromfp);
			close(tofd[0]);
			wpid = relay_tofilter(pid,FromC,tofd[1],fromfd[0],ToC);
			close(tofd[1]);
			close(fromfd[0]);
			if( 0 < wpid )
				wait(0);
		}
	}
}
