/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1995 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, modify, and distribute this material for any
purpose and without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies, and
that the name of ETL not be used in advertising or publicity pertaining
to this material without the specific, prior written permission of an
authorized representative of ETL.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	nntpgw.c (NNTP / HTTP gateway)
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	950903	created
//////////////////////////////////////////////////////////////////////#*/
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include "delegate.h"
extern char *Sprintf();
extern FILE *TMPFILE();
extern FILE *NNTP_openArticle();
extern FILE *NNTP_openLIST();
extern int DELEGATE_LastModified;
extern char *someGroup();

#define LINESIZE	4095

extern int ACLMAX;

int EXPIRE_ART = 24*3600;
int EXPIRE_LIST = 600;

static int PSIZE = 10;
int ALIST_WINDOW = 10;
int ALIST_MAXWIN = 100;

static char *MyProto = "http";  /* client's protocol (http or https) */

typedef struct {
	int	 printMode;
	int	 mounted;
	int	 layered;
	int	 source;
	int	 no_tailer;
	int	 isHTML;
	int	 expires;
	int	 expireA;

	int	 start;
	int	 nsid;
	char	 hostport[256];
	FILE	*tmpfp;
	char	 urlFullSelf[1024];
	char	 urlSelf[1024];
	char	 urlbase[1024];
	char	 search[1024];
	char	 iconbase[1024];
	char	 iconform[1024];

	FILE	*lfp;
	char	 group[1024];
	char	 rgroup[1024];
	char	 prgroup[1024];
	char	 upgroup[1024];
	int	 nhit;
	int	 nact;
	int	 nall;
	int	 nempty;
	int	 min1;
	int	 max1;
	int	 nact1;
	int	 nchild1;
	char	 group1[1024];
	char	 grouphint[1024];

	int	 min;
	int	 max;
	int	 anum1;
	int	 anum2;
	char	 msgid[1024];
	char	 emptyarts[1024];

	char	 aclid[128];
	char	 aclurl[1024];
	char	 userclass[64];
	int	 nadmin;
	int	 nunsub;
	int	 nsubsc;
	int	 subscribe;

	char	hbase[1024];
	char	self[1024];
	char	top[64];
	char	end[64];
	char	purl1[1024];
	char	purlp[1024];
	char	nurl1[1024];
	char	nurlp[1024];
	char	center[64];
	char	wide[64];
	char	narrow[64];

	FILE	*afp;
	int	anum;
	char	subject[2048];
	char	reply_to[1024];
	char	summary[LINESIZE];
	char	date[128];
	char	from[512];
	char	message_id[256];
	char	organization[512];
	char	newsgroups[LINESIZE];
	char	references[LINESIZE];
	char	lines[128];
	char	xref[LINESIZE];

	char	xrefList[64];
	char	sDate[64];
	char	newSubj[256];
} NewsEnv;

static clearNewsEnv(env)
	NewsEnv *env;
{
	env->printMode	= 0;
	env->mounted	= 0;
	env->layered	= 0;
	env->no_tailer	= 0;
	env->source	= 0;
	env->isHTML	= 0;
	env->expires	= 0;
	env->expireA	= 0;
}

#define PrintMode env->printMode
#define Start	env->start
#define Nsid	env->nsid
#define Tmpfp	env->tmpfp
#define UrlSelf	env->urlSelf
#define UrlFullSelf env->urlFullSelf
#define UrlBase	env->urlbase
#define Search	env->search
#define Hostport env->hostport
#define Iconbase env->iconbase
#define Iconform env->iconform

#define	Mounted	env->mounted
#define Layered	env->layered
#define NoTailer env->no_tailer
#define Lfp	env->lfp
#define Rgroup	env->rgroup
#define Prgroup	env->prgroup
#define Upgroup	env->upgroup
#define Expires	env->expires
#define Nhit	env->nhit
#define Nact	env->nact
#define Nall	env->nall
#define Nempty	env->nempty
#define Min1	env->min1
#define Max1	env->max1
#define Nact1	env->nact1
#define Nchild1	env->nchild1
#define Group1	env->group1
#define GroupHint env->grouphint

#define AclID	env->aclid
#define AclURL	env->aclurl
#define UserClass env->userclass
#define Nadmin	env->nadmin
#define Nsubsc	env->nsubsc
#define Nunsub	env->nunsub
#define Subscribe env->subscribe

#define Hbase	env->hbase
#define Self	env->self
#define Group	env->group
#define Anum1	env->anum1
#define Anum2	env->anum2
#define Min	env->min
#define Max	env->max
#define ExpireA	env->expireA
#define Source	env->source
#define Msgid	env->msgid
#define Emptyarts env->emptyarts

#define Top	env->top
#define End	env->end
#define Purl1	env->purl1
#define Purlp	env->purlp
#define Nurl1	env->nurl1
#define Nurlp	env->nurlp
#define Center	env->center
#define Wide	env->wide
#define Narrow	env->narrow

#define Afp		env->afp
#define Anum		env->anum
#define Reply_To	env->reply_to
#define Subject		env->subject
#define Date		env->date
#define From		env->from
#define Organization	env->organization
#define Newsgroups	env->newsgroups
#define References	env->references
#define Lines		env->lines
#define Xref		env->xref
#define Message_ID	env->message_id
#define Summary		env->summary

#define XrefList	env->xrefList
#define SDate		env->sDate
#define NewSubj		env->newSubj
#define IsHTML		env->isHTML

static int ENCODE_ENT1;
static put1s(fp,fmt,val)
	FILE *fp;
	char *fmt,*val;
{	char buf[4096];

	if( fp != NULL ){
		if( ENCODE_ENT1 ){
			ENCODE_ENT1 = 0;
			encodeEntities(val,buf);
			val = buf;
		}
		if( fmt[0] == '%' && fmt[1] == 's' && fmt[2] == 0 )
			fputs(val,fp);
		else	fprintf(fp,fmt,val);
	}
	return val[0];
}
static put1d(fp,fmt,iv)
	FILE *fp;
	char *fmt;
{	char buf[32];
	char fmt1[8];

	if( fp != NULL ){
		if( fmt[0]=='%' && fmt[1]=='0' && isdigit(fmt[2]) ){
			sprintf(fmt1,"%%0%dd",atoi(&fmt[2]));
			sprintf(buf,fmt1,iv);
		}else	sprintf(buf,"%d",iv);
		put1s(fp,fmt,buf);
	}
	return iv;
}

static dispExpire(se,start,done,expires)
	char *se;
{	char now[128],exp[128];

	StrftimeLocal(now,sizeof(now),TIMEFORM_mdHMS,done);
	StrftimeLocal(exp,sizeof(exp),TIMEFORM_mdHMS,expires);
	sprintf(se,"Generated:%s (%d sec) Expires:%s",now,done-start,exp);
}

extern char *MailGate();

static printItem(Conn,fp,fmt,name,arg,env)
	Connection *Conn;
	FILE *fp;
	char *fmt,*name,*arg;
	NewsEnv *env;
{	int rcode;

	if( name[0] == '_' ){
		ENCODE_ENT1 = 1;
		name++;
	}else	ENCODE_ENT1 = 0;

	if( streq(name,"req") ){
		if( strncmp(arg,"search",6) == 0 ){
			if( arg[6] == 0 )	return put1s(fp,fmt,Search);
			if( arg[6] == '.' )	return streq(arg+7,Search);
		}
	}else
	if( streq(name,"grp") ){
		if( streq(arg,"list") ){
			Nhit = putLIST(Conn,env,Lfp,fp,Hostport,Mounted,Group,Layered,
				&Nact,&Nall,&Nempty);
			return 1;
		}
		if( streq(arg,"acl") )
			return getSubscription(Conn,fp,UserClass,Group,NULL,NULL);

		if( streq(arg,"Layered") )	return put1d(fp,fmt,Layered);
		if( streq(arg,"name") )		return put1s(fp,fmt,Group);
		if( streq(arg,"real") )		return put1s(fp,fmt,Rgroup);
		if( streq(arg,"print") )	return put1s(fp,fmt,Prgroup);
		if( streq(arg,"up") )		return put1s(fp,fmt,Upgroup);
		if( streq(arg,"Max1") )		return put1d(fp,fmt,Max1);
		if( streq(arg,"Min1") )		return put1d(fp,fmt,Min1);
		if( streq(arg,"Nact1") )	return put1d(fp,fmt,Nact1);
		if( streq(arg,"Nchild1") )	return put1d(fp,fmt,Nchild1);
		if( streq(arg,"Group1") )	return put1s(fp,fmt,Group1);

		if( streq(arg,"Nadmin") )	return put1d(fp,fmt,Nadmin);
		if( streq(arg,"Nunsub") )	return put1d(fp,fmt,Nunsub);
		if( streq(arg,"Nsubsc") )	return put1d(fp,fmt,Nsubsc);
		if( streq(arg,"Subscribe") )	return put1d(fp,fmt,Subscribe);
	}else
	if( streq(name,"acl") ){
		if( streq(arg,"id") )		return put1s(fp,fmt,AclID);
		if( streq(arg,"url") )		return put1s(fp,fmt,AclURL);
		if( streq(arg,"max") )		return put1d(fp,fmt,ACLMAX);
		if( streq(arg,"mailgate") )	return put1s(fp,fmt,MailGate(Conn));
	}else
	if( streq(name,"printmode") ){
		if( streq(arg,"on") ){
			PrintMode = 1;
			return 1;
		}
		return PrintMode;
	}else
	if( streq(name,"num") ){
		if( streq(arg,"article") )	return put1d(fp,fmt,Nact);
		if( streq(arg,"match") )	return put1d(fp,fmt,Nhit);
		if( streq(arg,"all") )		return put1d(fp,fmt,Nall);
		if( streq(arg,"empty") )	return put1d(fp,fmt,Nempty);
		if( streq(arg,"anum1") )	return put1d(fp,fmt,Anum1);
		if( streq(arg,"anum2") )	return put1d(fp,fmt,Anum2);
		if( streq(arg,"min")   )	return put1d(fp,fmt,Min);
		if( streq(arg,"max")   )	return put1d(fp,fmt,Max);
						return put1d(fp,fmt,0);
	}else
	if( streq(name,"art") ){
		if( streq(arg,"Anum") )		return put1d(fp,fmt,Anum);
		if( streq(arg,"IsHTML") )	return put1d(fp,fmt,IsHTML);
		if( streq(arg,"Date") )		return put1s(fp,fmt,Date);
		if( streq(arg,"From") )		return put1s(fp,fmt,From);
		if( streq(arg,"Reply_To") )	return put1s(fp,fmt,Reply_To);
		if( streq(arg,"Subject") )	return put1s(fp,fmt,Subject);
		if( streq(arg,"NewSubj") )	return put1s(fp,fmt,NewSubj);
		if( streq(arg,"Newsgroups") )	return put1s(fp,fmt,Newsgroups);
		if( streq(arg,"Lines") )	return put1s(fp,fmt,Lines);
		if( streq(arg,"XrefList"))	return put1s(fp,fmt,XrefList);
		if( streq(arg,"SDate"))		return put1s(fp,fmt,SDate);
		if( streq(arg,"Msgid") )	return put1s(fp,fmt,Msgid);
		if( streq(arg,"References") )	return put1s(fp,fmt,References);
		if( streq(arg,"Organization"))	return put1s(fp,fmt,Organization);
		if( streq(arg,"Message_ID") )	return put1s(fp,fmt,Message_ID);
		if( streq(arg,"Summary") )	return put1s(fp,fmt,Summary);
		if( streq(arg,"xreflist") )	return putXreflist(Conn,env,fp);
		if( streq(arg,"lastref") )	return putLastRef(Conn,env,fp);
		if( streq(arg,"body") )		return putArt1(Conn,env,Afp,fp);
		if( streq(arg,"list") )		return putArts(Conn,fp,env);
		if( streq(arg,"emptys") )	return put1s(fp,fmt,Emptyarts);
	}else
	if( streq(name,"arturl") ){
		char *src,buff[2048];
		src = NULL;
		if( streq(arg,"Message_ID") )	src = Message_ID; else
		if( streq(arg,"Reply_To") )	src = Reply_To; else
		if( streq(arg,"From") )		src = From;
		if( streq(arg,"Subject") )	src = Subject;
		if( src ){
			char tmp1[2048],tmp2[2048];
			/* decode entities encoded in getFV_D() ... :-O */
			if( streq(arg,"From") || streq(arg,"Subject") ){
				decodeEntities(src,tmp1,1);
				src = tmp1;
			}
			MIME_strHeaderEncode(src,tmp2,sizeof(tmp2));
			src = tmp2;
			safe_escape(src,buff);
			return put1s(fp,fmt,buff);
		}
	}else
	if( streq(name,"ref") ){
		put1s(fp,fmt,Hbase);
		if( streq(arg,"self") )		return put1s(fp,fmt,Self);
		if( streq(arg,"top")    )	return put1s(fp,fmt,Top);
		if( streq(arg,"end")    )	return put1s(fp,fmt,End);
		if( streq(arg,"purl1")  )	return put1s(fp,fmt,Purl1);
		if( streq(arg,"purlp")  )	return put1s(fp,fmt,Purlp);
		if( streq(arg,"nurl1")  )	return put1s(fp,fmt,Nurl1);
		if( streq(arg,"nurlp")  )	return put1s(fp,fmt,Nurlp);
		if( streq(arg,"center") )	return put1s(fp,fmt,Center);
		if( streq(arg,"wide")   )	return put1s(fp,fmt,Wide);
		if( streq(arg,"narrow") )	return put1s(fp,fmt,Narrow);
	}else
	if( streq(name,"tailer") ){
		if( streq(arg,"off") ){	return NoTailer = 1; }
	}else
	if( streq(name,"icon") ){
		char url[1024];
		sprintf(url,"%s/%s",Iconbase,arg);
						return put1s(fp,fmt,url);
	}else
	if( streq(name,"url") ){
		if( streq(arg,"base") )		return put1s(fp,fmt,UrlBase);
		if( streq(arg,"self") )		return put1s(fp,fmt,UrlSelf);
		if( streq(arg,"fullself") )	return put1s(fp,fmt,UrlFullSelf);
	}else
	if( streq(name,"serv") ){
		if( streq(arg,"hostport") )	return put1s(fp,fmt,Hostport);
	}else
	if( streq(name,"user") ){
		if( streq(arg,"class") )	return put1s(fp,fmt,UserClass);
	}else
	if( streq(name,"expires") ){
		char sexpire[128];
		if( Expires ){
			dispExpire(sexpire,Start,time(0),Expires);
			put1s(fp,fmt,sexpire);
		}
		return Expires;
	}
	{
	char val[256];
	sprintf(val,"%s.%s",name,arg);
	return put1s(fp,"(unknown %s)",val);
	}
}

static putLayered(Conn,env,tc,nactive,nchildren,base,group,ogroup)
	Connection *Conn;
	NewsEnv *env;
	FILE *tc;
	char *base,*group,*ogroup;
{	char *dp;
	char pgroup[1024];

	if( nchildren && nactive ){
		if( nchildren == 1 ){
			sprintf(Group1,"%s/",ogroup);
		}else{
			if( base[0] == 0 || group[0] == 0 )
				dp = "";
			else	dp = ".";
			sprintf(Group1,"%s%s%s",base,dp,group);
		}

Nchild1 = nchildren;
Nact1 = nactive;
Min1 = 0;
Max1 = 0;
putBuiltinHTML(Conn,tc,"NNTP/HTTP-Gateway-NGLine","news/ngline.dhtml",NULL,printItem,env);

	}
}

extern char *wordscan();
static scanLIST1(line,group,minp,maxp)
	char *line,*group;
	int *minp,*maxp;
{	char *lp,buf[32];

	/* return sscanf(line,"%s %d %d",group,maxp,minp); */
	lp = line;
	if( (lp = wordscan(lp,group)) == 0) return 0;
	if( (lp = wordscan(lp,buf)) == 0) return 1;
	*maxp = atoi(buf);
	if( (lp = wordscan(lp,buf)) == 0) return 2;
	*minp = atoi(buf);
	return 3;
}
static scanName1(name,name1)
	char *name,*name1;
{	char ch,*sp,*dp;

	dp = name1;
	for( sp = name; ch = *sp; sp++ ){
		if( ch == '.' )
			break;
		*dp++ = ch;
	}
	*dp = 0;
}


extern char *getFieldValue2();
#define getFieldValue(str,fld,buf,siz) getFieldValue2(str,fld,buf,siz)
#define getFV(str,fld,buf)             getFieldValue2(str,fld,buf,sizeof(buf))
#define getFV_D(str,fld,buf)           getFieldValue_D(str,fld,buf,sizeof(buf))

static getFieldValue_D(head,field,value_D,size)
	char *head,*field,*value_D;
{	char value[LINESIZE*2];

	getFieldValue(head,field,value_D,size);
	line_codeconv_repair(value_D,value,"text/plain");
	encodeEntities(value,value_D);
}

static numXref(xref)
	char *xref;
{	char *xp;
	int nx;

	nx = 0;
	for(xp = strpbrk(xref," \t\r\n"); xp; xp = strpbrk(xp+1," \t\r\n") )
		nx++;
	return nx;
}
static xrefnext(xref,group,next)
	char *xref,*group,*next;
{	char xb[LINESIZE],*xv[128],*x1;
	int nx,xi;
	int glen;

	strcpy(xb,xref);
	nx = 0;
	for( x1 = strpbrk(xb," \t\r\n"); x1; x1 = strpbrk(x1," \t\r\n") ){
		*x1++ = 0;
		while( strchr(" \t\r\n",*x1) )
			x1++;
		xv[nx++] = x1;
	}
	xv[nx] = 0;

	sprintf(next,"");
	glen = strlen(group);
	for( xi = 0; xi < nx; xi++ ){
		if( strncmp(xv[xi],group,glen) == 0 && xv[xi][glen] == ':' ){
			if( xv[xi+1] )
				strcpy(next,xv[xi+1]);
			else	strcpy(next,xv[0]);
			break;
		}
	}
}

static maybe_username(name)
	char *name;
{	char *np,ch;
	int na,nd,ns;

	na = nd = ns = 0;
	for( np = name; ch = *np; np++ ){
		if( ch == '@' )  break;
		if( isalpha(ch)) na++; else
		if( isdigit(ch)) nd++; else
		if( ch == '-' )  ns++; else
		if( ch == '.' )  ns++; else
			return 0;
	}
	if( na + nd + ns <= 8 )
	if( ns <= 1 )
	if( nd < na || isalpha(*name) )
		return 1;
	return 0;
}

static markup1(nsid,dst,src,references,mailboxes,group,anum)
	char *dst,*src,*references,*mailboxes,*group;
{	char msgid[1024];

	if( src[0] != '<' || src[strlen(src)-1] != '>' ){
		strcpy(dst,src);
		return;
	}

	strcpy(msgid,src+1);
	msgid[strlen(msgid)-1] = 0;

	if( strncasecmp(msgid,"URL:",4) == 0 ){
		sprintf(dst,"<A HREF=\"%s\"><I>&lt;%s&gt;</I></A>",
			msgid+4,msgid);
	}else
	if( strchr(msgid,'@') ){
		char href[1024],xmsgid[1024];

		url_escape(msgid,xmsgid,"/*%");
		if( anum )
			sprintf(href,"../%s/%s?Base=%s/%d",someGroup(),xmsgid,
				group,anum);
		else	sprintf(href,"../%s/%s",someGroup(),xmsgid);

		if( strstr(references,src) )
			sprintf(dst,"<A HREF=\"%s\"><I>&lt;%s&gt;</I></A>",href,msgid);
		else
		if( strstr(mailboxes,msgid) == 0 && !maybe_username(msgid) )
			sprintf(dst,"<A HREF=\"%s\">&lt;%s&gt;</A>",href,msgid);
		else	sprintf(dst,"&lt;%s&gt;",msgid);
	}else
	if( strstr(msgid,"://") ){
		sprintf(dst,"<A HREF=\"%s\"><I>&lt;%s&gt;</I></A>",msgid,msgid);
	}else	sprintf(dst,"<I>&lt;%s&gt;</I>",msgid);
}

extern unsigned char *strpbrk1B();
#define isIDCHAR(ch)	( 0x20 < ch && ch < 0x7F && ch != '<' && ch != '>' )

static markup_reference(nsid,references,mailboxes,group,anum,resp,xresp)
	unsigned char *references,*mailboxes;
	unsigned char *group,*resp;
	char *xresp;
{	unsigned char ch,*rp,*sp,*ep,*tp;
	unsigned char tmp[4096];
	char *xp;
	int sx,notid;

	xp = xresp;
	*xp = 0;
	for( rp = resp; rp && *rp; rp = ep ){
		if( (sp = strpbrk1B(rp,"<>",&xp)) == NULL )
			break;
		if( *sp == '>' ){
			strcpy(xp,"&gt;");
			xp += strlen(xp);
			ep = sp + 1;
			continue;
		}

		tmp[0] = '<';
		tp = tmp + 1;
		notid = 0;
		if( (ep = strpbrk1B(sp+1,"<>",&tp)) == NULL )
			notid = 1;
		else
		if( *ep == '<' )
			notid = 2;
		else
		/* ep == '>' */
		{
			ep++;
			for( sx = 1; ch = tmp[sx]; sx++ ){
				if( !isIDCHAR(ch) ){
					strcat(tmp,"&gt;");
					notid = 3;
					break;
				}
			}
		}
		if( notid ){
			strcpy(xp,"&lt;");
			strcat(xp,tmp+1);
			xp += strlen(xp);
			continue;
		}

		strcat(tmp,">");
		markup1(nsid,xp,tmp,references,mailboxes,group,anum);
		xp += strlen(xp);
	}
	*xp = 0;
}
putLastRef(Conn,env,tc)
	Connection *Conn;
	NewsEnv *env;
	FILE *tc;
{	char *sp,*tp,mark[1024],msgid[1024];
	int len;

	if( References[0] == 0 )
		return;

	msgid[0] = 0;
	if( tp = strrchr(References,'>') ){
	for( sp = tp - 1; References <= sp; sp-- )
		if( *sp == '<' ){
			len = tp - sp + 1;
			strncpy(msgid,sp,len);
			msgid[len] = 0;
			break;
		}
	}
	if( msgid[0] ){
		markup1(Nsid,mark,msgid,References,From,Group,Anum);
		fprintf(tc,"%s",mark);
	}
}

static putXref(tc,form,hostport,basegroup,xref)
	FILE *tc;
	char *form,*hostport,*basegroup,*xref;
{	char xref1[1024],*nxref;
	char group[1024],*dp;
	char url[1024],anchor[1024];
	int anum;

	nxref = wordscan(xref,xref1);
	if( sscanf(xref1,"%[^:]:%d",group,&anum) == 2 ){
		if( mount_url_fromL(url,"nntp",hostport,group,NULL,MyProto,"-.-") )
		if( dp = strrchr(url,'/') )
			strcpy(group,dp+1);

sprintf(anchor,"<A HREF=\"../%s/%d\">%s/%d</A>",group,anum,group,anum);
fprintf(tc,form,anchor);
	}
	if( nxref && *nxref )
		putXref(tc,form,hostport,basegroup,nxref);
}
putXreflist(Conn,env,tc)
	Connection *Conn;
	NewsEnv *env;
	FILE *tc;
{	int nxref;

	if( Xref[0] == 0 )
		return;

	if( strcmp(Search,"Xref") == 0 ){

fprintf(tc,"<UL>\r\n");
putXref(tc,"<LI> %s\r\n",Hostport,Group,Xref);
fprintf(tc,"</UL>\r\n");

	}else{
		nxref = numXref(Xref);
		if( nxref == 1 && Msgid[0] ){

putXref(tc,"[%s]\r\n",Hostport,Group,Xref);

		}else
		if( 2 <= nxref )

fprintf(tc,"<A HREF=\"%s?Xref\">[Xref*%d]</A>\r\n",Self,nxref);

	}
}

stripBracket(str)
	char *str;
{	char *tp,*ep;
	int len;

	if( tp = strchr(str,'<') )
	if( ep = strchr(tp,'>') ){
		len = ep - tp - 1;
		strncpy(str,tp+1,len);
		str[len] = 0;
	}
}

static char *skipRe(sp)
	char *sp;
{
	while( strncasecmp(sp,"Re:",3) == 0 ){
		sp += 3;
		while( *sp == ' ' )
			sp++;
	}
	return sp;
}
static putARTICLE(Conn,env,afp,tc,withbody,prevsubj)
	Connection *Conn;
	NewsEnv *env;
	FILE *afp,*tc;
	char *prevsubj;
{	char head[0x2000],*hp,*dp;
	int flen,getit;
	char xrefs[LINESIZE];
	char contenttype[512];
	int li;

	Afp = Tmpfp;

	getit = 0;
	hp = head;

	Verbose("putARTICLE(%s,%d) %s/%s\n",Group,Anum,GroupHint,Msgid);
	for( li = 0;;li++ ){
		if( fgets(hp,&head[sizeof(head)]-hp,afp) == NULL )
			break;
		if( li == 0 && strncmp(hp,"From ",5) == 0 ) /* unix format header */
			continue;

		if( *hp == '\r' || *hp == '\n' || *hp == 0 )
			break;

		if( *hp == ' ' || *hp == '\t' ){
			if( getit )
				hp += strlen(hp);
			continue;
		}
		dp = strpbrk(hp," \t:");
		if( dp == 0 )
			continue;
		flen = dp - hp;

		if(
		    strncasecmp(hp,"Subject",flen) == 0
		||  strncasecmp(hp,"Summary",flen) == 0
		||  strncasecmp(hp,"Date",flen) == 0
		||  strncasecmp(hp,"Content-Type",flen) == 0
		||  strncasecmp(hp,"From",flen) == 0
		||  strncasecmp(hp,"Reply-To",flen) == 0
		||  strncasecmp(hp,"Lines",flen) == 0
		||  strncasecmp(hp,"Organization",flen) == 0
		||  strncasecmp(hp,"Newsgroups",flen) == 0
		||  strncasecmp(hp,"Message-ID",flen) == 0
		||  strncasecmp(hp,"References",flen) == 0
		||  strncasecmp(hp,"Xref",flen) == 0
		){
			getit = 1;
			hp += strlen(hp);
		}else	getit = 0;
	}

	getFV_D(head,"Subject",Subject);
	getFV_D(head,"Summary",Summary);
	getFV_D(head,"From",From);

	getFV(head,"Reply-To",Reply_To);
	if( Reply_To[0] == 0 )
		getFV(head,"From",Reply_To);
	RFC822_addresspart(Reply_To,Reply_To);

	getFV_D(head,"Organization",Organization);
	getFV(head,"Date",Date);
	getFV(head,"Newsgroups",Newsgroups);
	getFV(head,"Lines",Lines);
	getFV(head,"References",References);
	getFV(head,"Message-ID",Message_ID);
	stripBracket(Message_ID);

	getFV(head,"Content-Type",contenttype);
	if( strncasecmp(contenttype,"text/html",9) == 0 )
		IsHTML = 1;
	else	IsHTML = 0;

	NNTP_selectXref(Nsid,head,xrefs);
	getFV(xrefs,"Xref",Xref);

	if( Date[0] == 0 && From[0] == 0 && Message_ID[0] == 0 ){
		if( withbody )
fprintf(tc,"<H2>no article</H2>\r\n");

		Verbose("Bad article: Date[%s] From[%s]\n",Date,From);
		return;
	}else
	if( withbody ){
/*
#fprintf(tc,"<A HREF=\"%d?Referer\">[Referer]</A>\r\n",Anum);
#if( Anum && strcmp(Group,someGroup()) != 0 ){
#fprintf(tc,"<A HREF=%d?PrevSubj>%s/prev.gif\"></A>\r\n",Anum,Iconform);
#fprintf(tc,"<A HREF=%d?NextSubj>%s/next.gif\"></A>\r\n",Anum,Iconform);
}
*/

putBuiltinHTML(Conn,tc,"NNTP/HTTP-Gateway-ARTHead","news/arthead.dhtml",NULL,printItem,env);

	}else{
		int idate;
		char *sp,*np,*pp,ch,prntsubj[1024],normsubj[1024];

		pp = prntsubj;
		sp = Subject;
		sp = skipRe(sp);
		if( sp[0] == '[' && (np = strchr(sp+1,']')) ){
			do *pp++ = *sp++; while(sp <= np);
			while( *sp == ' ' )
				sp++;
		}
		sp = skipRe(sp);
		if( *sp ){
			if( pp != prntsubj )
				*pp++ = ' ';
			strcpy(pp,sp);
			strcpy(normsubj,sp);
			strip_ISO2022JP(normsubj);
			np = normsubj;
			for( sp = normsubj; ch = *sp++; )
				if( ch != ' ' )
					*np++ = ch;
			*np = 0;
		}else{
			if( Subject[0] == 0 )
				strcpy(prntsubj,"(empty subject)");
			else	strcpy(prntsubj,Subject);
			strcpy(normsubj,prntsubj);
		}

		if( strcmp(prevsubj,normsubj) != 0 ){
			strcpy(prevsubj,normsubj);
			strcpy(NewSubj,prntsubj);
		}else	NewSubj[0] = 0;


		idate = scanNNTPtime(Date);
		if( idate == -1 )
			strcpy(SDate,Date);
		else	StrftimeLocal(SDate,sizeof(SDate),"%m/%d-%H:%M",idate);

		if( Xref[0] && 2 <= numXref(Xref) ){
			char next[1024],*dp;
			int anum;

			xrefnext(Xref,Group,next);
			anum = 0;
			if( dp = strchr(next,':') ){
				*dp = '/';
				anum = atoi(dp+1);
			}
			sprintf(XrefList,"../%s-%d",next,anum+10);
		}else	XrefList[0] = 0;

putBuiltinHTML(Conn,tc,"NNTP/HTTP-Gateway-ARTLine","news/artline.dhtml",NULL,printItem,env);

	}
}
putArt1(Conn,env,afp,tc)
	Connection *Conn;
	NewsEnv *env;
	FILE *afp,*tc;
{
	char resp[LINESIZE],xresp[LINESIZE*2],yresp[LINESIZE*2];
	char pending[LINESIZE];
	int lines;

	pending[0] = 0;
	lines = 0;
	for(;;){
		if( fgets(resp,sizeof(resp),afp) == NULL )
			break;

		if( resp[0] == '.' && resp[1] == '.' && (resp[2]=='\r' || resp[2]=='\n') )
			strcpy(resp,resp+1);

		if( resp[0] == '\r' || resp[0] == '\n' ){
			if( lines != 0 )
				strcat(pending,resp);
			continue;
		}
		if( pending[0] ){
			fputs(pending,tc);
			pending[0] = 0;
		}
		lines++;
		if( IsHTML )
			strcpy(xresp,resp);
		else	markup_reference(Nsid,References,From,Group,Anum,resp,xresp);
		line_codeconv_repair(xresp,yresp,"text/html");
		fputs(yresp,tc);
	}
}


static putLIST(Conn,env,lfp,tc,hostport,mounted,groups,layered,nactp,nallp,nemptyp)
	Connection *Conn;
	NewsEnv *env;
	FILE *lfp,*tc;
	char *hostport,*groups;
	int *nactp,*nallp,*nemptyp;
{	char resp[1024];
	char group[1024],group1[1024];
	char ogroup1[1024],ogroup[1024];
	int max,min;
	int cactive,cchildren;
	int nactive,nall,nhit,nempty;
	int lbaselen;
	char obase[1024];
	char *dp;

	ogroup[0] = 0;
	ogroup1[0] = 0;
	if( mounted ){
		if( dp = strrchr(groups,'/') )
			strcpy(obase,dp+1);
		else	strcpy(obase,groups);
	}else	strcpy(obase,groups);
	sv1log("putLIST(%s) [%s]\n",groups,obase);

	lbaselen = strlen(groups);

	cactive = 0;
	cchildren = 0;
	nall = 0;
	nhit = 0;
	nempty = 0;
	nactive = 0;

	while( !feof(lfp) ){
		if( fgets(resp,sizeof(resp),lfp) == NULL ){
			if( layered )
putLayered(Conn,env,tc,cactive,cchildren,obase,ogroup1,ogroup);
			break;
		}

		nall++;

		scanLIST1(resp,group,&min,&max);
		if( mounted ){
			char url[1024];
			if( mount_url_fromL(url,"nntp",hostport,group,NULL,MyProto,"-.-") )
				strcpy(group,url);
		}

		if( groups[0] == 0
		/* || groups[0] == '*' && strstr(resp,groups+1) */
		 || obase[0] == '*' && strstr(resp,obase+1)
		 || strstr(group,groups) == group
		){
		    if( layered ){
			if( groups[0] == 0
			 || strstr(group,groups) == group
			 &&
( groups[lbaselen-1] == '/'
|| group[lbaselen] == '/' || group[lbaselen] == '.' || group[lbaselen] == 0 )
			){
				nhit++;
				if( mounted ){
					char tmp[1024],*gp;

					gp = &group[lbaselen];
					if( *gp == '.' )
						scanName1(gp+1,group1);
					else	scanName1(gp,group1);
					if( dp = strrchr(group,'/') )
						strcpy(group,dp+1);
/*
					strcpy(group,group+lbaselen);
					if( group[0] == '.' )
						scanName1(group+1,group1);
					else	scanName1(group,group1);
					strcpy(tmp,group);
					strcpy(group,obase);
					strcat(group,tmp);
*/
				}else
				if( groups[0] == 0 )
					scanName1(group,group1);
				else
				if( group[lbaselen] == '.' )
					scanName1(group+lbaselen+1,group1);
				else	group1[0] = 0;

				if( strcmp(ogroup1,group1) == 0 ){
					if( min != 0 && max != 0 && min <= max ){
						cactive += max - min + 1;
						nactive += max - min + 1;
					}else	nempty++;
					cchildren++;
				}else{
putLayered(Conn,env,tc,cactive,cchildren,obase,ogroup1,ogroup);
					strcpy(ogroup1,group1);
					if( min != 0 && max != 0 && min <= max ){
						cactive = max - min + 1;
						nactive += max - min + 1;
					}else	cactive = 0;
					cchildren = 1;
				}
				strcpy(ogroup,group);
			}
		    }else{
			if( min != 0 && max != 0 && min <= max ){
				nhit++;

				nactive += max - min + 1;
				if( dp = strrchr(group,'/') )
					strcpy(group,dp+1);
Min1 = min;
Max1 = max;
strcpy(Group1,group);
putBuiltinHTML(Conn,tc,"NNTP/HTTP-Gateway-NGLine","news/ngline.dhtml",NULL,printItem,env);

			}else	nempty++;
		    }
		}
	}
	if( nactp ) *nactp = nactive;
	if( nallp ) *nallp = nall;
	if( nemptyp ) *nemptyp = nempty;
	return nhit;
}

#define ICON	"-/builtin/icons/ysato"

char *setHOSTbyUSER(Conn,user,userb,hostb,portp)
	Connection *Conn;
	char *user,*userb,*hostb;
	int *portp;
{	int port;

	if( strchr(user,'@') ){
		userb[0] = hostb[0] = 0;
		port = *portp;
		sscanf(user,"%[^@]@%[^:]:%d",userb,hostb,&port);
		sv1log("#### %s LOGIN %s@%s:%d\n",DST_PROTO,userb,hostb,port);
		if( hostb[0] ){
			*portp = port;
			return userb;
		}
	}
	return NULL;
}
scanPOPgroup(group,proto,user,host)
	char *group,*proto,*user,*host;
{
	if( sscanf(group,"+%[^.].%[^.].%[^/?]",proto,user,host) == 3 )
		return 1;
	else	return 0;
}
int DUP_ToC = -1;

HttpNews(Conn,vno,sv,host,port,groupanumsearch,req,user,pass)
        Connection *Conn;
        char *host,*groupanumsearch,*req;
	char *user,*pass;
{	FILE *tc,*tc_sav = NULL;
	int anum;
	char resp[1024];
	char *ctype;
	int totalc;
	int stat,nart;
	char groupanum[1024],*fp;
	char *mp;
	char murl[1024];
	int expireL;
	int isart;
	char url[1024],*dp;
	char *ep;
	int psize;
	char sexpire[128];
	NewsEnv newsEnv,*env = &newsEnv;
	int length;
	int sub,uns;
	char myhp[1024];
char gas[1024];
	int dontReadCache;
	int cached_authOK = 0;
	char proto[256],protob[256],userb[256],hostb[256],*hostp;

	strcpy(proto,DST_PROTO);

	if( user[0] ){
		if( strstr(groupanumsearch,"+auth+") ){
			strcpy(gas,groupanumsearch);
			strsubst(gas,"+auth+",user);
			strsubst(gas,"@",".");
			groupanumsearch = gas;
		}
	}

	if( scanPOPgroup(groupanumsearch,protob,userb,hostb) ){
		if( streq(protob,"pop") ){
			strcpy(proto,protob);
			user = userb;
			host = hostb;
			strcpy(REAL_PROTO,protob);
			strcpy(REAL_HOST,hostb);
			REAL_PORT = serviceport(proto);
		}
	}else{
		if( streq(proto,"pop") )
		if( setHOSTbyUSER(Conn,user,userb,hostb,&port) ){
			user = userb;
			host = hostb;
			strcpy(REAL_HOST,hostb);
			REAL_PORT = port;
		}
	}

	if( strchr(host,'@') )
	if( user[0] == 0 || pass[0] == 0 ){
		char usert[256],passt[256];
		scan_url_userpass(host,usert,passt,"");
		if( usert[0] && passt[0] ){
			strcpy(user,usert);
			strcpy(pass,passt);
			sv1log("URL> user[%s] pass[*%d]\n",user,strlen(pass));
		}
	}

	if( hostp = strchr(host,'@') )
		hostp += 1;
	else	hostp = host;
	if( streq(proto,"pop") )
	if( user[0] == 0 || pass[0] == 0 || hostp[0] == 0 || isMYSELF(hostp) ){
		char msg[1024];

		sv1log("NotAuthorized: proto[%s] user[%s] pass[%s] host[%s]\n",
			proto,user,pass[0]?"****":"",host);

		tc = fdopen(dup(ToC),"w");
		totalc = putNotAuthorized(Conn,tc,req,0,NULL);
		sprintf(msg,"<P><HR>POP/HTTP: you must send Authorization (username as user@host and password) or specify URL as +pop.USER.HOST<HR>\r\n");
		fputs(msg,tc);
		fclose(tc);
		return totalc + strlen(msg);
	}
	host = hostp;

	if( NNTP_needAuth(Conn) && user[0] == 0 ){
		tc = fdopen(dup(ToC),"w");
		totalc = putNotAuthorized(Conn,tc,req,0,NULL);
		fclose(tc);
		sv1log("NotAuthorized: need auth fot the client\n");
		return totalc;
	}

	if( CLNT_PROTO[0] )
		MyProto = CLNT_PROTO;
	else	MyProto = "http";

	clearNewsEnv(env);

	HTTP_originalURL(Conn,UrlSelf);
	if( dp = strchr(UrlSelf,'?') )
		*dp = 0;

	HTTP_ClientIF_HP(Conn,myhp);
	sprintf(UrlFullSelf,"%s://%s%s",MyProto,myhp,UrlSelf);

	Start = time(0);
	if( streq(host,"*") && streq(proto,"nntp") ){
		if( strcmp(groupanumsearch,"*") == 0 )
			groupanumsearch = "";
		Nsid = NNTP_getServer(Conn,FromC,ToC,groupanumsearch,&host,&port);
		if( strchr(groupanumsearch,'@') ){
			sprintf(gas,"*/%s",groupanumsearch);
			groupanumsearch = gas;
		}
	}else{
		Nsid = NNTP_newServer(Conn,DST_PROTO,user,pass,host,port,
			FromC,ToC,FromS,ToS);
	}

	sv1log("NNTPGW: [%s:%d]=%d=%d UserPass=[%s:%s] GroupAnumSearch=[%s]\n",
		host,port,Nsid,sv, user,pass[0]?"******":"",groupanumsearch);
	setProtoOfClient(Conn,MyProto);
	sprintf(Hostport,"%s:%d",host,port);
	/*
	HostPort(Hostport,DST_PROTO,host,port);
	*/

	sprintf(Iconbase,"%s/%s",HTTP_iconURLbase(Conn),ICON);
	if( mount_url_fromL(murl,"file","localhost",ICON,NULL,MyProto,"-.-") )
		strcpy(Iconbase,murl);
	sprintf(Iconform,"<IMG SRC=\"%s",Iconbase);

	PrintMode = 0;
	Expires = 0;
	Layered = 1; 
	Source = 0;

	Search[0] = 0;
	strcpy(groupanum,groupanumsearch);
	if( fp = strchr(groupanum,'?') ){
		strcpy(Search,fp+1);
		*fp = 0;
	}
	UrlBase[0] = 0;
	Group[0] = 0;
	Anum1 = Anum2 = 0;

	Msgid[0] = 0;
	GroupHint[0] = 0;
/*
	if( (mp = strchr(groupanum,'*')) && mp[1] == '/' ){
		strcpy(Group,"*");
		strcpy(Msgid,mp+2);
	}
*/
	if( strchr(groupanum,'@') && (mp = strchr(groupanum,'/')) ){
		sscanf(groupanum,"%[^/]",GroupHint);
		strcpy(Group,someGroup());
		strcpy(Msgid,mp+1);
	}else
	if( strncmp(groupanum,"++",2) == 0 ){
		if( user[0] == 0 || strcmp(groupanum+2,user) == 0 ){
			tc = fdopen(dup(ToC),"w");
			putNotAuthorized(Conn,tc,req,0,NULL);
			fclose(tc);
			return;
		}
		groupanum[0] = 0;
		/*sscanf(groupanum,"++%[^/]/%d-%d",group,&Anum1,&Anum2);*/
	}else{
		if( groupanum[0] == '/' ){
			Group[0] = 0;
			sscanf(groupanum,"/%d-%d",&Anum1,&Anum2);
		}else	sscanf(groupanum,"%[^/]/%d-%d",Group,&Anum1,&Anum2);
		if( strchr(groupanum,'/') == 0 )
			strcpy(UrlBase,Group);
	}

	DUP_ToC = dup(ToC);
	tc = fdopen(DUP_ToC,"w");
	Tmpfp = TMPFILE("NNTP/HTTP");

	isart = 0;
	if( Anum1 != 0 && Anum2 == 0 ) isart = 1;
	if( Anum1 == 0 && Anum2 == 0 && Msgid[0] ) isart = 1;

	ctype = "text/html";

	dontReadCache = DontReadCache;
	if( dontReadCache && !PragmaNoCache )
	if( DontWriteCache )
	if( auth_cache(0,EXPIRE_LIST,"nntp",user,pass,DST_HOST,DST_PORT) ){
		/* dontRead seems be set because Authorization is given
		 * in the HTTP request (because dontWrite is set).
		 * But because the Authorization is OK, may be cached LIST
		 * is available for the user. (but ARTICLE may be dangerous ... )
		 * But some server may be filtering the LIST per 
		 * authenticated user.
		 * (Thus the LIST should be cached per each user...)
		 */
		sv1log("#### AUTHINFO [%s:****] matches with cached one.\n",user);
		dontReadCache = 0;
		cached_authOK = 1;
	}

	if( isart ){
		Expires = 0;
		expireL = EXPIRE_LIST;

		if( dontReadCache ){
			ExpireA = 0;
			expireL = 0; /* force using GROUP command */
		}else	ExpireA = EXPIRE_ART;

		if( strcmp(Search,"Source") == 0 ){
			Source = 1;
			ctype = "text/plain";
		}
	}else{
		if( ALIST_MAXWIN < Anum2 - Anum1 ){
			sv1log("## too wide range: %d-%d\n",Anum1,Anum2);
			/* should do penalty sleep ... */
			sleep(30);

			fprintf(tc,"HTTP/1.0 500 too wide range.\r\n");
			fprintf(tc,"MIME-Version: 1.0\r\n");
			fprintf(tc,"Content-Type: text/plain\r\n");
			fprintf(tc,"\r\n");
			fprintf(tc,"Too wide range [%d-%d]\r\n",Anum1,Anum2);
			tc_sav = NULL;
			totalc = 0;
			goto EXIT;
		}

		if( Anum1 == 0 && Anum2 == 0 ) /* article.list/ and news.groups */
			Expires = time(0) + EXPIRE_LIST;
		else	Expires = time(0) + 6*60*60;
		ExpireA = -1;

		if( dontReadCache ){
			if( Anum1 == 0 && Anum2 == 0 )	/* group list or latest art. list */
				expireL = 0;
			else	expireL = EXPIRE_LIST;
		}else	expireL = EXPIRE_LIST;
	}
	if( strstr(Search,"Expire") ){
		sv1log("forced Expire\n");
		expireL = 0;
	}

	if( Msgid[0] ){
		char xmsgid[1024];
		char rgroup[1024];
		char tgroup[1024];
		int tanum;

		nonxalpha_unescape(Msgid,xmsgid,0);
		strcpy(Msgid,xmsgid);
		if( strncmp(Search,"Base=",5) == 0 )
			sscanf(Search+5,"%[^/]/%d",tgroup,&tanum);
		else{
			strcpy(tgroup,GroupHint);
			tanum = 0;
		}
		Anum1=Anum2= NNTP_getGroupAnum(Nsid,Msgid,tgroup,tanum,rgroup);
		if( Anum1 )
			strcpy(Group,rgroup);
	}

	strcpy(Prgroup,Group);
	if( mount_url_fromL(url,"nntp",Hostport,Group,NULL,MyProto,"-.-") ){
		Mounted = 1;
		if( dp = strrchr(url,'/') )
			strcpy(Prgroup,dp+1);
	}

	strcpy(Upgroup,Prgroup);
	if( Prgroup[0] == 0 )
		strcpy(Prgroup,"./");

	for( dp = &Upgroup[strlen(Upgroup)-1];; dp-- ){
		if( dp <= Upgroup ){ strcpy(Upgroup,"./"); break; }
		if( *dp == '.' ){ dp[0] = 0; break; }
		if( *dp == '/' ){ dp[1] = 0; break; }
	}

	totalc = 0;
	if( ClntKeepAlive && 0 < CKA_RemAlive
	 || *user /* maybe with Authorization, thus preceeding output
		   * should be discarded when Authorization failed... */
	){
		tc_sav = tc;
		tc = TMPFILE("NNTP/HTTP-length");
	}else{
		tc_sav = NULL;
		putHttpHeaderV(Conn,tc,vno,NULL,ctype,(char*)0,0,DELEGATE_LastModified,Expires);
	}

/*
if( user[0] ) fprintf(tc,"User[%s]<BR>\r\n",user);
*/

	strcpy(UserClass,"anonymous");
	Nadmin = getSubscription(Conn,NULL,UserClass,Group,&Nsubsc,&Nunsub);
	Subscribe = Nunsub <= Nsubsc;
	if( strncmp(Search,"Admin",5) == 0 ){
		newsAdmin(Conn,UserClass,tc,env,Group,Search);
		goto EXIT;
	}

	if( Msgid[0] == 0 )
	if( Anum1 == 0 && strchr(groupanum,'/') == NULL ){
		Lfp = NNTP_openLIST(Nsid,expireL,"active");

		if( Lfp != NULL ){
			int lbaselen;
			int nact,nall,nhit,nempty;
			char url[1024],*dp;

			if( strstr(groupanum,"Jump") && strcmp(Search,"Menu") == 0 ){
putBuiltinHTML(Conn,tc,"NNTP/HTTP-Gateway-Top","news/top.dhtml",NULL,printItem,env);
				putFrogForDeleGate(Conn,tc,"");
				goto EXIT;
			}
			if( strstr(groupanum,"Jump") && strcmp(Search,"Menu") != 0 ){
				unescape_specials(Search,"/","");
				if( Search[0] == 0 || strchr(Search,'/') ){
putBuiltinHTML(Conn,tc,"NNTP/HTTP-Gateway-Jump","news/jump.dhtml",NULL,printItem,env);
					putFrogForDeleGate(Conn,tc,"");
					goto EXIT;
				}
				strcpy(Group,Search);
				if( Group[0] == '*' )
					Layered = 0;
			}
			if( mount_url_fromL(url,"nntp",Hostport,Group,NULL,MyProto,"-.-") ){
				Mounted = 1;
				strcpy(Group,url);
				if( dp = strrchr(Group,'/') )
					strcpy(Rgroup,dp+1);
				else	Rgroup[0] = 0;
			}else{
				Mounted = 0;
				strcpy(Rgroup,Group);
			}

			lbaselen = strlen(Group);
			if( strcmp(Search,"Flat") == 0 )
				Layered = 0;

putBuiltinHTML(Conn,tc,"NNTP/HTTP-Gateway-NGList","news/nglist.dhtml",NULL,printItem,env);

			fclose(Lfp);
			putFrogForDeleGate(Conn,tc,"");

		}else{
			if( !NNTP_authERROR(Nsid) ){
				fprintf(tc,"cannot get active list.\r\n");
				putFrogForDeleGate(Conn,tc,"");
			}
		}
		goto EXIT;
	}


	if( !Subscribe ){
		fprintf(tc,
		"This newsgroup `%s'is unsubscribed for <I>anonymous</I> users.\r\n",
			Group);
		fprintf(tc,"See <A HREF=?Admin>Administration<A>.");
		goto EXIT;
	}

	NNTP_getGROUP(Nsid,expireL,Group,&nart,&Min,&Max);
	if( NNTP_authERROR(Nsid) )
		goto EXIT;
	else{
		int n1,n2;

		psize = ALIST_WINDOW;
		if( Msgid[0] ){
			if( Anum1 == 0 )
				Min = Max = 0;
		}else
		if( Anum1 == 0 ){
			Anum2 = Max;
			Anum1 = ((Max-1) / psize) * psize;
			if( Anum1 <= 0 ) Anum1 = 1;

		}else
		if( Anum2 == 0 ){
			Anum2 = Anum1;
		}else{
			n1 = (Anum1 / PSIZE) * PSIZE;
			n2 = ((Anum2+PSIZE-1) / PSIZE) * PSIZE;
			psize = ((n2 - n1) / PSIZE) * PSIZE; 
			if( psize < PSIZE )
				psize = PSIZE;
		}

		sprintf(Top,   "%d",   Min);
		sprintf(End,   "%d",   Max);
		sprintf(Purl1, "%d",   Anum1-1);

		n1 = ((Anum1-1) / psize) * psize;
		n2 = n1 +  psize;
		if( n1 <= 0 ) n1 = 1;
		if( n2 > Max ) n2 = Max;
		sprintf(Purlp,"%d-%d",n1,n2);
		sprintf(Nurl1, "%d",   Anum2+1);

		n1 = ((Anum2+1) / psize) * psize;
		n2 = n1 + psize;
		if( n1 <= 0 ) n1 = 1;
		if( n2 > Max ) n2 = Max;
		sprintf(Nurlp,"%d-%d",n1,n2);
		sprintf(Center,"%d",   Anum1);
	}

	if( Source ){
		putArts(Conn,tc,env);
	}else{
		sprintf(Hbase,"");
		if( Msgid[0] ){
			if( Anum1 != 0 ){
				sprintf(Hbase,"../%s/",Prgroup);
				sprintf(Self,"../%s/%d",Prgroup,Anum1);
			}else	sprintf(Self,"../%s/%s",someGroup(),Msgid);
		}else{
			if( Anum1 == Anum2 )
				sprintf(Self,"%d",Anum1);
			else	sprintf(Self,"%d-%d",Anum1,Anum2);
		}

		if( Anum1 != Anum2 ){
			int npsize,nanum1,nanum2;

			npsize = psize + PSIZE;
			if( (nanum2 = Anum2) < Max ){
				nanum2 = (Anum1 / PSIZE) * PSIZE + npsize;
					if( Max < nanum2 )
					nanum2 = Max;
				nanum1 = Anum1;
			}else
			if( (nanum1 = Anum1) > Min ){
				nanum1 = ((Anum2+PSIZE-1) / PSIZE) * PSIZE - npsize;
				if( nanum1 < Min )
					nanum1 = Min;
				nanum2 = Anum2;
			}
			sprintf(Wide,"%d-%d",nanum1,nanum2);

			npsize = psize - PSIZE;
			if( npsize < PSIZE )
				npsize = PSIZE;
			nanum2 = (Anum1 / PSIZE) * PSIZE + npsize;
			if( Max < nanum2 )
				nanum2 = Max;
			sprintf(Narrow,"%d-%d",Anum1,nanum2);
		}else{
			Wide[0] = 0;
			Narrow[0] = 0;
		}
putBuiltinHTML(Conn,tc,"NNTP/HTTP-Gateway-ARTList","news/artlist.dhtml",NULL,printItem,env);

		if( !PrintMode )
		if( !NoTailer )
			putFrogForDeleGate(Conn,tc,"");
	}

EXIT:
	if( tc_sav != NULL ){
		if( !cached_authOK && NNTP_authERROR(Nsid) )
			putNotAuthorized(Conn,tc_sav,req,0,NULL);
		else{
			fflush(tc);
			fseek(tc,0,0);
			length = file_size(fileno(tc));
			putHttpHeaderV(Conn,tc_sav,vno,NULL,ctype,NULL,length,
				DELEGATE_LastModified,Expires);
			copyfile1(tc,tc_sav);
		}
		fclose(tc);
		tc = tc_sav;
	}

	if( streq(proto,"pop") ){
		NNTP_closeServer(Nsid);
	}else
	/* connection should be held in the Private-MASTER */
	/* but the initialization is heavy ... */
	/* 961125 3.0.59: Now the cost for connection is not so heavy
	 * because the Private-MASTER has become a StickyServer,
	 * initializations are suppressed on reuse...
	 */
	if( ClntKeepAlive && 0 < CKA_RemAlive ){
		/* the connection to the client will be kept-alive,
		 * thus keep alive the connection to the server also.
		 */
	}else
	/*if( MasterIsPrivate || Conn->sv_viaCc )
	 *  This connection will not reused so effectively when this 
	 *  proxy is shared by many clients for many servers.
	 *  Also, unexpected EOF from the server may occur.
	 */
	{
		/* when the connection is not expensive, the connection
		 * should be closed so that it will be reused by others.
		 */
		NNTP_closeServer(Nsid);
	}

	fclose(Tmpfp);
	fclose(tc);
	DUP_ToC = -1;
	return totalc;
}

static NewsEnv *env1;
static phead(group)
	char *group;
{	char url[1024];

	if( mount_url_fromL(url,"nntp",env1->hostport,group,NULL,MyProto,"-.-") )
		return 1;
	return 0;
}

extern char *findFieldValue();
static FILE *permitted_head(head,tc)
	char *head;
	FILE *tc;
{	char *ng,groups[1024];
	int permitted;

	if( env1->mounted )
	if( ng = findFieldValue(head,"Newsgroups") ){
		linescan(ng,groups,sizeof(groups));
		permitted = scan_commaList(groups,0,phead);
		if( !permitted ){
			sv1log("#### Not allowed: %s\n",groups);
			fclose(tc);
			return NULL;
		}
	}
	return tc;
}

static FILE *openArt1(Conn,env)
	Connection *Conn;
	NewsEnv *env;
{	FILE *afp;
	char cpath[1024];

	if( Msgid[0] && Anum == 0 )
		afp = NNTP_openArticle(Nsid,ExpireA,Msgid,GroupHint,0,cpath);
	else	afp = NNTP_openArticle(Nsid,ExpireA,Msgid,Group,Anum,cpath);
	return afp;
}

putArts(Conn,tc,env)
	Connection *Conn;
	FILE *tc;
	NewsEnv *env;
{	char *ep;
	FILE *afp;
	char prevsubj[2048];

	prevsubj[0] = 0;

	Emptyarts[0] = 0;
	ep = Emptyarts;

	set_HEAD_filter(permitted_head);
	env1 = env;

sv1log("putARTICLE(%s,%d-%d) %s/%s\n",Group,Anum1,Anum2,GroupHint,Msgid);

	for( Anum = Anum1; Anum <= Anum2; Anum++ ){
		afp = openArt1(Conn,env);
		if( afp != NULL ){
			if( Source && Anum1 == Anum2 ){
				copy_file(afp,tc,NULL);
			}else{
				fseek(Tmpfp,0,0);
				PGPdecodeMIME(afp,Tmpfp,NULL,0x2FF,0,0);
				Ftruncate(Tmpfp,0,1);
				fseek(Tmpfp,0,0);

putARTICLE(Conn,env,Tmpfp,tc,Anum1==Anum2,prevsubj);

			}
			fclose(afp);
		}else{
			ep = Sprintf(ep,"[%d]",Anum);
			Verbose("No article: %s:%d\n",Group,Anum);
		}
	}
	env1 = NULL;
}

static char *checkng(env,base,group)
	NewsEnv *env;
	char *base,*group;
{	int len;
	char act[2048];
	char *err;
	FILE *lfp;

	lfp = NNTP_openLIST(Nsid,-1,"active");
	if( lfp == NULL )
		return "no active file";

	err = "unknown newsgroup";
	len = strlen(group);

	fseek(lfp,0,0);
	while( fgets(act,sizeof(act),lfp) ){
		if( strncmp(act,group,len) == 0 ){
			if( act[len] == ' ' ){
				err = NULL;
				break;
			}
			if( act[len] == '.' )
				err = "meta newsgroup";
		}
	}

	fclose(lfp);
	return err;

}

newsAdmin(Conn,user,tc,env,group,search)
	Connection *Conn;
	FILE *tc;
	char *user;
	NewsEnv *env;
	char *group,*search;
{
	return httpAdmin(Conn,user,tc,group,search,env,printItem,checkng,AclID);
}
