/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1994 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, modify, and distribute this material for any
purpose and without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies, and
that the name of ETL not be used in advertising or publicity pertaining
to this material without the specific, prior written permission of an
authorized representative of ETL.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	mount.c (mount URL to/from)
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	940806	created
//////////////////////////////////////////////////////////////////////#*/
#include <string.h>
extern char *strcasestr();
#ifndef NULL
#define NULL 0L
#endif

#ifndef Verbose
extern int LOG_VERBOSE;
#define Verbose LOG_VERBOSE==0 ? 0 : sv1vlog
#endif

#ifdef DONT_SORT_MTAB
int DO_MTAB_SORT = 0;
#else
int DO_MTAB_SORT = 1;
#endif

char *getv();
char *Sprintf();
char *gethostaddr();
char *gethostaddr_fromcache();

#define U_MOVED_TO	0x01
#define U_DISPPORT	0x02
#define U_RESOLV	0x04
#define U_INDIRECT	0x08
#define U_USE_PROXY	0x10
#define U_CGI		0x20

#define C_ASPROXY	0x80
#define C_DSTHOST	0x40
#define C_WITHQUERY	0x20

#define C_METHOD	0x10
#define C_CLPATH	0x08
#define C_CLVIA		0x04
#define C_CLFROM	0x02
#define C_CLHOST	0x01
#define C_CLCONDS	0x1F

typedef struct {
	char	*u_src;
	int	 u_fullurl;
	int	 u_remain;
	char	*u_format;
	char	*u_prefix;
	char	*u_proto;
	int	 u_emptysite;
/*
BUG: Both hostname and hostaddr can be list.  cacheing and matching of
host/addr should be done in inets.c.
*/
	char	*u_user;
	char	*u_pass;
	char	*u_hostn;
	char	*u_hosta;
	char	*u_path;
	int	 u_plen;
	int	 u_iport;
	int	 u_stdport;
	int	 u_flags;

	char	*u_ftocl;
} Url;

typedef struct {
	int	 serno;
	int	 compiled;
	int	 u_conds;
	int	 u_conds_value;
	char	*u_conds_param;
	int	 viaList;
	int	 pathList;
	int	 clifList;
	int	 fromList;
	int	 dstList;
	char	*useproxy;
	char	*method;
	char	*opts;
	Url	 Src;
	Url	 Dst;
	int	 to_asis;
	int	 from_asis;
	int	 cond;
	int	 timeout;
	int	 disable;
} Mtab;

Mtab *mtab[128];
static int mtabN;

extern char *strdup();

static last_hit;
mount_disable_lasthit(){
	if( last_hit ){
		mtab[last_hit-1]->disable = 1;
		return last_hit;
	}
	return 0;
}
mount_enable(last){
	if( last )
		mtab[last-1]->disable = 0;
}

Mounted()
{	int mi,mn;

	mn = 0;
	for( mi = 0; mi < mtabN; mi++ )
		if( !mtab[mi]->to_asis )
			mn++;
	return mn;
}
MountedConditional()
{	int mi,mn;
	Mtab *mt;

	mn = 0;
	for( mi = 0; mi < mtabN; mi++ ){
		mt = mtab[mi];
		if( mt->u_conds & C_CLCONDS )
			mn++;
	}
	return mn;
}

scan_MOUNT(Conn,spec)
	char *Conn;
	char *spec;
{	char src[1024],dst[1024],opts[1024];
	char xdst[1024];

	opts[0] = 0;
	if( sscanf(spec,"%s %s %s",src,dst,opts) < 2 )
	{
		sv1log("MOUNT=\"%s\" ? (missing right hand)\n",spec);
		return;
	}
	Verbose("%s\n",spec);
	set_MOUNT(Conn,src,dst,opts);
}

extern char CLIF_HOSTPORT[];
scan_mtabserv(func,arg)
	int (*func)();
	char *arg;
{	Mtab *mt;
	int mi;

	for( mi = 0; mi < mtabN; mi++ ){
		mt = mtab[mi];

		if( evalCond(mt,CLIF_HOSTPORT,NULL,NULL) == 0 )
			continue;

if( mt->Dst.u_hostn )
/* scanned but not compiled, caused by duplicat set of MOUNT list X-< */
		(*func)(arg,
			mt->Src.u_src,
			mt->Dst.u_proto,
			mt->Dst.u_user,
			mt->Dst.u_pass,
			mt->Dst.u_hostn,
			mt->Dst.u_iport,
			mt->Dst.u_path,
			mt->opts);
	}
}
char *getMountSrcByDst(dst)
	char *dst;
{	Mtab *mt;
	int mi;

	for( mi = 0; mi < mtabN; mi++ ){
		mt = mtab[mi];
		if( streq(mt->Dst.u_src,dst) )
			return mt->Src.u_src;
	}
	return NULL;
}

#define INDIRECT_URLEXT "%0/indirect.cfi?_?%1-"

static scanopt(opt,mt)
	char *opt;
	Mtab *mt;
{
	if( strcmp(opt,"cgi") == 0 )
		mt->Dst.u_flags |= U_CGI;
	else
	if( strcmp(opt,"moved") == 0 )
		mt->Dst.u_flags |= U_MOVED_TO;
	else
	if( strncmp(opt,"useproxy",8) == 0 ){
		mt->Dst.u_flags |= U_USE_PROXY;
		if( opt[8] == '=' )
			mt->useproxy = strdup(opt+9);
		else	mt->useproxy = strdup("");
	}else
	if( strcmp(opt,"indirect") == 0 ){
		mt->Dst.u_flags |= U_INDIRECT;
		mt->Dst.u_format = strdup(INDIRECT_URLEXT);
	}else
	if( strcmp(opt,"resolve") == 0 )
		mt->Dst.u_flags |= U_RESOLV;
	else
	if( strncmp(opt,"via=",4) == 0 || strncmp(opt,"src=",4) == 0 ){
		mt->viaList = makePathList("MOUNT.via", opt+4);
		mt->u_conds |= C_CLVIA;
	}else
	if( strncmp(opt,"path=",5) == 0 ){
		mt->pathList = makePathList("MOUNT.path",opt+5);
		mt->u_conds |= C_CLPATH;
	}else
	if( strncmp(opt,"host=",5) == 0 ){
		mt->clifList = makePathList("MOUNT.clif",opt+5);
		mt->u_conds |= C_CLHOST;
	}else
	if( strncmp(opt,"from=",5) == 0 ){
		mt->fromList = makePathList("MOUNT.from",opt+5);
		mt->u_conds |= C_CLFROM;
	}else
	if( strcmp(opt,"asproxy") == 0 ){
		mt->u_conds |= C_ASPROXY;
	}else
	if( strncmp(opt,"dst=",4) == 0 ){
		mt->dstList = makePathList("MOUNT.dst", opt+4);
		mt->u_conds |= C_DSTHOST;
	}else
	if( strncmp(opt,"method=",7) == 0 ){
		mt->method = strdup(opt+7);
		mt->u_conds |= C_METHOD;
	}else
	if( strncmp(opt,"withquery",9) == 0 ){
		mt->u_conds |= C_WITHQUERY;
	}else
	if( strncmp(opt,"ftocl=",6) == 0 ){
		mt->Dst.u_ftocl = strdup(opt+6);
	}else
	if( strncmp(opt,"master=",7) == 0 ){
	}else
	if( strncmp(opt,"proxy=",6) == 0 ){
	}
	return 0;
}


static int init_from;

set_MOUNT(Conn,src,dst,opts)
	char *Conn;
	char *src,*dst,*opts;
{	Mtab *mt;
	int len;
	char dstbuf[1024];

	if( mtab[0] == NULL ){
		mtab[0] = (Mtab*)-1;
		set_MOUNT(Conn,"/-*","=","");
		set_MOUNT(Conn,"/=*","=","");
		if( streq(src,"/-*") && streq(dst,"=") && opts[0]==0 ) return;
		if( streq(src,"/=*") && streq(dst,"=") && opts[0]==0 ) return;
	}

	mt = (Mtab*)calloc(sizeof(Mtab),1);
	if( mt == NULL )
		return;
	mtab[mtabN++] = mt;
	mt->serno = mtabN;
	mt->cond = getCondition(Conn);

	mt->Src.u_src = strdup(src);
	mt->Src.u_fullurl = isFullURL(src);
	len = strlen(src);

	if( mt->Src.u_src[len-1] == '*' ){
		mt->Src.u_src[len-1] = 0;
		mt->Src.u_remain = 1;
		if( 1 < len && mt->Src.u_src[len-2] == ']' ){
			char *dp;
			if( dp = strrchr(mt->Src.u_src,'[') ){
				mt->Src.u_format = strdup(dp);
				*dp = 0;
			}
		}
	}

	if( *dst == '/' ){
		sprintf(dstbuf,"file://%s",dst);
		dst = dstbuf;
	}
	mt->Dst.u_src = strdup(dst);
	len = strlen(dst);
	if( mt->Dst.u_src[len-1] == ']' ){
		char *dp;
		if( dp = strrchr(mt->Dst.u_src,'[') )
		if( mt->Dst.u_src < dp && dp[-1] == '*' ){
			*dp = 0;
			len = strlen(mt->Dst.u_src);
			mt->Dst.u_format = strdup(dp+1);
			*strchr(mt->Dst.u_format,']') = 0;
		}
	}
	if( mt->Dst.u_src[len-1] == '*' ){
		mt->Dst.u_src[len-1] = 0;
		mt->Dst.u_remain = 1;
	}

	mt->opts = strdup(opts);
	scan_commaList(opts,1,scanopt,mt);
}
set_MOUNT_ifndef(Conn,src,dst,opts)
	char *Conn;
	char *src,*dst,*opts;
{	int mi;
	char srcbuf[1024];
	int len,remain;

	strcpy(srcbuf,src);
	len = strlen(src);
	if( srcbuf[len-1] == '*' ){
		srcbuf[len-1] = 0;
		remain = 1;
	}else	remain = 0;

	for( mi = 0; mi < mtabN; mi++ ){
		if( strcmp(mtab[mi]->Src.u_src,srcbuf) == 0 )
		if( strcmp(mtab[mi]->opts,opts) == 0 )
			/* if ``cond'' are different */
			return;
	}
	set_MOUNT(Conn,src,dst,opts);
}

/*
 *  - A rule with a left hand ``Path1*'' should be after the rule with
 *    a left hand ``Path1Path2''.
 *  - In rules of the same left hand ``Path1'' with each other should be
 *    sorted (or overwritten if without any condition) in reverse order
 *    of the definition.
 *
 *  return S1_S2;  s1 should be before than s2
 *  return S2_S1;  s2 should be before than s1
 */

#define S2_S1	 1
#define S1_S2	-1

static mtabcomp(mt1p,mt2p)
	Mtab **mt1p,**mt2p;
{	Mtab *mt1,*mt2;
	char *s1,*s2;
	int r1,r2;
	int comp;

	mt1 = *mt1p; if( mt1 == NULL ) return S2_S1;
	mt2 = *mt2p; if( mt2 == NULL ) return S1_S2;

	s1 = mt1->Src.u_src;
	s2 = mt2->Src.u_src;
	r1 = mt1->Src.u_remain;
	r2 = mt2->Src.u_remain;

	/*if( mt1->to_asis && mt2->to_asis )*/
/*
	if( streq(s1,"=") && streq(s2,"=") )
	{
		s1 = mt1->Dst.u_src;
		s2 = mt2->Dst.u_src;
		r1 = mt1->Dst.u_remain;
		r2 = mt2->Dst.u_remain;
	}
*/

	comp = strcmp(s1,s2);

	if( comp == 0 ){
		if( r1 && !r2 ) return S2_S1;
		if( r2 && !r1 ) return S1_S2;

		/* rule with rexp-prefix first */
		if(  mt1->Src.u_format && !mt2->Src.u_format ) return S1_S2;
		if( !mt1->Src.u_format &&  mt2->Src.u_format ) return S2_S1;

		/* rule with src=xxx first */
		if( mt1->u_conds > mt2->u_conds ) return S1_S2;
		if( mt1->u_conds < mt2->u_conds ) return S2_S1;

		/* reverse entry order for overwriting */
		if( mt1->serno < mt2->serno )
			return S2_S1;
		else	return S1_S2;
	}else{	
		if( strstr(s1,s2) && r2) return S1_S2;
		if( strstr(s2,s1) && r1) return S2_S1;

		/* entry order */
		if( mt1->serno < mt2->serno )
			return S1_S2;
		else	return S2_S1;
	}
}

static sort_mtab()
{
	Bsort(mtab,mtabN,sizeof(Mtab*),mtabcomp);
}
static dump_mtab()
{	int mi;
	Mtab *mt;

	for( mi = 0; mi < mtabN; mi++ ){
		mt = mtab[mi];
		sv1log("MOUNT[%d]%s[%d] %s%s %s%s %s\n",
			mi,
			mi != mt->serno-1 ? "X":"=",
			mt->serno-1,
			mt->Src.u_src,mt->Src.u_remain?"*":"",
			mt->Dst.u_src,mt->Dst.u_remain?"*":"",
			mt->opts);
	}
}

extern char *file_hostpath();
init_mtab(){
	int mi;
	char *ssrc,*dsrc;
	char proto[64],hostport[256],host[256],path[1024],prefix[64];
	char *addr,*dpath;
	char login[256],*dp,user[64],pass[64];
	char loginpath[1024];
	int iport;
	Mtab *mt;
	char *opts;
	char dproto[256];

	if( mtabN <= init_from )
		return;
	mi = init_from;
	init_from = mtabN;

	if( DO_MTAB_SORT )
		sort_mtab();
	dump_mtab();

	for(mi = 0; mi < mtabN; mi++ ){
		mt = mtab[mi];
		if( mt->compiled )
			continue;
		mt->compiled = 1;

		ssrc = mt->Src.u_src;
		if( ssrc[0] == '=' && ssrc[1] == 0 )
			mt->from_asis = 1;

		proto[0] = path[0] = 0;
		dpath = path;
		dsrc = mt->Dst.u_src;

		dproto[0] = 0;
		sscanf(dsrc,"%[^: \t]",dproto);

		if( mt->opts )
			opts = mt->opts;
		else	opts = "";

		if( mt->Dst.u_remain && streq(dsrc+strlen(dproto),"://") ){
			/* the right hand is "scheme://*" */
			strcpy(proto,dproto);
			login[0] = 0;
			dpath = "";
		}else
		if( dsrc[0] == '=' && dsrc[1] == 0 ){
			mt->to_asis = 1;
		/*sv1log("[%d] MOUNT ASIS: %s %s\n",mi,mt->Src.u_src,opts);*/
			continue;
		}else
		if( localPathProto(dproto) ){
			char *upath;
			if( upath = file_hostpath(dsrc,proto,login) ){
				if( login[0] == 0 )
					strcpy(login,"localhost");
				if( upath[0] == '/' )
					strcpy(path,upath+1);
				else
				if( !isFullpath(upath) ){
					getcwd(path,sizeof(path));
					chdir_cwd(path,upath,0);
					strcat(path,"/");
					if( *path == '/' )
						strcpy(path,path+1);
				}
				else	strcpy(path,upath);
				dpath = path;
			}
		}else
		if( strncasecmp(dsrc,"news:",5) == 0 ){
			strcpy(proto,"news");
			strcpy(login,"");
			strcpy(path,dsrc+strlen(proto)+1);
			dpath = path;
		}else
		if( sscanf(dsrc,"%[^:]://%s",proto,loginpath) == 2 ){
			if( loginpath[0] == '/' || loginpath[0] == '?' ){
				mt->Dst.u_emptysite = 1;
				login[0] == 0;
				strcpy(path,loginpath+1);
			}else{
				sscanf(loginpath,"%[^/?]%s",login,path);
				if( path[0] == '/' )
					dpath = path+1;
				else	dpath = path;
			}
		}else{
			Verbose("MOUNT ? %s (right hand should be full-URL)\n",
				mt->Dst.u_src);
			continue;
		}
		if( dp = strrchr(login,'@') ){
			strcpy(hostport,dp+1);
			*dp = 0;
			user[0] = pass[0] = 0;
			sscanf(login,"%[^:]:%s",user,pass);
			mt->Dst.u_user = strdup(user);
			mt->Dst.u_pass = strdup(pass);
		}else	strcpy(hostport,login);

		url_rmprefix(proto,prefix);
		mt->Dst.u_prefix = strdup(prefix);

		if( login[0] ){
			iport = scan_hostport(proto,hostport,host);
			if( addr = gethostaddr(host) )
				mt->Dst.u_hosta = strdup(addr);
			else	addr = "";
			Verbose("MOUNT HOST %s=%s\n",host,addr);
			/* multiple address should be cared ... */
		}else{
			host[0] = 0;
			iport = 0;
			addr = "";
		}

		mt->Dst.u_proto = strdup(proto);
		mt->Dst.u_hostn = strdup(host);
		mt->Dst.u_stdport = serviceport(proto);
		mt->Dst.u_iport = iport;
		if( strchr(hostport,':') )
			mt->Dst.u_flags |= U_DISPPORT;

		mt->Dst.u_path = strdup(dpath);
		mt->Dst.u_plen = strlen(dpath);

		if( login[0] )
			Verbose("[%d] MOUNT=%s %s%s://%s[%s]:%d%s %s\n",
				mi,mt->Src.u_src,prefix,proto,
				host,addr,iport,path,opts);
		else	Verbose("[%d] MOUNT=%s %s%s:%s %s\n",
				mi,mt->Src.u_src,prefix,proto,path,opts);


		if( IsResolvable(host) ){
			sethostcache(host,1);
			sethostcache_predef(host);
			/* preload cache from all of RESOLV=dns,nis,file ... */
		}
	}
}
static char *rewrite_path(out,fmt,in)
	char *out,*fmt,*in;
{	char *op,*fp,fc;
	char urlbuf[4096],*uv[256];
	int un,u1,u2,ui,tailis;

	op = out;
	strcpy(urlbuf,in);
	tailis = strtailchr(urlbuf) == '/';
	un = stoV(urlbuf,256,uv,'/');

	for( fp = fmt; fc = *fp; fp++ ){
		if( fc != '%' ){
			*op++ = fc;
			continue;
		}
		fc = *++fp;
		if( fc == 0 )
			break;

		if( '0' <= fc && fc <= '9' ){
			u1 = fc - '0';
			u2 = u1;
			if( fp[1] == '-' ){
				fp++;
				u2 = un;
			}
			ui = u1;
			if( ui < un ) do {
				if( u1 < ui )
					*op++ = '/';
				strcpy(op,uv[ui]);
				op += strlen(op);
			} while ( ++ui < u2 );
			if( u2 == un && tailis )
				*op++ = '/';
		}
	}
	*op = 0;
	return op;
}

static evalCond1(mt,clif,method,origurl)
	Mtab *mt;
	char *clif;
	char *method;
	char *origurl;
{
	if( mt->fromList && !matchFROM(mt->fromList,NULL) )
		return 0;

	if( mt->clifList && clif != NULL ){
		char host[256];
		int port;

		port = scan_hostport1(clif,host);
		if( !matchPath1(mt->clifList,"-",host,port) )
			return 0;
	}

	if( mt->dstList && origurl != NULL ){
		char proto[256],host[256],port[256];
		int porti;

		if( scan_protositeport(origurl,proto,host,port) ){
			if( *port == 0 )
				porti = serviceport(proto);
			else	porti = atoi(port);
			if( !matchPath1(mt->dstList,"-",host,porti) )
				return 0;
		}
	}

	if( mt->method && method != NULL ){
		/*sv1log("### MOUNT METHOD [%s][%s]\n",mt->method,method);*/
		if( strcmp(mt->method,"*") != 0 )
		if( strcasestr(mt->method,method) == NULL )
			return 0;
	}

	if( mt->pathList && !matchPATHs(mt->pathList,NULL) )
		return 0;

	if( mt->viaList && !matchPATH1(mt->viaList,NULL,"-") )
		return 0;

	if( mt->cond && evalCondition(mt->cond) == 0 )
		return 0;

	return 1;
}
static evalCond(mt,clif,method,origurl)
	Mtab *mt;
	char *clif;
	char *method;
	char *origurl;
{	int value;
	char param[1024];

	param[0] = 0;
	if( clif ) strcat(param,clif);
	/*
	if( method ){ strcat(param," "); strcat(param,method); }
	if( origurl ){ strcat(param," "); strcat(param,origurl); }
	*/

	if( mt->u_conds_value )
	if( strcmp(param,mt->u_conds_param) == 0 )
		return 0 < mt->u_conds_value ? 1 : 0;
		/* should check if input parameters (clif,method,origurl)
		 * is identical with the previous evaluation...
		 */

	value = evalCond1(mt,clif,method,origurl);
	if( clif ){
		if( value )
			mt->u_conds_value = 1;
		else	mt->u_conds_value = -1;
		Strdup(&mt->u_conds_param,param);
	}
	return value;
}
reset_MOUNTconds()
{	int mi;

	for( mi = 0; mi < mtabN; mi++ )
		mtab[mi]->u_conds_value = 0;
}

evalMountCond(opts,user,chost,cport,ihost,iport)
	char *opts,*user,*chost,*ihost;
{	int List;
	int match = 0;
	char path[1024];

	sprintf(path,"%s:%d!%s:%d",ihost,iport,chost,cport);

	if( strncmp(opts,"from=",5) == 0 ){
		List = makePathList("SERVER.from",opts+5);
		match = matchPath1(List,user,chost,cport);
	}else
	if( strncmp(opts,"host=",5) == 0 ){
		List = makePathList("SERVER.clif",opts+5);
		match = matchPath1(List,user,ihost,iport);
	}else
	if( strncmp(opts,"path=",5) == 0 ){
		List = makePathList("SERVER.path",opts+5);
		match = matchPATHs(List,path);
	}else{
		if( strncmp(opts,"via=",4)==0 || strncmp(opts,"src=",4)==0 )
			opts += 4;
		List = makePathList("SERVER.via",opts);
		match = matchPATH1(List,path,user);
	}
	return match;
}

static char *mount_url_toX(myhostport,method,url,moved,rmt)
	char *myhostport;
	char *method,*url;
	Mtab **rmt;
{	char *up,iurl[16*1024],*rp,src_rest[1024];
	int ai;
	char *src,*addr,nch;
	int len;
	Mtab *mt;
	int delput;

	strcpy(iurl,url);
	if( rp = strpbrk(iurl," \t\r\n") ){
		strcpy(src_rest,rp);
		*rp = 0;
	}else	src_rest[0] = 0;

	for( ai = 0; ai < mtabN; ai++ ){
		mt = mtab[ai];

		if( mt->from_asis || mt->disable )
			continue;

		src = mt->Src.u_src;
		nch = src[strlen(src)];

		if( (len = url_strstr(iurl,src)) || src[0] == 0 )
		if(  mt->Src.u_remain 
|| !mt->Src.u_remain && nch==0 && iurl[len]==0 /* exact match */
		 || !mt->Src.u_remain && strchr(" \t\n\r",nch)==0 /* ??? */
		){
			if( evalCond(mt,myhostport,method,iurl) == 0 )
				continue;

			if( mt->Src.u_format )
				if( !RexpMatch(&iurl[len],mt->Src.u_format) )
					continue;

			if( mt->u_conds & C_WITHQUERY )
			if( strchr(url,'?') == NULL )
				continue;

			if( mt->u_conds & C_ASPROXY )
			if( !isFullURL(iurl) )
				continue;

			if( mt->to_asis ){
				Verbose("[%d] MOUNT ASIS: %s\n",ai,mt->Src.u_src);
				if( mt->opts && mt->opts[0] )
					goto FOUND;
				break;
			}
			if((mt->Dst.u_flags & U_RESOLV) && mt->Dst.u_hosta)
				addr = mt->Dst.u_hosta;
			else	addr = mt->Dst.u_hostn;

			up = Sprintf(url,"%s",mt->Dst.u_prefix);
			up = Sprintf(up,"%s:",mt->Dst.u_proto);

			if( addr[0] ){ 
				up = Sprintf(up,"//");
				if( mt->Dst.u_user || mt->Dst.u_pass ){
					if( mt->Dst.u_user )
					up = Sprintf(up,"%s",mt->Dst.u_user);
					if( mt->Dst.u_pass )
					up = Sprintf(up,":%s",mt->Dst.u_pass);
					up = Sprintf(up,"@");
				}
				up = Sprintf(up,"%s",addr);
				if( mt->Dst.u_flags & U_DISPPORT )
				up = Sprintf(up,":%d",mt->Dst.u_iport);
				delput = 0;
			}else
			if( mt->Dst.u_emptysite ){
				up = Sprintf(up,"//");
				delput = 0;
			}else	delput = 1;

			if( mt->Dst.u_path ){
				if( !delput ){
					up = Sprintf(up,"/");
					delput = 1;
				}
				up = Sprintf(up,"%s",mt->Dst.u_path);
				delput = 1;
			}

			if( iurl[len] )
			if( mt->Dst.u_remain ){
				if( !delput ){
					up = Sprintf(up,"/");
					delput = 1;
				}
				if( mt->Dst.u_format )
					up = rewrite_path(up,mt->Dst.u_format,iurl+len);
				else	up = Sprintf(up,"%s",iurl+len);
			}

			Verbose("*** %s MOUNTED TO[%d] %s ***\n",
				mt->Src.u_src,ai,mt->Dst.u_src);
			sv1log("*** %s => %s ***\n",iurl,url);

			if( src_rest[0] )/* not a part of the URL */
				up = Sprintf(up,"%s",src_rest);
			last_hit = ai+1;
			goto FOUND;
		}
	}
	return 0;

FOUND:
	/*
	 * MOVED_TO and USE_PROXY are not matching conditions about URL
	 * but the interpretations of the rule when the URL is matched.
	 * So they are here.
	 */
	if( moved & U_MOVED_TO ){
		if((mt->Dst.u_flags & U_MOVED_TO) == 0)
			return 0;
	}else
	if( moved & U_USE_PROXY ){
		if((mt->Dst.u_flags & U_USE_PROXY) == 0)
			return 0;
	}else{
		if( mt->Dst.u_flags & (U_MOVED_TO|U_USE_PROXY) )
			return 0;
	}
	if( rmt ) *rmt = mt;
	return mt->opts;
}

static char *mount_url_to1(myhostport,method,url,moved)
	char *myhostport;
	char *method,*url;
{
	return mount_url_toX(myhostport,method,url,moved,NULL);
}

char *mount_url_to(method,url)
	char *method,*url;
{
	return mount_url_to1(NULL,method,url,0);
}
char *moved_url_to(myhostport,method,url)
	char *myhostport,*method,*url;
{
	return mount_url_to1(myhostport,method,url,U_MOVED_TO);
}
char *changeproxy_url_to(myhostport,method,url,proxy)
	char *myhostport,*method,*url,*proxy;
{	Mtab *mt;
	char *opt;

	*proxy = 0;
	if( opt = mount_url_toX(myhostport,method,url,U_USE_PROXY,&mt) )
	if( mt->useproxy )
		strcpy(proxy,mt->useproxy);
	return opt;
}
char *mount_url_to0(myhostport,method,url)
	char *myhostport,*method,*url;
{
	return mount_url_to1(myhostport,method,url,0);
}

static hostMatch(host,ahostn,ahosta)
	char *host,*ahostn,*ahosta;
{	char *hosta;

	if( streq(host,ahostn) || ahosta && streq(host,ahosta) ) 
		return 1;

	if( ahosta )
	if( hosta = gethostaddr_fromcache(host) )
		if( streq(hosta,ahosta) )
			return 1;

	/* when the host have several addresses ...
	   `matchhostaddr_incache(host,ahosta)' is necessary ?
	 */
	return 0;
}

static int mount_debug = 0;

char *mount_url_fromL(url,proto,hostport,path,search,dproto,delegate)
	char *url,*proto,*hostport,*path,*search,*dproto,*delegate;
{	char *up,*dp1,*dp2,dhost[128];
	int ai;
	int plen;
	Mtab *mt;
	char host[128];
	int iport;

	up = url;

	if( proto == 0 || hostport == 0 )
		return 0;
	if( path == 0 )
		path = "";

	if( dproto == 0 || dproto[0] == 0 )
		dproto = "http";

	if( hostport[0] == 0 ){
		host[0] = 0;
		iport = 0;
	}else	iport = scan_hostport(proto,hostport,host);

	for( ai = 0; ai < mtabN; ai++ ){
		mt = mtab[ai];
		if( mt->to_asis || mt->disable )
			continue;

		plen = mt->Dst.u_plen;

if( mount_debug ){
printf("########### [%d] %s:%d/%s ? [%s:%d/%s[%d] => %s]\n",
ai, host, iport, path,
mt->Dst.u_hostn, mt->Dst.u_iport, mt->Dst.u_path, plen, mt->Src.u_src);
}

	 	if( mt->Dst.u_iport == iport || mt->Dst.u_iport==0 )
		if( hostMatch(host,mt->Dst.u_hostn,mt->Dst.u_hosta) || mt->Dst.u_hostn[0]==0 )
		if( plen == 0 || strncmp(path,mt->Dst.u_path,plen) == 0 )
		{
			if( evalCond(mt,delegate,NULL,NULL) == 0 )
				continue;

			if( !mt->Dst.u_remain && path[plen] != 0 )
				continue;

			if( mt->from_asis )
				break;

			Verbose("** %s UNMOUNTED FROM %s **\n",
				mt->Src.u_src,mt->Dst.u_src);

			if( dp1 = strchr(delegate,':') ){
				if( atoi(dp1+1) == serviceport(dproto) ){
					strcpy(dhost,delegate);
					dp1 = strchr(dhost,':');
					if( dp2 = strchr(dp1,'/') )
						strcpy(dp1,dp2);
					else	*dp1 = 0;
					delegate = dhost;
				}
			}

/* src protocol should be recovered */
/* proto = "http"; */
proto = dproto;
			if( !mt->Src.u_fullurl )
				up = Sprintf(up,"%s://%s",proto,delegate);
			up = Sprintf(up,mt->Src.u_src);

/*
if( mt->Dst.u_hostn[0] == 0 ) up = Sprintf(up,"//%s",host);
*/

			/* the path after the mount point (which is
			 * mounted on the root of destination) should be
			 * delimited with '/' from the reference point ???.
			 * if( up[-1] != '/' && mt->Dst.u_path[0] == 0 )
			 *	*up++ = '/';
			 */

/*
up = Sprintf(up,"%s",mt->Src.u_src);
is insufficient for rewriting "302 Found" response.
*/

			if( streq(proto,"gopher") ){
				if( up[-1] == '/' )
					up = Sprintf(up,"1");
				else	up = Sprintf(up,"/1");
			}

			if( plen )
				path += plen;

/*
if( up[-1]  == '/' ) *--up = 0;
if( path[0] == '/' ) path = path + 1;
up = Sprintf(up,"/%s",path);
*/
up = Sprintf(up,"%s",path);

			if( search )
				up = Sprintf(up,"?%s",search);
			last_hit = ai+1;
			return mt->opts;
		}
	}
	return 0;
}
char *mount_url_from(url,av)
	char *url;
	char *av[];
{	char *proto,*hostport,*path,*search,*dproto,*delegate;

	proto = getv(av,"proto");
	hostport = getv(av,"hostport");
	if( hostport == (char*)0 )
		hostport = getv(av,"host");
	path = getv(av,"path");
	search = getv(av,"search");
	delegate = getv(av,"delegate");
	if( delegate == (char*)0 )
		return 0;
	dproto = getv(av,"dproto");

	return mount_url_fromL(url,proto,hostport,path,search,dproto,delegate);
}


mount_selector_from(selector,host,port,gtype)
	char *selector,*host;
{	int ai;
	char tselector[1024];
	Mtab *mt;

/*
	for( ai = 0; ai < mtabN; ai++ ){
	    mt = mtab[ai];
	    if( streq(host,mt->dst) ){
		strcpy(tselector,selector);
		sprintf(selector,"%s/%s",mt->src,tselector);
		Verbose("*** MOUNT FROM ***\n%s\n%s\n",tselector,selector);
		return 1;
	    }
	}
*/
	return 0;
}


trans_url(nurl,ourl,fmt)
	char *nurl,*ourl,*fmt;
{
	strcpy(nurl,fmt);
	sv1log("Transform-URL: %s -> %s\n",ourl,nurl);
}
