/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1994 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, modify, and distribute this material for any
purpose and without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies, and
that the name of ETL not be used in advertising or publicity pertaining
to this material without the specific, prior written permission of an
authorized representative of ETL.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	misc.c (miscellaneous functions)
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	March94	creatd
//////////////////////////////////////////////////////////////////////#*/
#include <stdio.h>
#include <string.h>

extern char *strdup();

fcloseFILE(fp)
	FILE *fp;
{	int fd,fdsav;

	fd = fileno(fp);
	fdsav = dup(fd);
	fclose(fp);
	dup2(fdsav,fd);
	close(fdsav);
	return fd;
}

copy_file(sfp,dfp,cfp)
	FILE *sfp,*dfp,*cfp;
{	int rcc;
	char buff[1023];
	int totalc;

	totalc = 0;
	for(;;){
		rcc = fread(buff,1,sizeof(buff),sfp);
		if( rcc == 0 )
			break;
		totalc += rcc;
		if( cfp ){ if(fwrite(buff,1,rcc,cfp)==0) break; }
		if( dfp ){ if(fwrite(buff,1,rcc,dfp)==0) break; }
		if( dfp && ready_cc(sfp) == 0 )
			if( fflushTIMEOUT(dfp) == EOF )
				break;
	}
	if( dfp ) fflush(dfp);
	if( cfp ) fflush(cfp);
	return totalc;
}
copy_fileTIMEOUT(sfp,dfp,cfp)
	FILE *sfp,*dfp,*cfp;
{	int rcc;
	char buff[1024];
	int totalc;

	totalc = 0;
	for(;;){
		if( feof(sfp) )
			break;
		rcc = freadTIMEOUT(buff,1,sizeof(buff),sfp);
		if( rcc == 0 )
			break;
		totalc += rcc;
		if( dfp ){ if(fwriteTIMEOUT(buff,1,rcc,dfp)==0) break; }
		if( dfp ){ if(fflushTIMEOUT(dfp) == EOF) break; }
		if( cfp ){ if(fwriteTIMEOUT(buff,1,rcc,cfp)==0) break; }
	}
	if( dfp ) fflushTIMEOUT(dfp);
	if( cfp ) fflushTIMEOUT(cfp);
	return totalc;
}

ftouch(fp,time)
	FILE *fp;
{	int off;

	off = ftell(fp);
	fseek(fp,0,2);
	fwrite("",1,1,fp);
	fflush(fp);
	fseek(fp,-1,2);
	Ftruncate(fp,0,1);
	fseek(fp,off,0);
}
File_touch(path,clock)
	char *path;
{	FILE *fp;

	if( fp = fopen(path,"a") ){
		ftouch(fp,clock);
		fclose(fp);
	}
}

Fprintf(fp,fmt,a,b,c,d,e,f,g,h,i,j,k,l,m,n)
	FILE *fp;
	char *fmt,*a,*b,*c,*d,*e,*f,*g,*h,*i,*j,*k,*l,*m,*n;
{	char buf[0x10000];

	sprintf(buf,fmt,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
	fputs(buf,fp);
	return strlen(buf);
}

char *Fgets(str,size,fp)
	char *str;
	FILE *fp;
{	char *rstr;
	char *dp;

	rstr = fgets(str,size,fp);
	if( rstr != NULL )
		if( dp = strpbrk(str,"\r\n") )
			*dp = 0;
	return rstr;
}

Fputs(str,fp)
	char *str;
	FILE *fp;
{	char *dp;
	int rcode;

	/* signal(SIGPIPE,... */

	if( strchr(str,'\r') == 0 ){
		if( dp = strchr(str,'\n') )
			strcpy(dp,"\r\n");
		else	strcat(str,"\r\n");
	}

	rcode = fputs(str,fp);
	fflush(fp);
	return rcode;
}

Write(fd,buf,len)
	char *buf;
{	int nw,wcc,wc1;

	nw = 0;
	for(wcc = 0; wcc < len; wcc += wc1 ){
		nw++;
		wc1 = write(fd,buf+wcc,len-wcc);
		if( wc1 <= 0 )
			break;
	}
	return wcc;
}
Fwrite(buf,esize,ecount,fp)
	char *buf;
	FILE *fp;
{	int re,we;

	re = ecount;
	do {
		we = fwrite(buf,esize,re,fp);
		if( we != re )
			sv1log("Fwrite: partial (%d/%d/%d) NBIO=%d\n",
				we,re,ecount,getNonblockingIO(fileno(fp)));

		if( we <= 0 )
			break;
		else	re -= we;
	} while( 0 < re );
	return ecount - re;
}

Exit(code,fmt,a,b,c,d,e,f,g)
	char *fmt,*a,*b,*c,*d,*e,*f,*g;
{	char msg[2048];

	if( code != 0 ){
		sprintf(msg,"Exit (%d) ",code);
		sprintf(msg+strlen(msg),fmt,a,b,c,d,e,f,g);
		sv1log("%s",msg);
	}
	Finish(code);
}

int MyPID;
Getpid(){
	if( MyPID == 0 )
		MyPID = getpid();
	return MyPID;
}
Fork(what)
	char *what;
{	register int pid;

	endhostent();
	MyPID = 0;
	pid = fork();
	if( pid == 0 ){
		MyPID = getpid();
		sv1log("-- Fork(%s): %d -> %d\n",what,getppid(),MyPID);
	}
	return pid;
}

extern int WAIT_WNOHANG;
NoHangWait()
{
	return wait3(NULL,WAIT_WNOHANG,NULL);
}

extern int errno;
extern char *getusernames();
Execvp(where,path,av)
	char *where,*path,*av[];
{	int rcode;
	char pwd[1024];
	char names[1024];
	char *nav[2];

	BeforeExec();
	endhostent();
	if( av[0] == NULL ){
		nav[0] = nav[1] = NULL;
		av = nav;
	}
	rcode = execvp(path,av);

	fprintf(stderr,"%s: Could not execute COMMAND: %s\n",where,path);
	fprintf(stderr," with the OWNER uid/gid: %s\n",getusernames(names));
	fprintf(stderr," at the DIR: %s\n",getcwd(pwd,sizeof(pwd)));
	fprintf(stderr,"You should check that you can execute the COMMAND\n");
	fprintf(stderr," at the DIR with the access right of the OWNER.\n");
	perror("proc_title_init");
	Exit(-1,"%s(%s) failed(%d) errno=%d\n",where,path,rcode,errno);
}
Kill(pid,sig)
{
	sv1log("Kill(%d,%d)\n",pid,sig);
	if( pid == 0 || pid == 1 || pid == -1 ){
		sv1log("Error: tried to Kill %d X-<\n",pid);
		return -1;
	}
	return kill(pid,sig);
}
Killpg(pgrp,sig)
{
	sv1log("Killpg(%d,%d)\n",pgrp,sig);
	if( pgrp == 0 || pgrp == 1 ){
		sv1log("Error: tried to Killpg %d X-<\n",pgrp);
		return -1;
	}
	return killpg(pgrp,sig);
}

static cmpstr(s1p,s2p)
	char **s1p,**s2p;
{
	return strcmp(*s1p,*s2p);
}
static cmpstr_reverse(s1p,s2p)
	char **s1p,**s2p;
{
	return strcmp(*s2p,*s1p);
}

extern FILE *TMPFILE();
sort_file(src,dst,rev)
	FILE *src,*dst;
{	FILE *tmp;
	char line[4096];
	char *lines[0x10000];
	int nlines,li;

	if( src == dst )
		tmp = dst = TMPFILE("SORT");
	else	tmp = NULL;

	fseek(src,0,0);
	for( nlines = 0; fgets(line,sizeof(line),src); nlines++ )
		lines[nlines] = strdup(line);

	if( rev )
		qsort(lines,nlines,sizeof(char*),cmpstr_reverse);
	else	qsort(lines,nlines,sizeof(char*),cmpstr);

	fseek(dst,0,0);
	for( li = 0; li < nlines; li++ ){
		fputs(lines[li],dst);
		free(lines[li]);
	}
	fflush(dst);

	if( tmp != NULL ){
		fseek(src,0,0);
		fseek(tmp,0,0);
		copy_file(tmp,src,NULL);
		fclose(tmp);
		fflush(src);
	}
}

msleep(msec){
	int sec,usec;

	if( msec < 1000 ){
		Usleep(msec*1024);
		return;
	}

	if( sec = msec / 1000 )
		sleep(sec);

	if( usec = (msec % 1000)*1000 )
		Usleep(usec);
}


extern int SPAWN_P_NOWAIT;
Spawnvp(what,path,av)
	char *what,*path,*av[];
{	int pid;

	MyPID = 0;
	pid = spawnvp(SPAWN_P_NOWAIT,path,av);
	return pid;
}

char *Sprintf(s,fmt,a,b,c,d,e,f,g,h,i,j,k,l,m,n)
	char *s;
	char *fmt,*a,*b,*c,*d,*e,*f,*g,*h,*i,*j,*k,*l,*m,*n;
{
	if( fmt[0]=='%' && fmt[1]=='s' && fmt[2]==0 ){
		while( *s = *a++ ){ s++; }
		return s;
	}else{
		sprintf(s,fmt,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
		return s+strlen(s);
	}
}
