/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1994-1998 Electrotechnical Laboratry (ETL), AIST, MITI
Copyright (c) 1994-1998 Yutaka Sato

Permission to use, copy, modify, and distribute this material for any
purpose and without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	access.c (Access Control)
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	March94	created
	941002	merged proxy.c(created 940316)
//////////////////////////////////////////////////////////////////////#*/
#include "hostlist.h"
#include "delegate.h"

extern char *getClientUserC();
#define Ident()	getClientUserC(Conn)

/*
 *	Master DeleGate servers
 */
extern addHostList1();
extern char *stralloc();
extern char **dupv();

typedef struct {
	char	 *p_name;
	int	  p_portN;
	int	 *p_portV;
	int	  p_negate;
	char	 *p_methods;
} ProtoList;

typedef struct {
	char	 *m_proto;
	char	 *m_host;
	int	  m_port;
	char	 *m_path;
	char	 *m_conn;
	ProtoList *m_protoV;
	HostList  m_dsts; /* should be URLs ? */
	HostList  m_srcs;
	int	  m_teleport;
	int	  m_cacheonly;
	char	 *m_owner;
	char	 *m_Version;
	char	 *m_SERVER;
} Route;

static Route MASTER_delegated[16];

static int MapX;
static Route *Maps[128];
static int ForwardX;
static Route *Forwards[32];
static int PermitX;
static Route *Permits[128];
static int ConnectX;
static Route *Connects[32];
static int OwnerX;
static Route *Owners[128];

static ProtoList *PermitG;

static scanProtoPort(protoport,proto,ports,methods)
	char *protoport,*proto,*ports,*methods;
{	char buf[1024],*pv[4];
	int ne;

	strcpy(buf,protoport);
	if( strchr(buf,':') )
		ne = stoV(buf,3,pv,':');
	else	ne = stoV(buf,3,pv,'/');
	proto[0] = ports[0] = methods[0] = 0;
	if( 1 <= ne ) strcpy(proto,pv[0]);
	if( 2 <= ne ) strcpy(ports,pv[1]);
	if( 3 <= ne ) strcpy(methods,pv[2]);
	return ne;
}
static ProtoList *makeProtoV(protov)
	char **protov;
{	ProtoList *protoV;
	int ni,np,nj,nn;
	char proto[64],ports[1024];
	char methods[512];
	char *portv[64];

	for( np = 0; protov[np]; np++);
	protoV = (ProtoList*)calloc(sizeof(ProtoList),np+1);

	for( ni = 0; ni < np; ni++ ){
		scanProtoPort(protov[ni],proto,ports,methods);
		protoV[ni].p_name = strdup(proto);
		if( ports[0] && strcmp(ports,"*") != 0 ){
			if( ports[0] == '{' )
				strcpy(ports,ports+1);
			nn = stoV(ports,64,portv,',');
			protoV[ni].p_portN = nn;
			protoV[ni].p_portV = (int *)calloc(sizeof(int*),nn);
			for( nj = 0; nj < nn; nj++ )
				protoV[ni].p_portV[nj] = atoi(portv[nj]);
		}
		if( methods[0] )
			protoV[ni].p_methods = strdup(methods);
	}
	return protoV;
}
static freeProtoV(protoV)
	ProtoList *protoV;
{	int ni;

	for( ni = 0; protoV[ni].p_name; ni++ ){
		free(protoV[ni].p_name);
		free(protoV[ni].p_portV);
	}
	free(protoV);
}
static sprintProtoV(protoV,protolist)
	ProtoList *protoV;
	char *protolist;
{	int ni,nj,np;
	char *proto1,*pp;
	char *mp;

	*protolist = 0;
	if( protoV == 0 )
		return;

	pp = protolist;
	*pp = 0;
	for( ni = 0; proto1 = protoV[ni].p_name; ni++ ){
		if( 0 < ni )
			*pp++ = ',';

		strcpy(pp,proto1);
		pp += strlen(pp);

		if( np = protoV[ni].p_portN ){
			*pp++ = '/';
			if( 1 < np )
				*pp++ = '{';

			for( nj = 0; nj < protoV[ni].p_portN; nj++ ){
				if( 0 < nj )
					*pp++ = ',';
				sprintf(pp,"%d",protoV[ni].p_portV[nj]);
				pp += strlen(pp);
			}
			if( 1 < np )
				*pp++ = '}';
			*pp = 0;
		}
		if( mp = protoV[ni].p_methods ){
			if( np == 0 ){
				*pp++ = '/';
				*pp++ = '*';
			}
			*pp++ = '/';
			strcpy(pp,mp);
			pp += strlen(pp);
		}
	}
}
static char *srcProto;
static addProto1(protoport,tv,pv,portp)
	char *protoport;
	char *tv[],*pv[];
	char **portp;
{	int pi,ti,px,match0,match;
	char proto[64],ports[256],protoportb[256];
	char methods[512];
	char *proto1,ports1[256];
	int len;

	scanProtoPort(protoport,proto,ports,methods);

	if( proto[0] == '!' || proto[0] == '-' ){
		px = 0;
		match0 = 0;
		if( strcmp(proto+1,"*") == 0 || strcmp(proto+1,"all") == 0 )
			match0 = 1;
		len = strlen(proto+1);
		for( pi = 0; proto1 = pv[pi]; pi++ ){
			match = match0;
			if( strncmp(proto+1,proto1,len) == 0 ){
				if( proto1[len] == 0 )
					match = 1;
				else
				if( proto1[len] == '/' ){
					subSetList(&proto1[len+1],ports,ports1);
					if( *ports1 == 0 )
						match = 1;
					else{
						strcpy(*portp,proto1);
						proto1 = *portp;
						strcpy(&proto1[len+1],ports1);
						*portp += strlen(proto1) + 1;
					}
				}
			}
			if( match )
				continue;
			pv[px++] = proto1;
		}
		pv[px] = 0;
		return 0;
	}

	if( strcmp(proto,".") == 0 )
		strcpy(proto,srcProto);

	if( strcmp(proto,"*") == 0 || strcmp(proto,"all") == 0 ){
		px = 0;
		for( ti = 0; tv[ti]; ti++ )
			if( 0 <= serviceport(tv[ti]) ) /* not VPROTO */
				pv[px++] = tv[ti];
		pv[px] = 0;
		return 0;
	}else{
		match = 0;
		for( ti = 0; tv[ti]; ti++ )
			if( match = (strcasecmp(proto,tv[ti])==0) )
				break;

		if( match ){
			for( pi = 0; pv[pi]; pi++);
			pv[pi+1] = 0;

			pv[pi] = *portp;
			strcpy(*portp,proto);
			*portp += strlen(*portp);
			if( ports[0] == 0 && methods[0] )
				strcpy(ports,"*");
			if( ports[0] ){
				sprintf(*portp,"/%s",ports);
				*portp += strlen(*portp);
			}
			if( methods[0] ){
				sprintf(*portp,"/%s",methods);
				*portp += strlen(*portp);
			}
			*portp += 1;
			return 0;
		}
	}
	sv1log("ERROR protocol inhibited: %s\n",proto);
	return 0;
}
static int portMatch(protoV,port)
	ProtoList *protoV;
{	int ni;

	if( protoV->p_portV == NULL )
		return 1;

	for( ni = 0; ni < protoV->p_portN; ni++ )
		if( protoV->p_portV[ni] == port )
			return 1;
	return 0;
}
static ProtoList *protoMatch1(protoV,proto,port)
	ProtoList *protoV;
	char *proto;
{	int px;
	char *aproto;

	for( px = 0; aproto = protoV[px].p_name; px++ ){
		if( strcasecmp(proto,aproto)==0 )
			if( portMatch(&protoV[px],port) )
				return &protoV[px];
	}
	return NULL;
}
static protoMatch2(protoV,proto)
	ProtoList *protoV;
	char *proto;
{	int px;
	char *aproto;

	if( protoV == NULL )
		return 1;

	for( px = 0; aproto = protoV[px].p_name; px++ ){
		if( *proto=='*' || *aproto=='*' || strcasecmp(proto,aproto)==0 )
			return 1;
	}
	return 0;
}
static protoMatch3(protoV,proto)
	ProtoList *protoV;
	char *proto;
{	int px;
	char *aproto;

	for( px = 0; aproto = protoV[px].p_name; px++ ){
		if( *proto=='*' || *aproto=='*' || strcasecmp(proto,aproto)==0 )
			return 1;
	}
	return 0;
}
static int methodMatch(protoV,method)
	ProtoList *protoV;
	char *method;
{	char *methods = protoV->p_methods;

	if( methods == NULL || *methods == 0 || strcmp(methods,"*") == 0 )
		return 1;
	if( method  == NULL || *method  == 0 || strcmp(method, "*") == 0 )
		return 1;
	if( strstr(methods,method) )
		return 1;
	return 0;
}

static Route *addRoute1(what,tab,idx,proto,host,port,path,conn,protov,dstlist,srclist)
	char *what;
	Route *tab[];
	char *proto,*host,*path;
	char *conn;
	char **protov,*dstlist,*srclist;
{	Route *Rp;
	char tabid[64];
	char protolist[1024];

	Rp = tab[idx] = (Route*)calloc(sizeof(Route),1);
	Rp->m_proto = stralloc(proto);
	Rp->m_host = stralloc(host);
	Rp->m_port = port;
	Rp->m_path = stralloc(path);
	Rp->m_conn = stralloc(conn);

	sprintf(tabid,"%s/DST",what);
	Rp->m_dsts.hl_what = stralloc(tabid);
	Rp->m_dsts.hl_noIdent = 1;
/* Rp->m_dsts.hl_list = &filterHosts[HostsX]; */
	scan_commaListL(dstlist,STR_ALLOC,addHostList1,&Rp->m_dsts);
/* HostsX += Rp->m_dsts.hl_cnt; */

	sprintf(tabid,"%s/SRC",what);
	Rp->m_srcs.hl_what = stralloc(tabid);
/* Rp->m_srcs.hl_list = &filterHosts[HostsX]; */
	scan_commaListL(srclist,STR_ALLOC,addHostList1,&Rp->m_srcs);
/* HostsX += Rp->m_srcs.hl_cnt; */

	if( protov != NULL ){
		protolist[0] = 0;
		Rp->m_protoV = makeProtoV(protov);
		sprintProtoV(Rp->m_protoV,protolist);
		Verbose("[%d] %s={%s}%s{%s}:{%s}:{%s}\n",
			idx,what,path,host,protolist,dstlist,srclist);
	}else	Verbose("[%d] %s=%s://%s:%d%s-_-{%s}:{%s}\n",
			idx,what,proto,host,port,path,dstlist,srclist);
	return Rp;
}


/*
 *	CMAP=output:mapname:protoList:dstHostList:srcHostList
 */
#define M_OUT	0
#define M_NAME	1
#define M_PROTO	2
#define M_DSTH	3
#define M_SRCH	4

static scanmap1(map1,mapv,mapc)
	char *map1;
	char *mapv[];
	int *mapc;
{
	mapv[*mapc] = map1;
	*mapc = *mapc + 1;
	return 0;
}
scan_CMAP(Conn,map)
	Connection *Conn;
	char *map;
{
	scan_CMAPX(Conn,map,0,0);
}
scan_CMAP2(Conn,name,map)
	Connection *Conn;
	char *name,*map;
{	char cmap[1024];

	sprintf(cmap,"%s:%s",name,map);
	scan_CMAPX(Conn,cmap,1,1);
}
scan_CMAPX(Conn,map,reverse,defaultOK)
	Connection *Conn;
	char *map;
{	char mapb[1024],*mapv[8],*map1;
	int mapc,mapi;
	char protoV[32];
	int outx,namex;

	strcpy(mapb,map);
	for( mapi = 0; mapi < 8; mapi++ )
		mapv[mapi] = "";

	mapc = 0;
	scan_ListL(mapb,':',STR_ALLOC,scanmap1,mapv,&mapc);

	if( defaultOK )
	for( mapi = 0; mapi < 8; mapi++ )
		if( mapv[mapi][0] == 0 )
			mapv[mapi] = "*";

	protoV[0] = 0;
	stoV(mapv[M_PROTO],32,protoV,',');

	for( mapi = 0; mapi < mapc; mapi++ ){
		map1 = mapv[mapi];
		if( map1[0] == '{' && strtailchr(map1) == '}' ){
			strcpy(map1,map1+1);
			map1[strlen(map1)-1] = 0;
		}
	}

	if( reverse ){
		namex = M_OUT;
		outx = M_NAME;
	}else{
		namex = M_NAME;
		outx = M_OUT;
	}
	addRoute1("CMAP",Maps,MapX++,
		"CMAP",mapv[namex],0,mapv[outx],"-",
		protoV, mapv[M_DSTH], mapv[M_SRCH]);
}
find_CMAPX(map,str,proto,dhost,dport,shost,sport,suser)
	char *map,*str,*proto,*dhost,*shost,*suser;
{	int mx;
	Route *Rp;
	int nd,ns;

	for( mx = 0; mx < MapX; mx++ ){
		Rp = Maps[mx];

		if( strcmp(map,Rp->m_host) != 0 )
			continue;

		if( !protoMatch2(Rp->m_protoV,proto) )
			continue;

		nd = Rp->m_dsts.hl_cnt;
		ns = Rp->m_srcs.hl_cnt;
		if(!nd || hostIsinList_byname(&Rp->m_dsts,proto,dhost,dport,NULL) )
		if(!ns || hostIsinList_byname(&Rp->m_srcs,ANYP,shost,sport,suser) ){
			strcpy(str,Rp->m_path);
			return mx;
		}
	}
	*str = 0;
	return -1;
}
find_CMAP(Conn,map,str)
	Connection *Conn;
	char *map,*str;
{	char *proto;
	char *dhost,shost[128];
	int dport,sport;
	char *suser;

	proto = DST_PROTO;
	dhost = DST_HOST;
	dport = DST_PORT;
	sport = getClientHostPort(Conn,shost);
	suser = Ident();

	return find_CMAPX(map,str,proto,dhost,dport,shost,sport,suser);
}

/*
 *	ROUTE=proto://host:port/path-_-{dstHostList}:{srcHostList}
 */
#define DELMARK	"-_-"
scan_ROUTE(Conn,forward)
	Connection *Conn;
	char *forward;
{	char gateway[256],proto[32],hostport[128],host[128],path[128];
	int port;
	char dstlist[2048],srclist[2048];
	char *dp,*np,*srcp;
	int na;

	if( (dp = strstr(forward,DELMARK)) == 0 )
		goto error;
	strncpy(gateway,forward,dp-forward);
	gateway[dp-forward] = 0;

	path[0] = 0;
	if( sscanf(gateway,"%[^:]://%[^/]%s",proto,hostport,path) < 2 )
		goto error;
	if( sscanf(hostport,"%[^:]:%d",host,&port) < 2 )
		port = serviceport(proto);

	dp += strlen(DELMARK);

	srcp = 0;
	dstlist[0] = srclist[0] = 0;

	if( *dp == '{' ){
		dp++;
		if( (np = strchr(dp,'}')) == 0 )
			goto error;
		strncpy0(dstlist,dp,np-dp);
		switch( np[1] ){
			case 0:	  goto done;
			case ':': srcp = np + 2; break;
			default:  goto error;
		}
	}else{
		if( np = strchr(dp,':') ){
			strncpy0(dstlist,dp,np-dp);
			srcp = np + 1;
		}else{
			strcpy(dstlist,dp);
			goto done;
		}
	}
	if( *srcp == '{' ){
		srcp++;
		if( (np = strchr(srcp,'}')) == 0 )
			goto error;
		strncpy0(srclist,srcp,np-srcp);
	}else{
		strcpy(srclist,srcp);
	}
done:
	addRoute1("ROUTE",Forwards,ForwardX++,proto,host,port,path,"",
		NULL,dstlist,srclist);
	return;
error:
	sv1log("ROUTE ? %s\n",forward);
	return;
}

static findRoute(Conn,routes,startX,endX,proto,dsthost,srchost)
	Connection *Conn;
	Route *routes[];
	char *proto,*dsthost,*srchost;
{	int cx,nd,ns;
	Route *Rp;

	for( cx = startX; cx < endX; cx++ ){
		Rp = routes[cx];

		if( !protoMatch3(Rp->m_protoV,proto) )
			continue;

		nd = Rp->m_dsts.hl_cnt;
		ns = Rp->m_srcs.hl_cnt;
		if(!nd || hostIsinList_byname(&Rp->m_dsts,proto,dsthost,0,NULL) )
		if(!ns || hostIsinList_byname(&Rp->m_srcs,ANYP,srchost,0,Ident()))
			return cx;
	}
	return -1;
}

/*
 *	PERMIT=proto1/{port1,port2}/{com1,com2}:dstHostList:srcHostList
 */
int PERMIT_WITH_SRCHOST;

scan_PERMITV(Conn,list,protov)
	Connection *Conn;
	char *list;
	char *protov[];
{	char protoL[256],dstL[2048],srcL[2048];
	char *protoV[64],*pprotov[64];
	char portb[1024],*portp = portb;
	int pc;

	protoL[0] = dstL[0] = srcL[0] = 0;
	pc = scan_ListList(list,':',protoL,dstL,srcL);

	srcProto = DFLT_PROTO;
	protoV[0] = 0;

	if( pc <= 1 ){
		char protolist[1024];

		sprintProtoV(PermitG,protolist);
		if( protolist[0] )
			strcat(protolist,",");
		strcat(protolist,protoL);

		scan_commaListL(protolist,STR_VOLA,addProto1,protov,protoV,&portp);
		if( PermitG )
			freeProtoV(PermitG);
		PermitG = makeProtoV(protoV);
		sprintProtoV(PermitG,protolist);
		sv1log("REMITTABLE = %s\n",protolist);
		return;
	}

	if( srcL[0] )
		PERMIT_WITH_SRCHOST++;

	if( PermitG != NULL ){
		int pi;

		for( pi = 0; pprotov[pi] = PermitG[pi].p_name; pi++ )
			;
		protov = pprotov;
	}
	scan_commaListL(protoL,STR_VOLA,addProto1,protov,protoV,&portp);

	if( dstL[0] == 0 ) strcpy(dstL,"*");
	if( srcL[0] == 0 ) strcpy(srcL,DELEGATE_RELIABLE);
	addRoute1("PERMIT",Permits,PermitX++,"","",0,"","",protoV,dstL,srcL);
}

notREMITTABLE(proto,port)
	char *proto;
{
	if( PermitG != NULL )
		if( protoMatch1(PermitG,proto,port) == NULL )
			return 1;
	return 0;
}

DELEGATE_permit(Conn,proto,dsthost,dport,srchost,sport)
	Connection *Conn;
	char *proto,*dsthost,*srchost;
{	Route *Rp;
	int pi;
	char *suser;
	char protob[256],method[256];
	ProtoList *pl;
	char *duser = DST_USER;
	int no_dstcheck_proto;

	method[0] = 0;
	if( sscanf(proto,"%[^/]/%s",protob,method) == 2 )
		proto = protob;

	no_dstcheck_proto = 0; 
	if( Conn->no_dstcheck_proto
	 && Conn->no_dstcheck_proto == serviceport(proto) )
		no_dstcheck_proto = 1; 

	if( !Conn->no_dstcheck )
	if( !no_dstcheck_proto )
	if( PermitG != NULL ){
		if( (pl = protoMatch1(PermitG,proto,dport)) == NULL )
			return 0;
		if( !methodMatch(pl,method) )
			return 0;
	}

	if( PermitX == 0 )
		return 1;

	if( Conn->cl_auth_user[0] ){
		srchost = Conn->cl_auth_host;
		sport = 0;
		suser = Conn->cl_auth_user;
	}else	suser = Ident();

	for( pi = 0; pi < PermitX; pi++ ){
		Rp = Permits[pi];
		pl = NULL;

		if( !Conn->no_dstcheck )
		if( !no_dstcheck_proto )
		if( Rp->m_protoV )
		if( (pl = protoMatch1(Rp->m_protoV,proto,dport)) == NULL )
			continue;

		if( Conn->no_dstcheck
		 || hostIsinList_byname(&Rp->m_dsts,proto,dsthost,dport,duser) )
		if( hostIsinList_byname(&Rp->m_srcs,ANYP,srchost,sport,suser) ){
			if( pl == NULL )
				return 1;
			else	return methodMatch(pl,method);
		}
	}
	return 0;
}

/*
 *	OWNER=owner:srcHostList
 */
scan_OWNER(Conn,ownerspec)
	Connection *Conn;
	char *ownerspec;
{	char user[1024],from[1024];
	Route *Rp;

	user[0] = from[0] = 0;
	sscanf(ownerspec,"%[^:]:%s",user,from);
	if( from[0] != 0 ){
		Rp = addRoute1("OWNER",Owners,OwnerX++,"","",0,"","",NULL,"",from);
		Rp->m_owner = strdup(user);
	}
	return 0;
}
set_OWNER(Conn,host,port,user)
	Connection *Conn;
	char *host,*user;
{	int oi;
	Route *Rp;
	char *owner;

	if( OwnerX == 0 )
		return 0;

	owner = 0;
	for( oi = 0; oi < OwnerX; oi++ ){
		Rp = Owners[oi];
		if( hostIsinList_byname(&Rp->m_srcs,ANYP,host,port,user) ){
			owner = Rp->m_owner;
			break;
		}
	}
	if( owner ){
		if( streq(owner,"*") )
			owner = user;
		sv1log("OWNER=%s <= %s@%s:%d\n",owner,user,host,port);
		set_Owner(1,owner,-1); /* Identd doesn't look effective UID ... */
		return 0;
	}
	sv1log("#### set_OWNER: failed <= %s@%s:%d\n",user,host,port);
	return -1;
}
extern char *getusernames();
set_Owner(real,aowner,file)
	char *aowner;
{	char *owner;
	int uid,gid;
	char names[128];

	if( aowner != NULL && strchr(aowner,':') )
		return 0;

	if( (owner = aowner) == NULL )
		owner = DELEGATE_OWNER;

	if( scan_guid(owner,&uid,&gid) != 0 ){
		if( aowner != NULL ){
			ERRMSG("ERROR: Unknown OWNER: %s\n",owner);
			return -1;
		}
	}else{
		if( 0 <= file && !isatty(file) )
		if( INHERENT_fchown() )
			fchown(file,uid,gid);
		/* chown() should be tried if it is available... */

		if( real ){
			if( gid != -1 ) setgid(gid);
			setuid(uid);
		}else{
			if( gid != -1 ) setegid(gid);
			seteuid(uid);
		}
		sv0log("OWNER=%s => OWNER=%s\n",owner,getusernames(names));
	}
	return 0;
}

/*
 *	cache/expire
 *	direct/socks
 *	master/private
 *	master/socks
 *	proxy/socks
 */

#define C_CACHE		'c'
#define C_ICP		'i'
#define C_SSLTUNNEL	'h'
#define C_MASTER	'm'
#define C_MASTERP	'm'
#define C_PROXY		'p'
#define C_DIRECT	'd'
#define C_VSAP		'v'
#define C_SOCKS		's'
#define C_TELEPORT	't'
#define C_UDP		'u'
#define C_INTERNAL	'l'

typedef struct {
	char	*orders;
	int	 orderx;
	int	*expires;
} connArg; 

static connect1(conn,Conn,Ca)
	char *conn;
	Connection *Conn;
	connArg *Ca;
{	char *expire,*dp;
	int ctype;

	switch( *conn ){
	    case 'c':	enable_cache();
			if( expire = strchr(conn,'/') ){
				expire++;
			}
			ctype = C_CACHE;    break;
	    case 'i':	ctype = C_ICP;      break;
	    case 'd':	ctype = C_DIRECT;   break;
	    case 'h':	ctype = C_SSLTUNNEL;break;
	    case 'm':	ctype = C_MASTER;
			if( dp = strchr(conn,'/') )
				if( dp[1] == 'p' )
					ctype = C_MASTERP;
			break;
	    case 'v':	ctype = C_VSAP;
			if( dp = strchr(conn,'/') ){
				char vsap[1024];
				sprintf(vsap,"%s/CONNECT",dp+1);
				scan_VSAP(Conn,vsap);
			}
			break;
	    case 's':	ctype = C_SOCKS;    break;
	    case 't':	ctype = C_TELEPORT; break;
	    case 'u':	ctype = C_UDP; break;
	    case 'l':	ctype = C_INTERNAL; break;
	    default:	sv1log("CONNECT=%s ?\n",conn);
			return -1;
	}

	Ca->orders[Ca->orderx++] = ctype;
	return 0;
}
static conn1(co1,connv,connc)
	char *co1,*connv[];
	int *connc;
{
	if( *co1 )
		connv[*connc] = co1;
	else	connv[*connc] = "*";
	*connc += 1;
	return 0;
}
scan_CONNECT(Conn,connlist)
	Connection *Conn;
	char *connlist;
{	char *clist,*proto,*dst,*src,*protoV[64];
	char orders[32];
	int expires[32];
	connArg ca;
	char *connv[4];
	int conni,connc;

	clist = stralloc(connlist);
	for( conni = 0; conni < 4; conni++ )
		connv[conni] = "*";
	connc = 0;
	scan_List(clist,':',STR_OVWR,conn1,connv,&connc);
	proto = connv[1];
	dst = connv[2];
	src = connv[3];

	ca.orders = orders;
	ca.orderx = 0;
	ca.expires = expires;
	if( scan_commaListL(connv[0],STR_VOLA,connect1,Conn,&ca) < 0 ){
		ERRMSG("CONNECT=%s ?\r\n",clist);
		Finish(1);
	}
	ca.orders[ca.orderx] = 0;
	Verbose("CONNECT={%s}:{%s}:{%s}:{%s}\n",orders,proto,dst,src);

	stoV(proto,64,protoV,',');
	addRoute1("CONNECT",Connects,ConnectX++,"","",0,"",orders,protoV,dst,src);
	free(clist);
}
setupConnect(Conn)
	Connection *Conn;
{	int routex;
	char shost[256];
	int shosti,sporti;
	Route *Rp;
	char *orders;

	if( ConnectX == 0 )
		return 0;
	if( Conn->co_setup )
		return 1;
	Conn->co_setup = 1;

	if( remote_access() ){
		sv1log("====> remote access\n");
		ConnectX = 0; /* should set remote access explicitly ? */
		Conn->co_nonet = 0;
		return 0;
	}

	if( Conn->from_myself ){
		shost[0] = 0;
		shosti = 0;
		sporti = 0;
	}else
	if( getpeerNAME(Conn->cl_sock,shost,&shosti,&sporti) == 0 )
		return 0;
	routex = findRoute(Conn,Connects,0,ConnectX,DST_PROTO,DST_HOST,shost);
	Conn->co_routex = routex;
	if( routex < 0 ){
		Verbose("====> NO CONNECT was specified for: %s:%s\n",
			DST_HOST,shost);
		return 0;
	}

	Rp = Connects[routex];
	orders = Rp->m_conn;

	if( strchr(orders,C_INTERNAL) && orders[0] != C_INTERNAL ){
		Verbose("CONNECTION: NO INTERNAL\n");
		Conn->co_nointernal = 1;
	}
	if( strchr(orders,C_CACHE) == 0 ){
		disable_cache();
	}else{
		enable_cache();
		/*scan_EXPIRE();*/
		if( orders[0] == C_CACHE && orders[1] == 0 )
			Conn->co_nonet = 1;
	}
}
tryCONNECT(Conn,relay_input,svsockp)
	Connection *Conn;
	int *svsockp;
{	int cx,ci,svsock;
	char contype,*order;

	*svsockp = -1;
	Conn->ca_objsize = -1;

	if( ConnectX == 0 )
		return 0;
	if( Conn->co_setup == 0 )
		setupConnect(Conn);
	if( Conn->co_routex < 0 )
		return 0; /* default connection will be tried */
	if( Conn->co_nonet )
		return -1;

	svsock = -1;
	cx = Conn->co_routex;
	order = Connects[cx]->m_conn;

	for( ci = 0; svsock == -1 && order[ci]; ci++ ){
	    switch( contype = order[ci] ){
	      case C_CACHE:
		Verbose("-[%d,%d]- TRY CACHE ...\n",cx,ci);
		break;
	      case C_ICP:
		Verbose("-[%d,%d]- TRY ICP ...\n",cx,ci);
		svsock = ConnectViaICP(Conn);
		break;
	      case C_SSLTUNNEL:
		Verbose("-[%d,%d]- TRY SSLtunnel/HTTP ...\n",cx,ci);
		svsock = ConnectViaSSLtunnel(Conn,DST_HOST,DST_PORT);
		break;
	      case C_MASTER:
		Verbose("-[%d,%d]- TRY MASTER ...\n",cx,ci);
		svsock = open_master(Conn,1,DST_HOST,DST_PORT,1,relay_input);
		break;
	      case C_DIRECT:
		Verbose("-[%d,%d]- TRY DIRECT ...\n",cx,ci);
/* should get rid of SOCKS access */
		svsock = ConnectToServer(Conn,relay_input);
		break;
	      case C_VSAP:
	      { char sockname[256],peername[256];
		sockname[0] = 0;
		sprintf(peername,"%s:%d",DST_HOST,DST_PORT);
		Verbose("-[%d,%d]- TRY VSAP ...\n",cx,ci);
		svsock = VSAPconnect(sockname,peername);
		if( 0 <= svsock )
			Conn->sv_viaVSAP = 1;
		break;
	      }
	      case C_SOCKS:
		Verbose("-[%d,%d]- TRY SOCKS ...\n",cx,ci);
		svsock = ConnectViaSocks(Conn,relay_input);
		if( 0 <= svsock )
			Conn->sv_viaSocks = 1;
		break;
	      case C_UDP:
		svsock = UDP_client_open1("connect",DST_PROTO,DST_HOST,DST_PORT,
			NULL,0);
		break;
	      case C_INTERNAL:
		Verbose("-[%d,%d]- TRY INTERNAL ... not supported\n",cx,ci);
		break;
	      case C_TELEPORT:
		Verbose("-[%d,%d]- TRY TELEPORT ...\n",cx,ci);
/*
		svsock = teleport_open(Conn,DST_HOST,relay_input);
*/
		break;
	    }
	}
	if( 0 <= svsock )
		ConnType = contype;

	*svsockp = svsock;
	return 1;
}

DELEGATE_forward(Conn,proto,dsthost,dstport,srchost,rproto,rhost,rport,rpath)
	Connection *Conn;
	char *proto,*dsthost,*srchost;
	char **rproto,**rhost;
	int *rport;
	char **rpath;
{	Route *Rp;
	int nd,ns,fi,fj;

	if( ForwardX == 0 )
		return 0;

	for( fi = 0; fi < ForwardX; fi++ ){
	  Rp = Forwards[fi];
	  nd = Rp->m_dsts.hl_cnt;
	  ns = Rp->m_srcs.hl_cnt;
	  if( !nd || hostIsinList_byname(&Rp->m_dsts,proto,dsthost,dstport,NULL) )
	  if( !ns || hostIsinList_byname(&Rp->m_srcs,ANYP,srchost,0,Ident()) )
	    {
		*rproto = Rp->m_proto;
		*rhost  = Rp->m_host;
		*rport  = Rp->m_port;
		*rpath  = Rp->m_path;
		return 1;
	    }
	}
	return 0;
}

TeleportServer(tunnel,invites)
	char *tunnel,*invites;
{	char *host;
	int port;
	int pid;
	int mi;
	Route *Rp;

	pid = 0;
	for( mi = 0; MASTER_delegated[mi].m_host; mi++ ){
		Rp = &MASTER_delegated[mi];
		if( Rp->m_teleport == 0 )
			continue;

		host = Rp->m_host;
		port = Rp->m_port;
		pid = bindTeleportVehicle(mi+1,NULL,host,port,tunnel,invites);
		sv1log(">>>>>> Teleport[%d] <<<<<< %s:%d\n",pid,host,port);
	}
	return pid;
}

static scan_MASTER0(Conn,host,port,route,filter)
	Connection *Conn;
	char *host,*route,*filter;
{	int mi;
	Route *Rp;
	char *host1;

	for( mi = 0; host1 = MASTER_delegated[mi].m_host; mi++){
		if( streq(host1,host) )
		if( MASTER_delegated[mi].m_port == port ){
			Verbose("warning MASTER=%s duplicate\n",host);
			/*return;*/
		}
	}

	if( route )
		Verbose("MASTER=%s:%d/%s:%s\n",host,port,route,filter);
	else	Verbose("MASTER=%s:%d:%s\n",host,port,filter);

	Rp = &MASTER_delegated[mi];

	if( route[0] ){
		if( strcasecmp(route,"teleport") == 0 ){
			Rp->m_teleport = 1;
		}else
		if( strcasecmp(route,"cache") == 0 ){
			Rp->m_cacheonly = 1;
		}else
		sv1log("ERROR MASTER=%s:%d'/%s'?\n",host,port,route);
	}
	Rp->m_dsts.hl_what = stralloc("MASTER/FILTER");
	scan_commaListL(filter,STR_ALLOC,addHostList1,&Rp->m_dsts);

	Rp->m_host = stralloc(host);
	Rp->m_port = port;

	if( !(Rp->m_teleport && streq(host,"tty7")) )
	if( !IsResolvable(host) )
		sv1log("ERROR unknown host MASTER=%s\n",host);

}
scan_MASTER(Conn,master)
	Connection *Conn;
	char *master;
{	char host[1024],*dp;
	char ports[1024];
	char route[1024];
	char filter[2048];
	int port;

	route[0] = 0;
	filter[0] = 0;
	if( *master == '*' ){
		sscanf(master,"*:%s",filter);
		strcpy(host,"*");
		port = 0;
	}else
	if( sscanf(master,"%[^:]:%[^:]:%s",host,ports,filter) < 2 ){
		sv1log("ERROR MASTER=%s\n",master);
		return;
	}
	if( (dp = strchr(host,'/')) && dp != host ){
		*dp++ = 0;
		strcpy(route,dp);
	}
	if( dp = strchr(ports,'/') ){
		*dp++ = 0;
		strcpy(route,dp);
	}
	port = atoi(ports);
	scan_MASTER0(Conn,host,port,route,filter);
}
scan_DIRECT(Conn,hosts)
	Connection *Conn;
	char *hosts;
{
	scan_MASTER0(Conn,"@",0,"",hosts);
}

int ROUND_ROBBIN = 0;

extern int FromTeleport;
DELEGATE_master(ms,master,mport,teleport,cacheonly)
	char **master;
	int *mport;
	int *teleport;
	int *cacheonly;
{	int mn,mi;

	for( mn = 0; MASTER_delegated[mn].m_host; mn++);
	if( mn == 0  ) return 0;
	if( mn <= ms ) return 0;

	if( ROUND_ROBBIN )
		mi = (SERNO() + ms) % mn;
	else	mi = ms % mn;

/*
FromTeleport should be inherited via exec()
also MASTER_delegated table should be ...
(currently MASTER=tty7/teleport is not inherited, thus the problem will not occur)
	sv1log("FromTeleport:%d [%d]%x\n",FromTeleport,
		MASTER_delegated[mi].m_teleport);
*/
	if( FromTeleport && MASTER_delegated[mi].m_teleport ){
		sv1log("DONT LOOPBACK TO Teleport.\n");
		*master = NULL;
	}else
	{
		*master = MASTER_delegated[mi].m_host;
		*mport  = MASTER_delegated[mi].m_port;
		*teleport = MASTER_delegated[mi].m_teleport;
		*cacheonly = MASTER_delegated[mi].m_cacheonly;
	}
	return mi+1;
}
get_masterenv(mx,version,server)
	char **version,**server;
{	Route *Rp;

	Rp = &MASTER_delegated[mx-1];
	if( Rp->m_Version ){
		*version = Rp->m_Version;
		*server = Rp->m_SERVER;
		return 1;
	}else	return 0;
}
set_masterenv(mx,version,server)
	char *version,*server;
{	Route *Rp;

	Rp = &MASTER_delegated[mx-1];
	Strdup(&Rp->m_Version,version);
	Strdup(&Rp->m_SERVER,server);
}

DELEGATE_Filter(mi,dstproto,dsthost,dstport)
	char *dstproto;
	char *dsthost;
{	HostList *hostlist;
	int rcode;

	hostlist = &MASTER_delegated[mi-1].m_dsts;
	if( hostlist->hl_cnt == 0 )
		return 0;

	if( hostIsinList_byname(hostlist,dstproto,dsthost,dstport,NULL) )
		rcode = 0;
	else	rcode = -1;
	Verbose("filter[%d]: %s = %d\n",mi,dsthost,rcode);
	return rcode;
}


/*///////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	proxy.c (client for URL proxy server)
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	940316	created
//////////////////////////////////////////////////////////////////////#*/

char	 DELEGATE_PROXY_HOST[128] = "";
int	 DELEGATE_PROXY_PORT      = 8080;

scan_PROXY(Conn,proxy)
	Connection *Conn;
	char *proxy;
{	char *proto,host[256],proxyb[2048];
	char protob[128];
	int port;
	char filter[2048];
	char route[2048];

	if( DFLT_PROTO[0] )
		proto = DFLT_PROTO;
	else	proto = "http";
	if( strstr(proxy,"://") ){
		sscanf(proxy,"%[^:]",protob);
		if( 0 < (port = serviceport(protob)) ){
			proto = protob;
			proxy += strlen(proto) + strlen("://");
			if( strcaseeq(proto,"delegate") ){
				sv1log("MASTER=%s\n",proxy);
				return scan_MASTER(Conn,proxy);
			}
			sv1log("PROXY = [%d/%s] %s\n",port,proto,proxy);
		}
	}

/*
	if( sscanf(proxy,"%[^:]:%d:%s",host,&port,filter) == 3 ){
*/
	strcpy(filter,"*");
	if( sscanf(proxy,"%[^:]:%d:%s",host,&port,filter) >= 2 ){
		if( *filter == '{' ){
			int len;
			strcpy(filter,filter+1);
			len = strlen(filter);
			if( 0 < len && filter[len-1] == '}' )
				filter[len-1] = 0;
		}
		sprintf(route,"%s://%s:%d/%s{%s}:{%s}",
			proto,host,port,DELMARK,filter,"*");
		scan_ROUTE(Conn,route);
	}else
	sscanf(proxy,"%[^:]:%d",DELEGATE_PROXY_HOST,&DELEGATE_PROXY_PORT);
}
with_PROXY(){
	return DELEGATE_PROXY_HOST[0] != 0;
}

connectToUpper(Conn,where,proto,host,port)
	Connection *Conn;
	char *where,*proto,*host;
{	int routex;
	char *shost = "";
	char *orders;
	int sock;

	routex = findRoute(Conn,Connects,0,ConnectX,proto,host,shost);
	if( 0 <= routex ){
		orders = Connects[routex]->m_conn;
		if( strchr(orders,C_SOCKS) ){
			sock = connectViaSocks(host,port);
			sv1log("%s '%s' via SOCKS = %d\n",where,proto,sock);
			return sock;
		}
	}
	return client_open(where,proto,host,port);
}

connect_to_proxy(Conn,req,proto,server,iport)
	Connection *Conn;
	char *req,*proto,*server;
{	int clsock;
	char *pxhost;
	int pxport;
	char pxname[256];

	if( Conn->co_mask & CONN_NOPROXY )
		return -1;

	sprintf(pxname,"%s_proxy",proto);
	if( withTmpProxy() ){
		pxhost = MO_ProxyHost;
		pxport = MO_ProxyPort;
	}else{
		pxhost = DELEGATE_PROXY_HOST;
		pxport = DELEGATE_PROXY_PORT;
	}

	clsock = connectToUpper(Conn,"ConnectToProxy",pxname,pxhost,pxport);
	if( 0 <= clsock ){
		ConnType = 'p';
		if( strcasecmp(proto,"ftp") != 0 )
			connected_to_proxy(Conn,req,proto,server,iport,clsock);
	}
	Conn->sv_toS = Conn->sv_fromS = clsock;
	return clsock;
}

static char *st_host;
static int st_port;
scan_SSLTUNNEL(spec)
	char *spec;
{	char host[256];
	int port;

	port = 8080;
	if( sscanf(spec,"%[^:]:%d",host,&port) < 1 )
		return;
	if( !IsResolvable(host) ){
		sv1log("#### Unknown host -- SSLTUNNEL=%s:%d",host,port);
		return;
	}
	st_host = strdup(host);
	st_port = port;
}
ConnectViaSSLtunnel(Conn,host,port)
	Connection *Conn;
	char *host;
{	int sock;
	char msg[1024],resp[4096],ver[1024];
	int wcc,rcc,rcode;

	if( st_host == NULL || st_port == 0 )
		return -1;
	sock = client_open("SSLtunnel","http",st_host,st_port);
	if( sock < 0 )
		return -1;

	sprintf(msg,"CONNECT %s:%d HTTP/1.0\r\n\r\n",host,port);
	sv1log("SSL-TUNNEL<< %s:%d\n",host,port);
	wcc = write(sock,msg,strlen(msg));
	rcc = RecvLine(sock,resp,sizeof(resp));
	if( rcc <= 0 )
		goto ERROR;
	sv1log("SSL-TUNNEL>> %s",resp);
	if( sscanf(resp,"%s %d",ver,&rcode) != 2 )
		goto ERROR;
	if( rcode != 200 )
		goto ERROR;
	for(;;){
		rcc = RecvLine(sock,resp,sizeof(resp));
		if( rcc <= 0 )
			goto ERROR;
		sv1log("SSL-TUNNEL>> %s",resp);
		if( resp[0] == '\r' || resp[0] == '\n' )
			break;
	}
	return sock;

ERROR:
	close(sock);
	return -1;
}

extern char *gethostaddr();
forward_RIDENT(Conn,where,svsock,ident)
	Connection *Conn;
	char *ident;
{	char sockname[512],peername[512];

	if( TeleportHost[0] && TeleportPort ){
		sprintf(sockname,"%s:%d",TelesockHost,TelesockPort);
		sprintf(peername,"%s:%d",gethostaddr(TeleportHost),TeleportPort);
	}else{
		getpairName(Conn->cl_sock,sockname,peername);
	}
	RIDENT_send(svsock,sockname,peername,ident);
}
connected_to_proxy(Conn,req,proto,server,iport,clsock)
	Connection *Conn;
	char *req,*proto,*server;
{	char method[256],hostport[256],gopher_url[1024];
	char *tp,*arg,*tmp,*wordscan();

	forward_RIDENT(Conn,'p',clsock,NULL);

	insert_FSERVER(Conn,ClientSock);
	if( (Conn->xf_filters & XF_FSV) && streq(DST_PROTO,"https") ){ 
		sv1log("## INSERTED FSV for HTTPS and CONNECT\n");
		return;
	}

	if( tp = strpbrk(req,"\r\n") )
		*tp = 0;
	arg = wordscan(req,method);
	while( *arg == ' ' || *arg == '\t' )
		*arg++;
	if( *arg == '/' )
		arg++;

	if( !is_http_method(method) ){
		strcpy(method,"GET");
		if( streq(proto,"gopher") ){
			gopherreq_to_URL(req,gopher_url);
			arg = gopher_url;
		}
	}
	HostPort(hostport,proto,server,iport);
	tmp = strdup(arg);
	sprintf(req,"%s %s://%s/%s\r\n",method,proto,hostport,tmp);
	free(tmp);
/*
	sv1log("connected to %s://%s:%d via PROXY %s:%d\n",
		proto,server,iport, pxhost,pxport);
*/
	sv1log("proxy request = %s",req);
}

redirect_url(Conn,url,durl)
	Connection *Conn;
	char *url,*durl;
{	char turl[2048];
	char myhost[256];
	int myport;
	int len;

	if( DONT_REWRITE || is_redirected_url(url) )
		strcpy(durl,url);
	else{
		if( url == durl ){
			strcpy(turl,url);
			url = turl;
		}

		myport = HTTP_ClientIF_H(Conn,myhost);

		len = url_rurl(url,durl,CLNT_PROTO,myhost,myport,
			Conn->cl_urlbase,DO_DELEGATE);

		if( len == 0 )
			strcpy(durl,url);
	}
}

/*
 * translate a gopher selector to a URL
 */
gopherreq_to_URL(req,url)
	char *req,*url;
{	char gtype;
	char sel[1024],search[1024];

	gtype = get_gtype(req,req);
	sprintf(url,"%c%s",gtype,req);

	if( gtype == '7' )
	if( sscanf(url,"%[^\t]\t%[^\t\r\n]",sel,search) == 2 ){
		nonxalpha_escape(sel,sel);
		nonxalpha_escape(search,search);
		sprintf(url,"%s?%s",sel,search);
	}
}

is_http_method(method)
	char *method;
{
	if( 0 == strcasecmp(method,"GET") )  return 1;
	if( 0 == strcasecmp(method,"PUT") )  return 1;
	if( 0 == strcasecmp(method,"POST") ) return 1;
	if( 0 == strcasecmp(method,"HEAD") ) return 1;
	return 0;
}


service_icp(Conn,sock,port)
	Connection *Conn;
{
	icp_server(sock,port);
}

#define NUMPEER		32
#define IC_PARENT	0x01
#define PX_DELEGATE	0x10
#define PX_ORIGINPROXY	0x20
#define PX_ORIGINSERVER	0x40

extern int ICP_DEBUGLOG;

select_icpconf(Conn,icpconf)
	Connection *Conn;
	char *icpconf;
{	char shost[256],*suser;
	int sport;
	char tmpbuf[1024];

	if( icpconf == NULL )
		icpconf = tmpbuf;

	sport = getClientHostPort(Conn,shost);
	suser = Ident();
	if( icp_selectconf(icpconf,DST_PROTO,DST_HOST,DST_PORT,
		shost,sport,suser) < 0 )
		return 0;
	return 1;
}

ConnectViaICP(Conn)
	Connection *Conn;
{	int sock;
	int icptypes[NUMPEER];
	char *icpaddrs[NUMPEER];
	int icpports[NUMPEER];
	int nserv;
	int sx;
	char url[16*1024];
	char sxaddr[32];
	int sxport;
	char *pxhost;
	int pxport;
	int pxtype,pxtypes[NUMPEER];
	char *pxaddrs[NUMPEER];
	int pxports[NUMPEER];
	double timeout;
	int *objsize;
	char objbuff[16*1024];
	char icpconf[128];
	int parent;
	char addrbuff[1024];
	char msg[1024];
	double Start,Connect;
	FILE *log = stderr;
	char urlhead[1024];

	if( !strcaseeq(iSERVER_PROTO,"http")
	 && !strcaseeq(iSERVER_PROTO,"nntp")
	 && !strcaseeq(iSERVER_PROTO,"ftp" )
	)	return -1;

	if( !select_icpconf(Conn,icpconf) )
		return -1;

	Start = Time();
	parent = 0;
	nserv = icp_getconf(icpconf,icptypes,icpaddrs,icpports,
		pxaddrs,pxports,&timeout,addrbuff);

	for( sx = 0; sx < nserv; sx++ ){
		if( icptypes[sx] & IC_PARENT )
			parent++;
	}

	if( PragmaNoCache ){
		if( parent == 0 )
			return -1;
		else	objsize = NULL;
	}else{
		if( strcaseeq(DST_PROTO,"http") )
			objsize = &Conn->ca_objsize;
		else	objsize = NULL;
	}

	if( HTTP_getICPurl(Conn,url) != 0 ){
		if( parent == 0 )
			return -1;
		/* just to select the parent */
		sprintf(url,"%s://",DST_PROTO);
		HostPort(url+strlen(url),DST_PROTO,DST_HOST,DST_PORT);
		objsize = NULL;
	}
	sprintf(urlhead,"%s://",DST_PROTO);
	HostPort(urlhead+strlen(urlhead),DST_PROTO,DST_HOST,DST_PORT);

	sx = icp_select(url,icptypes,icpaddrs,icpports,timeout,log,
		sxaddr,&sxport,1,objsize,objbuff);
	if( sx < 0 ){
		sprintf(msg,"(ICP-FAIL) %5.3f <%s>",Time()-Start,urlhead);
		sv1log("%s\n",msg);
		if( ICP_DEBUGLOG ) fprintf(log,"%s\n",msg);
		return -1;
	}

	if( 0 <= Conn->ca_objsize ){
		int io[2];
		Socketpair(io);
		setsockbuf(io[1],0,Conn->ca_objsize);
		write(io[1],objbuff,Conn->ca_objsize);
		close(io[1]);

		sprintf(msg,"(ICP-HITO) %5.3f [%s:%d] = %d <%s>",
			Time()-Start,
			icpaddrs[sx],icpports[sx],Conn->ca_objsize,urlhead);
		sv1log("%s\n",msg);
		if( ICP_DEBUGLOG ) fprintf(log,"%s\n",msg);
		return io[0];
	}

	if( strcmp(sxaddr,icpaddrs[sx]) == 0 )
		pxhost = pxaddrs[sx];
	else	pxhost = sxaddr;
	pxport = pxports[sx];
	pxtype = icptypes[sx];
	Connect = Time();

	sock = connectToUpper(Conn,"ICP-PROXY",DST_PROTO,pxhost,pxport);

	sprintf(msg,"(ICP-SUCC) %5.3f [%d][%s]>[%s]>%x[%s:%d]>(%d) %5.3f <%s>",
		Connect-Start,sx,icpaddrs[sx],sxaddr,
		pxtype,pxhost,pxport,sock,Time()-Connect,urlhead);
	sv1log("%s\n",msg);
	if( ICP_DEBUGLOG ) fprintf(log,"%s\n",msg);

	if( 0 <= sock ){
		if( pxtype & PX_ORIGINSERVER ){
		}else
		if( pxtype & PX_DELEGATE ){
			toMaster = 1;
		}else{
			toProxy = 1;
		}
	}

	return sock;
}
