/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1994 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, modify, and distribute this material for any
purpose and without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies, and
that the name of ETL not be used in advertising or publicity pertaining
to this material without the specific, prior written permission of an
authorized representative of ETL.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	lock.c
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	970403	extracted from cache.c
//////////////////////////////////////////////////////////////////////#*/
#include <stdio.h>
#include <sys/types.h>
extern double Time();
extern int errno;

#ifndef Verbose
extern int LOG_VERBOSE;
#define Verbose LOG_VERBOSE==0 ? 0 : sv1vlog
#endif

int lock_for_rd(what,nretry,cpath,fp)
	char *what,*cpath;
	FILE *fp;
{	int rcode;
/*
double Start;
Start = Time();
*/
	errno = 0;
	if( SHlockB(fileno(fp)) == -1 ){
		sv1log("%s lock for read failed*%d (%d) %s\n",
			what,nretry,errno,cpath);
		fclose(fp);
		rcode = -1;
	}else{
/*
daemonlog("E","[%3.2f][%s lock-shared] %s\n",Time()-Start,what,cpath);
*/
		rcode = 0;
	}
	return rcode;
}

int file_lock_wr(what,fp)
	char *what;
	FILE *fp;
{	int rcode;

	rcode = EXlockNB(fileno(fp));
	if( rcode == -1 )
	/* someone are reading or writing the file */
	{
		fclose(fp);
		sv1log("%s lock for write failed (%d), retry..\n",
			what,errno);
		return -1;
	}else{
		Verbose("%s locked for write [%d] %d\n",what,
			fileno(fp),rcode);
		return 0;
	}
}
lock_exclusive(fd)
{
	return EXlockB(fd);
}
lock_exclusiveNB(fd)
{
	return EXlockNB(fd);
}
lock_shared(fd)
{
	return SHlockB(fd);
}
lock_sharedNB(fd)
{
	return SHlockNB(fd);
}
lock_unlock(fd)
{
	return UNlock(fd);
}
lock_free(fd)
{
	return UNlock(fd);
}

static int LOCK_INTVL = 200;

static lock_TO(fd,funcNB,func,timeout,elapsedp)
	int (*funcNB)(),(*func)();
	int *elapsedp;
{	int elapsed,remain;
	int rcode;
	int try;

	elapsed = 0;
	rcode = -1;

	for( try = 0;; try++ ){
		if( (*funcNB)(fd) == 0 ){
			rcode = 0;
			break;
		}
		remain = timeout - elapsed;
		if( remain <= 0 )
			break;

		if( 2000 <= elapsed && 1000 <= remain ){
			double start;
			int elapse1;

			start = Time();
			rcode = callFuncTimeout(remain/1000,-1,func,fd);
			elapse1 = (Time() - start) * 1000; 
/*{
static int n;
fprintf(stderr,"#### [%d] %5d sleeped %5d + %5d RCODE=%d\n",
getpid(),++n,elapsed,elapse1,rcode);
}*/

			elapsed += elapse1;
		}else{
			int wait1;

			if( remain < LOCK_INTVL )
				wait1 = remain;
			else	wait1 = LOCK_INTVL;
			msleep(wait1);
			elapsed += wait1;
		}
	}

	if( elapsedp != NULL )
		*elapsedp = elapsed;
	return rcode;
}
lock_exclusiveTO(fd,timeout,elapsedp)
	int *elapsedp;
{
	return lock_TO(fd,lock_exclusiveNB,lock_exclusive,timeout,elapsedp);
}
lock_sharedTO(fd,timeout,elapsedp)
	int *elapsedp;
{
	return lock_TO(fd,lock_sharedNB,lock_shared,timeout,elapsedp);
}

/* ################ */

/*
LOCK_exclusiveTO(fd,func,timeout,elapsedp)
	int *elapsedp;
{	int rcode;

	LOCK1 = 1;
	rcode = lock_exclusiveTO(fd,func,timeout,elapsedp);
	return rcode;
}
LOCK_sharedTO(fd,timeout,elapsedp)
	int *elapsedp;
{	int rcode;

	LOCK1 = 1;
	rcode = lock_sharedTO(fd,timeout,elapsedp);
	return rcode;
}
LOCK_exclusiveNB(fd)
{	int rcode;

	LOCK1 = 1;
	rcode = lock_exclusiveNB(fd);
	return rcode;
}
LOCK_sharedNB(fd)
{	int rcode;

	LOCK1 = 1;
	rcode = lock_sharedNB(fd);
	return rcode;
}
LOCK_unlock(fd){
	int rcode;

	LOCK1 = 1;
	rcode = lock_unlock(fd);
	return rcode;
}
*/

int fileIsremote(path,fd)
	char *path;
{	int isremote,i;
	char fstype[128];

	if( !INHERENT_fchmod() )
		return 0;

	/* may be on tmpfs on SunOS where st_ctime is not supported ... */
	if( strncmp(path,"/tmp/",5) == 0 )
		return 0;

	if( strncmp(path,"/net/",5) == 0 )
		return 1;
	if( strncmp(path,"/tmp_mnt/",9) == 0 )
		return 1;
	if( Fstype(path,fstype) == 0 ){
		if( strcmp(fstype,"nfs") == 0 )
			return 1;
		else	return 0;
	}

	if( fd < 0 )
		return -1;

	if( isatty(fd) )
		return 0;

	/* not only NFS but different type device also ... */
	if( File_device("/") != file_device(fd) )
		return 1;

	if( lock_exclusive(fd,10*1000,NULL) != 0 )
		return -1;

	isremote = 0;
	for( i = 0; i < 5; i++ ){
		if( fileIsremote1(fd) != 0 ){
			isremote = 1;
			break;
		}
	}
	lock_unlock(fd);
	return isremote;
}

extern FILE *dirfopen();
int getLockFile(dir,file,lkpath)
	char *dir,*file,*lkpath;
{	FILE *lkfp;
	int lkfd;

	sprintf(lkpath,"%s/locks/FILE/%s",dir,file);
	if( lkfp = dirfopen("LOCALLOCK",lkpath,"w+") ){
		lkfd = dup(fileno(lkfp));
		fclose(lkfp);
		setCloseOnExec(lkfd);
		return lkfd;
	}
	return -1;
}

int getLocalLock(fp,dir,file,lkpath)
	FILE *fp;
	char *dir,*file,*lkpath;
{
	if( !fileIsremote(file,fileno(fp)) )
		return -1;
	return getLockFile(dir,file,lkpath);
}

extern char *getenv();
loglog(fmt,a,b,c,d,e,f,g)
	char *fmt,*a,*b,*c,*d,*e,*f,*g;
{	FILE *logfp;
	char *file,stime[256];

	if( file = getenv("DELEGATE_LOGLOG") )
	if( logfp = fopen(file,"a") ){
		getTimestamp(stime);
		fprintf(logfp,"%s [%5d][%5d][%5d] ",
			stime,SERVER_PORT(),getpid(),getppid());
		fprintf(logfp,fmt,a,b,c,d,e,f,g);
		fclose(logfp);
	}
}
