/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1998 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, modify, and distribute this material for any
purpose and without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies, and
that the name of ETL not be used in advertising or publicity pertaining
to this material without the specific, prior written permission of an
authorized representative of ETL.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	ldap.c
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	981201	created
//////////////////////////////////////////////////////////////////////#*/
#include <stdio.h>
#include <ctype.h>
#include "delegate.h"
extern char *malloc();

#define CLASS_OF(type)	((type >> 6) & 3)
#define CLASS_UNV	0
#define CLASS_APP	1
#define CLASS_CTX	2
#define CLASS_PRI	3
static char *classname[4] = {"UNV","APP","CTX","PRI"};
#define classof(type)	classname[CLASS_OF(type)]

#define TYPE_STRUCT	0x20
#define TYPE_INT	2
#define TYPE_CSTRING	4
#define TYPE_ENUM	10
#define TYPE_OF(type)	(type & 0x1F)

#define LDAP_BIND		0
#define LDAP_BIND_RESP		1
#define LDAP_UNBIND		2
#define LDAP_SEARCH		3
#define LDAP_SEARCH_RESP	5

#define RESULT_OK	0
#define RESULT_UNAVAIL	52

#define ident(class,sort,type)	((class<<6)|(sort<<5)|type)

typedef unsigned char *Message;

#define FGETTYPE(in)	getc(in)
#define MGETTYPE(mp)	(*mp++)

static scan_type(octets,typep)
	Message octets;
	int *typep;
{
	if( typep ) *typep = octets[0];
	return 1;
}
static int scan_leng(in,octets,lengp)
	FILE *in;
	Message octets;
	int *lengp;
{	int bytes,bi,noct,leng,ch;

	bytes = 0;
	if( in != NULL ){
		ch = getc(in);
		octets[bytes++] = ch;
	}else	ch = octets[bytes++];

	if( ch & 0x80 ){
		noct = ch & 0x7F;
		leng = 0;
		for( bi = 0; bi < noct; bi++ ){
			if( in != NULL ){
				ch = getc(in);
				octets[bytes++] = ch;
			}else	ch = octets[bytes++];
			leng = (leng << 8) | ch;
		}
	}else{
		leng = ch & 0x7F;
	}
	if( lengp ) *lengp = leng;
	return bytes;
}

static mssglen(mssg)
	Message mssg;
{	int off,type,leng;

	off = 0;
	off += scan_type(&mssg[off],&type);
	off += scan_leng(NULL,&mssg[off],&leng);
	return off + leng;
}

static Message read_mssg(in)
	FILE *in;
{	int type,leng;
	Message mssg;
	unsigned char tbuf[128];
	int len1,tlen,rcc;

	tlen = 0;

	type = getc(in);
	if( type == EOF ) return NULL;
	tbuf[tlen++] = type;

	tlen += len1 = scan_leng(in,&tbuf[tlen],&leng);
	if( len1 < 0 )
		return NULL;

	mssg = (Message)malloc(tlen+leng);
	bcopy(tbuf,mssg,tlen);

	rcc = fread(mssg+tlen,1,leng,in);
	if( rcc != leng ){
		free(mssg);
		syslog_ERROR("ERROR: premature EOF %x/%x\n",rcc,leng);
		return NULL;
	}
	return mssg;
}
static scan_mssg1(offp,ptype,lev,off0,data)
	int *offp;
	Message data;
{	int li;
	int tlen,len1,type,leng,stype,sleng;
	int off;
	int ci,ch;
	char line[1024],*lp;

	tlen = 0;
	tlen += len1 = scan_type(data,&type); data += len1;
	tlen += len1 = scan_leng(NULL,data,&leng); data += len1;

	if( lev == 0 ){
		syslog_ERROR("-- leng=%d type=%x --\n",leng,type);
		lp = line;
		line[0] = 0;
		for( ci = 0; ci < tlen+leng; ci++ ){
			if( ci % 8 == 0 ){
				if( ci != 0 )
					syslog_DEBUG("%s\n",line);
				lp = line;
				sprintf(lp,"%3d: ",ci);
				lp += strlen(lp);
			}
			ch = 0xfF & data[ci-tlen];
			sprintf(lp,"%02x %c|",ch,0x20<=ch&&ch<0x7F?ch:' ');
			lp += strlen(lp);
		}
		syslog_DEBUG("%s\n",line);
	}

	lp = line;
	sprintf(lp,"%3d %02d.%02d [%s %2d](%2d) ",
		*offp,lev,off0,classof(type),type&0x1F,leng);
	lp += strlen(lp);
	for( li = 0; li < lev; li++ )
		*lp++ = '|';
	if( type & TYPE_STRUCT )
		*lp++ = '-';
	*lp++ = ' ';
	*lp = 0;

	*offp += tlen;
	if( type & TYPE_STRUCT ){
		char *typename = NULL;
		switch( CLASS_OF(type) ){
		case CLASS_APP:
			switch( TYPE_OF(type) ){
			case LDAP_BIND: typename = "BIND"; break;
			case LDAP_BIND_RESP: typename = "BIND-RESP"; break;
			case LDAP_SEARCH: typename = "SEARCH"; break;
			case LDAP_SEARCH_RESP: typename = "SEARCH-RESP"; break;
			}
			break;

		case CLASS_CTX:
			if( ptype == ident(CLASS_APP,1,LDAP_SEARCH) )
			switch( TYPE_OF(type) ){
			case 0: typename = "AND"; break;
			case 1: typename = "OR"; break;
			case 2: typename = "NOT"; break;
			case 3: typename = "EQ"; break;
			}
			break;
		}
		if( typename )
			sprintf(lp,"<%s>",typename);
		syslog_ERROR("%s\n",line);
		for( off = 0; off < leng; ){
			sleng = scan_mssg1(offp,type,lev+1,off,&data[off]);
			off += sleng;
		}
	}else{
		if( CLASS_OF(type) == CLASS_APP
		 && TYPE_OF(type) == LDAP_UNBIND
		){
			sprintf(lp,"<UNBIND>");
		}else
		if( leng == 0 ){
			sprintf(lp,"(empty)");
		}else
		switch( type ){
		default:
			sprintf(lp,"0x%x",data[0]);
			break;
		case TYPE_INT:
			sprintf(lp,"%d",data[0]);
			break;
		case TYPE_CSTRING:
			*lp++ = '"';
			for( off = 0; off < leng && off < 32; off++ ){
				ch = data[off];
				if( 0x20 <= ch && ch <= 0x7F )
					*lp++ = ch;
				else	*lp++ = '?';
			}
			*lp++ = '"';
			*lp = 0;
			break;
		}
		syslog_ERROR("%s\n",line);
	}
	*offp += leng;
	return tlen+leng;
}
static scan_mssg(mssg)
	Message mssg;
{	int off;

	off = 0;
	return scan_mssg1(&off,0,0,0,mssg);
}

static Message make_LDAPResult(msgid,type,code,comment)
	char *comment;
{	unsigned char resp[1024];
	Message mresp,tail;
	int ri,comlen,comlenlen;
	unsigned char comlenbuf[8];

	comlen = strlen(comment);
/*
	comlenlen = put_leng(&comlenbuf[sizeof(comlenbuf)],comlen);
*/

	ri = 0;
	resp[ri++] = ident(CLASS_UNV,1,16);
	resp[ri++] = 12+comlen; 
	resp[ri++] = ident(CLASS_UNV,0,TYPE_INT);
	resp[ri++] = 1;
	resp[ri++] = msgid;
	resp[ri++] = ident(CLASS_APP,1,type);
	resp[ri++] = 7+comlen;
	resp[ri++] = ident(CLASS_UNV,0,TYPE_ENUM);
	resp[ri++] = 1;
	resp[ri++] = code;
	resp[ri++] = ident(CLASS_UNV,0,TYPE_CSTRING);
	resp[ri++] = 0;
	resp[ri++] = ident(CLASS_UNV,0,TYPE_CSTRING);
	resp[ri++] = comlen;
	bcopy(comment,&resp[ri],comlen);
	ri += comlen;

/*
ri = 0;
tail = &resp[sizeof(reesp)-1];
ri += comlen;
bcopy(comment,tail[-ri],comlen);
ri++; tail[-ri] = comlen;
...
*/

	mresp = (Message)malloc(ri);
	bcopy(resp,mresp,ri);
	return mresp;
}

static proxy_ldap(Conn)
	Connection *Conn;
{	FILE *fc,*tc,*fs,*ts;
	Message bindmssg,srchmssg,mssg,resp,mp;
	char srchroot[512],ldapserv[512],host[512],*dp;
	int mlen;
	int len,servlen,port;
	FILE *fpv[2],*ifp;
	int rds[2],tov[2],fi;

	fc = fdopen(FromC,"r");

	bindmssg = read_mssg(fc);
	scan_mssg(bindmssg);

	resp = make_LDAPResult(bindmssg[4],
		LDAP_BIND_RESP,RESULT_OK,
		"Bound by proxy (DeleGate)");
/*
"Bound by proxy (DeleGate) 012345680123456801234568012345680123456801234568012345680123456801234568012345689999999999012345689");
*/

	mlen = mssglen(resp);
	syslog_ERROR("#### proxy BIND response (%d)\n",mlen);
	scan_mssg(resp);
	write(ToC,resp,mlen);

	srchmssg = read_mssg(fc);
	scan_mssg(srchmssg);

	len = srchmssg[8];
	bcopy(srchmssg+9,srchroot,len);
	srchroot[len] = 0;
	if( dp = strchr(srchroot,'@') ){
		strcpy(ldapserv,dp+1);
		servlen = strlen(dp);
		mp = (Message)strchr(srchmssg+9,'@');
		mlen = mssglen(srchmssg);
		bcopy(mp+servlen,mp,mlen-(mp-srchmssg)-servlen);
		srchmssg[1] -= servlen;
		srchmssg[6] -= servlen;
		srchmssg[8] -= servlen;
	}else{
		strcpy(ldapserv,"");
	}
	port = scan_hostport("ldap",ldapserv,host);
	syslog_ERROR("LDAP-SERVER=[%s]=[%s:%d]\n",srchroot,host,port);
	set_realserver(Conn,"ldap",host,port);
	if( connect_to_serv(Conn,FromC,ToC,0) < 0 ){
		syslog_ERROR("#### proxy connection error response\n");
		resp = make_LDAPResult(srchmssg[4],
			LDAP_SEARCH_RESP,RESULT_UNAVAIL,
			"Can't connect to LDAP server by proxy (DeleGate)");
		goto ERROR;
	}

	fs = fdopen(FromS,"r");

	mlen = mssglen(bindmssg);
	syslog_ERROR("#### relay client's BIND (%d)\n",mlen);
	scan_mssg(bindmssg);
	write(ToS,bindmssg,mlen);

	syslog_ERROR("#### wait BIND response from the server\n");
	resp = read_mssg(fs);
	if( resp == NULL ){
		syslog_ERROR("#### EOF from server\n");
		resp = make_LDAPResult(srchmssg[4],
			LDAP_SEARCH_RESP,RESULT_UNAVAIL,
			"EOF from LDAP server to proxy (DeleGate)");
		goto ERROR;
	}
	scan_mssg(resp);

	mlen = mssglen(srchmssg);
	syslog_ERROR("#### forward search request (%d)\n",mlen);
	scan_mssg(srchmssg);
	write(ToS,srchmssg,mlen);

	syslog_ERROR("#### start bidirectional relay\n");
	fpv[0] = fc; tov[0] = ToS;
	fpv[1] = fs; tov[1] = ToC;
	while( !feof(fc) && !feof(fs) && 0 < fPollIns(0,2,fpv,rds) )
	for( fi = 0; fi < 2; fi++ )
	if( rds[fi] ){
		ifp = fpv[fi];
		mssg = read_mssg(ifp);
		if( mssg == NULL ){
			syslog_ERROR("#### %s EOF\n",fi==0?"C-S":"S-C");
			break;
		}

		/* "@real-server-name" in LDAPDN in requests must
		 * be removed, and LDAPDN in responses must be
		 * appended with "@real-server-name".
		 * This rewriting should be controled with MOUNT parameter.
		 */

		mlen = mssglen(mssg);
		write(tov[fi],mssg,mlen);
		syslog_ERROR("#### %s (%d)\n",fi==0?"C-S":"S-C",mlen);
		/*scan_mssg(mssg);*/
	}
	return;

ERROR:
	mlen = mssglen(resp);
	scan_mssg(resp);
	write(ToC,resp,mlen);
}

service_ldap(Conn)
	Connection *Conn;
{
	if( isMYSELF(DFLT_HOST) )
                proxy_ldap(Conn);
	else	service_tcprelay(Conn);
}
