/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1995 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, modify, and distribute this material for any
purpose and without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies, and
that the name of ETL not be used in advertising or publicity pertaining
to this material without the specific, prior written permission of an
authorized representative of ETL.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	httpmail.c
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	951023	created
//////////////////////////////////////////////////////////////////////#*/
#include <stdio.h>
#include <string.h>
#include "ysocket.h"

extern FILE *TMPFILE();
extern FILE *dirfopen();
extern char *findFieldValue();
extern char *DELEGATE_ver();
extern char *gethostaddr();

extern char *X_PARTIAL;
#define SERVER		"X-Server"
#define REQUEST		"X-Request"
#define REPLY_TO	"X-Reply-To"
#define INFORM_TO	"X-Inform-To"
#define SPOOLFILE	"X-Spool-File"
#define SPLIT_LENG	"X-Desire-Split"
#define RESPONSE	"X-Response"
#define CTE		"Content-Transfer-Encoding"

int HTTPMAIL_TIMEOUT = 600;
int USE_HTTPMAIL = 0;
static char Server[256];
static char Recipient[256];
static int MSPLIT = 0; /* default */

scan_HTTPMAIL(hm)
	char *hm;
{
	if( hm == 0 )
		return;
	sscanf(hm,"%[^:]:%[^:]:%d",Server,Recipient,&MSPLIT);

	if( Server[0] && Recipient[0] )
		USE_HTTPMAIL = 1;
	else{
		fprintf(stderr,"error: HTTPMAIL=%s\n",hm);
		fprintf(stderr,"usage: HTTPMAIL=Server:Relay\n");
		Finish(1);
	}
}

static FILE *getmail(in,out)
	FILE *in,*out;
{
	copyfile1(in,out);
	fflush(out);
	fseek(out,0,0);
}
static skiphead(what,in,out,prefix,remove)
	char *what;
	FILE *in,*out;
	char *prefix,*remove;
{	char line[1024],*ltop;
	int EOH;
	int rlen;
	int put;

	EOH = 0;
	if( remove ){
		rlen = strlen(remove);
		put = 0;
	}else	put = 1;

	for(;;){
		if( fgets(line,sizeof(line),in) == NULL ){
			sv1tlog("####[%s] Empty header.\n",what);
			Finish(1);
		}
		if( line[0] == '\r' || line[0] == '\n' ){
			put = 1;
			EOH = 1;
		}
		if( out != NULL ){
			ltop = line;
			if( !EOH && ltop[0] != ' ' && ltop[0] != '\t' ){
			    if( remove ){
				if( strncasecmp(ltop,remove,rlen)==0 ){
					if( ltop[rlen] == '-' )
						ltop += rlen + 1;
					else
					if( ltop[rlen] == ':' ){
						ltop += rlen + 1;
						if( ltop[0] == ' ' )
							ltop += 1;
					}
					put = 1;
				}else	put = 0;
			    }
			    if( prefix )
				fprintf(out,"%s-",prefix);
			}
			if( put )
				fputs(ltop,out);
		}
		if( EOH )
			break;
		if( strncasecmp(line,"Received:",9) == 0 )
			sv1log("#### %s",line);
	}
}
static getrequest(what,rfp,part,server,request,replyto,informto,spool,msplit)
	char *what;
	FILE *rfp;
	char *part,*server,*request,*replyto,*informto,*spool;
	int *msplit;
{	char line[1024],name[1024];

	part[0] = 0;
	request[0] = 0;
	informto[0] = 0;
	spool[0] = 0;
	*msplit = 0;

	for(;;){
		if( fgets(line,sizeof(line),rfp) == NULL )
			break;

		if( line[0] == '\r' || line[0] == '\n' )
			break;

		sv1log("####[%s] %s",what,line);
		sscanf(line,"%[^:]",name);

		if( strcasecmp(name,X_PARTIAL) == 0 )
			sscanf(line,"%*[^:]: %[^\r\n]",part);
		else
		if( strcasecmp(name,SERVER) == 0 )
			sscanf(line,"%*[^:]: %[^\r\n]",server);
		else
		if( strcasecmp(name,REQUEST) == 0 )
			sscanf(line,"%*[^:]: %[^\r\n]",request);
		else
		if( strcasecmp(name,REPLY_TO) == 0 )
			sscanf(line,"%*[^:]: %[^\r\n]",replyto);
		else
		if( strcasecmp(name,SPLIT_LENG) == 0 )
			sscanf(line,"%*[^:]: %d",msplit);
		else
		if( strcasecmp(name,INFORM_TO) == 0 )
			sscanf(line,"%*[^:]: %[^\r\n]",informto);
		else
		if( strcasecmp(name,SPOOLFILE) == 0 )
			sscanf(line,"%*[^:]: %[^\r\n]",spool);
	}
}

extern char *fgetsHeaderField();
hmserver(ac,av)
	char *av[];
{	FILE *rfp,*ifp,*msg;
	char from[256];
	char server[256],replyto[256],informto[256],spool[1024];
	char buf[1024];
	char request[4096],method[256],url[4096],ver[256];
	char stat[1024],mimever[1024],ctype[1024],cte[128],ncte[128];
	char subj[1024],xhead[1024];
	char part[128];
	int msplit;

	USE_HTTPMAIL = 0;
	sv1log("####[SV] HMSERVER start\n");
	rfp = TMPFILE("hmserver-req");
	getmail(stdin,rfp);

	replyto[0] = 0;
	fgets(from,sizeof(from),rfp);
	fseek(rfp,0,0);
	if( strncasecmp(from,"From ",4) == 0 )
		sscanf(from,"%*s %s",replyto);
	if( fgetsHeaderField(rfp,"From",buf,sizeof(buf)) != NULL )
		strcpy(replyto,buf);

	skiphead("SV",rfp,NULL,NULL,NULL);
	if( strchr(replyto,'@') == 0 ){
		sv1log("####[SV] Rejected -- Lacking @Host.Domain -- From: %s\n",
			replyto);
		Finish(0);
	}
	sv1log("####[SV] From: %s\n",replyto);
	getrequest("SV",rfp,part,server,request,replyto,informto,spool,&msplit);
	if( part[0] ){
		Finish(0);
	}

	request[0] = 0;
	fgets(request,sizeof(request),rfp);
	fclose(rfp);

	method[0] = url[0] = ver[0] = 0;
	sscanf(request,"%s %s %s",method,url,ver);

	sprintf(xhead,"%s: %s %s %s\r\n",REQUEST,method,url,ver);
	sprintf(xhead+strlen(xhead),"URI: <%s>\r\n",url);
	if( informto[0] )
		sprintf(xhead+strlen(xhead),"%s: %s\r\n",INFORM_TO,informto);
	if( spool[0] )
		sprintf(xhead+strlen(xhead),"%s: %s\r\n",SPOOLFILE,spool);

	ifp = TMPFILE("hmserver-in");
	URLget(url,0,ifp);
	fseek(ifp,0,0);

	msg = TMPFILE("hmserver-msg");
	fprintf(msg,"%s",xhead);
	fgets(stat,sizeof(stat),ifp);
	fprintf(msg,"%s: %s",RESPONSE,stat);

	fgetsHeaderField(ifp,"MIME-Version",mimever,sizeof(mimever));
	if( mimever[0] == 0 )
		sprintf(mimever,"1.0 (by DeleGate/%s)",DELEGATE_ver());
	fprintf(msg,"MIME-Version: %s\r\n",mimever);
	if( fgetsHeaderField(ifp,"Content-Type",ctype,sizeof(ctype)) != NULL )
		fprintf(msg,"Content-Type: %s\r\n",ctype);
	else	fprintf(msg,"Content-Type: text/html\r\n");

	ncte[0] = 0;
	if( fgetsHeaderField(ifp,CTE,cte,sizeof(cte)) != NULL ){
		fprintf(msg,"%s: %s\r\n",CTE,cte);
		if( strcasecmp(cte,"binary") == 0 || strcasecmp(cte,"8bit") )
			strcpy(ncte,"base64");
	}else	strcpy(ncte,"base64");
	if( ncte )
		fprintf(msg,"%s: %s\r\n",CTE,ncte);

	skiphead("SV",ifp,msg,RESPONSE,NULL);
	if( strcmp(ncte,"base64") == 0 )
		MIME_to64(ifp,msg);
	else	copyfile1(ifp,msg);
	fclose(ifp);
	fflush(msg);
	fseek(msg,0,0);

	sprintf(subj,"response - %s",url);
	MAIL_send(msg,file_size(fileno(msg)),msplit,mimever,replyto,server,subj);

	fclose(msg);
	sv1log("####[SV] HMSERVER done\n");
	return 0;
}

static copyresp(rfp,out)
	FILE *rfp,*out;
{	char cte[128];

	fseek(rfp,0,0);
	skiphead("CL",rfp,NULL,NULL,NULL);

	cte[0] = 0;
	fgetsHeaderField(rfp,CTE,cte,sizeof(cte));
	skiphead("CL",rfp,out,NULL,RESPONSE);

	if( strcasecmp(cte,"base64") == 0 )
		MIME_from64(rfp,out);
	else	copyfile1(rfp,out);
	fclose(out);
}

extern FILE *MAIL_assemblePartial();
hmrelay(ac,av)
	char *av[];
{	FILE *rfp,*afp,*out;
	char spool[4096];
	char request[4096];
	char server[256],replyto[256],informto[256],host[256];
	int port,sock;
	char part[256];
	int msplit;

	USE_HTTPMAIL = 0;
	sv1log("####[CL] HMCLIENT start\n");
	rfp = TMPFILE("mail2spool");
	getmail(stdin,rfp);
	skiphead("CL",rfp,NULL,NULL,NULL);

	getrequest("CL",rfp,part,server,request,replyto,informto,spool,&msplit);
	if( part[0] ){
		afp = MAIL_assemblePartial(rfp,part);
		if( afp == NULL )
			Finish(0);
		fclose(rfp);
		rfp = afp;

		skiphead("CL",rfp,NULL,NULL,NULL);
		getrequest("CL",rfp,part,server,request,replyto,informto,spool,&msplit);
	}

	sv1log("####[CL] %s: %s\n",INFORM_TO,informto);
	sv1log("####[CL] %s: %s\n",SPOOLFILE,spool);
	sv1log("####[CL] %s: %s\n",REQUEST,request);

	if( informto[0] ){
		sscanf(informto,"%[^:]:%d",host,&port);
		sock = client_open("HTTPMAIL","tcprelay",host,port);
		out = fdopen(sock,"w");
		if( 0 <= sock && out != NULL ){
			copyresp(rfp,out);
			sv1log("####[CL] %s: %s [%d]\n",INFORM_TO,
				informto,sock);
		}
	}
	if( spool[0] ){
		if( out = dirfopen("hmrelay",spool,"w") ){
			lock_exclusive(fileno(out));
			copyresp(rfp,out);
			sv1log("####[CL] written to spool [%s]\n",spool);
		}
	}
	fclose(rfp);
	sv1log("####[CL] HMCLIENT done\n");
	return 0;
}

FILE *hmget1(url,expire)
	char *url;
{	char spool[4096];
	FILE *msg,*rfp;
	char mailer[1024];
	int odate,ndate,got;
	int sock,port;
	char myhost[256],*myaddr,informto[256];
	char method[64],ver[64];
	char subj[1024],xhead[1024],mimever[256];

	strcpy(method,"GET");
	strcpy(ver,"HTTP/1.0");

	url_cachepath(url,"httpmail",spool);
	rfp = fopen(spool,"r");
	if( rfp == NULL ){
		rfp = dirfopen("hmget1",spool,"w");
		if( rfp != NULL ){
			fclose(rfp);
			rfp = fopen(spool,"r");
		}
	}
	if( rfp != NULL ){
		sv1log("####[HG] %s: %s\n",SPOOLFILE,spool);
		odate = file_mtime(fileno(rfp));
		if( time(0)-odate < expire )
		if( file_size(fileno(rfp)) ){
			sv1log("####[HG] VIVID %s\n",spool);
			got = 1;
			goto GOT;
		}
	}

	gethostname(myhost,sizeof(myhost));
	myaddr = gethostaddr(myhost);

	sock = server_open("HTTPMAIL",myhost,0,1);
	if( 0 <= sock ){
		sockHostport(sock,&port);
		sprintf(informto,"%s:%d %s:%d",myaddr,port,myhost,port);
		sv1log("####[HG] %s: %s [%d]\n",INFORM_TO,informto,sock);
	}
	if( rfp == NULL && sock < 0 ){
		sv1log("hmget: cannot open cache nor socket.\n");
		return NULL;
	}

	sv1log("####[HG] HMSERVER: %s\n",Server);
	sv1log("####[HG] HMRELAY: %s\n",Recipient);
	sv1log("####[HG] URL: %s\n",url);

	sprintf(subj,"request - %s",url);
	sprintf(xhead,"%s: %s\r\n",SERVER,Server);
	if( Recipient[0] )
		sprintf(xhead+strlen(xhead),"%s: %s\r\n",REPLY_TO,Recipient);
	if( 0 <= sock )
		sprintf(xhead+strlen(xhead),"%s: %s\r\n",INFORM_TO,informto);
	if( rfp != NULL )
		sprintf(xhead+strlen(xhead),"%s: %s\r\n",SPOOLFILE,spool);
	if( MSPLIT != 0 )
		sprintf(xhead+strlen(xhead),"%s: %d\r\n",SPLIT_LENG,MSPLIT);

	msg = TMPFILE("HTTPMAIL");
	fprintf(msg,"MIME-Version: 1.0\r\n");
	fprintf(msg,"Content-Type: application/x-http-request\r\n");
	fprintf(msg,"%s",xhead);
	fprintf(msg,"\r\n");
	fprintf(msg,"%s %s %s\n",method,url,ver);
	fflush(msg);
	fseek(msg,0,0);

	mimever[0] = 0;
	MAIL_send(msg,file_size(fileno(msg)),MSPLIT,mimever,Server,Recipient,subj);
	fclose(msg);

	got = 0;
	if( 0 <= sock ){
		FILE *ifp;
		int isock,cc;

		sv1log("####[HG] start ACCEPT %s\n",informto);
		isock = ACCEPT(sock,0,-1,HTTPMAIL_TIMEOUT);
		if( 0 <= isock ){
			if( rfp != NULL )
				fclose(rfp);
			rfp = TMPFILE("HTTPMAIL");
			ifp = fdopen(isock,"r");
			cc = copyfile1(ifp,rfp);
			fclose(ifp);
			got = 1;
			sv1log("####[HG] GOT via %s [%d] %d bytes\n",
				informto,isock,cc);
			fflush(rfp);
			fseek(rfp,0,0);
		}
		close(sock);
	}
	if( rfp != NULL ){
		int start;

		start = time(0);
		for(;;){
			int etime;

			ndate = file_mtime(fileno(rfp));
			if( odate < ndate ){
				sv1log("####[HG] GOT %s\n",spool);
				lock_shared(fileno(rfp));
				got = 1;
				break;
			}

			etime = time(0) - start;
			if( HTTPMAIL_TIMEOUT < etime )
				break;

			sv1log("####[HG] WAIT %s\n",spool);
			if( etime< 10 ) sleep(1); else
			if( etime< 30 ) sleep(5); else
			if( etime<120 ) sleep(10); else
					sleep(60);
		}
	}
GOT:
	if( got )
		return rfp;

	sv1log("####[HG] FAILED %s\n",spool);
	fclose(rfp);
	return NULL;
}

hmget(ac,av)
	char *av[];
{	FILE *rfp;

	if( ac < 2 ){
		fprintf(stderr,"Usage: hmget Url HTTPMAIL=Server:Relay\n");
		Finish(1);
	}
	rfp = hmget1(av[1],0);
	if( rfp != NULL ){
		copyfile1(rfp,stdout);
		fclose(rfp);
	}
}
