/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1995 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, modify, and distribute this material for any
purpose and without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies, and
that the name of ETL not be used in advertising or publicity pertaining
to this material without the specific, prior written permission of an
authorized representative of ETL.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	httplog.c
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	950210	extracted from http.c
//////////////////////////////////////////////////////////////////////#*/
#include <stdio.h>
#include "delegate.h"
#include "log.h"

extern char *getClientUserC();
extern char *wordscan();
extern int LOG_center;
extern char *LOG_format();
extern int HTTP_CKA_MAXREQ;
extern Logfile *LOG_which();
extern char *LOG_buffer();
extern char *TIMEFORM_HTTPDs;
#define HTTPLOG	LOG_which("http",LF_PROTOLOG,0)

http_logplus(Conn,type)
	Connection *Conn;
	char type;
{	Logfile *log;
	char *buff;
	int len;

	if( type == 0 )
		return;

	if( (log = HTTPLOG) == NULL )
		return;

	if( buff = LOG_buffer(log) ){
		len = strlen(buff);
		if( 2 < len && buff[len-1] == '\n' && buff[len-2] == '+' )
			buff[len-2] = type;
	}
}

http_log(Conn,proto,server,iport,req,rcode,ctype,rsize,mtime,ctime,dtime)
	Connection *Conn;
	char *proto,*server;
	char *req;
	char *ctype;
	double ctime,dtime;
{	char clientlog[256];
	char request[4096],*dp,com[1024],arg[4096];
	char hostport[256];
	char buff[0x2000],*bp,*fmt,*fp,fc,fmtb[256],tmp[256];
	Logfile *log;

	if( (log = HTTPLOG) == NULL )
		return;

	fmt = LOG_format(log);
	if( fmt == NULL || strchr(fmt,'%') == NULL )
		fmt = "%C %D";

	makeClientLog(Conn,clientlog);

	dp = wordscan(req,com);
	linescan(dp,arg,sizeof(arg));

	if( strcasecmp(com,"CONNECT") == 0 ){
		sprintf(request,"%s %s://%s",com,proto,arg);
	}else
	if( isFullURL(arg) )
		sprintf(request,"%s %s",com,arg);
	else
	if( streq(proto,"file") || streq(server,"localhost") )
		sprintf(request,"%s %s",com,arg);
	else{
		HostPort(hostport,proto,server,iport);
		sprintf(request,"%s %s://%s%s",com,proto,hostport,arg);
	}

	bp = buff;
	*bp = 0;
	for( fp = fmt; fc = *fp; fp++ ){
		if( fc != '%' || fp[1] == 0 ){
			*bp++ = fc;
			continue;
		}
		switch( fc = *++fp ){
		case '%': *bp++ = '%'; break;
		case 'X':
			strcpy(tmp,fp+1);
			sprintf(fmtb,"X%%C \"%%r\" \"%%u\"%s",tmp);
			fp = fmtb;
			break;
		case 'c':
		case 'C':
		{	char *form,date[128];
			int now,usec;

			now = Gettimeofday(&usec);
			if( fc == 'c' )
				form = TIMEFORM_HTTPDs;
			else	form = TIMEFORM_HTTPD;
			StrftimeLocal(date,sizeof(date),form,now,usec);
			sprintf(bp,"%s [%s] \"%s\" %d %d",
				clientlog,date,request,rcode,rsize);
			break;
		}
		case 'D':
			sprintf(bp,"%4.3f+%4.3f:%s%c",
				ctime,dtime,
				httpStatX ? "R":"",
				httpStat ? httpStat:'-');
			bp += strlen(bp);
			if( 1 < HTTP_CKA_MAXREQ ){
				if( !ClntKeepAlive && RequestSerno == 0 )
					sprintf(bp,":0-");
				else	sprintf(bp,":%d+",RequestSerno);
			}
			break;

		case 'S':
			if( ConnType )
				sprintf(bp,"%c",ConnType);
			else
			if( Conn->sv_viaSocks ) strcpy(bp,"s"); else
			if( Conn->sv_viaVSAP  ) strcpy(bp,"v"); else
			if( Conn->sv_viaCc    ) strcpy(bp,"n"); else
			if( toMaster ) strcpy(bp,"m"); else
			if( toProxy )  strcpy(bp,"p"); else
			if( 0 <= ToS ) strcpy(bp,"d"); else
				       strcpy(bp,"?");
			break;

		case 't':
			/* content-type */
			break;

		case 'r':
			HTTP_getRequestField(Conn,"Referer",bp,256);
			break;
		case 'u':
			HTTP_getRequestField(Conn,"User-Agent",bp,256);
			break;
		}
		bp += strlen(bp);
	}
	*bp = 0;
	LOG_printf(log,"%s\n",buff);

	if( 0 < LOG_center )
	if( 0 <= ToS || 0 < mtime )
		http_publiclog(Conn,rcode,ctype,rsize,mtime,request);
}

static getReferer(Conn,request,url,referer,relurl)
	Connection *Conn;
	char *request,*url,*referer,*relurl;
{
	referer[0] = relurl[0] = 0;
	if( HTTP_getRequestField(Conn,"Referer",referer,sizeof(referer)) == 0 )
		return 0;

	if( !toAnotherProxy(Conn,referer) ){
		char proto[128],host[256];
		int port;
		proto[0] = host[0] = 0; port = 0;
		url_deproxy(Conn,request,referer,proto,host,&port);
		/* strip http://myself/-_- */
	}
	if( strncmp(referer,"/-_-",4) == 0 )
		strcpy(referer,referer+4);

	url_relative(relurl,referer,url);
	if( relurl[0] == 0 ) /* from the same server */
		strcpy(relurl,"=");
	else{
		char rproto[256],rhostport[256],rhost[256],rlogmap[256];
		int rport;
		Connection ConnR;

		if( sscanf(relurl,"%[^:]://%[^/]",rproto,rhostport) == 2 ){
			ConnR = *Conn;
			rport = scan_hostport(rproto,rhostport,rhost);
			set_realserver(&ConnR,rproto,rhost,rport);
			find_CMAP(&ConnR,"sendlog",rlogmap);
			Verbose("#### sendlog Referer map = [%s]\n",rlogmap);
			if( rlogmap[0] == 0 )
				strcpy(relurl,"-");
		}
	}
	return 1;
}

http_publiclog(Conn,rcode,ctype,rsize,mtime,request)
	Connection *Conn;
	char *ctype;
	char *request;
{	int code;
	char url[4096],buf[4096],myhp[256],proxytype,statch,sdate[16];
	char req[4096],*selector;
	extern char *TIMEFORM_ymdhms;
	char logmap[1024];
	char ctmajor[128],ctminor[128],sctype[32];
	char referer[4096],relurl[4096];

	find_CMAP(Conn,"sendlog",logmap);
	Verbose("#### sendlog map = [%s]\n",logmap);
	if( logmap[0] == 0 )
		return;

	code = (rcode % 1000) / 100;
	if( code == 2 || code == 3 ){
		selector = "xmit";
		wordscan(request,req);

		if( sscanf(ctype,"%[^/]/%s",ctmajor,ctminor) == 2 )
			sprintf(sctype,"%c/%c",ctmajor[0],ctminor[0]);
		else	strcpy(sctype,"-/-");

		HTTP_originalURL(Conn,url);
		strcpy(&url[sizeof(url)-3-256],"\r\n");

		if( strncmp(url,"/-_-",4) == 0 ){
			proxytype = 'd';
			strcpy(url,url+4);
		}else
		if( url[0] == '/' ){
			proxytype = '-';
			if( ImMaster )
				HostPort(myhp,DST_PROTO,DST_HOST,DST_PORT);
			else	ClientIF_HP(Conn,myhp);
			sprintf(buf,"http://%s%s",myhp,url);
			strcpy(url,buf);
		}else{
			proxytype = 'c';
		}
		statch = httpStat ? httpStat : '-';
		if( 0 < mtime )
			StrftimeGMT(sdate,sizeof(sdate),TIMEFORM_ymdhms,mtime);
		else	sprintf(sdate,"%012d",0);

		getReferer(Conn,request,url,referer,relurl);

		/*
		 * decode first, because it may be encoded in -_-URL case
		 */
		nonxalpha_unescape(url,url,0);
		logurl_escape(url,url);

		clear_publiclog();
		publiclog("P","%s.%s %s \"%s %s\" %d %d %s %c%c \"%s\"\r\n",
			logmap,selector,sdate,
				req,url,rcode,rsize,
				sctype,proxytype,statch,relurl);
	}
}

http_Log(Conn,rcode,rstat,req,size)
	Connection *Conn;
	char *req;
{	char *proto,*host;
	int port;
	char ctype[256];

	if( REAL_HOST[0] ){
		if( ToMyself && CLNT_PROTO[0] )
			proto = CLNT_PROTO;
		else	proto = REAL_PROTO;
		host = REAL_HOST;
		port = REAL_PORT;
	}else{
		if( CLNT_PROTO[0] )
			proto = CLNT_PROTO;
		else	proto = DFLT_PROTO;
		host = DFLT_HOST;
		port = DFLT_PORT;
	}
	httpStat = rstat;
	ctype[0] = 0;
	http_log(Conn,proto,host,port,req, rcode,ctype,size,0, 0.0,0.0);
}
