/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1997-1998 Electrotechnical Laboratry (ETL), AIST, MITI
Copyright (c) 1997-1998 Yutaka Sato

Permission to use, copy, and distribute this material for any purpose
and without fee is hereby granted, provided that the above copyright
notice and this permission notice appear in all copies.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	httphead.c
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	970708	extracted from httpd.c
//////////////////////////////////////////////////////////////////////#*/
#include "delegate.h"
#include "http.h"

extern char *findField();
extern char *findFieldValue();
extern char *fgetsHeaderField();
extern char *HTTP_getRequestField();
extern char *mount_url_to0();

#define FPRINTF		leng += Fprintf

extern char *strrpbrk();
static int LastModified = -1;
extern int MADE_TIME_data;
extern int START_TIME1;

static putMimeHeader(tc,type,encoding,size)
	FILE *tc;
	char *type,*encoding;
{	int leng = 0;

	FPRINTF(tc,"MIME-Version: %s\r\n",MY_MIMEVER);
	FPRINTF(tc,"Content-Type: %s\r\n",type);
	if( encoding != ME_7bit )
	FPRINTF(tc,"Content-Transfer-Encoding: %s\r\n",encoding);
	if( 0 < size )
	FPRINTF(tc,"Content-Length: %d\r\n",size);
	return leng;
}
static makeDeleGateHeader(head,iscache)
	char *head;
{
	sprintf(head,"DeleGate-Ver: %s (delay=%d)",
		DELEGATE_ver(),time(0)-START_TIME1);
	if( iscache )
		strcat(head," (from-cache)");
}
HTTP_putDeleGateHeader(Conn,tc,iscache)
	Connection *Conn;
	FILE *tc;
{	int leng = 0;
	char head[256];

	makeDeleGateHeader(head,iscache);
	FPRINTF(tc,"%s\r\n",head);
	leng += HTTP_echoRequestHeader(Conn,tc);
	return leng;
}

putHEAD(Conn,tc,code,reason,server,ctype,ccode,csize,mtime,expire)
	Connection *Conn;
	FILE *tc;
	char *reason,*server,*ctype,*ccode;
{	int leng;
	char date[128],serverb[128];

	if( ctype == NULL ) ctype = "text/html";
	if( ccode == NULL ) ccode = ME_7bit;
	StrftimeGMT(date,sizeof(date),TIMEFORM_RFC822,time(0));
	if( server == NULL ){
		server = serverb;
		sprintf(server,"DeleGate/%s",DELEGATE_ver());
	}
	FPRINTF(tc,"HTTP/%s %d %s\r\n",MY_HTTPVER,code,reason);
	leng = 0;
	leng += FPRINTF(tc,"Date: %s\r\n",date);
	leng += FPRINTF(tc,"Server: %s\r\n",server);
	leng += HTTP_putDeleGateHeader(Conn,tc,NULL);
	leng += putMimeHeader(tc,ctype,ccode,csize);

	if( mtime != -1 && mtime != 0 ){
		StrftimeGMT(date,sizeof(date),TIMEFORM_RFC822,mtime);
		FPRINTF(tc,"Last-Modified: %s\r\n",date);
	}
	if( expire != -1 && expire != 0 ){
		StrftimeGMT(date,sizeof(date),TIMEFORM_RFC822,expire);
		FPRINTF(tc,"Expires: %s\r\n",date);
	}

	if( csize <= 0 ){ /* && req != GET && resp != 304 */
		HTTP_clntClose(Conn,"U:unknown size internal response");
	}
	modifyConnection(Conn,csize);
	leng += putKeepAlive(Conn,tc);
	return leng;
}
genHEAD(Conn,tc,code,reason)
	Connection *Conn;
	FILE *tc;
	char *reason;
{	int leng;

	leng = putHEAD(Conn,tc,code,reason, NULL,NULL,NULL,0,-1,-1);
	return leng;
}

static char Status[128];
putHttpHeader1(Conn,tc,server,type,encoding,size,expire)
	Connection *Conn;
	FILE *tc;
	char *server,*type,*encoding;
{	int leng = 0;
	int code;
	char reason[2048];

	code = 200;
	strcpy(reason,"OK");
	if( Status[0] != 0 )
		sscanf(Status,"%d %[^\r\n]",&code,reason);

	leng = putHEAD(Conn,tc,code,reason,server,type,encoding,size,
		LastModified,expire);
	FPRINTF(tc,"\r\n");
	return leng;
}

putHttpHeaderV(Conn,tc,vno,server,type,encoding,size,lastmod,expire)
	Connection *Conn;
	FILE *tc;
	char *server,*type,*encoding;
{	int leng;
	int smod;

	if( vno < 100 )
		return 0;
	if( lastmod ){
		smod = LastModified;
		LastModified = lastmod;
	}
	leng = putHttpHeader1(Conn,tc,server,type,encoding,size,expire);
	if( lastmod )
		LastModified = smod;
	return leng;
}

putHttpHeaderX(Conn,tc,vno,server,type,encoding,size,lastmod,expire,status)
	Connection *Conn;
	FILE *tc;
	char *server,*type,*encoding;
	char *status;
{	int leng;

	strcpy(Status,status);
	leng =
	putHttpHeaderV(Conn,tc,vno,server,type,encoding,size,lastmod,expire);
	Status[0] = 0;
	return leng;
}

HTTP_putHeader(Conn,tc,vno,type,size,mtime)
	Connection *Conn;
	FILE *tc;
	char *type;
{	int smtime;
	int leng;

	if( vno < 100 ){
		sv1log("No header put: client is HTTP %d.%d\n",
			vno/100,vno%100);
		return 0;
	}

	smtime = LastModified;
	if( 0 < mtime )
		LastModified = mtime;
	else
	if( mtime == 0 )
		LastModified = MADE_TIME_data;
	else	LastModified = 0;
	leng = putHttpHeader1(Conn,tc,NULL,type,ME_7bit,size,0);
	LastModified = smtime;
	return leng;
}


static char httpConn[128];
setKeepAlive(Conn,timeout)
	Connection *Conn;
{
	if( 1 < CKA_RemAlive )
		sprintf(httpConn,"keep-alive, timeout=%d, maxreq=%d",
			timeout,CKA_RemAlive);
	else	strcpy(httpConn,"close");
}
HTTP_clntClose(Conn,fmt,a,b,c,d,e,f,g)
	Connection *Conn;
	char *fmt,*a,*b,*c,*d,*e,*f,*g;
{
	WillKeepAlive = 0;
	sprintf(WhyClosed,fmt,a,b,c,d,e,f,g);
	Verbose("HCKA:[%d] %s\n",RequestSerno,WhyClosed);
}
putKeepAlive(Conn,tc)
	Connection *Conn;
	FILE *tc;
{	int leng;
	char buff[256];

	if( leng = getKeepAlive(Conn,buff) )
		fputs(buff,tc);
	return leng;
}
getKeepAlive(Conn,KA)
	Connection *Conn;
	char *KA;
{
	KA[0] = 0;
	if( Conn != NULL && ClntKeepAlive ){
		if( WillKeepAlive )
			sprintf(KA,"%s: %s\r\n",ConnFname,httpConn);
		else	sprintf(KA,"%s: close\r\n",ConnFname);
		SentKeepAlive = WillKeepAlive;
		return strlen(KA);
	}else	return 0;
}

HTTP_relayCachedHeader(Conn,cache,tc)
	Connection *Conn;
	FILE *cache,*tc;
{	char line[1024],ver[1024],reason[1024];
	int lines;
	int total;

	total = 0;
	for(lines = 0;;lines++){
		if( fgets(line,sizeof(line),cache) == NULL )
			break;
		if( lines == 0 ){
			if( strncasecmp(line,"HTTP/",5) == 0 )
				continue;
			RespCode = decomp_httpstat(line,ver,reason);
		}
		if( strncasecmp(line,"Date:",5) == 0 ){
			strcpy(line,"Date: ");
			StrftimeGMT(line,sizeof(line),TIMEFORM_RFC822,time(0));
			strcat(line,"\r\n");
		}
		if( line[0] == '\r' || line[0] == '\n' )
			total += putKeepAlive(Conn,tc);

		total += strlen(line);
		fputs(line,tc);
		if( line[0] == '\r' || line[0] == '\n' )
			break;
	}
	return total;
}

HTTP_setHost(Conn,fields)
	Connection *Conn;
	char *fields;
{	char *ohostport,ohp[256],hostport[256],hostfield[256];

	if( GEN_VHOST[0] )
		strcpy(hostport,GEN_VHOST);
	else	HostPort(hostport,DST_PROTO,DST_HOST,DST_PORT);

	if( (ohostport = findFieldValue(fields,"Host")) == NULL ){
		sprintf(hostfield,"Host: %s\r\n",hostport);
		RFC822_addHeaderField(fields,hostfield);
	}else{
		/* replace it ... */
		/* if the request is for proxy (DONT_REWRITE, with full-URL) or
		 * if the field may be rewritten by MOUNT.
		 * (PointCast2.X clients send request including "Host: proxy")
		 */
		if( DONT_REWRITE || DO_DELEGATE || IsMounted ){
			wordscan(ohostport,ohp);
			if( strcmp(hostport,ohp) != 0 ){
				sv1log("XHost: (%d,%d,%d) %s <= %s\n",
					DONT_REWRITE,DO_DELEGATE,IsMounted,
					hostport,ohp);
				replace_line(ohostport,hostport);
			}else	Verbose("Host: %s <= %s\n",hostport,ohp);
		}
	}
}
HTTP_getHost(Conn,request,fields)
	Connection *Conn;
	char *request,*fields;
{	char *hostport,host[256],*url;
	int port;

	if( hostport = findFieldValue(fields,"Host") ){
		port = 80;
		sscanf(hostport,"%[^:\r\n]:%d",host,&port);
		set_realsite(Conn,"http",host,port);

		if( url = strpbrk(request," \t") ){
			while( *url == ' ' || *url == '\t' )
				url++;
			if( url[0] == '/' || url[0] == '*' )
				Verbose("Host: %s:%d\n",host,port);
		}
	}
}

static stripDeleGate(Conn,durl)
	Connection *Conn;
	char *durl;
{	char upath[URLSZ],mods[256],flags[256];
	char rproto[64],rhost[256],rhostport[256];
	char mupath[URLSZ];
	int rport;
	int rewritten = 0;

	while( *durl == ' ' || *durl == '\t' )
		durl++;

	if( *durl == '0' || *durl == '\r' || *durl == '\n' )
		return 0;

	if( toAnotherProxy(Conn,durl) )
		return 0;

	upath[0] = '/';
	decomp_absurl(durl,NULL,NULL,upath+1);
	strcpy(rproto,"http");

	if( url_derefer("http",upath,mods,flags,rproto,rhost,&rport) ){
		HostPort(rhostport,rproto,rhost,rport);
		sprintf(durl,"%s://%s%s",rproto,rhostport,upath);
		Verbose("STRIPPED: %s\n",durl);
		rewritten = 1;
	}else{
		decomp_absurl(durl,rproto,rhostport,NULL);
		rport = scan_hostport(rproto,rhostport,rhost);
	}


	if( !Ismyself(Conn,rproto,rhost,rport) )
		return rewritten;

	strcpy(mupath,upath);
	if( mount_url_to0(Conn->cl_myhp,REQ_METHOD,mupath) ){
		decomp_absurl(mupath,rproto,rhostport,NULL);
		rport = scan_hostport(rproto,rhostport,rhost);
		if( rport != DST_PORT )
			return;
		if( strcmp(rproto,DST_PROTO) != 0 )
			return;
		if( gethostintMin(rhost) != gethostintMin(DST_HOST) ) 
			return;
		strcpy(durl,mupath);
		Verbose("MOUNTED: %s\n",durl);
		rewritten = 1;
	}
	return rewritten;
}

/*
 * Referer URL should be rewritten to the real URL when it is relayed
 * to the server of the URL, so that it can be recognized at the server.
 * This is neccearry to let work some "URL access counters" embedded in 
 * a html text, which use the Referer as the target of the counter.
 */
MountReferer(Conn,fields)
	Connection *Conn;
	char *fields;
{	char *val,url[URLSZ];

	if( val = findFieldValue(fields,"Referer") ){
		linescan(val,url,sizeof(url));
		if( stripDeleGate(Conn,url) ){
			sv1log("rewritten Referer: %s\n",url);
			replace_line(val,url);
		}
	}
}

/* strip redundant http://myHost:myPort/ for rewriting in MOUNT */
static stripMyself(Conn,url)
	Connection *Conn;
	char *url;
{	char login[1024];

	if( url[0] != '/' && !toAnotherProxy(Conn,url)
	 && strncasecmp(url,"http://",7) == 0 ){
		strip_urlhead(url,REAL_PROTO,login);
		REAL_PORT = scan_hostport("http",login,REAL_HOST);
		sv1log("##stripped before MOUNT [%s:%d] %s",
			REAL_HOST,REAL_PORT,url);
	}
}

static opt1(opt,Conn)
	char *opt;
	Connection *Conn;
{
	if( strncasecmp(opt,"CHARCODE=",9) == 0 ){
		int leng;
		leng = CCXcreate("*",opt+9,CCX_TOCL);
		sv1log("#### CHARCODE=%s [%d]\n",opt+9,leng);
	}else
	if( strncasecmp(opt,"FTOCL=",6) == 0 ){
		scan_FTOCL(opt+6);
		sv1log("#### FTOCL=%s\n",opt+6);
	}else
	if( strcasecmp(opt,"AUTH=none") == 0 ){
		NoAuth = 1;
		sv1log("#### noauth for %s\n",REQ);
	}else
	if( strncasecmp(opt,"MASTER=",7) == 0 ){
		MO_MasterPort = scan_hostport("http",opt+7,MO_MasterHost);
	} else
	if( strncasecmp(opt,"PROXY=",6) == 0 ){
		MO_ProxyPort = scan_hostport("http",opt+6,MO_ProxyHost);
	}
	else
	if( strncasecmp(opt,"GENVHOST=",9) == 0 )
		strcpy(GEN_VHOST,opt+9);
	return 0;
}

static save_VHOST(Conn,url)
	Connection *Conn;
	char *url;
{	char myhp[256],*hostport,myhost[256],*port;

	OREQ_VHOST[0] = 0;

	if( url[0] == '/' )
	if( hostport = findFieldValue(OREQ_MSG,"Host") )
	if( sscanf(hostport,"%[^\r\n]",myhp) == 1 )
	if( sscanf(myhp,"%[^:]",myhost) )
	if( !ImMaster || IsMyself(myhost) ) /* req. directed to myself */
	{
		if( strchr(myhp,':') == NULL )
		    sprintf(myhp+strlen(myhp),":%d",serviceport(CLNT_PROTO));
		strcpy(OREQ_VHOST,myhp);
	}
}
HTTP_ClientIF_H(Conn,host)
	Connection *Conn;
	char *host;
{
	if( CurEnv && (DO_DELEGATE||IsMounted) && OREQ_VHOST[0] )
		return scan_hostport(DFLT_PROTO,OREQ_VHOST,host);
	else	return ClientIF_H(Conn,host);
}
HTTP_ClientIF_HP(Conn,hostport)
	Connection *Conn;
	char *hostport;
{
	if( CurEnv && (DO_DELEGATE||IsMounted) && OREQ_VHOST[0] )
		strcpy(hostport,OREQ_VHOST);
	else	ClientIF_HP(Conn,hostport);
}
extern char *iconURLbase();
char *HTTP_iconURLbase(Conn)
	Connection *Conn;
{
	if( CurEnv && (DO_DELEGATE||IsMounted) && OREQ_VHOST[0] ){
		sprintf(Conn->iconbase,"%s://%s",CLNT_PROTO,OREQ_VHOST);
		return Conn->iconbase;
	}else	return iconURLbase(Conn);
}

MountRequestURL(Conn,url)
	Connection *Conn;
	char *url;
{
	Verbose("ImMaster? %d <%s://%s:%d> <%s://%s:%d/>\n",
		ImMaster,
		DFLT_PROTO,DFLT_HOST,DFLT_PORT,
		REAL_PROTO,REAL_HOST,REAL_PORT);

	if( ImMaster && !Ismyself(Conn,DFLT_PROTO,DFLT_HOST,DFLT_PORT)){
		Verbose("DON'T MOUNT (ImMaster) %s://%s:%d%s",
			DFLT_PROTO,DFLT_HOST,DFLT_PORT,url);
	}else{
		char *opts;
		char proto[128];

		opts = NULL;
		save_VHOST(Conn,url);

		if( OREQ_VHOST[0] ){
			/* MOUNT "/path" request with "Host: hostname" applied
			 * conditionally by MOUNT="URL URL2 host=-hostname"
			 * ("-hostname" is regarded as a vertual host name)
			 */
			char myhp[256];
			sprintf(myhp,"-%s",OREQ_VHOST);
			opts = mount_url_to0(myhp,REQ_METHOD,url);
		}
		stripMyself(Conn,url);
		if( opts == NULL )
			opts = mount_url_to0(Conn->cl_myhp,REQ_METHOD,url);

		if( opts ){
			IsMounted = 1;
			sv1log("REQUEST +M %s",url);
			scan_commaList(opts,0,opt1,Conn);
			MountOptions = opts;

			proto[0] = 0;
			sscanf(url,"%[^:]",proto);
			Conn->no_dstcheck_proto = serviceport(proto);
		}
	}
}

replace_line(oval,val)
	char *oval,*val;
{	char *tp,tc,*sp,sc,*dp;

	for( tp = oval; tc = *tp; tp++ )
		if( tc == ';' || tc == '\r' || tc == '\n' )
			break;
	dp = oval;
	for( sp = val; sc = *sp; sp++ ){
		if( tp <= dp ){
			Strins(dp,sp);
			dp = NULL;
			break;
		}
		*dp++ = sc;
	}
	if( dp != NULL ){
		for( sp = tp; sc = *sp; sp++ )
			*dp++ = sc;
		*dp = 0;
	}
}

static getsetDomPath(value,domain,path,set)
	char *value,*domain,*path;
{	char *vp;
	int domset,pathset;

	if( !set )
		*domain = *path = 0;

	domset = pathset = 0;
	for( vp = value; *vp; vp++ ){
		if( strncasecmp(vp,"DOMAIN=",7) == 0 ){
			domset = 1;
			if( set )
				replace_line(vp+7,domain);
			else	sscanf(vp+7,"%[^;\r\n]",domain);
		}else
		if( strncasecmp(vp,"PATH=",5) == 0 ){
			pathset = 1;
			if( set )
				replace_line(vp+5,path);
			else	sscanf(vp+5,"%[^;\r\n]",path);
		}
	}
	return domset || pathset;
}
static rewriteCookie(value,url)
	char *value,*url;
{	char proto[128],login[1024],path[1024],opath[1024],*dp;

	decomp_absurl(url,proto,login,path);
	if( dp = strchr(login,':') )
		*dp = 0;
	sprintf(opath,"/%s",path);
	getsetDomPath(value,login,opath,1);
	sv1log("Cookie >%s",value);
}
MountCookieRequest(Conn,request,value)
	Connection *Conn;
	char *request,*value;
{	char proto[128],login[1024],domain[1024],path[1024],*dp;
	char opath[1024],url[URLSZ];

	sv1log("Cookie: %s",value);
/*
	HTTP_originalURLPath(Conn,opath);
	if( !getsetDomPath(value,domain,opath,0) )
		return;

	strcpy(url,opath);
	if( mount_url_to0(Conn->cl_myhp,REQ_METHOD,url) )
		rewriteCookie(value,url);
*/
}
MountCookieResponse(Conn,request,value)
	Connection *Conn;
	char *request,*value;
{	char dom[1024],proto[128],login[1024],myhp[1024];
	char opath[1024],url[URLSZ];

	sv1log("Set-Cookie: %s",value);

	HTTP_originalURLPath(Conn,opath);
	if( !getsetDomPath(value,dom,opath,0) )
		return;

	HTTP_ClientIF_HP(Conn,myhp);
	HostPort(login,DST_PROTO,DST_HOST,DST_PORT);
	if( opath[0] == '/' )
		strcpy(opath,opath+1);

	if( mount_url_fromL(url,DST_PROTO,login,opath,NULL,"http",myhp) )
		rewriteCookie(value,url);
}
toAnotherProxy(Conn,url)
	Connection *Conn;
	char *url;
{	char proto[256],hostport[256],host[1024];
	int port;

	if( strncasecmp(url,"http://",7) != 0 )
		return 0;

	scan_protosite(url,proto,hostport);
	port = scan_hostport(proto,hostport,host);

	if( Ismyself(Conn,proto,host,port) )
		return 0;

	return 1;
}
url_deproxy(Conn,req,url,Rproto,Rhost,Riportp)
	Connection *Conn;
	char *req,*url,*Rproto,*Rhost;
	int *Riportp;
{	char *dp;
	char ruser[256],rhostport[256],rproto[256],rhost[256];
	char tmp[256];
	int riport;

	if( url[0] == '/' )
		return 0;

	/*
	 *	get "rproto","rhostport" and strip them out from "url"
	 */
	if( dp = strstr(url,"://") ){
		if( scan_protosite(url,rproto,rhostport) != 2 )
			return 0;

		if( rproto[0] == '/' ) /* maybe /-_- */
			return 0;

		if( strcaseeq(rproto,"opher") ){
			/* might be generated in buggy Mosaic ;-) */
			sv1log("Repaired-PROTO: %s to gopher\n",rproto);
			strcpy(rproto,"gopher");
		}
		strcpy(url,dp+3+strlen(rhostport));
	}else{
		sscanf(url,"%[^:]",rproto);
		if( localPathProto(rproto) ){
			strcpy(rhostport,"localhost");
			*(dp = strchr(url,':')) = 0;
			strcpy(rproto,url);
			strcpy(url,dp+1);
		}else	return 0;
	}

	riport = 0;
	if( dp = strchr(rhostport,'@') ){
		strcpy(ruser,"(empty-username)");
		strcpy(tmp,"(empty-hostname)");
		sscanf(rhostport,"%[^@]@%[^:]:%d",ruser,tmp,&riport);
		sprintf(rhost,"%s@%s",ruser,tmp);
	}else	sscanf(rhostport,"%[^:]:%d",rhost,&riport);
	if( riport == 0 )
		riport = serviceport(rproto);

	if( url[0]==' ' && url[1]=='/' ){
		/* might be generated in buggy Mosaic ;-) */
		strcpy(url,url+1);
		sv1log("Repaired-URL: %s",req);
	}
	if( strcaseeq(rproto,"gopher") ){
		if( req[0] == '/' && req[1] != '\r' ){
			sprintf(tmp,"(:%c:)",req[1]);
			strcpy(req,req+2);
			Strins(req,tmp);
		}
	}
	if( strcaseeq(rproto,"http") )
	if( Ismyself(Conn,rproto,rhost,riport) ){
		set_realsite(Conn,rproto,rhost,riport);
		sv1log("##strip myself [%s:%d]\n",rhost,riport);
		ToMyself = 1;
		return 0;
	}

	if( Rhost[0] != 0 ){
		sprintf(tmp,"%s://%s:%d",Rproto,Rhost,*Riportp);
		Strins(url,tmp);
		strcpy(REMOTE_PROTO,Rproto);
		strcpy(REMOTE_HOST,Rhost);
		REMOTE_PORT = *Riportp;
		HostPort(tmp,"http",rhost,riport);
		scan_DELEGATE(Conn,tmp);
		DONT_REWRITE = 0;
	}
	strcpy(Rproto,rproto);
	strcpy(Rhost,rhost);
	*Riportp = riport;

	if( localPathProto(rproto) )
		if( streq(rhost,"localhost") || rhost[0] == 0 )
			ToMyself = 1;

	return 1;
}

HTTP_genVia(Conn,isreq,via)
	Connection *Conn;
	char *via;
{	char host[256],uname[256],myid[256];

	makeVia(Conn,host);
	sprintf(myid,"DeleGate/%s",DELEGATE_ver());

	if( Uname(uname) == 0 )
	if( NotifyPlatform(Conn,isreq) )
		sprintf(myid+strlen(myid)," on %s",uname);
	sprintf(via,"%s %s (%s)",MY_HTTPVER,host,myid);
}
FTPHTTP_genPass(pass)
	char *pass;
{
	sprintf(pass,"%s(FTP/HTTP-DeleGate/%s)",
		DELEGATE_MANAGER,DELEGATE_ver());
}

HTTP_selfExpired(cachefp)
	FILE *cachefp;
{	int expired;
	char *found,sdate[256];
	char pragma[256];
	int expires,now;

	if( cachefp == NULL )
		return 0;

	expired = 0;
	found = fgetsHeaderField(cachefp,"Pragma",pragma,sizeof(pragma));
	if( found != NULL && strstr(pragma,"no-cache") ){
		sv1log("EXPIRES: Pragma: %s\n",pragma);
		return 1;
	}

	found = fgetsHeaderField(cachefp,"Expires",sdate,sizeof(sdate));
	if( found != NULL ){
		now = time(0);
		expires = scanHTTPtime(sdate);
		if( expires <= now )
			expired = 1;
		sv1log("EXPIRES: %d > %d ? %s\n",now,expires,sdate);
	}
	return expired;
}
HTTP_ContLengOk(cachefp)
	FILE *cachefp;
{	char Leng[128];
	int ok,off,leng,hsize,bsize;

	if( cachefp == NULL )
		return 0;

	ok = 0;
	off = ftell(cachefp);
	if( fgetsHeaderField(cachefp,"Content-Length",Leng,sizeof(Leng)) ){
		leng = atoi(Leng);
		RFC821_skipheader(cachefp,NULL,NULL);
		hsize = ftell(cachefp);
		fseek(cachefp,0,2);
		bsize = ftell(cachefp) - hsize;
		if( bsize == leng )
			ok = 1;
		else	sv1log("#### wrong Content-Length: %d -> %d\n",
				leng,bsize);
	}
	fseek(cachefp,off,0);
	return ok;
}
HTTP_getLastModInCache(scdate,size,cachefp,cpath)
	char *scdate;
	FILE *cachefp;
	char *cpath;
{	FILE *hfp;
	int off;
	char *found;

	off = -1;

	if( cachefp ){
		off = ftell(cachefp);
		fseek(cachefp,0,0);
		hfp = cachefp;
	}else	hfp = fopen(cpath,"r");

	if( hfp != NULL ){
		found = fgetsHeaderField(hfp,"Last-Modified",scdate,size);
		if( hfp == cachefp )
			fseek(cachefp,off,0);
		else	fclose(hfp);

		if( found != NULL ){
			Verbose("original Last-Modified: %s\n",scdate);
			return scantime(scdate,NULL);
		}
	}
	return 0;
}
HTTP_genLastMod(scdate,size,cachefp,cpath)
	char *scdate;
	FILE *cachefp;
	char *cpath;
{	int ncdate;

	if( cachefp )
		ncdate = file_mtime(fileno(cachefp));
	else	ncdate = File_mtime(cpath);

	StrftimeGMT(scdate,size,TIMEFORM_RFC822,ncdate);
	sv1log("generated Last-Modified[%x]: %s\n",cachefp,scdate);
	return ncdate;
}
HTTP_getLastMod(scdate,size,cachefp,cpath)
	char *scdate;
	FILE *cachefp;
	char *cpath;
{	int ncdate;

	if( ncdate = HTTP_getLastModInCache(scdate,size,cachefp,cpath) )
		return ncdate;
	else	return HTTP_genLastMod(scdate,size,cachefp,cpath);
}


HTTP_forgedAuthorization(Conn,fields)
	Connection *Conn;
	char *fields;
{	char *auth,atype[128],aval[256],*dp,buf[256],host[128];

	auth = findFieldValue(fields,"Authorization");
	if( auth == 0 )
		return 0;

	sscanf(auth,"%s %s",atype,aval);
	str_from64(aval,strlen(aval),buf,sizeof(buf));

	if( dp = strrchr(buf,'/') ){
		gethostname(host,sizeof(host));
		if( strcmp(dp+1,host) == 0 ){
			sv1log("!!!! FORGED Authorization !!!!! [%s]\n",buf);
			return 1;
		}
	}

	return 0;
}
HTTP_getAuthorization(Conn,proxy,ohost,ahost,auser,apass)
	Connection *Conn;
	char *ohost,*ahost,*auser,*apass;
{	char atype[128],auth[1024],cookie[1024],dauth[1024];
	char *field;

	auser[0] = apass[0] = 0;
	auth[0] = 0;
	if( proxy )
		field = "Proxy-Authorization";
	else	field = "Authorization";
	HTTP_getRequestField(Conn,field,auth,sizeof(auth));

	if( auth[0] != 0 && 1 < sscanf(auth,"%s %[^\r\n]",atype,cookie) ){
		str_from64(cookie,strlen(cookie),dauth,sizeof(dauth));
		if( ahost != NULL ){
			ahost[0] = 0;
			if( sscanf(dauth,"%[^@]@%[^:]:%[^\r\n]",auser,ahost,apass) < 2 ){
				sscanf(dauth,"%[^:]:%[^\r\n]",auser,apass);
				strcpy(ahost,ohost);
			}
		}else{
			sscanf(dauth,"%[^:]:%[^\r\n]",auser,apass);
		}
		return 1;
	}
	return 0;
}
HTTP_decodeAuthorization(auth,atype,userpass) 
	char *auth,*atype,*userpass;
{	char body[512];


	atype[0] = userpass[0] = 0;
	if( sscanf(auth,"%s %[^\r\n]",atype,body) ){
		str_from64(body,strlen(body),userpass,512);
		return 1;
	}
	return 0;
}
HTTP_proxyAuthorized(Conn,req,fields,pauth,tc)
	Connection *Conn;
	char *req,*fields;
	FILE *tc;
{	char auser[256],apass[256];
	char host[256],user[256];
	int vno,totalc;

	if( HTTP_getAuthorization(Conn,pauth,"",NULL,auser,apass) ){
		user[0] = host[0] = 0;
		sscanf(auser,"%[^@]@%s",user,host);
		if( user[0] != 0 ){
			if( host[0] == 0 )
				gethostname(host,sizeof(host));

			strcpy(Conn->cl_auth_host,host);
			strcpy(Conn->cl_auth_user,user);

			if( service_permitted2(Conn,DST_PROTO,1) ){
				if( 0 <= Authenticate(Conn,host,user,apass,"/") )
					return 1;
			}
			Conn->cl_auth_user[0] = 0;
		}
		sv1log("Not Authorized: user=[%s]\n",auser);
	}else	sv1log("No Authorization\n");
	return 0;
}


ClientIfModClock(Conn)
	Connection *Conn;
{
	return	ClntIfModClock;
}

char *HTTP_originalRequest(Conn,req)
	Connection *Conn;
	char *req;
{
	if( OREQ[0] )
		sscanf(OREQ,"%[^\r\n]",req);
	else	req[0] = 0;
	return req;
}
HTTP_originalURL(Conn,url)
	Connection *Conn;
	char *url;
{
	url[0] = 0;
	if( OREQ[0] )
		return scan_http_request(OREQ,NULL,url,NULL);
	else	return 0;
}
HTTP_originalURLPath(Conn,path)
	Connection *Conn;
	char *path;
{	char url[URLSZ];

	if( HTTP_originalURL(Conn,url) ){
		if( url[0] != '/' )
			strip_urlhead(url,NULL,NULL);

		if( url[0] == '/' && url[1] != '/' ){
			sscanf(url,"%s",path);
			return 1;
		}
	}
	path[0] = 0;
	return 0;
}
HTTP_originalURLmatch(Conn,urlc)
	Connection *Conn;
	char *urlc;
{	char *url;
	int leng;

	if( OREQ[0] ){
		leng = strlen(urlc);
		if( url = strpbrk(OREQ," \t") ){
			while( *url == ' ' || *url == '\t' )
				url++;
			if( strncmp(url,urlc,leng) == 0 )
			if( url[leng] == 0 || strchr(" \t\r\n",url[leng]) )
				return 1;
		}
	}
	return 0;
}
HTTP_getSelfURL(Conn,url)
	Connection *Conn;
	char *url;
{	char purl[URLSZ],hostport[256];

	*url = 0;
	if( CurEnv == NULL || REQ == NULL )
		return 0;

	scan_http_request(REQ,NULL,purl,NULL);
	HostPort(hostport,DST_PROTO,DST_HOST,DST_PORT);
	if( streq(DST_PROTO,"news") )
		sprintf(url,"%s:%s",DST_PROTO,purl);
	else	sprintf(url,"%s://%s%s",DST_PROTO,hostport,purl);
	return strlen(url);
}
static getModifier(Conn,mod)
	Connection *Conn;
	char *mod;
{	
	if( mod )
		strcpy(mod,Modifier);
	return strlen(Modifier);
}
HTTP_echoRequestHeader(Conn,tc)
	Connection *Conn;
	FILE *tc;
{	char *sp,ch;
	int leng = 0;
	char modifiers[512];

	if( !EchoRequest )
		return 0;
	if( !CurEnv )
		return 0;
	if( !HTTP_reqWithHeader(Conn,REQ) )
		return 0;

	fputs("X-Request-Original: ",tc);
	fputs(OREQ,tc);
	if( strstr(OREQ,"\n") == NULL )
		fputs("\r\n",tc);

	if( getModifier(Conn,modifiers) )
		fprintf(tc,"X-Modifier: %s\r\n",modifiers);

	fputs("X-Request: ",tc);
	fputs(REQ,tc);
	leng += strlen("X-Request: ") + strlen(REQ);

	sp = REQ_FIELDS;
	while( ch = *sp ){
		if( ch == '\r' || ch == '\n' )
			break;
		fputs("X-Request-",tc);
		leng += strlen("X-Request-");

		while( ch = *sp ){
			sp++;
			putc(ch,tc);
			leng++;
			if( ch == '\n' && !(*sp == ' ' || *sp == '\t') )
				break;
		}
	}
	return leng;
}
originalHost(Conn,host)
	char *host;
{
}
char *HTTP_originalRequestField(Conn,fname,buff,bsize)
	Connection *Conn;
	char *fname,*buff;
{	char *ffname,*ffbody;

	buff[0] = 0;
	if( CurEnv ){
		if( ffname = findField(OREQ_MSG,fname,&ffbody) ){
			linescan(ffbody,buff,bsize);
			return buff;
		}
	}
	return 0;
}
char *HTTP_getRequestField(Conn,fname,buff,bsize)
	Connection *Conn;
	char *fname,*buff;
{	char *ffname,*ffbody;

	buff[0] = 0;
	if( CurEnv == 0 )
		return 0;

	if( strcmp(fname,"*") == 0 ){
		Strncpy(buff,CurEnv->r_fields,bsize);
		return buff;
	}
	if( CurEnv->r_lastFname ){
		char *lfname;
		int fnlen;
		lfname = CurEnv->r_lastFname;
		fnlen = strlen(fname);

		/* BUG: this header cache should be cleared when
		 * the header buffer is modified ...
		 */
		if( strncasecmp(lfname,fname,fnlen) == 0 )
		if( lfname[fnlen] == ':' && lfname[fnlen+1] == ' ' )
		if( &lfname[fnlen+2] == CurEnv->r_lastFbody ){
			linescan(CurEnv->r_lastFbody,buff,bsize);
			return buff;
		}
	}
	if( ffname = findField(CurEnv->r_fields,fname,&ffbody) ){
		linescan(ffbody,buff,bsize);
		CurEnv->r_lastFname = ffname;
		CurEnv->r_lastFbody = ffbody;
		return buff;
	}
	return 0;
}
HTTP_delRequestField(Conn,fname)
	Connection *Conn;
	char *fname;
{
	rmField(REQ_FIELDS,fname);
	CurEnv->r_lastFname = NULL;
}
HTTP_putRequest(Conn,fp)
	Connection *Conn;
	FILE *fp;
{	int len = 0;

	if( CurEnv == 0 )
		return 0;

	len += strlen(CurEnv->r_req);
	fputs(CurEnv->r_req,fp);
	len += strlen(CurEnv->r_fields);
	fputs(CurEnv->r_fields,fp);
	return len;
}
HTTP_scanAcceptCharcode(Conn,field)
	Connection *Conn;
	char *field;
{	char *pp,*vp,*dp;
	char code[256];
	char *value;
	char orgval[256],remmark[256];

	remmark[0] = 0;

	if( value = strchr(field,':') ){
		value++;
		while( *value == ' ' || *value == '\t' )
			value++;
		if( *value == 0 || *value == '\r' || *value == '\n' )
			return;
	}else	return;

	orgval[0] = 0;
	linescan(value,orgval,sizeof(orgval));

	while( pp = strstr(value,"(pragma=") ){
		strcat(remmark,"#"); /* indicate stuff removed */
		vp = pp + 8;
		if( strstr(vp,"thru)") == vp )
			RelayTHRU = 1;
		else
		if( strstr(vp,"no-cache)") == vp ){
			DontReadCache = 1;
			DontWriteCache = 1;
		}
		if( dp = strchr(pp,')') )
			strcpy(pp,dp+1);
		else	break;
	}

	if( pp = strstr(value,"charcode") ){
		strcat(remmark,"#"); /* indicate stuff removed */
		sscanf(pp,"charcode=%[-0-9a-zA-Z/]",code);
		sv1log("HTTP charcode=%s\n",code);
		scan_CHARCODE(Conn,code);
		dp = pp+strlen("charcode")+1+strlen(code);
		if( *dp == ';' )
			dp++;
		strcpy(pp,dp);
	}
	while( pp = strstr(value,"()") )
		strcpy(pp,pp+2);
	if( strncmp(value,"()",2) == 0 )
		value += 2;

	if( *value == 0 || *value == '\r' || *value == '\n' )
		*field = 0;

	if( AcceptLanguages ){
		if( AcceptLanguages[0] != 0 ) 
			strcat(AcceptLanguages,", ");
		strcat(AcceptLanguages,orgval);
		if( remmark[0] )
			strcat(AcceptLanguages,remmark);
	}
}


extern char *HTTP_methods[];
HTTP_isMethod(method)
	char *method;
{	int mi;
	char *m1,*mp,mc;

	for( mi = 0; m1 = HTTP_methods[mi]; mi++ ){
		mp = method;
		while( *m1 && *mp == *m1 ){
			mp++;
			m1++;
		}
		if( *m1 == 0 ){
			mc = *mp;
			if( mc==0||mc==' '||mc=='\t'||mc=='\r'||mc=='\n' )
				return 1;
		}
	}
	return 0;
}
HTTP_methodWithoutBody(method)
	char *method;
{
	return strcasecmp(method,"GET")==0 || strcasecmp(method,"HEAD")==0;
}

setHTTPenv(Conn,he)
	Connection *Conn;
	HTTP_env *he;
{
	Conn->cl_reqbuf = (void*)he;
	if( he == NULL )
		return;
	Conn->cl_reqbufsize = sizeof(HTTP_env);

	he->r_oreqlen = 0;
	he->r_oreq[0] = 0;
	he->r_ohost[0] = 0;
	he->r_oport = 0;

	he->r_req[0] = 0;
	he->r_method[0] = 0;
	he->r_url[0] = 0;
	he->r_ver[0] = 0;
	he->r_vno = 0;

	he->r_fields[0] = 0;
	he->r_lastFname = 0;
	he->r_lastFbody = 0;

	he->r_acclangs[0] = 0;

	he->r_clntIfmod[0] = 0;
	he->r_clntIfmodClock = 0;

	he->r_flushhead = 0;
	he->r_flushsmall = 0;

	he->r_code = 0;
	he->r_status[0] = 0;
	he->r_resplen = 0;
	he->r_respsav = 0;
}
HTTP_decompRequest(Conn)
	Connection *Conn;
{
	REQ_VNO = scan_http_request(REQ,REQ_METHOD,REQ_URL,REQ_VER);
	return REQ_VNO;
}
scan_http_request(req,method,arg,ver)
	char *req,*method,*arg,*ver;
{	char *dp;
	char *tp;
	char *vp;
	int vmaj,vmin;

/*
fprintf(stderr,"#### scan_http_request(%x,%x,%x):%s\n",method,arg,ver,req);
*/

	if( (dp = strpbrk(req," \t")) == NULL )
		return 0;

	if( !HTTP_isMethod(req) )
		return 0;

	if( method )
		wordscan(req,method);

	vmaj = 0;
	vmin = 9;
	while( *dp == ' ' || *dp == '\t' )
		dp++;

	if( arg ){
		strcpy(arg,dp);
		if( tp = strpbrk(arg,"\r\n") )
			*tp = 0;
		if( tp = strrpbrk(arg," \t") )
			*tp = 0;
	}
	if( vp = strpbrk(dp," \t") ){
		while( *vp == ' ' || *vp == '\t' )
			vp++;
		if( strncmp(vp,"HTTP/",5) == 0 )
			sscanf(vp+5,"%d.%d",&vmaj,&vmin);
	}
	if( ver )
		sprintf(ver,"%d.%d",vmaj,vmin);

	return (vmaj*100 + vmin);
}
HTTP_reqIsHTTP(Conn,req)
	Connection *Conn;
	char *req;
{	int vno;

	if( CurEnv == NULL || req != REQ )
		return HTTP_isMethod(req);
	else
	if( REQ_VNO != 0 )
		return REQ_VNO;
	else	return REQ_VNO = scan_http_request(req,0,0,0);
}
HTTP_reqWithHeader(Conn,req)
	Connection *Conn;
	char *req;
{
	if( CurEnv == NULL || req != REQ )
		return 100 <= scan_http_request(req,0,0,0);
	else	return 100 <= HTTP_reqIsHTTP(Conn,REQ);
}
/*
static replace_url(req,urlfmt)
	char *req,*urlfmt;
{	char method[128],ver[128];
	int vno;
	char ourl[URLSZ],nurl[URLSZ];

	vno = scan_http_request(req,method,ourl,ver);
	trans_url(nurl,ourl,urlfmt);
	sprintf(req,"%s %s",method,nurl);
	if( 100 <= vno ){
		strcat(req," HTTP/");
		strcat(req,ver);
	}
	strcat(req,"\r\n");
}
*/


MovedToSelf(Conn,line)
	Connection *Conn;
	char *line;
{	char base[URLSZ],moved[URLSZ];

	if( HTTP_originalURL(Conn,base) && strstr(base,":") )
	if( sscanf(line,"%*[^:]: %s",moved) ){
		if( streq(base,moved) )
			return 1;

		/* should check IP-address and HOST-name matching ... */
	}
	return 0;
}
MovedToAnotherServer(Conn,line)
	Connection *Conn;
	char *line;
{	char movedto[URLSZ];
	char proto[128],host[256];
	int port;

	movedto[0] = 0;
	sscanf(line,"%*s %[^ \t\r\n]",movedto);
	port = scan_urlhead(movedto,proto,host);

	if( strcasecmp(proto,DST_PROTO) == 0 && port == DST_PORT ){
		if( strcasecmp(host,DST_HOST) == 0 
		 || gethostintMin(host) == gethostintMin(DST_HOST) )
			return 0;
	}
	sv1log("Moved to another server [%s://%s:%d] -> [%s://%s:%d]\n",
		DST_PROTO,DST_HOST,DST_PORT,proto,host,port);
	return 1;
}

HTTP_getICPurl(Conn,url)
	Connection *Conn;
	char *url;
{	char hostport[256],*upath;
	int ulen;

	if( strcmp(iSERVER_PROTO,"http") != 0 )
		return -1;

	if( strncasecmp(REQ,"GET ",4) != 0
	 /* && strncasecmp(REQ,"HEAD ",5) != 0 */ )
	{
		return -1;
	}

	upath = strchr(REQ,' ');
	if( upath == NULL ){
		return -1;
	}
	if( 256 < strlen(upath) ){
		return -1;
	}
	if( strchr(REQ,'?') ){
		return -1;
	}

	upath++;
	if( *upath == '/' || strchr(" \t\r\n",*upath) ){
		upath++;
		HostPort(hostport,DST_PROTO,DST_HOST,DST_PORT);
		sprintf(url,"%s://%s/",DST_PROTO,hostport);
		if( strchr(" \t\r\n",*upath) == NULL ){
			ulen = strlen(url);
			wordscan2(upath,url+ulen,256);
		}
	}else{
		wordscan2(upath,url,256);
	}
	return 0;
}
