/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1994 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, modify, and distribute this material for any
purpose and without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies, and
that the name of ETL not be used in advertising or publicity pertaining
to this material without the specific, prior written permission of an
authorized representative of ETL.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	httpd.c
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	941009	extracted from http.c
//////////////////////////////////////////////////////////////////////#*/
#include "delegate.h"
#include "http.h"

#define ME_7bit		((char*)0)
#define ME_binary	"binary"

static char *home_page = "/-/";
static char *cntl_base = "/-/manage/";
static char *cgi_base = "/-/cgi/";
static char *icon_base = "/-/builtin/icons/";
static char *mssg_base = "/-/builtin/mssgs/";
static char *bench_base = "/-/bench/";
static char *data_base = "/-/data:";
#define icon_relative	(icon_base+3)
#define FPRINTF		leng += Fprintf

extern int MADE_TIME_data;
extern int ClientIfModClock();	/* -1 if not specified */
extern FILE *openHttpResponseFilter();
extern char *HTTP_getRequestField();
extern FILE *TMPFILE();
extern char *HTTP_originalRequest();
extern char *strcasestr();
extern char *start_time();

localPathProto(proto)
	char *proto;
{
	if( streq(proto,"file") ) return 1;
	if( streq(proto,"proc") ) return 1;
	if( streq(proto,"cgi" ) ) return 1;
	if( streq(proto,"cfi" ) ) return 1;
	return 0;
}

static toMyself(Conn)
	Connection *Conn;
{
	if( localPathProto(DST_PROTO) )
		if( strcmp(DST_HOST,"localhost") == 0 )
			return 1;
	return 0;
}

extern char *HTTP_iconURLbase();
static char *getIconBase(Conn)
	Connection *Conn;
{	static char baseb[256];

	sprintf(baseb,"%s%s",HTTP_iconURLbase(Conn),icon_base);
	return baseb;
}
static putFrogInline(Conn,tc,align,trans,body)
	Connection *Conn;
	FILE *tc;
	char *align;
{	char *icon;
	char iurl[1024];

	if( body )
		if( trans )
			icon = "ysato/frogTrans.gif";
		else	icon = "ysato/frog.gif";
	else	icon = "ysato/frogHead.gif";

	sprintf(iurl,"%s%s",getIconBase(Conn),icon);
	return Fprintf(tc,"<IMG ALT=\"@_@\" ALIGN=%s BORDER=0 SRC=%s>",
		align,iurl);
}
putDeleGateInline(Conn,tc,align)
	Connection *Conn;
	FILE *tc;
	char *align;
{
	return Fprintf(tc,"<IMG ALT=\"@_@\" ALIGN=%s SRC=%s%s>",
		align,getIconBase(Conn),"ysato/DeleGateLogoTrans.gif");
}

char *getCERNiconBase(Conn,base)
	Connection *Conn;
	char *base;
{
	sprintf(base,"%s%s",getIconBase(Conn),"cern/");
	return base;
}

static flushLinger(tc)
	FILE *tc;
{
	fflush(tc);
	set_linger(fileno(tc),DELEGATE_LINGER);
}

static putDescription(Conn,tc)
	Connection *Conn;
	FILE *tc;
{	char *distrib,*DELEGATE_Distribution();
	char *DELEGATE_homepage();
	char rurl[256];
	int leng = 0;

	FPRINTF(tc,"<UL>\n");
	distrib = DELEGATE_homepage();
	redirect_url(Conn,distrib,rurl);
	FPRINTF(tc,"<LI> The home page of DeleGate is at <A HREF=%s>%s</A>\n",
		rurl,distrib);
	distrib = DELEGATE_Distribution();
	redirect_url(Conn,distrib,rurl);
	FPRINTF(tc,"<LI> The latest DeleGate is at <A HREF=%s>%s</A>\n",
		rurl,distrib);
	redirect_url(Conn,getIconBase(Conn),rurl);
	FPRINTF(tc,"<LI> CERN's <A HREF=%s>icons</A> in public domain are built-in.\n",
		rurl);
	FPRINTF(tc,"</UL>\n");
	return leng;
}
printHTTPmessage(fp,msg)
	FILE *fp;
	char *msg;
{	char *mp,*np,line[1024],name[1024],type[1024];

	for( mp = msg; *mp; mp = np ){
		linescan(mp,line,sizeof(line));
		if( strncasecmp(mp,"Proxy-Authorization",19)==0
		 || strncasecmp(mp,"Authorization",13)==0 ){
			name[0] = type[0] = 0;
			sscanf(line,"%s %s",name,type);
			sprintf(line,"%s %s ******",name,type);
		}
		fputs(line,fp);
		fputs("\r\n",fp);
		if( np = strchr(mp,'\n') )
			np++;
		else	break;
	}
}

extern int TOTAL_SERVED;
static printItem(Conn,fp,fmt,name,arg)
        Connection *Conn;
        FILE *fp;
        char *fmt,*name,*arg;
{	char hostport[256],stime[128];
	char url[1024];

	if( streq(name,"ver") ){
		fputs(DELEGATE_ver(),fp);
	}else
	if( streq(name,"verdate") ){
		fprintf(fp,"%s",DELEGATE_verdate());
	}else
	if( streq(name,"Version") ){
		fputs(DELEGATE_Version(),fp);
	}else
	if( streq(name,"copyright") ){
		fputs(DELEGATE_copyright(),fp);
	}else
	if( streq(name,"homepage") ){
		fputs(DELEGATE_homepage(),fp);
	}else
	if( streq(name,"Description") ){
		putDescription(Conn,fp);
	}else
	if( streq(name,"icon") ){
		if( streq(arg,"delegate") )
			fprintf(fp,"%s%s", getIconBase(Conn),
				"ysato/DeleGateLogoTrans.gif");
		else
		if( streq(arg,"frog") )
			fprintf(fp,"%s%s", getIconBase(Conn),
				"ysato/frog.gif");
		else
		if( streq(arg,"froghead") )
			fprintf(fp,"%s%s", getIconBase(Conn),
				"ysato/frogHead.gif");
	}else
	if( streq(name,"time") ){
		if( streq(arg,"now") ){
			StrftimeLocal(stime,sizeof(stime),
				TIMEFORM_HTTPD,time(0));
			fputs(stime,fp);
		}else
		if( streq(arg,"start") )
			fputs(start_time(),fp);
	}else
	if( streq(name,"num") ){
		if( streq(arg,"serno") )
			fprintf(fp,"%d",SERNO());
		else
		if( streq(arg,"peers") )
			fprintf(fp,"%d",alive_peers());
		else
		if( streq(arg,"served") )
			fprintf(fp,"%d",TOTAL_SERVED);
	}else
	if( streq(name,"host") ){
		if( streq(arg,"clif") ){
			ClientIF_name(Conn,FromC,hostport);
			fputs(hostport,fp);
		}
	}else
	if( streq(name,"hostport") ){
		if( streq(arg,"client") ){
			getpeerName(Conn->cl_sock,hostport,PN_HOSTPORT);
			fputs(hostport,fp);
		}else
		if( streq(arg,"clif") ){
			ClientIF_HP(Conn,hostport);
			fputs(hostport,fp);
		}
	}else
	if( streq(name,"request") ){
		if( streq(arg,"mssg") )
			printHTTPmessage(fp,OREQ_MSG);
	}else
	if( streq(name,"server") ){
		if( streq(arg,"name") )
			fputs(D_SERVER,fp);
		else
		if( streq(arg,"host") )
			fputs(DST_HOST,fp);
		else
		if( streq(arg,"port") )
			fprintf(fp,"%d",DST_PORT);
		else
		if( streq(arg,"url") ){
			redirect_url(Conn,D_SERVER,url);
			fputs(url,fp);
		}
	}else
	if( streq(name,"expire") )
		fprintf(fp,"%d",http_EXPIRE(Conn));
	else
	if( streq(name,"getccx") ){
		char code[128];
		if( cur_codeconvCL(code) )
			return 1;
		else	return 0;
	}else
	if( streq(name,"setccx") ){
		char code[128],stat[128];
		if( cur_codeconvCL(code) ){
			global_setCCX(Conn,code,stat);
			fprintf(fp,"\"%s\" %s",code,stat);
		}
	}else
	if( streq(name,"codeconv") ){
		char cvenv[128];
		cur_codeconvCL(cvenv);
		fprintf(fp,"%s",cvenv);
	}else
	if( streq(name,"ADMIN") )
		fprintf(fp,"%s",DELEGATE_MANAGER);
	else
	if( streq(name,"publist") )
		list_PUBLIC(fp);
	else
	if( streq(name,"pubcenter") )
		fputs(PUBLIC_CENTER,fp);
	else
	if( streq(name,"cantconn") ){
		if( streq(arg,"rejected") )
			return Conn->co_error & CO_REJECTED;
		if( streq(arg,"unknown") )
			return Conn->co_error & CO_CANTRESOLV;
		if( streq(arg,"timeout") )
			return Conn->co_error & CO_TIMEOUT;
		if( streq(arg,"refused") )
			return Conn->co_error & CO_REFUSED;
		if( streq(arg,"unreach") )
			return Conn->co_error & CO_UNREACH;
		return 0;
	}
}

put_eval_dhtml(Conn,url,outfp,instr)
	Connection *Conn;
	char *url;
	FILE *outfp;
	char *instr;
{	int exitlev;

	exitlev = 0;
	return eval_DHTML(Conn,url,outfp,instr,printItem,NULL,&exitlev);
}

static putDeleGatePage(Conn,req,tc,vno)
	Connection *Conn;
	char *req;
	FILE *tc;
{	FILE *tmp;
	int leng;

	tmp = TMPFILE("DGinfo");
	putBuiltinHTML(Conn,tmp,"DGinfo","welcome.dhtml",NULL,printItem);
	fflush(tmp);
	fseek(tmp,0,0);
	leng = file_size(fileno(tmp));

	HTTP_putHeader(Conn,tc,vno,"text/html",leng,-1);
	copyfile1(tmp,tc);
	fclose(tmp);

	flushLinger(tc);
	return leng;
}

static putIcon(Conn,tc,vno,icon)
	Connection *Conn;
	FILE *tc;
	char *icon;
{	char *data,*getIcon(),*ctype;
	int size;
	int leng = 0;

	if( (data = getIcon(icon,&size)) == 0 )
		return 0;

	if( (char*)strstr(icon,".xbm") != 0 )
		ctype = "image/x-xbitmap";
	else	ctype = "image/gif";
	leng += HTTP_putHeader(Conn,tc,vno,ctype,size,0);
	leng += fwrite(data,1,size,tc);
	flushLinger(tc);
	return leng;
}
static put1(name,data,size,buf,iconhp)
	char *name,*data;
	char *buf;
	char *iconhp;
{	char path[256],file[1024];

	sprintf(path,"%s%s",home_page,name);
	sprintf(file,"<IMG SRC=%s%s> <A HREF=%s%s>%s</A> (%d bytes)<BR>\n",
		iconhp,path, iconhp,path, name,size);
	strcat(buf,file);
}
static putIconList(Conn,tc,vno,iconhp)
	Connection *Conn;
	FILE *tc;
	char *iconhp;
{	char buf[0x10000];
	int leng = 0;

	buf[0] = 0;
	leng += HTTP_putHeader(Conn,tc,vno,"text/html",0,0);
	FPRINTF(tc,"<TITLE> Built-in images </TITLE>");
	FPRINTF(tc,"<H1> Images built into the DeleGate </H1>");
	FPRINTF(tc,"<MENU>\n");
		scanIcons(icon_relative,put1,buf,iconhp);
	fputs(buf,tc);
	leng += strlen(buf);
	FPRINTF(tc,"</MENU>\n");
	flushLinger(tc);
	return leng;
}
/*
	FPRINTF(tc,"<UL>\n");
	FPRINTF(tc,"<LI> <A HREF=echo>Echo your request</A>\n");
	FPRINTF(tc,"<LI> Display response header <ISINDEX>\n");
	FPRINTF(tc,"</UL>\n");
	if( streq(command,"echo") ){
		leng += HTTP_putHeader(Conn,tc,vno,"text/plain",0,-1);
		leng += HTTP_putRequest(Conn,tc);
		return leng;
	}else
*/

extern char *getv();
extern FILE *MtabFile();
static char *lastset;

static printMount(Conn,fp,fmt,name,param)
	Connection *Conn;
	FILE *fp;
	char *fmt,*name,*param;
{	FILE *mfp;
	char line[1024],from[256],to[1024],owner[256];

	mfp = MtabFile("anybody",0);
	if( mfp == NULL )
		return;

	if( streq(name,"jumplist") )
		fputs("<OPTION>/\r\n",fp);

	while( fgets(line,sizeof(line),mfp) != NULL ){
		owner[0] = 0;
		sscanf(line,"%s %s %[^\r\n]",from,to,owner);

		if( streq(name,"mountlist") )
			fprintf(fp,"<OPTION> %s\r\n",from);
		else
		if( streq(name,"jumplist") )
		{	char fromx[1024];

			strcpy(fromx,from);
			if( fromx[strlen(fromx)-1] == '*' )
			    fromx[strlen(fromx)-1] = 0;

			if( lastset && streq(from,lastset) )
				fprintf(fp,"<OPTION SELECTED>%s\r\n",fromx);
			else	fprintf(fp,"<OPTION>%s\r\n",fromx);
		}
		else
		if( streq(name,"mtab") ){
			fprintf(fp,"%-16s %-32s owner=%s\r\n",from,to,owner);
		}
	}

	fclose(mfp);
}

static mountControl(Conn,argv,tc,who)
	Connection *Conn;
	char *argv[];
	FILE *tc;
	char *who;
{	char *action,*user,*fromp,*tol,*comment,*val,froms[256],tos[256],*bp;
	char line[1024],froma[1024];
	FILE *mfp = NULL;
	char msg[1024];
	int leng;
	FILE *tmp;

	action  = getv(argv,"action");
	fromp   = getv(argv,"vurl-path");
	tol     = getv(argv,"rurl-login");
	user    = getv(argv,"user");
	comment = getv(argv,"comment");

	sv1log("MOUNT: [%s] from=[%s] to=[%s] src=[%s]\n",
		action?action:"", fromp?fromp:"",tol?tol:"",user?user:"");

	if( action == 0 ){
		sprintf(msg,"Missing action specification.\n");
		goto error;
	}

	if( fromp == 0 || fromp[0] == 0 ){
		sprintf(msg,"Missing left hand part.\n");
		goto error;
	}

	mfp = MtabFile("anybody",1);
	if( mfp == NULL ){
		sprintf(msg,"Cannot open MTAB file\n");
		goto error;
	}

	if( streq(action,"mount") ){
		if( fromp[0] == '/' )
			froms[0] = 0;
		else	strcpy(froms,"/");
		if( val = getv(argv,"vurl-path") ) strcat(froms,val);
		if( strtailchr(froms) != '*' )
			if( val = getv(argv,"vurl-tail") ) strcat(froms,val);

		if( tol == NULL || tol[0] == 0 ){
			sprintf(msg,"Missing right hand part.\n");
			goto error;
		}
		tos[0] = 0;
		if( val = getv(argv,"rurl-proto") ) strcat(tos,val);
		if( val = getv(argv,"rurl-login") ) strcat(tos,val);
		if( val = getv(argv,"rurl-tail") )  strcat(tos,val);

		/*
		if( file_size(fileno(mfp)) == 0 ){
			fprintf(mfp,"/-*\t=\t.delegate\n");
			fflush(mfp);
			fseek(mfp,0,0);
		}
		*/

		while( fgets(line,sizeof(line),mfp) != NULL ){
			wordscan(line,froma);
			if( strcmp(froms,froma) == 0 ){
				sprintf(msg,"Duplicate MOUNT for '%s'\n",froms);
				goto error;
			}
		}

		lock_exclusiveNB(fileno(mfp));
		fprintf(mfp,"%s\t%s\t%s\n",froms,tos,who);
		fflush(mfp);
		fseek(mfp,0,0);
		sort_file(mfp,mfp,1);
		lock_unlock(fileno(mfp));

		lastset = froms;
	}else
	if( streq(action,"unmount") ){
		tmp = TMPFILE("UNMOUNT");
		while( fgets(line,sizeof(line),mfp) != NULL ){
			int ai;
			char *from1;
			int match = 0;

			wordscan(line,froma);
			for( ai = 0; from1 = argv[ai]; ai++ ){
				if( strncmp(from1,"vurl-path=",10) == 0 )
					if( strcmp(from1+10,froma) == 0 ){
						match = 1;
						break;
					}
			}
			if( !match )
				fputs(line,tmp);
		}
		fflush(tmp);
		fseek(tmp,0,0);
		fseek(mfp,0,0);

		lock_exclusiveNB(fileno(mfp));
		copyfile1(tmp,mfp);
		lock_unlock(fileno(mfp));

		fclose(tmp);
		Ftruncate(mfp,0,1);
	}else
	if( streq(action,"jump") ){
		char myhp[256],url[1024];

		ClientIF_HP(Conn,myhp);
		sprintf(url,"http://%s%s",myhp,fromp);
		return putMovedTo(Conn,tc,url);
	}

	fclose(mfp);
	leng = putBuiltinHTML(Conn,tc,"Mount",
		"manage/mount.dhtml",NULL,printMount,fromp);
	lastset = 0;
	return leng;

error:
	if( mfp != NULL )
		fclose(mfp);
	fprintf(tc,"%s",msg);
	return 1;
}

dynamic_config(Conn)
	Connection *Conn;
{	FILE *fp;
	char line[1024];

	fp = MtabFile("anybody",0);
	if( fp == NULL )
		return;

	/* if( "/-*" is not mounted )
		scan_MOUNT(Conn,"/-* ="); */

	while( fgets(line,sizeof(line),fp) )
		scan_MOUNT(Conn,line);
	fclose(fp);
	init_mtab();
}


#define A_IAUTHEN	0x01
#define A_IAUTHOR	0x02
#define A_WITHAUTH	0x10
#define A_FAUTHEN	0x20
#define A_FAUTHOR	0x40
#define A_FAUTHFAIL	0x80

static printAuth(Conn,fp,fmt,name,param,env)
	Connection *Conn;
	FILE *fp;
	char *fmt,*name,*param;
	char *env[];
{
	if( streq(name,"identmsg") ) fputs(env[0],fp);
	if( streq(name,"fauthmsg") ) fputs(env[1],fp);
	if( streq(name,"withauth") ) return (int)env[2] & A_WITHAUTH;
}

static putControl(Conn,req,fc,tc,vno,command)
	Connection *Conn;
	char *req;
	FILE *fc,*tc;
	char *command;
{	int leng = 0;
	char fauth[1024];
	char ohost[1024],ouser[1024];
	int oport;
	char purl[1024],url[1024];
	char from[1024];
	char ahost[256],auser[256],apass[256];
	char *dp;
	char identmsg[512];
	char fauthmsg[512];
	char *msgs[3];
	int auth_stat = 0;
	char who[256];

	if( streq(command,"reauth") ){
		leng += putNotAuthorized(Conn,tc,req,0,NULL);
		FPRINTF(tc,"You are clearing authorization thus are never authorized.\n");
		return leng;
	}

if( HTTP_getRequestField(Conn,"From",from,sizeof(from)) != 0 )
	sv1log("#### putControl -- From: %s\n",from);

	oport = getOriginator(ohost);
	ouser[0] = 0;
	who[0] = 0;

	if( HTTP_getAuthorization(Conn,0,ohost,ahost,auser,apass) ){
		auth_stat |= A_WITHAUTH;
		sprintf(fauth,"<I>&lt;%s@%s&gt;</I>",auser,ahost);
	}else	sprintf(fauth,"<I>&lt;empty-authorization&gt;</I>");

	identmsg[0] = 0;
	HTTP_originalURL(Conn,purl);

	if( getClientUser0(Conn,ohost,oport,ouser) ){
		auth_stat |= A_IAUTHEN;
		sprintf(who,"%s@%s",ouser,ohost);
		sprintf(identmsg,"You are <I>&lt;%s&gt;</I> who is ",who);
		if( auth_manager(command,"IDENT",ohost,ouser) ){
			strcpy(ahost,ohost);
			strcpy(auser,ouser);
			auth_stat |= A_IAUTHOR;
		}else	strcat(identmsg,"not ");
		strcat(identmsg,"authorized by the DeleGate.\n");
	}else	sprintf(identmsg,"You seem to be from <I>%s</I> without Identd.",ohost);

	if( auth_stat & A_WITHAUTH ){
	    if( 0 <= Authenticate(Conn,ahost,auser,apass,"/")  ){
		auth_stat |= A_FAUTHEN;
		sprintf(who,"%s@%s",auser,ahost);
		if( auth_manager(command,"FTP",ahost,auser) ){
			auth_stat |= A_FAUTHOR;
			sprintf(fauthmsg,"You as %s are authorized by the DeleGate.\n",fauth);
		}else	sprintf(fauthmsg,"You as %s are not authorized by the DeleGate.\n",fauth);
	    }else{
		auth_stat |= A_FAUTHFAIL;
		sprintf(fauthmsg,"Your authorization as %s is rejected by ftp://%s/.\n",
			fauth,ahost);
	    }
	}else	sprintf(fauthmsg,"Your authorization information is empty.\n");

	if( *command == 0 ){
		leng += HTTP_putHeader(Conn,tc,vno,"text/html",0,-1);
		msgs[0] = identmsg;
		msgs[1] = fauthmsg;
		msgs[2] = (char*)auth_stat;
		leng += putBuiltinHTML(Conn,tc,"Management",
			"manage/server.dhtml",NULL,printAuth,msgs);
		return leng;
	}

	if( !(auth_stat & (A_IAUTHOR | A_FAUTHOR)) ){
/*
		if( put_help ){
			strcpy(url,purl);
			if( dp = strrchr(url,'/') )
				*dp = 0;
			return putMovedTo(Conn,tc,url);
		}else
*/
		{
			leng += putNotAuthorized(Conn,tc,req,0,NULL);
			FPRINTF(tc,"<TITLE> Not Authorized </TITLE>");
			FPRINTF(tc,"<H1> Not Authorized </H1>");
/*
FPRINTF(tc,"Authenticated: %s@%s\n",auser,ahost);
FPRINTF(tc,"You are not authorized to do `%s'.<BR>",command);
*/
			return leng;
		}
	}

	if( streq(command,"mount") ){
		if( strncmp(req,"POST",4) == 0 )
			leng = control_cgi(Conn,command,fc,tc,who);
		else	leng = putBuiltinHTML(Conn,tc,"Mount",
			"manage/mount.dhtml",NULL,printMount,"");
		return leng;
	}
	if( streq(command,"authenticate") ){
		leng += HTTP_putHeader(Conn,tc,vno,"text/html",0,-1);
		FPRINTF(tc,"<TITLE> You are authority </TITLE>\n");
		FPRINTF(tc,"<H1> You are authority </H1>\n");
		FPRINTF(tc,"You are authenticated to be &lt;<I>%s@%s</I>&gt;, \n",auser,ahost);
		FPRINTF(tc,"who is authorized to do DeleGate Server Management.\n",auser,ahost);
		return leng;
	}else
	if( streq(command,"restart") ){
		leng += HTTP_putHeader(Conn,tc,vno,"text/plain",0,-1);
		fflush(tc);
		leng += restart_server(tc);
		return leng;
	}else
	if( streq(command,"getlog") ){
		leng += HTTP_putHeader(Conn,tc,vno,"text/plain",0,-1);
		fflush(tc);
		leng += get_serverinitlog(tc);
		return leng;
	}else
	if( streq(command,"showconf") ){
		leng += HTTP_putHeader(Conn,tc,vno,"text/plain",0,-1);
		fflush(tc);
		leng += DELEGATE_dumpEnv(tc);
		return leng;
	}
/*
	if( streq(command,"replace") ){
		leng += HTTP_putHeader(Conn,tc,vno,"text/html",0,-1);
		FPRINTF(tc,"<TITLE> Replaced </TITLE>\n");
		FPRINTF(tc,"Authorization: %s\n",dauth);
		return leng;
	}
*/
	leng += HTTP_putHeader(Conn,tc,vno,"text/html",0,-1);
	FPRINTF(tc,"Not yet supported: %s\n",command);
	return leng;
}
static putProxyPage(Conn,tc,vno)
	Connection *Conn;
	FILE *tc;
{	int leng = 0;

	leng += HTTP_putHeader(Conn,tc,vno,"text/html",0,-1);
	leng += putBuiltinHTML(Conn,tc,"non-CERN-proxy","nonCERNproxy.dhtml","",NULL);
	putFrogVer(Conn,tc);
	flushLinger(tc);
	return leng;
}
static putUnknownPage(Conn,tc,vno,req)
	Connection *Conn;
	FILE *tc;
	char *req;
{	int leng = 0;

	delayUnknown(Conn,1,req);
	leng += putHttpNotFound(Conn,tc,"");
	leng += putBuiltinHTML(Conn,tc,"NotFound","404-notfound.dhtml","",NULL);
/*
FPRINTF(tc,"<TITLE> URL is Unknown or in Syntax Error </TITLE>\r\n");
FPRINTF(tc,"<H2> URL is Unknown or in Syntax Error </H2>\r\n");
FPRINTF(tc,"Your request: %s\r\n",req);
*/
	putFrogVer(Conn,tc);
	flushLinger(tc);
	return leng;
}

control_cgi(Conn,action,fc,tc,who)
	Connection *Conn;
	char *action;
	FILE *fc,*tc;
	char *who;
{	char cLeng[1024];
	int cleng,rcc;
	char form[4096],*argv[32];
	int argc,argi;

	HTTP_getRequestField(Conn,"Content-Length",cLeng,sizeof(cLeng));
	cleng = atoi(cLeng);

	argc = 0;
	form[0] = 0;
	if( 0 < cleng ){ /* && if Content-Type: x-form */
		char *sp,*dp;

		rcc = fread(form,1,cleng,fc);
		form[rcc] = 0;

		sp = form;
		for(;;){
			argv[argc++] = sp;
			if( dp = strchr(sp,'&') )
				*dp++ = 0;
			nonxalpha_unescape(sp,sp,1);
			if( dp == 0 )
				break;
			sp = dp;
		}
	}
	argv[argc] = 0;

	if( streq(action,"mount") )
		return mountControl(Conn,argv,tc,who);

	return 1;
}
static putBench(Conn,tc,vno,what)
	Connection *Conn;
	FILE *tc;
	char *what;
{	int leng,bi;

	leng = atoi(what);
	HTTP_putHeader(Conn,tc,vno,"text/plain",leng,-1);
	for( bi = 0; bi < leng-2; bi++ )
		putc('*',tc);
	fputs("\r\n",tc);
	return leng;
}
putData(Conn,tc,vno,dataspec)
	Connection *Conn;
	FILE *tc;
	char *dataspec;
{	char ctype[64],encode[64],*data,databuf1[0x8000],databuf2[0x8000];
	char *dp;
	int leng;

	strcpy(ctype,"text/plain");
	strcpy(encode,"7bit");
	data = "";
	leng = 0;

	dp = strpbrk(dataspec,";,");
	if( dp == NULL || 64 <= (dp - dataspec) )
		goto EXIT;

	sscanf(dataspec,"%[^;,];%[^,]",ctype,encode);
	if( data = strchr(dataspec,',') ){
		data++;
		nonxalpha_unescape(data,databuf1,1);
		leng = strlen(databuf1);
		data = databuf1;

		if( strcasecmp(encode,"base64") == 0 ){
			leng = str_from64(data,leng,databuf2,sizeof(databuf2));
			data = databuf2;
		}
	}
EXIT:
	if( vno != 0 )
	HTTP_putHeader(Conn,tc,vno,ctype,leng,-1);
	fwrite(data,1,leng,tc);
	return leng;
}

#define ISMYSELF(Conn) \
	(!Conn->co_nointernal && Ismyself(Conn,DST_PROTO,DST_HOST,DST_PORT))

HttpToMyself(Conn,req,head,fc,tc,stcodep)
	Connection *Conn;
	char *req,*head;
	FILE *fc,*tc;
	int *stcodep;
{	char method[256],path[URLSZ],ver[256];
	int vno;
	int nlen;
	char icon[256],*iconhp;
	int leng = 0;
	int ismyself;
	int clIfMod;

	ismyself = ISMYSELF(Conn);

	sv1log("checking delegate-internal: self=%d %s",ismyself,req);
	if( (vno=scan_http_request(req,method,path,ver)) == 0 )
		return 0;

	if( ismyself ){
		if( streq(path,"/") ){
			return putProxyPage(Conn,tc,vno);
		}
		if( path[0] == '/' && path[1] == '?' ){
			if( DONT_REWRITE )
				return putMovedTo(Conn,tc,path+2);
			else{
				char upath[URLSZ],durl[URLSZ];
				char myhost[128];
				int myport;

				nonxalpha_unescape(path+2,upath,0);
				myport = ClientIF_H(Conn,myhost);
				delegate_url0(durl,upath,myhost,myport);
				return putMovedTo(Conn,tc,durl);
			}
		}
	}

	if( strncmp(path,data_base,strlen(data_base)) == 0 )
		return putData(Conn,tc,vno,path+strlen(data_base));

	if( streq(path,home_page) ){
		if( DONT_REWRITE )
			leng = putDeleGatePage(Conn,req,tc,vno);
		else{
			FILE *tcx;
			tcx = openHttpResponseFilter(Conn,tc);
			leng = putDeleGatePage(Conn,req,tcx,vno);
			fclose(tcx);
			wait(0);
		}
		return leng;
	}
	if( strncmp(path,cntl_base,strlen(cntl_base)) == 0 || strstr(path,"?-_-") ){
		leng = putControl(Conn,req,fc,tc,vno,path+strlen(cntl_base));
		flushLinger(tc);
		return leng;
	}

	nlen = strlen(mssg_base);
	if( strncmp(path,mssg_base,nlen) == 0 ){
		putHttpHeader1(Conn,tc,NULL,"text/html",ME_7bit,0,0);
		leng =
		putBuiltinHTML(Conn,tc,"builtin-mssg",path+nlen,NULL,printItem);
		if( leng == 0 ){
			fprintf(tc,"UNKNOWN ? %s\r\n",path+nlen);
			leng = 1;
		}
		return 1;
	}

	nlen = strlen(icon_base);
	if( strncmp(path,icon_base,nlen) == 0 ){
		sprintf(icon,"%s%s",icon_relative,path+nlen);
		iconhp = HTTP_iconURLbase(Conn);
		if( path[nlen] == 0 )
			leng = putIconList(Conn,tc,vno,iconhp);
		else	leng = putIcon(Conn,tc,vno,icon);

		if( 0 < leng ){
			IsInternal = 1;
			return leng;
		}
	}else{
		if( strncmp(path,bench_base,strlen(bench_base)) == 0 ){
			return putBench(Conn,tc,vno,path+strlen(bench_base));
		}
		if( ismyself ){
			if( leng = putRobotsTxt(Conn,tc,NULL,NULL) )
				return leng;
			sv1log("ERROR: Unknown internal: %s",req);
			return putUnknownPage(Conn,tc,vno,req);
		}
	}
	if( leng = putLocal(Conn,vno,method,req,head,path,fc,tc,stcodep) )
		return leng;

	return 0;
}

static putDeleGateAnchor(Conn,tc)
	Connection *Conn;
	FILE *tc;
{
	return Fprintf(tc,"<A HREF=%s%s>",HTTP_iconURLbase(Conn),home_page);
}

static printMoved(Conn,fp,fmt,name,param,url)
	Connection *Conn;
	FILE *fp;
	char *fmt,*name,*param;
	char *url;
{
	if( streq(name,"moved") ){
		if( streq(param,"url") )
			fputs(url,fp);
	}
}
putChangeProxy(Conn,tc,url,proxy)
	Connection *Conn;
	FILE *tc;
	char *url,*proxy;
{	int leng;

	leng = genHEAD(Conn,tc,305,"Use Proxy");
	if( *proxy == 0 || strcasecmp(proxy,"direct") == 0 ){
		FPRINTF(tc,"Set-Proxy: DIRECT\r\n",url);
	}else{
		FPRINTF(tc,"Set-Proxy: SET; proxyURI=\"%s\"\r\n",proxy);
		FPRINTF(tc,"Location: %s\r\n",proxy);
	}
	FPRINTF(tc,"\r\n");

	leng += putBuiltinHTML(Conn,tc,"UseProxy-message",
		"305-useproxy.dhtml",NULL,printItem);
	flushLinger(tc);
	return leng;
}
putMovedTo(Conn,tc,url)
	Connection *Conn;
	FILE *tc;
	char *url;
{	int leng;
	char *dp;

	leng = genHEAD(Conn,tc,302,"Moved");
	if( getenv("DG_useURI") ){
		if( strncmp(url,"http://",7) == 0 )
			if( dp = strchr(url+7,'/') )
				url = dp;
		FPRINTF(tc,"URI: <%s>\r\n",url);
		sv1log("####### URI: <%s>\r\n",url);
	}else{
		FPRINTF(tc,"Location: %s\r\n",url);
		sv1log("####### Location: %s\r\n",url);
	}
	FPRINTF(tc,"\r\n");

	leng += putBuiltinHTML(Conn,tc,"Moved-message",
		"302-moved.dhtml",NULL,printMoved,url);

	putFrogVer(Conn,tc);
	flushLinger(tc);
	return leng;
}
static putHttpNotModified(Conn,tc)
	Connection *Conn;
	FILE *tc;
{	int leng;

	leng = genHEAD(Conn,tc,304,"Not modified");
	FPRINTF(tc,"\r\n");
	return leng;
}
putHttpNotFound(Conn,tc,mssg)
	Connection *Conn;
	FILE *tc;
	char *mssg;
{	int leng;

	leng = genHEAD(Conn,tc,404,"Not found");
	FPRINTF(tc,"\r\n");
	FPRINTF(tc,"%s",mssg);
	return leng;
}
putHttpNotAvailable(Conn,tc,mssg)
	Connection *Conn;
	FILE *tc;
	char *mssg;
{	int leng = 0;

	leng = genHEAD(Conn,tc,503,"Service Unavailable");
	FPRINTF(tc,"\r\n");
	return leng;
}
putNotAuthorized(Conn,tc,req,proxy,realm)
	Connection *Conn;
	FILE *tc;
	char *req,*realm;
{	int leng = 0;
	char url[1024],xrealm[1024];

	if( realm == NULL ){
		url[0] = 0;
		scan_http_request(req,NULL,url,NULL);
		sprintf(xrealm,"<%s>",url);
		realm = xrealm;
	}
	if( proxy )
		leng = genHEAD(Conn,tc,407,"Proxy Authentication Required");
	else	leng = genHEAD(Conn,tc,401,"Unauthorized");

	Verbose("REALM: %s\n",realm);
	if( proxy )
		FPRINTF(tc,"Proxy-Authenticate: Basic Realm=%s\r\n",realm);
	else	FPRINTF(tc,"WWW-Authenticate: Basic Realm=%s\r\n",realm);

	FPRINTF(tc,"\r\n");

	FPRINTF(tc,"Not Authorized: %s<BR>\n",req);
	if( proxy )
		FPRINTF(tc,"<B>Proxy Authorization</B> required.<P>\n");
	else	FPRINTF(tc,"<B>Authorization</B> required.<P>\n");
	return leng;
}

putFrogVer(Conn,tc)
	Connection *Conn;
	FILE *tc;
{	int leng = 0;

	FPRINTF(tc,"<HR>\n");
	FPRINTF(tc,"<ADDRESS> Proxy HTTP Server %s \n", DELEGATE_Ver());
	leng += putFrogForDeleGate(Conn,tc,"");
	FPRINTF(tc,"</ADDRESS>\n");
	return leng;
}

putHttpRejectmsg(Conn,tc,proto,server,iport,req)
	Connection *Conn;
	FILE *tc;
	char *proto,*server,*req;
{	int leng = 0,leng1;
	char oreq[URLSZ],desc[URLSZ],msg[URLSZ];
	int mleng;
	char *mid;

	if( HTTP_reqIsHTTP(Conn,req) ){
		leng = genHEAD(Conn,tc,403,"Forbidden");
		FPRINTF(tc,"\r\n");
	}
	HTTP_originalRequest(Conn,req);
	sprintf(desc,"<B>Forbidden</B>: %s",req);
	mid = "403-forbidden.dhtml";
	Conn->from_myself = 1;
	leng1 = putBuiltinHTML(Conn,tc,"Forbidden-Message",mid,desc,NULL);
	leng += leng1;
	leng += putFrogVer(Conn,tc);
	flushLinger(tc);
	return leng;
}

#define RemoteImage "builtin/icons/ysato/Remote.gif"
putHttpCantConnmsg(Conn,tc,proto,server,iport,req)
	Connection *Conn;
	FILE *tc;
	char *proto,*server,*req;
{	int leng = 0,leng1;
	char myhp[128],url[URLSZ],rurl[URLSZ],iurl[256];
	char *mid,desc[1024],msg[1024];
	char *dp;

	if( HTTP_reqIsHTTP(Conn,req) ){
		leng = genHEAD(Conn,tc,502,"Cannot Connect");
		FPRINTF(tc,"\r\n");
	}
	if( Conn->co_nonet ){
		scan_http_request(req,NULL,url,NULL);
		ClientIF_HP(Conn,myhp);
		sprintf(rurl,"http://%s/FR-_-",myhp);
		if( url[0] == '/' && (dp = strstr(url+1,"-_-")) )
			strcat(rurl,dp+3);
		else	strcat(rurl,url);

		FPRINTF(tc,"<TITLE> Not in Cache </TITLE>\n");
		FPRINTF(tc,"<H2>Not in Cache</H2>\n");
		FPRINTF(tc,"This DeleGate is running under <I>cache-only</I> mode.<BR>\n");
		sprintf(iurl,"http://%s/-/%s",myhp,RemoteImage);
		FPRINTF(tc,"Click <A HREF=\"%s\"><IMG SRC=\"%s\">",rurl,iurl);
		FPRINTF(tc,"here</A> to load from the remote server.\r\n");
	}else{
		mid = "502-cantconnect.dhtml";
		sprintf(desc,"<B>Cannot Connect</B>");
		leng1 = putBuiltinHTML(Conn,tc,"CantConn-Message",mid,desc,printItem);
		leng += leng1;
	}
	leng += putFrogVer(Conn,tc);
	flushLinger(tc);
	return leng;
}

httpfinger(Conn,sv,server,iport,path,vno)
	Connection *Conn;
	char *server,*path;
{	FILE *ts,*fs,*tc;
	char resp[1024];
	int lines;
	int leng = 0;

	if( sv == -1 )
		return;
	ts = fdopen(dup(sv),"w");
	fs = fdopen(dup(sv),"r");
	tc = fdopen(dup(ToC),"w");

	if( *path == '/' )
		path++;
	if( *path == '?' )
		path++;

	fprintf(ts,"%s\r\n",path);
	fflush(ts);

	leng += HTTP_putHeader(Conn,tc,vno,"text/html",0,-1);
	FPRINTF(tc,"<TITLE> Finger on %s </TITLE>\n",server);
	FPRINTF(tc,"<H1> Finger on %s </H1>\n",server);
	FPRINTF(tc,"<ISINDEX>\n");
	FPRINTF(tc,"<PRE>\n");

	lines = 0;
	while( fgets(resp,sizeof(resp),fs) != NULL ){
		fputs(resp,tc);
		leng += strlen(resp);
		lines++;
	}
	FPRINTF(tc,"</PRE>\n");
	FPRINTF(tc,"<HR>\n");
	leng += putFrogForDeleGate(Conn,tc,"[%d lines]\n",lines);

	flushLinger(tc);
	fclose(ts);
	fclose(fs);
	fclose(tc);
	return leng;
}

putFrogForDeleGate(Conn,dst,fmt,a,b,c,d,e,f,g,h,i,j)
	Connection *Conn;
	FILE *dst;
	char *fmt,*a,*b,*c,*d,*e,*f,*g,*h,*i,*j;
{	int leng = 0;

	FPRINTF(dst,fmt,a,b,c,d,e,f,g,h,i,j);
	leng += putDeleGateAnchor(Conn,dst);
	leng += putFrogInline(Conn,dst,"BOTTOM",1,0);
	FPRINTF(dst,"V</A>\n");
	return leng;
}


extern int START_TIME;
post_PUBLIC(Conn,public)
	Connection *Conn;
	char *public;
{	char serv[256],myhp[256];
	char line[1024],date[128],now[128],cvenv[128];
	int sv;
	FILE *ts,*fs;
	int ready;

	if( public == NULL || public[0] == 0 )
		public = PUBLIC_CENTER;

	scan_SERVER(Conn,public);
	sv = connect_to_serv(Conn,FromC,ToC,0);

	if( sv != -1 ){
	    ts = fdopen(sv,"w");
	    fs = fdopen(sv,"r");

	    if( streq(DFLT_PROTO,"http") ){
		fprintf(ts,"GET / HTTP/1.0\r\n");
		HTTP_putDeleGateHeader(Conn,ts,NULL);
		Myhostport(myhp,sizeof(myhp));
		fprintf(ts,"Public-DeleGate: %s\r\n",myhp);
		fprintf(ts,"\r\n");
		fflush(ts);
		sv1log("post_PUBLIC: [%d] %s://%s/\n",sv,DFLT_PROTO,myhp);
		StrftimeLocal(date,sizeof(date),"%m/%d-%H:%M",START_TIME);

if( fgets(line,sizeof(line),fs) != NULL )
sv1log("[PUBLIC-DeleGate] %s",line);

		fs = fdopen(sv,"r");
		for(;;){
			fprintf(ts,"Version=%s; ",DELEGATE_ver());
			fprintf(ts,"Uptime=%s; ",date);
			StrftimeLocal(now,sizeof(now),"%m/%d-%H:%M",time(0));
			fprintf(ts,"LastUp=%s; ",now);
			if( cur_codeconvCL(cvenv) )
				fprintf(ts,"Charcode=%s; ",cvenv);
			fprintf(ts,"\n");
			fflush(ts);
			ready = fPollIn(fs,10*60*1000);

			if( ready < 0 )
				break;
			if( ready == 0 )
				continue;
			if( fgets(line,sizeof(line),fs) == NULL )
				break;
		}
		return 0;
	    }
	}
	sv1log("post_PUBLIC[ERROR]: %s %d\n",DFLT_PROTO,sv);
	return 1;
}

extern char *gethostaddr();
keep_PUBLIC(Conn,clsock,arg)
	Connection *Conn;
	char *arg;
{	char public[1025],*dp;
	char host[1024];
	char stat[1024];
	char path[1024];
	FILE *fc,*tc;
	FILE *fp;
	char peer[1024],*addr;

	fc = fdopen(clsock,"r");
	tc = fdopen(clsock,"w");
	fprintf(tc,"START.\n");
	fflush(tc);

	if( *arg == ' ' )
		arg++;
	strcpy(public,arg);
	if( dp = strpbrk(public,"\r\n") )
		*dp = 0;

	getpeerNAME(clsock,peer,NULL,NULL);
	addr = gethostaddr(peer);

	sv1log("[PUBLIC-DeleGate] %s << %s [%s]\n",public,peer,addr);
	sprintf(path,"%s/%s",PUBLIC_DIR,public);
	strsubst(path,"${TMPDIR}",DELEGATE_TMPDIR);
	strsubst(path,"${ACTDIR}",DELEGATE_ACTDIR);
	strsubstDirEnv(path,DELEGATE_DGROOT,DELEGATE_VARDIR);
	fp = dirfopen("PUBLIC",path,"w");

	if( fp != NULL ){
		while( fgets(stat,sizeof(stat),fc) != NULL ){
			sv1log("[PUBLIC-DeleGate] %s %s",public,stat);
			fseek(fp,0,0);
			fprintf(fp,"Host=%s/%s; ",peer,addr);
			fputs(stat,fp);
			fflush(fp);
			Ftruncate(fp,0,1);
		}
		sv1log("[PUBLIC-DeleGate] %s done.\n",public);
		unlink(path);
		Finish(0);
	}
	Finish(1);
}

list_PUBLIC(tc)
	FILE *tc;
{	FILE *tmp,*sp;
	char desc[1024];
	int rcc;
	char hostport[256],url[256];
	int leng = 0;
	char *dp;
	int lastmod,now;

	if( chdir(PUBLIC_DIR) != 0 )
		return 0;

	tmp = TMPFILE("list_PUBLIC");
	dir2ls(PUBLIC_DIR,NULL,NULL,"%N",tmp);
	fflush(tmp);
	fseek(tmp,0,0);
	now = time(0);

	while( fgets(hostport,sizeof(hostport),tmp) != NULL ){
		if( dp = strpbrk(hostport,"\r\n") )
			*dp = 0;
		if( hostport[0] == '.' )
			continue;

		sv1log("[%s]\n",hostport);
		if( sp = fopen(hostport,"r") ){
			lastmod = file_mtime(fileno(sp));
			rcc = fread(desc,1,sizeof(desc),sp);
			desc[rcc] = 0;
			fclose(sp);
			if( 10*60 < now - lastmod )
				continue;
		}else	continue;

		if( dp = strpbrk(hostport,"\r\n") )
			*dp = 0;

		sprintf(url,"http://%s/-/",hostport);
		FPRINTF(tc,"<A HREF=\"%s\"><B>%s</B></A>\n{ %s }<BR>\n",
			url,url,desc);
	}

	fclose(tmp);
	return leng;
}

extern char *file_hostpath();
extern char *filename2ctype();
extern char *filename2icon();

static off_limit(url,upath)
	char *url,*upath;
{	char *rpath,apath[1024];

	if( rpath = strstr(url,"://") ){
		rpath += 3;
		if( rpath = strchr(rpath,'/') ) /* skip server part */
			rpath += 1;
	}else
	if( rpath = strstr(url,":/") )
		rpath += 2;

	if( rpath ){
		strcpy(apath,"-/-");
		chdir_cwd(apath,rpath,0);
		if( strncmp(apath,"-/-",3) != 0 )
			return 1; /* intruded off limit by ".." */
		strcpy(upath,rpath);
	}

	return 0;
}


/*
 * as a search script ?
 *
 *	/path/of/dir?ls-options
 *
 */
static char DIR_CGI[16] = "-dir.cgi";
static dir_CGI(Conn,path,upath,fp)
	Connection *Conn;
	char *path,*upath;
	FILE *fp;
{
}

static char DIR_HTML[16] = "-dir.html";

static char *http_search_script;
static char *indexurls[16] = {
	"welcome.html",
	"welcome.cgi",
	"index.html",
	"index.cgi",
	DIR_HTML,
	NULL
};

scan_HTTPCONF(Conn,conf)
	Connection *Conn;
	char *conf;
{	char what[128],value[2048];

	sscanf(conf,"%[^:]:%s",what,value);
	if( streq(what,"search") ){
		http_search_script = strdup(value);
		sv1log("HTTP SearchScript=%s\n",value);
	}else
	if( streq(what,"welcome") ){
		int wc,wi;
		char *wv[16];

		wc = stoV(value,15,wv,',');
		for( wi = 0; wi < wc; wi++ ){
			Verbose("HTTP-Welcome[%d] %s\n",wi,wv[wi]);
			indexurls[wi] = strdup(wv[wi]);
		}
		indexurls[wc] = NULL;
	}
}

#define S_DATA	1
#define S_EXEC	2

static FILE *openIndex(Conn,path,upath,ipath,what)
	Connection *Conn;
	char *path,*upath,*ipath;
{	FILE *fp;
	int ii;
	char *sp,sc,*ip,*file;

	ip = ipath;
	if( path[0] ){
		for( sp = path; sc = *sp; sp++ )
			*ip++ = sc;
		if( ip[-1] != '/' )
			*ip++ = '/';
	}

	for( ii = 0; file = indexurls[ii]; ii++ ){
		if( streq(file,DIR_HTML) || strtailstr(file,".cgi") ){
			if( (what & S_EXEC) == 0 ) continue;
		}else{
			if( (what & S_DATA) == 0 ) continue;
		}

		strcpy(ip,file);
		if( strcmp(file,DIR_HTML) == 0 ){
			fp = TMPFILE("ls2html");
			putDirPage(Conn,path,upath,fp);
			fflush(fp);
			fseek(fp,0,0);
			return fp;
		}else{
			if( fp = fopen(ipath,"r") )
				return fp;
		}
	}
	return NULL;
}

extern char *TIMEFORM_LS;
static putDir(Conn,dirpath,tmp,fp,eol)
	Connection *Conn;
	char *dirpath;
	FILE *tmp,*fp;
	char *eol;
{	char line[1024];
	char file[2048];
	char iconbase[1024],*iconsrc,*iconalt;
	char pfile[2048];
	char path[1024];
	int size,time,isdir;
	char atime[128];

	getCERNiconBase(Conn,iconbase);
	while( fgets(line,sizeof(line),tmp) != NULL ){
		linescan(line,file,sizeof(file));
		strcpy(pfile,file);
		if( file[0] == '.' && file[1] != '.' )
			continue;

		strcpy(path,dirpath);
		if( strtailchr(path) != '/' )
			strcat(path,"/");
		strcat(path,file);
		File_stat(path,&size,&time,&isdir);
		StrftimeLocal(atime,sizeof(atime),TIMEFORM_LS,time);
		fprintf(fp,"%8d %s ",size,atime);

		if( strcmp(file,"..") == 0 ){
			sprintf(pfile,"<IMG ALIGN=TOP SRC=%s%s>",
				iconbase,"back.gif");
		}else
		if( isdir )
			strcat(file,"/");
		iconsrc = filename2icon(file,&iconalt);
		fprintf(fp,"<IMG ALT=\"[%s]\" ALIGN=TOP SRC=\"%s%s\">",
			iconalt,iconbase,iconsrc);

		nonxalpha_escape(file,file);
		fprintf(fp," <A HREF=\"%s\"><B>%s</B></A>%s",
			file,pfile,eol);
	}
}
static putDirPage(Conn,path,upath,fp)
	Connection *Conn;
	char *path,*upath;
	FILE *fp;
{	FILE *tmp;

	tmp = TMPFILE("dir2ls");
	dir2ls(path,NULL,NULL,"%N",tmp);
	fflush(tmp);
	fseek(tmp,0,0);

	fprintf(fp,"<TITLE> Index of /%s </TITLE>\n",upath);
	fprintf(fp,"<B>/%s</B>\n",upath);
	fprintf(fp,"<PRE>\n",path);

	putDir(Conn,path,tmp,fp,"\r\n");

	fclose(tmp);
	fprintf(fp,"<HR>\n",path);
	fprintf(fp,"<PRE>\n",path);
}

service_cgi(Conn)
	Connection *Conn;
{
}
service_cfi(Conn)
	Connection *Conn;
{
}

static strip_extrapath(method,surl,durl,dupath,extrapath)
	char *method,*surl,*durl,*dupath,*extrapath;
{	char durlbuf[URLSZ],search[URLSZ];
	char surlb[URLSZ],durlb[URLSZ],*dp;
	int script_namlen;

	dp = strrchr(surl,'/');
	if( dp == 0 || dp == surl )
		return 0;

	if( durl == NULL )
		durl = durlbuf;

	strcpy(surlb,surl);
	if( dp = strchr(surlb,'?') ){
		strcpy(search,dp);
		*dp = 0;
	}else	search[0] = 0;

	strcpy(durlb,surlb);
	if( mount_url_to(method,durlb) == 0 )
		return 0;
	strcpy(durl,durlb);

	for(;;){
		if( dp = strrchr(surlb,'/') )
			*dp = 0;
		else	break;

		strcpy(durlb,surlb);
		if( mount_url_to(method,durlb)==0 || strstr(durl,durlb)==0 ){
			*dp = '/';
			break;
		}
		strcpy(durl,durlb);
	}
	if( script_namlen = strlen(surlb) ){
		strcpy(extrapath,surl+script_namlen);
		if( dp = strchr(extrapath,'?') )
			*dp = 0;
		decomp_absurl(durl,NULL,NULL,dupath);
		sv1log("### stripped CGI extra PATH [%s]=[/%s%s]+[%s]\n",
			surl,dupath,search,extrapath);
		strcpy(surl+script_namlen,search);
		strcat(durl,search);
		return 1;
	}
	return 0;
}

putLocal(Conn,vno,method,req,head,url,fc,tc,stcodep)
	Connection *Conn;
	char *method,*req,*head,*url;
	FILE *fc,*tc;
	int *stcodep;
{	char dstproto[256];
	char apath[4096];
	char proto[1024],host[256],*pp,urlbuf[4096],hostport[256];
	char *path,upath[4096],ourl[4096];
	char dpath[4096];
	char *execpath,*datapath; /* path of script.exe and data.html */
	char iexecpath[4096],idatapath[4096]; /* index.html extended */
	char *search;
	char server[256];
	char *ctype = NULL;
	char *encoding = ME_7bit;
	int size = 0; int lastmod = 0;
	int expire = 0;
	int leng;
	int ch;
	FILE *fp;
	int notMod = 0;
	int clIfMod;
	int CGIonly = 0;
	int mok;
	char *Search,search_script[1024];
	char script[4096],expath[4096],nupath[4096];
	char texurl[4096],texpath[4096]; /* translated expath */

	HTTP_originalURLPath(Conn,ourl);
	expath[0] = 0;

	Search = http_search_script;
	if( MountOptions ){
		char *dp;
		if( dp = strcasestr(MountOptions,"search:") ){
			search_script[0] = 0;
			sscanf(dp+7,"%[^, ]",search_script);
			if( search_script[0] && strcmp(search_script,"-") != 0 )
				Search = search_script;
			else	Search = NULL;
		}
	}

	if( strcasecmp(DST_PROTO,"cgi") == 0){
		CGIonly = 1;
		if( strip_extrapath(REQ_METHOD,ourl,NULL,nupath,expath) )
			url = nupath;
	}
	strcpy(script,ourl);
	if( search = strchr(script,'?') )
		*search = 0;

	if( streq(method,"POST") || streq(method,"PUT") ){
		CGIonly = 1;
		strcpy(expath,ourl);
		script[0] = 0;
	}

	strcpy(dstproto,DST_PROTO);
	if( localPathProto(dstproto) ){
		strcpy(proto,DST_PROTO);
		strcpy(host,DST_HOST);
		path = url;
	}else{
		path = file_hostpath(url,proto,host);
	}
	if( path == NULL )
		return 0;
	IsLocal = 1;

	if( search = strchr(url,'?') )
		*search++ = 0;

	sprintf(server,"DeleGate/%s",DELEGATE_ver());
	set_realserver(Conn,proto,host,0);

	if( !service_permitted(Conn,proto) ){
		sv1log("REJECT 1\n");
		*stcodep = 403;
		return putHttpRejectmsg(Conn,tc,proto,server,0,req);
	}
	if( !Conn->from_myself && !IsMounted ){
		sv1log("REJECT 2\n");
		*stcodep = 403;
		return putHttpRejectmsg(Conn,tc,proto,server,0,req);
	}

	/*
	 * if the path is not in absolute form, then make it so ...
	 */
	Verbose("## PATH=[%s]\n",path);
	if( *path != '/' ){
		sprintf(apath,"/%s",path);
		path = apath;
	}
	strcpy(upath,path);

	HTTP_ClientIF_HP(Conn,hostport);

	mok == 0;
	if( path[0] == '/' )
	mok = mount_url_fromL(urlbuf,proto,host,path+1,NULL,"http",hostport);
	if( !mok )
	mok = mount_url_fromL(urlbuf,proto,host,path,  NULL,"http",hostport);
	Verbose("## URL=[%s]\n",urlbuf);

	if( localPathProto(dstproto) )
	if( off_limit(urlbuf,upath) ){
		sv1log("REJECT 3\n");
		*stcodep = 403;
		return putHttpRejectmsg(Conn,tc,proto,server,0,req);
	}

	nonxalpha_unescape(path,dpath,1);
	path = dpath;

	Verbose("## UPATH=[%s]\n",upath);
	if( search && Search || CGIonly ){
		if( CGIonly )
			execpath = path;
		else	execpath = Search;
		if( strtailchr(execpath) == '/' ){
			if( fp = openIndex(Conn,execpath,upath,iexecpath,S_EXEC) ){
				execpath = iexecpath;
				fclose(fp);
			}
		}
		if( CGIonly ){
			if( expath[0] ){
				strcpy(texurl,expath);
				datapath = expath;
				if( mount_url_to(method,texurl) ){
					strcpy(texpath,"/");
					decomp_absurl(texurl,NULL,NULL,texpath+1);
					datapath = texpath;
				}
			}else	datapath = execpath;
		}else{
			strcpy(expath,ourl);
			if( search = strchr(expath,'?') )
				*search = 0;
			datapath = path;
			script[0] = 0;
			sv1log("Search-Script: %s %s %s\n",execpath,datapath,expath);
		}
		if( strtailchr(datapath) == '/' ){
			if( fp = openIndex(Conn,datapath,upath,idatapath,S_DATA) ){
				datapath = idatapath;
				fclose(fp);
			}
		}
		IsLocal = 0; /* some side effect might remain ... ? */
		leng = exec_cgi(Conn,req,head,execpath,datapath,ourl,script,expath,fc,tc);
		return leng;
	}

	fp = NULL;
	if( !fileIsdir(path) ){
		fp = fopen(path,"r");
	}else
	if( strtailchr(path) != '/' ){
		strcat(urlbuf,"/");
		*stcodep = 302;
		return putMovedTo(Conn,tc,urlbuf);
	}

	if( leng = putRobotsTxt(Conn,tc,fp,NULL) ){
		if( fp != NULL )
			fclose(fp);
		return leng;
	}

	if( fp == NULL ){
		if( fileIsdir(path) && strtailchr(path) == '/' ){
			fp = openIndex(Conn,path,upath,idatapath,S_EXEC|S_DATA);
			if( fp != NULL ){
				path = idatapath;
				ctype = filename2ctype(idatapath);
			}
		}
		if( fp == NULL ){
			sv1log("Unknown local %s: %s\n",path,proto);
			delayUnknown(Conn,1,req);
			*stcodep = 404;
			return putHttpNotFound(Conn,tc,
				"No such file or directory\r\n");
		}
	}

	if( pp = strstr(path,".cgi") )
	if( pp[4] == 0 )
	/* if( executable ) */
	{
		leng = exec_cgi(Conn,req,head,path,path,ourl,script,expath,fc,tc);
		if( 0 <= leng ){
			fclose(fp);
			IsLocal = 0; /* some side effect might remain ... ? */
			return leng;
		}
	}

	if( ctype == NULL )
		ctype = filename2ctype(path);
	if( ctype == NULL ){
		ctype = "text/plain";
		while( (ch = getc(fp)) != EOF )
			if( ch & 0x80 ){
				ctype = "application/octet-stream";
				encoding = ME_binary;
				break;
			}
		fseek(fp,0,0);
	}
	size = file_size(fileno(fp));
	lastmod = file_mtime(fileno(fp));

	clIfMod = ClientIfModClock(Conn);
	if( 0 < clIfMod ){
		if( lastmod <= clIfMod ){
			notMod = 1;
			sv1log("Not Modified: %s\n",path);
		}
	}

	leng = 0;
	if( strcasecmp(method,"HEAD") == 0 ){
		if( vno < 100 )
			vno = 100;
		leng += putHttpHeaderV(Conn,tc,vno,server,ctype,encoding,size,lastmod,expire);
	}else
	if( check_codeconv(1) || CCXactive(CCX_TOCL) ){
		FILE *tcx;

		DONT_REWRITE = 1;
		tcx = openHttpResponseFilter(Conn,tc);

		leng += putHttpHeaderV(Conn,tcx,vno,server,ctype,encoding,size,lastmod,expire);
		leng += copyfile1(fp,tcx);

		fclose(tcx);
		wait(0);
	}else
	if( notMod ){
		leng += putHttpHeaderX(Conn,tc,vno,server,ctype,encoding,size,lastmod,expire,"304 Not modified");
		*stcodep = 304;
	}else{
		leng += putHttpHeaderV(Conn,tc,vno,server,ctype,encoding,size,lastmod,expire);
		leng += copyfile1(fp,tc);
	}
	fclose(fp);
	return leng;
}

static norobot1(fp,url,proto,user,pass,host,port,path,opts)
	FILE *fp;
	char *url,*proto,*user,*host,*path,*opts;
{	int disable;

	if( strstr(opts,"robots=ok") )
		disable = 0;
	else
	if( strstr(opts,"robots=no") )
		disable = 1;
	else
	if( streq(proto,"nntp") || streq(proto,"ftp") )
		disable = 1;
	else	disable = 0;

	if( disable )
		fprintf(fp,"Disallow: %s\r\n",url);
}
static printNonRobotsMounts(Conn,fp,fmt,name,param)
	Connection *Conn;
	FILE *fp;
	char *fmt,*name,*param;
{
	if( streq(name,"no-robots") )
		scan_mtabserv(norobot1,fp);
}

/* Return true if the request is for "/robots.txt" from a client which
 * regards this DeleGate as an origin HTTP server.  In this case, the
 * original form of the request is like "GET /robots.txt HTTP/1.0".
 * In HTTP/1.1 or later, the existence of "Host: server" field might be
 * considered also ... ?
 */
reqRobotsTxt(Conn)
        Connection *Conn;
{
	return HTTP_originalURLmatch(Conn,"/robots.txt");
}
putRobotsTxt(Conn,tc,afp,stat)
	Connection *Conn;
	FILE *tc;
	FILE *afp;
	char *stat;
{	int leng;
	FILE *org,*gen;

	if( !reqRobotsTxt(Conn) )
		return 0;

	sv1log("#### Generate /robots.txt\n");
	if( afp == NULL ){
		putHttpHeader1(Conn,tc,NULL,"text/plain",ME_7bit,0,0);
		leng = 0;
		fprintf(tc,"#### Generated by a proxy - %s\r\n",
			DELEGATE_version());
		leng += putBuiltinHTML(Conn,tc,"/robots.txt","robots.dhtml",
			NULL,printNonRobotsMounts,NULL);
		fflush(tc);
		return leng;
	}

	org = TMPFILE("RobotsTxt-1");
	copyfile1(afp,org);
	fflush(org);
	fseek(org,0,0);

	gen = TMPFILE("RobotsTxt-2");
	putBuiltinHTML(Conn,gen,"/robots.txt","robots.dhtml",
		NULL,printNonRobotsMounts,NULL);
	fflush(gen);
	fseek(gen,0,0);

	if( stat != NULL )
		fputs(stat,tc);
	else	putHttpHeader1(Conn,tc,NULL,"text/plain",ME_7bit,0,0);

	leng = mergeRobotsTxts(org,gen,tc);
	fflush(tc);

	fclose(org);
	fclose(gen);
	return leng;
}

extern char *freadfile();
mergeRobotsTxts(rtf1,rtf2,out)
	FILE *rtf1,*rtf2,*out;
{	int leng,len,tx,ti,out2;
	char *rts[2],ch,*sp,*np;
	char *records[2][1024],fn[256],val[256],*rs1,*rs2;
	char *wildua[2];
	int wildrec[2];
	char msg[1024];

	len = 0; rts[0] = freadfile(rtf1,&len);
	len = 0; rts[1] = freadfile(rtf2,&len);

	for( ti = 0; ti < 2; ti++ ){
		tx = 0;
		records[ti][tx++] = rts[ti];
		wildrec[ti] = -1;
		wildua[ti] = 0;
		for( sp = rts[ti]; sp && *sp; sp = np ){
			if( wildua[ti] == NULL )
			if( sscanf(sp,"%[^:]:%s",fn,val) == 2 )
			if( strcasecmp(fn,"User-Agent") == 0 )
			if( strcmp(val,"*") == 0 ){
				wildua[ti] = sp;
				wildrec[ti] = tx - 1;;
			}
			if( *sp == '\r' || *sp == '\n' )
				records[ti][tx++] = sp;
			if( np = strchr(sp,'\n') )
				np++;
		}
		records[ti][tx++] = rts[ti] + strlen(rts[ti]);
		records[ti][tx] = 0;
	}

	leng = 0;
	for( tx = 0; (rs1 = records[0][tx]) && *rs1; tx++ ){
		leng += len = records[0][tx+1] - rs1;
		fwrite(rs1,1,len,out);
		if( tx == wildrec[0] && 0 <= (ti = wildrec[1]) ){
			sprintf(msg,"#### Appended by a proxy - %s\r\n",
				DELEGATE_version());
			leng += strlen(msg);
			fwrite(msg,1,strlen(msg),out);

			rs2 = records[1][ti];
			leng += len = wildua[1] - rs2;
			fwrite(rs2,1,len,out);

			fwrite("#",1,1,out);
			leng++;
			leng += len = records[1][ti+1] - wildua[1];
			fwrite(wildua[1],1,len,out);
		}
	}

	out2 = 0;
	for( ti = 0; (rs2 = records[1][ti]) && *rs2; ti++ )
	if( ti != wildrec[1] ){
		if( out2++ == 0 ){
			sprintf(msg,"\r\n");
			sprintf(msg,"#### Generated by a proxy - %s\r\n",
				DELEGATE_version());
			leng += strlen(msg);
			fwrite(msg,1,strlen(msg),out);
		}
		leng += len = records[1][ti+1] - rs2;
		fwrite(rs2,1,len,out);
	}
	return leng;
}

