/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1997 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, modify, and distribute this material for any
purpose and without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies, and
that the name of ETL not be used in advertising or publicity pertaining
to this material without the specific, prior written permission of an
authorized representative of ETL.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	http.h
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	970708	extracted from httpd.c
//////////////////////////////////////////////////////////////////////#*/

#define URLSZ		(16*1024)
#define OBUFSIZE	(16*1024)
#define IBUFSIZE	(16*1024)
#define SOCKBUFSIZE	(16*1024)

#define MY_HTTPVER	"1.0"
#define MY_MIMEVER	"1.0"

#define ME_7bit		((char*)0)
#define ME_binary	"binary"

typedef struct {
	char	r_oreqmsg[0x8000]; /* original request message */
	int	r_oreqlen;

	char	r_oreq[URLSZ];	/* original request line */
	char	r_ohost[1024];	/* original server host */
	int	r_oport;	/* original server port */
	char	r_vhost[256];	/* original Host: field */
	char	r_genhost[256];	/* Host: field to be forwarded */

	char	r_req[URLSZ];	/* HTTP request possibly rewritten */
	char	r_method[128];
	char	r_url[URLSZ];
	char	r_ver[128];
	int	r_vno;

	char	r_fields[0x8000];
	char   *r_lastFname;	/* cache for getRequestField */
	char   *r_lastFbody;	/* (pointers into f_fields) */

	char	r_acclangs[1024]; /* merged list of Accept-Language for log */

	char	r_clntIfmod[256]; /* If-Mod-Since from the  client */
	int	r_clntIfmodClock; /* its value in int */

	int	r_flushhead;
	int	r_flushsmall;

	int	r_code;
	char	r_status[1024];
	int	r_respsav;
	char	r_respmsg[0x8000];
	int	r_resplen;
	int	r_withCookie;
} HTTP_env;

#define CurEnv		((HTTP_env*)Conn->cl_reqbuf)

#define OREQ_MSG	CurEnv->r_oreqmsg
#define OREQ_LEN	CurEnv->r_oreqlen

#define OREQ		CurEnv->r_oreq
#define OREQ_HOST	CurEnv->r_ohost
#define OREQ_PORT	CurEnv->r_oport
#define OREQ_VHOST	CurEnv->r_vhost
#define GEN_VHOST	CurEnv->r_genhost

#define REQ		CurEnv->r_req
#define REQ_FIELDS	CurEnv->r_fields
#define REQ_METHOD	CurEnv->r_method
#define REQ_URL		CurEnv->r_url
#define REQ_VER		CurEnv->r_ver
#define REQ_VNO		CurEnv->r_vno

#define AcceptLanguages	CurEnv->r_acclangs

#define FlushHead	CurEnv->r_flushhead
#define FlushIfSmall	CurEnv->r_flushsmall

#define ClntIfMod	CurEnv->r_clntIfmod
#define ClntIfModClock	CurEnv->r_clntIfmodClock

#define RespCode	CurEnv->r_code
#define RespStatus	CurEnv->r_status
#define RESP_SAV	CurEnv->r_respsav
#define RESP_MSG	CurEnv->r_respmsg
#define RESP_LEN	CurEnv->r_resplen

#define withCookie	CurEnv->r_withCookie
