/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1994-1998 Electrotechnical Laboratry (ETL), AIST, MITI
Copyright (c) 1994-1998 Yutaka Sato

Permission to use, copy, modify, and distribute this material for any
purpose and without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	http.c (HTTP/1.0 proxy)
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	940316	created
//////////////////////////////////////////////////////////////////////#*/
#include "delegate.h"
#include "fpoll.h"
#include "http.h"
#include "vsignal.h"
#define clntClose	HTTP_clntClose

/*
 *	Connection: Keep-Alive
 */
int HTTP_CKA_PERCLIENT      = 4;
int HTTP_CKA_TIMEOUT        = 5;
int HTTP_CKA_TIMEOUT_MARGIN = 2;
int HTTP_CKA_MAXREQ         = 10;

extern int MAX_BUFF_SOCKRECV;
extern int MAX_BUFF_SOCKSEND;
extern int RES_CACHE_DISABLE;

int HTTP_MAXHOPS = 20;

#define F_OKVER		"HTTP/"
#define F_DGVer		"DeleGate-Ver:"
#define F_ContType	"Content-Type:"
#define F_CtypeText	"Content-Type: text"
#define F_CtypePlain	"Content-Type: text/plain"
#define F_CtypeHTML	"Content-Type: text/html"
#define F_ContEncode	"Content-Encoding:"
#define F_ContLeng	"Content-Length:"
#define F_Location	"Location:"
#define F_SetProxy	"Set-Proxy:"
#define F_LastMod	"Last-Modified:"
#define F_Server	"Server:"
#define F_Cookie	"Cookie:"
#define F_SetCookie	"Set-Cookie:"
#define F_Connection	"Connection:"
#define F_PConnection	"Proxy-Connection:"

#define STRH(field,fname) \
	(strncasecmp(field,fname,sizeof(fname)-1)==0?sizeof(fname)-1:0)

static int flen;
#define STRH_Connection(field) \
	((flen=STRH(field,F_Connection))?flen : STRH(field,F_PConnection))


extern FILE *NULLFP();
extern char *Sprintf();
extern char *DDI_fgetsFromC();
extern char *fgetsRequest();
extern char *findFieldValue();
extern char *getFieldValue2();
#define getFieldValue(str,fld,buf,siz) getFieldValue2(str,fld,buf,siz)
#define getFV(str,fld,buf)             getFieldValue2(str,fld,buf,sizeof(buf))
extern FILE *recvDistribution();
extern char *malloc();

static char DGateWay[128];

extern double Time();
static
setConnStart(Conn)Connection *Conn; { CONN_START= Time(); }
setConnDone(Conn) Connection *Conn; { CONN_DONE = Time(); }

#define TIMEOUT_REQ	120

#define protoGopher(proto)	strcaseeq(proto,"gopher")
#define FORWARD_ASIS(req,proto) 0
/*
#define FORWARD_ASIS(req,proto) \
	(TUNNELsock && HTTP_reqIsHTTP(Conn,req) && strcaseeq(proto,"ftp"))
*/

#define R_EMPTY_RESPONSE	-10001
#define R_UNSATISFIED		-10002
#define R_UNSATISFIED_TEXT	-10003
#define R_NONTEXT_INTEXT	-10004
#define R_GENERATED		-10005
#define R_MOVED_LOOP		-10006

#define CS_AUTHERR	'A'
#define CS_CONNERR	'C'
#define CS_ERROR	'E'
#define CS_HITCACHE	'H'
#define CS_INTERNAL	'I'
#define CS_KILLED	'K'
#define CS_MAKESHIFT	'M'	/* connection failed and make shift */
#define CS_EOF		'P'

#define CS_NEW		'N'	/* got first (not found) */
#define CS_OBSOLETE	'O'	/* obsolete (modified) */
#define CS_RELOAD	'R'	/* reload (Pragma: no-cache) */
#define CS_STABLE	'S'	/* stable (not modified) */
#define CS_WITHOUTC	'W'	/* without cache */

static int   GET_CACHE;

static int   DontTruncate;	/* keep the cache in the current state */
static struct {
	int	 on;
	int	 pid;
	char	*cpath;
	FILE	*cachefp;
	FILE	*tc;
     Connection *Conn;
} Relaying;
static char *Where;
static int nsigPIPE;

extern FILE *cache_fopen_rd();
extern FILE *cache_fopen_rw();

static abortCache()
{	FILE *cachefp;

	cachefp = Relaying.cachefp;
	if( cachefp == NULL )
		return;

	if( Relaying.Conn && Relaying.cpath )
		stopDistribution(Relaying.Conn,cachefp,Relaying.cpath);

	/* discards the half done cache file */
	if( !DontTruncate ){
		sv1log("CACHE discards half written cache.\n");
		fflush(cachefp);
		Ftruncate(cachefp,0,0);
		fseek(cachefp,0,0);
	}
}
static int exiting;
static void sigTERM(sig)
{	int now;

	signal(sig,sigTERM);
	now = time(0);
	if( exiting ){
		sv1log("#### duplicate sigTERM in %d seconds\n",now-exiting);
		if( exiting && now-exiting < 10 )
			return;
		else	_Finish(0);
	}
	exiting = now;

	if( Relaying.on ){
		sv1log("HTTP SC got sigTERM(%d) %x\n",sig,Relaying.cpath);
		abortCache();
		if( Relaying.tc != NULL )
			fcloseLinger(Relaying.tc);
		Finish(0); /* flush outputs and exit */
	}else{
		sv1log("HTTP CS got sigTERM(%d)\n",sig);
		_Finish(0);
	}
}
static setRelaying(Conn,tc,cachefp,cpath)
	Connection *Conn;
	FILE *tc,*cachefp;
	char *cpath;
{
	Relaying.on = 1;
	Relaying.pid = getpid();
	Relaying.tc = tc;
	Relaying.cachefp = cachefp;
	Relaying.cpath = cpath;
	Relaying.Conn = Conn;
	Vsignal(SIGTERM,sigTERM);
}
static abortHTTP(msg)
	char *msg;
{
	sv1log("#### EMERGENCY EXIT (%s)\n",msg);
	abortCache();
	_Finish(-1);
}
static void sigPIPE(sig)
{
	signal(SIGPIPE,SIG_IGN); /* sv1log may cause SIGPIPE ... */
	if( nsigPIPE++ % 10 == 0 )
		sv1log("## got SIGPIPE [%d] in HTTP: %s\n",
			nsigPIPE,Where?Where:"");
	signal(SIGPIPE,sigPIPE);
}
static setClientEOF(Conn,tc,fmt,a1,a2,a3)
	Connection *Conn;
	FILE *tc;
	char *fmt,*a1,*a2,*a3;
{	char where[256];

	ClientEOF = 1;
	if( fmt ){
		sprintf(where,fmt,a1,a2,a3);
		sv1log("ClientEOF: %s\n",where);
	}
}
static checkClientEOF(Conn,tc,where)
	Connection *Conn;
	FILE *tc;
	char *where;
{	char *conn_stat;

	if( ClientEOF )
		return ClientEOF;
	if( Conn->from_myself )
		return 0;
	if( IsConnected(Conn->cl_sock,&conn_stat) )
		return 0;

	if( where ){
		clntClose(Conn,"p:premature client EOF (%s)",where);
		sv1log("## premature client close: %s (%s)\n",where,conn_stat);
	}

	detachFile(tc);
	setClientEOF(Conn,tc,where);

	return 1;
}


static decomp_gopherURL(req,path)
	char *req,*path;
{	int gtype;
	char pathb[URLSZ];

	if( path == NULL )
		path = pathb;

	if( scan_http_request(req,0,path,0) ){
	/* Gopher/HTTP where path is URL with gtype */
		/* from client expecting proxy */
		if( path[0] == '/' && path[1] != 0 ){
			/* this should be gtype in URL */
			gtype = path[1];
			strcpy(path,path+2);
		}else
		/* from client without proxy support */
	    		gtype = get_gtype(path,path);

		set_clientgtype(gtype);
		return gtype;

	}else{
	/* Gopher/Gopher */
/* sscanf(req,"%[^\r\n]",path);  */ linescan(req,path,URLSZ);

	    	gtype = get_gtype(path,path);
		set_clientgtype(gtype);
		return 0;
	}
}

static OpenProxy(Conn,req,proto,server,iport)
	Connection *Conn;
	char *req,*proto,*server;
{
	if( !with_PROXY() && !withTmpProxy() )
		return -1;

	if( REAL_PROTO[0] )
		proto = REAL_PROTO;
	else	proto = DFLT_PROTO;

	if( protoGopher(proto) )
		if( get_gtype(req,0) == '7' )
			IsGopherSearch = 1;

	connect_to_proxy(Conn,req,proto,server,iport);

	if( FromS < 0 )
		IsGopherSearch = 0;

	return FromS;
}
static GopherFtp(Conn,svsock,user,pass,server,iport,req)
	Connection *Conn;
	char *user,*pass,*server,*req;
{	char gpath[1024],gtype,path[1024];

/* sscanf(req,"%[^\r\n]",gpath); */ linescan(req,gpath,sizeof(gpath));

	gtype = get_gtype(gpath,path);
	return gopherftp(Conn,svsock,user,pass,server,iport,gtype,path);
}

char *scan_url_userpass(server,user,pass,dfltuser)
	char *server,*user,*pass,*dfltuser;
{	char buff[256],*sp;

	strcpy(user,dfltuser);
	pass[0] = 0;

	sp = strchr(server,'@');
	if( sp == NULL )
		return server;

	sscanf(server,"%[^:@]%*[:]%[^@]",user,pass);
	nonxalpha_unescape(user,buff,1); strcpy(user,buff);
	nonxalpha_unescape(pass,buff,1); strcpy(pass,buff);
	return sp + 1;
}

static HttpFtp(Conn,fc,tc,svsock,server,iport,req)
	Connection *Conn;
	FILE *fc,*tc;
	char *server,*req;
{	int vno;
	char ver[256],method[256],path[2048],gpath[1024],gtype;
	char user[256],pass[256],auser[256],apass[256],auth[512];

	Conn->body_only = !HTTP_reqWithHeader(Conn,req);
	vno = scan_http_request(req,method,path,ver);
	linescan(path,gpath,sizeof(gpath));
	gtype = get_gtype(gpath,path);

	scan_url_userpass(server,user,pass,"anonymous");

	auser[0] = apass[0] = 0;
	if( HTTP_getAuthorization(Conn,0,"",NULL,auser,apass) )
		sprintf(auth,"%s:%s",auser,apass);
	else	auth[0] = 0;

	return httpftp(Conn,fc,tc,ver,method,svsock,
		auth,user,pass,server,iport,gtype,path);
}
static HttpFinger(Conn,vno,sv,server,iport,path)
	Connection *Conn;
{
	if( sv == -1 )
		return 0;
	return httpfinger(Conn,sv,server,iport,path,vno);
}

static http_gateway(Conn,sv,proto,server,iport,fc,tc,req,cache_on_master)
	Connection *Conn;
	char *proto;
	char *server;
	FILE *fc,*tc;
	char *req;
{	char method[256],user[256],pass[256];
	char path[1024],ver[256],request[URLSZ];
	char rserver[256];
	int vno;
	int msock;
	int rcode,rtotal;
	char ctype[128];
	char gtype;
	char *dp;

	Where = "Gatewaying";
	nsigPIPE = 0;

	*path = 0;
	rcode = 200;
	ctype[0] = 0;
	rtotal = 0;
	setConnStart(Conn);
	msock = -1;

DDI_proceedFromC(Conn,fc);

	/* exclude gopher to keep gopher cache shareable with gopher clients */
	/*
	if( sv == -1 )
	if( !protoGopher(proto) )
	if( HTTP_reqIsHTTP(Conn,req) )
	if( force_forward(Conn,proto) || !IsResolvable(server) )
	*/
	/* Connect to the MASTER-DeleGate which can act as proxy_httpd for
	 * ftp/gopher, thus input for it should be the same of this one.
	 */
	if( FORWARD_ASIS(req,proto) ){
		/* Set default server on the MASTER */
		Verbose("FORWARD_ASIS : %s",OREQ);
		strcpy(rserver,server);
		set_realserver(Conn,"http",OREQ_HOST,OREQ_PORT);

		clear_DGinputs(Conn);
		add_DGinputs(Conn,"%s",OREQ);
		strcpy(request,OREQ);

		if( 0 <= (msock = openMaster(Conn,sv,rserver,1)) ){
			setConnDone(Conn);
			sv1log("Forwarding to the MASTER DeleGate < %s\n",rserver);
			rtotal = relay_svcl(Conn,FromC,ToC,msock,msock,1,512);
		}else	rcode = 403;
		goto EXIT;
	}

/* if( strcaseeq(proto,"ftp") || strcaseeq(proto,"file") ) */
	if( strcaseeq(proto,"ftp") ){
		setConnDone(Conn);
		if( vno = scan_http_request(req,method,path,ver) ){
			get_gtype(path,path);
			rtotal = HttpFtp(Conn,fc,tc,sv,server,iport,req);
		}else{
			linescan(req,path,sizeof(path));
			gtype = get_gtype(path,path);
			rtotal = GopherFtp(Conn,sv,user,pass,server,iport,req);
		}
		sprintf(request,"%s %s://%s:%d%s%s",method,proto,server,iport,
			(*path=='/'?"":"/"),path);
		goto EXIT;
	}

	vno = scan_http_request(req,method,path,ver);
	sprintf(request,"GET %s://%s:%d%s HTTP/%s",proto,server,iport,path,ver);

	if( strcaseeq(proto,"wais") ){
		setConnDone(Conn);
		rtotal = HttpWais(Conn,vno,sv,server,iport,path);
		/*goto EXIT;*//* log was done in HttpWais */
		return;
	}
	if( strcaseeq(proto,"finger") ){
		setConnDone(Conn);
		rtotal = HttpFinger(Conn,vno,sv,server,iport,path);
		goto EXIT;
	}
	if( strcaseeq(proto,"news") || strcaseeq(proto,"nntp")
	 || strcaseeq(proto,"pop") ){
		setConnDone(Conn);
		if( path[0] == '/' )
			strcpy(path,path+1);
		else
		if( strncasecmp(path,"news:",5) == 0 )
			strcpy(path,path+5);

		*user = *pass = 0;
		HTTP_getAuthorization(Conn,0,"",NULL,user,pass);
		rtotal = HttpNews(Conn,vno,sv,server,iport,path,request,user,pass);
		if( dp = strchr(user,'@') ){
			server = dp + 1;
		}
		goto EXIT;
	}
	if( strcaseeq(proto,"whois") ){
	}

	if( protoGopher(proto) ){
		if( gtype = decomp_gopherURL(req,path) ){
			vno = HTTP_reqIsHTTP(Conn,req);
			rtotal = HttpGopher(Conn,vno,sv,server,iport,gtype,path);
			sprintf(request,"GET %s://%s:%d/%s",
				proto,server,iport,path);
			goto EXIT;
		}
	}else{
/* sscanf(req,"%[^\r\n]",path);  */ linescan(req,path,sizeof(path));
	}
	sprintf(request,"GET %s://%s:%d/%s",proto,server,iport,path);

	if( 0 <= (msock = openMaster(Conn,sv,server,1)) ){
		setConnDone(Conn);
		if( protoGopher(proto) )
			rtotal = relay_svcl(Conn,-1,ToC,msock,-1,1,512);
		else	rtotal = relay_svcl(Conn,FromC,ToC,msock,msock,1,512);
	}else{
		sv1log("ERROR: cannot connect to a MASTER\n");
		rcode = 403;
		rtotal = 0;
	}

EXIT:
	http_log(Conn,proto,server,iport,request,rcode,ctype,rtotal,0,
		CONN_DONE-CONN_START,Time()-CONN_DONE);

	if( nsigPIPE ){
		clntClose(Conn,"p:premature client EOF on gatewaying");
		setClientEOF(Conn,tc,"gatewaying_%s.SIGPIPE",proto);
	}
}

static relaydata(Conn,fc,ts,timeout)
	Connection *Conn;
	FILE *fc,*ts;
{	int fcd,rcc,bytes;
	char buf[0x2000];

	bytes = 0;
	while( rcc = fgetBuffered(buf,sizeof(buf),fc) ){
		Fwrite(buf,1,rcc,ts);

if( PadCRLF && buf[rcc-1] != '\n' ){
	sv1log("added CRLF at end of line for Mozilla/0.9 (^_^;\n");
	fputs("\r\n",ts);
}

		fflush(ts);
		bytes += rcc;

		strncpy(OREQ_MSG+OREQ_LEN,buf,rcc+1);
		OREQ_LEN += rcc;

		sv1log("Relay_bufferd (%d bytes)\n",rcc);
	}
	fcd = fileno(fc);
	for(;;){
		if( (rcc = readTimeout(fcd,buf,sizeof(buf),timeout)) == 0 )
			break;
		if( Fwrite(buf,1,rcc,ts) <= 0 )
			break;
		fflush(ts);
		sv1log("Relay_nonbuffered (%d+%d bytes)\n",bytes,rcc);
		bytes += rcc;

		strncpy(OREQ_MSG+OREQ_LEN,buf,rcc+1);
		OREQ_LEN += rcc;
	}
	fflush(ts);
	return bytes;
}

static UAspecific(Conn,UA,direct)
	Connection *Conn;
	char *UA;
{	char *dp;

	if( direct ){
		if( dp = strstr(UA,"MSIE ") ){
			if( dp[5] < '3' || strncmp(dp+5,"3.0",3) == 0 && atoi(dp+8) < 1 )
				clntClose(Conn,"o:old MSIE");
		}else
		if( dp = strstr(UA,"Mozilla/") ){
			if( dp[8] < '2' )
				FlushHead = 50;
			else
			if( dp[8] < '3' && WillKeepAlive )
				FlushIfSmall = 1;
		}
	}

	if( strstr(UA,"Mozilla/0.9") )
		PadCRLF = 1;

	if( dp = strstr(UA,"MSIE ") )
	if( dp[5] < '3' || strncmp(dp+5,"3.0",3)==0 && atoi(dp+8) < 1 )
		SimpleContType = 1;

	if( dp = strstr(UA,"Mosaic") )
	if( dp = strstr(dp,"/") )
	if( strcmp(dp+1,"2.6") < 0 )
		SimpleContType = 1;

	if( dp = strstr(UA,"Lynx") )
	if( dp = strstr(dp,"/") )
		SimpleContType = 1;
}

/* The following stuff is for Mozillas older than 3.0.
 * Either flushHead or Keep-Alive:close is necessary to let their Keep-Alive
 * work properly.
 * - Keep-Alive:close is preferable because their performance by Keep-Alive
 *   with flushHead isn't so good.
 * - But flushHead is preferable when RTT is long...
 */
modifyConnection(Conn,rlength)
	Connection *Conn;
{
	if( FlushIfSmall )
	if( rlength < 1024 )
		HTTP_clntClose(Conn,"o:old Mozilla");
}

static clientAskedKeepAlive(Conn,fname,value)
	Connection *Conn;
	char *fname,*value;
{
	Strncpy(ConnFname,fname,sizeof(ConnFname));
	if( strcasecmp(value,"keep-alive") == 0 ){
		ClntKeepAlive = 1; /* client requests so */
		if( 1 < CKA_RemAlive )
			WillKeepAlive = 1; /* I will do so */
		else	WillKeepAlive = 0;
	}else
	if( strcasecmp(value,"close") == 0 ){
		clntClose(Conn,"c:client's will");
		ClntKeepAlive = 0;
		WillKeepAlive = 0;
	}
}

/*
This should be splited into relayRequestHead() and relayRequestBody()
 */
static relay_request(Conn,request,fields,fc,ts,headonly,in_header,cpath,cdate)
	Connection *Conn;
	char *request,*fields;
	FILE *fc,*ts;
	char *cpath;
{	char req[URLSZ];
	char value[256];
	int fnlen;
	int lines;
	int bytes;
	int sentFrom;
	int tsEOF;
	char public[256];
	char *tail;
	char UA[1024],Via[2048],connection[256],fname[256];

	if( headonly && !in_header )
		return 0;

	sentFrom = 0;
	ClntIfMod[0] = 0;
	ClntIfModClock = -1;
	if( LockedByClient ){ free(LockedByClient); LockedByClient = 0; }
	tsEOF = 0;
	lines = bytes = 0;
	tail = fields;
	public[0] = 0;
	D_HOPS = 0;
	UA[0] = Via[0] = 0;
	connection[0] = 0;

	if( in_header )
	for(;;){
		if( fgetsRequest(Conn,req,sizeof(req),fc) == NULL ){
			setClientEOF(Conn,fc,"relay_request");
			break;
		}
		lines += 1;
		bytes += strlen(req);

		value[0] = 0;
		if( fnlen = STRH_Connection(req) ){
			sscanf(req,"%[^:]",fname);
			linescan(req+fnlen,value,sizeof(value));
			clientAskedKeepAlive(Conn,fname,value);

			if( connection[0] != 0 )
				strcat(connection,",");
			strcat(connection,value);
			continue;
		}else
		if( strncasecmp(req,"Host:",5) == 0 ){
		}else
		if( strncasecmp(req,"Public-DeleGate:",16) == 0 ){
			strcpy(public,req+16);
		}else
		if( strncasecmp(req,"From:",5) == 0 ){
			sv1log("%s",req);
			if( strpbrk(req,"/(") )
				strcat(Via,req);
		}else
		if( strncasecmp(req,"Forwarded:",10) == 0 ){
			strcat(Via,req);
			D_HOPS++;
		}else
		if( strncasecmp(req,"Via:",4) == 0 ){
			strcat(Via,req);
			D_HOPS++;
		}else
		if( strncasecmp(req,"User-Agent:",11) == 0 ){
			linescan(req+11,UA,sizeof(UA));
		}else
		if( strncasecmp(req,"Referer:",8) == 0 ){
			/*sv1log("%s",req);*/
			/*stripDeleGate(Conn,req+8);*/
		}else
		if( strncasecmp(req,"Authorization:",14) == 0 ){
		}else
		if( strncasecmp(req,"Accept-Language:",16) == 0 ){
			HTTP_scanAcceptCharcode(Conn,req);
			if( *req == 0 )
				continue;
		}else
		if( strncasecmp(req,"If-Modified-Since:",18) == 0 ){
			strcpy(ClntIfMod,req);
			linescan(ClntIfMod+18,value,sizeof(value));
			ClntIfModClock = scantime(value,NULL);
			sv1log("= (%d) %s",ClntIfModClock,req);
			continue;
		}else
		if( strncasecmp(req,"Pragma:",7) == 0 ){
			Verbose("%s",req);
			sscanf(req,"%*s %[^ \t\r\n]",value);
			if( strcaseeq(value,"no-cache")){
				DontReadCache = 1;
				PragmaNoCache = 1;
				RES_CACHE_DISABLE = 1;
			}else
			if( strcaseeq(value,"cache-readonly") ){
				DontWriteCache = 1;
				continue;
			}else
			if( strcaseeq(value,"cache-only") ){
				CacheOnly = 1;
				DontWriteCache = 1;
				continue;
			}
		}else
		if( strncmp(req,"X-Locking: ",11) == 0 ){
			linescan(req+11,value,sizeof(value));
			LockedByClient = strdup(value);
			continue;
		}

		if( *req == '\r' || *req == '\n' ){
			/* Append some fields at the end of header fields */
			if( !sentFrom ){
				sentFrom = 1;
/*
This should be the E-mail address of proxy for security consideration.
if( tail )tail = Sprintf(tail,"From: %s\r\n",D_FROM);
if( ts != NULL ) fprintf(ts,  "From: %s\r\n",D_FROM);
*/
			}
		}

if( tail )tail = Sprintf(tail,"%s",req);
if( ts != NULL ){
			if( fputs(req,ts) == EOF ){
				tsEOF = 1;
				break;
			}
		}

		if( *req == '\r' || *req == '\n' ){
			if( AcceptLanguages && AcceptLanguages[0] )
				Verbose("Accept-Language: %s\n",AcceptLanguages);
			Verbose("HTTP Relay_request_head (%d bytes/%d lines)\n",
				bytes,lines);
			break;
		}
	}

	if( in_header ){
		char *user,host[256],UaVia[1024],*dp;
		extern char *getClientUserC();
		int port,direct;

		strcpy(host,"-");
		port = getClientHostPort(Conn,host);

		for( dp = Via; *dp; dp++ ){
			switch( *dp ){
				case '\r': *dp = ';'; break;
				case '\n': *dp = ' '; break;
			}
		}
		direct = Via[0] == 0 && strstr(UA," via ") == NULL;
		sprintf(UaVia,"host=%s; User-Agent: %s; %s",host,UA,
			direct?"DIRECT":Via);
		if( !LOG_GENERIC || !fputLog(Conn,"Proxy","%s\n",UaVia) )
			    sv1log("Proxy: %s\n",UaVia);
		if( LOG_GENERIC ){
			if( (user = getClientUserC(Conn)) == NULL )
				user = "-";
			fputLog(Conn,"Client","%s@%s; agent=%s\n",user,host,UA);
		}

		if( connection[0] && RequestSerno == 0 )
		sv1log("HCKA:[%d] %s; host=%s; (%sUser-Agent: %s)\n",
			RequestSerno,connection,host,Via,UA);

		if( WillKeepAlive )
			if( ImMaster || !direct )
				clntClose(Conn,"v:via proxy");

		/* if this is the front most DeleGate for the client ... */
		if( !ImMaster )
			UAspecific(Conn,UA,direct);
	}

	if( public[0] )
		keepPublic(Conn,public,fileno(fc));

	if( ts != NULL && !tsEOF ){
		if( !ClientEOF && !headonly ){
			lines = 0;
			DDI_proceedFromC(Conn,fc);
			bytes = relaydata(Conn,fc,ts,TIMEOUT_REQ);
		}
		fflush(ts);
	}

	Verbose("HTTP Relay_request done (%d bytes/%d lines)\n",bytes,lines);
	return lines;
}

static recvRequestFields(Conn,fc)
	Connection *Conn;
	FILE *fc;
{
	if( REQ_FIELDS[0] != 0 ){
		/* already got */
		return;
	}
	if( HTTP_reqIsHTTP(Conn,REQ) ){
		if( HTTP_reqWithHeader(Conn,REQ) )
			relay_request(Conn,REQ,REQ_FIELDS,fc,NULL,1,1,NULL,-1);
		else	DontWriteCache = 1;
	}else{
		/* a Gopher request without such request fields */
	}
}

static lastmtime(line)
	char *line;
{	char scdate[1024];

	linescan(line,scdate,sizeof(scdate));
	return scantime(scdate,NULL);
}

static LockedByC(Conn,cpath,fc)
	Connection *Conn;
	char *cpath;
	FILE *fc;
{	char fileId[1024];

	if( cpath == NULL || cpath[0] == 0 )
		return -1;
	if( LockedByClient == 0 )
		return 0;

	getFileUID(fileId,cpath);
	if( streq(LockedByClient,fileId) ){
		sv1log("--- cache is locked by client: %s\n",cpath);
		DontUseCache = 1;
		DontReadCache = DontWriteCache = DontWaitCache = 1;
		return 1;
	}
	return 0;
}
getFileUID(fileId,path,peerver)
	char *fileId,*path,*peerver;
{	char host[256],fileid[URLSZ];
	char *addr,*gethostaddr();

	/* if the file is on NFS, should use the name of NFS server */
	GetHostname(host,sizeof(host));

	/* if( peerver < 5.3.1 ) */
		sprintf(fileId,"%s:%s",gethostaddr(host),path);
	/*
	else{
		strcpy(fileid,"file://");
		strcat(fileid,host);
		strcat(fileid,"/");
		strcat(fileid,path);
		toMD5(fileid,fileId);
		sv1log("%s = %s\n",fileId,fileid);
	}
	*/
}

extern int FULL_URL;

static withConversion(Conn,checkxf)
	Connection *Conn;
{
	/* URL CONVERSIONS */
	if( DO_DELEGATE || IsMounted || FULL_URL )
		return 1;

	/* CHARACTER CODE CONVERSION */
	if( cur_codeconvCL(NULL) || CCXactive(CCX_TOCL) )
		return 1;

	/* HTML CONVERSIONS */

	/* EXTERNAL FILTERS */
	if( checkxf && Conn->xf_filters )
		return 1;

	return 0;
}


/*
 * Check if some setup of proxy for some conversion have changed
 * after the client cached the data.  If so, whole data should be sent
 * as the response regardless of the modification of original data.
 * So ignore If-Modified-Since to get the body if cache is not.
 * and ignore 304 Not Modified response when the cache is.
 */
extern int DELEGATE_LastModified;
static forceBodyResponse(Conn)
	Connection *Conn;
{
	if( !withConversion(Conn,1) )
		return 0;

	if( 0 < ClntIfModClock )
	if( ClntIfModClock < DELEGATE_LastModified ){
		sv1log("DeleGated is Modified after the data: %d > %d\n",
			DELEGATE_LastModified,ClntIfModClock);
		return 1;
	}
	return 0;
}

static cacheReadOK(cachefp)
	FILE *cachefp;
{
	if( cachefp == NULL )
		return 0;
	if( file_size(fileno(cachefp)) <= 0 )
		return 0;
	return 1;
}

/*
 * Set `If-Modified-Since: cdate' if not specified by the client.
 */
static setIfModified(Conn,req_fields,req,cachefp,cpath,cdate)
	Connection *Conn;
	char *req_fields,*req;
	FILE *cachefp;
	char *cpath;
{	char scdate[64],mod[64];
	int lastmod;

	if(forceBodyResponse(Conn) && cachefp==NULL && !LockedByC(Conn,cpath,NULL)){
		/* need data anyway to produece the body response regardless
		 *  of the modified date, so ignore and don't produce If-Mod.
		 */
		sv1log("ignore and don't produce If-Modified-Since\n");
		return;
	}
	if(cpath==NULL||cdate==-1||cachefp==NULL||DontUseCache||DontReadCache){
		/* local cache is not useful, pass Client's request as is */
		if( ClntIfMod[0] )
			RFC822_addHeaderField(req_fields,ClntIfMod);
		return;
	}

	/*
	 * local cache file is available
	 */
	lastmod = HTTP_getLastModInCache(scdate,sizeof(scdate),cachefp,cpath);

	if( ClntIfMod[0] && lastmod <= ClntIfModClock ){
		RFC822_addHeaderField(req_fields,ClntIfMod);
		CacheLastMod = ClntIfModClock;
		return;
	}

	if( lastmod == 0 )
		lastmod = HTTP_genLastMod(scdate,sizeof(scdate),cachefp,cpath);
	CacheLastMod = lastmod;

	sprintf(mod,"If-Modified-Since: %s\r\n",scdate);
	RFC822_addHeaderField(req_fields,mod);
	Verbose("+ %s",mod);
}

redirectXdisplay(Conn,fc,method,req,fields,bodyp,blengp)
	Connection *Conn;
	FILE *fc;
	char *method,*req,*fields,**bodyp;
	int *blengp;
{	int xpid;
	int bleng;
	int rcc;
	char *body;
	char cleng[256],uagent[256],ctype[256],display[256],xproxy[256],*rem;
	char edisplay[256],exproxy[256];
	char myname[256],peername[256];
	char me[256],myhp[256];

	if( !strcaseeq(method,"POST") )
		return 0;

	if( getFV(fields,"User-Agent",uagent) == NULL )
		return 0;
	if( strstr(uagent,"X11") == NULL && strstr(uagent,"X Window") == NULL)
		return 0;

	if( getFV(fields,"Content-Type",ctype) == NULL )
		return 0;
	if( strstr(ctype,"application/") != ctype )
		return 0;
	if( strstr(ctype,"www-form-urlencoded") == NULL )
		return 0;

	if( getFV(fields,"Content-Length",cleng) == NULL )
		return 0;
	bleng = atoi(cleng);
	if( bleng == 0 )
		return 0;

	body = malloc(bleng+100);
	DDI_proceedFromC(Conn,fc);
	rcc = fread(body,1,bleng,fc);
	body[rcc] = 0;
	*bodyp = body;
	*blengp = rcc;
	if( rcc != bleng ){
		sv1log("#### Content-Length: %d != real length=%d\n",bleng,rcc);
		bleng = rcc;
	}

	if( 0 < rcc ){
		strncpy(OREQ_MSG+OREQ_LEN,body,rcc+1);
		OREQ_LEN += rcc;
	}

	if( strncmp(body,"proxy_request=",14) == 0 ){
		char xbody[4096];
		nonxalpha_unescape(body,xbody,0);
		Verbose("#### POST REQUEST BODY ####\n%s\n",xbody);
		strcpy(req,"GET ");
		strcpy(req+4,req+5);
		Verbose("#### REQUEST ####\n%s",req);
		return 0;
	}

	if( strncmp(body,"display=",8) != 0 )
		return 0;

	sscanf(body+8,"%[^&]",edisplay);
	nonxalpha_unescape(edisplay,display,0);
	if( strchr(display,':') == NULL )
		return 0;

	rem = strdup(body+8+strlen(edisplay));
	gethostNAME(ToS,myname,NULL,NULL);
	getpeerNAME(ToS,peername,NULL,NULL);
	ClientIF_HP(Conn,myhp);
	sprintf(me,"%s://%s/",DFLT_PROTO,myhp);
	xpid = makeXproxy(Conn,xproxy,display,myname,peername,me,60);
	sv1log("#### Xproxy[%d]: %s <- %s <- %s\n",xpid,display,xproxy,peername);

	if( xpid == 0 )
		return 0;

	nonxalpha_escape(xproxy,exproxy);
	sprintf(body,"display=%s%s",exproxy,rem);
	free(rem);
	bleng += strlen(exproxy) - strlen(edisplay);
	sprintf(cleng,"%d",bleng);
	replaceFieldValue(fields,"Content-Length",cleng);

	*bodyp = body;
	*blengp = bleng;
	return xpid;
}

static relayRequestBody1(Conn,fc,ts,req,fields)
	Connection *Conn;
	FILE *fc,*ts;
	char *req,*fields;
{	char cleng[128];
	int bleng,bsize;
	int ch;
	int bn;
	char *bbuff;
	int nready;

	if( getFV(fields,"Content-Length",cleng) == 0 )
		return 0;

	bleng = atoi(cleng);
	bsize = bleng + 1024;
	bbuff = malloc(bleng+1024);

	bn = DDI_flushCbuf(Conn,bbuff,bsize);
	DDI_proceedFromC(Conn,fc); /* it clears Cbuf ... */

	for( ; bn < bleng || 0 < READYCC(fc); bn++ ){
		if( bn < bleng && (nready = frPollIn(fc,1000)) <= 0 ){
			if( nready < 0 )
				setClientEOF(Conn,fc,"relayRequestBody-1");
			sv1log("#### ERROR: IMMATURE REQUEST BODY (%d/%d)\n",
				bn, bleng);
			break;
		}
		ch = getc(fc);
		if( ch == EOF ){
			setClientEOF(Conn,fc,"relayRequestBody-2");
			break;
		}
		if( bsize <= bn ){
			bsize += 1024;
			bbuff = (char*)realloc(bbuff,bsize);
		}
		bbuff[bn] = ch;
		if( OREQ_LEN < sizeof(OREQ_MSG) )
		OREQ_MSG[OREQ_LEN++] = ch;
	}
	bbuff[bn] = 0;
	if( OREQ_LEN < sizeof(OREQ_MSG) )
	OREQ_MSG[OREQ_LEN] = 0;

	fputs(req,ts);
	fputs(fields,ts);
	fwrite(bbuff,1,bn,ts);
	fflush(ts);

	free(bbuff);
	return 1;
}

static relayBuffered(in,out)
	FILE *in,*out;
{	int rcc;
	char buf[1024];

	fflush(out);
	while( rcc = fgetBuffered(buf,sizeof(buf),in) ){
		if( Fwrite(buf,1,rcc,out) <= 0 )
			return;
	}
	while( 0 < PollIn(fileno(in),1000) ){
		rcc = read(fileno(in),buf,sizeof(buf));
		if( rcc <= 0 )
			break;
		if( write(fileno(out),buf,rcc) != rcc )
			break;
	}
}

static generateProxyFields(Conn,fields,cpath)
	Connection *Conn;
	char *fields;
	char *cpath;
{	char *gfp;
	char forwarded[256],received_by[256];
	char *auth,atype[128],genauth[256];
	char buf[1024],buf2[1024];
	char *dp;
	int withAuth;

	gfp = fields;
	*gfp = 0;

	if( findFieldValue(REQ_FIELDS,"From") == NULL )
	if( makeFrom(Conn,buf) ){
		Verbose("## GEN From: %s\n",buf);
		gfp = Sprintf(gfp,"From: %s\r\n",buf);
	}
	if( makeForwarded(Conn,forwarded) ){
		Verbose("## GEN Forwarded: %s\n",forwarded);
		gfp = Sprintf(gfp,"Forwarded: %s\r\n",forwarded);
	}
	HTTP_genVia(Conn,1,received_by);
	gfp = Sprintf(gfp,"Via: %s\r\n",received_by);

	withAuth = 0;
	if( auth = findFieldValue(REQ_FIELDS,"Authorization") )
	if( HTTP_decodeAuthorization(auth,atype,buf) ){
		if( buf[0] == 0 || buf[0] == ':' )
			sv1log("## ignore empty Authorization [%s]\n",buf);
		else{
			Verbose("## PASS Authorization: %s %s\n",atype,"");
			withAuth = 1;
		}
	}
	if( IsMounted && strchr(REAL_SITE,'@') ){
		strcpy(buf2,REAL_SITE);
		*strchr(buf2,'@') = 0;
		str_to64(buf2,strlen(buf2),buf,sizeof(buf),1);
		if( dp = strpbrk(buf,"\r\n") )
			*dp = 0;
		strcpy(atype,"Basic");
		sprintf(genauth,"%s %s",atype,buf);
		sv1log("## MOUNT Authorization: %s [%s]\n",genauth,buf2);
		gfp = Sprintf(gfp,"Authorization: %s\r\n",genauth);
	}else
	if( withAuth == 0 )
	if( makeAuthorization(Conn,genauth) ){
		sscanf(genauth,"%s %s",atype,buf);
		str_from64(buf,strlen(buf),buf2,sizeof(buf2));
		sv1log("## GEN Authorization: %s [%s]\n",genauth,buf2);
		gfp = Sprintf(gfp,"Authorization: %s\r\n",genauth);
	}

	if( cpath != NULL )
	if( toProxy || toMaster )
	{	char fileId[URLSZ];

		getFileUID(fileId,cpath);
		gfp = Sprintf(gfp,"X-Locking: %s\r\n",fileId);
	}
}
/*
 * relayRequest in background is to simplify implementation of request
 * relay without knowing whether or not the request method has request body
 * which EOF could not be determined without knowledge, thus difficult to be
 * done in foreground before relaying the response.
 * HINT: HTTP header can be relayed in foreground without any knowledge :-D
 */
static relayRequest(Conn,cpath,cdate,fc,ts)
	Connection *Conn;
	char *cpath;
	FILE *fc,*ts;
{	register int ppid,cpid;
	char method[128];
	int in_header;
	int with_reqbody;
	char *body;
	int bleng;
	int xpid;
	char genfields[0x8000];

	if( !HTTP_reqWithHeader(Conn,REQ) ){
		fputs(REQ,ts);
		if( !HTTP_isMethod(REQ) ){
			relayBuffered(fc,ts);
			/* should be relayed by parallel thread/process */
		}
		fflush(ts);
		return 0;
	}

	wordscan2(REQ,method,sizeof(method));
	with_reqbody = !HTTP_methodWithoutBody(method);

	generateProxyFields(Conn,genfields,cpath);
	strcat(genfields,REQ_FIELDS);

	if( with_reqbody ){
		if( relayRequestBody1(Conn,fc,ts,REQ,genfields) )
			return 0;
		if( ClientEOF )
			return 0;

		ppid = getpid();
		if( cpid = Fork("relayRequest") ){
			if( cpid == -1 ){
				/* should send TOO BUSY message to the client */
				sv1tlog("CANNOT FORK\n");
				Finish(1);
			}
			return cpid;
		}
		Relaying.on = 0;
		Vsignal(SIGTERM,sigTERM);
	}

bleng = 0;
body = NULL;
xpid = redirectXdisplay(Conn,fc,method,REQ,REQ_FIELDS,&body,&bleng);

	fputs(REQ,ts);
	fputs(genfields,ts);

	if( body != NULL ){
		fwrite(body,1,bleng,ts);
		free(body);
	}
	Verbose("HTTP relayed request %dhead+%dbody\n",strlen(REQ_FIELDS),bleng);

	if( with_reqbody ){
		relay_request(Conn,REQ,0,fc,ts,0,0,cpath,-1);
		if( feof(fc) ){
			sv1log("Kill (%d/%d, SIGTERM)\n",ppid,getppid());
			Kill(ppid,SIGTERM);
		}else{
			Verbose("C-S relay TIMEOUT\n");
		}
		/* if( xpid ) Kill(xpid,SIGTERM); */
		Finish(0);
	}else{
		if( ts != NULL )
			fflush(ts);
		return 0;
	}
}

static char anchor_rem[128];
/* Pushed back fragment of anchor tag which is folded into multiple lines.
 * Should be treated in general way in the input buffer operation... (-_-;
 */

static setReferer(Conn,proto,host,port,req,referer,refbuf)
	Connection *Conn;
	char *proto,*host,*req;
	Referer *referer;
	char *refbuf;
{	char *rp,*bp;

	rp = refbuf;

	referer->r_my_hostport = rp;
	HTTP_ClientIF_HP(Conn,rp);
	rp += strlen(rp) + 1;

	referer->r_my_proto = CLNT_PROTO;
	referer->r_my_host = rp;
	referer->r_my_port = HTTP_ClientIF_H(Conn,rp);
	rp += strlen(rp) + 1;

	if( REMOTE_HOST[0] ){
		proto = REMOTE_PROTO;
		host = REMOTE_HOST;
		port = REMOTE_PORT;
	}

	referer->r_proto = rp;
	strcpy(rp,proto);
	rp += strlen(rp) + 1;

	referer->r_host = rp;
	strcpy(rp,host);
	rp += strlen(rp) + 1;

	referer->r_port = port;

	referer->r_hostport = rp;
	HostPort(rp,proto,host,port);
	rp += strlen(rp) + 1;

	referer->r_path = rp;
	rp[0] = 0;
	sscanf(req,"%*s %s",rp);
	/*if( toProxy )*/
	strip_urlhead(rp,NULL,NULL);
	rp += strlen(rp) + 1;

	referer->r_base = rp;
	strcpy(rp,referer->r_path);
	if( bp = strrchr(rp,'/') )
		bp[1] = 0;
	else	rp[0] = 0;
	rp += strlen(rp) + 1;

	referer->r_my_path = rp;
	strcpy(rp,Conn->cl_urlbase);
	rp += strlen(rp) + 1;

	referer->r_altbuf = rp;
}

static url_abs_delegateS(Conn,do_delegate,referer,src,dst)
	Connection *Conn;
	Referer *referer;
	char *src,*dst;
{	char buf[0x10000];

	/*if( do_delegate || something-MOUNTed )*/
		url_absoluteS(referer,src,buf);
	url_delegateS(referer,buf,dst,do_delegate?Conn:NULL);
}
static redirect_HTMLS(Conn,dont_rewrite,do_delegate,referer,src,dst)
	Connection *Conn;
	Referer *referer;
	char *src,*dst;
{
	if( dont_rewrite )
		url_absoluteS(referer,src,dst);
	else	url_abs_delegateS(Conn,do_delegate,referer,src,dst);
}
redirect_HTML0(Conn,proto,host,port,req,src,dst)
	Connection *Conn;
	char *proto,*host,*req;
	char *src,*dst;
{	Referer referer;
	char refbuf[URLSZ];

	setReferer(Conn,proto,host,port,req,&referer,refbuf);
	redirect_HTMLS(Conn,DONT_REWRITE,DO_DELEGATE,&referer,src,dst);
}

static char *Lines[2];
#define RESP_LINEBUFSIZE	0x10000
static char *Line(line0,ln)
	char *line0;
{	int lx;

	if( ln == 0 )
		return line0;
	lx = ln % 2;
	if( Lines[lx] == NULL )
		Lines[lx] = malloc(RESP_LINEBUFSIZE);
	return Lines[lx];
}
#define Cline	Line(line0,linex+0)
#define Nline	Line(line0,linex+1)

static http_fputs(Conn,referer,line0,ctype,doconv,deent,tc)
	Connection *Conn;
	Referer *referer;
	char *line0,*ctype;
	FILE *tc;
{	int linex;

	linex = 0;

	if( !RelayTHRU )
	if( BORN_SPECIALIST || ACT_SPECIALIST ){
		if( anchor_rem[0] ){
			strcpy(Nline,anchor_rem);
			strcat(Nline,Cline);
			linex++;
			anchor_rem[0] = 0;
		}
		if( !DONT_REWRITE || FULL_URL )
		if( html_nexturl(Cline,anchor_rem,NULL) ){
			redirect_HTMLS(Conn,DONT_REWRITE,DO_DELEGATE,referer,Cline,Nline);
			linex++;
		}
		if( deent ){
			decode_entities(Cline,Nline);
			linex++;
		}
		if( doconv ){
			if( CCXactive(CCX_TOCL) )
				CCXexec(CCX_TOCL,Cline,strlen(Cline),
					Nline,RESP_LINEBUFSIZE);
			else	line_codeconv(Cline,Nline,ctype);
			linex++;
		}
	}
	if( fputs(Cline,tc) == EOF ){
		setClientEOF(Conn,tc,"http_fputs");
		return 0;
	}else	return strlen(Cline);
}

#define FPUTS(line,ctype,doconv,deent,tc) \
	( !RelayTHRU && (BORN_SPECIALIST || ACT_SPECIALIST) ) \
	? http_fputs(Conn,referer,line,ctype,doconv,deent,tc) \
	: (fputs(line,tc),strlen(line))


#define TX_PLAIN	1
#define TX_HTML		2
#define TX_MISC		3

#define STATIC

extern char *fgetsByBlock();
STATIC
char *fgetsResponse(Conn,niced,line,size,fs,byline,fromcache,lengp,isbinp)
	Connection *Conn;
	char *line;
	FILE *fs;
	int *lengp,*isbinp;
{	int cc;
	char *rcode;

	rcode = fgetsByBlock(line,size,fs,niced,byline,fromcache,lengp,isbinp);
	cc = *lengp;
	if( RESP_SAV ){
		bcopy(line,RESP_MSG+RESP_LEN,cc+1);
		RESP_LEN += cc;
	}
	return rcode;
}

/*
fflush after the header is put makes separated header/body and let
the server on Solaris2.X be slower...  But, this is necessary in
BSDI-1.x to avoid the header from being put after the body X-<
*/
#ifdef __bsdi__
#include <sys/param.h>
#if !defined(_BSDI_VERSION) || _BSDI_VERSION < 199501
#define HeadFlush 1
#endif
#endif
#ifndef HeadFlush
#define HeadFlush 0
#endif

STATIC flushHead(Conn,tc,length)
	Connection *Conn;
	FILE *tc;
{
/*
	if( 0 < length && length < 1024 )
*/
 	if( !HeadFlush && !FlushHead )
		return 0;

	if( fflush(tc) == EOF ){
		setClientEOF(Conn,tc,"flushHead");
		return EOF;
	}

	Verbose("HeadFlush:%d, FlushHead:%d(msec)\n",HeadFlush,FlushHead);
	if( FlushHead )
		msleep(FlushHead);

	return 0;
}

static int emulateNCSA;

extern FILE *TMPFILE();
static int respBuffer = -1;
HTTP_putMIMEmsg(Conn,in,out)
	Connection *Conn;
	FILE *in,*out;
{	char line[1024];
	int oleng,nleng,wleng;
	/* SHOULD rewrite "Line:" header also */

	oleng = 0;
	for(;;){
		if( fgets(line,sizeof(line),in) == NULL ) break;
		if( line[0] == '\r' || line[0] == '\n' ) break;
		if( STRH(line,F_ContLeng) )
			oleng = atoi(line+strlen(F_ContLeng));
	}
	nleng = file_size(fileno(in)) - ftell(in);
	sv1log("Content-Length: %d -> %d\n",oleng,nleng);

	fseek(in,0,0);
	for(;;){
		if( fgets(line,sizeof(line),in) == NULL ) break;
		if( line[0] == '\r' || line[0] == '\n' ){
			fprintf(out,"%s %d\r\n",F_ContLeng,nleng);
			fputs(line,out);
			break;
		}
		if( STRH(line,F_ContLeng) ) continue;
		fputs(line,out);
	}

	if( Conn && flushHead(Conn,out,nleng) != 0 ){
 sv1log("## stop relay-3: flush()=EOF, client seems dead\n");
		return -1;
	}else{
		wleng = copy_fileTIMEOUT(in,out,NULL);
		if( wleng != nleng ){
 sv1log("## stop relay-4: FWRITE(%d)=%d, SIGPIPE=%d, client seems dead\n",
 nleng,wleng,nsigPIPE);
			return -1;
		}
	}
	return wleng;
}

static distFromCache(Conn,proto,server,iport,req,tc,cpath,cachefp)
	Connection *Conn;
	char *proto,*server,*req;
	FILE *tc;
	char *cpath;
	FILE *cachefp;
{	int rcode;
	char scdate[256];
	char dcpath[URLSZ];
	int start;
	int lastmod;
	FILE *dcfp;
	int ready;

	lock_sharedNB(fileno(cachefp));
	stopDistribution(Conn,cachefp,cpath);

/*
 * copying too large file (larger than 1M bytes ?) should be avoided not to
 * make slower response to ther client and headvy load the the server...
 */

	dcpath[0] = 0;
	dcfp = NULL;
	ready = 0;

	lastmod = HTTP_getLastModInCache(scdate,sizeof(scdate),cachefp,cpath);
	if( lastmod ){
		start = time(0);
		sprintf(dcpath,"%s#%d",cpath,lastmod);
		dcfp = fopen(dcpath,"r");
		if( dcfp != NULL ){
			lock_unlock(fileno(cachefp));
			Verbose("distFromCache: share %s\n",dcpath);
			ready = 1;
		}else{
			dcfp = dirfopen("distFromCache",dcpath,"w+");
			Verbose("distFromCache: created %s\n",dcpath);
		}
	}
	if( dcfp == NULL ){
		dcfp = TMPFILE("distFromCache");
		if( dcfp == NULL ){
			dcfp = fdopen(dup(fileno(cachefp)),"r");
			Verbose("distFromCache: WITHOUT-LOCK %s\n",cpath);
			ready = -1;
		}
	}
	if( !ready ){
		copyfile1(cachefp,dcfp);
		fflush(dcfp);
		fseek(dcfp,0,0);
		lock_unlock(fileno(cachefp));
	}

	rcode = relay_response(Conn,0,proto,server,iport,req,
		dcpath,1,dcfp,tc,NULL,NULL,1);

if( ready )
lock_unlock(fileno(cachefp));
lock_unlock(fileno(dcfp));

	fclose(dcfp);

	if( dcpath[0] ){
		int ucode;

		ucode = unlink(dcpath);
		Verbose("distFromCache: %d unlink=%d [%ds] %s\n",
			ready,ucode,time(0)-start,dcpath);
	}
	return rcode;
}

static FILE *detach_respbuff(Conn,tc_buf,tc,checkHead,reason)
	Connection *Conn;
	FILE *tc_buf,*tc;
	char *reason;
{	char field[1024],conn[1024];
	int fnlen;

	sv1log("detach respBuff: %s\n",reason);

	fflush(tc_buf);
	Ftruncate(tc_buf,0,1);
	fseek(tc_buf,0,0);

	if( checkClientEOF(Conn,tc,"detach_respbuff") )
		httpStat = CS_EOF;

	/* copy header removing Connection: Keep-Alive */
	if( checkHead )
	while( fgets(field,sizeof(field),tc_buf) ){
		if( fnlen = STRH_Connection(field) ){
			wordscan(field+fnlen,conn);
			if( strncasecmp(conn,"keep-alive",10) == 0 )
				clntClose(Conn,"b:temp. buff. detached (%s)",
					reason);
			strcpy(field+fnlen," close\r\n");
			SentKeepAlive = 0;
		}
		if( !ClientEOF )
		if( fputs(field,tc) == EOF )
			setClientEOF(Conn,tc,"detach_respbuff-1");

		if( field[0] == '\r' || field[0] == '\n' )
			break;
	}

	if( !ClientEOF ){
		copy_fileTIMEOUT(tc_buf,tc,NULL);
		if( feof(tc) )
			setClientEOF(Conn,tc,"detach_respbuff-2");
	}
	fclose(tc_buf);
	return tc;
}

HTTP_delayReject(Conn,req,stat,self)
	Connection *Conn;
	char *req,*stat;
{	char method[128],url[URLSZ],ver[128];
	char path[URLSZ],referer[URLSZ];
	char shost[256];
	int sport;

	scan_http_request(req,method,url,ver);
	path[0] = 0;
	sscanf(url,"%*[^:]://%*[^/ \t\r\n]/%[^ \t\r\n]",path);
	HTTP_getRequestField(Conn,"Referer",referer,sizeof(referer));

	self |= DO_DELEGATE || IsMounted || IAM_GATEWAY;
	sport = getClientHostPort(Conn,shost);
	logReject(Conn,self,shost,sport);
	delayReject(Conn,self,method,DFLT_PROTO,shost,sport,path,referer,stat);
}
HTTP_delayCantConn(Conn,req,stat,self)
	Connection *Conn;
	char *req,*stat;
{	char method[128];
	char shost[256];
	int sport;

	scan_http_request(req,method,NULL,NULL);

	self |= DO_DELEGATE || IsMounted || IAM_GATEWAY;
	sport = getClientHostPort(Conn,shost);
	delayReject(Conn,self,method,DFLT_PROTO,shost,sport,"","",stat);
}

#define FGETRESP(header) \
 fgetsResponse(Conn,niced,line,sizeof(line),fs,header,fromcache,&lleng1,&isbin)

static logCookie(Conn,resCookie)
	Connection *Conn;
	char *resCookie;
{	char reqCookie[2048];

	if( withCookie || *resCookie ){
		getFV(REQ_FIELDS,"Cookie",reqCookie);
		sv1log("[Cookie:%s][Set-Cookie:%s]\n",reqCookie,resCookie);
	}
}

static relay_response(Conn,cpid,proto,server,iport,req,cpath,fromcache,
fs,tc,fc,cachefp,cache_rdok)
	Connection *Conn;
	char *proto,*server;
	char *req;
	char *cpath;
	FILE *fs,*tc,*fc,*cachefp;
{	char method[128],line[IBUFSIZE];
	char *got1;
	int nlines;
	int rcode;
	char ver[1024];
	char ctype[256],cencoding[256],servername[256];
	char reason[1024];
	char resCookie[2048];
	int errori;
	int header;
	int nobody;
	int oldver;
	int rcc;
	int wcc;
	int putPRE;
	int isText;
	int headlen;
	int rlength;
	int isbin;
	int lleng1;
	int obufed;
	int lastMod;
	int lastModTime;
	int rtotal;
	int wtotal;
	int htotal;
	int wlength;
double connDelay;
double firstResp;
	int tryKeepAlive;
	int WithHeader;
	int doconv;
	int deent;
int txlen = 0;
int bilen = 0;
int reqHEAD = 0;
	int nready;
	int ninput;
	int noutput;
	int nflush;
	int nreport;
	int fsEOF = 0;
	FILE *respBuff,*tc_sav;
	Referer refererb, *referer = &refererb;
	char refbuf[URLSZ];
	void (*osigpipe)();
	int niced = 0;
	double Start;
	double Resp1;
	int fsd,tcd;

	Start = Time();
	WithHeader = HTTP_reqWithHeader(Conn,req);
	wordscan2(req,method,sizeof(method));
	reqHEAD = strcasecmp(method,"HEAD") == 0;

	tryKeepAlive = 0;
	if( ClntKeepAlive ){
		if( strcaseeq(method,"GET") || strcaseeq(method,"HEAD") )
			tryKeepAlive = 1;
		else
		clntClose(Conn,"M:Method is ``%s'' cpid=[%d]",method,cpid);
	}

	got1 = FGETRESP(1);
	strcpy(RespStatus,line);
	ver[0] = 0;
	RespCode = rcode = decomp_httpstat(line,ver,reason);
	Resp1 = Time();

	if( cpid )
		Kill(cpid,SIGTERM);
	if( got1 == NULL ){
		sv1log("HTTP realy_response: EOF at start\n");
		http_Log(Conn,500,CS_EOF,req,0);
		return R_EMPTY_RESPONSE;
	}

	if( cachefp != NULL && 500 <= rcode ){
		if( cache_rdok ){
			sv1log("HTTP temporary error ? %s",line);
			http_Log(Conn,rcode,CS_EOF,req,0);
			copy_fileTIMEOUT(fs,NULLFP(),NULL);
			return R_EMPTY_RESPONSE;
		}
		cachefp = NULL;
		DontTruncate = 1;
	}

	if( cachefp != NULL ){
		Verbose("CacheMtime: %d : %d\n",CacheMtime,
			file_mtime(fileno(cachefp)));

		if( CacheMtime != file_mtime(fileno(cachefp)) ){
			int fd;

			sv1log("## !!! Cache is updated by someone else.\n");
/*
cachefp = NULL;
*/
			fd = open(cpath,0);
			dup2(fd,fileno(cachefp));
			close(fd);
			DontTruncate = 1;
		}
	}

	/*
	 *	If the transmission speed from the server is slow,
	 *	do flush frequently.
	 */
	if( fromcache ){
		connDelay = 0;
	}else{
		int delay;

		connDelay = CONN_DONE - CONN_START;
		firstResp = Time() - CONN_DONE;
		daemonlog("D","connDelay:%5.2fsec, firstResp:%5.2fsec\n",
			connDelay,firstResp);
	}

	if( checkClientEOF(Conn,tc,"start_response") ){
		httpStat = CS_EOF;
		return R_UNSATISFIED;
	}

	errori = 0;
	nobody = reqHEAD;
	header = 1;
	isText = 0;
	headlen = 0;
	rtotal = 0;
	wtotal = 0;
	htotal = 0;
	obufed = 0;
	putPRE = 0;
	oldver = 0;
	lastMod = 0;
	lastModTime = 0;
	resCookie[0] = 0;

	if( reqRobotsTxt(Conn) ){
		clntClose(Conn,"R:Robots.txt");
		putRobotsTxt(Conn,tc,rcode==200?fs:NULL,line);
		return R_GENERATED;
	}

	if( rcode == 403 )
		HTTP_delayReject(Conn,req,line,0);
	else
	if( rcode == 404 )
		delayUnknown(Conn,DO_DELEGATE||IsMounted,OREQ);

/* This will not work well when the client is DeleGate with cache
 * and  its cache is newer than the cache of this DeleGate.
 */
	if( rcode == 304 ){
		int cacheOk;
		int forceBody;

		cacheOk = cacheReadOK(cachefp);
		sv1log("HTTP status: %d %s => %x/%d\n",rcode,reason,cachefp,cacheOk);

		if( cacheOk ){
			ftouch(cachefp,time(0));
			forceBody = forceBodyResponse(Conn);
		}else{
			forceBody = 0;
			sv1log("No-Cache to reuse\n");
		}

		if( ClntIfMod[0] && !forceBody && CacheLastMod<=ClntIfModClock){
			Verbose("%d is relayed to the client.\n",rcode);
			if( cachefp ){
				Verbose("DontWriteCache 304 not modified.\n");
				/*fclose(cachefp);*/
				cachefp = NULL;
				DontTruncate = 2;
			}
		}else
		if( cachefp ){
/*
 * 304 should be passwd thru to the client if it is a delegated
 * with cache file which is very same with this delegated.
 */
			sv1log("HTTP <=+= %d [%s] %s",RespCode,cpath,req);
			httpStat = CS_STABLE;
			return distFromCache(Conn,proto,server,iport,req,
				tc,cpath,cachefp);
		}
		nobody = 1;
		lastMod = 1;
	}else{
		if( DontReadCache ){
			httpStatX = CS_RELOAD;
		}else
		if( cachefp != NULL && cache_rdok )
			httpStat = CS_OBSOLETE;
	}

	if( rcode == 1200 ){
		char xline[32],*np;

		rtotal = lleng1;
		oldver = 1;
		header = 0;

		if( strchr(line,'\n') )
			isText = TX_HTML; /* HTML is assumed */

		Strncpy(xline,line,sizeof(xline));
		if( strtailchr(xline) != '\n' )
			strcat(xline," ...\n");

		sv1log("No header (HTTP/0.9) : %s assumed : [%x][%x]%s",
			(isText?"text":"binary"), xline[0],xline[1],xline);
	}else{
		headlen = lleng1;
		switch( rcode ){
		case 200:
		case 301:
		case 302: /* OK and cachable */
			break;
		case 304:
			break;
		case 305:
		case 306:
			break;
		default:
			sv1log("HTTP error request: %s",req);
			sv1log("HTTP error status: %d %s\n",rcode,reason);
			errori = -rcode;
		}
	}

	setReferer(Conn,proto,server,iport,req,referer,refbuf);
	doconv = cur_codeconvCL(NULL) || CCXactive(CCX_TOCL);
	deent = toProxy && protoGopher(DST_PROTO);

	if( IsGopherSearch && oldver )
		sv1log("Gopher/HTTP relay skipped 1st response line\n");
	else
	if( (rcode==305 || rcode==306) && (ConnType=='p' || ConnType=='m') ){
		RESP_SAV = 1;
		/* tc = NULLFPW(); */
		tc = TMPFILE("RESP_MSG");
		strcpy(RESP_MSG,line);
		RESP_LEN = strlen(line);
	}else{
		if( !header && isText==TX_HTML ){
			wtotal += FPUTS(line,"text/html",!header && doconv,deent,tc);
		}else{
			if( WithHeader || !header )
				htotal += fwrite(line,1,lleng1,tc);
		}

		if( !oldver && header ){
			if( WithHeader )
			HTTP_putDeleGateHeader(Conn,tc,fromcache);
			/* also X-Request-XXX is echoed */
		}

		if( cachefp ){
			fwrite(line,1,lleng1,cachefp);
			sendDistribution(Conn,cachefp,fs,tc,line,lleng1);
		}
	}

	/* sv1log("HTTP status: %d %s\n",rcode,reason); */

	ctype[0] = 0;
	cencoding[0] = 0;
	servername[0] = 0;
	rlength = 0;
	nlines = 0;
	nflush = 0;
	noutput = 0;

	if( !ClientEOF )
	if( 0 < DELEGATE_LINGER )
		set_linger(fileno(tc),DELEGATE_LINGER);
	if( fromcache )
		fsd = -1;
	else	fsd = fileno(fs);
	tcd = fileno(tc);

	respBuff = NULL;
	if( WillKeepAlive ){
		if( CKA_RemAlive <= 1 )
			clntClose(Conn,"f:finished lifetime");
		else
		if( errori != 0 )
			clntClose(Conn,"s:bad status: %d",errori);
	}

	if( !ClientEOF )
	if( !nobody && !oldver && WithHeader )
	if( withConversion(Conn,0)
	 || WillKeepAlive && (!fromcache || fromcache && !HTTP_ContLengOk(fs)) ){
		if( respBuffer < 0 ){
			respBuff = TMPFILE("HTTP-respBuff");
			respBuffer = dup(fileno(respBuff));
		}else{
			respBuff = fdopen(dup(respBuffer),"r+");
			fseek(respBuff,0,0);
		}
		tc_sav = tc;
		tc = respBuff;
		tcd = -1;
	}

	nreport = 0;
	nsigPIPE = 0;
	osigpipe = Vsignal(SIGPIPE,sigPIPE);
	Where = "header";

	for( ninput = 0;;ninput++ ){
	    if( fsEOF )
		break;
	    if( feof(fs) )
		break;
	    if( nsigPIPE ){
		if( !ClientEOF )
			setClientEOF(Conn,tc,"relay_response.SIGPIPE");
		if( nreport++ % 100 == 0 ){
			sv1log(
"## (%d) SIGPIPE * %d: the recipient seems to be dead, Ctype:%s\n",
			nreport,nsigPIPE, ctype);
		}
	    }
	    if( ClientEOF && cachefp == NULL ){
 sv1log("## stop relay-1: no recipient & no cache\n");
		break;
	    }

	    if( 10 < ninput )
	      niced = doNice("HTTPresponse",fsd,tcd,niced,rtotal,ninput,Resp1);

 	/*
 	 * stop buffering for Keep-Alive when the response data is large
 	 * or response speed is slow.
 	 */
	nready = 0;

         if( WillKeepAlive )
         if( tc == respBuff && !header && !ClientEOF )
         if( 1024*1024 < rlength
	 || 1024*1024 < rtotal
	 || 15 < Time()-CONN_DONE
 	 || !fromcache
	 && nready == 0 && (nready = fPollIn(fs,100)) == 0
	 && 10 < Time()-CONN_DONE )
                 tc = detach_respbuff(Conn,tc,tc_sav,
                         WithHeader,"flush slow response.");
 
	    if( header || isText ){
		if( !header && nlines == 0 ){
			doconv = cur_codeconvCL(NULL) || CCXactive(CCX_TOCL);
			check_codeconv(1);
			if( !ClientEOF && putPRE ){
				wtotal += FPUTS("\n",ctype,doconv,0,tc);
				fputs("<PRE>",tc);
				wtotal += 5;
				putPRE = 2;
			}
		}
		if( !header && !fromcache && !ClientEOF
		 && nready == 0 && (nready = fPollIn(fs,200)) == 0 ){
			noutput++;
			if( fflushTIMEOUT(tc) == EOF )
				setClientEOF(Conn,tc,"text flush-1\n");
			else
			if( rlength == 0 && tc == respBuff ){
				tc = detach_respbuff(Conn,tc,tc_sav,
					WithHeader,"flush endless text.");
			}
		}
		if( FGETRESP(header) == NULL ){
textEOF:
			if( !ClientEOF && !header )
			if( !nobody )
				wtotal += FPUTS("",ctype,doconv,0,tc);
			break;
		}

		if( header && (line[0] == '\r' || line[0] == '\n') ){
			char via[256];

			if( !ClientEOF && WithHeader ){
				HTTP_genVia(Conn,0,via);
				fprintf(tc,"Via: %s\r\n",via);
			}

			/* asked Keep-Alive in the request, so must reply
			 * int the respose.
			 */
			if( !ClientEOF && ClntKeepAlive ){
				if( !nobody )
					modifyConnection(Conn,rlength);

				if( tryKeepAlive ){
/*
				if( !nobody && tc != respBuff && rlength == 0 )
					clntClose(Conn,"u:unbound length data");
*/
				if( errori )
					clntClose(Conn,"s:bad status: %d",errori);
				if( Conn->xf_filters & (XF_FTOCL|XF_FCL) )
					clntClose(Conn,"x:external filter");
				}

				putKeepAlive(Conn,tc);
			}
		}

		if( !header && isText && isbin ){ /* isbin is set in FGETRESP() */
			sv1log("non-text in text type resp.(%d/%d)\n",rtotal,ninput);
			errori = R_NONTEXT_INTEXT;
			rcc = lleng1;
			Where = "binaryBody";
			isText = 0;
			goto GOT_BINARY;
		}

		/* output to the cache should be
		 * before "FPUTS()" which may rewrite input line
		 * after "goto GOT_BINARY" to cache binary line with fwrite()
		 */
		if( cachefp && !oldver ){
			if( !(header && STRH(line,F_DGVer)) )
			if( !(header && STRH_Connection(line)) ){
				fputs(line,cachefp);
				sendDistribution(Conn,cachefp,fs,tc,line,lleng1);
			}

			if( !header )
				txlen += lleng1;
		}

		if( emulateNCSA && rcode == 304 ){
			if( strncasecmp(line,"Date:",4) != 0
			 && strncasecmp(line,"Server:",7) != 0
			 && *line != '\r' && *line != '\n' ){
				Verbose("emulateNCSA: skip %s",line);
				continue;
			}
		}

		if( !header ){
			rtotal += lleng1;
			nlines += 1;

			/* don't cause automatic flush at
			 * non line boundary.  */
			if( OBUFSIZE <= obufed+lleng1
			|| !fromcache && READYCC(fs) == 0 ){ 
				if( !ClientEOF && fflushTIMEOUT(tc) == EOF )
					setClientEOF(Conn,tc,"text flush-2\n");
				noutput++;
				obufed = lleng1;
			}else{
				obufed += lleng1;
				/* should be length of converted string. */
			}
		}

		if( header && SimpleContType && STRH(line,F_ContType) ){
			char *dp;
			if( dp = strchr(line,';') ){
				sv1log("Discard Parameter -- %s",dp);
				strcpy(dp,"\r\n");
			}
		}
		if( header && deent && STRH(line,F_DGVer) )
			deent = 0;

		/*
		 * the charset should be rewritten only when
		 * the code conversion in the body is made ...
		 */
		if( header && doconv && !SimpleContType && STRH(line,F_CtypeText) ){
			char *xcharset;
			if( codeconv_get(NULL,&xcharset,NULL) )
				replace_charset(line,xcharset);
		}
		if( header && STRH(line,F_SetCookie) ){
			linescan(line+strlen(F_SetCookie),resCookie,sizeof(resCookie));
			MountCookieResponse(Conn,req,line+strlen(F_SetCookie));
			if( cachefp ){
				Ftruncate(cachefp,0,0);
				fseek(cachefp,0,0);
				cachefp = NULL;
			}
		}else
		if( header && STRH(line,F_Location) )
		if( rcode == 301 || rcode == 302 ){
			sv1log("%s",line);
			if( MovedToSelf(Conn,line) ){
				errori = R_MOVED_LOOP;
				sv1log("#### don't cache MOVED loop\n");
			}
			if( WillKeepAlive && MovedToAnotherServer(Conn,line) )
				clntClose(Conn,"m:moved to another server");
		}

		if( header && WithHeader && plain2html() && STRH(line,F_CtypePlain) ){
			if( !ClientEOF )
				fprintf(tc,"%s\r\n",F_CtypeHTML);
		}else
		if( header && STRH_Connection(line) ){
			Verbose("HCKA:[R] %s",line);
		}else
		if( !header || WithHeader ){
			if( !ClientEOF ){
				wcc = FPUTS(line,ctype,!header && doconv,deent,tc);
				if( !header )
					wtotal += wcc;
				else	htotal += wcc;
			}
		}

		if( header ){
			headlen += lleng1;
			if( STRH(line,F_ContEncode) )
				wordscan(line+strlen(F_ContEncode),ctype);
			else
			if( STRH(line,F_ContLeng) )
				rlength = atoi(line+strlen(F_ContLeng));
			else
			if( STRH(line,F_LastMod) ){
				lastMod = 1;
				lastModTime = lastmtime(line+strlen(F_LastMod));
			}else
			if( STRH(line,F_ContType) ){
				wordscan(line+strlen(F_ContType),ctype);
				if( STRH(line,F_CtypeText) ){
					if( STRH(line,F_CtypePlain) ){
						if( plain2html() ){
							isText = TX_HTML;
							putPRE = 1;
						}else	isText = TX_PLAIN;
					}else
					if( STRH(line,F_CtypeHTML) )
						isText = TX_HTML;
					else	isText = TX_MISC;
				}
			}else
			if( STRH(line,F_Server) ){
				linescan(line+7,servername,sizeof(servername));
if(LOG_GENERIC){
fputLog(Conn,"Server","%s://%s:%d; version=%s\n",
DST_PROTO,DST_HOST,DST_PORT,servername);
}
			}else
			if( line[0] == '\r' || line[0] == '\n' ){
				header = 0;
			sv1log("%s %d Content-{Type:%s Encoding:%s Leng:%d} Server:%s\n",
					ver,rcode,ctype,cencoding,rlength,servername);

				Where = "headerFlush";
				if( !ClientEOF && tc != respBuff )
					flushHead(Conn,tc,rlength);
				noutput++;

				if( reqHEAD )
					break;

				if( isText )
					Where = "textBody";
				else	Where = "binaryBody";
			}
			if( errori )
			if( rcode != 404 )
				sv1log("HTTP error header: %s",line);
		}
		if( rlength+0x100000 < txlen ){
			if( tc == respBuff ){
				tc = detach_respbuff(Conn,tc,tc_sav,
					WithHeader,"huge data");
			}
			if( cachefp ){
				sv1log("discard cache: leng=%d/%d %s\n",
					txlen,rlength,cpath);
				Ftruncate(cachefp,0,0);
				fseek(cachefp,0,0);
				cachefp = NULL;
			}
		}
	    }else{
		if( tc == respBuff && !WillKeepAlive ){
			tc = detach_respbuff(Conn,tc,tc_sav,
				WithHeader,"non-text data, non keep-alive");
		}
		if( fromcache )
			rcc = fread(line,1,sizeof(line),fs);
		else
		if( rcc = fgetBuffered(line,sizeof(line),fs) ){
			Verbose("buffered(%d)\n",rcc);
		}else{
			if( nready == 0 && (nready = PollIn(fileno(fs),2000)) == 0 ){
				if( tc == respBuff ){
					tc = detach_respbuff(Conn,tc,tc_sav,
						WithHeader,"flush binary body.");
				}else
				if( !ClientEOF ){
					nflush++;
					if( fflushTIMEOUT(tc) == EOF )
						setClientEOF(Conn,tc,"binary");
				}
			}
			if( nready == 0 )
				rcc = readTIMEOUT(fileno(fs),line,sizeof(line));
			else	rcc = read(fileno(fs),line,sizeof(line));

			if( rcc <= 0 )
				fsEOF = 1;
			else
			while( rcc < sizeof(line) ){
			    if( 0 < PollIn(fileno(fs),10) ){
				int rcc1;
				rcc1 = read(fileno(fs),line+rcc,sizeof(line)-rcc);
				if( rcc1 <= 0 ){
					fsEOF = 1;
					break;
				}else{
					rcc += rcc1;
					ninput++;
				}
			    }else	break;
			}
		}
GOT_BINARY:
		if( rcc <= 0 ){
			Verbose("read(%d) = %d\n",sizeof(line),rcc);
			break;
		}

		rtotal += rcc;

		if( cachefp ){
			wcc = fwrite(line,1,rcc,cachefp);
			sendDistribution(Conn,cachefp,fs,tc,line,rcc);
			bilen += wcc;

			if( wcc == 0 || rlength+0x100000 < bilen ){
				sv1log("discard cache: wcc=%d leng=%d/%d %s\n",
					wcc,bilen,rlength,cpath);
				Ftruncate(cachefp,0,0);
				fseek(cachefp,0,0);
				cachefp = NULL;
			}
		}

		if( !ClientEOF ){
		    wcc = fwriteTIMEOUT(line,1,rcc,tc);
		    wtotal += wcc;
		    if( wcc == 0 ){
			/* don't break to relay response data into the cache */
 sv1log("## HTTP out to client TIMEOUT[%d]\n",fileno(tc));
			/*fcloseTIMEOUT(tc);*/
			setClientEOF(Conn,tc,"binary flush-1");
		    }
		    if( wcc < rcc ){
			if( !ClientEOF )
				setClientEOF(Conn,tc,"binary flush-2");
 sv1log("## HTTP ERROR incomplete fwrite(%d)=%d %d/%d, SIGPIPE=%d\n",
 rcc,wcc,rtotal,rlength,nsigPIPE);
			if( tc == respBuff )
				abortHTTP("disk full?");

			if( cachefp == NULL ){
 sv1log("## stop relay-2: FWRITE(%d)=%d, SIGPIPE=%d, no cache & no recipient\n",
 rcc,wcc,nsigPIPE);
				break;
			}
		    }
		    noutput++;

		    Verbose("read %d / %d bytes / %d blocks; %d flush.\n",
			rcc,rtotal,ninput,nflush);
		}
	    }
	}
	Where = "bodyFlush";

	if( !(fromcache && ClientEOF) )
	if( !nobody && rtotal < rlength )
		errori = R_UNSATISFIED;

	if( !ClientEOF ){
		if( putPRE == 2 ){
			fputs("</PRE>\n",tc);
			wtotal += 7;
		}
	}

	wlength = rlength;
	if( tc == respBuff ){
		fflush(tc);
		Ftruncate(tc,0,1);
		fseek(tc,0,0);

		if( checkClientEOF(Conn,tc,"flush_respbuff") ){
			httpStat = CS_EOF;
			wtotal = wlength = 0;
		}else
		if( 0 < (wtotal = HTTP_putMIMEmsg(Conn,tc,tc_sav)) ){
			wlength = wtotal;
		}else{
			sv1log("## HTTP RESPONSE CLOSE: NO (client dead)\n");
			setClientEOF(Conn,tc,"flush_respbuff.FAILED");
			close(respBuffer);
			respBuffer = -1;
		}
		fclose(tc);
		tc = tc_sav;
	}

	if( errori == R_NONTEXT_INTEXT )
		if( rtotal == rlength )
			errori = 0;

	if( WillKeepAlive ){
		if( ClientEOF ){
			clntClose(Conn,"r:by client (response EOF) %d/%d (%d/%d)",
				wtotal,wlength,rtotal,rlength);
		}else
		if( !nobody && wtotal != wlength ){
			clntClose(Conn,"l:##FATAL:inconsistent body length %d/%d (%d/%d)",
				wtotal,wlength,rtotal,rlength);
		}else
		if( errori ){
			clntClose(Conn,"s:##FATAL:bad status(%d) %d/%d (%d/%d)",
				errori,wtotal,wlength,rtotal,rlength);
		}
	}

	if( RESP_SAV )
		fclose(tc);
	else
	if( checkClientEOF(Conn,tc,"flush_body") ){
		httpStat = CS_EOF;
	}else{
		Verbose("HTTP RESPONSE FLUSH: DO\n");
		if( WillKeepAlive ){
			fflushKeepAlive(Conn,"flush_response",
				fc,tc,htotal+wtotal);
			if( nsigPIPE || ClientEOF )
				clntClose(Conn,"p:premature EOF on flush");
			if( nsigPIPE && !ClientEOF )
				setClientEOF(Conn,tc,"flush_response.SIGPIPE");
			if( ClientEOF )
				httpStat = CS_EOF;
		}else{
			tcCLOSED = 1;
			if( fcloseTIMEOUT(tc) == EOF )
				httpStat = CS_EOF;
			setClientEOF(Conn,tc,NULL);
		}
	}

	if( cachefp )
		fflush(cachefp);

	Vsignal(SIGPIPE,osigpipe);

	http_log(Conn,proto,server,iport,req,rcode,ctype,rtotal,lastModTime,
		CONN_DONE-CONN_START,Time()-CONN_DONE);

sprintf(line,
"HTTP transmitted: %dhead+%d/%dbody=>%dtxt+%dbin->%d/%d, %di/%do/%df/%3.1f",
headlen,rtotal,rlength,txlen,bilen,wtotal,wlength,ninput,noutput,nflush,
Time(0)-Start);
 	sv1log("%s\n",line);

	if( withCookie || *resCookie )
		logCookie(Conn,resCookie);

	if( errori == R_UNSATISFIED )
		return errori;

	if( lastMod == 0 ){
		if( rcode == 302 ){
			/* relatively shorter expire time is desired ? */
		}else{
			Verbose("No Last-Modified:\n");
#ifndef CACHE_NOLM
			return R_GENERATED;
#endif
		}
	}
	return errori;
}

static relay_response_fromCache(Conn,proto,server,iport,req,cpath,cachefp,tc,fc)
	Connection *Conn;
	char *proto,*server;
	char *req;
	char *cpath;
	FILE *cachefp,*tc,*fc;
{	int rcode;
	int mycache;
	char scdate[256];
	int rtotal;

	httpStat = CS_HITCACHE;
	ConnType = 'c';

	if( 0 < ClntIfModClock && !forceBodyResponse(Conn) ){
		mycache=HTTP_getLastMod(scdate,sizeof(scdate),cachefp,cpath);
		if( mycache <= ClntIfModClock ){
			char ctype[128];

			/* dont send the same or older resource */
			fprintf(tc,"HTTP/1.0 304 Not Modified (cached)\r\n");
			rtotal = HTTP_relayCachedHeader(Conn,cachefp,tc);
			flushHead(Conn,tc,0);
			sv1log("HTTP <=S= %d [%s] %s",RespCode,cpath,req);

			ctype[0] = 0;
			http_log(Conn,proto,server,iport,req,304,ctype,rtotal,0,
				-1.0,Time()-CONN_DONE);
			return 0;
		}
	}
	rcode = relay_response(Conn,0,proto,server,iport,req,cpath,1,
		cachefp,tc,fc,NULL,1);

	sv1log("HTTP <=-= %d [%s] %s",RespCode,cpath,req);

	if( rcode < 0 || /*rcode == 304 ||*/ RespCode == 304 ){
		sv1log("----------- UNLINK:%d:%d:%s\n",rcode,RespCode,cpath);
		unlink(cpath);
		return rcode;
	}
	if( /*rcode == 304*/ RespCode == 304 ){
		sv1log("ERROR  304 Not modified messages was cached?\n");
		return 304;
	}
	return 0;
}
static char *rewrite_request(Conn,fp)
	Connection *Conn;
	FILE *fp;
{	char *url,*urltop;
	char rproto[256],rhost[256];
	int riport;
	char *cproto;
	char *rcode = REQ;
	int dgurl;
	char *ver;

	sv1log("REQUEST %s %s",BORN_SPECIALIST?"-":"=",REQ);

strcpy(rproto,"http");
riport = 80;
rhost[0] = 0;

	if( BORN_SPECIALIST || ACT_SPECIALIST ){
		if( 0 < REQ_VNO ){
			url = REQ + strlen(REQ_METHOD);
			while( *url == ' ' || *url == '\t' )
				url++;
			cproto = "http";
		}else{
			url = REQ;
			cproto = "gopher";
		}
		urltop = url;

		if( url[0] == '/' && strchr(" \t\r\n",url[1]) != 0 )
		if( D_SELECTOR[0] ){
			url++;
			Strins(url,D_SELECTOR);
			sv1log("REQUEST +S %s",REQ);
		}

		/*
		 * This stuff should be passed multiple times
		 * for indirect MOUNT, but it should be executed
		 * only for the first original reuqest URL.
		 */
		if( CLIENTS_PROXY[0] == 0 ){
			if( fromProxyClient(url) ){
				setProxyOfClient(Conn,1,url);
				DONT_REWRITE = 1;
			}else	setProxyOfClient(Conn,0,NULL);
		}

		MountRequestURL(Conn,url);

		rhost[0] = 0;

		dgurl = 0;
		DGateWay[0] = 0;

/*
 * How to treat a request sent form a proxy client like "http://proxy/-_-URL"
 * should be cleary defined... (^_^;
 *
 * 951113: such URL (and optional flags) sould be passed through to the
 * target Proxy in the form  /-_-=flags=URL  because the flags should be
 * used in the Proxy (DeleGate).
 */

		if( strncasecmp(url,"news:",5) == 0 ){ 
			strcpy(rproto,"nntp");
			strcpy(rhost,"*");
			riport = 119;
			set_realserver(Conn,rproto,rhost,riport);
		}else
		if( toAnotherProxy(Conn,url) ){
			Verbose("To another server or proxy, THRU >>> %s",url);
		}else
		if( url_derefer(cproto,url,Modifier,DELEGATE_FLAGS,rproto,rhost,&riport) ){
			dgurl = 1;
			set_realserver(Conn,rproto,rhost,riport);
			if( !do_RELAY(Conn,RELAY_DELEGATE) ){
				sv1log("Forbidden: RELAY DELEGATE\n");
				RelayForbidden |= RELAY_DELEGATE;
/*
 * can't strictly forbid the relaying if some host is allowed ...
 * (it's not problem if the restriction is all or nothing way)
 *
 * It's so expensive to check all of URLs in the RESPONSE about whether or
 * not they are RELAYable.  So all of them are rewritten if the URL in the
 * REQUEST is RELAYable, thus access to them will visit the delegated again.
 * And they should be relayed because they are directed to the delegated by
 * the delegated.
 * But RESPONSE to them will not rewritten if they are not RELAYable, thus
 * the recursive relay by URL rewriting of delegated will stop there.
 */
			}else	DO_DELEGATE = 1;
		}

		if( url_deproxy(Conn,REQ,url,rproto,rhost,&riport) ){
			set_realserver(Conn,rproto,rhost,riport);
			if( !do_RELAY(Conn,RELAY_PROXY) ){
				RelayForbidden |= RELAY_PROXY;
				sv1log("Forbidden: RELAY PROXY\n");
			}
			if( dgurl )
				sprintf(DGateWay,"%s://%s:%d",rproto,rhost,riport);
		}

		/*
		 * cancel `DONT_REWRITE' if the URL is in form http://myself/-_-url
		 */
		if( ToMyself && dgurl )
			DONT_REWRITE = 0;

		if( rhost[0] == 0 )
			ToMyself = 1;

		if( strchr(" \t\r\n",url[0]) ){
			Strins(url,"/");
			Verbose("HTTP EMPTY URL to %s",REQ);
		}

		if( ver = strstr(REQ," HTTP/1.1\r\n") ){
			ver[8] = '0';
			clientAskedKeepAlive(Conn,"Connection","keep-alive");
		}
		if( REAL_HOST[0] )
			Verbose("REMOTE > %s",REQ);

		wordscan2(urltop,REQ_URL,sizeof(REQ_URL));
	}

	if( rproto[0] == 0 ){
		sv1log("What? %s",REQ);
		return NULL;
	}

	if( !strcaseeq(rproto,"https") )
	if( !strcaseeq(rproto,"http") ){
		IAM_GATEWAY = 1;

		if( FORWARD_ASIS(REQ,rproto) )
			add_localheader(Conn,0);
		else	add_localheader(Conn,DONT_REWRITE);
		add_DGinputs(Conn,"%s",REQ);
		sv1log("HTTP GateWay > %s://%s:%d/%s",rproto,rhost,riport,REQ);

		if( protoGopher(rproto) )
			decomp_gopherURL(REQ,NULL);
	}

	return rcode;
}

service_https(Conn)
	Connection *Conn;
{
	if( 0 <= ToS )
		relay_svcl(Conn,FromC,ToC,FromS,ToS);
	else	service_http(Conn);
}

extern int USE_HTTPMAIL;

static lookCacheOnly(Conn,tc,fc)
	Connection *Conn;
	FILE *tc,*fc;
{	char *proto,*host;
	int port;
	char *req,method[128],url[URLSZ],ver[128];
	char cpath[URLSZ];
	int useCache;
	FILE *cachefp;
	int expire,cdate;
	char smtime[URLSZ];
	int mtime;

	cachefp = NULL;

	if( DontReadCache ){
		returnAckCANTCON(Conn,tc,"don't read cache");
		return;
	}

	proto = DFLT_PROTO;
	host = DFLT_HOST;
	port = DFLT_PORT;
	req = D_REQUEST;

	scan_http_request(req,method,url,ver);

	sv1log("#### [%s][%s][%d] [%s][%s][%s]\n",
		proto,host,port, method,url,ver);

	if( !service_permitted(Conn,proto) ){
		returnAckDENIED(Conn,tc,"not permitted");
		return;
	}

	useCache = cache_path(proto,host,port,url,cpath);
	expire = 0x7FFFFFFF;

	if( useCache )
	if( cachefp = cache_fopen_rd("HTTP",cpath,expire,&cdate) )
	if( lock_sharedNB(fileno(cachefp)) == 0 )
	{
		if( CacheLastMod != 0 ){
			mtime = HTTP_getLastMod(smtime,sizeof(smtime),cachefp,cpath);
			sv1log("LastModified: %d <= %d ?\n",
				CacheLastMod,mtime);
			if( mtime <= CacheLastMod ){
				returnAckCANTCON(Conn,tc,"cache is obsolete");
				goto EXIT;
			}
		}
		returnAckOK(Conn,tc,"found in cache");
		relay_response_fromCache(Conn,proto,host,port,req,cpath,cachefp,tc,fc);
		goto EXIT;
	}
	returnAckCANTCON(Conn,tc,"not found in cache");
EXIT:
	if( cachefp != NULL )
		fclose(cachefp);
}

#define CacheClose() { if( cachefp ){ \
	fflush(cachefp); lock_unlock(fileno(cachefp)); \
	stopDistribution(Conn,cachefp,cpath); \
	fclose(cachefp); cachefp = NULL; \
} }

/*
 *     MOUNT="URL1/* URL2/* indirect"
 *     URL1/name/path
 *  -> URL2/name/indirect.cfi [Base: URL3]
 *  -> URL3/path
 * thus, add
 *     MOUNT="URL1/name/* URL3/*"
 * redirection for response, and bypass mount for succeeding request.
 */

#define DELIM "?_?"

extern FILE *URLget();
static indirect_mount(Conn,req,tc)
	Connection *Conn;
	char *req;
	FILE *tc;
{	FILE *mtab;
	char *tp,*bp,method[128],mnt_url[URLSZ],ver[128];
	char hostport[256],murl[URLSZ],rel_url[URLSZ],*rurl;
	char line[URLSZ],Base[URLSZ];
	char ourl[URLSZ],vurl[URLSZ],durl[URLSZ],*up;
	int nocache;

	tp = strstr(req,DELIM);
	if( tp == NULL )
		return 0;
	strcpy(rel_url,tp+strlen(DELIM));

	scan_http_request(req,method,mnt_url,ver);
	if( bp = strstr(mnt_url,DELIM) )
		*bp = 0;
	if( bp = strpbrk(rel_url," \t\r\n") )
		*bp = 0;

	mtab = TMPFILE("indirect_mount");
	HostPort(hostport,DST_PROTO,DST_HOST,DST_PORT);
	sprintf(murl,"%s://%s%s",DST_PROTO,hostport,mnt_url);
	nocache = PragmaNoCache;
	URLget(murl,nocache,mtab);

/*
	if( fgets(line,sizeof(line),mtab) == NULL
	 || strncasecmp(line,"#!cfi",5) != 0 ){
		fclose(mtab);
		return 0;
	}
*/

	Base[0] = 0;
	while( fgets(line,sizeof(line),mtab) != NULL ){
		if( strncasecmp(line,"BASE:",5) == 0 )
			wordscan(line+5,Base);
	}
	fclose(mtab);
	if( Base[0] == 0 )
		return 0;
	if( strtailchr(Base) != '/' )
		strcat(Base,"/");

	url_rurl(murl,ourl,"http","-.-",0,"",0);
	if( !toAnotherProxy(Conn,ourl) ){
		vurl[0] = '/';
		decomp_absurl(ourl,NULL,NULL,vurl+1);
		if( up = strrchr(vurl,'/') )
			up[1] = 0;
		strcat(vurl,"*");
		sprintf(durl,"%s*",Base);
		set_MOUNT_ifndef(Conn,vurl,durl,"");
		init_mtab();
	}

	/*
	 * the following may also be done by rewriting ORIGINAL request
	 * with the above MOUNT.
	 */
	rurl = rel_url;
	if( rurl[0] == '/' )
		rurl++;
	sprintf(req,"%s %s%s HTTP/%s\r\n",method,Base,rurl,ver);
	sv1log("#### %s",req);

	return 1;
}

static isMoved(Conn,tc,req,req_url)
	Connection *Conn;
	FILE *tc;
	char *req,*req_url;
{	char moved_url[URLSZ];
	char proxy[128];
	int totalc;
	char *query,me[128],realurl[URLSZ];

	nonxalpha_unescape(req_url,moved_url,0);
	if( query = strstr(moved_url,"?-.-=") ){
		if( strncmp(moved_url,"/-_-",4) == 0 ){
			ClientIF_HP(Conn,me);
			sprintf(realurl,"%s://%s/-_-%s",CLNT_PROTO,me,query+5);
		}else	strcpy(realurl,query+5);
		sv1log("REDIRECT %s -> %s\n",moved_url,realurl);
		totalc = putMovedTo(Conn,tc,realurl);
		http_Log(Conn,302,CS_INTERNAL,req,totalc);
		return 1;
	}
	if( moved_url_to(Conn->cl_myhp,REQ_METHOD,moved_url)
	&& !streq(moved_url,req_url) ){
		totalc = putMovedTo(Conn,tc,moved_url);
		http_Log(Conn,302,CS_INTERNAL,req,totalc);
		return 1;
	}
	if( changeproxy_url(Conn->cl_myhp,REQ_METHOD,moved_url,proxy) ){
		totalc = putChangeProxy(Conn,tc,moved_url,proxy);
		http_Log(Conn,305,CS_INTERNAL,req,totalc);
		sv1log("RETURNED 305 for: %s",req);
		HTTP_delayReject(Conn,req,"",1);
		return 1;
	}
	return 0;
}
static byHTTPMAIL(Conn,tc,proto,host,port,req,req_urlpath,
cpath,cachefp,cdate,expire)
	Connection *Conn;
	FILE *tc;
	char *proto,*host,*req,*req_urlpath;
	char *cpath;
	FILE *cachefp;
{	FILE *cfp,*hmget1();
	char url[URLSZ],*dp;
	int fromcache;

	sprintf(url,"%s://%s:%d/%s",proto,host,port,req_urlpath);
	if( dp = strpbrk(url," \t\r\n\f") )
		*dp = 0;
	sv1log("TRY HTTPMAIL: %s\n",req_urlpath);

/* host may be the same with client ... (maybe only for testing...) */
if( cachefp ) lock_unlock(fileno(cachefp));

	if( PragmaNoCache )
		expire = 0;
	cfp = hmget1(url,expire);

	if( cfp ){
		relay_response(Conn,0,proto,host,port,req, cpath,0,cfp,
			tc,NULL,cachefp,cdate!=-1);
		fclose(cfp);
		return 1;
	}
	return 0;
}

FILE *insertFTOCL_X(Conn,tc)
	Connection *Conn;
	FILE *tc;
{	int toC;
	FILE *ntc;

	toC = ToC;
	setConnX(Conn,FromC,ToC,FromS,ToS);
	if( ToC == toC ){
		/* filter is not inserted */
		return tc;
	}else{
		ntc = fdopen(ToC,"w");
		/* if( fileno(tc) != Conn->cl_sock )
		/* fclose(tc); */
		return ntc;
	}
}

HTTP_repairRequest(req)
	char *req;
{	int nsp,repaired;
	char xreq[URLSZ],*xp,*sp,sc;

	nsp = 0;
	repaired = 0;
	xp = xreq;
	for( sp = req; sc = *sp; sp++ ){
		if( sc == ' ' || sc == '\t' ){
			nsp++;
			if( 2 <= nsp && strncmp(sp+1,"HTTP/",5) != 0 ){
				sprintf(xp,"%%%02x",sc);
				xp += strlen(xp);
				repaired++;
				continue;
			}
		}
		*xp++ = sc;
	}
	*xp = 0;
	if( repaired ){
		strcpy(req,xreq);
		sv1log("REQUEST REPAIRED: %s",xreq);
	}
	return repaired;
}

extern int IO_TIMEOUT;
DDI_PollIn(Conn,fc,timeout)
	Connection *Conn;
	FILE *fc;
{	int nready;

	if( DDI_readyCbuf(Conn) )
		nready = 1;
	else	nready = frPollIn(fc,timeout);
	return nready;
}

static char *fgetsRequest(Conn,buff,size,fc)
	Connection *Conn;
	char *buff;
	FILE *fc;
{	char *rcode;
	int len;

	if( 0 < OREQ_LEN )
	if( 30 < IO_TIMEOUT )
	if( WillKeepAlive )
	if( strncasecmp(OREQ_MSG,"POST",4) == 0 )
	{
		/* Mozilla/3.? stops sending in the middle of a POST
		 * request header after the connection is broken which
		 * is notified as Proxy-Connection: keep-alive ...
		 */
		int timeout;
		timeout = 5 * 1000;
		if( DDI_PollIn(Conn,fc,timeout) <= 0 ){
			sv1log("#### fgetsRequest: TIMEOUT\n");
			return NULL;
		}
	}

	rcode = DDI_fgetsFromC(Conn,buff,size,fc);
	if( rcode != NULL ){
		if( OREQ_LEN == 0 )
		if( HTTP_isMethod(buff) )
			HTTP_repairRequest(buff);
		len = strlen(buff);
		if( OREQ_LEN + len < sizeof(OREQ_MSG) ){
			strncpy(OREQ_MSG+OREQ_LEN,buff,len+1);
			OREQ_LEN += len;
		}
	}
	return rcode;
}

#define FORWARD_AUTH "forward-auth"
static strmatch(s1,s2) char *s1,*s2; { return strcmp(s1,s2) == 0; }
static forwardOK(Conn,what,fname)
	Connection *Conn;
{	char forw[1024];

	if( 0 <= find_CMAP(Conn,what,forw) ){
		if( scan_commaList(forw,0,strmatch,fname) )
			return 1;
	}
	return 0;
}
static checkAUTH(Conn,proto,server,iport,tc)
	Connection *Conn;
	char *proto;
	char *server;
	FILE *tc;
{	int auth,pauth;
	int totalc;

	if( !Conn->from_myself && NotREACHABLE(Conn,proto,server,iport) ){
		service_permitted2(Conn,proto,0); /* cause delayReject */
		totalc = putHttpRejectmsg(Conn,tc,proto,server,iport,REQ);
		http_Log(Conn,403,CS_AUTHERR,REQ,totalc);
		return -1;
	}

	if( service_permitted2(Conn,proto,1) )
		return 0;

	auth = auth_proxy_auth();
	pauth = auth_proxy_pauth();
	if( auth || pauth ){
		if(HTTP_proxyAuthorized(Conn,REQ,REQ_FIELDS,pauth,tc)){
			char *fname;
			if( pauth )
				fname = "Proxy-Authorization";
			else	fname = "Authorization";
			if( !forwardOK(Conn,FORWARD_AUTH,fname) )
				HTTP_delRequestField(Conn,fname);
			return 0;
		}
	}

	service_permitted2(Conn,proto,0); /* cause delayReject */
	if( auth || pauth )
		totalc = putNotAuthorized(Conn,tc,REQ,pauth,"</>");
	else	totalc = putHttpRejectmsg(Conn,tc,proto,server,iport,REQ);
	http_Log(Conn,403,CS_AUTHERR,REQ,totalc);
	return -1;
}

/*
 * reply 302 Moved "/-_-proto://server/" to the "/-_-proto://server" request
 */
static delegate_moved(Conn,tc)
	Connection *Conn;
	FILE *tc;
{	char *dp;
	char url[URLSZ];
	int totalc;

	if( dp = strchr(REQ,' ') )
	if( dp[1] == '/' && strchr(" \t\r\n",dp[2]) )
	if( dp = strchr(OREQ_MSG,' ') ){
		wordscan2(dp+1,url,sizeof(url));
		if( strtailchr(url) != '/' ){
			strcat(url,"/");
			totalc = putMovedTo(Conn,tc,url);
			http_Log(Conn,302,CS_INTERNAL,REQ,totalc);
			return 1;
		}
	}
	return 0;
}

static service_http2(Conn,httpEnv,fc,tc,method)
	Connection *Conn;
	HTTP_env *httpEnv;
	FILE *fc,*tc;
	char *method;
{	FILE *ts,*fs;
	char *proto;
	char *server = DFLT_HOST;
	char loginbuf[256],*lp;
	int iport = DFLT_PORT;
	char *req_urlpath;
	char hostport[256];
	char *val;
	int nredirect = 0;
	int cpid;
	int force_on_proxy;
	int totalc;
	int rcode;

	int useCache;
	char cpath[1024];
	FILE *cachefp = NULL;
	int cdate = -1;
	int expire;
	int cacheRemove = 0;

	httpStat = 0;
	httpStatX = 0;

	cpath[0] = 0;
	PragmaNoCache = 0;
	ToMyself = 0;
	setHTTPenv(Conn,httpEnv);

	if( ImMaster && CacheOnly ){
		lookCacheOnly(Conn,tc,fc);
		goto EXIT;
	}
	returnAckOK(Conn,tc,"http");

	REQ[0] = 0;
	if( fgetsRequest(Conn,REQ,sizeof(REQ),fc) == NULL || REQ[0] == 0 ){
		if( RequestSerno ){
			clntClose(Conn,"q:by client (request EOF-8)");
			setClientEOF(Conn,fc,"request-EOF-8");
			goto EXIT;
		}
		goto nullreq;
	}
	HTTP_decompRequest(Conn);

	strcpy(OREQ,REQ);
	strcpy(OREQ_HOST,DFLT_HOST);
	OREQ_PORT = DFLT_PORT;

	if( strncasecmp(REQ,"CONNECT",7) == 0 ){
		char *rproto,rhost[256];
		int rport;
		char ctype[128];

		rproto = "https";
		recvRequestFields(Conn,fc);

DDI_proceedFromC(Conn,fc);

		if( sscanf(REQ,"CONNECT %[^:]:%d",rhost,&rport) != 2 ){
			sv1log("CONNECT: Unknown Request? %s",REQ);
			goto EXIT;
		}
		set_realserver(Conn,rproto,rhost,rport);
		if( checkAUTH(Conn,rproto,rhost,rport,tc) != 0 )
			goto EXIT;

		Conn->from_myself = 1;
		set_realserver(Conn,"https",rhost,rport);
		setConnStart(Conn);

		if( connect_to_serv(Conn,FromC,ToC,0) < 0 ){
			putHttpCantConnmsg(Conn,tc,rproto,rhost,rport,OREQ);
			http_Log(Conn,500,CS_CONNERR,REQ,0);
			goto EXIT;
		}

		setConnDone(Conn);

		if( toMaster || toProxy ){
			if( ToServ )
				ts = ToServ;
			else	ts = fdopen(ToS,"w");
			fputs(REQ,ts);
			fputs(REQ_FIELDS,ts);
			fflush(ts);
		}else{
			fprintf(tc,"HTTP/1.0 200 Connection established.\r\n");
			fprintf(tc,"\r\n");
			fflush(tc);
		}

		ProcTitle(Conn,"https://%s:%d/)",rhost,rport);
		ctype[0] = 0;
		totalc = relay_svcl(Conn,FromC,ToC,FromS,ToS);
		httpStat = CS_WITHOUTC;
		http_log(Conn,rproto,rhost,rport,REQ,200,ctype,totalc,0,
			CONN_DONE-CONN_START,Time()-CONN_DONE);
		close(ToS);
		close(FromS);
		goto EXIT;
	}

	if( strncasecmp(REQ,"!SET",4) == 0 ){
		DELEGATE_setenv(fc,tc,REQ);
		goto EXIT;
	}
	if( strncasecmp(REQ,"X-CACHE-GET",11) == 0 ){
		GET_CACHE = 1;
		sprintf(REQ,"GET %s HTTP/1.0\r\n",REQ_URL);
	}
	if( nonHTTP(Conn,fc,tc,REQ) )
		goto EXIT;

	recvRequestFields(Conn,fc);
	if( isMoved(Conn,tc,REQ,REQ_URL) )
		goto EXIT;

	if( HTTP_MAXHOPS < D_HOPS ){
		sv1log("#### MAX_HOPS %d < %d HOPS\n",HTTP_MAXHOPS,D_HOPS);
		fprintf(tc,"HTTP/%s 502 too many hops\r\n",MY_HTTPVER);
		fprintf(tc,"\r\n");
		fprintf(tc,"Too many hops: %d\r\n",D_HOPS);
		goto EXIT;
	}
	HTTP_getHost(Conn,REQ,REQ_FIELDS);

REDIRECT:
	if( rewrite_request(Conn,fc) == NULL )
	nullreq:{
		char clhost[256];
		if( getClientHostPort(Conn,clhost) == 0 )
			strcpy(clhost,"?");
		sv1log("HTTP empty_request ? from %s (%d)\n",clhost,
			Conn->cl_count);
		http_Log(Conn,500,CS_ERROR,"ERR /empty_request",0);
		delayConnError(Conn,REQ);
		goto EXIT;
	}
	if( indirect_mount(Conn,REQ,tc) ){
		if( 5 < ++nredirect ){
			sv1log("ERROR: REDIRECT LOOP ?\n");
			goto EXIT;
		}
/* variables which should be decided by the rewritten request... */
IAM_GATEWAY = 0;

/* some variable including DONT_REWRITE
 * should be decided by the original request.
 */

		goto REDIRECT;
	}
	if( DO_DELEGATE && delegate_moved(Conn,tc) )
		goto EXIT;

	setREQUEST(Conn,REQ);
	strcpy(method,REQ_METHOD);

	if( REAL_HOST[0] ){
		proto  = REAL_PROTO;
		server = REAL_HOST;
		iport  = REAL_PORT;

		if( REAL_SITE[0] == 0 ){
			sv1log("#### REAL_SITE = empty => [%s]\n",REAL_HOST);
			strcpy(loginbuf,REAL_HOST);
		}else	strcpy(loginbuf,REAL_SITE);
		server = loginbuf;

		log_PATH(Conn,">");
	}else{
		if( ImMaster )
		log_PATH(Conn,">");

		proto = "http";
	}

	HostPort(hostport,proto,server,iport);
	ProcTitle(Conn,"%s://%s/)",proto,hostport);
	sv1log("REQUEST = %s[%s://%s/] %s",
		PragmaNoCache?"(no-cache)":"",
		proto,
		hostport,
		REQ);

	if( RelayForbidden || HTTP_forgedAuthorization(Conn,REQ_FIELDS) ){
		totalc = putHttpRejectmsg(Conn,tc,proto,server,iport,REQ);
		http_Log(Conn,403,CS_AUTHERR,REQ,totalc);
		goto EXIT;
	}

	setupConnect(Conn);
	if( Conn->co_nonet ){
		DontReadCache = 0;
		DontWriteCache = 1;
	}

	if( isMYSELF(server) )
		ToMyself = 1;

if( strstr(REQ,"?-_-") )
	ToMyself = 1;

	if( ToMyself ){
		int stcode = 200;
		/* is public thus permission is not necessary? */
		if( totalc = HttpToMyself(Conn,REQ,REQ_FIELDS,fc,tc,&stcode) ){
			http_Log(Conn,stcode,CS_INTERNAL,REQ,totalc);
			goto EXIT;
		}
	}

	if( checkAUTH(Conn,proto,server,iport,tc) != 0 )
		goto EXIT;

	if( findFieldValue(REQ_FIELDS,"Authorization") ){
		sv1log("Authorization: Dont-Read/Write-Cache ON\n");
		DontReadCache = 1;
		DontWriteCache = 1;
	}
	if( val = findFieldValue(REQ_FIELDS,"Cookie") ){
		MountCookieRequest(Conn,OREQ,val);
		DontReadCache = 1;
		DontWriteCache = 1;
		withCookie = 1;
	}else	withCookie = 0;

	tc = insertFTOCL_X(Conn,tc);
	setFTOCL(NULL);

	if( IAM_GATEWAY && ClntKeepAlive )
		if( !strcaseeq(DST_PROTO,"nntp")
		 && !strcaseeq(DST_PROTO,"news")
		 && !strcaseeq(DST_PROTO,"pop") )
			clntClose(Conn,"g:gateway for: %s",DST_PROTO);

	if( !DontReadCache && streq(proto,"ftp") ){
		char method[128],path[2048],ver[128];
		char user[128],host[128];

		scan_http_request(REQ,method,path,ver);
		if( streq(method,"GET") && 0 <= strcmp(ver,"1.0") ){
			if( strchr(server,'@') ){
				host[0] = 0;
				sscanf("%[^@]@%s",user,host);
			}else{
				strcpy(user,"anonymous");
				strcpy(host,server);
			}
			if( totalc = httpftp_cached(Conn,tc,user,host,iport,path) ){
				http_Log(Conn,200,CS_HITCACHE,REQ,totalc);
				goto EXIT;;
			}
		}
	}

	if( GET_CACHE ){
		/*fclose(tc);*/
		tc = fopen("/dev/null","w");
	}
	if( FORWARD_ASIS(REQ,proto) ){
		http_gateway(Conn,-1,proto,server,iport,fc,tc,REQ,1);
		goto EXIT;
	}

	if( req_urlpath = strchr(REQ,'/') )
		req_urlpath = req_urlpath + 1;
	else	req_urlpath = "?";

	if( IAM_GATEWAY
	 || 512 < (int)strlen(REQ)
	 || without_cache()
	 || strncasecmp(REQ,"GET ",4) != 0 ){
		useCache = 0;
		cpath[0] = 0;
		httpStat = CS_WITHOUTC;
	}else{
		useCache = cache_path(proto,server,iport,req_urlpath,cpath);
		if( useCache )
			httpStat = CS_NEW;
		else	httpStat = CS_WITHOUTC;
	}

	if( CacheOnly )
		expire = 0x7FFFFFFF;
	else
	if( Conn->co_nonet )
		expire = 0x7FFFFFFF;
	else	expire = http_EXPIRE(Conn,server);

	if( IAM_GATEWAY ){
	}else{
		int cretry;
		int dontWaitCache;

	    if( useCache ){
		cretry = 0;
		set_DG_EXPIRE(Conn,expire);
		dontWaitCache = DontWaitCache;

	    retry_read:
		if( cachefp != NULL )
			CacheClose();
		cdate = -1;
		if( 5 < cretry++ )
			goto give_up;

		if( !DontReadCache )
		if( cachefp = cache_fopen_rd("HTTP",cpath,expire,&cdate) ){

if( LockedByC(Conn,cpath,fc) ){ CacheClose(); goto give_up; }

			if( lock_for_rd("HTTP",cretry,cpath,cachefp) != 0 ){
				sleep(CACHE_RDRETRY_INTERVAL);
				goto retry_read;
			}
			if( HTTP_selfExpired(cachefp) && !Conn->co_nonet ){
				CacheClose();
			}else{
				setConnStart(Conn);
				CONN_DONE = CONN_START - 1; /* minus value represent no connection ... */

				if( relay_response_fromCache(Conn,
				    proto,server,iport,REQ,
				    cpath,cachefp,tc,fc) != 0 )
				{
					/* sent something wrong to client X-< */
				}
				goto EXIT;
			}
		}

		if( !DontWriteCache )
		if( cachefp = cache_fopen_rw("HTTP",cpath) ){

if( LockedByC(Conn,cpath,fc) ){ CacheClose(); goto give_up; }

			if( file_lock_wr("HTTP",cachefp) != 0 ){
				FILE *rfp;
				int updated;

				rfp = recvDistribution(Conn,cpath,&updated);
				if( updated )
					goto retry_read;

				if( rfp != NULL ){
					setConnStart(Conn);
					CONN_DONE = CONN_START;
					relay_response(Conn,0,proto,server,iport,
						REQ,NULL,0,rfp,tc,fc,NULL,0);
					fclose(rfp);
					goto EXIT;
				}
				if( !DontReadCache && !dontWaitCache ){
					sleep(CACHE_WRRETRY_INTERVAL);
					goto retry_read;
				}
				CacheClose();
			}else{
				makeDistribution(Conn,cachefp,cpath);
				DontWaitCache = 1;
			}
		}else{
			/* readable but not writable */
			if( cdate != -1 ) cdate = -1;
		}
	    } give_up:

	    if( cachefp == NULL )
		httpStat = CS_WITHOUTC;

	    if( !reqRobotsTxt(Conn)  )
		setIfModified(Conn,REQ_FIELDS,REQ,cachefp,cpath,cdate);
	}
	if( HTTP_reqWithHeader(Conn,REQ) ){
		HTTP_setHost(Conn,REQ_FIELDS);
		MountReferer(Conn,REQ_FIELDS);
	}

	if( USE_HTTPMAIL )
	if( byHTTPMAIL(Conn,tc,proto,server,iport,REQ,req_urlpath,
		cpath,cachefp,cdate,expire))
		goto EXIT;

	if( cachefp != NULL )
		CacheMtime = file_mtime(fileno(cachefp));

	setConnStart(Conn);
	FromS = -1;
	IsGopherSearch = 0;

	if( select_icpconf(Conn,NULL) )
		connect_to_serv(Conn,FromC,ToC,0);

	if( 0 <= FromS ){
		char msg1[64],msg2[64];

		sprintf(msg1,"ConnType=%c%s%s%s%s",
			ConnType?ConnType:'?',
			IAM_GATEWAY?"/GateWay":"",
			toProxy?"/Proxy":"",
			toMaster?"/Master":"",
			0<=Conn->ca_objsize?"/HIT_OBJ":"");

		if( ConnType == 'i' ){
			if( 0 <= Conn->ca_objsize ){
				sprintf(msg2,"RECEIVED HIT_OBJ=%d",
					Conn->ca_objsize);
			}else
			if( toProxy ){
				ConnType = 'p';
				strcpy(msg2,"FORWARDING to HTTP proxy");
				IAM_GATEWAY = 0;
				connected_to_proxy(Conn,REQ,proto,server,iport,
					FromS);
			}else
			if( toMaster ){
				ConnType = 'm';
				strcpy(msg2,"FORWARDING to MASTER DeleGate");
			}else{
				strcpy(msg2,"FORWARDING to ORIGIN server");
			}
		}else{
			msg2[0] = 0;
		}
		sv1log("(ICP) %s{%s}(%s:%d) %s",msg1,msg2,server,iport,REQ);

		if( IAM_GATEWAY ){
			http_gateway(Conn,FromS,proto,server,iport,fc,tc,REQ,1);
			goto EXIT;
		}
	}

	if( FromS < 0 )
	if( Forwardit(Conn,FromC,ToC,0) ){
		if( FromS < 0 )
		{
			/* connection failed with forward server */
			goto EXIT;
		}
		if( streq(GatewayProto,"http") ){
			IAM_GATEWAY = 0;
			strcpy(DELEGATE_PROXY_HOST,GatewayHost);
			DELEGATE_PROXY_PORT = GatewayPort;
			ConnType = 'p';
			connected_to_proxy(Conn,REQ,proto,server,iport,FromS);
			sv1log("FORWARDING to HTTP proxy.\n");
		}else{
			/* GatewayProto == "delegate" */
			if( IAM_GATEWAY ){
				http_gateway(Conn,FromS,proto,server,iport,fc,tc,REQ,1);
				goto EXIT;
			}
		}
		if( GatewayPath && GatewayPath[0] ){
			/*
			replace_url(REQ,GatewayPath);
			must set reverse rewriting in the response...
			*/
		}
	}

	force_on_proxy = with_PROXY() && force_forward(Conn,proto)
		 || withTmpProxy();
	if( FromS < 0 && force_on_proxy )
		OpenProxy(Conn,REQ,proto,server,iport);

	if( !streq(proto,"nntp") && !streq(proto,"news")
	 && !streq(proto,"pop")  && !streq(proto,"ftp") )
	if( FromS < 0 ){
		connect_to_serv(Conn,FromC,ToC,0);
		if( 0 <= FromS && IAM_GATEWAY ){
			http_gateway(Conn,FromS,proto,server,iport,fc,tc,REQ,1);
			goto EXIT;
		}
	}

	if( FromS < 0 && !force_on_proxy )
		OpenProxy(Conn,REQ,proto,server,iport);

	if( FromS < 0 && IAM_GATEWAY ){
		http_gateway(Conn,-1,proto,server,iport,fc,tc,REQ,1);
		goto EXIT;
	}
	if( FromS < 0 ){
		sv1log("cannot connect to server: %s://%s:%d\n",
			DST_PROTO,DST_HOST,DST_PORT);

		if( checkClientEOF(Conn,tc,"cant_connect") ){
			http_Log(Conn,500,CS_CONNERR,REQ,0);
		}else
		if( cachefp != NULL && cdate != -1 ){
			setConnDone(Conn);
			sv1log("makeshift with old cache (A).\n");
			httpStat = CS_MAKESHIFT;
			relay_response(Conn,0,proto,server,iport,
				REQ,cpath,1,cachefp,tc,NULL,NULL,1);
		}else{
			totalc = putHttpCantConnmsg(Conn,tc,
				proto,server,iport,OREQ);

			/* when Pragma: no-cache */
			if( cachefp != NULL && 0 < file_size(fileno(cachefp)) ){
				int ooff = ftell(cachefp);
				fseek(cachefp,0,2);
				sv1log("preserved old cache (%d->%d) %s\n",
					ooff,ftell(cachefp),cpath);
			}
			http_Log(Conn,500,CS_CONNERR,REQ,0);
			HTTP_delayCantConn(Conn,REQ,"500 cannot connect\r\n",1);
		}
		if( cachefp != NULL && file_size(fileno(cachefp)) <= 0 )
			cacheRemove = 1;
		goto EXIT;
	}

	if( toMaster ){
		sv1log("HTTP -> (%s:%d) %s",server,iport,REQ);
	}else{
		std_setsockopt(ToS);
		sv1log("HTTP => (%s:%d) %s",server,iport,REQ);
	}

	if( checkClientEOF(Conn,tc,"connected") ){
		http_Log(Conn,500,CS_EOF,REQ,0);
		goto EXIT;
	}
	/* do getsockopt(client) immediately after EOF check */
	expsockbuf(ToC,0,MAX_BUFF_SOCKSEND);

	set_keepalive(FromS,1);
	expsockbuf(FromS,MAX_BUFF_SOCKRECV,0);
	setConnDone(Conn);

	fs = fdopen(FromS,"r");
	if( ToServ )
		ts = ToServ;
	else	ts = fdopen(ToS,"w");

	if( 0 <= Conn->ca_objsize && ConnType == 'i' ){
		/* response data is got by HIT_OBJ of ICP */
		cpid = 0;
	}else
	cpid = relayRequest(Conn,(cachefp==NULL?NULL:cpath),cdate,fc,ts);

	if( DontWriteCache && cachefp != NULL )
		CacheClose();

	setRelaying(Conn,tc,cachefp,cpath);

	rcode = relay_response(Conn,cpid,proto,server,iport,REQ,
			cpath,0,fs,tc,fc,cachefp,cdate != -1);

Verbose("relay_response() = %d, cachefp=%x, httpStat=%c DontTruncate=%d\n",
rcode,cachefp,httpStat,DontTruncate);

	if( cachefp != NULL ){
		if( rcode == R_EMPTY_RESPONSE && cdate != -1 ){
			sv1log("makeshift with old cache (B).\n ");
			Verbose("cache-file: %s\n",cpath);

			lock_sharedNB(fileno(cachefp));
			relay_response(Conn,0,proto,server,iport,
				REQ,cpath,1,cachefp,tc,fc,NULL,cdate != -1);
		}else
		if( DontTruncate ){
			Verbose("DontTruncate: rcode=%d ftell:%d\n",
				DontTruncate,ftell(cachefp));
		}else
		if( rcode < 0 ){
			sv1log("rcode=%d unlink %s\n",rcode,cpath);
			cacheRemove = 1;
		}else{
			if( httpStat == CS_STABLE ){
			}else{
				sv1log("%d bytes written to [%s]\n",
					ftell(cachefp),cpath);
				Ftruncate(cachefp,0,1);
			}
		}
	}

	fcloses(fs,ts);
	if( cpid )
		wait(0);

EXIT:
	ToServ = NULL;
	CacheClose(); /* unlock and remove AF_UNIX socket */
	if( cpath[0] && File_size(cpath) == 0 ){
		sv1log("unlink empty cache: %s\n",cpath);
		cacheRemove = 1;
	}
	if( cacheRemove )
		cache_remove(proto,server,iport,cpath);
	Relaying.on = 0;
	Where = 0;

	if( RespCode == 305 || RespCode == 306 ){
		char proxy[1024];
		if( getFV(RESP_MSG,"Set-Proxy",proxy) ){
			if( strncasecmp(proxy,"DIRECT",5) == 0 ){
				sv1log("#### must be accessed without proxy: %s",OREQ);
				/* Whole request message including message body must be
				 * kept for transparent automatic retry by the proxy,
				 * and two transactions will occur always.
				 * One another way is recording a triple (method,URL,proxy)
				 * for each 305/306 response to be looked by succeeding
				 * proxy processes to decide their rouring.
				 * But, it seems expensive too.
				 */
				if( OREQ_LEN < sizeof(OREQ_MSG) )
				if( ConnType == 'p' || ConnType == 'm' ){
					int comask;
					ConnType = 0;
					DDI_pushCbuf(Conn,OREQ_MSG,OREQ_LEN);
					comask = Conn->co_mask;
					Conn->co_mask = (CONN_NOPROXY | CONN_NOMASTER);
					service_http2(Conn,httpEnv,fc,tc,method);
					Conn->co_mask = comask;
				}
			}
		}
		if( RespCode == 305 || RespCode == 306 || ConnType == 0 )
			fputs(RESP_MSG,tc);

		/*
		 * if Proxy-Authorization is required, retry with it... ?
		 */
	}

	setHTTPenv(Conn,NULL);
	return;
}

static fflushKeepAlive(Conn,where,fc,tc,wtotal)
	Connection *Conn;
	char *where;
	FILE *fc,*tc;
{	int nready;

	if( fc == NULL ){
		if( fflushTIMEOUT(tc) == EOF )
			setClientEOF(Conn,fc,"%s-fflushKeepAlive-1",
				where);
	}else
	if( wtotal == 0 || 1024*8 < wtotal ){
		nready = frPollIn(fc,1);
		if( nready < 0 )
			setClientEOF(Conn,fc,"%s-fflushKeepAlive-2-RESET",
				where);
		else
		if( nready == 0 ){
			set_nodelay(fileno(tc),1);
			if( fflushTIMEOUT(tc) == EOF )
				setClientEOF(Conn,fc,"%s-fflushKeepAlive-3",
					where);
			else	set_nodelay(fileno(tc),0);
		}
	}
}

service_http(Conn)
	Connection *Conn;
{	FILE *fc,*tc;
	void (*osigint)() = NULL;
	void (*osigterm)() = NULL;
	void (*osigpipe)() = NULL;
	char o_buff[OBUFSIZE];
	char i_buff[URLSZ];
	Connection savConn;
	int keepAlive,clntKeepAlive,Serno,tm0;
	char method[1024];
	int timeout,timeout1,timeout2,rtimeout,ptimeout,nready,till;
	HTTP_env httpEnv;
	char *FTOCL,*getFTOCL();
	FTOCL = getFTOCL(Conn);

	tc = fdopen(ToC,"w");
	if( tc == 0 ){
	http_Log(Conn,500,CS_ERROR,"ERR cannot_fdopen(to_client)",0);
	Exit(-1,"fdopen(ToC=%d) failed\n",ToC);
	}
	tcCLOSED = 0;

	fc = fdopen(FromC,"r");
	if( fc == NULL ){
	http_Log(Conn,500,CS_ERROR,"ERR cannot_fdopen(from_client)",0);
	Exit(-1,"fdopen(FromC=%d) failed\n",FromC);
	}

	/* setbuff tc after for IRIX-5.3 ... ?_? */
	setbuffer(fc,i_buff,sizeof(i_buff));
	setbuffer(tc,o_buff,sizeof(o_buff));

	osigint = Vsignal(SIGINT,sigTERM);
	osigterm = Vsignal(SIGTERM,sigTERM);
	osigpipe = Vsignal(SIGPIPE,sigPIPE);

	savConn = *Conn;
	keepAlive = 0;
	clntKeepAlive = 0;
	Serno = 0;
	WhyClosed[0] = 0;

	timeout = HTTP_CKA_TIMEOUT;
	CKA_RemAlive = HTTP_CKA_MAXREQ;

	if( 0 < CKA_RemAlive && Conn->cl_count > HTTP_CKA_PERCLIENT ){
		char clhost[256];
		if( getClientHostPort(Conn,clhost) == 0 )
			strcpy(clhost,"?");
		Verbose("HCKA: too many connections %d/%d for %s\n",
			Conn->cl_count,HTTP_CKA_PERCLIENT,clhost);
		sprintf(WhyClosed,"X:too many Keep-Alive (%s*%d)",clhost,Conn->cl_count);
		CKA_RemAlive = 0;
	}else
	if( 0 < CKA_RemAlive && Conn->cl_count == 1 && 1 < HTTP_CKA_PERCLIENT ){
		timeout = timeout * 10;
		if( timeout < 20 ) timeout = 20;
		if( 60 < timeout ) timeout = 60;
		CKA_RemAlive = CKA_RemAlive * 10;
		if( CKA_RemAlive < 20 ) CKA_RemAlive = 20;
		if( 60 < CKA_RemAlive ) CKA_RemAlive = 60;
	}
	rtimeout = timeout + HTTP_CKA_TIMEOUT_MARGIN;
	ptimeout = 20;
	if( rtimeout <= ptimeout ){
		timeout1 = rtimeout;
		timeout2 = 0;
	}else{
		timeout1 = ptimeout;
		timeout2 = rtimeout - ptimeout;
	}

	do {
		if( 0 < CKA_RemAlive ){
			setKeepAlive(Conn,timeout);
		}
		if( keepAlive ){
			if( DDI_proceedFromC(Conn,fc) < 0 ){
				clntClose(Conn,"d:by client(request EOF-0)");
				setClientEOF(Conn,fc,"request-EOF-0");
				break;
			}

			clear_DGreq(Conn);
			restoreConn(Conn,&savConn);

			if( feof(fc) ){
				clntClose(Conn,"d:by client(request EOF-1)");
				setClientEOF(Conn,fc,"request-EOF-1");
				break;
			}
			if( checkClientEOF(Conn,tc,"keep_alive") ){
				clntClose(Conn,"d:by client(request EOF-2)");
				break;
			}

			fflushKeepAlive(Conn,"request-EOF-3",fc,tc,0);
			if( ClientEOF ){
				clntClose(Conn,"d:by client(request EOF-3)");
				break;
			}
			/* if the flush of the response to the client is
			 * postponed here, it must be flushed when
			 * the connection to or the response from
			 * the next server is blocked... (may be in 
			 * service_http2())
			 */

			till = time(0) + timeout;

			tm0 = time(0);
			nready = DDI_PollIn(Conn,fc,timeout1*1000);
			if( nready < 0 ){
				clntClose(Conn,"d:by client(request EOF-4)");
				setClientEOF(Conn,fc,"request-EOF-4");
				break;
			}

			if( nready == 0 && 0 < timeout2 ){
				ProcTitle(Conn,"(HTTP:keep-alive=%02d:%02d)",
					(till%3600)/60,till%60);

				/* close ServPort not to block other clients
				 */
				checkCloseOnTimeout(0);
				LOG_flushall();
				nready = frPollIn(fc,timeout2*1000);
			}

			if( nready < 0 ){
				clntClose(Conn,"d:by client(request EOF-5)");
				setClientEOF(Conn,fc,"request-EOF-5");
				break;
			}
			if( nready == 0 ){
				clntClose(Conn,"t:timeout: %d",time(0)-tm0);
				break;
			}
			if( READYCC(fc) == 0 )
			if( Peek1(fileno(fc)) < 1 ){
				clntClose(Conn,"d:by client(request EOF-6)");
				setClientEOF(Conn,fc,"request-EOF-6");
				break;
			}

			/* close ServPort because this delegated may be
			 * devoted to a single client
			 */
			checkCloseOnTimeout(0);
		}

		strcpy(method,"?");
		if( keepAlive )
			WhyClosed[0] = '-';
		else
		if( WhyClosed[0] == 0 )
			WhyClosed[0] = '?';
		SentKeepAlive = 0;
		setFTOCL(NULL);
		service_http2(Conn,&httpEnv,fc,tc,method);
		CKA_RemAlive--;
		clntKeepAlive |= ClntKeepAlive;
		RES_CACHE_DISABLE = 0;

		if( tcCLOSED || ClientEOF )
			break;
		if( fflushTIMEOUT(tc) == EOF ){
			clntClose(Conn,"d:by client(request EOF-7)");
			setClientEOF(Conn,fc,"request-EOF-7");
			break;
		}

		if( 0 < CKA_RemAlive ){
			if( !streq(method,"?") ) /* not empty request */
				Serno = incRequestSerno(Conn);
			if( keepAlive || WillKeepAlive )
				Verbose("HCKA:[%d] KeepAlive: %s %c =>%d\n",
					Serno,method,httpStat,WillKeepAlive);
		}
		keepAlive = WillKeepAlive && SentKeepAlive;
	} while( keepAlive && 0 < CKA_RemAlive );

	if( clntKeepAlive && 1 < HTTP_CKA_MAXREQ ){
		http_logplus(Conn,WhyClosed[0]);
		sv1log("HCKA:[%d] closed -- %s\n",RequestSerno,WhyClosed);
	}

	Where = "closeClient";

	if( tcCLOSED )
		fclose(fc);
	else{
		if( checkClientEOF(Conn,tc,NULL) ){
			int fd = fileno(tc);
			close(fd);
			Verbose("## [%d] don't flush to cause SIGPIPE\n",fd);
		}else{
			if( 0 < DELEGATE_LINGER )
				set_linger(fileno(tc),DELEGATE_LINGER);
		}
		fcloses(tc,fc); /* close tc first */
	}
	Vsignal(SIGPIPE,osigpipe);
	Vsignal(SIGTERM,osigterm);
	Vsignal(SIGINT,osigint);

	setFTOCL(FTOCL);
}

nonHTTP(Conn,fc,tc,req)
	Connection *Conn;
	FILE *fc,*tc;
	char *req;
{
	if( isHelloRequest(req)
	 || VSAP_isMethod(req)
	 || strncmp(req,"HELO",4)==0
	 || strncmp(req,"CPORT",5)==0
	 || strncmp(req,"PARAM",5)==0
	){
		Verbose("---- WARNING! HTTP changed to GENERALIST server.\n");
		signal(SIGPIPE,SIG_DFL);
		DDI_proceedFromC(Conn,fc);
		beGeneralist(Conn,fc,tc,req);
		return 1;
	}
	if( strncmp(req,"FTPGET ",7) == 0 ){
		Verbose("---- WARNING: HTTP changed to FTPGET server.\n");
		signal(SIGPIPE,SIG_DFL);
		DDI_proceedFromC(Conn,fc);
		MetamoFTPGET(Conn,req);
		execSpecialist(Conn,FromC,tc,-1);
		return 1;
	}
	return 0;
}

fcloses(ff,ft)
	FILE *ff,*ft;
{	int df,dt;

	df = fileno(ff);
	dt = fileno(ft);

	fcloseTIMEOUT(ff);
	if( df != dt )
		fcloseTIMEOUT(ft);
	else	fclose(ft);
}

int decomp_httpstat(stat,ver,reason)
	char *stat,*ver,*reason;
{	char code[256];
	int ni;

	if( !STRH(stat,F_OKVER) )
		return 1200;

	reason[0] = 0;
	ni = sscanf(stat,"%s %s %[^\r\n]",ver,code,reason);
	if( 2 <= ni )
		return atoi(code);
	else	return -1;
}

static sendHttpResponse(Conn,in,out,req)
	Connection *Conn;
	FILE *in,*out;
	char *req;
{	char myhost[128];
	int myport;

	if( DONT_REWRITE ){
		strcpy(myhost,MYSELF);
		myport = 0;
	}else{	
		myport = ClientIF_H(Conn,myhost);
	}
	relay_response(Conn,0,CLNT_PROTO,myhost,myport,req,NULL,0,
		in,out,NULL,NULL,0);
}

extern FILE *openFilter();
FILE *openHttpResponseFilter(Conn,tc)
	Connection *Conn;
	FILE *tc;
{
	Verbose("## openHttpResponseFilter\n");
	return openFilter(Conn,"HttpResponseFilter",sendHttpResponse,tc,OREQ);
}

relayThru(Conn)
	Connection *Conn;
{
	return DONT_REWRITE && !cur_codeconvCL(NULL) && !CCXactive(CCX_TOCL);
}

service_file(Conn)
	Connection *Conn;
{
	sv1log("access to file ... \n");
}

extern char *file_hostpath();
FILE * URLgetFrom(OrigConn,url,reload,out)
	Connection *OrigConn;
	char *url;
	FILE *out;
{	Connection ConnBuf,*Conn = &ConnBuf;
	char req[1024],*rp,resp[1024];
	int io[2];
	int code;
	FILE *aout;

	aout = out;
	if( out == NULL )
		out = TMPFILE("URLgetFrom");

	if( strncasecmp(url,"file:",5) == 0 ){
		FILE *fp;
		char host[128],*path;

		path = file_hostpath(url,NULL,host);
		if( fp = fopen(path,"r") ){
			copyfile1(fp,out);
			fclose(fp);
			fflush(out);
			Ftruncate(out,0,1);
			fseek(out,0,0);
			return out;
		}
		if( aout == NULL && out != NULL )
			fclose(out);
		return NULL;
	}
	if( strncasecmp(url,"data:",5) == 0 ){
		putData(OrigConn,out,0,url+5);
		fflush(out);
		Ftruncate(out,0,1);
		fseek(out,0,0);
		return out;
	}
	if( strncasecmp(url,"builtin:",8) == 0 ){
		extern char *getMssg();
		char *data;
		int leng;

		sprintf(req,"builtin/%s",url+8);
		data = getMssg(req,&leng);
		if( data == NULL )
			return NULL;
/*
 * eval. if with ".dhtml" extension.
 * on each request based on conditional info.
 */
		fwrite(data,1,leng,out);
		fflush(out);
		Ftruncate(out,0,1);
		fseek(out,0,0);
		return out;
	}

	ConnInit(Conn);
	Conn->from_myself = 1;
	ACT_SPECIALIST = 1;

	if( OrigConn ){
		Conn->cl_sock = OrigConn->cl_sock;
		/*
		Conn->oc_isset = 1;
		Conn->oc_norewrite = OrigConn->oc_norewrite;
		strcpy(Conn->oc_proxy,OrigConn->oc_proxy);
		strcpy(Conn->oc_proto,OrigConn->oc_proto);
		*/
	}

	Socketpair(io);
	FromC = io[0];
	ToC = dup(fileno(out));

	rp = Sprintf(req,"GET %s HTTP/1.0\r\n",url);
	rp = Sprintf(rp,"User-Agent: DeleGate/%s\r\n",DELEGATE_ver());
	if( reload )
		rp = Sprintf(rp,"Pragma: no-cache\r\n");
	strcpy(rp,"\r\n");

	DDI_pushCbuf(Conn,req,strlen(req));
	service_http(Conn);

	fflush(out);
	Ftruncate(out,0,1);
	fseek(out,0,0);

	if( fgets(resp,sizeof(resp),out) != NULL ){
	    if( strncmp(resp,"HTTP/1.0",8) == 0 ){
		sscanf(resp,"HTTP/1.0 %d",&code);
		if( code != 200 ){
			Ftruncate(out,0,0);
			fseek(out,0,0);
			sv1log("error: %s",resp);
		}else{
		    while( fgets(resp,sizeof(resp),out) != NULL )
			if( resp[0] == '\r' || resp[0] == '\n' )
				break;
		}
	    }else
		fseek(out,0,0);
	}

	close(io[0]);
	close(io[1]);

	return out;
}
FILE * URLget(url,reload,out)
	char *url;
	FILE *out;
{
	return URLgetFrom(NULL,url,reload,out);
}

url_cachepath(url,base,cpath)
	char *url,*base,*cpath;
{	char proto[128],login[512],path[URLSZ],host[128];
	int iport;
	char xhost[128];

	proto[0] = login[0] = path[0] = 0;
	sscanf(url,"%[^:]://%[^/]%s",proto,login,path);
	host[0] = 0;
	iport = serviceport(proto);
	sscanf(login,"%[^:]:%d",host,&iport);
	if( base[0] )
		sprintf(xhost,"%s/%s",base,host);
	else	strcpy(xhost,host);
	return cache_path(proto,xhost,iport,path,cpath);
}

extern char *TIMEFORM_RFC822;
putFileInHTTP(tc,path,file)
	FILE *tc;
	char *path,*file;
{	FILE *fp;
	int size,mtime;
	char sdate[1024];

	fp = fopen(path,"r");
	if( fp == NULL ){
		fprintf(tc,"HTTP/1.0 404 not found\r\n");
		return;
	}
	size = file_size(fileno(fp));
	mtime = file_mtime(fileno(fp));
	StrftimeGMT(sdate,sizeof(sdate),TIMEFORM_RFC822,mtime);

	fprintf(tc,"HTTP/1.0 200 OK\r\n");
	fprintf(tc,"MIME-Version: 1.0\r\n");
	fprintf(tc,"Content-Type: application/octet-stream\r\n");
	fprintf(tc,"Content-Transfer-Encoding: base64\r\n");
	fprintf(tc,"Content-Length: %d\r\n",size);
	fprintf(tc,"Last-Modified: %s\r\n",sdate);
	fprintf(tc,"\r\n");
	MIME_to64(fp,tc);
	fclose(fp);
}

