/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1994-1998 Electrotechnical Laboratry (ETL), AIST, MITI
Copyright (c) 1994-1998 Yutaka Sato

Permission to use, copy, and distribute this material for any purpose
and without fee is hereby granted, provided that the above copyright
notice and this permission notice appear in all copies.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	ftp.c (ftp/DeleGate)
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	940305	created
	940321	added data client protocol
	950107	let service_ftp be half-duplex (single process)
	950107	introduced MODE XDC (Data transfer on Control connection)
	950504	Exit if server dead when waiting client's request
ToDo:
	How about "PORT 0,0,0,0,N,M" instead of "MODE XDC" ?
//////////////////////////////////////////////////////////////////////#*/
#include <ctype.h>
#include "vsignal.h"
#include "delegate.h"
extern char *getenv();
extern char *stralloc();
extern char *strcasestr();
extern char *wordscan();
extern char *getClientUserMbox();
extern FILE *TMPFILE();
extern char *mount_url_to();
extern char *mount_url_fromL();
static get_resp();

#define comeq(com1,com2)	(strcasecmp(com1,com2) == 0)
#define remote_path(path)	(strncmp(path,"//",2) == 0)

int FTP_FROMSERV_TIMEOUT = 300;
int FTP_FROMCLNT_TIMEOUT = 900;

extern int CON_TIMEOUT;
int CON_TIMEOUT_DATA;

extern char *fgetsTimeout();
#define fgetsFromST(b,s,f)	fgetsTimeout(b,s,f,FTP_FROMSERV_TIMEOUT)
#define fgetsFromCT(b,s,f)	fgetsTimeout(b,s,f,FTP_FROMCLNT_TIMEOUT)

char *FTP_LIST_COM = "LIST";
char *FTP_LIST_OPT = "-lL";

#define XDC_OPENING	"220-extended FTP [MODE XDC]"
#define XDC_STAT	"999"
#define XDC_PORT_TEMP	"999 PORT %s"


static char *ftp_env_name = "FTP";
static jmp_buf ftp_env;
static void sigPIPE(sig){
	svlog("FTP got SIGPIPE: %s\n",ftp_env_name);
	signal(SIGPIPE,SIG_IGN);
	longjmp(ftp_env,sig);
}

static int serverWithSTAT;

static command_log(fmt,a,b,c)
	char *fmt,*a,*b,*c;
{
	Verbose(fmt,a,b,c);
}

typedef struct {
	char	fc_swcom[32];
	char	fc_user[128];
	char	fc_pass[128];
	char	fc_path[128];
	char	fc_type[64];
	int	fc_SUCcode;
	int	fc_ERRcode;
} FtpConn;
static FtpConn *PFC;

typedef struct {
	int	fs_IAMCC; /* with a cached connection for the host:port */
    Connection *fs_Conn;

	char   *fs_opening;
	char	fs_proto[64];
	char	fs_host[128];
	int	fs_port;
	char	fs_logindir[1024];
	int	fs_islocal; /* CWD is on the local "file://localhost/" */
	int	fs_nocache;

	char	fs_myhost[128];
	int	fs_myport;
	int	fs_imProxy;
	int	fs_anonymous;
	int	fs_serverWithPASV;
	int	fs_serverWithXDC;
	int	fs_IamClientWithXDC;

	int	fs_dsvsock;
	int	fs_psvsock;
	int	fs_pclsock;

	int	fs_modeXDC;
	int	fs_PASVforPORT;
	int	fs_PORTforPASV;

	char   *fs_cstat;
	char	fs_dport[128];
	char	fs_mport[128];
	char	fs_CWD[1024];
	int	fs_auth;
	char	fs_auser[128];
	FILE   *fs_ts;
	FILE   *fs_fs;

	char	fs_USER[128];
	char   *fs_rcUSER;
	char	fs_PASS[128];
	char   *fs_rcPASS;
	char	fs_TYPE[128];
	char	fs_rcSYST[64]; /* SYST response cache */
	char	fs_qcTYPE[32]; /* TYPE request cache */
	char	fs_rcTYPE[32]; /* TYPE response cache */
} FtpStat;

#define MODE(FS)	((FS)->fs_anonymous ? PS_ANON : 0)
static FtpStat *PFS;

static init_FS(FS)
	FtpStat *FS;
{
	bzero(FS,sizeof(FtpStat));
	FS->fs_dsvsock = -1;
	FS->fs_psvsock = -1;
	FS->fs_pclsock = -1;

	if( getenv("NOPASV") )
		FS->fs_serverWithPASV = -1;
}
static save_FS(FS)
	FtpStat *FS;
{
	if( PFS ){
		PFS->fs_pclsock = FS->fs_pclsock;
		PFS->fs_dsvsock = FS->fs_dsvsock;
		PFS->fs_psvsock = FS->fs_psvsock;
		strcpy(PFS->fs_dport,FS->fs_dport);
	}
}

static ServSock(Conn,ts,where)
	Connection *Conn;
	FILE *ts;
	char *where;
{	int toS;

	if( (Conn->xf_filters & XF_SERVER) && 0 <= ToSX ){
		sv1log("## viaCFI [%s]: fileno(ts)=%d ToSX=%d\n",
			where,fileno(ts),ToSX);
		toS = ToSX;
	}else	toS = fileno(ts);
	return toS;
}

is_anonymous(user)
	char *user;
{
	if( strcaseeq(user,"ftp") || strcaseeq(user,"anonymous") )
		return 1;
	if( strncmp(user,"ftp@",4)==0 || strncmp(user,"anonymous@",9)==0 )
		return 1;
	return 0;
}

static com_scode(swcom,passw,scodep,ecodep)
	char *swcom;
	char *passw;
	int *scodep,*ecodep;
{	int scode,ecode;

	scode = 220;
	ecode = 500;
	if( strcaseeq(swcom,"PASS") ){ scode = 230; ecode = 530; }else
	if( strcaseeq(swcom,"OPEN") ){ scode = 220; ecode = 421; }else
	if( strcaseeq(swcom,"USER") ){
		if( passw[0] )       { scode = 230; ecode = 530; }
		else		     { scode = 331; ecode = 530; }
	}else
	if( strcaseeq(swcom,"CWD")  ){ scode = 250; ecode = 550; }
	else
	if( strcaseeq(swcom,"LIST") ){ scode = 150; ecode = 550; }else
	if( strcaseeq(swcom,"NLST") ){ scode = 150; ecode = 550; }else
	if( strcaseeq(swcom,"RETR") ){ scode = 150; ecode = 550; }else
	if( strcaseeq(swcom,"STOR") ){ scode = 150; ecode = 550; }else
	if( strcaseeq(swcom,"STAT") ){ scode = 211; ecode = 550; }else
	if( strcaseeq(swcom,"SIZE") ){ scode = 213; ecode = 550; }else
	if( strcaseeq(swcom,"MDTM") ){ scode = 213; ecode = 550; }

	*scodep = scode;
	*ecodep = ecode;
	return 0;
}

static check_server(server,swcom,tc)
	char *server,*swcom;
	FILE *tc;
{
	return 0;
}
static user_permitted(Conn,tc,serv,port,user)
	Connection *Conn;
	FILE *tc;
	char *serv,*user;
{	char clnt[128];

	getClientHostPort(Conn,clnt);

	set_SERVER(Conn,"ftp",serv,port);
	strcpy(REAL_USER,user);
	if( service_permitted(Conn,DST_PROTO) ){
		sv1log("FTP LOGIN FROM %s TO %s@%s\n",clnt,user,serv);
		fputLog(Conn,"Login","FTP; from=%s; to=%s@%s\n",clnt,user,serv);
		return 1;
	}else{
		fprintf(tc,"553 Permission denied by DeleGate.\r\n");
		fflush(tc);
		sv1log("FTP LOGIN FROM %s TO %s@%s REJECTED\n",clnt,user,serv);
		return 0;
	}
}

static change_server(Conn,tc,swcom,server,cuser,cpass,ctype)
	Connection *Conn;
	FILE *tc;
	char *swcom,*server,*cuser,*cpass,*ctype;
{	char serv[128],*dp;
	char *xp,xuser[256],xpass[256],*ppass;
	int port;
	int shops;
	int svsock;
	int rcode = 0;

	if( PFC == NULL )
		PFC = (FtpConn*)calloc(sizeof(FtpConn),1);

	svsock = -1;
	if( xp = strchr(server,'@') ){
		xuser[0] = xpass[0] = 0;
		sscanf(server,"%[^:@]:%[^@]",xuser,xpass);
		cuser = xuser;
		cpass = xpass;
		server = xp+1;
	}
	if( xp = strrchr(cuser,'%') )
		*xp = '@';

	strcpy(PFC->fc_swcom,swcom);
	com_scode(swcom,cpass,&PFC->fc_SUCcode,&PFC->fc_ERRcode);
	strcpy(PFC->fc_user,cuser);
	strcpy(PFC->fc_pass,cpass);
	strcpy(PFC->fc_type,ctype);

	wordscan(server,serv);
	if( dp = strchr(server,'/') ){
		if( strncmp(dp,"//",2) != 0 )
			dp++;
		wordscan(dp,PFC->fc_path);
	}else	PFC->fc_path[0] = 0;

	if( xp = strrchr(serv,':') ){
		*xp++ = 0;
		port = atoi(xp);
	}else	port = serviceport("ftp");/*DFLT_PORT;*/

	if( 0 <= svsock ){
		Verbose("USER %s\n",cuser);
		getpeerNAME(svsock,serv,NULL,&port);
	}else{
		if( is_anonymous(cuser) )
			ppass = cpass;
		else	ppass = "****";
		Verbose("CWD //[%s:%s]@%s:%d\n",cuser,ppass,serv,port);
	}
	if( serv[0] == 0 )
		strcpy(serv,"localhost");

	if( user_permitted(Conn,tc,serv,port,cuser) ){
		shops = D_FTPHOPS;
		execSpecialist(Conn,FromC,tc,svsock);
		D_FTPHOPS = shops;
		rcode = 0;
	}else{
		rcode = -1;
	}

	PFC = NULL;
	return rcode;
}

static makeDataConn(dport,cntrlsock)
	char *dport;
{	int dsock;
	char host[64],hostport[64];
	int port,a0,a1,a2,a3,p0,p1;

/*
        sscanf(dport,"%d,%d,%d,%d,%d,%d",&a0,&a1,&a2,&a3,&p0,&p1);
	sprintf(host,"%d.%d.%d.%d",a0,a1,a2,a3);
	port = (p0<<8)|p1;
	sprintf(hostport,"%s:%d",host,port);
	if( !isREACHABLE("ftp",hostport) ){
		Verbose("DataConn to unreachable host [%s]\n",hostport);
		return -1;
	}
*/

	dsock = connect_ftp_data(dport,cntrlsock);
	/* It should be connect_to_server() to tcprelay://a.b.c.d:ef/
	 * so that it can be controlled and relayed with DeleGate's routing.
	 */

	set_keepalive(dsock,1);
	return dsock;
}

static insert_scode(str,dst,scode)
	char *str;
	FILE *dst;
{	char *sp,*np,ch;

	for( sp = str; sp && *sp; sp = np ){
		fprintf(dst,"%d- ",scode);
		for( np = sp; ch = *np; np++ ){
			putc(ch,dst);
			if( ch == '\n' ){
				np++;
				break;
			}
		}
	}
}
static escape_scode(str,dst)
	char *str;
	FILE *dst;
{	char *sp,*np,ch;
	int scode;
	int len;

	for( sp = str; sp && *sp; sp = np ){
		if( isdigit(sp[0]) && isdigit(sp[1]) && isdigit(sp[2]) ){
			sp += 3;
			ch = *sp;
			if( ch==' ' || ch=='\t' || ch=='\r' || ch=='\n' ){
				for( len = strlen(sp); 0 <= len; len-- )
					sp[len+1] = sp[len];
				sp[0] = '-';
			}
		}
		if( np = strchr(sp,'\n') )
			np++;
	}
	if( dst != NULL )
		fputs(str,dst);
}

/*
 *	get virtual URL path of given MOUNTed URL
 */
static char *getVUpath(FS,cpath,vpath)
	FtpStat *FS;
	char *cpath,*vpath;
{	char *proto,hostport[256],*path,vurl[1024];
	char *np;

	if( FS->fs_islocal || FS->fs_host[0] == 0 ){
		proto = "file";
		sprintf(hostport,"%s:%d","localhost",0);
	}else{
		proto = "ftp";
		sprintf(hostport,"%s:%d",FS->fs_host,FS->fs_port);
	}
	if( cpath[0] == '/' )
		path = cpath + 1;
	else	path = cpath;

	if( mount_url_fromL(vurl,proto,hostport,path,NULL,"ftp","-.-") ){
		vpath[0] = '/';
		decomp_absurl(vurl,NULL,NULL,vpath+1);
		return vpath;
	}else{
		strcpy(vpath,path);
		return NULL;
	}
}
static char *isLocal(FS,method,rpath,isdir,mpath)
	FtpStat *FS;
	char *method,*rpath,*mpath;
{	char *proto,hostport[256];	
	char *cpath,vurl[1024];
	char *opt;
	char delegate[256];

	if( !FS->fs_islocal )
		return 0;

	if( rpath[0] == '/' ){
		strcpy(vurl,rpath);
		if( opt = mount_url_to(method,vurl) ){
			mpath[0] = '/';
			decomp_absurl(vurl,NULL,NULL,mpath+1);
			return opt;
		}
	}

	strcpy(mpath,FS->fs_CWD);
	chdir_cwd(mpath,rpath,1);
	if( !isdir )
		isdir |= fileIsdir(mpath);
	if( mpath[0] == '/' )
		cpath = mpath + 1;
	else	cpath = mpath;

	/*
	 *	cover MOUNT="/X*  /dir*"   also
	 *	by    MOUNT="/X/* /dir/*"
	 */
	if( isdir && strtailchr(cpath) != '/' )
		strcat(cpath,"/");

	proto = "file";
	sprintf(hostport,"%s:%d","localhost",0);
	ClientIF_HP(FS->fs_Conn,delegate);

	if( opt = mount_url_fromL(vurl,proto,hostport,cpath,NULL,"ftp",delegate) ){
		sv1log("MOUNTED LOCAL [%s] = [%s] opt=%s\n",vurl,mpath,opt);
		return opt;
	}else{
		return 0;
	}
}

decomp_site(proto,site,user,pass,host,port)
	char *proto,*site,*user,*pass,*host,*port;
{	char *dp,uwb[256],ub[256],wb[256],hb[256],pb[256];

	if( dp = strpbrk(site,"@/ \t\r\n\f") )
	if( *dp == '@' ){
		if( user || pass ){
			ub[0] = 0;
			wb[0] = 0;
			sscanf(site,"%[^@:]:%[^@]",ub,wb);
		}
		if( user ) strcpy(user,ub);
		if( pass ) strcpy(pass,wb);
		site = dp + 1;
	}
	hb[0] = 0;
	pb[0] = 0;
	sscanf(site,"%[^:/ \t\r\n\f]:%[0-9]",hb,pb);
	if( host ) strcpy(host,hb);
	if( port ) strcpy(port,pb);

	if( pb[0] )
		return atoi(pb);
	else	return serviceport(proto);
}

static isRemote(FS,com,arg,host,port,path)
	FtpStat *FS;
	char *com,*arg,*host,*path;
	int *port;
{	char proto[256],hostport[256],vurl[1024];

	if( arg[0] == '-' ){
		for( arg++; *arg; arg++ ){
			if( *arg == ' ' || *arg == '\t' ){
				arg++;
				break;
			}
		}
	}
	if( *arg == 0 )
		return 0;

	if( remote_path(arg) ){
		sprintf(vurl,"ftp:%s",arg);
		sv1log("direct access to remote: %s\n",vurl);
	}else{
		if( arg[0] == '/' )
			strcpy(vurl,arg);
		else{
			getVUpath(FS,FS->fs_CWD,vurl);
			if( vurl[0] == 0 )
				strcpy(vurl,"/");
			chdir_cwd(vurl,arg,1);
		}
		
		if( mount_url_to("GET",vurl) == 0 )
			return 0;
	}

	decomp_absurl(vurl,proto,hostport,path);
	*port = decomp_site(proto,hostport,NULL,NULL,host,NULL);

	if( strcaseeq(proto,"file") || strcaseeq(proto,"lpr") || *port <= 0 )
		return 0;

	if( hostcmp(FS->fs_host,host) == 0 && FS->fs_port == *port ){
		sv1log("MOUNTED REMOTE [%s] -> [%s]\n",arg,vurl);
		sprintf(arg,"/%s",path);
		return 0;
	}

	if( *path == 0 )
		strcpy(path,".");
	sv1log("MOUNTED REMOTE [%s:%d] %s %s\n",host,*port,com,path);
	return 1;
}

static char *isGateway(FS,isdir,rpath,path,scheme,lphost,lpportp,lpq,fname)
	FtpStat *FS;
	char *rpath,*path;
	char *scheme,*lphost,*lpq,*fname;
	int *lpportp;
{	char vpath[1024],lprserv[64],upath[1024];
	char *opt;
	int tail_added;

	/*
	if( lpr: is not in MOUNTs )
		return 0;
	*/

	strcpy(vpath,FS->fs_CWD);
	if( vpath[0] == 0 )
		strcpy(vpath,"/");
	chdir_cwd(vpath,rpath,1);
	if( isdir && strtailchr(vpath) != '/' )
		strcat(vpath,"/");
	strcpy(path,vpath);

	if( opt = mount_url_to("PUT",path) ){
		decomp_absurl(path,scheme,lprserv,upath);
		if( strcasecmp(scheme,"lpr") == 0 ){
			lphost[0] = 0;
			*lpportp = 0;
			sscanf(lprserv,"%[^:]:%d",lphost,lpportp);
			lpq[0] = 0;
			strcpy(fname,"LPR/FTP-GateWay");
			sscanf(upath,"%[^/]/%s",lpq,fname);
			sv1log("LPR: //%s /%s\n",lprserv,lpq);
			return opt;
		}
	}
	return 0;
}

static char *scanLISTarg(com,arg,fopt)
	char *com,*arg,*fopt;
{	char *file;

	if( *arg == '-' )
		file = wordscan(arg,fopt);
	else{
		if( strcaseeq(com,"LIST") || strcaseeq(com,"STAT") )
			strcpy(fopt,"-l");
		else	fopt[0] = 0;
		file = arg;
	}
	while( *file == ' ' || *file == '\t' )
		file++;
	return file;
}
extern FILE *ls_unix();
static FILE *putlist(fp,com,fopt,path,file)
	FILE *fp;
	char *com,*fopt,*path,*file;
{	char *rexp,xfopt[128];

	rexp = 0;
	if( File_is(path) || (rexp = strpbrk(path,"*?[")) ){
		if( rexp ){
			sprintf(xfopt,"%s*",fopt);
			fopt = xfopt;
		}
		ls_unix(fp,fopt,NULL,path,NULL);
		sv1log("FTP LOCAL %s [%s][%s]\n",com,fopt,file);
	}else{
		fprintf(fp,"unknown: %s\r\n",path);
	}
}
static FILE *localLIST(FS,tc,com,arg,path)
	FtpStat *FS;
	FILE *tc;
	char *com,*arg,*path;
{	FILE *fp;
	char *file,fopt[1024];
	char scheme[64],lphost[64],lpq[64],fname[1024],stat[4096];
	int lpport;

	file = scanLISTarg(com,arg,fopt);

	scheme[0] = 0;
	if( isGateway(FS,1,file,path,scheme,lphost,&lpport,lpq,fname) )
	if( strcaseeq(scheme,"lpr") ){
		stat_lpr(lphost,lpport,lpq,fopt,fname,stat);
		fp = TMPFILE("FTP-LPRstat");
		fputs(stat,fp);
		fflush(fp);
		fseek(fp,0,0);
		return fp;
	}

	if( isLocal(FS,"GET",file,1,path) ){
		if( 2 <= strlen(path) && strtailchr(path) == '/' )
			path[strlen(path)-1] = 0;

		fp = TMPFILE("FTP-localLIST");
		putlist(fp,com,fopt,path,file);
		fflush(fp);
		fseek(fp,0,0);
		return fp;
	}
	return NULL;
}
static FILE *localRETR(FS,tc,com,arg,path)
	FtpStat *FS;
	FILE *tc;
	char *com,*arg,*path;
{	FILE *fp;

	if( getenv("FTP_ON_HTTP") )
	if( strcaseeq(com,"RETR") ){
		FILE *URLget();
		char url[2048];
		strcpy(path,FS->fs_CWD);
		if( path[0] == '/' )
			strcpy(path,path+1);
		if( arg[0] ){
			if( path[0] ) strcat(path,"/");
			strcat(path,arg);
		}
		sprintf(url,"ftp://%s:%d/%s",FS->fs_host,FS->fs_port,path);
		if( fp = URLget(url,0,NULL) )
		if( 0 < file_size(fileno(fp)) ){
sv1log("#### %x [%s] %d/%d [%s]\n\n",
fp,url,ftell(fp),file_size(fileno(fp)),path);
			fseek(fp,0,1);
			return fp;
		}
		fclose(fp);
	}

	if( isLocal(FS,"GET",arg,0,path) ){
		if( fileIsdir(path) )
			return NULL;
		fp = fopen(path,"r");
		return fp;
	}
	return NULL;
}

static localDELE(FS,tc,com,vpath,path,Conn,user)
	FtpStat *FS;
	FILE *tc;
	char *com,*vpath,*path;
	Connection *Conn;
	char *user;
{	char *opt;
	char scheme[64],lphost[64],lpq[64],fname[1024],stat[4096];
	int lpport;
	int code;

	scheme[0] = 0;
	if( opt = isGateway(FS,0,vpath,path,scheme,lphost,&lpport,lpq,fname) )
	if( strcaseeq(scheme,"lpr") ){
		if( rmjob_lpr(Conn,lphost,lpport,lpq,user,vpath,stat) == 0 ){
			code = 250;
			fprintf(tc,"%d- removed [%s]\r\n",code,vpath);
		}else{
			code = 250;
			fprintf(tc,"%d- no such job [%s]\r\n",code,vpath);
		}
		fputs(stat,tc);
		fprintf(tc,"%d \r\n",code);
		return 1;
	}
	return 0;
}
static localSTOR(FS,tc,com,vpath,path,Conn,user)
	FtpStat *FS;
	FILE *tc;
	char *com,*vpath,*path;
	Connection *Conn;
	char *user;
{	FILE *fp;
	char *opt;
	int cdsock,wcc;
	char port[256];
	FILE *ifp;
	char scheme[64],lphost[64],lpq[64],fname[1024],stat[4096];
	int lpport;

	fp = NULL;
	scheme[0] = 0;
	if( opt = isGateway(FS,0,vpath,path,scheme,lphost,&lpport,lpq,fname) )
		goto STOR;

	opt = isLocal(FS,"PUT",vpath,0,path);
	if( opt == NULL )
		return 0;

	if( strstr(opt,"rw") == NULL && strstr(opt,"writeonly") == NULL ){
		fprintf(tc,"553 Writing disabled.\r\n");
		return 1;
	}
	fp = fopen(path,"w");
	if( fp == NULL ){
		fprintf(tc,"553 %s: Write permission denied.\r\n",vpath);
		return 1;
	}
STOR:
	cdsock = connect_data("FTP-LOCAL",FS,port,Conn->cl_sock);
	if( cdsock < 0 )
		fprintf(tc,"550 cannot connect with you.\r\n");
	else{
		fprintf(tc,"150 Data connection for %s (%s)\r\n",vpath,port);
		fflush(tc);
		ifp = fdopen(cdsock,"r");

		if( strcaseeq(scheme,"lpr") ){
			if( INHERENT_fork() && getenv("LPR_NOWAIT") ){
				FILE *tmp;
				int isize;
				tmp = TMPFILE("LPR/FTP");
				isize = copyfile1(ifp,tmp);
				fflush(tmp);
				fseek(tmp,0,0);
				if( Fork("LPR/FTP") == 0 ){
				wcc = send_lpr(Conn,lphost,lpport,lpq,tmp,isize,
					user,fname,stat);
					Exit(0);
				}
				fclose(tmp);
				strcpy(stat,"sending to LPR ...\r\n");
			}else
			wcc = send_lpr(Conn,lphost,lpport,lpq,ifp,0,
				user,fname,stat);
			fprintf(tc,"226- LPR response:\r\n");
			fputs(stat,tc);
			fprintf(tc,"226 \r\n");
		}else{
			wcc = copyfile1(ifp,fp);
			fprintf(tc,"226 Transfer complete (%d bytes)\r\n",wcc);
		}
		fclose(ifp);
	}
	if( fp )
		fclose(fp);
	return 1;
}

static putToClient(Conn,FS,tc,com,stat,datafd,data,leng,path)
	Connection *Conn;
	FtpStat *FS;
	FILE *tc;
	char *com,*stat,*data,*path;
{	int wcc;
	char msg[256];
	int cdsock;
	char port[256];

	if( datafd < 0 && data == NULL ){
		fprintf(tc,"550 No such file\r\n");
		return -1;
	}

	cdsock = connect_data("FTP-LOCAL",FS,port,Conn->cl_sock);
	if( cdsock < 0 ){
		fprintf(tc,"550 cannot connect with you.\r\n");
		return -1;
	}

	if( stat ){
		fprintf(tc,"150- Ok\r\n");
		fprintf(tc,"%s",stat);
	}
	datamsg(FS,msg,datafd,com,path);
	fprintf(tc,"150 %s\r\n",msg);
	fflush(tc);

	if( 0 <= datafd )
		wcc = FTP_data_relay(Conn,datafd,cdsock,NULL,0);
	else	wcc = write(cdsock,data,leng);
	close(cdsock);

	fprintf(tc,"226 Transfer complete (%d bytes)\r\n",wcc);

	return wcc;
}
static get_help(data)
	char *data;
{	char *dp,*Sprintf();

	dp = data;
	dp = Sprintf(dp,"150-  @ @  \r\n");
	dp = Sprintf(dp,"150- ( - ) { %s }\r\n",DELEGATE_version());
	dp = Sprintf(dp,"150- Enter cd //server/path\r\n");
	dp = Sprintf(dp,"150-          to go `path' on FTP `server'\r\n");
	dp = Sprintf(dp,"150- This (proxy) service is maintained by '%s'\r\n",
		DELEGATE_MANAGER);
}
static AsServer(Conn,FS,tc,com,arg,user)
	Connection *Conn;
	FtpStat *FS;
	FILE *tc;
	char *com,*arg;
	char *user;
{	char data[4096],path[1024];
	FILE *fp;

	if( strcasecmp(com,"NOOP") == 0 ){
		fprintf(tc,"200 NOOP command successful.\r\n");
	}else
	if( strcasecmp(com,"SYST") == 0 ){
		fprintf(tc,"500 SYST command is not supported.\r\n");
	}else
	if( strcasecmp(com,"MODE") == 0 ){
		fprintf(tc,"200 MODE %s Ok.\r\n",arg);
		if( strcaseeq(arg,"XDC") )
			FS->fs_modeXDC = 1;
		else	FS->fs_modeXDC = 0;
	}else
	if( strcasecmp(com,"PORT") == 0 ){
		setupPORT(Conn,FS,NULL,NULL,tc,arg);
	}else
	if( strcasecmp(com,"PASV") == 0 ){
		setupPASV(Conn,FS,NULL,NULL,tc,arg);
	}else
	if( strcasecmp(com,"TYPE") == 0 ){
		wordscan(arg,FS->fs_TYPE);
		fprintf(tc,"200 Type set to %s\r\n",FS->fs_TYPE);
	}else
	if( strcasecmp(com,"MDTM") == 0 ){
		char paht[1024],stime[128];
		if(isLocal(FS,"GET",arg,0,path) && File_is(path) && !fileIsdir(path)){
			StrftimeGMT(stime,sizeof(stime),
				"%Y%m%d%H%M%S",File_mtime(path));
			fprintf(tc,"213 %s\r\n",stime);
		}else	fprintf(tc,"550 %s: No such file\r\n",arg);
	}else
	if( strcasecmp(com,"STAT") == 0 ){
	    if( arg[0] == 0 ){
		char myhost[256];
		ClientIF_name(Conn,FromC,myhost);
		fprintf(tc,"211-%s FTP server status:\r\n",myhost);
		fprintf(tc,"    Version: FTP/%s\r\n",DELEGATE_version());
	    }else{
		char *file,fopt[128],path[1024];
		int body;

		file = scanLISTarg(com,arg,fopt);
		if( strncasecmp(fopt,"-HTTP",5) == 0 ){
			*fopt = 0;
			body = 1;
		}else	body = 0;
		fprintf(tc,"211-status of %s [%s][%s]:\r\n",arg,fopt,file);

		if( isLocal(FS,"GET",file,0,path) )
			if( body ){
				putFileInHTTP(tc,path,file);
				fputs("\r\n--\r\n",tc);
			}else	putlist(tc,com,fopt,path,file);
		else	fprintf(tc,"%s not found\r\n",file);
	    }
	    fprintf(tc,"211 end of status\r\n");
	}else
	if( strcasecmp(com,"STOR")==0 ){
		if( localSTOR(FS,tc,com,arg,path,Conn,user) )
			return 1;
		return 0;
	}else
	if( strcasecmp(com,"DELE")==0 ){
		if( localDELE(FS,tc,com,arg,path,Conn,user) )
			return 1;
		else	return 0;
	}else
	if( strcasecmp(com,"LIST")==0 || strcasecmp(com,"NLST")==0 ){
		if( fp = localLIST(FS,tc,com,arg,path) ){
			putToClient(Conn,FS,tc,com,NULL,fileno(fp),NULL,0,path);
			fclose(fp);
		}else{
			get_help(data);
			putToClient(Conn,FS,tc,com,data,-1,"",0,"(init)");
		}
	}else
	if( strcasecmp(com,"RETR") == 0 ){
		int start;
		int leng,xc;

		start = time(0);
		if( fp = localRETR(FS,tc,com,arg,path) ){
			xc = putToClient(Conn,FS,tc,com,NULL,fileno(fp),NULL,0,path);
			fclose(fp);
			putXferlog(Conn,FS,com,arg,start,xc);
		}else	putToClient(Conn,FS,tc,com,NULL,-1,NULL,0,"(error)");
	}else{
		/*fprintf(tc,"500 Unknown command\r\n");*/
		return 0;
	}
	return 1;
}

static rewrite_CWD(FS,req,arg,tc)
	FtpStat *FS;
	char *req,*arg;
	FILE *tc;
{	char mdir[1024],vdir[1024],*dp;
	char npath[1024],*ncwd;
	char rmsg[1024];

	getVUpath(FS,FS->fs_CWD,mdir);
	if( mdir[0] == 0 )
		strcpy(mdir,"/");
	chdir_cwd(mdir,arg,1);
	strcpy(vdir,mdir);

	if( strncmp(FS->fs_CWD,"//",2) == 0 && strncmp(mdir,"//",2) != 0 ){
		strcpy(mdir,FS->fs_CWD);
		if( dp = strchr(mdir+2,'/') )
			chdir_cwd(dp,arg,1);
	}

	FS->fs_islocal = 0;

	if( strtailchr(mdir) != '/' )
		strcat(mdir,"/");

	if( mount_url_to("GET",mdir) == 0 ){
		strcpy(vdir,FS->fs_CWD);
		if( mdir[0] == 0 )
			strcpy(vdir,"/");
		else
		if( strtailchr(vdir) != '/' )
			strcat(vdir,"/");
		strcpy(mdir,vdir);
		if( mount_url_to("GET",mdir) )
		if( strncmp(mdir,"lpr:",4) == 0 ){
			strcpy(mdir,vdir);
			chdir_cwd(mdir,arg,1);
			strcpy(FS->fs_CWD,mdir);
			sv1log("LEAVE-MOUNTED-LPR: %s => %s\n",vdir,mdir);
			sprintf(rmsg,"250 CWD command successful.\r\n");
			goto EXIT;
		}
		return 0;
	}
	if( strncmp(mdir,"lpr://",6) == 0 ){
		sv1log("MOUNTED-TO-LPR: %s => %s\n",vdir,mdir);
		strcpy(FS->fs_CWD,vdir);
		sprintf(rmsg,"250 CWD command successful.\r\n");
		goto EXIT;
	}

	if( strncmp(mdir,"ftp://",6) == 0 ){
		strcpy(arg,mdir+4);
		if( req != NULL )
			sprintf(req,"CWD %s\r\n",arg);
		sv1log("MOUNTED-TO: %s\n",arg);
		return 0;
	}

	if( strncmp(mdir,"file://localhost/",17) != 0 )
		return 0;

	FS->fs_islocal = 1;
	ncwd = mdir + 16;
	if( fileIsdir(ncwd) ){
		sv1log("MOUNTED-TO-LOCAL: %s\n",mdir);
		strcpy(FS->fs_CWD,ncwd);
		sprintf(rmsg,"250 CWD command successful.\r\n");
	}else{
		sv1log("MOUNTED-TO-LOCAL#UNKNOWN: %s\n",mdir);
		sprintf(rmsg,"550 %s: No such directory.\r\n",vdir);
	}
EXIT:
	if( tc != NULL ){
		fputs(rmsg,tc);
		fflush(tc);
	}
	return 1;
}
static scanPWD(resp,path,rem)
	char *resp,*path,*rem;
{	char rembuf[1024];

	if( rem == NULL )
		rem = rembuf;
	path[0] = rem[0] = 0;
	return sscanf(resp,"257 \"%[^\"]\"%[^\r\n]",path,rem);
}
static rewrite_PWD(FS,req,arg,tc)
	FtpStat *FS;
	char *req,*arg;
	FILE *tc;
{	char cwd[1024],npath[1024],*tp;
	char resp[1024];

	if( FS->fs_CWD[0] )
		strcpy(cwd,FS->fs_CWD);
	else	strcpy(cwd,FS->fs_logindir);

	if( getVUpath(FS,cwd,npath) == NULL )
		return 0;

	sv1log("local echo for PWD: ftp://%s:%d/%s\n",
		FS->fs_host,FS->fs_port,cwd);

	if( tp = strrchr(npath,'/') )
	if( tp != npath && tp[1] == 0 )
		*tp = 0;
	sprintf(resp,"257 \"%s\" is current directory.\r\n",npath);
	sv1log("I-SAY: %s",resp);
	fputs(resp,tc);
	fflush(tc);
	return 1;
}
static setLoginPWD0(FS,resp)
	FtpStat *FS;
	char *resp;
{	char path[1024];

	scanPWD(resp,path,NULL);
	strcpy(FS->fs_logindir,path);
	sv1log("LoginPWD: \"%s\"\n",path);
}
static setLoginPWD(FS,ts,fs)
	FtpStat *FS;
	FILE *ts,*fs;
{	char resp[1024];

	fputs("PWD\r\n",ts);
	fflush(ts);
	if( get_resp(fs,NULL,resp,sizeof(resp)) == EOF )
		return -1;

	setLoginPWD0(FS,resp);
	return 0;
}
checkAnonftpAuth(user,pass) 
	char *user,*pass;
{	char *host;
	int smtp_vrfy,checkuser;

	if( auth_anonftp("*",user,pass) )
		return 0;

	if( auth_anonftp("smtp-vrfy",user,pass) ){ 
		smtp_vrfy = 1;
		checkuser = 1;
	}else
	if( auth_anonftp("smtp-vrfy",user,"-@*") ){
		smtp_vrfy = 1;
		checkuser = 0;
	}else{
		smtp_vrfy = 0;
		checkuser = 1;
	}

	if( smtp_vrfy ) 
	if( validateEmailAddr(user,checkuser) == 0 ){
		if( host = strchr(user,'@') ){
			host++;
			if( strchr(host,'.') == 0 && gethostint_nbo(host) != -1 ){
				getFQDN(host,host);
				sv1log("anonftp PASS rewritten with FQDN: %s\n",user);
			}
		}
		return 0;
	}

	return -1;
}
static anonPASS(tc,user,pass)
	FILE *tc;
	char *user,*pass;
{	char pass1[256],pass2[256];

	strcpy(pass1,pass);
	RFC822_strip_comment(pass1,pass1);
	strcpy(pass2,pass1);

	if( checkAnonftpAuth(pass2,pass2) == 0 ){
		if( strcmp(pass1,pass2) != 0 )
			strcpy(pass,pass2);/* host part rewriten by smtp-vrfy */
		return 0;
	}

	if( tc != NULL ){
		sv1log("Bad anonymous login\n");
		fprintf(tc,"530 Invalid/Forbidden Email address '%s'\n",pass);
		fflush(tc);
	}
	return -1;
}

#define RETRCOMS(com)	 ( comeq(com,"NLST") || comeq(com,"LIST") \
			|| comeq(com,"RETR") || comeq(com,"STOR") )

#define PATHCOMS(com)	 ( RETRCOMS(com) \
			|| comeq(com,"STAT") \
			|| comeq(com,"SIZE") || comeq(com,"MDTM") )

static ftp_banner(Conn,tc)
	Connection *Conn;
	FILE *tc;
{	char *aurl,rurl[256],msg[2048],buf[0x4000];
	FILE *tmp;
	int rcc;

	aurl = "/-/builtin/mssgs/file/ftp-banner.dhtml";
	getBuiltinData(Conn,"FTP-banner",aurl,msg,sizeof(msg),rurl);

	tmp = TMPFILE("FTPbanner");
	put_eval_dhtml(Conn,rurl,tmp,msg);
	fflush(tmp);
	fseek(tmp,0,0);
	rcc = fread(buf,1,sizeof(buf),tmp);
	buf[rcc] = 0;
	insert_scode(buf,tc,220);

fprintf(tc,"%s\r\n",XDC_OPENING);

	fprintf(tc,"220  \r\n");
	fclose(tmp);
}

static proxyFTP(Conn)
	Connection *Conn;
{	FILE *tc,*fc;
	char req[1024],*dp,com[128],arg[1024];
	char *chost,cuser[256],cpass[256],xpath[1024];
	char usermbox[256];
	int anonymous = 0;
	int csock;
	FtpStat FSbuf, *FS = &FSbuf;
	int timeout;

	PFS = FS;
	init_FS(FS);
	FS->fs_Conn = Conn;
	tc = fdopen(dup(ToC),"w");
	strcpy(arg,"/");
	rewrite_CWD(FS,NULL,arg,NULL);
	if( strncmp(arg,"//",2) == 0 ){
		change_server(Conn,tc,"OPEN",arg+2,"","","");
		return;
	}
	strcpy(FS->fs_logindir,FS->fs_CWD);
	fc = fdopen(dup(FromC),"r");
	ftp_banner(Conn,tc);
	fflush(tc);

	usermbox[0] = 0;
	getClientUserMbox(Conn,usermbox);

	cuser[0] = cpass[0] = 0;
	xpath[0] = 0;
	FS->fs_TYPE[0] = 0;
	FS->fs_serverWithPASV = 1;

	for(;;){
		if( Conn->co_error & CO_TIMEOUT )
			break;
		if( Conn->co_error & CO_CLOSED )
			break;

		fflush(tc);
		if( FS->fs_CWD[0] == 0 )
			timeout = LOGIN_TIMEOUT * 1000;
		else	timeout = FTP_FROMCLNT_TIMEOUT * 1000;
		if( fPollIn(fc,timeout) <= 0 ){
			fprintf(tc,"421 ---- PROXY-FTP login: TIMEOUT(%d)\n",
				LOGIN_TIMEOUT);
			fflush(tc);
			break;
		}
		if( fgetsFromCT(req,sizeof(req),fc) == NULL ){
			sv1log("proxyFTP got EOF from the client.\n");
			break;
			/* Exit(0); Login LOG should be flushed.  QUIT command
			   from the user should be remembered as a normal EOF
			 */
		}
		if( strncasecmp(req,"PASS",4) == 0 && anonymous == 0 )
			command_log("CLIENT-SAYS: PASS ********\n");
		else    command_log("CLIENT-SAYS: %s",req);

		dp = wordscan(req,com);
		linescan(dp,arg,sizeof(arg));

		if( strcaseeq(com,"USER") )
			if( unescape_user_at_host(arg) )
				sprintf(req,"%s %s\r\n",com,arg);

		if( PATHCOMS(com) ){
			char host[256],server[256];
			int port;

			if( isRemote(FS,com,arg,host,&port,xpath) ){
				HostPort(server,"ftp",host,port);
				sprintf(server+strlen(server),"/%s",xpath);
				change_server(Conn,tc,com,server,
					cuser,cpass,FS->fs_TYPE);
				continue;
			}
		}

		if( AsServer(Conn,FS,tc,com,arg,cuser) ){
			continue;
		}else
		if( Mounted() )
		/* if mounted */{
			if( strcasecmp(com,"USER") == 0 && strchr(arg,'@') ){
				char serv[1024],host[256];
				int port;

				strcpy(cuser,arg);
				dp = strrchr(cuser,'@'); *dp++ = 0;
				strcpy(serv,dp);
				if( serv[0] ){
					port = 21;
					sscanf(serv,"%[^:]:%d",host,&port);
					if( !user_permitted(Conn,tc,host,port,
					  cuser) )
						continue;
				}
				if( cuser[0] && serv[0] ){
					anonymous = is_anonymous(cuser);
					strcpy(com,"CWD");
					sprintf(arg,"//%s/",serv);
					sprintf(req,"%s %s\r\n",com,arg);
					sv1log("rewritten to: %s",req);
				}
			}
			if( strcaseeq(com,"CDUP") ){
				strcpy(com,"CWD");
				strcpy(arg,"..");
				sprintf(req,"%s %s\r\n",com,arg);
			}
			if( strcasecmp(com,"CWD") == 0 )
				if( rewrite_CWD(FS,req,arg,tc) )
					continue;
		}
		if( strcasecmp(com,"USER") == 0 ){
			wordscan(req+5,cuser);
			if( chost = strrchr(cuser,'@') ){
				*chost++ = 0;
				cpass[0] = 0;
				change_server(Conn,tc,com,chost,cuser,cpass,FS->fs_TYPE);
				continue;
			}
			strcpy(FS->fs_USER,cuser);
			anonymous = is_anonymous(cuser);
			if( anonymous ){
			    if( usermbox[0] ){
 fprintf(tc,"331- Guest login ok, enter your E-mail address as password.\r\n");
 fprintf(tc,"331  Default value is: %s\r\n",usermbox);
			    }else{
 fprintf(tc,"331 Guest login ok, enter your E-mail address as password.\r\n");
			    }
			}else{
 fprintf(tc,"331 Password required for %s.\r\n",cuser);
			}
		}else
		if( strcasecmp(com,"PASS") == 0 ){
			cpass[0] = 0;
			sscanf(req+5,"%[^\r\n]",cpass);
			if( anonymous ){
			    FS->fs_anonymous = 1;
			    if( *cpass == 0 && usermbox[0] != 0 )
				strcpy(cpass,usermbox);
			    if( anonPASS(tc,cuser,cpass) != 0 ){
				cpass[0] = 0;
				continue;
			    }
			    strcpy(FS->fs_PASS,cpass);

 fprintf(tc,"230- Guest login ok, your E-mail address is <%s>\r\n",cpass);
			}else{
			    FS->fs_anonymous = 0;
 fprintf(tc,"230- User %s logged in.\r\n",cuser);
			}
			if( xpath[0] ){
				change_server(Conn,tc,com,xpath,cuser,cpass,FS->fs_TYPE);
				xpath[0] = 0;
				return;
			}else{
 fprintf(tc,"230  Now you can select a FTP SERVER by cd //SERVER\r\n");
			}
		}else
		if( strcaseeq(com,"CWD") && strncmp(arg,"//",2) == 0 ){
			if( cpass[0] == 0 ){
				strcpy(xpath,arg+2);
 fprintf(tc,"331 Password required for %s.\r\n",cuser);
				continue;
			}
			change_server(Conn,tc,com,req+6,cuser,cpass,FS->fs_TYPE);
		}else
		if( strcaseeq(com,"CWD") && controlCWD(FS,tc,arg) ){
			continue;
		}else
		if( strcasecmp(com,"SITE")==0 || strcasecmp(com,"OPEN")==0 ){
			change_server(Conn,tc,com,req+5,cuser,cpass,FS->fs_TYPE);
		}else
		if( strcasecmp(com,"MACB") == 0 ){
 fprintf(tc,"500 MACB? nani sore ?_?\r\n");
		}else
		if( strcasecmp(com,"QUIT") == 0 ){
 fprintf(tc,"221 Goodbye.\r\n");
			break;
		}else
		if( strcasecmp(com,"CDUP")==0 ){
 fprintf(tc,"250 CWD command successful.\r\n");
		}else
		if( strcasecmp(com,"CWD")==0 ){
			if( rewrite_CWD(FS,req,arg,tc) ){
			}else
 fprintf(tc,"250 CWD command successful.\r\n");
		}else
		if( strcasecmp(com,"PWD") == 0 ){
			if( !rewrite_PWD(FS,req,arg,tc) ){
 fprintf(tc,"257 \"%s\" is current directory.\r\n",FS->fs_CWD);
			}
		}else{
 fprintf(tc,"500-%s",req);
 fprintf(tc,"500 only USER,PASS,TYPE,QUIT and CWD are available.\r\n");
			sv1log("Unknown request: %s",req);
		}
	}
	fflush(tc);
}

static get_resp(fs,tc,resps,rsize)
	FILE *fs,*tc;
	char *resps;
{	char *rp,resp[1024],rcode[4];
	int lines;
	int remlen;
	int leng;

	if( fs == NULL )
		return 0;

	if( resps ){
		remlen = rsize - 1;
		rp = resps;
		*resps = 0;
	}

	rcode[0] = 0;
	for(lines = 0;;lines++){
		if( fgetsFromST(resp,sizeof(resp),fs) == 0 ){
		sv1log("FTP: connection timedout or closed by the server\n");
			return EOF;
		}
		if( tc != NULL ){
			fputs(resp,tc);
			fflush(tc);
		}

		if( lines == 0 )
			command_log("FTP-SERVER-SAYS: %s",resp);

		leng = strlen(resp);
		if( resps && leng < remlen ){
			strcpy(rp,resp);
			rp += leng;
			remlen -= leng;
		}

		if( resp[3] == '-' ){
			if( rcode[0] == 0 )
				strncpy(rcode,resp,3);
		}else{
			if( rcode[0] == 0 || strncmp(resp,rcode,3) == 0 )
				break;
		}
	}

	if( !isdigit(resp[0]) )
		return EOF;
	if( resp[0] == '5' )
		return EOF;
	return 0;
}

#define PS_ANON	1
#define PS_BUFF	2

static put_serv(mode,ts,fmt,a,b,c,d,e,f,g)
	FILE *ts;
	char *fmt,*a,*b,*c,*d,*e,*f,*g;
{	char req[1024];
	int rcode;

	rcode = fprintf(ts,fmt,a,b,c,d,e,f,g);
	if( rcode == EOF )
		return EOF;

	if( (mode & PS_BUFF) == 0 )
		if( fflush(ts) == EOF ){
			sv1log("put_serv: EOF\n");
			return EOF;
		}

	sprintf(req,fmt,a,b,c,d,e,f,g);
	if( strncasecmp(req,"PASS",4) == 0 && (mode & PS_ANON) == 0 )
		command_log("I-SAY: PASS ********\n");
	else	command_log("I-SAY: %s",req);
	return rcode;
}
static _put_get(mode,ts,fs,resp,rsize,fmt,a,b,c,d,e,f,g)
	FILE *ts,*fs;
	char *resp;
	char *fmt,*a,*b,*c,*d,*e,*f,*g;
{
	if( fmt ){
		if( put_serv(mode,ts,fmt,a,b,c,d,e,f,g) == EOF )
			return EOF;
	}

	if( get_resp(fs,NULL,resp,rsize) == EOF )
		return EOF;

	return 0;
}
static put_get(ts,fs,resp,rsize,fmt,a,b,c,d,e,f,g)
	FILE *ts,*fs;
	char *resp;
	char *fmt,*a,*b,*c,*d,*e,*f,*g;
{
	return _put_get(0,ts,fs,resp,rsize,fmt,a,b,c,d,e,f,g);
}

char *searchPortSpec(resp)
	char *resp;
{	char *rp;
	int p;

	for( rp = resp; *rp; rp++ ){
		if( isdigit(*rp) )
			if( sscanf(rp,"%*d,%*d,%*d,%*d,%*d,%d",&p) == 1 )
				return rp;
	}
	return NULL;
}

static mkdsockPASV(Conn,ts,fs,resp,rsize)
	Connection *Conn;
	FILE *ts,*fs;
	char *resp;
{	char *rp;
	int psock;
	int timeout,stimeout;

	put_serv(0,ts,"PASV\r\n");
	if( get_resp(fs,NULL,resp,rsize) == EOF || resp[0] != '2' ){
		sv1log("PASV ... %s",resp);
		return -1;
	}

	rp = searchPortSpec(resp);
	if( rp ){
		stimeout = CON_TIMEOUT;
		timeout = CON_TIMEOUT_DATA;
		psock = makeDataConn(rp,ServSock(Conn,ts,"mkPASV"));
		CON_TIMEOUT = stimeout;
	}else{
		sv1log("UNKNOWN PASV RESPONSE: %s",resp);
		AbortLog();
		psock = -1;
	}
	return psock;
}
static mkdsockPORT(Conn,host,ts,fs)
	Connection *Conn;
	char *host;
	FILE *ts,*fs;
{	int dsock;
	char mport[256],resp[1024];

	dsock = mkserv_sock_ftp(mport,host,21,ServSock(Conn,ts,"mkPORT"),0);
	if( dsock < 0 )
		return dsock;

	put_serv(0,ts,"PORT %s\r\n",mport);
	if( fs != NULL )
		get_resp(fs,NULL,resp,sizeof(resp));
	return dsock;
}
static listretr(ts,fs,path,isdirp,resp,rsize)
	FILE *ts,*fs;
	char *path;
	int *isdirp;
	char *resp;
{	char *dp;
	char xpath[1024],apath[1024],comm[1024];
	int isdir;

	isdir = 0;
	if( *path == 0 )
		isdir = 1;
	else
	if( (dp = strrchr(path,'/')) && dp != path && dp[1] == 0 ){
		path = strcpy(xpath,path);
		*strrchr(path,'/') = 0;
		isdir = 1;
	}

	if( !isdir && put_get(ts,fs,resp,rsize,"CWD %s\r\n",path) == EOF ){
		strcpy(xpath,path);
		if( dp = strrchr(xpath,'/') ){
			*dp = 0;
			if( put_get(ts,fs,resp,rsize,"CWD %s\r\n",xpath) != EOF )
				path = dp + 1;
		}
		sprintf(comm,"RETR %s",path);
		isdir = 0;
	}else{
		if( isdir && path[0] )
		if( put_get(ts,fs,resp,rsize,"CWD %s\r\n",path) == EOF )
			return -1;

		sprintf(comm,"%s %s",FTP_LIST_COM,FTP_LIST_OPT);
		isdir = 1;
	}

	if( put_get(ts,fs,resp,rsize,"%s\r\n",comm) == EOF )
		return -1;

	if( isdirp )
		*isdirp = isdir;
	return 0;
}
static stor(ts,fs,path,resp,rsize)
	FILE *ts,*fs;
	char *path,*resp;
{	char *dp,dir[102];

	if( strrchr(path,'/') ){
		strcpy(dir,path);
		path = strrchr(dir,'/');
		*path++ = 0;
		if( put_get(ts,fs,resp,rsize,"CWD %s\r\n",dir) == EOF )
			return -1;
	}
	if( put_get(ts,fs,resp,rsize,"STOR %s\r\n",path) == EOF )
		return -1;
	return 0;
}

ACCEPTdc(dsvsock,asServer)
{	char host[128];
	int port,dsock;

	if( peerHostport(dsvsock,NULL) != -1 ){
		if( ViaVSAPassociator(dsvsock) ){
			char sockname[256],peername[256];
			dsock = VSAPaccept(FTP_ACCEPT_TIMEOUT,dsvsock,0,sockname,peername);
			if( 0 <= dsock )
				dsock = dup(dsvsock);
		}else
		if( acceptViaSocks(dsvsock,host,&port) == 0 )
			dsock = dup(dsvsock);
		else	dsock = -1;
	}else{
		dsock = ACCEPT(dsvsock,asServer,-1,FTP_ACCEPT_TIMEOUT);
		if( dsock < 0 )
			sv1log("FTP ACCEPT_TIMEOUT %d\n",FTP_ACCEPT_TIMEOUT);
	}
	return dsock;
}
static ACCEPT_SVPORT(dsvsock,asServer)
{	int dsock;
	char shost[128];
	int sport;

	Verbose("Start accept on port for PORT from server[%d]\n",dsvsock);
	dsock = ACCEPTdc(dsvsock,asServer);
	if( 0 < dsock ){
		getpeerNAME(dsock,shost,NULL,&sport);
		Verbose("Accepted the data port: %s:%d\n",shost,sport);
	}
	return dsock;
}

static data_open(Conn,put,PASV,dsock,host,ts,fs,path,isdirp,resp,rsize)
	Connection *Conn;
	char *host;
	FILE *ts,*fs;
	char *path;
	int *isdirp;
	char *resp;
{	int psock = -1;
char xpath[1024];

	if( PASV )
		psock = mkdsockPASV(Conn,ts,fs,resp,rsize);

	if( psock < 0 && dsock < 0 )
		dsock = mkdsockPORT(Conn,host,ts,fs);

	if( path != 0 ){
	    if( put ){
		if( stor(ts,fs,path,resp,rsize) < 0 ){
			if( 0 <= psock ){
				close(psock);
				psock = -1;
			}
			goto EXIT;
		}
	    }else{
		if( listretr(ts,fs,path,isdirp,resp,rsize) < 0 ){
			if( 0 <= psock ){
				close(psock);
				psock = -1;
			}
			goto EXIT;
		}
	    }
	}

	if( psock < 0 ){
		psock = ACCEPTdc(dsock,0);
		if( psock < 0 ){
			char myhost[256];
			gethostname(myhost,sizeof(myhost));
			sprintf(resp,
				"500 Data connection accept timedout (%s).\r\n",
				myhost);
		}
	}
EXIT:
	if( 0 <= dsock ){
		close(dsock);
		dsock = -1;
		/*sv1log("FTP DATA-PORT: %s = sock[%d]\n",mport,psock);*/
	}
	return psock;
}

static char *relay1(ser,buff,leng,tcfp)
	char *buff;
	FILE *tcfp;
{	int wcc;

	Verbose("@%d - %d relay1.\n",ser,leng);
	if( 0 < ser )
		wcc = fwrite(buff,1,leng,tcfp);
	return "";
}

/* PORT to/from XDC relay */
static XDCrelayServ(STOR,ts,fs,tc,fc,dsock,port, cachefp,resp,rsize)
	FILE *ts,*fs,*tc,*fc;
	char *port;
	FILE *cachefp;
	char *resp;
{	FILE *dfp;
	int xc;

	sv1log("--- XDC data_relay SERVER (%s).\n",STOR?"STOR":"RECV");
	fprintf(tc,XDC_PORT_TEMP,port);
	fprintf(tc,"\r\n");
	fflush(tc);

	if( STOR ){
		dfp = fdopen(dsock,"w");
		xc = getMessageF(fc,cachefp,FTP_FROMSERV_TIMEOUT,relay1,dfp);
		fclose(dfp);
		get_resp(fs,NULL,resp,rsize);
	}else{
		dfp = fdopen(dsock,"r");
		xc = putMessageF(dfp,tc,cachefp);
		fclose(dfp);
		get_resp(fs,NULL,resp,rsize);
		putPostStatus(tc,resp);
	}
	fputs(resp,tc);
	fflush(tc);
	return xc;
}
static XDCrelayClnt(Conn,STOR,ts,fs,tc,fc, cachefp,resp,rsize)
	Connection *Conn;
	FILE *ts,*fs,*tc,*fc;
	FILE *cachefp;
	char *resp;
{	char port[128];
	int dsock;
	FILE *dfp;
	int xc;

	sv1log("---- XDC data_relay CLIENT (%s).\n",STOR?"STOR":"RECV");
	get_resp(fs,NULL,resp,rsize);

	if( sscanf(resp,XDC_PORT_TEMP,port) == 0 ){
		fputs(resp,tc);
		fflush(tc);
		return 0;
	}

	Verbose("XDC %s",resp);
	dsock = makeDataConn(port,ClientSock);

	if( STOR ){
		dfp = fdopen(dsock,"r");
		xc = putMessageF(dfp,ts,cachefp);
		fclose(dfp);
		putPostStatus(ts,"done\r\n");
		fflush(ts);
	}else{
		dfp = fdopen(dsock,"w");
		xc = getMessageF(fs,cachefp,FTP_FROMSERV_TIMEOUT,relay1,dfp);
		fflush(dfp);
		close(fileno(dfp));
		fclose(dfp);
	}
	get_resp(fs,NULL,resp,rsize);
	fputs(resp,tc);
	fflush(tc);
	return xc;
}
static XDCrelayThru(fs,tc)
	FILE *fs,*tc;
{	char resp[128],port[128];

	get_resp(fs,NULL,resp,sizeof(resp));
	cpyMessageF(fs,tc);
	fflush(tc);
}

FTP_data_relay(Conn,src,dst,cachefp,tosv)
	Connection *Conn;
	FILE *cachefp;
{	char buff[0x8000];
	int xc,rc,wc1,wc,size;
	int sr,ss,dr,ds;
	int dstEOF;
	int niced,rcode,ngets;
	double Start,Time();
	int odst;
	char *reason;
	extern int IO_TIMEOUT;
	int fromcache;

	size = sizeof(buff);

	if( fromcache = file_isreg(src) ){
		sr = ss = 0;
	}else{
		setsockbuf(src,size,0);
		getsockbuf(src,&sr,&ss);
	}
	setsockbuf(dst,0,size);
	getsockbuf(dst,&dr,&ds);

	xc = 0;
	Verbose("FTP data-relay(%d,%d): bufsize=%d\n",src,dst,size);

	odst = dst;
	if( tosv != 0 && filter_withCFI(Conn,XF_FTOSV) )
		dst = insertFTOSV(Conn,dst,src,NULL);
	else
	if( tosv == 0 && filter_withCFI(Conn,XF_FTOCL) )
		dst = insertFTOCL(Conn,dst,src,NULL);

	Start = Time();
	niced = 0;
	dstEOF = 0;
	reason = "?";

	for( ngets = 0; ; ngets++  ){
		if( fromcache )
			rc = read(src,buff,size);
		else{
			if( !readyAlways(src) )
			if( PollIn(src,IO_TIMEOUT*1000) <= 0 ){
				reason = "poll-TIMEOUT";
				break;
			}
			rc = readsTO(src,buff,size,100);
		}
		if( rc <= 0 ){
			reason = "read-EOF";
			break;
		}

		if( cachefp )
			fwrite(buff,1,rc,cachefp);
		xc += rc;
		for( wc = 0; wc < rc; wc += wc1 ){
			wc1 = write(dst,buff+wc,rc-wc);
			if( wc1 <= 0 ){
				reason = "write-EOF";
				dstEOF = 1;
				goto EXIT;
			}
		}
		if( !ImCC && ngets )
			niced = doNice("FTPdata",src,dst,niced,xc,ngets,Start);
	}
	daemonlog("E",
	"FTP data-relay([%d]%xb -> [%d]%xb) %db / %d/ %4.2fs (%s)\n",
		src,sr,dst,ds,xc,ngets,Time(0)-Start, reason);

	if( !dstEOF )
		set_linger(dst,DELEGATE_LINGER);
EXIT:
	if( dst != odst ){
		close(dst);
		wait(0);
	}
	return xc;
}

static PORTrelay(Conn,STOR,dsock,ts,fs,tc,fc,port,modeXDC,cachefp,resp,rsize)
	Connection *Conn;
	FILE *ts,*fs,*tc,*fc;
	char *port;
	FILE *cachefp;
	char *resp;
{	int csock;
	int xc;

	if( modeXDC ){
		xc = XDCrelayServ(STOR,ts,fs,tc,fc,dsock,port,
			cachefp,resp,rsize);
		close(dsock);
	}else{
		csock = makeDataConn(port,ClientSock);
		if( STOR )
			xc = FTP_data_relay(Conn,csock,dsock,cachefp,STOR);
		else	xc = FTP_data_relay(Conn,dsock,csock,cachefp,STOR);
		close(csock);
		close(dsock);
		Verbose("Transfer complete (%d).\n",xc);
		get_resp(fs,tc,resp,rsize);
	}
	return xc;
}
static PASVrelay(Conn,STOR,svd,cld,cachefp)
	Connection *Conn;
	FILE *cachefp;
{	int xc;

	if( STOR )
		xc = FTP_data_relay(Conn,cld,svd,cachefp,STOR);
	else	xc = FTP_data_relay(Conn,svd,cld,cachefp,STOR);
	Verbose("PASVrelay(%d,%d): %d\n",svd,cld,xc);
	return xc;
}

static STATrelay(fs,tc)
	FILE *fs,*tc;
{	char code[8],resp[0x8000],*cresp,*dp;
	int size,len,ser,cont;

	fgetsFromST(resp,sizeof(resp),fs);
	if( resp[3] == '-' ){
		strncpy(code,resp,3);
		code[3] = ' ';

		size = sizeof(resp);
		for( ser = 1;; ser++ ){
			len = 0;
			cont = 0;
			for(;;){
				cresp = resp + len;
				if( fgetsFromST(cresp,size-len,fs) == NULL )
					break;
				if( strncmp(cresp,code,4) == 0 )
					break;
				len += strlen(cresp);
				if( (size-len) < 1024 ){
					cont = 1;
					break;
				}
			}
			if( tc != NULL )
				putMessage1(tc,ser,resp,len);
			if( !cont )
				break;
			cont = 0;
		}
	}
	if( tc != NULL )
		putMessage1(tc,ser,NULL,0);
}

#define SSEEK(str)	{str += strlen(str);}

static pollSC(what,timeout,fs,fc)
	char *what;
	FILE *fs,*fc;
{	FILE *fpv[2];
	int rds[2];
	int nready;

	fpv[0] = fs;
	fpv[1] = fc;
	/*
	 * "fs" and/or "fc" may be connected with pipe to external filter
	 * so PollIns should be replaced with ..?.. on Win32
	 */
	Verbose("%s: start PollIns=[%d,%d]\n",what,fileno(fs),fileno(fc));
	nready = fPollIns(timeout*1000,2,fpv,rds);
	if( nready <= 0 || rds[0] != 0 ){ /* timeout or server is ready */
		sv1log("%s: exit PollIns=%d[sv=%d,cl=%d] timeout=%d\n",
			what,nready,rds[0],rds[1],timeout);
		if( rds[0] == 0 ) /* timeout */
			write(fileno(fs),"QUIT\r\n",6);
		if( 0 < nready )
			return nready;
		else	return -1;
	}
	return nready;
}

extern FILE *creat_ftpcache();
extern FILE *fopen_ftpcache0();
#define STATCACHE ".-_-."

ftpc_dirext(path)
	char *path;
{
	if( strtailchr(path) != '/' )
		strcat(path,"/");
	sprintf(path+strlen(path),"%s/%s:%s:",STATCACHE,
		FTP_LIST_COM,FTP_LIST_OPT);
}
ftpc_ext(path,ext,xtype,com,opt,arg)
	char *path,*ext,*xtype,*com,*opt,*arg;
{	char *dp,name[1024];

	ext[0] = 0;
	if( strcaseeq(com,"CWD") || strcaseeq(com,"LOGIN") ){
		sprintf(ext,"/%s/%s:",STATCACHE,com);
	}else
	if( strcaseeq(com,"LIST") || strcaseeq(com,"NLST") ){
		if( arg[0] == 0 || streq(arg,".") )
			if( strtailchr(path) != '/' )
				strcat(path,"/");

		if( dp = strrchr(path,'/') ){
			strcpy(name,dp+1);
			dp[1] = 0;
		}else{
			strcpy(name,path);
			path[0] = 0;
		}
		sprintf(ext,"%s/%s:%s:%s",STATCACHE,com,opt,name);
	}else{
		if( xtype == NULL || xtype[0] == 0 )
			xtype = "A";
		if( xtype[0] != 'I' )
			sprintf(ext,"#[%c]",xtype[0]);
	}
}

static FILE *fopen_cache(create,Conn,FS,com,arg,path,cpath,xcpath)
	Connection *Conn;
	FtpStat *FS;
	char *com,*arg,*path,*cpath,*xcpath;
{	char *host = FS->fs_host;
	char *user = FS->fs_USER;
	int port = FS->fs_port;
	char opt[256],ext[256];
	FILE *cfp;
	int isdir,csize,cmtime;
	int exp;

	strcpy(path,FS->fs_CWD);
	opt[0] = 0;
	if( strcaseeq(com,"LIST") || strcaseeq(com,"NLST") ){
		isdir = 1;
		if( arg[0] == '-' )
			arg = wordscan(arg,opt);
	}else	isdir = -1;

	chdir_cwd(path,arg,1);
	ftpc_ext(path,ext,FS->fs_TYPE,com,opt,arg);

	if( create ){
		cfp = creat_ftpcache(user,host,port,path,ext,cpath,xcpath);
	}else{
		if( 0 < FS->fs_nocache )
			exp = 0;
		else	exp = ftp_EXPIRE(Conn);
		cfp = fopen_ftpcache0(Conn,exp,host,port,path,ext,cpath,
			&isdir,&csize,&cmtime);

		if( cfp == NULL && 0 <= csize && isdir < 0 ){
			char stat[1024],*line;
			char nmtimes[128],nname[128],snname[128];
			int nsize,nmtime;

			/* STAT or MDTM */
			fprintf(FS->fs_ts,"STAT /%s\r\n",path);
			fflush(FS->fs_ts);
			get_resp(FS->fs_fs,NULL,stat,sizeof(stat));
			line = strchr(stat,'\n') + 1;
			nsize = nmtime = 0;
			scan_ls_l(line,NULL,NULL,NULL,NULL,&nsize,
				nmtimes,nname,snname);
			nmtime = LsDateClock(nmtimes,time(0));

sv1log("######## size = %d <- %d, age = %d <- %d\n",
	nsize,csize, time(0)-nmtime,time(0)-cmtime);
/* touch and reuse the cache file if size and age is not changed ... */

		}
		xcpath = "";
	}
	sv1log("FTP-CACHE: %s [%s] = [%s][%s]:%x\n",com,arg,cpath,xcpath,cfp);
	return cfp;
}

static put_statcache(Conn,FS,com,arg,statresp)
	Connection *Conn;
	FtpStat *FS;
	char *com,*arg,*statresp;
{	FILE *cachefp;
	char path[1024],cpath[1024],xcpath[1024];

	cachefp = fopen_cache(1,Conn,FS,com,arg,path,cpath,xcpath);
	if( cachefp == NULL )
		return;
	fputs(statresp,cachefp);
	fflush(cachefp);
	cache_done(1,cachefp,cpath,xcpath);
}

static relay_data(FS,Conn,ts,fs,tc,fc,com,arg,err,resp,rsize)
	FtpStat *FS;
	Connection *Conn;
	FILE *ts,*fs,*tc,*fc;
	char *com,*arg,*resp;
{	int rcode = 0;	
	char *dport       = FS->fs_dport;
	int clientWithXDC = FS->fs_IamClientWithXDC;
	int modeXDC       = FS->fs_modeXDC;
	int dsvsock       = FS->fs_dsvsock;
	int psvsock       = FS->fs_psvsock;
	int pclsock       = FS->fs_pclsock;
	int PORTforPASV   = FS->fs_PORTforPASV;
	int PASVforPORT   = FS->fs_PASVforPORT;
	int ssock,csock,psock,dsock;
	int start,xc;
	char path[1024],cachepath[1024],xcachepath[1024];
	FILE *cachefp;
	int STOR = strcasecmp(com,"STOR") == 0;

	if( err ){
		sv1log("#### close data connection because of error.\n");
/*
DONT close the date socket to the server, the client (ex. Mozaic)
may expect to reuse already connected PORT and will not issue
another PORT for the next retreaval command.
Such conn. should be reused on next PORT command (and may be
closed at the end of a FTPCC session ?).

		if( 0 <= FS->fs_dsvsock ) close(FS->fs_dsvsock);
		if( 0 <= FS->fs_psvsock ) close(FS->fs_psvsock);
		FS->fs_dsvsock = FS->fs_psvsock = -1;
*/

/*
DONT close the socket to accept PASV connection by a client, the client
(e.x. Mozilla) may have connected it and may be going to reuse it
for the next retrieval command...
Such PASV conn. should be closed on the next PASV if it is not used...
(This may be done at setupPASV() by polling existing connection ...)
 
		if( 0 <= FS->fs_pclsock ) close(FS->fs_pclsock);
		FS->fs_pclsock = -1;
*/
		return 0;
	}

	xc = 0;
	start = time(0);
	cachefp = fopen_cache(1,Conn,FS,com,arg,path,cachepath,xcachepath);
	resp[0] = 0;

	if( clientWithXDC && modeXDC ){
		sv1log("-- XDC to XDC\n");
		get_resp(fs,NULL,resp,rsize);
		fputs(resp,tc);
		xc = cpyMessageF(fs,tc);
		get_resp(fs,NULL,resp,rsize);
		putPostStatus(tc,resp);
		fputs(resp,tc);
		fflush(tc);
	}else
	if( clientWithXDC && psvsock < 0 ){
		sv1log("-- XDC to PORT\n");
		xc = XDCrelayClnt(Conn,STOR,ts,fs,tc,fc,
			cachefp,resp,rsize);
	}else
	if( PASVforPORT && 0 <= psvsock && modeXDC ){
		sv1log("-- XDC to PASV\n");
		xc = XDCrelayServ(STOR,ts,fs,tc,fc,psvsock,dport,
			cachefp,resp,rsize);
	}else
	if( PORTforPASV && 0 <= dsvsock && 0 <= pclsock ){
		ssock = ACCEPT_SVPORT(dsvsock,0);
		Verbose("Start accept on port of PASV for client\n");
		csock = ACCEPTdc(pclsock,1);
		close(dsvsock);
		close(pclsock);
		Verbose("PORTforPASV: accept[%d][%d] data[%d][%d]\n",
			dsvsock,pclsock,ssock,csock);

		xc = PASVrelay(Conn,STOR,ssock,csock,cachefp);
		close(ssock);
		close(csock);
		get_resp(fs,tc,resp,rsize);
	}else
	if( 0 <= psvsock ){
		if( PASVforPORT ){
			psock = makeDataConn(dport,ClientSock);
			Verbose("PASVforPORT: [%d][%d]\n",psvsock,psock);
			PASVforPORT = 0;
		}else{
			Verbose("Start accept on PASV port\n");
			psock = ACCEPTdc(pclsock,1);
			close(pclsock);
		}
		if( 0 <= psock ){
			xc = PASVrelay(Conn,STOR,psvsock,psock,cachefp);
			close(psvsock);
			close(psock);
			get_resp(fs,tc,resp,rsize);
		}else{
			rcode = -1;
			close(psvsock);
		}
	}else{
		dsock = ACCEPT_SVPORT(dsvsock,0);
		close(dsvsock);
		if( dsock < 0 )
			Finish(1);

		xc = PORTrelay(Conn,STOR,dsock,ts,fs,tc,fc,dport,modeXDC,
			cachefp,resp,rsize);
	}
	FS->fs_dsvsock = FS->fs_psvsock = FS->fs_pclsock = -1;
	FS->fs_dport[0] = FS->fs_mport[0] = 0;

	if( cachefp ){
		int OK;

		fflush(cachefp);
		OK = atoi(resp) == 226 && file_size(fileno(cachefp)) == xc;
		cache_done(OK,cachefp,cachepath,xcachepath);
		sv1log("FTP-CACHE: written=%d %d bytes [%s]\n",OK,xc,cachepath);
	}
	if( FS->fs_cstat == NULL )
		FS->fs_cstat = "W";

	putXferlog(Conn,FS,com,arg,start,xc);
	return rcode;
}

putXferlog(Conn,FS,com,arg,start,xc,cstat)
	Connection *Conn;
	FtpStat *FS;
	char *com,*arg;
	char *cstat;
{	char clnt[256],url[2048],*auser,*dp;
	int bin,anon;
	int STOR = strcasecmp(com,"STOR") == 0;

	if( !strcaseeq(com,"RETR") && !strcaseeq(com,"STOR") )
		return;

	anon = FS->fs_anonymous;
	/*if( FS->fs_imProxy )*/
	{	char fpath[2048];

		fpath[0] = 0;
		if( FS->fs_CWD[0] ){
			if( FS->fs_CWD[0] != '/' )
				strcat(fpath,"/");
			strcat(fpath,FS->fs_CWD);
		}
		if( strtailchr(fpath) != '/' )
			strcat(fpath,"/");
		strcat(fpath,arg);

		if( FS->fs_islocal ){
			strcpy(url,fpath);
		}else
		if( strncmp(fpath,"//",2) == 0 ){
			strcpy(url,fpath);
		}else{
			if( strcmp(DST_PROTO,"ftp") != 0 )
				sprintf(url,"%s://",DST_PROTO);
			else	strcpy(url,"//");
			if( !anon )
				sprintf(url+strlen(url),"%s@",FS->fs_USER);
			strcat(url,DST_HOST);
			if( DST_PORT != 21 )
				sprintf(url+strlen(url),":%d",DST_PORT);
			strcat(url,fpath);
		}
	}
	/*else{
		if( FS->fs_CWD[0] )
			sprintf(url,"%s/%s",FS->fs_CWD,arg);
		else	strcpy(url,arg);
	}*/
	getClientHostPort(Conn,clnt);
	bin = FS->fs_TYPE[0] == 'I';

	if( FS->fs_auth == 0 ){
		FS->fs_auth = 1;
		getClientUserMbox(Conn,FS->fs_auser);
		if( dp = strchr(FS->fs_auser,'@') )
			*dp = 0;
	}
	if( FS->fs_auser[0] && strcmp(FS->fs_auser,"?") != 0 )
		auser = FS->fs_auser;
	else	auser = NULL;

	ftp_xferlog(start,clnt,xc,url,bin,STOR,
		anon,anon?FS->fs_PASS:FS->fs_USER,auser,
		FS->fs_cstat?FS->fs_cstat:"N");
}

static controlCWD(FS,tc,dir)
	FtpStat *FS;
	FILE *tc;
	char *dir;
{
	if( strcaseeq(dir,".") ){
		FS->fs_nocache = !FS->fs_nocache;
		fprintf(tc,"250 CACHE %s.\r\n",FS->fs_nocache?"disabled":"enabled");
		sv1log("RELOAD %d\n",FS->fs_nocache);
		fflush(tc);
		return 1;
	}
	/* if .control ... then enter control mode ??? */
	return 0;
}

datamsg(FS,msg,datafd,com,path)
	FtpStat *FS;
	char *msg;
	char *com,*path;
{	int fsize;
	char *what;
	char mode[32];

	if( FS->fs_TYPE[0] == 0 || FS->fs_TYPE[0] == 'A' )
		strcpy(mode,"ASCII");
	else	strcpy(mode,"BINARY");
	fsize = file_size(datafd);

	if( strcaseeq(com,"RETR") ){
		if( what = strrchr(path,'/') )
			what = what + 1;
		else	what = path;
	}else	what = com;

	sprintf(msg,
		"Opening %s mode data connection for %s (%d bytes).",
		mode,what,fsize);
}

static connect_data(where,FS,port,cntrlsock)
	char *where;
	FtpStat *FS;
	char *port;
{	int cdsock;

	cdsock = -1;
	if( FS->fs_dport[0] ){
		strcpy(port,FS->fs_dport);
		sv1log("%s: connecting to client's PORT %s\n",where,port);
		cdsock = makeDataConn(FS->fs_dport,cntrlsock);
		FS->fs_dport[0] = 0;
	}else
	if( 0 < FS->fs_pclsock ){
		strcpy(port,FS->fs_mport);
		sv1log("%s: accepting client's PASV %s\n",where,port);
		cdsock = ACCEPTdc(FS->fs_pclsock,1);
		close(FS->fs_pclsock);
		FS->fs_pclsock = -1;
	}
	return cdsock;
}
static lookaside_cache(Conn,FS,tc,com,arg)
	Connection *Conn;
	FtpStat *FS;
	FILE *tc;
	char *com,*arg;
{	char path[1024],cpath[1024],cdate[32];
	int found,start,xc;
	FILE *cfp;
	int cdsock;
	char port[128];
	char msg[256];
	int islocal;

	start = time(0);
	islocal = 0;

	if( strcaseeq(com,"LIST") || strcaseeq(com,"NLST") )
	if( cfp = localLIST(FS,tc,com,arg,path) ){
		strcpy(cpath,path);
		islocal = 1;
		goto OPENED;
	}
	if( strcaseeq(com,"RETR") )
	if( cfp = localRETR(FS,tc,com,arg,path) ){
		strcpy(cpath,path);
		islocal = 1;
		goto OPENED;
	}

	if( !FS->fs_anonymous )
		return 0;

	cfp = fopen_cache(0,Conn,FS,com,arg,path,cpath,NULL);
	if( cfp == NULL ){
		FS->fs_cstat = "N";
		return 0;
	}

OPENED:
	if( strcaseeq(com,"STOR") ){
		sv1log("FTP-CACHE: STOR remove the cache [%s]\n",cpath);
		unlink(cpath);
		/* unlink the directory */
		fclose(cfp);
		FS->fs_cstat = "W";
		return 0;
	}

	found = 0;
	cdsock = connect_data("FTP-CACHE",FS,port,Conn->cl_sock);

	if( 0 <= cdsock ){
		rsctime(file_mtime(fileno(cfp)),cdate);

		datamsg(FS,msg,fileno(cfp),com,path);
		fprintf(tc,"150- %s\r\n",msg);
		fprintf(tc,"150  DeleGate Port(%s) Cached(%s)\r\n",
			port,cdate);

		fflush(tc);
		xc = FTP_data_relay(Conn,fileno(cfp),cdsock,NULL,0);
		close(cdsock);

		fprintf(tc,"226 Transfer complete (%d bytes).\r\n",xc);
		fflush(tc);

		if( islocal )
			FS->fs_cstat = "L";
		else	FS->fs_cstat = "H";
		putXferlog(Conn,FS,com,arg,start,xc);
		found = 1;
		sv1log("FTP-CACHE HIT: [%d] %s\n",fileno(cfp),cpath);
	}else	FS->fs_cstat = "N";
		

	fclose(cfp);
	return found;
}

/*
 *	setup data connection to the server
 */
static setWithPASV(FS)
	FtpStat *FS;
{
	if( FS->fs_serverWithPASV == 0 ){
		if( 0 <= FS->fs_psvsock ){
			FS->fs_serverWithPASV = 1;
			sv1log("-- with PASV\n");
		}else{
			FS->fs_serverWithPASV = -1;
			sv1log("-- without PASV\n");
		}
	}
}
static setupPASV(Conn,FS,ts,fs,tc,arg)
	Connection *Conn;
	FtpStat *FS;
	FILE *ts,*fs,*tc;
	char *arg;
{	char resp[2048];
	char *mport = FS->fs_mport;

	if( FS->fs_pclsock < 0 ){
		if( Conn->xf_filters & XF_CLIENT )
		if( ToC != ClientSock )
		sv1log("## viaCFI: ToC=%d ClientSock=%d\n",ToC,ClientSock);
		FS->fs_pclsock =
		mkserv_sock_ftp(mport,FS->fs_myhost,FS->fs_myport,ClientSock,1);
	}else
	if( tc == NULL )
		;/* inheriting from unbound mode proxy */
	else
	while( 0 < PollIn(FS->fs_pclsock,1) ){
		int psock;
		if( (psock = ACCEPT(FS->fs_pclsock,0,-1,1)) < 0 )
			break;
		sv1log("## discard previous (unused) PASV sock: %d -> %d\n",
			FS->fs_pclsock,psock);
		close(psock);
	}

	if( FS->fs_pclsock < 0 ){
		sprintf(resp,"500 Can't create Passive Mode socket.\r\n");
	}else
	if( ts == NULL ){
		sprintf(resp,"227 Entering Passive Mode/DeleGate[X] (%s).\r\n",
			mport);
	}else
	if( 0 <= FS->fs_psvsock || 0 <= FS->fs_dsvsock ){
		sprintf(resp,"227 Entering Passive Mode/DeleGate[A] (%s).\r\n",
			mport);
	}else
	if( 0 <= FS->fs_serverWithPASV
	 && 0 <= (FS->fs_psvsock = mkdsockPASV(Conn,ts,fs,resp,sizeof(resp))) ){
		setWithPASV(FS);
		sprintf(resp,"227 Entering Passive Mode/DeleGate[B] (%s).\r\n",
			mport);
	}else
	if( 0 <= (FS->fs_dsvsock = mkdsockPORT(Conn,DFLT_HOST,ts,fs)) ){
		FS->fs_PORTforPASV = 1;
		sprintf(resp,"227 Entering Passive Mode/DeleGate[C] (%s).\r\n",
			mport);
	}else{
		sprintf(resp,"500 PASV failed.\r\n");
	}
	if( tc != NULL ){
		fputs(resp,tc);
		fflush(tc);
	}
	sv1log("PASV [%s] >> %s",mport,resp);
	if( atoi(resp) == 227 )
		return 0;
	else	return EOF;
}
static setupPORT(Conn,FS,ts,fs,tc,arg)
	Connection *Conn;
	FtpStat *FS;
	FILE *ts,*fs,*tc;
	char *arg;
{	char resp[2048];

	wordscan(arg,FS->fs_dport);

	if( FS->fs_IamClientWithXDC ){
		put_serv(MODE(FS),ts,"PORT %s\r\n",arg);
		get_resp(fs,NULL,resp,sizeof(resp));
	}else
	if( ts == NULL ){
		sv1log("#### 200 PORT command successful [delaying].\r\n");
		sprintf(resp,"200 PORT command successful [delaying].\r\n");
	}else
	if( 0 <= FS->fs_psvsock || 0 <= FS->fs_dsvsock ){
		sv1log("#### DSV[%d] PSV[%d]\n",FS->fs_dsvsock,FS->fs_psvsock);
		sprintf(resp,"200 PORT command successful [reusing].\r\n");
	}else
	if( 0 <= FS->fs_serverWithPASV
	 && 0 <= (FS->fs_psvsock = mkdsockPASV(Conn,ts,fs,resp,sizeof(resp))) ){
		setWithPASV(FS);
		FS->fs_PASVforPORT = 1;
		sprintf(resp,"200 PORT command successful [%s].\r\n",
			"translated to PASV by DeleGate");
	}else
	if( 0 <= (FS->fs_dsvsock = mkdsockPORT(Conn,DFLT_HOST,ts,NULL)) ){
		get_resp(fs,NULL,resp,sizeof(resp));
	}else{
		sprintf(resp,"500 PORT failed.\r\n");
	}
	if( tc != NULL ){
		fputs(resp,tc);
		fflush(tc);
	}
	sv1log("PORT [%s] >> %s",FS->fs_dport,resp);
	if( atoi(resp) == 200 )
		return 0;
	else	return EOF;
}

static proxyLogin(Conn,FS,PFC,xuser,resp,rsize,ts,fs)
	Connection *Conn;
	FtpStat *FS;
	FtpConn *PFC;
	char *xuser,*resp;
	FILE *ts,*fs;
{	char *RESP;

	Verbose("proxyLogin(%s,%s,%s,%s)\n",
		PFC->fc_user,PFC->fc_pass,PFC->fc_path,PFC->fc_type);

	RESP = resp;
	if(PFC->fc_user[0]){
		SSEEK(RESP);
		if( xuser[0] == 0 )
			xuser = PFC->fc_user;

		_put_get(MODE(FS),ts,fs,RESP,rsize,
			"USER %s\r\n",xuser);
		if( atoi(RESP) == 530 )
			addRejectList(Conn,"USER","","",PFC->fc_user,PFC->fc_pass,RESP);
		if( *RESP == '5' || *RESP == '4' )
			goto ERROR;
		strcpy(FS->fs_USER,PFC->fc_user);
		FS->fs_anonymous = is_anonymous(FS->fs_USER);
		FS->fs_rcUSER = strdup(RESP);
	}
	if(PFC->fc_pass[0]){
		SSEEK(RESP);
		if( FS->fs_anonymous && anonPASS(NULL,PFC->fc_user,PFC->fc_pass)!=0 )
			sprintf(RESP,"530 Invalid/Forbidden <%s>\r\n",PFC->fc_pass);
		else
		_put_get(MODE(FS),ts,fs,RESP,rsize,
			"PASS %s\r\n",PFC->fc_pass);
		if( atoi(RESP) == 530 )
			addRejectList(Conn,"PASS","","",PFC->fc_user,PFC->fc_pass,RESP);
		if( *RESP == '5' || *RESP == '4' )
			goto ERROR;
		strcpy(FS->fs_PASS,PFC->fc_pass);
		FS->fs_rcPASS = strdup(RESP);
	}
	if(PFC->fc_type[0]){
		SSEEK(RESP);
		_put_get(MODE(FS),ts,fs,RESP,rsize,
			"TYPE %s\r\n",PFC->fc_type);
		if( *RESP == '5' || *RESP == '4' )
			goto ERROR;
		strcpy(FS->fs_TYPE,PFC->fc_type);
	}

if(PFC->fc_pass[0])
	setLoginPWD(FS,ts,fs);
	return 0;
ERROR:
	return -1;
}

static setConnTimeout(Conn)
	Connection *Conn;
{	int timeout;

	if( ConnDelay == 0 )
		return;

	timeout = 1 + (ConnDelay * 10);
	if( timeout < CON_TIMEOUT ){
/*
		daemonlog("D",
		"Estimated FTP data connetion timeout = (1+10*%4.2f) %d < %d\n",
			ConnDelay,timeout,CON_TIMEOUT);
*/
		CON_TIMEOUT_DATA = timeout;
	}else	CON_TIMEOUT_DATA = CON_TIMEOUT;
}

static isMounted(FS)
	FtpStat *FS;
{	char vpath[1024];

	return getVUpath(FS,FS->fs_CWD,vpath) != NULL;
}
static presetLogin(FS,user,pass,path)
	FtpStat *FS;
	char *user,*pass,*path;
{	char vurl[1024];

	if( getVUpath(FS,FS->fs_CWD,vurl) )
		return preset_login("GET",vurl,user,pass,path);
	else	return 0;
}
static dontREINitialize(FS)
	FtpStat *FS;
{
	if( presetLogin(FS,NULL,NULL,NULL) )
		return 1;
	return 0;
}

service_ftp(Conn)
	Connection *Conn;
{	FtpStat FSbuf,*FS = &FSbuf;
	int mounted;

	init_FS(FS);
	FS->fs_Conn = Conn;
	mounted = Mounted();
	return service_ftp1(Conn,FS,mounted);
}
chdirHOME(FS,ts,fs,resp,rsize)
	FtpStat *FS;
	FILE *ts,*fs;
	char *resp;
{
	put_get(ts,fs,resp,rsize,"CWD %s\r\n",FS->fs_logindir);
	chdir_cwd(FS->fs_CWD,FS->fs_logindir,1);
}

service_ftp1(Conn,FS,mounted)
	Connection *Conn;
	FtpStat *FS;
{	FILE *tc,*fc,*ts,*fs;
	char req[1024],com[1024],arg[1024],*dp;
	char resp[0x8000],*swcom;
	int rcode,scode;
	char cserv[128],ctype[32],cuser[128],cpass[128];
	char cpath[1024];
	int nUSER = 0,nPASS = 0;
	char pwd[1024];
	char xuser[128],xserv[128];
	void (*sigpipe)();
	int server_eof = 0;
	char reqQs[16][256];
	int reqQn = 0, reqQi;
	int noSTOR;
	int enable_mount;
	int login_done = 0;

	sv1log("FTP server ftp://%s:%d/%s\n",DFLT_HOST,DFLT_PORT,D_SELECTOR);
	if( isMYSELF(DFLT_HOST) ){
		proxyFTP(Conn);
		return -1;
	}
	/* PFS is necessary to inherit established PASV/PORT environment
	 * to a switched (MOUNTed) server ...
	 */
	if( PFS == NULL )
		PFS = FS;

	D_FTPHOPS++;
	sv1log("FTPHOPS: %d [%d/%d - %d/%d]\n",D_FTPHOPS,ToC,FromC,ToS,FromS);

	if( ToS <= 0 || FromS <= 0 )
		connect_to_serv(Conn,FromC,ToC,0);
	setConnTimeout(Conn);

	if( ToS < 0 || FromS < 0 ){
		if( PFC )
			scode = PFC->fc_ERRcode;
		else	scode = 421;
		sprintf(resp,"%d ;-< Proxy failed to connect with `%s'\r\n",
			scode,DST_HOST);
		write(ToC,resp,strlen(resp));
		sv1log("cannot connect `%s'\n",DST_HOST);
		return -1;
	}

	if( toMaster && D_FTPHOPS != 1 ){
		/*if( sockHostport(ToS,0) == peerHostport(ToS,0) )*/
		{
			sv1log("FTP simple relay.\n");
			relay_svcl(Conn,FromC,ToC,FromS,ToS,1,512);
			return -1;
		}
	}

	strcpy(FS->fs_host,DST_HOST);
	FS->fs_port = DST_PORT;

	if( PFC == NULL && presetLogin(FS,cuser,cpass,cpath) ){
		char server[1024];
		sprintf(server,"%s:%s@%s:%d/%s",cuser,cpass,
			DST_HOST,DST_PORT,cpath);
		tc = fdopen(ToC,"w");
		return change_server(Conn,tc,"OPEN",server,cuser,cpass,"");
	}

	/*
	 * Disable MOUNTing if it's generated by SERVER=ftp://Server/
	 * (as MOUNT="/* ftp://Server/*") and the current server is not Server.
	 * User's "CWD /path" should be intended to be local to the current
	 * server ftp://server/path, not to switch to another server
	 * ftp://Server/path.
	 */
	if( enable_mount = mounted )
	if( !isMYSELF(iSERVER_HOST) )
	if( !streq(iSERVER_HOST,FS->fs_host) || iSERVER_PORT != FS->fs_port )
	/*
	 * Maybe this disabling is intended for *interactive* human user
	 * who knows each MOUNTed server as an origin server.
	 * - if the (current) ftp-server is not in MOUNT list
	 * - (when the user changed server explicitly with "CWD //ftp-server")
	 */
	if( !isMounted(FS) ){
		sv1log("MOUNT is disabled in NON-MOUNTed server [%s:%d]\n",
			FS->fs_host,FS->fs_port);
		enable_mount = 0;
	}

	if( PFC ){
		tc = fdopen(dup(ToC),"w");
		fc = fdopen(dup(FromC),"r");
	}else{
		tc = fdopen(ToC,"w");
		fc = fdopen(FromC,"r");
	}

	if( FS->fs_IAMCC ){
		fs = FS->fs_fs;
		ts = FS->fs_ts;
	}else{
		fs = fdopen(FromS,"r");
		ts = fdopen(ToS,"w");
		FS->fs_ts = ts;
		FS->fs_fs = fs;
	}

	sigpipe = Vsignal(SIGPIPE,sigPIPE);
	ftp_env_name = "service_ftp";
	if( setjmp(ftp_env) != 0 ){
		sv1log("## service_ftp: error return from setjmp.\n");
		Vsignal(SIGPIPE,sigpipe);
		goto SERVER_EOF;
	}

	if( FS->fs_IAMCC ){
		strcpy(resp,FS->fs_opening);
		rcode = atoi(resp);
	}else{
		rcode = get_resp(fs,NULL,resp,sizeof(resp));
		/* some server respond in local char-code with 8bits,
	 	   which breaks some client like Mosaic... */
		for( dp = resp; *dp; dp++  )
			if( *dp & 0x80 )
				*dp = ' ';

		FS->fs_opening = strdup(resp);
	}

	scode = atoi(resp);
	if( scode == 421 )
		rcode = EOF;

	if( PFC ){
		if( scode == 220 )
			scode = PFC->fc_SUCcode;
		else	scode = PFC->fc_ERRcode;
	}
	if( rcode == EOF ){
		if( PFC )
			swcom = PFC->fc_swcom;
		else	swcom = "opening";
		sv1log("closed from the server [%s] %s",
			swcom,resp[0]?resp:"\n");
		fprintf(tc,"%d- %s for %s.\r\n",scode,swcom,DST_HOST);
		escape_scode(resp,tc);
		fprintf(tc,"%d ;-< proxy connection to `%s' rejected.\r\n",
			scode,DST_HOST);
		goto SERVER_EOF;
	}

	FS->fs_serverWithXDC = strstr(resp,XDC_OPENING) != 0;

	FS->fs_myport = ClientIF_name(Conn,FromC,FS->fs_myhost);

	cserv[0] = cuser[0] = cpass[0] = ctype[0] = 0;

	xuser[0] = xserv[0] = 0;
	if( toProxy ){
		char hostport[256];

		if( DST_PORT == 21 )
			strcpy(hostport,DST_HOST);
		else	sprintf(hostport,"%s:%d",DST_HOST,DST_PORT);

		if( PFC == 0 ){
			strcpy(xserv,hostport);
			sv1log("#### to FTP-Proxy THRU [%s]\n",xserv);
		}else{
			if( PFC->fc_user[0] )
				strcpy(xuser,PFC->fc_user);
			else	strcpy(xuser,"anonymous");
			sprintf(xuser+strlen(xuser),"@%s",hostport);
			sv1log("#### to FTP-Proxy [%s]\n",xuser);
		}
	}
	if( PFC ){
		char *RESP;
		char *retrresp = NULL;

		FS->fs_imProxy = 1;
		if( proxyLogin(Conn,FS,PFC,xuser,resp,sizeof(resp),ts,fs) < 0 ){
			if( PFS ){
				PFC->fc_ERRcode = 530;

				/* just to be copied back in save_FS() ... */
				FS->fs_pclsock = PFS->fs_pclsock;
				strcpy(FS->fs_dport,PFS->fs_dport);
			}
			goto PROXY_ERROR;
		}
		if( PFC->fc_pass[0] )
			login_done = 1;

		if( PFS && 0 <= PFS->fs_pclsock ){
			FS->fs_pclsock = PFS->fs_pclsock;
			PFS->fs_pclsock = -1;
			if( setupPASV(Conn,FS,ts,fs,NULL,"") == EOF ){
				fprintf(tc,"500 PASV failed.\r\n");
				goto PROXY_ERROR;
			}
		}else
		if( PFS && PFS->fs_dport[0] ){
			if( setupPORT(Conn,FS,ts,fs,NULL,PFS->fs_dport)==EOF ){
				fprintf(tc,"500 PORT failed.\r\n");
				goto PROXY_ERROR;
			}
			PFS->fs_dport[0] = 0;
		}

		if( PFS ){
			FS->fs_modeXDC = PFS->fs_modeXDC;
		}

		RESP = resp + strlen(resp);
		if( PATHCOMS(PFC->fc_swcom) ){
			_put_get(MODE(FS),ts,fs,RESP,sizeof(resp),"%s %s\r\n",
				PFC->fc_swcom,PFC->fc_path);
			/*
			if( *RESP == '5' || *RESP == '4' )
			if( RETRCOMS(PFC->fc_swcom) )
				goto PROXY_ERROR;
			*/
			retrresp = strdup(RESP);
		}else
		if( PFC->fc_path[0] ){
			_put_get(MODE(FS),ts,fs,RESP,sizeof(resp),
				"CWD %s\r\n",PFC->fc_path);
			if( *RESP == '5' || *RESP == '4' )
				goto PROXY_ERROR;
			chdir_cwd(FS->fs_CWD,PFC->fc_path,1);
		}

		strcpy(cuser,PFC->fc_user);
		strcpy(cpass,PFC->fc_pass);
		strcpy(ctype,PFC->fc_type);
		
		arg[0] = 0;
		if( dp = strstr(resp,"\n331") )
			linescan(dp+1,arg,sizeof(arg));

		if( strcasestr(arg," otp-") != NULL ){
			fprintf(tc,"%s\r\n",arg);
		}else
		if( comeq(PFC->fc_swcom,"RETR")
		 || comeq(PFC->fc_swcom,"SIZE")
		 || comeq(PFC->fc_swcom,"MDTM")
		){
			/* thru "150 Opening .... path (DDDD bytes)"
			 * MOUNTed path name should be rewriten ...
			 */
			fputs(retrresp,tc);
		}else{
			fprintf(tc,"%d-- %s for %s@%s.\r\n",scode,
				PFC->fc_swcom,PFC->fc_user,DST_HOST);
			escape_scode(resp,tc);
/*
fprintf(tc,"%s %s\r\n",XDC_OPENING,FS->fs_myhost);
*/
			fprintf(tc,"%d--  @ @  \r\n",scode);
			fprintf(tc,"%d  \\( - )/ -- { %s `%s' %s}\r\n",
				scode, "connected to",
				DST_HOST,toProxy?"(via FTP-Proxy) ":"");
		}

		if( RETRCOMS(PFC->fc_swcom) )
		if( *retrresp != '5' && *retrresp != '4' ){
			fflush(tc);
			if( relay_data(FS,Conn,ts,
				fs,tc,fc,PFC->fc_swcom,PFC->fc_path,0,
				resp,sizeof(resp)) < 0 )
					goto PROXY_ERROR;
		}
		if( retrresp )
			free(retrresp);
	}else{
		Verbose("D_FTPHOPS (%d) %s\n",D_FTPHOPS,FS->fs_myhost);
		fprintf(tc,"%s[PIPELINE] (%d) %s\r\n",
			XDC_OPENING,D_FTPHOPS,FS->fs_myhost);
		escape_scode(resp,tc);
		fprintf(tc,"%d \r\n",220);
	}
	fflush(tc);

	if( !FS->fs_IAMCC )
	if( !localsocket(ServSock(Conn,ts,"INIT")) && getenv("NOXDC") == 0 )
	if( FS->fs_serverWithXDC ){
		if( D_FTPHOPS == 1 ){
			put_serv(MODE(FS),ts,"MODE XDC\r\n");
			if( get_resp(fs,NULL,resp,sizeof(resp)) != EOF ){
				FS->fs_IamClientWithXDC = 1;
				sv1log("--- I'm clientWithXDC\n");
			}
		}
	}

	noSTOR = permitted_readonly(Conn,DST_PROTO);

	for(;;){

		FS->fs_cstat = NULL;

		if( reqQn != 0 && reqQi == reqQn )
			reqQi = reqQn = 0;

		if( reqQn != 0 && reqQi < reqQn ){ /* dequeue */
			strcpy(req,reqQs[reqQi++]);
			Verbose("[%d/%d] %s",reqQi,reqQn,req);
		}else{
			if( feof(ts) || feof(fs) )
				goto SERVER_EOF;

			if( pollSC("service_ftp",FTP_FROMCLNT_TIMEOUT,fs,fc) <= 0 )
			{
				Conn->co_error |= CO_TIMEOUT;
				goto SERVER_EOF;
			}

			if( fgetsTimeout(req,sizeof(req),fc,1) == NULL )
				goto EXIT;
		}

		dp = wordscan(req,com);
		linescan(dp,arg,sizeof(arg));

		if( strcaseeq(com,"USER") )
			if( unescape_user_at_host(arg) )
				sprintf(req,"%s %s\r\n",com,arg);

		/* pipelining should be implicit rathar than explicit
		 * with explicit PIPELINE command ...
		 */
		if( strcaseeq(com,"PIPELINE") ){
			reqQn = 0;
			for( reqQi = 0; ; reqQi++ ){
				if( fgets(req,sizeof(req),fc) == NULL )
					goto SERVER_EOF;
				if( req[0] == '.' && (req[1] == '\r' || req[1] == '\n') )
					break;

				strcpy(reqQs[reqQn++],req);
				if( !FS->fs_IAMCC || strncasecmp(req,"PWD",3) == 0 )
					fputs(req,ts);
			}
			fflush(ts);
			reqQi = 0;
			sv1log("PIPELINE: %d\n",reqQn);
			continue;
		}

		incRequestSerno(Conn);
		ProcTitle(Conn,"ftp://%s/",DST_HOST);

		if( PFC == NULL )
		if( strcasecmp(com,"QUIT") == 0 ){
 			fprintf(tc,"221 Goodbye.\r\n");
			fflush(tc);
			goto EXIT;
		}
		if( strcasecmp(com,"QUIT") == 0 )
			Conn->co_error |= CO_CLOSED;

		if( strcasecmp(com,"PASS") == 0 )
			Verbose("#### PASS ******\n");
		else	Verbose("#### %s",req);

		if( strcaseeq(com,"CWD") && controlCWD(FS,tc,arg) )
			continue;

		if( strcaseeq(com,"CWD") || strcaseeq(com,"PWD") || login_done )
			if( FS->fs_logindir[0] == 0 )
				if( reqQn == 0 )
					setLoginPWD(FS,ts,fs);

		if( !ImMaster /* && it's not for me (as a FTP server) */ )
		if( !toProxy )
		if( enable_mount ){
			if( strcaseeq(com,"CDUP") ){
				strcpy(com,"CWD");
				strcpy(arg,"..");
				sprintf(req,"%s %s\r\n",com,arg);
			}
			if( strcasecmp(com,"CWD") == 0 )
				if( rewrite_CWD(FS,req,arg,tc) )
					continue;

			if( strcasecmp(com,"PWD") == 0 )
				if( rewrite_PWD(FS,req,arg,tc) )
					continue;
		}

		if( noSTOR && comeq(com,"STOR") ){
			fprintf(tc,"553 Permission denied by DeleGate.\r\n");
			fflush(tc);
			continue;
		}

		pwd[0] = 0;
		if( strcaseeq(com,"CWD") && remote_path(arg) ){
			char host[128],*path;
			int port;

			host[0] = 0;
			port = decomp_site("ftp",arg+2,NULL,NULL,host,NULL);

			/* "CWD //host/path" is performed with the sequence
			 * of "CWD logindir";"CWD path" to make the CWD
			 * without the knowledge about the path name
			 * delimiter in the FTP server.
			 */
			if( streq(host,FS->fs_host) && port == FS->fs_port ){
				strcpy(pwd,FS->fs_CWD);
				chdirHOME(FS,ts,fs,resp,sizeof(resp));
				path = strchr(arg+2,'/');

				/* allow absolute /path name under the current
				 * working directory at the target server
				 * even if the /path is MOUNTed ... (why?)
				 */
				if( path != NULL ){
					char *ldir = FS->fs_logindir;
					int len;
					len = strlen(ldir);
					if( strncmp(path,ldir,len) == 0 )
					{
					sv1log("[%s] thru. CWD %s\n",ldir,path);
						strcpy(path,path+len);
					}
				}

				if( path == NULL || path[0] == 0 || strcmp(path,"/") == 0 ){
					fputs(resp,tc);
					fflush(tc);
					continue;
				}
				if( path[0] == '/' )
					strcpy(arg,path+1);
				else	strcpy(arg,path);
				sprintf(req,"%s %s\r\n",com,arg);
			}else{
				strcpy(cserv,arg+2);
				if( check_server(cserv,com,tc) == 0 )
					goto SWSERV;
				else	continue;
			}
		}else
		if( strcasecmp(com,"USER") == 0 && strchr(req,'@') ){
			strcpy(cserv,req+5);
			if( check_server(cserv,com,tc) == 0 )
				goto SWSERV;
			else	continue;
		}else
		if( strcasecmp(com,"USER") == 0 && xserv[0] ){
			sprintf(cserv,"%s@%s",arg,xserv);
			if( check_server(cserv,com,tc) == 0 )
			{
				if( toProxy ){
					sprintf(arg+strlen(arg),"@%s",xserv);
					sprintf(req,"%s %s\r\n",com,arg);
				}else
				goto SWSERV;
			}
			else	continue;
		}else
		if( strncasecmp(req,"MODE ",5) == 0 ){
			if( strncasecmp(req,"MODE XDC",8) == 0 ){
				fputs("200 MODE XDC ok.\r\n",tc);
				fflush(tc);
				FS->fs_modeXDC = 1;
				continue;
			}else	FS->fs_modeXDC = 0;
		}else
		if( strncasecmp(req,"USER ",5) == 0 ){
			if( strcaseeq(req,"USER anonymous\r\n")
			 || strcaseeq(req,"USER ftp\r\n") )
				FS->fs_anonymous = 1;
			else	FS->fs_anonymous = 0;
			wordscan(req+5,cuser);
		}else
		if( strncasecmp(req,"PASS ",5) == 0 ){
			sscanf(req+5,"%[^\r\n]",cpass);
			if( FS->fs_anonymous ){
				if( anonPASS(tc,cuser,cpass) != 0 ){
					cpass[0] = 0;
					continue;
				}
				/* cpass may be rewriten to canonical form */
		  		strcpy(arg,cpass);
				sprintf(req+5,"%s\r\n",arg);
			}
		}else
		if( strncasecmp(req,"TYPE ",5) == 0 )
			wordscan(req+5,ctype);

		/*
		 *	catch commands which use data connection
		 */

		if( PATHCOMS(com) ){
			if( enable_mount || remote_path(arg) ){
				char host[128],path[1024];
				int port;

				if( isRemote(FS,com,arg,host,&port,path) ){
					HostPort(cserv,"ftp",host,port);
					sprintf(cserv+strlen(cserv),"/%s",path);
					goto SWSERV;
				}
				/* arg may be rewriten by MOUNT */
				if( *arg )
					sprintf(req,"%s %s\r\n",com,arg);
				else	sprintf(req,"%s\r\n",com);
			}

			if( RETRCOMS(com) )
			if( lookaside_cache(Conn,FS,tc,com,arg) )
				continue;
		}

		if( strcaseeq(com,"PASV") ){
			setupPASV(Conn,FS,ts,fs,tc,arg);
			continue;
		}
		if( strcaseeq(com,"PORT") ){
			setupPORT(Conn,FS,ts,fs,tc,arg);
			continue;
		}

		if( comeq(com,"USER") || comeq(com,"PASS") )
		if( dontREINitialize(FS) ){
			if( comeq(com,"USER") ) nUSER++;
			if( comeq(com,"PASS") ) nPASS++;
			if( 1 < nUSER || 1 < nPASS )
				fprintf(tc,"530 Already logged in.\r\n");
			else	fprintf(tc,"230 Already logged in.\r\n");
			fflush(tc);
			continue;
		}

		if( FS->fs_IAMCC ){
			if( comeq(com,"USER") ){
				if( strcmp(arg,FS->fs_USER) != 0 ){
					strcpy(cserv,DST_HOST);
					strcpy(cuser,arg);
					cpass[0] = 0;
					ctype[0] = 0;
					goto SWSERV;
				}
				if( FS->fs_rcUSER && streq(FS->fs_USER,arg) )
					fputs(FS->fs_rcUSER,tc);
				else
				fprintf(tc,"331 Password required for %s.\r\n",arg);
				fflush(tc);
				continue;
			}
			if( comeq(com,"PASS") ){
				if( FS->fs_rcPASS && streq(FS->fs_PASS,arg) )
					fputs(FS->fs_rcPASS,tc);
				else
				fprintf(tc,"230 User %s logged in.\r\n",cuser);
				fflush(tc);
				login_done = 1;
				continue;
			}
			if( comeq(com,"SYST") && arg[0] == 0 && FS->fs_rcSYST[0] ){
				fputs(FS->fs_rcSYST,tc);
				fflush(tc);
				continue;
			}
			if( comeq(com,"TYPE") && comeq(arg,FS->fs_qcTYPE) && FS->fs_rcTYPE[0] ){
				fputs(FS->fs_rcTYPE,tc);
				fflush(tc);
				continue;
			}
		}

		if( reqQn == 0 )
			put_serv(MODE(FS),ts,"%s",req);

		if( feof(ts) ){
			sprintf(resp,"421 server closed ;-<\r\n");
			rcode = EOF;
			fputs(resp,tc);
			fflush(tc);
		}else	rcode = get_resp(fs,tc,resp,sizeof(resp));

		if( rcode != EOF ){
			if( strcaseeq(com,"PWD") ){
				if( FS->fs_logindir[0] == 0 )
					setLoginPWD0(FS,resp);
			}else
			if( strcasecmp(com,"USER") == 0 ){
				strcpy(FS->fs_USER,arg);
				FS->fs_rcUSER = strdup(resp);
			}else
			if( strcasecmp(com,"PASS") == 0 ){
				strcpy(FS->fs_PASS,arg);
				FS->fs_rcPASS = strdup(resp);
				login_done = 1;
			}else
			if( strcasecmp(com,"TYPE") == 0 ){
				strcpy(FS->fs_TYPE,arg);
			}else
			if( strcasecmp(com,"CWD")  == 0 ){
				chdir_cwd(FS->fs_CWD,arg,1);
				/*put_statcache(Conn,FS,"CWD","",resp);*/
			}else
			if( strcaseeq(com,"CDUP") ){
				chdir_cwd(FS->fs_CWD,"..",1);
			}
		}
		if( rcode == EOF ){
		  if( comeq(com,"USER") ){
			addRejectList(Conn,"USER","","",arg,"",resp);
			login_done = 0;
		  }else
		  if( comeq(com,"PASS") ){
			addRejectList(Conn,"PASS","","",FS->fs_USER,arg,resp);
			login_done = 0;
		  }else
		  if( strcaseeq(com,"CWD") && pwd[0] ){
			if( put_get(ts,fs,resp,sizeof(resp),"CWD %s\r\n",pwd) != EOF )
				strcpy(FS->fs_CWD,pwd);
		  }
		}

		if( RETRCOMS(com) ){
		    if( enable_mount ){ /* remove `-> symlink' in LIST */ }

		    if( relay_data(FS,Conn,ts,fs,tc,fc,com,arg,rcode==EOF,
				resp,sizeof(resp)) < 0 )
			goto SERVER_EOF;
		}

		if( comeq(com,"SYST") && arg[0] == 0 )
			strcpy(FS->fs_rcSYST,resp);
		else
		if( resp[0] == '2' ){
			if( comeq(com,"TYPE") ){
				strcpy(FS->fs_qcTYPE,arg);
				strcpy(FS->fs_rcTYPE,resp);
			}
		}
		if( strncasecmp(resp,"221",3) == 0 ) /* Goodbye */
			goto SERVER_EOF;
	}

SERVER_EOF:
	server_eof = 1;
EXIT:
	fflush(tc); set_linger(fileno(tc),DELEGATE_LINGER); fclose(tc);
	fclose(fc);
	D_FTPHOPS--;

	if( !login_done ){
	}else
	if( server_eof ){
		Verbose("NO FTPCC(0) server-EOF PFC=%x\n",PFC);
	}else
	if( BORN_SPECIALIST && ( getVUpath(FS,FS->fs_CWD,pwd) != NULL
	 || hostcmp(iSERVER_HOST,FS->fs_host)==0 && iSERVER_PORT==FS->fs_port
	) ){
		/* current server is the one specified in SERVER=ftp://server
 		 * and/or MOUNT="/path... ftp://server"
		 * Maybe it's a ``local'' or ``domestic'' ftp server to
		 * which FTPCC is not necessary (maybe not desireble)...
		 */
		Verbose("NO FTPCC(1)\n");
	}else
	if( PFC != NULL ){
		Verbose("NO FTPCC(2)\n");
		/* Then client socket may be dup()ed in calling functions.
		 * Those should be closed to finish the connection and
		 * become a server for other clients...
		.*/
	}else
	{
		if( put_get(ts,fs,resp,sizeof(resp),"NOOP\r\n") == EOF )
			goto nocc;

		if( FS->fs_IAMCC )
			return 0;
		if( FS->fs_anonymous ){
			extern int ftpcc();
			extern int CC_TIMEOUT_FTP;

			FS->fs_IAMCC = 1;
			if( cuser[0] ) strcpy(FS->fs_USER,cuser);
			if( PFC ){
				close(ToC);
				close(FromC);
			}
			beBoundProxy(Conn,"anonymous",CC_TIMEOUT_FTP,
				ftpcc,FS,fs,ts,mounted);
		}
	}
nocc:
	FS->fs_IAMCC = 0;
	fclose(ts);
	fclose(fs);
	Vsignal(SIGPIPE,sigpipe);
	ftp_env_name = "FTP_EXIT";
	return 0;

PROXY_ERROR:
	if( PFC )
		scode = PFC->fc_ERRcode;
	else	scode = 500;
	fprintf(tc,"%d-- %s for %s.\r\n",scode,PFC->fc_swcom,DST_HOST);
	escape_scode(resp,tc);
	fprintf(tc,"%d ;-<\r\n",scode);
	save_FS(FS);
	goto EXIT;

SWSERV:
	FS->fs_IAMCC = 0;
	fclose(ts);
	fclose(fs);
	FromS = ToS = -1;
	toProxy = toMaster = 0;
	D_FTPHOPS--;
	Vsignal(SIGPIPE,sigpipe);
	ftp_env_name = "FTP_SWSERV";

	save_FS(FS);
	change_server(Conn,tc,com,cserv,cuser,cpass,ctype);
	return -1;
}

int CC_TIMEOUT_FTP = 120;
static ftpcc(Conn,FS,fs,ts,mounted)
	Connection *Conn;
	FILE *fs,*ts;
	FtpStat *FS;
{	char resp[1024];

	chdirHOME(FS,ts,fs,resp,sizeof(resp));
	FS->fs_PORTforPASV = 0;
	FS->fs_PASVforPORT = 0;
	FS->fs_modeXDC = 0;

	service_ftp1(Conn,FS,mounted);

	if( FS->fs_IAMCC && !feof(fs) )
		return 0;
	else	return -1;
}

static char *serverSYST;
static char *logindir;

#define SYNC() \
	if( do_sync ){ \
		fflush(ts); \
		rv[rx++] = rp; strcpy(rp,"500 closed.\r\n"); \
		if( get_resp(fs,NULL,rp,sizeof(srb)-(rp-srb)) == EOF ) \
			goto endreq; \
		else	rp += strlen(rp); \
	}

static char *linecpy(to,from,size)
	char *to,*from;
{	int lx;

	for( lx = 1; lx < size; lx++ )
		if( (*to++ = *from++) == '\n' )
			break;
	*to = 0;
	return to;
}
#define GET_RESP(fs,tc,rs,sz) \
	( do_sync ? rx <= ri ? EOF : *linecpy(rs,rv[ri++],sz)=='5' ? EOF : 0 \
		  : get_resp(fs,tc,rs,sz))


ftp_login(Conn,ts,fs,resp,rsize,user,pass,TypeSyst)
	Connection *Conn;
	FILE *ts,*fs;
	char *resp,*user,*pass;
{	int rcode = 0;
	int mode;
	char respb[4096];
	char *tmp;
	char path[1024];
	int rleng;
	int do_pipeline;
	int do_sync = 0,rx,ri;
	char *rp,*rv[8],srb[4096];

	if( resp == NULL ){
		resp = respb;
		rsize = sizeof(respb);
	}

	mode = 0;
	if( is_anonymous(user) ){
		mode = PS_ANON;
		IsAnonymous = 1;
	}

	if( _put_get(mode,ts,fs,resp,rsize,NULL) == EOF )
		return EOF;
	if( strstr(resp,XDC_OPENING) )
		rcode = 1;

	mode |= PS_BUFF;
		/* This is meaningless if stelinebuf(ts) has done ... */

	do_pipeline = Conn->sv_viaCc
		&& strstr(resp,"[PIPELINE]");

	if( do_pipeline )
		put_serv(mode,ts,"PIPELINE\r\n");
	else{
		if( strstr(resp,"Microsoft FTP") ){
			do_sync = 1;
			rp = srb;
			ri = rx = 0;
		}
	}

	put_serv(mode,ts,"USER %s\r\n",user); SYNC();
	put_serv(mode,ts,"PASS %s\r\n",pass); SYNC();
	if( TypeSyst ){
		put_serv(mode,ts,"TYPE %s\r\n","I"); SYNC();
		put_serv(mode,ts,"SYST\r\n"); SYNC();
		put_serv(mode,ts,"PWD\r\n"); SYNC();
	}
endreq:

	if( do_pipeline )
		put_serv(mode,ts,".\r\n");

	fflush(ts);

	rleng = 0;
	if( GET_RESP(fs,NULL,resp+rleng,rsize-rleng) == EOF ){ /* USER */
		if( resp && atoi(resp)/100 == 5 ){
			tmp = strdup(resp);
			sprintf(resp,"%d-COMMAND: USER %s\r\n%d-\r\n%s",
				atoi(tmp),user,atoi(tmp),tmp);
			free(tmp);
		}
		addRejectList(Conn,"USER","","",user,"",resp);
		return EOF;
	}
	if( GET_RESP(fs,NULL,resp+rleng,rsize-rleng) == EOF ){ /* PASS */
		addRejectList(Conn,"PASS","","",user,pass,resp);
		return EOF;
	}

	if( TypeSyst == 0 )
		return rcode;

	if( GET_RESP(fs,NULL,resp+rleng,rsize-rleng) == EOF ) /* TYPE */
		rcode = EOF;

	if( GET_RESP(fs,NULL,resp+rleng,rsize-rleng) == EOF ) /* SYST */
		serverSYST = NULL;
	else{
		serverSYST = stralloc(resp+4);
		Verbose("SYST = %s",serverSYST);
	}

	if( GET_RESP(fs,NULL,resp+rleng,rsize-rleng) == EOF ) /* PWD */
		return EOF;
	else{
		scanPWD(resp,path,NULL);
		if( path[0] == 0 )
			strcpy(path,"/");
		logindir = strdup(path);
	}

	return rcode;
}

ftp_auth(ts,fs,resp,rsize,user,pass)
	FILE *ts,*fs;
	char *resp,*user,*pass;
{
	fprintf(ts,"USER %s\r\n",user);
	fflush(ts); /* for Microsoft FTP server */
	fprintf(ts,"PASS %s\r\n",pass);
	fflush(ts);
	if( get_resp(fs,NULL,resp,rsize) == EOF ) return EOF;
	if( get_resp(fs,NULL,resp,rsize) == EOF ) return EOF;
	if( get_resp(fs,NULL,resp,rsize) == EOF ) return EOF;
	return 0;
}

FILE *ftp_fopen(Conn,put,server,host,user,pass,path,resp,rsize,isdirp)
	Connection *Conn;
	char *host,*user,*pass,*path,*resp;
	int *isdirp;
{	FILE *fs,*ts;
	int dsock;
	char mport[256];
	int usePASV = 1;

	fs = fdopen(server,"r");
	setlinebuf(fs);
	if( fs == NULL ){
		sv1log("FTP: cannot fdopen server sock[%d]\n",server);
		return;
	}
	ts = fdopen(server,"w");
	setlinebuf(ts);

	if( ftp_login(Conn,ts,fs,resp,rsize,user,pass,1) == EOF )
		return NULL;

	setConnTimeout(Conn);
	if( getenv("NOPASV") ) usePASV = 0;
	dsock = data_open(Conn,put,usePASV,-1,host,ts,fs,path,isdirp,resp,rsize);

	if( 0 <= dsock )
		if( put )
			return fdopen(dsock,"w");
		else	return fdopen(dsock,"r");
	else	return NULL;
}

FILE *ftp_fopen0(put,svsock,host,user,pass,path,resp,rsize,isdirp)
	char *host,*user,*pass,*path;
	int *isdirp;
{	Connection ConnBuf, *Conn = &ConnBuf;

	bzero(Conn,sizeof(Connection));
	return
	ftp_fopen(Conn,put,svsock,host,user,pass,path,resp,rsize,isdirp);
}


/*###########################################################################*
 *	FTPGET server
 *	941231
 */
static int   FCC_connected;
static char *FCC_LastHostport;
static FILE *FCC_ts,*FCC_fs;
static char  FCC_user[64],FCC_pass[256];

static int useSTAT = 1;
static int usePASV = 1;
static int useXDC = 1;
static int serverWithXDC;
static int clientWithXDC;

unescape_path(path,xpath)
	char *path,*xpath;
{
	nonxalpha_unescape(path,xpath,1);
	if( strcmp(path,xpath) != 0 ){
		Verbose("path-unescaped> %s\n",xpath);
		return 1;
	}
	return 0;
}

static open_ftp_byURL(Conn,auth,url,path,respb,rsize)
	Connection *Conn;
	char *auth,*url,*path,*respb;
{	char auser[256],apass[256];
	char hostport[256],uchan[128],host[256],xpath[1024],*dp;
	int port;
	int rcode;

	hostport[0] = path[0] = 0;
	if( sscanf(url,"//%[^/]/%s",hostport,path) == 0 ){
		sv1log("ERROR: open_ftp_byURL:%s\n",url);
		return -1;
	}
	if( dp = strpbrk(path,"\r\n") )
		*dp = 0;
	if( unescape_path(path,xpath) )
		strcpy(path,xpath);

/* ~user, ~/ ? */
if( path[0] == '/' && path[1] == '~' )
strcpy(path,path+1);

	port = 0;
	uchan[0] = 0;
	if( dp = strchr(hostport,'@') ){
		sscanf(hostport,"%[^@]@%[^:]:%d",uchan,host,&port);
		strcpy(hostport,dp+1);
	}else	sscanf(hostport,"%[^:]:%d",host,&port);

	auser[0] = apass[0] = 0;
	sscanf(auth,"Authorization: %[^:]:%[^\r\n]",auser,apass);


sv1log("FTPGET URL:%s uchan[%s] auser[%s] apass[%s]\n",
url,uchan,auser,is_anonymous(auser)?apass:"********");

	if( FCC_connected ){
		if( FCC_LastHostport ){
			if( strcaseeq(FCC_LastHostport,hostport) ){
if( !is_anonymous(FCC_user)
 && (strcmp(FCC_pass,apass) || strcmp(FCC_user,auser)) ){
sprintf(respb,"530 you can't reuse anotherone's connection.\r\n");
return -1;
}
				return 0;
			}
			free(FCC_LastHostport);
			FCC_LastHostport = 0;
		}
		fclose(FCC_ts);
		fclose(FCC_fs);
		ToS = FromS = -1;
		serverWithXDC = clientWithXDC = 0;
		FCC_connected = 0;
	}

	strcpy(DFLT_HOST,host);
	strcpy(DFLT_PROTO,"ftp");

	if( port ){
		DFLT_PORT = port;
		sprintf(D_SERVER,"ftp://%s:%d/",host,port);
	}else{
		DFLT_PORT = 21;
		sprintf(D_SERVER,"ftp://%s/",host);
	}

if( getenv("NOXDC") )
	useXDC = 0;

	if( useXDC )
		D_FTPHOPS = 1;

	if( connect_to_serv(Conn,FromC,ToC,0) < 0 ){
		sprintf(respb,"500 This DeleGate cannot connect %s.\r\n",hostport);
		return -1;
	}

	FCC_fs = fdopen(FromS,"r");
	FCC_ts = fdopen(ToS,"w");
/*
	FCC_user = "anonymous";
	FCC_pass = DELEGATE_MANAGER;
*/
	if( auser[0] ) strcpy(FCC_user,auser); else
	if( uchan[0] ) strcpy(FCC_user,uchan); else
		strcpy(FCC_user,"anonymous");

	strcpy(FCC_pass,apass);

	if( FCC_user[0] == 0 ){
		sprintf(respb,"530 user name is empty.\r\n");
		return -1;
	}

	rcode = ftp_login(Conn,FCC_ts,FCC_fs,respb,rsize,FCC_user,FCC_pass,1);
	if( rcode == EOF )
		return -1;

	if( useXDC ){
		serverWithXDC = (0 < rcode);
		if( serverWithXDC ){
			put_serv(PS_ANON,FCC_ts,"MODE XDC\r\n");
			if( get_resp(FCC_fs,NULL,respb,rsize) != EOF ){
				clientWithXDC = 1;
				sv1log("---- clientWithXDC\n");
			}
		}
	}
	if( serverWithSTAT == 0 ){
		char resp[128];

		serverWithSTAT = -1;
		if( put_get(FCC_ts,FCC_fs,resp,sizeof(resp),"STAT .\r\n")!=EOF )
		if( resp[3] == '-' )
			serverWithSTAT = 1;

		if( 0 < serverWithSTAT )
			sv1log("withSTAT: %s\n",host);
		else	sv1log("withoutSTAT: %s\n",host);
	}

	FCC_connected = 1;
	FCC_LastHostport = stralloc(hostport);
	return 0;
}
static getFsize(resp)
	char *resp;
{	int fsize;
	char *sp;

	fsize = -1;
	if( sp = strstr(resp,"bytes)") ){
		while( resp < sp && *sp != '(' )
			sp--;
		if( *sp == '(' )
			sscanf(sp,"(%d",&fsize);
	}
	return fsize;
}
FTP_datasize(stat)
	char *stat;
{	char *dp;

	if( dp = strstr(stat,"150") )
	if( dp == stat || dp[-1] == '\n' )
		return getFsize(dp);
	return -1;
}
static putStatresp(tc,resp,isdir)
	FILE *tc;
	char *resp;
{	char stat[1024];
	int fsize;

	if( isdir )
		sprintf(stat,"is_dir\r\n");
	else{
		fsize = getFsize(resp);
		sprintf(stat,"is_flat %d\r\n",fsize);
	}
	putPreStatus(tc,stat);
}
static ftpget1(Conn,host,path,ts,fs,tc,dport)
	Connection *Conn;
	char *host,*path;
	FILE *ts,*fs,*tc;
{	int isdir,dsock;
	char resp[1024];
	int rcode;
	void (*sig)();

	rcode = 0;
	isdir = 0;
	if( path[0] == 0 || path[strlen(path)-1] == '/' )
		isdir = 1;
	sv1log("ftpget1: path=`%s'\n",path);

	sig = Vsignal(SIGPIPE,sigPIPE);
	ftp_env_name = "ftpget1";
	if( setjmp(ftp_env) != 0 )
		rcode = -1;
	else{
		if( getenv("NOSTAT") ) useSTAT = 0;
		if( getenv("NOPASV") ) usePASV = 0;
		if( getenv("NOXDC")  ) useXDC  = 0;

		if( path[0] != '/' && logindir != NULL && logindir[0] )
			put_get(ts,fs,resp,sizeof(resp),"CWD %s\r\n",logindir);

		if( useSTAT && (0 < serverWithSTAT) && isdir ){
			sv1log("---- STAT for LIST\n");

			if( path[0] != 0 )
				put_serv(PS_BUFF|PS_ANON,ts,"CWD %s\r\n",path);
			else	put_serv(PS_BUFF|PS_ANON,ts,"CWD .\r\n");
			put_serv(PS_ANON,ts,"STAT .\r\n");

			if( get_resp(fs,NULL,resp,sizeof(resp)) == EOF ){
				STATrelay(fs,NULL);
			}else{
				putStatresp(tc,"211 Status response follows\r\n",1);
				STATrelay(fs,tc);
				sprintf(resp,"211 End of Status\n");
			}
		}else
		if( useXDC && serverWithXDC && clientWithXDC ){
			sv1log("---- XDC client\n");
			put_serv(PS_ANON,ts,"PORT 0,0,0,0,0,0\r\n");
			if( get_resp(fs,NULL,resp,sizeof(resp)) != EOF )
			if( listretr(ts,fs,path,&isdir,resp,sizeof(resp))==0 ){
				putStatresp(tc,resp,isdir);
				XDCrelayThru(fs,tc);
				get_resp(fs,NULL,resp,sizeof(resp));
			}
		}else{
			dsock = data_open(Conn,0,usePASV,dport,host,ts,fs,path,
					&isdir,resp,sizeof(resp));

			if( 0 <= dsock ){
				FILE *dfp;

				putStatresp(tc,resp,isdir);
				dfp = fdopen(dsock,"r");
				putMessageF(dfp,tc,NULL);
				fclose(dfp);
				get_resp(fs,NULL,resp,sizeof(resp));
			}
		}
		putPostStatus(tc,resp);
		fflush(tc);
	}
	signal(SIGPIPE,sig);
	return rcode;
}
static ftpget0(Conn,auth,url,server,fc)
	Connection *Conn;
	char *auth,*url,*server;
	FILE *fc;
{	char path[1024];
	char resp[4096];
	int rcode;
	FILE *tc;

	if( open_ftp_byURL(Conn,auth,url,path,resp,sizeof(resp)) < 0 )
		return -1;

	tc = fdopen(ToC,"w");
	rcode = ftpget1(Conn,server,path,FCC_ts,FCC_fs,tc,-1);
	fclose(tc);
	fclose(fc);
	return rcode;
}

extern char *DDI_fgetsFromCbuf();
service_ftpget(Conn)
	Connection *Conn;
{	char url[1024],server[256];
	char auth[1024],auser[256],apass[256];
	char uchan[256];
	char *dp;
	FILE *fc,*tc;
	char req[4096];

	if( !service_permitted2(Conn,"ftpget",1) ){
		strcpy(DFLT_PROTO,"ftp");
		if( !service_permitted(Conn,"ftp" ) ){ 
			sv1log("PERMITTED: substituted ftpget with ftp\n");
			return;
		}
	}

	fc = fdopen(FromC,"r");
	if( DDI_fgetsFromCbuf(Conn,req,sizeof(req),fc) == NULL )
		fgetsFromCT(req,sizeof(req),fc);

	auth[0] = auser[0] = apass[0] = 0;
	fgetsFromCT(auth,sizeof(auth),fc);
	if( auth[0] )
		sscanf(auth,"Authorization: %[^:]:%[^\r\n]",auser,apass);

	sscanf(req,"FTPGET %s",url);
	sscanf(url,"//%[^:/]",server);

	uchan[0] = 0;
	if( dp = strchr(server,'@') ){
		sscanf(server,"%[^:@]",uchan);
		strcpy(server,dp+1);
	}
	if( uchan[0] == 0 )
		strcpy(uchan,auser);

	ftpget0(Conn,auth,url,server,fc);
	fclose(fc);
}
