/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1996 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, modify, and distribute this material for any
purpose and without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies, and
that the name of ETL not be used in advertising or publicity pertaining
to this material without the specific, prior written permission of an
authorized representative of ETL.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	domain.c (DNS server)
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	960528	created
//////////////////////////////////////////////////////////////////////#*/
#include "delegate.h"

extern int CHILD_SERNO_MULTI;
extern int CHILD_SERNO;
static int PARASERV = 2;

extern int (*RES_DNSSERVER)();
extern int (*RES_DNSSEARCH)();

extern char *getADMIN1();
extern int DELEGATE_LastModified;

service_domain(Conn,sock,port)
	Connection *Conn;
{	char ib[2048],ob[2048];
	int icc,occ;
	char froma[128];
	int fromp;
	int si;
	double Start,Time();
	char msg[128];

	if( isMYSELF(DST_HOST) && RES_DNSSEARCH ){
		RES_nsloopcheck(sock);
		dns_init();
		if( INHERENT_fork() ){
			for( si = 1; si < PARASERV; si++ ){
				if( Fork("DNS") == 0 )
					break;
				CHILD_SERNO++;
			}
		}
		for(;;){
			CHILD_SERNO_MULTI++;
			icc = RecvFrom(sock,ib,sizeof(ib),froma,&fromp);
			Start = Time();
			occ = (*RES_DNSSEARCH)(ob,ib,icc);
			if( 0 < occ )
				SendTo(sock,ob,occ,froma,fromp);
			sprintf(msg,"[%5.3fs] %s",Time()-Start,froma);
			sv1log("%s\n",msg);
		}
	}else{
		udp_relay(Conn,sock);
	}
}

extern char *DNS_DOMAIN;
extern char *DNS_ORIGIN;
extern char *DNS_ADMIN;
extern int   DNS_SERIAL;
extern int   DNS_REFRESH;
extern int   DNS_RETRY;
extern int   DNS_EXPIRE;
extern int   DNS_MINTTL;

dns_init(){
	char buf[128],*dp;
	int init;

	if( !streq(iSERVER_PROTO,"dns") )
		return;

	init = 0;
	if( DNS_ORIGIN == NULL ){
		init++;
		GetHostname(buf,sizeof(buf));
		getFQDN(buf,buf);
		DNS_ORIGIN = strdup(buf);
	}
	if( DNS_DOMAIN == NULL ){
		init++;
		if( dp = strchr(DNS_ORIGIN,'.') )
			DNS_DOMAIN = strdup(dp+1);
		else	DNS_DOMAIN = strdup(DNS_ORIGIN);
	}
	if( DNS_ADMIN == NULL ){
		init++;
		DNS_ADMIN = getADMIN1();
	}
	if( DNS_ADMIN && strchr(DNS_ADMIN,'@') ){
		init++;
		strcpy(buf,DNS_ADMIN);
		for( dp = buf; *dp; dp++ )
			if( *dp == '@' )
				*dp = '.';
		DNS_ADMIN = strdup(buf);
	}

	if( DNS_SERIAL == 0 ){
		init++;
		StrftimeGMT(buf,sizeof(buf),"%Y%m%d%H",DELEGATE_LastModified);
		DNS_SERIAL = atoi(buf);
	}
	if( DNS_REFRESH == 0 ){ init++; DNS_REFRESH = 3600; }
	if( DNS_RETRY   == 0 ){ init++; DNS_RETRY   =  600; }
	if( DNS_EXPIRE  == 0 ){ init++; DNS_EXPIRE  = 3600 * 24 * 14; }
	if( DNS_MINTTL  == 0 ){ init++; DNS_MINTTL  = 3600; }

	if( init ){
		sv1log("DNS_DOMAIN=%s\n", DNS_DOMAIN);
		sv1log("DNS_ORIGIN=%s\n", DNS_ORIGIN);
		sv1log("DNS_ADMIN=%s\n",  DNS_ADMIN);
		sv1log("DNS_SERIAL=%d\n", DNS_SERIAL);
		sv1log("DNS_REFRESH=%d\n",DNS_REFRESH);
		sv1log("DNS_RETRY=%d\n",  DNS_RETRY);
		sv1log("DNS_EXPIRE=%d\n", DNS_EXPIRE);
		sv1log("DNS_MINTTL=%d\n", DNS_MINTTL);
	}
}

static scanconf1(conf)
	char *conf;
{	char name[128],value[128];
	int ival;

	name[0] = value[0] = 0;
	sscanf(conf,"%[^:]:%s",name,value);
	sv1log("DNSCONF = %s : %s\n",name,value);
	ival = atoi(value);

	if( strcaseeq(name,"para") ){
		PARASERV = ival;
	}else
	if( strcaseeq(name,"domain") ){
		DNS_DOMAIN = strdup(value);
	}else
	if( strcaseeq(name,"origin") ){
		DNS_ORIGIN = strdup(value);
	}else
	if( strcaseeq(name,"admin") ){
		DNS_ADMIN = strdup(value);
	}else
	if( strcaseeq(name,"serial") ){
		DNS_SERIAL = ival;
	}else
	if( strcaseeq(name,"refresh") ){
		DNS_REFRESH = ival;
	}else
	if( strcaseeq(name,"retry") ){
		DNS_RETRY = ival;
	}else
	if( strcaseeq(name,"expire") ){
		DNS_EXPIRE = ival;
	}else
	if( strcaseeq(name,"minttl") ){
		DNS_MINTTL = ival;
	}else{
		sv1log("#### unknown [%s]\n",name);
	}
	return 0;
}

scan_DNSCONF(Conn,conf)
	Connection *Conn;
	char *conf;
{
	scan_commaList(conf,0,scanconf1);
}
