/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1994 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, modify, and distribute this material for any
purpose and without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies, and
that the name of ETL not be used in advertising or publicity pertaining
to this material without the specific, prior written permission of an
authorized representative of ETL.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	dget.c
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	940206	extracted from urlfind.c
//////////////////////////////////////////////////////////////////////#*/
#include <ctype.h>
#include <stdio.h>
#include <string.h>
char *strstr();
char *getenv();

static char *usage = "\
Usage: urlfind URL\n\
    -- Find recursively in URL space.\n\
";
static char *arg1spec = "\
Argument specification error:\n\
   The first argument should be URL as follows:\n\
      protocol://host\n\
      protocol://host:port\n\
      protocol://host/path\n\
      protocol://host:port/path\n\
";

static int NoCache;
static int PutBody;
static int KeepAlive;
static int Interval;
static int SendOnly;
extern double Time();
static char Host[256];
static int http1();

dget_main(ac,av)
	char *av[];
{	char *proxy;
	char phost[128];
	int pport;
	int ai,un,ux,nrepeat,nr;
	char *arg,*urls[256],url[16*1024],*dp;
	int svsock,num,total;
	char date[128];
	double time0,Start,Time0,TTime,Max,Min;
	char type[128];
	FILE *ts,*fs;
	int leng;
	float intvl;
	char proto[256],site[1024],upath[1024],noproxy[256];
	int withPROXY;

	if( ac < 2 ){
		fprintf(stderr,"Usage: %s [PROXY=host:port] [url] [-o]\r\n",
			av[0]);
		exit(0);
	}

	nrepeat = 1;
	proxy = NULL;
	un = 0;
	strcpy(proto,"http");

	for( ai = 1; ai < ac; ai++ ){
		arg = av[ai];

		if( arg[0] == '-' && isdigit(arg[1]) ){
			nrepeat = atoi(&arg[1]);
		}else
		if( strncmp(arg,"-i",2) == 0 ){
			intvl = 0;
			sscanf(&arg[2],"%f",&intvl);
			Interval = intvl * 1000;
		}else
		if( strcmp(arg,"-c") == 0 ){
			NoCache = 1;
		}else
		if( strcmp(arg,"-o") == 0 ){
			PutBody = 1;
		}else
		if( strcmp(arg,"-k") == 0 ){
			KeepAlive = 1;
		}else
		if( strcmp(arg,"-so") == 0 ){
			SendOnly = 1;
		}else
		if( strncmp(arg,"PROXY=",6) == 0 ){
			proxy = arg + 6;
		}else{
			urls[un++] = arg;
		}
	}

	if( proxy == NULL )
		proxy = getenv("PROXY");
	if( proxy != NULL )
		withPROXY = 1;
	else	withPROXY = 0;

/*
	if( proxy == NULL ){
		fprintf(stderr,
	"PROXY=host:port should be given by environment or parameger.\n");
		exit(1);
	}
*/
	if( proxy != NULL )
	if( sscanf(proxy,"%[^:]:%d",phost,&pport) != 2 ){
		fprintf(stderr,"Illegal specification PROXY=%s\n",proxy);
		exit(2);
	}
	time0 = Time();
	num = 0;
	total = 0;
	ts = fs = NULL;

	ux = 0;
	svsock = -1;

	TTime = Min = Max = 0;
	for(;;){
		if( 0 < un ){
			if( un <= ux )
				break;
			strcpy(url,urls[ux++]);
		}else{
			if( fgets(url,sizeof(url),stdin) == NULL )
				break;
			if( dp = strpbrk(url,"\r\n") )
				*dp = 0;
			if( url[0] == '#' )
				continue;
		}
		if( !withPROXY ){
			decomp_absurl(url,proto,site,upath);
			pport = scan_hostport(proto,site,phost);
			if( pport == 0 ){
				fprintf(stderr,"? %s\n",url);
				exit(-1);
			}
			strcpy(Host,site);
			sprintf(noproxy,"%s:%d",phost,pport);
			proxy = noproxy;
			sprintf(url,"/%s",upath);
			fprintf(stderr,"%s [%s] %s\n",proto,noproxy,url);
		}

		for( nr = 0; nr < nrepeat; nr++ ){
			Start = Time();
			num++;
			if( svsock < 0 )
				svsock = client_open("URLFIND",
					proto,phost,pport);

			if( svsock < 0 ){
				fprintf(stderr,"cannot connect to PROXY=%s\n",
					proxy);
				if( Interval == 0 )
					break;
				leng = 0;
			}else{
				if( ts == NULL ){
					ts = fdopen(svsock,"w");
					fs = fdopen(svsock,"r");
				}

if( (proxy == NULL || proxy == noproxy) && strcmp(proto,"ftp") == 0 ){
	FILE *dfp;
	char resp[1024];
	FILE *ftp_fopen0();
	char *getADMIN();
	int isdir;
	dfp = ftp_fopen0(0,svsock,phost,
		"anonymous",getADMIN(),url,resp,sizeof(resp),&isdir);
	strcpy(type,"application/octetstream");
	if( dfp != NULL ){
		if( PutBody )
			total += leng = copyfile1(dfp,stdout);
		else	total += leng = copyfile1(dfp,NULLFP());
	}else{
		total += leng = 0;
	}
	KeepAlive = 0;
}else{
total += leng = http1(nr,ts,fs,"http","-",0,url,type);
}

				if( !KeepAlive ){
					fclose(ts); ts = NULL;
					fclose(fs); fs = NULL;
					svsock = -1;
				}
			}
			Time0 = Time() - Start;
			if( Min == 0 || Time0 < Min )
				Min = Time0;
			if( Max == 0 || Max < Time0 )
				Max = Time0;
			TTime += Time0;

			if( 0 < Interval ){
				StrftimeLocal(date,sizeof(date),
					"%m/%d %H:%M:%S",time(0));
				fprintf(stderr,"%s %.3f (%d)\n",date,Time0,
					leng);
				msleep(Interval);
			}
		}
		StrftimeLocal(date,sizeof(date),"%H:%M:%S",time(0));
		fprintf(stderr,"%s %3d: %s %s\n",date,num,url,type);
		fflush(stderr);
	}
fprintf(stderr,
"%d GET / %f seconds =  %6.2f GET/second %d bytes (%.3f/%.3f/%.3f)\n",
num,Time()-time0, num/(Time()-time0),total,
Min,TTime/nrepeat,Max);
	exit(0);
}

static url1(url,base,urlfp)
	char *url;
	char *base;
	FILE *urlfp;
{	char xurl[4096],*bp;
	char *dp;

	if( strncmp(url,"http:",5) == 0 )
	if( url[5] != '/' )
		url += 5;
	if( strncmp(url,"./",2) == 0 )
		url += 2;

	if( dp = strstr(url,"..") )
	if( dp[2] == 0 || dp[2] == '/' )
	if( dp == url || dp[-1] == '/' )
		return;

	xurl[0] = 0;
	if( strchr(url,':') == 0 ){
		strcpy(xurl,base);
		if( bp = strrchr(xurl,'/') )
			bp[1] = 0;
	}
	strcat(xurl,url);

	if( strncmp(xurl,base,strlen(base)) == 0 )
		fprintf(urlfp,"%s\n",xurl);
}
static http1(nr,ts,fs,proto,host,port,path,result)
	FILE *ts,*fs;
	char *proto,*host,*path,*result;
{	FILE *urlfp;
	char request[16*1024];
	char resp[1024],xline[16*1024];
	char *url;
	double start;
	int code;
	char type[256];
	int leng;
	int total = 0;
	int rcc;
	int keepalive;
	char base[16*1024];
	sprintf(base,"%s://%s:%d/%s",proto,host,port,path[0]=='/'?path+1:path);

/*
	sprintf(request,"GET %s HTTP/1.0\r\n\r\n",path[0]?path:"/");
*/
	sprintf(request,"GET %s HTTP/1.0\r\n",path);
	if( Host[0] )
	sprintf(request+strlen(request),"Host: %s\r\n",Host);
	sprintf(request+strlen(request),"User-Agent: DeleGate/%s (dget)\r\n",
		DELEGATE_ver());

	if( NoCache )
		strcat(request,"Pragma: no-cache\r\n");
	if( KeepAlive ){
/*
		strcat(request,"Connection: keep-alive\r\n");
*/
		strcat(request,"Proxy-Connection: Keep-Alive\r\n");
	}

if( getenv("HEADSIZE") ){
	char *p;
	int size,i;
	size = atoi(getenv("HEADSIZE"));
	strcat(request,"X-Padding: ");
	p = request + strlen(request);
	for( i = 0; i < size; i++ )
		p[i] = 'X';
	p[i] = 0;
	strcat(request,"\r\n");
}
	strcat(request,"\r\n");
	fputs(request,ts);
	fflush(ts);

fprintf(stderr,"REQUEST-LEN: %d\n",strlen(request));

	if( SendOnly )
		return 0;

	start = Time();
	if( fgets(resp,sizeof(resp),fs) == NULL ){
		fprintf(stderr,"[NULL] empty response (%3.2fs)\n",Time()-start);
		sprintf(result,"[NULL]");
		goto ERR;
	}

	if( strncmp(resp,"HTTP/1.",7) != 0 ){
		fprintf(stderr,"[%d][NON-HTTP/1.0] %s\n",nr,resp);
		sprintf(result,"[%d][NON-HTTP/1.0]",nr);
		goto ERR;
	}
	sscanf(resp,"%*s %d",&code);

	type[0] = 0;
	leng = 0;
	keepalive = 0;

	while( fgets(resp,sizeof(resp),fs) != NULL ){
		char *dp;

		if( dp = strpbrk(resp,"\r\n") )
			*dp = 0;
		if( dp == resp )
			break;

		if( strncasecmp("Content-Type:",resp,12) == 0 )
			sscanf(resp,"%*s %[^ \t\r\n]",type);
		else
		if( strncasecmp("Content-Length:",resp,13) == 0 )
			sscanf(resp,"%*s %d",&leng);
		else
		if( strncasecmp("Proxy-Connection: keep-alive",resp,28) == 0
		 || strncasecmp(      "Connection: keep-alive",resp,22) == 0 )
			keepalive = 1;
	}
	sprintf(result,"[%d][%s][%d]",code,type,leng);

	if( KeepAlive && keepalive && 0 < leng ){
		char *buf;
		buf = (char*)malloc(leng);
		total = fread(buf,1,leng,fs);
		if( PutBody )
			fwrite(buf,1,leng,stdout);
		free(buf);
	}else{
		while( (rcc=fread(resp,1,sizeof(resp),fs)) != 0 ){
			total += rcc;
			if( PutBody )
				fwrite(resp,1,rcc,stdout);
		}
	}

	if( 100000 < total )
		fprintf(stderr,"total: %d\n",total);

ERR:
	if( !keepalive )
		KeepAlive = 0;

	return total;
}
