/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1994-1998 Electrotechnical Laboratry (ETL), AIST, MITI
Copyright (c) 1994-1998 Yutaka Sato

Permission to use, copy, modify, and distribute this material for any
purpose and without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	delegated (DeleGate Server)
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	940303	created
//////////////////////////////////////////////////////////////////////#*/
#include "param.h"
#include "vsignal.h"
#include "delegate.h"
#include "log.h"

extern int errno;
static int TeleportTunnel;

extern int CHILD_SERNO;
extern int CHILD_SERNO_MULTI;
extern int CHILD_SERNO_SINGLE;
extern int REQUEST_SERNO;

extern int SERVER_RESTART;
extern int SERVER_TIMEOUT;
extern int TOTAL_SERVED;
extern int NUM_CHILDREN;
extern int NUM_PEERS;
extern int START_TIME;
extern int PEEK_CLIENT_REQUEST;
extern int LOG_VERBOSE;
extern int RES_localdns;

static int NUM_HUPS;
static int ServerPID;
static int PublicPID;
static int HttpdPID;
static int RestartPublic;
static int StorePID;
static int DbasePID = 0;
extern int myPrivateMASTER;
extern int MASTERisPrivate;
extern int IamPrivateMASTER;
static int restartPrivateMASTER;
static int IamCGI;
static int TeleportPID = 0;
static char PrivateMasterOwnerPort[64];
static char *PrivateMasterOwner = "(private-MASTER for ";

extern int STANDBY_MAX;
extern int STANDBY_TIMEOUT;

double ACCEPT_TIME;
extern double Time();

extern int BREAK_STICKY;
static int INTERRUPT_STICKY;
static int StickyMAX_PARA; /* max. parallel Stickies */
static int StickyMAX_LIFE; /* max. services by a Sticky */
static int StickyTIMEOUT;  /* standby seconds. (users' click interval) */
static int *StickyProcs;
static int StickyActive;
static int StickyReport[2] = {-1,-1};
static int StickyNserved;
static int StickyDone;
static int ACC_BYMAIN_INTERVAL = 200; /* retry after blocked by Stickies */
static int ACC_REJECTED;

static char *DeleGate1	= "DeleGate";
static char *FuncFunc = "(Function)";
static char *FuncSTICKY = "(Sticky)";
static char *FuncFILTER = "(Filter)";
static char *FuncSOCKIO	= "(socket-I/O)";
static char *FuncSHIO	= "(shio)";
static char *FuncDBManager = "(DB-Manager)";
static char *FuncPutPUBLIC = "(put-PUBLIC)";
static char *FuncGetPUBLIC = "(get-PUBLIC)";

static char *originWD;

extern int LOG_sockio[2];
extern int LOG_sock_enable;
extern char *DELEGATE_LOGCENTER;
extern int LOG_center;
extern char *DELEGATE_ERRORLOG;

       int DELEGATE_PAUSE;
extern int MAX_DELEGATE;
static int MAX_SERVICE;

extern char *strdup();
extern char *getcwd();
extern char *gethostaddr();
extern char *strrpbrk();
extern char *strcasestr();
extern char *malloc();
extern char *calloc();
extern char *wordscan();
extern char **dupv();
extern char *getClientUser();
extern char *getClientUserC();
extern char *getClientUserH();

extern char **environ;
extern char EXEC_PATH[];
extern int  main_argc;
extern char **main_argv;
extern int  param_file;

extern int DELEGATE_pushEnv();
extern char *DELEGATE_getEnv();
#define getEnv(name)		DELEGATE_getEnv(name)
#define scanEnv(Conn,name,func)	DELEGATE_scanEnv(Conn,name,func)
#define pushEnv(name,value)	DELEGATE_pushEnv(name,value)

extern FILE *LOG_openLogFile();
extern FILE *TMPFILE();
extern int DELEGATE_LastModified;

int RESTART_NOW;
#define cronExit	DELEGATE_cronExit
#define sched_execute	DELEGATE_sched_execute
#define sched_action	DELEGATE_sched_action
extern int sched_action();

static setLastModified()
{	FILE *tmp,*fp;
	char *form;
	int modified;

	tmp = TMPFILE("setLastModified");
	DELEGATE_dumpEnv(tmp,0,IamPrivateMASTER);
	fflush(tmp);
	fseek(tmp,0,0);

	modified = 1;
	form = DELEGATE_PARAMFILE;
	if( fp = LOG_openLogFile(form,"r") ){
		if( fcompare(tmp,fp) == 0 ){
			modified = 0;
			DELEGATE_LastModified = file_mtime(fileno(fp));
		}
		fclose(fp);
	}
	if( modified ){
		DELEGATE_LastModified = time(0);
		if( fp = LOG_openLogFile(form,"w") ){
			copy_file(tmp,fp,NULL);
			fclose(fp);
		}
	}
	fclose(tmp);
	sv0log("DELEGATE_Modified[%d]: %x\n",modified,DELEGATE_LastModified);
}

extern char *sigsym();

static void sigPIPE(sig){
	sv0log("abort: caught SIGPIPE\n");
	Finish(-1);
}
static void sigURG(sig){
	sv0log("abort: caught SIGURG\n");
	Finish(-1);
}
static void sigFATAL(sig){
	signal(sig,SIG_IGN);
	daemonlog("F","E-A: ABORT: caught SIG%s [%d]\n",sigsym(sig),sig);
	ClientCountDown();
	AbortLog();
	abort();
}
static int gotSIGTERM;
static void sigTERM(sig)
{
	gotSIGTERM = sig;
	signal(SIGTERM,SIG_IGN);
	sv0log("DeleGate SERVER EXITS: caught SIG%s [%d]\n",sigsym(sig),sig);
	if( getpid() != ServerPID ){
		fprintf(stderr,"\nDeleGate[%d] got SIGTERM(%d) for server=%d\n",
			getpid(),sig,ServerPID);
		Finish(-1);
		_exit(-1);
	}
	closeServPorts();
	Killpg(getpid(),SIGTERM);
	signal(SIGTERM,SIG_DFL);

	LOG_deletePortFile();
	deleteWORKDIR();

	cleanup_zombis(0);
	if( NUM_CHILDREN )
		sv0log("Left children: %d\n",NUM_CHILDREN);

	sv0log("FINISH.\n");
	Finish(0);
	fprintf(stderr,"*** exit() on SIGTERM(%d) failed.1\n",sig);
	_exit(0);
}
static void sigTERM1(sig)
{
	Finish(0);
	fprintf(stderr,"*** exit() on SIGTERM(%d) failed.2\n",sig);
	_exit(0);
}


static StickyAdd(pid)
{
	StickyProcs[StickyActive++] = pid;
}
static StickyDel(pid)
{	int si;
	unsigned char nserv;

	for( si = 0; si < StickyActive; si++ ){
		if( StickyProcs[si] == pid ){
			for(; si < StickyActive; si++)
				StickyProcs[si] = StickyProcs[si+1];
			StickyActive--;
			StickyDone++;
			break;
		}
	}
	while( 0 < PollIn(StickyReport[0],1) )
		if( read(StickyReport[0],&nserv,1) == 1 )
			StickyNserved += nserv;
}
static StickyKill(sig)
{	int si,pid,rcode;
	int nkill;

	nkill = 0;
	for( si = 0; si < StickyActive; si++ ){
		pid = StickyProcs[si];
		rcode = Kill(pid,sig);
		if( rcode == 0 )
			nkill++;
	}
	sv1log("StickyKill(%d): %d/%d killed\n",sig,nkill,StickyActive);
	return nkill;
}

static dec_nproc(pid)
{
	if( pid == myPrivateMASTER ){
		myPrivateMASTER = 0;
		sv1log("#### privateMASTER[%d] dead\n",pid);
		if( getpid() == ServerPID )
			restartPrivateMASTER = 1;
		else	BREAK_STICKY = 1;
	} else
	if( pid == PublicPID ){	PublicPID = 0; RestartPublic = 1; }else
	if( pid == DbasePID ){	DbasePID = 0; } else
	if( pid == StorePID ){	StorePID = 0; } else
	if( pid == TeleportPID ){
		sv1log("Teleport Closed.\n");
		sigTERM(SIGTERM);
	}else
	if( cronExit(pid) ){
	}else{
		StickyDel(pid);
		del_CC(pid,"byWait");
		if( 0 < NUM_CHILDREN )
			NUM_CHILDREN--;
		else	sv1log("previous server's child ? %d\n",pid);
		Verbose("(%d) process [%d] dead\n",NUM_CHILDREN,pid);
	}
}

cleanup_zombis(log)
{	int pid;
	int ndead;

	ndead = 0;
	while( 0 < (pid = NoHangWait()) ){
		ndead++;
		dec_nproc(pid);
	}
	if( MAX_DELEGATE && MAX_DELEGATE + num_CC() <= NUM_CHILDREN ){
		int start = time(0);

		sv1tlog("MAX_DELEGATE: %d + %d <= %d\n",
			MAX_DELEGATE,num_CC(),NUM_CHILDREN);

		while( MAX_DELEGATE + num_CC() <= NUM_CHILDREN ){
			if( 0 < (pid = NoHangWait()) ){
				ndead++;
				dec_nproc(pid);
			}else{
				if( gotSIGTERM )
					break;
				sleep(1);
			}
		}
		sv1tlog("MAX_DELEGATE: %d < %d + %d (%d seconds) finished=%d\n",
			NUM_CHILDREN,MAX_DELEGATE,num_CC(),time(0)-start, pid);
	}
	return ndead;
}


/*
 *	temporary argument to be removed after got
 */
#define TMP_SYM		"++"
#define TMP_SYM_LEN	(sizeof(TMP_SYM)-1)

static killChildren()
{	int nproc;

	nproc = 0;
	if( 0 < myPrivateMASTER ){
		if( Kill(myPrivateMASTER,SIGTERM) == 0 ){
			svlog("Killed private-MASTER [%d]\n",myPrivateMASTER);
			myPrivateMASTER = 0;
			++nproc;
		}
	}
	if( 0 < DbasePID ){
		if( Kill(DbasePID,SIGTERM) == 0 ){
			DbasePID = 0;
			++nproc;
		}
	}
	if( 0 < PublicPID ){
		if( Kill(PublicPID,SIGTERM) == 0 ){
			PublicPID = 0;
			++nproc;
		}
	}
	return nproc;
}

static void sigHUP(sig)
{	char *nargv[256];
	char *arg,path[1024],port[128],nchild[32],wd[1024];
	int ai,ac,portset;
	int nproc;
	char orig_av0[1024];

	strcpy(path,EXEC_PATH);
	wordscan(main_argv[0],orig_av0);/*av[0] may be expanded for ps_title*/

	if( getpid() != ServerPID ){
		fprintf(stderr,"\nDeleGate[%d] got SIGHUP(%d) for server=%d\n",
			getpid(),sig,ServerPID);
		exit(1);
	}

	signal(SIGHUP,SIG_IGN);
	alarm(0);
	sigsetmask(0);
	LOG_sock_enable = 1;

{
char lpath[1024],host[256];
FILE *logfp;
int port;
int lsock;

sprintf(lpath,"/tmp/delegate/restart/%d",getpid());
if( logfp = fopen(lpath,"r") ){
	if( fscanf(logfp,"%[^:]:%d",host,&port) == 2 ){
		fclose(logfp);
		lsock = client_open("LOG","http",host,port);
		fprintf(stderr,"#### %s : %d [%d]\n",host,port);
		write(lsock,"(^_^)\n",6);
		sleep(5);
		close(lsock);
	}
}
}

	sv0log("DeleGate SERVER RESTART: %s\n",
		sig==0?"timeout":"caught SIGHUP");

{
int fd;
fd = dup(fileno(stderr));
sv0log("NUM_HUPS=%d FD=[%d]\n",NUM_HUPS+1,fd);
close(fd);
}

	printServPort(port,"-P",1);

	if( sig == -1 ){
		sv0log("REOPEN PORT: %s\n",port);
		printServPort(port,"-P",0);
		closeServPorts();
	}

	nproc = killChildren();
	StickyKill(SIGHUP);

	LOG_deletePortFile();
	deleteWORKDIR();
	if( originWD ) chdir(originWD);

	LOG_checkAged(1);
	sv0log("DeleGate SERVER RESTART in progress...\n");
	strcpy(wd,"?");
	getcwd(wd,sizeof(wd));
	sv0log("PWD: %s\n",wd);
	sv0log("EXEC: %s\n",path);
	LOG_closeall();

	close(StickyReport[0]); StickyReport[0] = -1;
	close(StickyReport[1]); StickyReport[0] = -1;

	if( 0 < nproc || NUM_CHILDREN )
		msleep(100);
	cleanup_zombis(0);
	sprintf(nchild,"%s%d/%d/%d/%d",TMP_SYM,++NUM_HUPS,NUM_CHILDREN,
		LOG_sockio[0],LOG_sockio[1]);

	nargv[0] = orig_av0;
	ac = 1;
	portset = 0;

	for( ai = 1; ai < main_argc; ai++ ){
		arg = main_argv[ai];
		if( arg[0]=='-' && arg[1]=='-' )
			continue;
		if( strncmp(arg,TMP_SYM,TMP_SYM_LEN) == 0 )
			continue;
		if( arg[0]=='-' && arg[1]=='P' ){
			if( !portset ){
				portset = 1;
				nargv[ac] = port;
			}
		}else	nargv[ac] = arg;
		ac++;
	}
	if( !portset )
		nargv[ac++] = port;
	nargv[ac++] = nchild;
	nargv[ac++] = 0;

	Execvp("sigHUP",path,nargv);
}

extern char PSTITLE_PADD;
extern int  PSTITLE_SIZE;
extern int  AF_UNIX_DISABLE;

static checkIfSolaris(){
	if( IsSolaris() ){
		PSTITLE_SIZE = 60;
		PSTITLE_PADD = '-';
	}
}

static LOG_type_got;
static setupForSolaris()
{
	/* LOG_type is given by the parent in private-MASTER in the av[] */
	if( LOG_type_got )
		return;

	if( acceptExclusive() ){
		Verbose("ACCEPT EXCLUSION is ON by default.\n");
		if( (LOG_type & (L_FORK|L_EXEC)) == 0 ){
			if( LOG_type & L_LOCK )
				LOG_type &= ~L_LOCK;
			else	LOG_type |=  L_LOCK;
		}
	}
}
/*
 *	This function should be called after the process's real OWNER
 *	is set so that the directry is writable for the process itself.
 */
static mkdirForSolaris()
{
	if( IsSolaris() )
		AF_UNIX_DISABLE = 1;
}

#define INC_SYM		"+="
#define INC_SYM_LEN	(sizeof(INC_SYM)-1)
static char *included[32];

#define LOAD_SYM	"-="
#define LOAD_SYM_LEN	(sizeof(LOAD_SYM)-1)

static int include_next;
extern int DEBUG_FILE;
extern FILE *openPurl();


static subst_argurl(base,url,arg,xarg)
	char *arg,*base,*url,*xarg;
{	char aurl[1024],path[1024],param[1024];
	FILE *sfp,*dfp;
	int size;

	sfp = openPurl(base,url,aurl);
	if( sfp == NULL ){
		ERRMSG("Cannot load: %s\n",url);
		return -1;
	}

	param[0] = 0;
	sscanf(arg,"%[^=]",param);
	makeWorkFile(path,"mirror",param);

	dfp = dirfopen(param,path,"w");
	if( dfp == NULL ){
		ERRMSG("Cannot create: %s\n",path);
		fclose(sfp);
		return -1;
	}

	copyfile1(sfp,dfp);
	fclose(sfp);
	fflush(dfp);
	size = file_size(fileno(dfp));
	fclose(dfp);

	sprintf(xarg,"%s=%s",param,path);
	/*fprintf(stderr,"Argument substituted [%s] -> [%s](%dbytes)\n",
		arg,xarg,size);*/
	return 0;
}

char *scan_arg1(ext_base,arg)
	char *ext_base,*arg;
{	char *list,*val;
	int num;
	char *as;
	char *dp,xarg[1024];

	if( dp = strchr(arg,'=') ){
		dp++;
		if( strncmp(dp,LOAD_SYM,LOAD_SYM_LEN) == 0 ){
			dp += LOAD_SYM_LEN;
			if( subst_argurl(ext_base,dp,arg,xarg) == 0 )
				arg = strdup(xarg);
		}
	}

	/* inherited on SIGHUP */
	if( strncmp(arg,TMP_SYM,TMP_SYM_LEN) == 0 && arg[TMP_SYM_LEN] != 0 ){
		sscanf(arg+2,"%d/%d/%d/%d",&NUM_HUPS,&NUM_CHILDREN,
			&LOG_sockio[0],&LOG_sockio[1]);
	}else
	if( include_next ){
		include_next = 0;
		load_script(NULL,ext_base,arg);
	}else
	if( strncmp(arg,INC_SYM,INC_SYM_LEN) == 0 ){
		if( arg[INC_SYM_LEN] == 0 )
			include_next = 1;
		else	load_script(NULL,ext_base,arg+INC_SYM_LEN);
	}else
	if( strncmp(arg,"-e",2) == 0 ){
		putenv(strdup(arg+2));
	}else
	if( list = strchr(arg,'=') ){
		check_param(arg,1);
		list++;
		if( strncmp(list,INC_SYM,INC_SYM_LEN) == 0 ){
			char name[128];
			extern int SCRIPT_ASIS;
			int asis;

			sscanf(arg,"%[^=]",name);
			asis = SCRIPT_ASIS;
			SCRIPT_ASIS = script_asis(name);
			load_script(name,ext_base,list+INC_SYM_LEN);
			SCRIPT_ASIS = asis;
		}else
		if( ext_base != NULL )
			DELEGATE_addEnvExt(arg);
	}else
	if( strncmp(arg,PrivateMasterOwner,strlen(PrivateMasterOwner)) == 0 ){
		PrivateMasterOwnerPort[0] = 0;
		sscanf(arg+strlen(PrivateMasterOwner),"%[^)]",
			PrivateMasterOwnerPort);
	}else
	switch( arg[0] ){
	    case '-':
	    val = &arg[2];
	    switch( arg[1] ){
		case 'F':
			/* function selector */
			break;

		case 'P': /* server port */
			svlog("PORT> %s\n",arg);

			{   int sock;
			    if( 0 < (sock = getserversock()) ){
				char *dp;
				arg = strcpy((char*)malloc(strlen(arg)+16),arg);
				val = &arg[2];
				if( (dp = strchr(arg,'/')) == 0 )
					dp = &arg[strlen(arg)];
				sprintf(dp,"/%d",sock);
			    }
			}
			if( strncmp(arg,"-P0/",4) == 0 )
				IamPrivateMASTER = getppid();
			scanServPort(val);
			break;

		case 'c':
			switch( arg[2] ){
			    case 'e': pushEnv(P_CHARCODE,"EUC"); break;
			    case 'j': pushEnv(P_CHARCODE,"JIS"); break;
			    case 's': pushEnv(P_CHARCODE,"SJIS"); break;
			}
			break;

		case 'C':
			DELEGATE_CONFIG = strdup(val);
			break;

		case 'L':
			LOG_type_got = 1;
			sscanf(val,"0x%x",&LOG_type);
			break;

		case 'd':
			LOG_type |= L_ARGDUMP;
			break;

		case 'f':
			LOG_type |= L_FG;
			break;
		case 'l':
			LOG_type |= L_LOCK;
			break;
		case 's':
			LOG_type |= L_FORK;
			break;
		case 'p':
			PEEK_CLIENT_REQUEST = 1;
			break;
		case 'x':
			LOG_type |= L_EXEC;
			break;
		case '1':
			LOG_type |= L_SYNC | L_TTY;
			break;
		case 't':
			LOG_type |= L_TTY;
			break;
		case 'v':
			if( arg[2] == 0 ){
				LOG_type |= L_FG|L_TTY;
			}else
			for( as = arg+2; *as; as++ ){
			    switch( *as ){
				case  's': LOG_type |= L_SILENT; break;
				case  't': LOG_type |= L_TERSE; break;
				case  'd': LOG_type |= L_VERB; break;
				case  'v': LOG_type |= L_FG|L_TTY|L_VERB;
			    }
			}
			break;
		case 'w':
			if( arg[2] == 0 )
				LOG_type |= 1;
			else
			if( '0' <= arg[2] && arg[2] <= '9' )
				LOG_type = (LOG_type & ~0xF) | (arg[2]-'0');
			break;
		}
		break;
	}
	return arg;
}

static int sav_TeleportTunnel;
static int sav_LOG_type;
static setupDefaultPort()
{
	if( SERVER_PORT() == 0 ){
		sav_TeleportTunnel = TeleportTunnel; TeleportTunnel = 1;
		sav_LOG_type = LOG_type;
		/*LOG_type |= L_SYNC;*/
	}
}
static unsetDefaultPort()
{
	if( SERVER_PORT() == 0 ){
		TeleportTunnel = sav_TeleportTunnel;
		LOG_type = sav_LOG_type;
	}
}
#define scan_args(ac,av)	DELEGATE_scan_args(ac,av)
scan_args(ac,av)
	char *av[];
{	int ai;

	if( lVERB() || lARGDUMP() ){
		for( ai = 0; ai < ac; ai++ )
			fprintf(stderr,"[%d] %s\n",ai,av[ai]);
	}
	for( ai = 0; ai < ac; ai++ )
		av[ai] = scan_arg1(NULL,av[ai]);

	if( lVERB() )
		LOG_VERBOSE = 1;

	setupForSolaris();
	return ac;
}

Connection MainConn;

static settty(){
	char *stty;
	char command[256];

	if( stty = getEnv("STTY") ){
		sprintf(command,"stty %s",stty);
		system(command);
	}
}

static beDaemon(Conn)
	Connection *Conn;
{	char *av[256],port[128],param[128];
	int ac,ai;
	char *admin,admbuff[128],parambuff[128];
	char *getADMIN1();

	if( !INHERENT_spawn() ){
		if( Fork("daemon") != 0 )
			_Finish(0);
		setsid();
		return;
	}

	ac = 0;	
	av[ac++] = EXEC_PATH;
	ac += copy_param(NULL,&av[ac],environ);
	ac += copy_param("*+",&av[ac],&main_argv[1]);
	printPrimaryPort(port);
/*
this make fgets() loop in askADMIN() without reading...
printServPort(port,"",1);
*/
	sprintf(param,"-P%s",port);
	av[ac++] = param;
	for( ai = 0; ai < main_argc; ai++ ){
		if( streq(main_argv[ai],"-SERVICE") ){
			av[ac++] = "-SERVICE";
			break;
		}
	}
	av[ac] = 0;

	put_identification(stdout);
	admin = getADMIN1();
	if( admin == NULL || *admin == 0 ){
		printf("CAUTION: Neither ADMIN nor MANAGER is specified.\r\n");
		printf("You must declare your E-mail address.\r\n");

		admbuff[0] = 0;
		if( askADMIN(stdout,stdin,admbuff,sizeof(admbuff)) != 0 )
			Finish(0);
		if( admbuff[0] == 0 ){
			printf("EXIT: You must declare ADMIN\r\n");
			Finish(0);
		}
		sprintf(parambuff,"ADMIN=%s",admbuff);
		av[ac++] = parambuff;
		av[ac] = NULL;
	}
	ScanFileDefs(Conn);
	if( checkCACHEDIR(Conn) != 0 )
		Finish(-1);

	if( create_service(ac,av,port) )
		exit(0);

	sv1log("#### DO NOT FORK TO BE DAEMON\n");
}


extern int START_TIME1;
static int CLsock = -1;

static char *execSPECIAL;
static int execPutPUBLIC;
static int execGetPUBLIC;
static char *putPUBLIC;

static int execDB;
static int DBsock[2] = {-1,-1};

extern int HAS_MASTER;

static scan_serverspec(serverspec,url,hostlist)
	char *serverspec,*url,*hostlist;
{	char *hl;

	if( hl = strstr(serverspec,":-:") ){
		strcpy(url,serverspec);
		hl = strstr(url,":-:");
		*hl = 0;
		strcpy(hostlist,hl+3);
	}else{
		strcpy(url,serverspec);
		strcpy(hostlist,"");
	}
	if( strchr(url,':') == NULL )
		strcat(url,"://-/");
}

static char *serverurl0;

static server2(Conn,serverspec,serverurl)
	Connection *Conn;
	char *serverspec,*serverurl;
{	char hostlist[1024];
	char chost[256],ihost[256];
	int cport,iport;
	int match;
	char *user;

	scan_serverspec(serverspec,serverurl,hostlist);
	if( hostlist[0] == 0 ){
		strcpy(serverurl0,serverurl);
		return 0;
	}
	if( !Conn->cl.p_connected )
		return 0;

	gethostNAME(Conn->cl_sock,ihost,NULL,&iport);
	cport = getClientHostPort(Conn,chost);
	user = getClientUser(Conn);
	if( user == NULL )
		user = "-";
	match = evalMountCond(hostlist,user,chost,cport,ihost,iport);

	if( match ){
		Verbose("OK [%s] [%s][%s]\n",serverurl,chost,hostlist);
		scan_SERVER(Conn,serverurl);
		Conn->cl.p_bound = 1;
		return 1;
	}else{
		Verbose("NO [%s] [%s][%s]\n",serverurl,chost,hostlist);
		return 0;
	}
}

static server1(Conn,serverspec)
	Connection *Conn;
	char *serverspec;
{	char serverurl[1024];

	if( Conn->cl.p_bound )
		return 1;

	if( server2(Conn,serverspec,serverurl) )
		return 1;

	return 0;
}

static char *Scan_SERVER(Conn)
	Connection *Conn;
{	char *proto;
	char url[1024];

	serverurl0 = url;
	serverurl0[0] = 0;
	scanEnv(Conn,P_SERVER,server1);

	if( !Conn->cl.p_bound && serverurl0[0] )
		if( scan_SERVER(Conn,serverurl0) == 0 )
			Exit(-1,"ERROR: %s=%s\n",P_SERVER,serverurl0);

	if( DFLT_PROTO[0] ){
		BORN_SPECIALIST = 1;
		proto = DFLT_PROTO;
		if( !REUSE_ENV() )
		Verbose("SPECIALIST: %s\n",proto);
	}else{
		Verbose("GENERALIST\n");
		BORN_SPECIALIST = 0;
		proto = "delegate";
	}
	return proto;
}

static char *servermount_proto;
static servermount1(Conn,serverspec)
	Connection *Conn;
	char *serverspec;
{	char serverurl[1024],hostlist[1024],mountopt[1024];
	char mount[1024];
char *proto;
proto = servermount_proto;

	scan_serverspec(serverspec,serverurl,hostlist);
	if( hostlist[0] )
		if( strchr(hostlist,'=') )
			sprintf(mountopt,"%s",hostlist);
		else	sprintf(mountopt,"via=%s",hostlist);
	else	strcpy(mountopt,"");

	if( streq(proto,"http") ){
		sprintf(mount,"%s*",serverurl);
		set_MOUNT_ifndef(Conn,"/-*","=",mountopt);
		set_MOUNT_ifndef(Conn,"/=*","=",mountopt);
		set_MOUNT_ifndef(Conn,"/*",mount,mountopt);
	}
	if( streq(proto,"nntp") || streq(proto,"news") ){
		sprintf(mount,"%s*",serverurl);
		set_MOUNT(Conn,"=",mount,mountopt);
	}
	if( streq(proto,"ftp") ){
		set_MOUNT_ifndef(Conn,"//*","=",mountopt);
		if( !isMYSELF(DFLT_HOST) )
		if( getEnv(P_MOUNT) != NULL || strchr(serverurl,'@') ){
			sprintf(mount,"%s*",serverurl);
			set_MOUNT_ifndef(Conn,"/*",mount,mountopt);
		}
	}
	if( streq(proto,"pop") )
		set_MOUNT_ifndef(Conn,"//*","=",mountopt);
}

static int mount_done;
static mount_all(Conn,proto)
	Connection *Conn;
	char *proto;
{	char *env;

	if( mount_done )
		return;
	mount_done = 1;

	scanEnv(Conn,P_MOUNT,scan_MOUNT);

servermount_proto = proto;
	scanEnv(Conn,P_SERVER,servermount1);

	init_mtab();
}

static char *defaultPERMIT(Conn)
	Connection *Conn;
{	char remitable[128];

	if( BORN_SPECIALIST ){
		if( streq(DFLT_PROTO,"telnet") )
		if( iSERVER_PORT != 0 ){
			sprintf(remitable,"%s/%d",iSERVER_PROTO,iSERVER_PORT);
			sv1log("REMITTABLE bound by SERVER: %s\n",remitable);
			return strdup(remitable);
		}

		if( streq(DFLT_PROTO,"http") || streq(DFLT_PROTO,"icp") )
			return DELEGATE_HTTP_PERMIT;
		else
		if( streq(DFLT_PROTO,"socks") )
			return DELEGATE_SOCKS_PERMIT;
		else
		if( streq(DFLT_PROTO,"telnet") )
			return DELEGATE_TELNET_PERMIT;
		else	return DELEGATE_S_PERMIT;
	}else	return DELEGATE_G_PERMIT;
}
static scan_PERMITX(Conn,proto)
	Connection *Conn;
	char *proto;
{	char extproto[1024];

	if( num_ListElems(proto,':') == 1 ){
		PERMIT_GLOBAL++;
		if( *proto == '+' ){
			sprintf(extproto,"%s%s",defaultPERMIT(Conn),proto+1);
			proto = extproto;
		}
	}else{
		if( PERMIT_GLOBAL == 0 ){
			scan_PERMIT(Conn,defaultPERMIT(Conn));
		}
	}
	scan_PERMIT(Conn,proto);
	return 0;
}

httplog_head(Conn,time,fp)
	Connection *Conn;
	FILE *fp;
{	char host[256],*user,date[64];

	strcpy(host,"-");
	getClientHostPort(Conn,host);
	if( (user = getClientUserC(Conn)) == NULL )
		user = "-";
	StrftimeLocal(date,sizeof(date),TIMEFORM_HTTPD,time);
	fprintf(fp,"%s %s %s [%s] ",host,user,"-",date);
}

extern Logfile *LOG_which();
fputLog(Conn,filter,fmt,a,b,c,d,e,f,g)
	Connection *Conn;
	char *filter;
	char *fmt,*a,*b,*c,*d,*e,*f,*g;
{	char date[64];
	Logfile *Log;

	if( Log = LOG_which(DFLT_PROTO,filter,0) ){
		StrftimeLocal(date,sizeof(date),TIMEFORM_HTTPD,time(0));
		LOG_printf(Log,"[%s]{%d+%d} %s: ",
			date,CHILD_SERNO,CHILD_SERNO_MULTI,filter);
		LOG_printf(Log,fmt,a,b,c,d,e,f,g);
		return 1;
	}
	return 0;
}
scan_LOG(Conn,log)
	void *Conn;
	char *log;
{	char proto[64],filters[256],logform[256],pathform[1024];
	int ni;

	proto[0] = filters[0] = logform[0] = pathform[0] = 0;
	ni = sscanf(log,"%[^:]:%[^:]:%[^:]:%s",proto,filters,logform,pathform);
	if( ni != 4 ){
		ERRMSG("ERROR LOG=%s\n",log);
		return 0;
	}
	LOG_create(proto,filters,logform,pathform,"a",0);
	return 0;
}
static char *logfile()
{	char *logfile;

	if( (logfile = getEnv(P_LOGFILE)) == 0 )
		logfile = DELEGATE_LOGFILE;
	return logfile;
}

static char *primaryPort(port)
	char *port;
{
	if( IamPrivateMASTER )
		sprintf(port,"%s++",PrivateMasterOwnerPort);
	else	printPrimaryPort(port);
	return port;
}
static strsubstDE(spath,path,root,var)
	char *spath,*path,*root,*var;
{
	strcpy(spath,path);
	strsubstDirEnv(spath,root,var);
}
#define substfile DELEGATE_substfile
int substfile(file,proto,rvardir,rlogdir,rtmpdir)
	char *file,*proto,*rvardir,*rlogdir,*rtmpdir;
{	char port[256],pid[64],*vardir,*etcdir,*admdir,*logdir,*tmpdir;
	char *dgroot ;
	char alogdir[1024];

	if( (dgroot = getEnv(P_DGROOT)) == 0 ) dgroot = DELEGATE_DGROOT;
	if( (vardir = getEnv(P_VARDIR)) == 0 ) vardir = DELEGATE_VARDIR;
	if( (etcdir = getEnv(P_ETCDIR)) == 0 ) etcdir = DELEGATE_ETCDIR;
	if( (admdir = getEnv(P_ADMDIR)) == 0 ) admdir = DELEGATE_ADMDIR;
	if( (logdir = getEnv(P_LOGDIR)) == 0 ) logdir = DELEGATE_LOGDIR;
	if( (tmpdir = getEnv(P_ACTDIR)) == 0 ) tmpdir = DELEGATE_ACTDIR;

	primaryPort(port);
	sprintf(pid,"%d",getpid());

	if( !isBoundpath(logdir) ){
		strcpy(alogdir,logdir);
		strsubstDirEnv(alogdir,dgroot,vardir);
		if( !isBoundpath(alogdir) )
			sprintf(alogdir,"%s/%s",vardir,logdir);
		logdir = alogdir;
	}

	if( lARGDUMP() )
		fprintf(stderr,"[%d]< %s\n",getpid(),file);

	strsubst(file,"${ETCDIR}",etcdir);
	strsubst(file,"${ADMDIR}",admdir);
	strsubst(file,"${LOGDIR}",logdir);
	strsubst(file,"${ACTDIR}",tmpdir);
	strsubstDirEnv(file,dgroot,vardir);
	strsubst(file,"${PROTO}",proto);
	strsubst(file,"${PORT}",port);
	strsubst(file,"${PID}",pid);

	if( lARGDUMP() )
		fprintf(stderr,"[%d]> %s\n",getpid(),file);

	if( rvardir != NULL ) strsubstDE(rvardir,vardir,dgroot,vardir);
	if( rlogdir != NULL ) strsubstDE(rlogdir,logdir,dgroot,vardir);
	if( rtmpdir != NULL ) strsubstDE(rtmpdir,tmpdir,dgroot,vardir);
}
static _setTMPDIR(dir)
	char *dir;
{	char tmpdir[1024];

	if( dir == NULL )
		dir = DELEGATE_TMPDIR;
	if( dir == NULL || *dir == 0 )
		return;

	strcpy(tmpdir,dir);
	substfile(tmpdir,"",NULL,NULL,NULL);
	setTMPDIR(tmpdir);
}

static char *logfmtpart(path)
	char *path;
{	char *dp;

	if( dp = strrchr(path,':') )
		if( strchr(dp,'%') )
			return dp;
	return NULL;
}

static ScanLogs(Conn,proto)
	Connection *Conn;
	char *proto;
{	char *env,logspec[1024],*path,*fmt;
	char tmp[1024],*dp;

	_setTMPDIR(getEnv(P_TMPDIR));

	if( env = getEnv(P_SYSLOG) )
		open_syslog(env);

	if( ( env = getEnv(P_LOGFILE) ) == 0 )
		env = DELEGATE_LOGFILE;
	LOG_create("delegate",LF_LOGFILE,"-",env,"a",0);

	if( ( env = getEnv(P_ERRORLOG) ) == 0 )
		env = DELEGATE_ERRORLOG;
	LOG_create("delegate",LF_ERRORLOG,"-",env,"a",0);

	if( ( env = getEnv(P_ABORTLOG) ) == 0 )
		env = DELEGATE_ABORTLOG;
	setAbortLog(env);

	if( !IamPrivateMASTER && execSPECIAL == 0 ){
		if( ( env = getEnv(P_PROTOLOG)) == 0 )
			env = DELEGATE_PROTOLOG;

		/*
		 *   PROTOLOG=[//host:port][/path][:format]
		 */

		strcpy(logspec,env);
		path = logspec;

		if( fmt = logfmtpart(logspec) ){
			*fmt++ = 0;
			if( path[0] == 0 ){
				strcpy(tmp,DELEGATE_PROTOLOG);
				path = tmp;
				if( dp = logfmtpart(path) )
					*dp = 0;
			}
		}else	fmt = "";

		if( !BORN_SPECIALIST || streq(proto,"http") || streq(proto,"https") )
			LOG_create("http",LF_PROTOLOG,fmt,path,"a",1);
		if( !BORN_SPECIALIST || streq(proto,"ftp") )
			LOG_create("ftp", LF_PROTOLOG,"-",path,"a",1);
		scanEnv(Conn,P_LOG,scan_LOG);
	}
	LOG_openall();
}

static int scannedGlobal;
extern int PERMIT_WITH_SRCHOST;
extern char *DELEGATE_SMTPGATE;
int rescanGlobal;

#define ScanGlobal(Conn,proto) DELEGATE_ScanGlobal(Conn,proto)
ScanGlobal(Conn,proto)
	Connection *Conn;
	char *proto;
{	char *env;

	if( scannedGlobal && !rescanGlobal )
		return;
	rescanGlobal = 0;
	scannedGlobal = 1;

	if( env = getEnv(P_MANAGER)  )	DELEGATE_MANAGER = env;
	if( env = getEnv(P_ADMIN)  )	DELEGATE_MANAGER = env;
	scanEnv(Conn,P_TIMEOUT, scan_TIMEOUT);
	scanEnv(Conn,P_MAXIMA,  scan_MAXIMA);
	scanEnv(Conn,P_CHARCODE,scan_CHARCODE);
	if( env = getEnv(P_MIMECONV) ) scan_MIMECONV(env);

	scanEnv(Conn,P_PORT,  scan_PORT);
	scanEnv(Conn,P_VSAP,  scan_VSAP);

	scanEnv(Conn,P_CMAP,  scan_CMAP);
	ScanLogs(Conn,proto);
	scanEnv(Conn,P_ROUTE, scan_ROUTE);
	scanEnv(Conn,P_MASTER,scan_MASTER);
	scanEnv(Conn,P_PROXY, scan_PROXY);
	if( env = getEnv(P_SSLTUNNEL) )
		scan_SSLTUNNEL(env);
	scanEnv(Conn,P_ICPCONF,scan_ICPCONF);
	scanEnv(Conn,P_ICP,   scan_ICP);

	if( env = getEnv(P_SMTPSERVER) )
		scan_SMTPSERVER(env);
	if( env = getEnv(P_HTTPMAIL) )
		scan_HTTPMAIL(env);

	scanEnv(Conn,P_OWNER, scan_OWNER);
	scanEnv(Conn,P_AUTH,scan_AUTH);
	scanEnv(Conn,P_AUTHORIZER,scan_AUTHORIZER);
	scanEnv(Conn,P_PGP, scan_PGP);

	if( env = getEnv(P_REMITTABLE) )
		scanEnv(Conn,P_REMITTABLE,scan_PERMITX);
	if( env = getEnv(P_PERMIT) )
		scanEnv(Conn,P_PERMIT,scan_PERMITX);
	if( getEnv(P_REMITTABLE) == NULL && getEnv(P_PERMIT) == NULL )
		scan_PERMIT(Conn,defaultPERMIT(Conn));

	if( scanEnv(Conn,P_RELIABLE,scan_RELIABLE) == 0 )
		/*if( getEnv(P_PERMIT) == 0 )*/
		if( PERMIT_WITH_SRCHOST == 0 )
			scan_RELIABLE(Conn,DELEGATE_RELIABLE);
	scanEnv(Conn,P_REACHABLE,scan_REACHABLE);

	if( env = getEnv(P_RELAY) )
		scanEnv(Conn,P_RELAY,scan_RELAY);
	else	scan_RELAY(Conn,DELEGATE_RELAY);

	scanEnv(Conn,P_FILETYPE,scan_FILETYPE);
	scanEnv(Conn,P_HTTPCONF,scan_HTTPCONF);
	scanEnv(Conn,P_NNTPCONF,scan_NNTPCONF);
	scanEnv(Conn,P_DNSCONF, scan_DNSCONF);

	if( strcaseeq(proto,"smtp") ){
		if( env = getEnv(P_SMTPGATE) )
			scan_SMTPGATE(Conn,env);
		else	scan_SMTPGATE(Conn,DELEGATE_SMTPGATE);
	}

	if( env = getEnv(P_CGIENV) )
		scan_CGIENV(Conn,env);

	if( env = getEnv(P_DELAY) )
		scanEnv(Conn,P_DELAY,scan_DELAY);

	scan_FILTERS(Conn);
	if( env = getEnv(P_HTMLCONV) )  scan_HTMLCONV(env);
	if( env = getEnv(P_OVERRIDE) )	scan_OVERRIDE(env);
	scanEnv(Conn,P_CRON,scan_CRON);
}

extern int MAX_MAILSPLIT;
extern int HTTP_CKA_MAXREQ;
extern int HTTP_CKA_PERCLIENT;
extern int MAX_CC;
       int MAXCONN_PCH;
extern int MAX_BUFF_SOCKRECV;
extern int MAX_BUFF_SOCKSEND;

static maxima1(maxima)
	char *maxima;
{	char name[128];
	int num;

	if( sscanf(maxima,"%[^:]:%d",name,&num) != 2 ){
		ERRMSG("DeleGate/%s: ERROR syntax MAXIMA=%s\n",
			DELEGATE_ver(),maxima);
		return 0;
	}

	if( streq(name,"delegated") )	MAX_DELEGATE = num; else
	if( streq(name,"standby") )     STANDBY_MAX = num; else
	if( streq(name,"ftpcc") )	MAX_CC = num; else
	if( streq(name,"svcc") )	MAX_CC = num; else
	if( streq(name,"listen") )	DELEGATE_LISTEN = num; else
	if( streq(name,"sockrecv") )	MAX_BUFF_SOCKRECV = num; else
	if( streq(name,"socksend") )	MAX_BUFF_SOCKSEND = num; else
	if( streq(name,"service") )	MAX_SERVICE = num; else
	if( streq(name,"mailsplit") )	MAX_MAILSPLIT = num; else
	if( streq(name,"conpch") )	MAXCONN_PCH = num; else
	if( streq(name,"http-cka") )	HTTP_CKA_MAXREQ = num; else
	if( streq(name,"http-ckapch") )	HTTP_CKA_PERCLIENT = num; else
		ERRMSG("DeleGate/%s: ERROR unknown MAXIMA=%s\n",
			DELEGATE_ver(),maxima);

	return 0;
}
scan_MAXIMA(Conn,maxima)
	Connection *Conn;
	char *maxima;
{
	scan_commaList(maxima,0,maxima1);
}
static scan_HOSTS0(Conn)
	Connection *Conn;
{	static int init;
	char hosts[0x10000];

	if( init == 0 ){
		init = 1;
		scan_HOSTS(Conn,"localhost/127.0.0.1");
		scanEnv(Conn,P_HOSTS,scan_HOSTS);
		dump_HOSTS(hosts);
		Verbose("scanned HOSTS=%s\n",hosts);
	}
}

static ScanEachConn()
{	char *env;

	HAS_MASTER = getEnv(P_PROXY) || getEnv(P_MASTER) || getEnv(P_TUNNEL);

	if( BORN_SPECIALIST && HAS_MASTER )
			scan_FORCEON("all");
	if( env = getEnv(P_FORCEON)){
		if( HAS_MASTER)
			scan_FORCEON(env);
		else	sv1log("ERROR: FORCEON needs MASTER, PROXY or TUNNEL\n");
	}else	scan_FORCEON(DELEGATE_FORCEON);
}

#define WIN_PGROOT	"/Program Files"
#define WIN_DGROOT	"/Program Files/DeleGate"

static ScanDirDefs()
{	char *env;

	if( env = getEnv(P_DGROOT)  )
		DELEGATE_DGROOT = strdup(env);
	else
	if( DELEGATE_DGROOT == NULL || *DELEGATE_DGROOT == 0 )
	if( fileIsdir(WIN_PGROOT) )
		DELEGATE_DGROOT = strdup(WIN_DGROOT);

	if( env = getEnv(P_VARDIR)   )	DELEGATE_VARDIR = strdup(env);
	if( env = getEnv(P_LOGFILE)  )	DELEGATE_LOGFILE = strdup(env);
	if( env = getEnv(P_ERRORLOG) )	DELEGATE_ERRORLOG = strdup(env);
	if( env = getEnv(P_PIDFILE)  )  DELEGATE_PIDFILE = strdup(env);
	if( env = getEnv(P_PROTOLOG) ){
		char logspec[1024],*fmt;
		if( env[0] == ':' ){
			/* PROTOLOG="[Path]:Form" - Path part is omitted */
			strcpy(logspec,DELEGATE_PROTOLOG);
			if( fmt = logfmtpart(logspec) )
				*fmt = 0;
			strcat(logspec,env);
			env = logspec;
		}
		DELEGATE_PROTOLOG = strdup(env);
	}
}
static ScanFileDefs(Conn)
	Connection *Conn;
{	char *env;

	ScanDirDefs();
	if( env = getEnv("IMAGEDIR") )	DELEGATE_IMAGEDIR = strdup(env);

	if( env = getEnv(P_CACHEDIR) )	scan_CACHEDIR(strdup(env));
	if( env = getEnv(P_CACHEFILE))	scan_CACHEFILE(strdup(env));
	if( env = getEnv(P_CACHE)    )	scan_CACHE(Conn,env);
	if( env = getEnv(P_EXPIRE)   )  scanEnv(Conn,P_EXPIRE,scan_EXPIRE);
}

static REUSE_ENV()
{
	return (1 < CHILD_SERNO_MULTI);
}
#define config(Conn,csock)	DELEGATE_config(Conn,csock)
config(Conn,csock)
	Connection *Conn;
{	char *env;
	char *proto;

	if( REUSE_ENV() || lSYNC() ){
		Scan_SERVER(Conn);
		return;
	}

/*
if( env = getEnv(P_EXPIRE) )	scanEnv(Conn,P_EXPIRE,scan_EXPIRE);
- should clear dynamically added CMAP (using peak index of static CMAPs ?)
*/
	scan_HOSTS0(Conn);
	proto = Scan_SERVER(Conn);

	scanEnv(Conn,P_CONNECT,scan_CONNECT);
	ScanGlobal(Conn,proto);
	ScanEachConn();
	if( env = getEnv(P_DELEGATE) )	scan_DELEGATE(Conn,env);
	ScanFileDefs(Conn);
	mount_all(Conn,proto);
}

static PutPortFile(stayopen)
{	char *file;

	if( (file = getEnv(P_PIDFILE)) == 0 )
		file = DELEGATE_PIDFILE;
	if( LOG_createPortFile(file,stayopen) != 0 ){
		if( lLOCK() ){
			fprintf(stderr,"DeleGate: could not create lock.\n");
			Finish(-1);
		}
	}
}
static killServer(killspec)
	char *killspec;
{	char signame[64];
	char *file,path[1024];
	FILE *fp;
	int sig,pid,rcode;

	if( (file = getEnv(P_PIDFILE)) == 0 )
		file = DELEGATE_PIDFILE;
	strcpy(path,file);
	substfile(path,"",NULL,NULL,NULL);
	if( (fp = fopen(path,"r")) == NULL ){
		fprintf(stderr,"\"%s\": no active server on the port.\n",path);
		return -1;
	}

	signame[0] = 0;
	sscanf(killspec,"-%s",signame);
	if( strcaseeq(signame,"HUP") ) sig = SIGHUP; else
	if( strcaseeq(signame,"INT") ) sig = SIGINT; else
	sig = SIGTERM;

	pid = 0;
	fscanf(fp,"%d",&pid);
	fclose(fp);
	printf("\"%s\": kill(%d,SIG%s) = ",path,pid,sigsym(sig));
	fflush(stdout);

	if( 1 < pid ){
		errno = 0;
		rcode = Kill(pid,sig);
		if( rcode == 0 )
			printf("%d (%d) ** OK **",rcode,errno);
		else	printf("%d (%d) ** ERROR **",rcode,errno);
	}
	printf("\n");
	return rcode;
}

extern FILE *open_logfile();
static service_DB(clsock)
{	char *dbfile;
	FILE *db;

	if( (dbfile = getEnv(P_DBFILE)) == 0 )
		return -1;

	db = open_logfile(NULL,dbfile,"a+","");
	if( db == NULL )
		return -1;

	DBmanager(clsock,db);
	fclose(db);
	return 0;
}

extern int CACHE_READONLY;
extern char CLIF_HOSTPORT[];
extern char CLIF_HOST[];
extern int  CLIF_PORT;

static initConn(Conn,csock)
	Connection *Conn;
{
	ConnInit(Conn);
	Conn->cl.p_connected = 1;
	Conn->cl_sock = csock;
	CLsock = csock;
	Conn->ma_private = myPrivateMASTER | MASTERisPrivate;
	clear_DGconn(Conn);

	HostPortIFclnt(Conn,csock,CLIF_HOST,NULL,&CLIF_PORT);
	sprintf(CLIF_HOSTPORT,"%s:%d",CLIF_HOST,CLIF_PORT);

	if( CACHE_READONLY )
		DontWriteCache = 1;
}

extern char *DELEGATE_HOSTID;
static char *hostid_PATH;
HostId(addr)
	char *addr;
{	char path[2048];

	if( hostid_PATH == NULL ){
		strcpy(path,DELEGATE_HOSTID);
		substfile(path,"",NULL,NULL,NULL);
		hostid_PATH = strdup(path);
	}
	return ipno(hostid_PATH,addr);
}

static put_publiclog(addr)
	char *addr;
{	char route[256];

	/*sprintf(route,"%d/%d",HostId(myaddr),HostId(addr));*/
	sprintf(route,"%d",HostId(addr));
	flush_publiclog(route);
}

static setClientInfo(Conn,clSock,addr,clntinfo)
	Connection *Conn;
	Efd *clSock;
	char *addr,*clntinfo;
{	int port;
	char host[256],*user;

	if( port = getClientHostPortAddr(Conn,host,addr) ){
		if( (user = getClientUserH(Conn,host,0,port)) == NULL )
			user = "-";
		Conn->cl_count = ClientCountUp(user,host,addr,port);
	}else{
		user = "-";
		strcpy(host,"-");
		strcpy(addr,"0.0.0.0");
		Conn->cl_count = 0;
	}
	sprintf(clntinfo,"%s@[%s]%s:%d",user,addr,host,port);

	if( clSock->_remote ){
		sscanf(PeernameOf(clSock),"%[^:]:%d",
			TeleportHost,&TeleportPort);

		gethostbyAddr(TeleportHost,TeleportHost);

		sscanf(SocknameOf(clSock),"%[^:]:%d",
			TelesockHost,&TelesockPort);
	}
	if( TeleportHost[0] )
		sprintf(clntinfo+strlen(clntinfo),".-.%s:%d",
			TeleportHost,TeleportPort);

	daemonlog("E","(%d) accepted [%d] %s (%5.3fs)(%d)\n",
		NUM_PEERS+NUM_CHILDREN,
		getEfd(clSock),clntinfo, Time()-ACCEPT_TIME,Conn->cl_count);

	if( set_OWNER(Conn,host,port,user) < 0 )
		return -1;

	return 0;
}
static call_client1(Conn,clSock)
	Connection *Conn;
	Efd *clSock;
{	int clsock = getEfd(clSock);
	char addr[256],clntinfo[256];
	int count;

	int remote;
	char sockname[256],peername[256];

	if( *PeernameOf(clSock) == 0 ){
		remote = RIDENT_recv(clsock,sockname,peername);
		if( remote < 0 ){
			close(clsock);
			return;
		}
		setEfd(clSock,clsock,sockname,peername,remote);
	}

	if( execSPECIAL )
	sv1log(">>>>>>>> %s\n",execSPECIAL);

	beginGeneralist(Conn,clsock);

	if( execSPECIAL == FuncDBManager ){
		execSPECIAL = 0;
		Finish(service_DB(clsock));
	}
	if( execSPECIAL == FuncPutPUBLIC ){
		execSPECIAL = 0;
		Conn->from_myself = 1;/* no check because caused by myself */
		Finish(post_PUBLIC(Conn,getEnv(P_PUBLIC)));
	}
	if( execSPECIAL == FuncGetPUBLIC ){
		execSPECIAL = 0;
		Finish(keep_PUBLIC(Conn,clsock,getEnv(P_PUBLIC)));
	}

	ACC_REJECTED = 0;
	if( setClientInfo(Conn,clSock,addr,clntinfo) == 0 ){
		if( 0 < MAXCONN_PCH && MAXCONN_PCH < Conn->cl_count ){
			ACC_REJECTED = 1;
			sv1log("Too many connections(%d) %s\n",
				Conn->cl_count,clntinfo);
		}else	ExecGeneralist(Conn,clsock,clsock);
		count = ClientCountDown();
	}else	count = -1;

	daemonlog("E","disconnected [%d] %s (%5.3fs)(%d)\n",
		clsock,clntinfo, Time()-ACCEPT_TIME,count);

closeEfd(clSock);
/* when `clsock' is closed in execGeneralist(), LOG_flushall() will reuse
 * the fd slot, then the slot will be closed in main as `clsock'.
 * Therefore call closeEfd() to avoid it... X-<
 */

	if( Conn->xf_filters ){
		int pid,wi,done;
		done = 0;
		for( wi = 0; done == 0 && wi < 10; wi++ ){
			while( 0 < (pid = NoHangWait()) ){
				sv1log("CFI process ? [%d] done\n",pid);
				done++;
			}
			msleep(100);
		}
	}

	LOG_flushall();

	if( 0 <= LOG_center )
	if( have_publiclog() )
		put_publiclog(addr);
}

beginGeneralist(Conn,clsock)
	Connection *Conn;
{
	START_TIME1 = time(0);
	initConn(Conn,clsock);
	if( func_inetd(Conn,clsock) )
		rescanGlobal = 1;
	config(Conn,clsock);
	if( BORN_SPECIALIST )
		set_USER(Conn,clsock);
}
initDelegate1(Conn,fromC,toC)
	Connection *Conn;
{
	START_TIME1 = time(0);
	initConn(Conn,fromC);
	config(Conn,fromC);
}

callDelegate1(clsock,imsg,telehost,teleport)
	char *imsg,*telehost;
{	Connection ConnBuf, *Conn = &ConnBuf;

	initConn(Conn,clsock);
	config(Conn,clsock);
	DFLT_HOST[0] = 0; /* be Generalist ;-) */

	strcpy(TeleportHost,telehost);
	TeleportPort = teleport;

	if( imsg != NULL )
		DDI_pushCbuf(Conn,imsg,strlen(imsg));

	ExecGeneralist(Conn,clsock,clsock);
}

callSelf(clsock)
{	Connection ConnBuf, *Conn = &ConnBuf;

	initConn(Conn,clsock);
	config(Conn,clsock);
	Conn->from_myself = 1;
	return execGeneralist(Conn,clsock,clsock,-1);
}

static ExecGeneralist(Conn,fromC,toC)
	Connection *Conn;
{	int fpid;
	int rcode;

	fpid = insert_FCLIENTS(Conn,&fromC,&toC);
	rcode = execGeneralist(Conn,fromC,toC,-1);
	if( 0 < fpid ){
		Kill(fpid,SIGTERM);
		NoHangWait();
	}
	return rcode;
}

static env2str(seqno,svsock,clSock)
	char *seqno;
	Efd *clSock;
{	int logfd;

	logfd = curLogFd();
sprintf(seqno,"%d/%d/%d/%d/%d/%d/%d/%d/%d/%d/%d/%d/%d/%d/%d/%d/%s/%s/%d",
		SERVER_PORT(),
		IamPrivateMASTER,
		svsock,
		param_file,
		clSock->_fd,
		TOTAL_SERVED,
		SERNO(),
		NUM_CHILDREN,
		StickyReport[1],
		DBsock[1],
		DELEGATE_LINGER,
		logfd,
		LOG_type,
		myPrivateMASTER,
		AF_UNIX_DISABLE,
		RES_localdns,
		SocknameOf(clSock),
		PeernameOf(clSock),
		clSock->_remote
	);
}
static EXEC_client1(Conn,path,func,svsock,clSock)
	Connection *Conn;
	char *path,*func;
	Efd *clSock;
{	int clsock = getEfd(clSock);
	char from[1024];
	char seqno[128];
	char stime[32];
	char alive[32];
	char abuff[0x4000];
	char *av[256];
	char ac,ai;
	int port;
	int rcode;
	char *cpath;
	int pid;
	int pass_svsock;

	pass_svsock = func != NULL &&
		(  streq(func,FuncSTICKY) && !ViaVSAPassociator(-1)
		|| streq(func,FuncFunc) );

	env2str(seqno,svsock,clSock);
	Verbose("SEQNO: %s\n",seqno);

	ac = 0;
	av[ac++] = DeleGate1;
	av[ac++] = seqno;
	if( func != NULL ){
		av[ac++] = func;
		if( putPUBLIC ){
			char public[256];
			sprintf(public,"%s=%s",P_PUBLIC,putPUBLIC);
			av[ac++] = public;
			putPUBLIC = 0;
		}
	}else{
		scan_HOSTS0(Conn);
		strcpy(from,"src=");

/* getpeerName(clsock,from+4,PN_HOSTPORT); */
Conn->cl.p_connected = 1;
Conn->cl_sock = clsock;
if( port = getClientHostPort(Conn,from+4) )
sprintf(from+strlen(from),":%d",port);

		Verbose("%s\n",from);
		av[ac++] = from;
	}

	sprintf(stime,"%s=%d",P_START_TIME,START_TIME);
	av[ac++] = stime;
	sprintf(alive,"%s=%d",P_ALIVE_PEERS,NUM_CHILDREN);
	av[ac++] = alive;
	ac = DELEGATE_copyEnv(av,ac,path,abuff);
	av[ac++] = 0;

	if( !INHERENT_fork() ){
		setclientsock(clsock);
		if( pass_svsock )
			setserversock(svsock);
		return Spawnvp("EXEC_client1",path,av);
	}else{
		if( !pass_svsock )
			closeServPorts();
		Execvp("EXEC_client1",path,av);
	}
}

static jmp_buf exec_env;
static int idle_timer;
static int IDLE_TIMEOUT = 10*60;

static idleTIMEOUT()
{
	longjmp(exec_env,-1);
}
setTimeout()
{
	setTimer(idle_timer,IDLE_TIMEOUT);
}
static EXEC_client(Conn,path,func,clSock)
	Connection *Conn;
	char *path,*func;
	Efd *clSock;
{
	idle_timer = pushTimer("EXEC_client",idleTIMEOUT,0);
	if( setjmp(exec_env) == 0 ){
		if( lSYNC() ){
			call_client1(Conn,clSock);
		}else
		if( !lEXEC() && func == NULL ){
			call_client1(Conn,clSock);
		}else	EXEC_client1(Conn,path,func,-1,clSock);
		closedups(0);
	}else{
		sv1log("TIMEOUT of idling.\n");
	}
	popTimer(idle_timer);
}

static postPublic(Conn)
	Connection *Conn;
{
	EXEC_client(Conn,EXEC_PATH,FuncPutPUBLIC,NULL);
	Finish(-1);
}
static forkDB(Conn,dbfile)
	Connection *Conn;
	char *dbfile;
{	register int pid;
	Efd dbSockb,*dbSock = &dbSockb;

	if( dbfile == 0 )
		return 0;

	Socketpair(DBsock);
	if( (pid = Fork("DB")) != 0 ){
		close(DBsock[0]);
		return pid;
	}
	close(DBsock[1]);
	closeServPorts();

	setEfd(dbSock,DBsock[0],"","",0);
	EXEC_client(Conn,EXEC_PATH,FuncDBManager,dbSock);
	Finish(-1);
}
/*
 *	fork private MASTER if MASTER is not specified.
 *	this will be used for caching on {Gopher,FTP}/HTTP,
 *	and Connection Cache.
 */
static fork_MASTER(hostport,frominetd)
	char *hostport;
{	int svsock;
	int svport;
	char svhost[256];
	char *av[256];
	int ai,ac;
	register int pid;
	char *env,logtype[32],logfile[1024],port[128],oport[128];
	char what[128],master[1024];
	char permit[128];
	char *name,epath[1024];
	int closestdIO;

	svhost[0] = 0;
	svport = 0;
	sscanf(hostport,"%[^:]:%d",svhost,&svport);
	if( svhost[0] == 0 )
		GetHostname(svhost,sizeof(svhost));
	svsock = server_open("ftpget",svhost,svport,1);
	if( svsock < 0 )
		return -1;

	sockHostport(svsock,&svport);
	sprintf(hostport,"%s:%d",svhost,svport);

	printServPort(oport,"",0);

	ac = 0;
	if( name = strrpbrk(EXEC_PATH,"/\\") )
		name = name + 1;
	else	name = EXEC_PATH;
	av[ac++] = name;

	sprintf(what,"%s%s)",PrivateMasterOwner,oport);
	av[ac++] = what;
	sprintf(port,"-P0/%d",svsock);
	av[ac++] = port; 

	sprintf(logtype,"-L0x%x",LOG_type);
	av[ac++] = logtype;
	sprintf(logfile,"%s=%s++",P_LOGFILE,oport);
	av[ac++] = logfile; 

	ac += DELEGATE_copyEnvPM(&av[ac],NULL);

	if( getEnv(P_MASTERP) )
		ac += DELEGATE_copyEnvPM(&av[ac],P_MASTER);

	sprintf(permit,"%s=*:*:{.,localhost}",P_PERMIT);
	av[ac++] = permit;
	sprintf(epath,"%s=%s",P_EXEC_PATH,EXEC_PATH);
	av[ac++] = epath;
	av[ac] = 0;

	if( closestdIO = frominetd || IamCGI ){
		sv1log("## private-MASTER: frominetd=%d IamCGI=%d (%d,%d,%d)\n",
			frominetd,IamCGI,
			fileno(stdin),fileno(stdout),fileno(stderr));
	}

	if( !INHERENT_fork() ){
		if( closestdIO ){
			av[ac++] = "CLOSE-STDIO";
			av[ac] = 0;
		}
		setserversock(svsock);
		pid = Spawnvp("fork_MASTER",EXEC_PATH,av);
	}else{
		pid = Fork("private-MASTER");
		if( pid == 0 ){
			LOG_closeall();
			if( closestdIO ){
				fclose(stdin);
				fclose(stdout);
				fclose(stderr);
			}
			closeServPorts();
			Execvp("fork_MASTER",EXEC_PATH,av);
		}
	}
	close(svsock);
	return pid;
}

static unsetEnv(dav,sav,what)
	char *dav[],*sav[],*what;
{	char *arg;
	int len,ai,ac;

	len = strlen(what);
	ac = 0;
	for( ai = 0; sav[ai]; ai++ ){
		arg = sav[ai];
		if( strncmp(arg,what,len) == 0 )
			if( arg[len] == '=' || arg[len] == 0 )
				continue;
		dav[ac++] = arg;
	}
	dav[ac] = 0;
	return ac;
}
static filterEnv(dav,sav)
	char *dav[],*sav[];
{	char *arg;
	int ai,ac;

	ac = 0;
	for( ai = 0; sav[ai]; ai++ ){
		arg = sav[ai];
		if( strncmp(arg,"CONNECT=",8) == 0 ) continue;
		if( strncmp(arg,"MASTERP=",8) == 0 ) continue;
		if( strncmp(arg,"MASTER=",7) == 0 ) continue;
		if( strncmp(arg,"-P",2) == 0 ) continue;
		dav[ac++] = sav[ai];
	}
	dav[ac] = 0;
	return ac;
}
static execWithPrivateMASTER(hostport)
	char *hostport;
{	char *av[256],port[128],master[128],masterp[128];
	int ac;

	ac = 0;
	if( 1 <= main_argc )
		av[ac++] = main_argv[0];
	av[ac++] = port; printServPort(port,"-P",1);
	av[ac++] = master; sprintf(master,"%s=%s",P_MASTER,hostport);
	av[ac++] = masterp;
	sprintf(masterp,"_masterp=%d",myPrivateMASTER);

	filterEnv(&av[ac],&main_argv[1]);
	filterEnv(environ,environ);

	if( !INHERENT_fork() ){
		setserversock(ServSock());
		Spawnvp("with-private-MASTER",EXEC_PATH,av);
		ServerPID = 0;
		closeServPorts();
		wait(0);
	}else	Execvp("with-private-MASTER",EXEC_PATH,av);
}
static addPrivateMASTER(Conn,hostport)
	Connection *Conn;
	char *hostport;
{
	pushEnv(P_MASTER,hostport);
	scan_MASTER(Conn,hostport);

	if( getEnv(P_CONNECT) == NULL ){
		char *conn1,*conn2;
		conn1 = "c,i,d,v,s:{http,https}:*";
		conn2 = "c,i,m,d:*:*";
		if( without_cache() ){ /* ignore cache "c," */
			conn1 += 2;
			conn2 += 2;
		}
		pushEnv(P_CONNECT,conn1);
		pushEnv(P_CONNECT,conn2);
	}
}
static forkMaster(Conn,frominetd)
	Connection *Conn;
{	char *env,hostport[256];

	hostport[0] = 0;
	if( env = getEnv(P_MASTERP) ){
		strcpy(hostport,env);
	}else
	if( getEnv(P_MASTER) || getEnv(P_PROXY) )
		return 0;

	if( myPrivateMASTER = fork_MASTER(hostport,frominetd) ){
		if( getEnv(P_MASTERP) || getEnv(P_TUNNEL) )
			execWithPrivateMASTER(hostport);
		else	addPrivateMASTER(Conn,hostport);
		sv1log("private-MASTER forked: %s [%d]\n",
			hostport,myPrivateMASTER);
	}
	return 1;
}

static Efd clientSocks[2];

static finalize()
{
	killChildren();
	StickyKill(SIGHUP);
	kill_CC();
	deleteWORKDIR();
}
int (*DELEGATE_TERMINATE)() = finalize;

#define ACC_FAILED	-1
#define ACC_TIMEOUTED	-2

extern int (*STORE_DB)();

static _main();
int (*DELEGATE_MAIN)() = _main;

static char *ABMwhere = "";
static void sigALRM()
{
	sv1log("AcceptByMain: Frozen (%s) ? try restart...\n",ABMwhere);
	sigHUP(0);
	Finish(-1);
}

/* do substitution for ${xxx} like ${VARDIR} ? */
char *absPathParam(param,prefix)
	char *param,*prefix;
{	char name[128],*vp,*rpath,apath[2048],*dp;
	char xparam[2048];
	int nonexist;

	if( (vp = strchr(param,'=')) == 0 )
		return 0;
	sscanf(param,"%[^=]",name);
	rpath = vp + 1;
	if( *rpath == 0 )
		return 0;

	if( isFullpath(rpath) )
		return 0;

	{	char cwd[1024];
		char *PATHSEP = "/";
		getcwd(cwd,sizeof(cwd));
		sprintf(apath,"%s%s%s",cwd,PATHSEP,rpath);
	}

	sprintf(xparam,"%s%s=%s",prefix,name,apath);
	if( nonexist = !File_is(apath) ){
		if( dp = strpbrk(apath," \t") ){
			*dp = 0;
			nonexist = !File_is(apath);
		}
		if( nonexist )
			fprintf(stderr,"CAUTION: nonexistent \"%s\"\n",xparam);
	}
	return strdup(xparam);
}
substArgvAbstpath(ac,av)
	char *av[];
{	int ai;
	char *a1,*xa;

	for( ai = 0; ai < ac; ai++ ){
		a1 = av[ai];
		if( strchr(a1,'=') == 0 )
			continue;
		xa = 0;
		if( strncmp(a1,  "+/",2) == 0 ) xa = absPathParam(a1+2,""); else
		if( strncmp(a1,"-e+/",4) == 0 ) xa = absPathParam(a1+4,"-e");
		if( xa )
			av[ai] = xa;
	}
}
main(ac,av)
	char *av[];
{	int code;
	char *root;

	main_argc = ac;
	main_argv = dupv(av,0);
	substArgvAbstpath(ac,av);
	ScanFileDefs(&MainConn);

	if( root = getEnv(P_CHROOT) ){
		if( chroot(root) != 0 ){
			fprintf(stderr,"DeleGate: chroot(%s) failed.\n",root);
			exit(-1);
		}
	}

	LOG_stdlogfile = logfile;
	LOG_substfile  = substfile;
	syslog_init();

	DO_INITIALIZE(ac,av);
	code = (*DELEGATE_MAIN)(ac,av);
	Finish(code);
}
static _main(ac,av)
	char *av[];
{	FILE *fp;
	int clsock;
	Efd *clSock = clientSocks;
	register int pid;
	char *name,*func,*ext,funcbuf[128];
	char *env;
	char *proto;
	Connection *Conn = &MainConn;
	int xcode;
	int frominetd,isafilter,isteleportd;
	int cnt;
	int lastaccept;
	int restart;
	int IamServer;
	int Fopt;
	int isFunc;
	int ai;

	main_argc = ac;
	main_argv = dupv(av,0);

	ACCEPT_TIME = Time();
	/* STORE_DB = storeDB; */
	signal(SIGHUP,SIG_IGN);

	if( isFullpath(av[0]) )
		strcpy(EXEC_PATH,av[0]);
	else	wordscan(av[0],EXEC_PATH);
	if( name = strrpbrk(EXEC_PATH,"/\\") )
		name = name + 1;
	else	name = EXEC_PATH;

	Fopt = 0;
	if( (func = getEnv(P_FUNC)) == 0 )
		func = name;
	for( ai = 1; ai < ac; ai++ ){
		if( strncmp(av[ai],"-F",2) == 0 ){
			func = &av[ai][2];
			Fopt = 1;
		}
	}

	if( (ext = strcasestr(func,".exe")) && ext[4] == 0 ){
		strcpy(funcbuf,func);
		*strcasestr(funcbuf,".exe") = 0;
		func = funcbuf;
	}

	if( strstr(func,"cgi") )
		IamCGI = 1;

	START_TIME1 = time(0);

	if( strncmp(func,"kill",4) == 0 ){
		scan_args(ac,av);
		killServer(func+4);
		Finish(0);
	}

	isFunc = DELEGATE_subfunc(Conn,ac,av,func,Fopt,0);

	frominetd = fromInetd();
	isafilter = 0;
	isteleportd = streq(func,"teleportd");
	IamPrivateMASTER = 0;

	if( !isFunc && !isteleportd )
	if( ac < 2 && !frominetd && !IamCGI )
	{	char yn[128];

		put_identification(stderr);
		fprintf(stderr,"Do configuration ? y / [n] : ");
		fflush(stderr);
		fgets(yn,sizeof(yn),stdin);
		if( yn[0] != 'y' && yn[0] != 'Y' )
			exit(0);
		fprintf(stderr,"-------------------------\n");
		fprintf(stderr,"INTERACTIVE CONFIGURATION\n");
		fprintf(stderr,"-------------------------\n");
		editconf1(&ac,&av,stdin,stderr);
	}

	if( !isFunc || isteleportd )
	if( !IamCGI )
	if( !streq(EXEC_PATH,DeleGate1) ) /* is the parent delegated */
	{
		setEXEC_PATH();
		/* should ProcTitileInit[exec()] before some files are opened */
		checkIfSolaris();
		ac = ProcTitleInit(EXEC_PATH,ac,av);

		if( env = getEnv(P_DGPATH) )
			DELEGATE_DGPATH = env;
		scan_DGPATH(DELEGATE_DGPATH);

		/* scan_args() should be after exec() in ProcTitleInit()
		 * to avoid repetitive script loading */
		ac = scan_args(ac,av);
		reopenLogFile(); /* reopen LOGFILE with a proper PORT number */

		_setTMPDIR(getEnv(P_TMPDIR));
		if( !IamPrivateMASTER ){
			new_shared();
			if( env = getEnv(P_INPARAM) )
				new_param_file(env);

			if( !frominetd ){
				if( fromRsh() ){
					if( authRsh() != 0 )
						Finish(-1);
				}
				if( getEnv(P_INETD) == NULL )
				if( getEnv(P_CRON) == NULL )
					setupDefaultPort();
				if( TeleportTunnel )
					setTeleportMASTER(Conn);
			}
			if( frominetd ){
				isafilter = 1;
				inetdServPort();
			}
		}
	}

	if( getEnv(P_INETD) ){
		scanEnv(Conn,P_INETD,scan_INETD);
		/* "port stream tcp nowait owner SERVER=exec XFIL=... */
		/* "port stream tcp nowait owner SERVER=exec XCOM=... */
		/* "port stream tcp wait owner SERVER=... */
		/* PollIns(ports) */
		/* wait -- don't accept, just exec */
		/* nowait -- accept and exec */
	}

/*
	set_LOCKFILE();
*/
	init_inets(name,getEnv(P_RESOLV),
		getEnv(P_RES_CONF),getEnv(P_RES_NS),getEnv(P_RES_VRFY),
		getEnv(P_RES_RR),
		getEnv(P_RES_DEBUG),
		getEnv(P_RES_LOG),getEnv(P_SOCKS),DELEGATE_pushEnv);
	scan_RIDENT(getEnv(P_RIDENT));
	isFunc = DELEGATE_subfunc(Conn,ac,av,func,Fopt,1);

	if( streq(EXEC_PATH,DeleGate1) )
	{
		_setTMPDIR(getEnv(P_TMPDIR));/* for Resolvy cache originally */
		signal(SIGTERM,sigTERM1);
		signal(SIGINT, sigTERM1);
		signal(SIGHUP, sigTERM1);
		Exec_client(Conn,ac,av);
		Finish(0);
		fprintf(stderr,"\n[%d] DeleGate: exit from DeleGate1 failed.\n",
			getpid());
		return;
	}

	if( LOG_sockio[0] < 0 ){
		Socketpair(LOG_sockio);
		setNonblockingIO(LOG_sockio[1],1);
	}

	LOG_sock_enable = 1;
	putSTART();

	START_TIME = time(0);
	settty();

	scan_HOSTS0(Conn);
	if( env = getEnv(P_TIMEOUT)) scanEnv(Conn,P_TIMEOUT,scan_TIMEOUT);
	if( env = getEnv(P_MAXIMA))  scanEnv(Conn,P_MAXIMA,scan_MAXIMA);

/* check UDP before mkEntrance */
proto = Scan_SERVER(Conn);
if( streq(proto,"cuseeme") ) DELEGATE_LISTEN = -1;
if( streq(proto,"udprelay") ) DELEGATE_LISTEN = -1;
if( streq(proto,"icp") ) DELEGATE_LISTEN = -1;
if( streq(proto,"dns") ) DELEGATE_LISTEN = -1;
if( streq(proto,"teleport") ) isteleportd = 1;

	if( !isteleportd )
	if( env = getEnv(P_LOGCENTER) )
		setLOGCENTER(env);

	/* 940930 beDaemon() moved before the TUNNEL_open to let
	 *        PGID of TUNNEL processes to be that of delegated.
	 */
	if( !lFG() && !lSYNC() )
	if( !IamPrivateMASTER )
	if( !TeleportTunnel )
	if( !IamCGI )
	if( activeServPort() == 0 )
		beDaemon(Conn);

	if( SERVER_PORT() == 0 )
		if( isteleportd ){
			unsetDefaultPort();
			setSERVER_PORT(8000,-1);
		}

	if( streq(proto,"udprelay1") ){
		extern int IO_TIMEOUT;
		IO_TIMEOUT = 60;
		if( getEnv(P_CONNECT) == NULL )
			scan_CONNECT(Conn,"udp");
		setServUDP();
	}

	/*
	 * makeEntrance() is here to, may be(-_-;, to avoid giving
	 * SVsock to TUNNEL processes.
	 */
	scanEnv(Conn,P_VSAP,scan_VSAP);
	if( !ViaVSAPassociator(-1) ) /* NOT to accept at remote associator */
	if( !IamCGI ){
		makeEntrance();
		putREADY(isafilter);
	}
	RES_isself(ServSock());

	/*
	 * makeEntrance() should be before set_Owner() to use privireged port.
	 */
	if( set_Owner(1,getEnv(P_OWNER),curLogFd()) < 0 )
		Finish(-1);
	mkdirForSolaris(); /* should be after set_Owner() */
	proto = Scan_SERVER(Conn);

	/* These should be done after "SERVER" scanned
	 * (to use DFLT_PROTO in defaultPERMIT() ?)
	 */
	ScanGlobal(Conn,proto);
	if( !IamPrivateMASTER ){
		checkMANAGER(Conn,proto);
		ScanFileDefs(Conn);
		if( checkCACHEDIR(Conn) != 0 )
			Finish(-1);
	}

	if( env = getEnv("LINGER") ) DELEGATE_LINGER = atoi(env);
	ServerPID = getpid();
	gotoWORKDIR();
	if( env = getEnv(P_PUBLIC) ){
		if( pid = Fork("PUBLIC") )
			PublicPID = pid;
		else	postPublic(Conn);
	}
	mount_all(Conn,proto);


	if( env = getEnv(P_TUNNEL) ){
		sv1log("SET TUNNEL AS MASTER: %s\n",env);
		scan_MASTER(Conn,"tty7:0/teleport");
	}

	/* forkDB should be after setuid() in checkMANAGER() */

	if( IamPrivateMASTER ){
		int ai;
		for( ai = 0; ai < ac; ai++ )
			svlog("> arg[%d] %s\n",ai,av[ai]);
		/*
		somthing wrong (accept lock failure?)(at NNTP/HTTP proxy?)
		3.0.59: YES. lLOCK() was turned off in setupForSolaris()
		*/
		setStickyParams(Conn,proto);

	}else{
		if( env = getEnv(P_DBFILE) )
			DbasePID = forkDB(Conn,env);

		if( env = getEnv("_masterp") ){
			myPrivateMASTER = atoi(env);
		}else
		if( streq(proto,"http") )
			forkMaster(Conn,frominetd);

		if( !lFORK() )
			setStickyParams(Conn,proto);

		ScanFileDefs(Conn);
		ScanEachConn(Conn);
		/*load_resources(Conn);*/
	}

	if( !isteleportd )
	if( IamPrivateMASTER || myPrivateMASTER == 0 )
		TeleportPID = TeleportServer(getEnv(P_TUNNEL),getEnv(P_INVITE));

	if( !streq(proto,"http") )
		PEEK_CLIENT_REQUEST = 0;

	if( 0 < StickyMAX_PARA )
		PutPortFile(1);
	else	PutPortFile(0);

	signal(SIGURG, sigURG);
	signal(SIGBUS, sigFATAL);
	signal(SIGSEGV,sigFATAL);
	signal(SIGPIPE,sigPIPE);
	signal(SIGTERM,sigTERM);
	signal(SIGINT, sigTERM);
	if( TeleportTunnel )
		signal(SIGHUP, sigTERM);
	else	signal(SIGHUP, sigHUP);

	if( StickyReport[0] < 0 || StickyReport[1] < 0 )
		Socketpair(StickyReport);

	pid = 0;
	DELEGATE_dumpEnv(NULL,1,IamPrivateMASTER);
	setLastModified();

	Verbose("Accept-LOCK: %d\n",LOG_type & L_LOCK);
	StickyProcs = (int*)calloc(StickyMAX_PARA+1,sizeof(int));

	sv0log("--INITIALIZATION DONE--\n");
	LOG_sock_enable = 0;

	if( streq(proto,"cuseeme") ){
		service_cuseeme(Conn,ServSock(),SERVER_PORT());
		Finish(0);
	}
	if( streq(proto,"icp") ){
		service_icp(Conn,ServSock(),SERVER_PORT());
		Finish(0);
	}
	if( streq(proto,"dns") ){
		dns_init(SERVER_PORT());
		service_domain(Conn,ServSock(),SERVER_PORT());
		Finish(0);
	}
	isFunc = DELEGATE_subfunc(Conn,ac,av,func,Fopt,2);
	if( DELEGATE_LISTEN <= 0 ){
		udp_relay(Conn,ServSock());
		goto EXIT;
	}

	if( isafilter )
		if( execOnetimeFilter(Conn,clSock) == 0 )
			goto EXIT;

	if( !IamPrivateMASTER && getpid() == ServerPID ){
		if( myPrivateMASTER ){
			/* wait the private-MASTER ready */
		}
		if( fromRsh() && SERVER_PORT() != 0 ){
			RshWatcher(NUM_HUPS,SERVER_PORT());
		}
	}

	lastaccept = time(0);

	if( SERVER_RESTART ){
		int now;
		char date[64];

		now = time(0);
		if( 3600*24 <= SERVER_RESTART )
			restart = timeBaseDayLocal(now) + SERVER_RESTART;
		else	restart = ((now/SERVER_RESTART)+1) * SERVER_RESTART;
		StrftimeLocal(date,sizeof(date),TIMEFORM_HTTPD,restart);
		sv1log("RESTART at %s\n",date);
	}

	IamServer = (getpid() == ServerPID);
	if( IamServer )
		set_CC();

	if( frominetd ){
		/* NDELAY may be left ON by former user of the socket */
		SetNonblockingIO("svsock",ServSock(),0);
		set_listen(ServSock(),0,DELEGATE_LISTEN);
	}

	signal(SIGALRM,sigALRM);
	for(cnt = 1;;cnt++){
		int idle,timeout,logtimeout,svsock;
		char sockname[256],peername[256];
		int now,sched_next;

		cleanup_zombis(0);
		if( restartPrivateMASTER ){
			restartPrivateMASTER = 0;
			if( IamServer ){
				sigHUP(0);
				break;
			}
		}

		load_params(Conn);

		TOTAL_SERVED = CHILD_SERNO_SINGLE + StickyNserved; 

		if( IamPrivateMASTER && getppid() != IamPrivateMASTER ){
			sv1log("private-MASTER DONE: OWNER seems dead. %d/%d\n",
				getppid(),IamPrivateMASTER);
			break;
		}

		if( MAX_SERVICE ){
			if( MAX_SERVICE <= TOTAL_SERVED ){
				sv1log("MAX_SERVICE done: %d\n",MAX_SERVICE);
				break;
			}
		}

		now = time(0);
		if( SERVER_TIMEOUT ){
			idle = now - lastaccept;
			if(  SERVER_TIMEOUT < idle ){
				sv1log("SERVER_TIMEOUT: %d seconds.\n",idle);
				break;
			}
		}

		ProcTitle(Conn,"+%d",NUM_CHILDREN);
		logtimeout = logTimeout();
		if( 0 < NUM_CHILDREN || PublicPID != 0 || IamPrivateMASTER ){
			timeout = 60;
			if( logtimeout != 0 && logtimeout < timeout )
				timeout = logtimeout;
		}else{
			timeout = logtimeout;
			if( timeout <= 0 )
				timeout = 0;
		}

		if( SERVER_RESTART ){
			int rstimeout;

			rstimeout = restart - now;
			if( timeout == 0 || rstimeout < timeout ){
				timeout = rstimeout;
				if( timeout <= 0 ){
					sigHUP(0);
					break;
				}
			}
		}

		if( SERVER_TIMEOUT )
		if( timeout == 0 || SERVER_TIMEOUT < timeout )
			timeout = SERVER_TIMEOUT;

if( !IamPrivateMASTER && IamServer )
if( timeout <= 0 || 15 < timeout )
timeout = 15;

sched_next = sched_execute(now,sched_action,Conn);
if( now < sched_next && sched_next-now < timeout )
	timeout = sched_next-now;

if( RESTART_NOW ){
	RESTART_NOW = 0;
	sigHUP(0);
	break;
}

		/*putStatus("Accept(%d,1,%d): nch=%d\n",ServSock(),timeout,
			NUM_CHILDREN);*/

		if( DELEGATE_PAUSE ){
			sleep(10);
			continue;
		}

		if( 0 < SIGALRM ) alarm(300);
		clsock = AcceptByMain(timeout,&svsock,clSock);
		if( 0 < SIGALRM ) alarm(0);

		if( clsock < 0 ){
			/*putStatus("TIMEOUT\n");*/
			LOG_checkAged(0);
			if( PublicPID )
				cleanup_zombis(0);
			if( RestartPublic ){
				RestartPublic = 0;
				if( pid = Fork("restart-PUBLIC") )
					PublicPID = pid;
				else	postPublic(Conn);
			}
			if( clsock != ACC_TIMEOUTED )
				msleep(ACC_BYMAIN_INTERVAL);
			continue;
		}else{
			if( lSYNC() ){ 
				CHILD_SERNO_MULTI++;
			}else	CHILD_SERNO++;
		}

		lastaccept = time(0);
		/*putStatus("Accepted[%d]\n",CHILD_SERNO);*/

		if( lSYNC() ){
			StickyNserved++;
			EXEC_client(Conn,EXEC_PATH,NULL,clSock);
			initConn(Conn,-1);
		}else
		if( !lEXEC() && StickyActive < StickyMAX_PARA ){
			pid = forkStickyServer(Conn,svsock,clSock);
			StickyAdd(pid);
			NUM_CHILDREN++;
		}else{
			pid = forkOnetimeServer(Conn,svsock,clSock,isafilter);
			if( pid == -1 ){
				sv1tlog("CANNOT FORK\n");
				sleep(10);
			}else{
				NUM_CHILDREN++;
				CHILD_SERNO_SINGLE++;
				/*putStatus("Forked[%d]: nch=%d pid=%d\n",
					CHILD_SERNO,NUM_CHILDREN,pid);*/
			}
		}
		closeEfd(clSock);
	}

EXIT:
	if( 0 < StickyActive )
		wait(0);
	finalize();
	Exit(0,"");
}

forkStickyServer(Conn,svsock,clSock)
	Connection *Conn;
	Efd *clSock;
{	int clsock = getEfd(clSock);
	int pid;

	if( !INHERENT_fork() ){
		setcontrolsock(StickyReport[1]);
		pid = EXEC_client1(Conn,EXEC_PATH,FuncSTICKY,svsock,clSock);
		return pid;
	}

	if( pid = Fork("SequentialServer") )
		return pid;
	close(StickyReport[0]); StickyReport[0] = -1;
	NUM_PEERS = NUM_CHILDREN;
	StickyServer(Conn,clSock,StickyMAX_LIFE);
	Finish(0);
}
forkOnetimeServer(Conn,svsock,clSock,isafilter)
	Connection *Conn;
	Efd *clSock;
{	int clsock = getEfd(clSock);
	int pid;

	if( !INHERENT_fork() ){
		pid = EXEC_client1(Conn,EXEC_PATH,NULL,-1,clSock);
		return pid;
	}

	if( pid = Fork("OnetimeServer") )
		return pid;

	if( !isafilter )
		closeServPorts();
	close(StickyReport[0]); StickyReport[0] = -1;
	ProcTitle1();
	NUM_PEERS = NUM_CHILDREN;
	EXEC_client(Conn,EXEC_PATH,NULL,clSock);
	Finish(0);
}

putSTART()
{	char uname[128];
	char inetd[128],rsh[128];

	Uname(uname);
	if( fromInetd() )
		sprintf(inetd,"[viaInetd]");
	else	inetd[0] = 0;
	if( fromRsh() )
		sprintf(rsh,"[viaRsh]");
	else	rsh[0] = 0;

	sv0log("--INITIALIZATION START: %s on %s--%s%s\n",
		DELEGATE_ver(),uname,inetd,rsh);
}
putREADY(isafilter)
{	char msg[1024],port[128];

	printServPort(port,"-P",0);
	sprintf(msg,"<%s> [%d] %s READY\n",DELEGATE_version(),
		getpid(),port);
	svlog("%s",msg);
	if( !isafilter )/* suppress the banner if from inetd */
	if( isatty(fileno(stderr)) || fromRsh() ){
		fputs(msg,stderr);
		fprintf(stderr,"%s\r\n",DELEGATE_copyright());
	}

	printServPort(port,"",1);
	if( TeleportTunnel )
		sv1log("PORT= 0 TeleportTunnel dummy=%s\n",port);
	else	sv1log("PORT= %s\n",port);
}
setEXEC_PATH()
{	char *env;

	if( env = getEnv(P_EXEC_PATH) )
		strcpy(EXEC_PATH,env);
	else	FullpathOfExe(EXEC_PATH);
}
setLOGCENTER(center)
	char *center;
{	char host[256],ifhost[256],hostport[256];
	int port;

	if( *center == 0 )
		center = DELEGATE_LOGCENTER;
	port = 8000;
	sscanf(center,"%[^:]:%d",host,&port);
	gethostnameIFIF(ifhost,sizeof(ifhost));
	LOG_center = UDP_client_open1("frog","frog",host,port,
			ifhost,SERVER_PORT());
	setCloseOnExec(LOG_center);

	/*
	gethostName(LOG_center,hostport,PN_ADDRPORT);
	put_publiclog("I","DeleGate.Start %s\n",hostport);
	*/
}
execOnetimeFilter(Conn,clSock)
	Connection *Conn;
	Efd *clSock;
{	char hostn[256];
	int hosta,port;

	if( getpeerNAME(0,hostn,&hosta,&port) ){
		/* connected, in nowait mode from inetd */
		svlog("ONE-TIME SERVER(in nowait mode from inetd).\n");
		setEfd(clSock,0,"","",0);
		EXEC_client(Conn,EXEC_PATH,NULL,clSock);
		return 0;
	}
	return -1;
}
setTeleportMASTER(Conn)
	Connection *Conn;
{	char master[256];

	sprintf(master,"tty7:0/teleport:!*");
	scan_MASTER(Conn,master);
	pushEnv(P_INVITE,"*");
}


static int ACC_NONE_TIMEOUT = 60;

static int lockedoutN;
static int lockedoutT;
static int lastserveN;
static int lastdoneN;

static breakStickies(shlock)
{	int idle;
	int timeout;

	ABMwhere = "breaking";
	timeout = StickyTIMEOUT;
	if( timeout < 10 ) timeout = 10; else
	if( 60 < timeout ) timeout = 60;

	sv1log("AcceptByMain: Wait Frozen Sticky*%d become active ...\n",
			StickyActive);

	if( lock_exclusiveTO(shlock,timeout,NULL) == 0 ){
		lock_unlock(shlock);
		idle = time(0) - lockedoutT;
		sv1log("AcceptByMain: Frozen Sticky*%d become active (%ds)\n",
			StickyActive,idle);
		return;
	}

	/* Try normal termination first.  Sending SIGHUP is not harmful
	 * for Stickies because they are blocking the signal during
	 * the execution of its service for a client.
	 */
	if( StickyKill(SIGHUP) ){
		sleep(5);
		cleanup_zombis(1);
	}

	sv1log("AcceptByMain: Wait Frozen Sticky*%d cleaned by SIGHUP ...\n",
			StickyActive);

	if( lock_exclusiveTO(shlock,timeout,NULL) == 0 ){
		lock_unlock(shlock);
		idle = time(0) - lockedoutT;
		sv1log("AcceptByMain: Frozen Sticky*%d were cleaned (%ds)\n",
			StickyActive,idle);
		return;
	}

	idle = time(0) - lockedoutT;
	sv1log("AcceptByMain: KILL Frozen Sticky*%d (%ds) %d/%d\n",
		StickyActive, idle, StickyNserved,StickyDone);

	daemonlog("F","E-F: kill Frozen Sticky*%d (%ds)\n",StickyActive,idle);
	if( StickyKill(SIGKILL) ){
		sleep(5);
		cleanup_zombis(1);
	}

	idle = time(0) - lockedoutT;
	if( lock_exclusiveTO(shlock,timeout,NULL) == 0 ){
		sv1log("AcceptByMain: Frozen Sticky*%d were KILLED (%ds)\n",
			StickyActive,idle);
	}else{
		sv1log("AcceptByMain: couldn't KILL Frozen Sticky*%d (%ds)\n",
			StickyActive,idle);
		sv1log("AcceptByMain: #### restarting may fail... ####\n");
	}

	if( fromInetd() )
		sigTERM(0);
	else	sigHUP(0);
	Finish(-1);
}
static locked_out(shlock)
{	int now,idle,nserved,ndone,reset;
	int (*LF)(),svlog(),svvlog();

	now = time(0);
	reset = 0;
	if( ndone = StickyDone - lastdoneN ){
		lastdoneN = StickyDone;
		lockedoutT = now;
		reset = 1;
	}
	if( nserved = StickyNserved - lastserveN ){
		lastserveN = StickyNserved;
		lockedoutT = now;
		reset = 1;
	}
	if( lockedoutN == 0 ){
		lockedoutT = now;
		reset = 1;
	}

	idle = now - lockedoutT;
	if( ++lockedoutN % 10 == 0 || reset )
		LF = svlog;
	else	LF = svvlog;
	(*LF)("AcceptByMain: locked out*%d/%d by Sticky*%d %d/%d\n",
		lockedoutN,idle,StickyActive,nserved,ndone);

	/*
	 * A Sticky server possibly frozen in accept() ...
	 * Kill them and restart emulating SIGHUP.
	 */
	if( ACC_NONE_TIMEOUT < idle ){
		breakStickies(shlock);
		lockedoutT = time(0);
	}
}

AcceptByMain1(timeout,exlock,svsock,sockname)
	char *sockname;
{	int clsock;
	int shlock;

	shlock = PortLockFd();

	if( 0 < StickyActive && 0 <= shlock ){
		ABMwhere = "locking";
		if( lock_exclusiveNB(shlock) != 0 ){
			locked_out(shlock);
			return ACC_FAILED;
		}
		lockedoutN = 0;

		if( PollIn(svsock,1) <= 0 ){
			sv1log("AcceptByMain: yielded to a Sticky (%d)\n",
				StickyActive);
			lock_unlock(shlock);
			return ACC_FAILED;
		}
	}

	ABMwhere = "accepting1";
	clsock = ACCEPT1(svsock,1,exlock,1,sockname);
	ACCEPT_TIME = Time();
	if( clsock < 0 )
		sv1log("AcceptByMain[%d]: taken by a Sticky (%d)?\n",svsock,
			StickyActive);

	if( StickyActive && 0 <= shlock )
		lock_unlock(shlock);

	return clsock;
}
static int Ntimeout;
AcceptByMain(timeout,svsockp,clSock)
	int *svsockp;
	Efd *clSock;
{	int clsock;
	int sx,nready,sockv[64];
	int exlock,sock1;
	char primport[256];
	int udpv[64];
	char sockname[256],peername[256];
	int remote;

	if( ViaVSAPassociator(-1) ){
		clsock = VSAPbindaccept(timeout,1,sockname,peername);
		if( 0 <= clsock ){
			setEfd(clSock,clsock,sockname,peername,1);
		sv1log("AcceptByMain: VSAP[%s<-%s]\n",sockname,peername);
			return clsock;
		}
		sleep(5);
		return -1;
	}

	ABMwhere = "polling";
	gotSIGTERM = 0;
	nready = pollServPort(timeout*1000,sockv,udpv);
	if( nready <= 0 ){
		if( getpid() == ServerPID ){
			int host,port;

			port = -1;
			host = sockHostport(ServSock(),&port);
			if( host == -1 ){
				sv1log("RESTART ON RESUME ? %x:%d SIGTERM=%d\n",
					host,port,gotSIGTERM);
				if( gotSIGTERM )
					return ACC_FAILED;
				sleep(1);
				sigHUP(-1);
			}
		}
		if( Ntimeout == 0 )
		svvlog("AcceptByMain: TIMEOUT(children=%d, timeout=%d)\n",
			NUM_CHILDREN,timeout);
		Ntimeout++;
		return ACC_TIMEOUTED;
	}
	Ntimeout = 0;

	ABMwhere = "accepting";
	primaryPort(primport);
	for( sx = 0; sx < nready; sx++ ){
/*
if connected, then it is from VSAP server
 */
		sock1 = sockv[sx];
		if( lLOCK() )
			exlock = PortLocks(primport,0,NULL);
		else	exlock = -1;

		if( udpv[sx] ){
			clsock = UDPaccept(sock1,exlock,timeout);
			/* parallel accept of UDP does not work without
			 * SO_REUSEPORT.  So it must not inherited to
			 * StickyProcess...
			 */
			StickyMAX_PARA = 0;
		}else	clsock = AcceptByMain1(timeout,exlock,sock1,sockname);
		if( 0 <= clsock ){
			setEfd(clSock,clsock,sockname,"",0);
			*svsockp = sockv[sx];
			return clsock;
		}
	}

	return ACC_FAILED;
}
AcceptBySticky(timeout,shlock,exlock,clSock)
	Efd *clSock;
{	int clsock = -1;
	int sx,nready,sockv[64];
	int udpv[64];
	char sockname[256],peername[256];
	int remote;

	if( ViaVSAPassociator(-1) ){
		clsock = VSAPbindaccept(timeout,0,sockname,peername);
		if( 0 <= clsock ){
			setEfd(clSock,clsock,sockname,peername,1);
		sv1log("AcceptBySticky: VSAP[%s<-%s]\n",sockname,peername);
			return clsock;
		}
		sleep(5);
		return -1;
	}

	if( 0 <= shlock )
	if( lock_sharedTO(shlock,timeout*1000,NULL) != 0 ){
		sv1log("AcceptBySticky: lock timeout\n");
		return -1;
	}

	nready = pollServPort(timeout*1000,sockv,udpv);
	if( nready <= 0 )
		goto EXIT;

	for( sx = 0; sx < nready; sx++ ){
		if( udpv[sx] )
			clsock = UDPaccept(sockv[sx],exlock,timeout);
		else	clsock = ACCEPT(sockv[sx],1,exlock,timeout);
		if( 0 <= clsock )
			break;
	}
	ACCEPT_TIME = Time();
EXIT:
	if( 0 <= shlock )
		lock_unlock(shlock);

	if( 0 <= clsock ){
		remote = RIDENT_recv(clsock,sockname,peername);
		if( remote < 0 ){
			close(clsock);
			clsock = -1;
		}else{
			setEfd(clSock,clsock,sockname,peername,remote);
		}
	}
	return clsock;
}

static reportNserv(stat,start,nreq)
	char *stat;
{	char nconn;

	/* might get SIGALRM in accept(), free accept lock immediately */
	if( PortLockFd() != -1 )
		close(PortLockFd());

	nconn = CHILD_SERNO_MULTI + nreq;
	signal(SIGPIPE,SIG_IGN);
	write(StickyReport[1],&nconn,1);

	sv1log("StickyServer done [%s] %d req / %d conn / %d sec\n",
		stat,CHILD_SERNO_MULTI+nreq,CHILD_SERNO_MULTI,time(0)-start);
	Finish(0);
}
static void sigHUPforAbort(sig){
	closeServPorts();
	sv1log("StickyServer SIGHUPed after %d services.\n",CHILD_SERNO_MULTI);
	Finish(0);
}
static isStickyProto(Conn)
	Connection *Conn;
{	int nntps,otimeout;
	char *proto;

	if( IsInternal ) return 1;

	proto = DFLT_PROTO;
	if( strcaseeq(iSERVER_PROTO,"socks") )  return 1;
	if( strcaseeq(proto,"vsap") )  return 1;
	if( strcaseeq(proto,"http") )	return 1;
	if( strcaseeq(proto,"gopher") )	return 1;
	if( strcaseeq(proto,"ftp") && IsAnonymous ) return 1;

	if( localPathProto(proto) && IsLocal )
	if( streq(iSERVER_PROTO,"http") )
		return 1;

	if( strcaseeq(proto,"nntp") || strcaseeq(proto,"ftp") )
	if( streq(iSERVER_PROTO,"http") && !ACT_GENERALIST )
		 return 1;

	return 0;
}
setStickyParams(Conn,proto)
	Connection *Conn;
	char *proto;
{
	if( streq(proto,"http")
	 || streq(proto,"vsap")
	 || streq(proto,"socks")
	 || BORN_SPECIALIST == 0 ){
		StickyMAX_PARA = MAX_DELEGATE;
		StickyMAX_LIFE = STANDBY_MAX * 4;
		StickyTIMEOUT  = STANDBY_TIMEOUT;
	}
}

StickyServer(Conn,clSock,max)
	Connection *Conn;
	Efd *clSock;
{	int clsock;
	int omask;
	int timer;
	int mypid,ppid,ouid,ogid;
	char *stat,statb[128];
	int shlock,exlock,madelock;
	char port[256];
	int start0,start,now,till;
	int nreq;
	int sx;
	char sockname[256],peername[256];

	mypid = getpid();
	ppid = getppid();
	ouid = getuid();
	ogid = getgid();

	signal(SIGHUP,sigHUPforAbort);
	NUM_CHILDREN = 0;
	nreq = 0;

	start = start0 = time(0);
	omask = sigblock(sigmask(SIGHUP));
	{
		CHILD_SERNO_MULTI = 1;
		ProcTitle1();
		setCloseOnTimeout(StickyTIMEOUT);
		EXEC_client(Conn,EXEC_PATH,NULL,clSock);
		closeEfd(clSock);
	}
	sigsetmask(omask);

	madelock = 0;
	for(;;){
		if( 0 < REQUEST_SERNO ){
			nreq += REQUEST_SERNO - 1;
			REQUEST_SERNO = 0;
		}
		if( max <= CHILD_SERNO_MULTI ){
			stat = "natural";
			break;
		}
		if( INTERRUPT_STICKY ){
			stat = "interrupted";
			break;
		}
		if( BREAK_STICKY ){
			stat = "broken";
			break;
		}
		if( !ACC_REJECTED && !isStickyProto(Conn) ){ /* generalist */
			stat = "nonStickyProtocol";
			sprintf(statb,"%s(%s:%s:%s)",stat,
				iSERVER_PROTO,DFLT_PROTO,DST_PROTO);
			stat = statb;
			break;
		}
		if( getpid() != mypid ){
			/* may be forkd in sendDistribution() */
			sv1log("#### not the Sticky server process, EXIT.\n");
			Finish(0);
		}
		if( getppid() != ppid || getuid() != ouid || getgid() != ogid ){
			stat = "parentChanged";
			break;
		}
		if( !ViaVSAPassociator(-1) )
		if( activeServPort() == 0 ){
			stat = "serverSocketClosed";
			break;
		}

		now = time(0);
		if( 120 < (now - start) ){
			stat = "lifeSpan1";
			break;
		}
		start = now;

		initConn(Conn,-1);
		Verbose("StickyServer: start accept()\n");
		till = now + StickyTIMEOUT;
		ProcTitle(Conn,"(standby=%02d:%02d)",(till%3600)/60,till%60);

		if( !madelock ){
			madelock = 1;
			shlock = PortLockReopen();
			if( lLOCK() )
				exlock = PortLocks(primaryPort(port),0,NULL);
			else	exlock = -1;
		}
		clsock = AcceptBySticky(StickyTIMEOUT,shlock,exlock,clSock); 

		if( clsock < 0 ){
			stat = "acceptFailed";
			break;
		}

		omask = sigblock(sigmask(SIGHUP));
		{
			CHILD_SERNO_MULTI++;
			setCloseOnTimeout(StickyTIMEOUT);
			EXEC_client(Conn,EXEC_PATH,NULL,clSock);
			closeEfd(clSock);
			cleanup_zombis(1);
		}
		sigsetmask(omask);
	}
	reportNserv(stat,start0,nreq);
}

static str2env(seqno,svsockp,clSock,lfdp)
	char *seqno;
	int *svsockp;
	Efd *clSock;
	int *lfdp;
{	int ac,port;
	int isock;
	int clsock;
	char sockname[256],peername[256];
	int remote;

	clsock = -1;
	*svsockp = -1;
	sockname[0] = peername[0] = 0;
	ac =
sscanf( seqno,"%d/%d/%d/%d/%d/%d/%d/%d/%d/%d/%d/%d/%d/%d/%d/%d/%[^/]/%[^/]/%d",
		&port,
		&IamPrivateMASTER,
		svsockp,
		&param_file,
		&clsock,
		&TOTAL_SERVED,
		&CHILD_SERNO,
		&NUM_PEERS,
		&StickyReport[1],
		&DBsock[1],
		&DELEGATE_LINGER,
		lfdp,
		&LOG_type,
		&MASTERisPrivate,
		&AF_UNIX_DISABLE,
		&RES_localdns,
		sockname,
		peername,
		&remote
	);
	if( lVERB() )
		LOG_VERBOSE = 1;

	if( 0 < (isock = getclientsock()) )
		clsock = isock;
	if( 0 <= clsock )
	setEfd(clSock,clsock,sockname,peername,remote);

	if( 0 < (isock = getserversock()) )
		*svsockp = isock;

	if( 0 < (isock = getcontrolsock()) )
		StickyReport[1] = isock;

	if( 0 <= *svsockp )
	setSERVER_PORT(port,*svsockp);
	return ac;
}

static recvEnv(Conn,ac,av,svsockp,clSock)
	Connection *Conn;
	char *av[];
	int *svsockp;
	Efd *clSock;
{	int av1ac;
	int lfd;
	char *env;

	lfd = -1;
	if( (av1ac = str2env(av[1],svsockp,clSock,&lfd)) < 3 ){
		if( env = getEnv(P_EXEC_ENV) )
			av1ac = str2env(env,svsockp,clSock,&lfd);
		else	av1ac = 0;
	}
	if( 0 <= lfd )
	fdopenLogFile(lfd);
	return av1ac;
}

static SockIO(){ sio_relay(3,0,1,1,1); return 0; }
Exec_client(Conn,ac,av)
	Connection *Conn;
	char *av[];
{	int av1ac;
	int svsock;
	Efd *clSock = clientSocks;
	char *env;

	av1ac = recvEnv(Conn,ac,av,&svsock,clSock);

	if( env = getEnv(P_EXEC_PATH)  ) strcpy(EXEC_PATH,env);
	if( env = getEnv(P_START_TIME) ) START_TIME = atoi(env);
	if( env = getEnv(P_ALIVE_PEERS)) NUM_CHILDREN = atoi(env);

	if( 1 < ac ){
	  if( streq(av[1],FuncFILTER) )    Finish(callFilter(Conn,ac,av));
	  if( streq(av[1],FuncSOCKIO) )    Finish(SockIO(3,0,1,1,1));
	  if( streq(av[1],FuncSHIO) )      Finish(shiobar(av[2]));
	  if( streq(av[2],FuncDBManager) ) execSPECIAL = FuncDBManager;	else
	  if( streq(av[2],FuncPutPUBLIC) ) execSPECIAL = FuncPutPUBLIC;	else
	  if( streq(av[2],FuncGetPUBLIC) ) execSPECIAL = FuncGetPUBLIC;
	  if( streq(av[2],FuncSTICKY) ){
		setStickyParams(Conn,DFLT_PROTO);
		StickyServer(Conn,clSock,StickyMAX_LIFE);
		closeEfd(clSock);
		Finish(0);
	  }
	  if( streq(av[2],FuncFunc)) Finish(callFunc(Conn,ac,av,clSock,svsock));
	}

	if( av1ac < 3 )
		Exit(-1,"cannot get socket argument.\n");
	else{
		call_client1(Conn,clSock);
		closeEfd(clSock);
	}
}

keepPublic(Conn,public,clsock)
	Connection *Conn;
	char *public;
{	Efd clSockb, *clSock = &clSockb;

	if( *public == ' ' )
		public++;
	putPUBLIC = public;
	setEfd(clSock,clsock,"","",0);
	LOG_closeall();
	EXEC_client(Conn,EXEC_PATH,FuncGetPUBLIC,clSock);
	Finish(-1);
}

storeDB(key,val)
	char *key,*val;
{	register int pid;

	if( DBsock[1] < 0 )
		return;

	if( pid = Fork("storeDB") )
		StorePID = pid;
	else{
		if( 0 <= CLsock )
			close(CLsock);
		DBstore(DBsock[1],key,val);
		Finish(0);
	}
}

CallSrelay(sock,in,out)
{
	dup2(sock,3);
	dup2(in,0);
	dup2(out,1);
	execlp(EXEC_PATH,DeleGate1,FuncSOCKIO,0);
	Finish(-1);
}

CallShio(arg)
	char *arg;
{
	execlp(EXEC_PATH,DeleGate1,FuncSHIO,arg,0);
	Finish(-1);
}

static char *_workdir;
gotoWORKDIR()
{	char *wd;
	char *pp,wdir[1024],cwd[1024],var[1024],tmp[1024];
	FILE *fp;

	wd = (char*)getEnv(P_WORKDIR);
	if( wd == 0 ){
		if( lFG() || lSYNC() )
			return;
		else	wd = DELEGATE_WORKDIR;
	}
	strcpy(wdir,wd);
	substfile(wdir,"PROTOCOL",var,NULL,NULL);

	if( !isBoundpath(wdir) ){
		strcpy(tmp,wdir);
		sprintf(wdir,"%s/%s",var,tmp);
		if( lARGDUMP() )
			fprintf(stderr,"WORKDIR=%s\n",wdir);
	}

	mkdirR(wdir,0777);
	getcwd(cwd,sizeof(cwd));
	originWD = strdup(cwd);

	if( chdir(wdir) == 0 ){
		char pid[64];

		sv1log("%s=%s\n",P_WORKDIR,wdir);
		_workdir = strdup(wdir);
		sprintf(pid,"%d",getpid());
		if( fp = dirfopen("WORKFILE",pid,"w") )
			fclose(fp);
	}else{
		sv1log("ERROR can't goto %s=%s\n",P_WORKDIR,wdir);
	}
}
static char *workFiles[16];
static int workFileX;
makeWorkFile(path,type,file)
	char *path,*type,*file;
{
	sprintf(path,"${ACTDIR}/%s/%d.%s",type,getpid(),file);
	substfile(path,"",NULL,NULL,NULL);
	workFiles[workFileX++] = strdup(path);
}
deleteWORKDIR()
{	int pid;
	char pidfile[1024],*workfile,*dp;
	int tx;

	pid = getpid();
	if( _workdir ){
		sprintf(pidfile,"%s/%d",_workdir,pid);
		if( unlink(pidfile) == 0 ){
			sv1log("unlinked %s\n",pidfile);
			chdir("..");
			if( rmdir(_workdir) == 0 )
				sv1log("removed %s/\n",_workdir);
			else	sv1log("remove failed, errno=%d, %s\n",
					errno,_workdir);
		}
		_workdir = NULL;
	}
	for( tx = 0; workfile = workFiles[tx]; tx++ ){
		if( dp = strrpbrk(workfile,"/\\") )
			if( atoi(dp+1) == pid )
				unlink(workfile);
	}
}

static char *title_head;
extern char *Sprintf();
ProcTitleInit(path,ac,av)
	char *path;
	char *av[];
{	char title[4096];

	if( lEXEC() )
		return;

	ac = proc_title_init(EXEC_PATH,ac,av);
	wordscan(av[0],title);
	title_head = strdup(title);
	return ac;
}
ProcTitle1()
{	char title[4096];

	if( lEXEC() )
		return;

	sprintf(title,"DeleGate");
	if( title_head )
		free(title_head);
	title_head = strdup(title);
}

ProcTitle(Conn,fmt,a,b,c,d,e,f,g,h)
	Connection *Conn;
	char *fmt,*a,*b,*c,*d,*e,*f,*g,*h;
{	char buf[4096],*bp;
	char host[256];

	if( lEXEC() )
		return;

	bp = buf;
	if( title_head == 0 ){
		Verbose("ERROR: NO TITLE_HEAD SET\n");
		title_head = DeleGate1;
	}
	bp = Sprintf(bp,"%s ",title_head);
	if( Getpid() != ServerPID ){
		bp = Sprintf(bp,"-{%03d+%02d",CHILD_SERNO,CHILD_SERNO_MULTI);
		if( RequestSerno )
		bp = Sprintf(bp,"/%03d",RequestSerno);
		bp = Sprintf(bp,":");
	}else	bp = Sprintf(bp,"-{%03d/%03d+%03d:",CHILD_SERNO,StickyNserved,CHILD_SERNO_SINGLE);

/*
	if( !IamPrivateMASTER )
		bp = Sprintf(bp,"-P%d ",SERVER_PORT());
*/

	if( 0 < Conn->cl_sock )
		if( getClientHostPort(Conn,host) )
			bp = Sprintf(bp,"%s,",host);

	bp = Sprintf(bp,fmt,a,b,c,d,e,f,g,h);
	bp = Sprintf(bp,"}-");
	proc_title("%s",buf);
}

extern FILE *openStatusFile();
putStatus(fmt,a,b,c,d,e,f,g,h)
	char *fmt,*a,*b,*c,*d,*e,*f,*g,*h;
{	char *file;
	FILE *fp;

	if( file = getEnv("STATFILE") )
	if( fp = openStatusFile(file) ){
		/* fseek(fp,0,0); */
		fprintf(fp,"%d ",time(0));
		fprintf(fp,fmt,a,b,c,d,e,f,g,h);
		fflush(fp);
		/* Ftruncate(fp,0,1); */
	}
}

static printXdisplay(pxdisplay,pxhost,pxport,scrnum)
	char *pxdisplay,*pxhost;
{	char *pxaddr;

	if( pxaddr = gethostaddr(pxhost) )
		sprintf(pxdisplay,"%s:%d.%d",pxaddr,pxport-6000,scrnum);
	else	sprintf(pxdisplay,"%s:%d.%d",pxhost,pxport-6000,scrnum);
	sv1log("Xproxy -- %s:%d.%d -- %s\n",pxhost,pxport,scrnum,pxdisplay);
}
makeXproxy(Conn,pxdisplay,display,pxhost,relhost,me,timeo)
	Connection *Conn;
	char *pxdisplay,*display,*pxhost,*relhost,*me;
{	char *av[32];
	char port[256],timeout[256],server[256],permit[256],desc[256],*env;
	char connect[256];
	char vardir[1024],logdir[1024],logfile[1024];
	char disphost[128];
	int dispport,dispsock;
	int pxsock,pxport;
	int ac;
	int pid;
	int dispnum,scrnum;
	char cachepath[2048];
	FILE *cachefp;
	char hosts[0x4000];
	char clientid[256];

	dispnum = scrnum = 0;
	sscanf(display,"%[^:]:%d.%d",disphost,&dispnum,&scrnum);
	dispport = 6000+dispnum;

	sprintf(clientid,"pid-port-%s",relhost);
	if( cache_path("X",disphost,dispnum,clientid,cachepath) ){
		char line[256];

		sv1log("##[%s][%s] %s\n",display,relhost,cachepath);
		if( cachefp = fopen(cachepath,"r+") ){
			fgets(line,sizeof(line),cachefp);
			fclose(cachefp);

			/* cleanup zombis of previous X-proxy to make kill()==0
			 * work to sense the existence of the process */
			while( 0 < NoHangWait() )
				;

			if( sscanf(line,"%d %d",&pid,&pxport) == 2 )
			if( Kill(pid,SIGHUP) == 0 )
			{
				sv1log("REUSE X-PROXY for %s: port=%d pid=%d\n",
					relhost,pxport,pid);
				printXdisplay(pxdisplay,pxhost,pxport,scrnum);
				return pid;
			}
			/* should add "xhost" */
		}
	}

	pxsock = -1;
	for( pxport = 6010; pxport < 6100; pxport++ ){
		pxsock = server_open("Xpxdisplay",pxhost,pxport,1);
		if( 0 < pxsock )
			break;
	}
	if( pxsock < 0 )
		return 0;

	sockHostport(pxsock,&pxport);

	if( (pid = Fork("Xpxdisplay")) != 0 ){
		close(pxsock);
		printXdisplay(pxdisplay,pxhost,pxport,scrnum);
		return pid;
	}

	if( cachepath[0] ){
		if( cachefp = dirfopen("X-Proxy",cachepath,"w") ){
			fprintf(cachefp,"%d %d\n",getpid(),pxport);
			fclose(cachefp);
		}
		/* should read "xhost" and set it to PERMIT */
	}

	if( fromInetd() ){
		close(0);
		close(1);
	}
	closeServPorts();
	close(ToS);
	close(FromS);
	close(ToC);
	close(FromC);

	ac = 0;
	av[ac++] = EXEC_PATH;

	sprintf(port,"-P%d/%d",pxport,pxsock);
	av[ac++] = port;

	sscanf(display,"%[^:]:%d",disphost,&dispport);
	sprintf(server,"%s=X://%s:%d/",P_SERVER,disphost,6000+dispport);
	av[ac++] = server;

	if( timeo ){
		sprintf(timeout,"%s=daemon:%ds",P_TIMEOUT,timeo);
		av[ac++] = timeout;
	}

	unsetEnv(environ,environ,P_PERMIT);
	unsetEnv(environ,environ,P_RELIABLE);
	unsetEnv(environ,environ,P_REACHABLE);
	sprintf(permit,"%s=X:%s:%s",P_PERMIT,disphost,relhost);
	av[ac++] = permit;

	if( env = getEnv(P_CONNECT) ){
		sprintf(connect,"%s=%s",P_CONNECT,env);
		av[ac++] = connect;
	}

	if( lVERB() )
		av[ac++] = "-vv";
	if( env = getEnv(P_VARDIR) ){
		sprintf(vardir,"%s=%s",P_VARDIR,env);
		av[ac++] = vardir;
	}
	if( env = getEnv(P_LOGDIR) ){
		sprintf(logdir,"%s=%s",P_LOGDIR,env);
		av[ac++] = logdir;
	}
	if( env = getEnv(P_LOGFILE) ){
		sprintf(logfile,"%s=%s",P_LOGFILE,env);
		av[ac++] = logfile;
	}

	sprintf(desc,"(X proxy for %s)",me);
	av[ac++] = desc;

	strcpy(hosts,"HOSTS=");
	dump_HOSTS(hosts+strlen(hosts));
	av[ac++] = hosts;

	av[ac] = 0;
	Execvp("Xproxy",EXEC_PATH,av);
	Finish(0);
}



fdcheck(msg,waits)
	char *msg;
{	char fds[256],*fdp;
	int fd;

	fdp = fds;
	for( fd = 0; fd < 64; fd++ ){
		if( 0 <= file_uid(fd) ){
			sprintf(fdp,"[%2d]",fd);
			fdp += strlen(fdp);
		}
	}
	*fdp = 0;
	fprintf(stderr,"####[%d]%s ACTIVE FD: %s\n",getpid(),msg,fds);

	if( waits ){
		signal(SIGHUP, sigHUP);
		fprintf(stderr,"#### (%s) SLEEPING\n",msg);
		sleep(waits);
	}
}

static callFunc(Conn,ac,av,clSock,svsock)
	Connection *Conn;
	char *av[];
	Efd *clSock;
{	char *env;
	int (*func)();
	char *funcenv,*arg;
	int clsock;

	clsock = getEfd(clSock);
	config(Conn,clsock);

	funcenv = getenv("FUNCADDR");
	sscanf(funcenv,"%x",&func);
	arg = getenv("FUNCARG");
	Verbose("EXEC START: %d %d func=%x arg[%s]\n",
		clsock,svsock,func,arg);
	(*func)(Conn,clsock,svsock,ac,av,arg);
	Finish(0);
}
execFunc(Conn,clsock,svsock,func,arg)
	Connection *Conn;
	int (*func)();
	char *arg;
{	Efd clSockb,*clSock = &clSockb;
	char funcenv[32],argenv[4098];
	int pid;

	if( INHERENT_fork() )
		if( pid = fork() )
			return pid;

	if( Conn == NULL )
		Conn = &MainConn;

	sprintf(funcenv,"FUNCADDR=%x",func); putenv(funcenv);
	sprintf(argenv,"FUNCARG=%s",arg); putenv(argenv);

	Verbose("START EXEC: %d %d func=%x arg[%s]\n",
		clsock,svsock,func,arg);

	setEfd(clSock,clsock,"","",0);

	if( 0 <= clsock ) setclientsock(clsock);
	if( 0 <= svsock ) setserversock(svsock);
	pid = EXEC_client1(Conn,EXEC_PATH,FuncFunc,svsock,clSock);
	return pid;
}
