/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1994 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, modify, and distribute this material for any
purpose and without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies, and
that the name of ETL not be used in advertising or publicity pertaining
to this material without the specific, prior written permission of an
authorized representative of ETL.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	delegate.h
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	May1994	created
//////////////////////////////////////////////////////////////////////#*/
#include <string.h>
extern char *strstr();
extern char *strdup();
#include <stdio.h>
#include "ysocket.h"

extern char *MYSELF;	/* -.- */

extern char *DELEGATE_CONFIG;
extern char *DELEGATE_MANAGER;
extern char *DELEGATE_OWNER;
extern char *DELEGATE_G_PERMIT;
extern char *DELEGATE_S_PERMIT;
extern char *DELEGATE_HTTP_PERMIT;
extern char *DELEGATE_SOCKS_PERMIT;
extern char *DELEGATE_TELNET_PERMIT;
extern char *DELEGATE_RELAY;
extern char *DELEGATE_FORCEON;
extern char *DELEGATE_RELIABLE;
extern char *DELEGATE_DGPATH;

extern char SERV_HTTP[];
extern char SERV_GOPHER[];
extern char SERV_WAIS[];
extern char *PUBLIC_CENTER;
extern char *PUBLIC_DIR;

extern int   DELEGATE_LINGER;
extern char  DELEGATE_PROXY_HOST[];
extern int   DELEGATE_PROXY_PORT;
extern char *DELEGATE_DGROOT;
extern char *DELEGATE_WORKDIR;
extern char *DELEGATE_VARDIR;
extern char *DELEGATE_LOGDIR;
extern char *DELEGATE_ADMDIR;
extern char *DELEGATE_ETCDIR;
extern char *DELEGATE_UASFILE;
extern char *DELEGATE_LOGFILE;
extern char *DELEGATE_EXPIRELOG;
extern char *DELEGATE_ABORTLOG;
extern char *DELEGATE_PROTOLOG;
extern char *DELEGATE_PARAMFILE;
extern char *DELEGATE_ACTDIR;
extern char *DELEGATE_TMPDIR;
extern char *DELEGATE_PIDFILE;
extern char *DELEGATE_STATFILE;
extern int   DELEGATE_syncro;
extern char *DELEGATE_IMAGEDIR;
extern int   GOPHER_ON_HTTP;

extern char *TIMEFORM_mdHMS;
extern char *TIMEFORM_HTTPD;
extern char *TIMEFORM_GOPHER;
extern char *TIMEFORM_RFC822;

extern int   ENCODE_HTML_ENTITIES;
extern int   DECODE_HTML_ENTITIES;

extern char  DELEGATE_FLAGS[];
extern char *DELEGATE_CACHE;
extern int   CACHE_RDRETRY_INTERVAL;
extern int   CACHE_WRRETRY_INTERVAL;

extern char D_FROM[];
extern char D_USER[];
extern char D_SERVICE_BYPORT[];
extern char D_EXPIRE[];
extern char D_CHARSET[];
extern char D_SELECTOR[];
extern char D_GTYPE[];

extern char *my_HOSTPORT();
extern char iSERVER_PROTO[];
extern char iSERVER_HOST[];
extern int  iSERVER_PORT;

typedef struct {
	int	_closed;
	int	_fd;
	int	_remote;
	char	_sockname[256];
	char	_peername[256];
} Efd;
#define setEfd(efd,fd,sockname,peername,remote) \
	(efd==NULL?-1:((efd->_closed=0),(efd->_fd=fd),\
		strcpy(efd->_sockname,sockname), \
		strcpy(efd->_peername,peername), (efd->_remote=remote)))
#define getEfd(efd) \
	(efd==NULL?-1:(efd->_closed?-1: efd->_fd))
#define closeEfd(efd) \
	(efd==NULL?-1:(efd->_closed?-1:((efd->_closed=1),close(efd->_fd))))
#define SocknameOf(efd)	(efd->_sockname)
#define PeernameOf(efd)	(efd->_peername)

typedef struct {
	char   *r_proto;
	char   *r_host;
	int	r_port;
	char   *r_path;
	char   *r_base;
	char   *r_hostport;
	char   *r_my_proto;
	char   *r_my_host;
	int	r_my_port;
	char   *r_my_hostport;
	char   *r_my_path;
	char   *r_altbuf;
} Referer;

typedef struct {
	int	p_connected;
	double	p_connTime;
	int	p_bound;
	char	p_connFname[32];	/* Connection or Proxy-Connection */
	int	p_wantKeepAlive;
	int	p_willKeepAlive;
	int	p_sentKeepAlive;
	char	p_proto[64];
	char	p_site[256];	/* [user [:pass] @] host [:port] */
	char	p_host[128];
	int	p_port;
	char	p_user[64];
	int	p_anonymous;
	int	p_flags;
} Port;

typedef struct {
	Port	sv_dflt;	/* default server */
	Port	sv_real;	/* specified server */
	Port	sv_remote;	/* http://H:P/...=@=Rp:RH:RP */
	int	me_iamgw;
	int	me_norelay;
	int	sv_viaSocks;
	int	sv_viaVSAP;
	int	sv_viaCc;	/* via a connection cache proxy */
	int	sv_sock;
	int	sv_toS;
	int	sv_toSX;	/* escaped when TOSV filter inserted */
	int	sv_fromS;
	int	sv_fromSX;
	FILE   *sv_toServ;
	int	sv_toMaster;
	char	sv_toMasterVer[64];
	int	sv_imCC;	/* server connection holder */
	int	sv_imMaster;
	int	sv_imProxy;
	int	sv_toProxy;
	int	sv_mounted;
	int	sv_reqserno;	/* serial number of requests on the connetion */
	int	sv_ka_timeout;
	int	sv_ka_remalive;
	int	ma_private;
	char	ma_sayhello;
	char	ma_saidhello;
	char	ma_doack;	/* return ACK */
	char	ma_noack;	/* don't return ACK */
	char	cl_nosync;	/* don't flush DeleGate-HELLO */
	char	cl_noflush;
	char	cl_ver[32];	
	char	rident_sockhost[256];
	int	rident_sockport;
	char	rident_peerhost[256];
	int	rident_peerport;
	int	rp_sock;	/* RPORT: socket for response connection */
	int	rp_udp;

	Port	cl;
	char   *cl_user;
	char   *cl_HOST;	/* cache for getpeername() */
	char   *cl_ADDR;	/* cache for getpeername() */
	int	cl_PORT;	/* cache for getpeername() */
	char   *cl_USER;	/* cache for IDENT */
	char	cl_whyclosed[128];
	int	cl_count;
	int	xf_filters;
	int	xf_isremote;
	int	xf_echoreq;
	int	xf_stderr2out;
	void   *cl_reqbuf;
	int	cl_reqbufsize;

	char    cl_myhp[128];	/* client side interface */
	int	cl_sock;	/* directly connected with the client */
	int	cl_closed;
	int	cl_tcCLOSED;
	int	cl_fromC;	/* could be indirect */
	int	cl_toC;
	int	cl_sockHOST;	/* cache for getsockname(), DeleGate side IP */
	char	cl_sockHOSTname[128];
	char	cl_sockHOSTaddr[32];
	int	cl_sockHOSTport;
	char	cl_nocache;
	char	cl_expire[128]; /* EXPIRE specified at client side */
	char	cl_urlbase[128];/* base of referer's url-path */
	char	dg_modifier[256];
	char	iconbase[128];
	char	cl_rport[256];	/* RPORT specified by the client DeleGate */

	int	oc_isset;
	int	oc_norewrite;	/* the client seems to expect proxy server */
	int	oc_bydelegate;	/* accessed by /-_-URL notation */
	char	oc_proto[64];	/* that of the real originator client, */
	char	oc_proxy[128];	/* which is not proxy */

	char   *cl_FromCbuff;
	int	cl_FromCfill;
	int	cl_FromCpeak;
	int	cl_FromCread;

	int	dg_HOPS;
	int	dg_FTPHOPS;

	char	ma_SERVER[256];
	char   *ma_REQUEST;
	char   *cl_headerB[32];
	int	cl_headerX;
	char   *cl_inputsB[16];
	int	cl_inputsX;

	char	cl_auth_host[128];
	char	cl_auth_user[128];
	int	cl_noauth;

	Port	gw;
	char   *gw_path;

	char   *ca_objbuff;
	int	ca_objsize;

	int	ca_dontuse;
	int	ca_dontread;
	int	ca_dontwait;
	int	ca_dontwrite;
	int	ca_readonly;
	int	ca_only;
	int	ca_mtime;
	int	ca_lastmod;
	int	ca_reqwithcookie;
	int	ca_respwithcookie;

	int	ca_distsock;
	int	ca_distsock_open;
	int	ca_curoff;
	int	ca_receptorN;
	int	ca_receptors[32];
	int	ca_putoff[32];

	int	co_setup;
	char	co_type; /* type of current connection to the server */
	int	co_routex;
	int	co_nonet;
	int	co_nointernal;
	int	co_internal;
	int	co_local;
	int	co_direct;
	int	co_mask; /* CONN_NOPROXY, CONN_NOMASTER, ... */
	int	co_error;
	double	co_start;
	double	co_done;
	double	co_delay;

	int	born_specialist;
	int	act_generalist;
	int	meta_specialist;
	int	act_specialist;
	int	act_translator;
	int	relay_thru;
	int	path_added;
	Port	dl; /* born as GENERALIST but act as SPECIALIST */

	int	body_only;	/* for HTTP ... */
	int	from_myself;
	int	no_dstcheck;
	int	no_dstcheck_proto; /* destination protocol when MOUNTed */
	int	no_permission; 	/* error code ... */
	int	auth_check;
	int	permitGlobal;
	int	toMyself;

	int	ht_IsGopherSearch;
	int	ht_PadCRLF;
	int	ht_SimpleContType;
	char   *ht_LockedByClient;
	char	ht_stat;
	char	ht_statx;

	char   *mo_options;	/* MOUNTed, its options */
	Port	mo_master;	/* MASTER just for current MOUNT point */
	Port	mo_proxy;	/* PROXY just for current MOUNT point */

	int	(*fi_func)();
	int	fi_arglen;
	int	fi_iomode;	/* 0:input-filter, 1:output filter */
	short	fi_topeer;	/* the peer side connection (socket or pipe) */
	short	fi_issock;	/* fi_topeer is socket */
	short	fi_dupclsock;	/* do copy fi_topeer to cl_sock */
	short	fi_logfd;

	char	fi_what[32];
	short	fi_isresp;

	void	*cc_conv[2];	/* CCX context */
	char	cc_ccxbuf[2][32];
} Connection;

#define CCX		(Conn->cc_conv[0])
#define CCX_TOSV	(Conn->cc_ccxbuf[0])
#define CCX_TOCL	(Conn->cc_ccxbuf[1])

#define ToMyself	(Conn->toMyself)
#define CLIENTS_PROXY	(Conn->oc_proxy)
#define CLIENTS_PROTO	(Conn->oc_proto)
#define DONT_REWRITE	(Conn->oc_norewrite)
#define DO_DELEGATE	(Conn->oc_bydelegate)
#define IAM_GATEWAY	(Conn->me_iamgw)
#define RelayForbidden	(Conn->me_norelay)
#define RPORTsock	(Conn->rp_sock)
#define RPORTudp	(Conn->rp_udp)
#define TelesockHost	(Conn->rident_sockhost)
#define TelesockPort	(Conn->rident_sockport)
#define TeleportHost	(Conn->rident_peerhost)
#define TeleportPort	(Conn->rident_peerport)
#define RespNOSYNC	(Conn->cl_nosync)
#define RespNOFLUSH	(Conn->cl_noflush)

#define Modifier	(Conn->dg_modifier)
#define	D_HOPS		(Conn->dg_HOPS)
#define	D_FTPHOPS	(Conn->dg_FTPHOPS)

#define	FromCbuff	(Conn->cl_FromCbuff)
#define	FromCfill	(Conn->cl_FromCfill)
#define	FromCpeak	(Conn->cl_FromCpeak)
#define	FromCread	(Conn->cl_FromCread)

#define headerB		(Conn->cl_headerB)
#define headerX		(Conn->cl_headerX)
#define inputsB		(Conn->cl_inputsB)
#define inputsX		(Conn->cl_inputsX)
#define D_SERVER	(Conn->ma_SERVER)
#define D_REQUEST	(Conn->ma_REQUEST)
#define D_EXPIRE	(Conn->cl_expire)
#define PragmaNoCache	(Conn->cl_nocache)
#define D_RPORTX	(Conn->cl_rport)

#define ToServ		(Conn->sv_toServ)
#define FromSX		(Conn->sv_fromSX)
#define FromS		(Conn->sv_fromS)
#define ToSX		(Conn->sv_toSX)
#define ToS		(Conn->sv_toS)
#define FromC		(Conn->cl_fromC)
#define ToC		(Conn->cl_toC)
#define toProxy		(Conn->sv_toProxy)
#define toMaster	(Conn->sv_toMaster)
#define MediatorVer	(Conn->sv_toMasterVer)
#define ImMaster	(Conn->sv_imMaster)
#define ImProxy		(Conn->sv_imProxy)
#define IsMounted	(Conn->sv_mounted)
#define ImCC		(Conn->sv_imCC)

#define	MasterIsPrivate	(Conn->ma_private)
#define SayHello	(Conn->ma_sayhello)
#define SaidHello	(Conn->ma_saidhello)
#define ReturnACK	(Conn->ma_doack)
#define NoACK		(Conn->ma_noack)
#define ClientVER	(Conn->cl_ver)

#define GatewayProto	(Conn->gw.p_proto)
#define GatewayHost	(Conn->gw.p_host)
#define GatewayPort	(Conn->gw.p_port)
#define GatewayPath	(Conn->gw_path)

#define NoAuth		(Conn->cl_noauth)

#define DontUseCache	(Conn->ca_dontuse)
#define DontReadCache	(Conn->ca_dontread)
#define DontWaitCache	(Conn->ca_dontwait)
#define DontWriteCache	(Conn->ca_dontwrite)
#define CacheReadOnly	(Conn->ca_readonly)
#define CacheOnly	(Conn->ca_only)
#define CacheMtime	(Conn->ca_mtime)
#define CacheLastMod	(Conn->ca_lastmod)
#define ReqWithCookie	(Conn->ca_reqwithcookie)
#define RespWithCookie	(Conn->ca_respwithcookie)

#define ServConnTime	(Conn->sv_real.p_connTime)
#define ClntConnTime	(Conn->cl.p_connTime)

extern int BORN_SPECIALIST; /* communicates with a real client */

#define ACT_GENERALIST	(Conn->act_generalist)
#define META_SPECIALIST	(Conn->meta_specialist)
#define	ACT_SPECIALIST	(Conn->act_specialist)
#define	DELEGATE_LHOST	(Conn->dl.p_host)/* specialist directly interface with client */
#define RelayTHRU	(Conn->relay_thru)
#define	DELEGATE_LPORT	(Conn->dl.p_port)
#define ACT_TRANSLATOR	(Conn->act_translator)

#define ClientEOF	(Conn->cl_closed)
#define tcCLOSED	(Conn->cl_tcCLOSED)
#define ClientSock	(Conn->cl_sock)
#define CLNT_PROTO	(Conn->cl.p_proto)
#define CLNT_HOST	(Conn->cl.p_host)
#define CLNT_PORT	(Conn->cl.p_port)

#define ClientFlags	(Conn->cl.p_flags)
#define ServerFlags	(Conn->sv.p_flags)

#define ConnFname	(Conn->cl.p_connFname)
#define ClntKeepAlive	(Conn->cl.p_wantKeepAlive)
#define WillKeepAlive	(Conn->cl.p_willKeepAlive)
#define SentKeepAlive	(Conn->cl.p_sentKeepAlive)
#define WhyClosed	(Conn->cl_whyclosed)
#define EchoRequest	(Conn->xf_echoreq)
#define CLNT_USER	(Conn->cl_user)
#define _ClientHost	(Conn->cl_HOST)
#define _ClientAddr	(Conn->cl_ADDR)
#define _ClientPort	(Conn->cl_PORT)
#define _ClientUser	(Conn->cl_USER)
#define RequestSerno	(Conn->sv_reqserno)
#define CKA_Timeout	(Conn->sv_ka_timeout)
#define CKA_RemAlive	(Conn->sv_ka_remalive)

#define DFLT_PROTO	(Conn->sv_dflt.p_proto)
#define DFLT_HOST	(Conn->sv_dflt.p_host)
#define DFLT_PORT	(Conn->sv_dflt.p_port)

#define REAL_PROTO	(Conn->sv_real.p_proto)
#define REAL_HOST	(Conn->sv_real.p_host)
#define REAL_PORT	(Conn->sv_real.p_port)
#define REAL_USER	(Conn->sv_real.p_user)
#define REAL_SITE	(Conn->sv_real.p_site)
#define DST_USER	(REAL_USER[0] ? REAL_USER : NULL)
#define IsAnonymous	(Conn->sv_real.p_anonymous)

#define DST_PROTO	(REAL_HOST[0] ? REAL_PROTO : DFLT_PROTO)
#define DST_HOST	(REAL_HOST[0] ? REAL_HOST  : DFLT_HOST)
#define DST_PORT	(REAL_HOST[0] ? REAL_PORT  : DFLT_PORT)

#define REMOTE_PROTO	(Conn->sv_remote.p_proto)
#define REMOTE_HOST	(Conn->sv_remote.p_host)
#define REMOTE_PORT	(Conn->sv_remote.p_port)

#define ConnType	(Conn->co_type)
#define IsInternal	(Conn->co_internal)
#define IsLocal		(Conn->co_local)
#define CONN_START	(Conn->co_start)
#define CONN_DONE	(Conn->co_done)
#define ConnDelay	(Conn->co_delay)
#define PERMIT_GLOBAL	(Conn->permitGlobal)

#define IsGopherSearch	(Conn->ht_IsGopherSearch)
#define PadCRLF		(Conn->ht_PadCRLF)
#define SimpleContType	(Conn->ht_SimpleContType)
#define LockedByClient	(Conn->ht_LockedByClient)
#define httpStat	(Conn->ht_stat)
#define httpStatX	(Conn->ht_statx)

#define CO_REJECTED	1
#define CO_CANTRESOLV	2
#define CO_CANTCONN	4
#define CO_TIMEOUT	8
#define CO_REFUSED	0x10
#define CO_UNREACH	0x20
#define CO_CLOSED	0x100 /* logically closed (eg. by QUIT command) */

#define MountOptions	(Conn->mo_options)
#define MO_MasterHost	(Conn->mo_master.p_host)
#define MO_MasterPort	(Conn->mo_master.p_port)
#define MO_ProxyHost	(Conn->mo_proxy.p_host)
#define MO_ProxyPort	(Conn->mo_proxy.p_port)
#define withTmpProxy()	(MO_ProxyHost[0] && MO_ProxyPort)
#define withTmpMaster()	(MO_MasterHost[0] && MO_MasterPort)

/*
 *	GOPHER delegater
 */
extern int   GOPHER_EXPIRE;
extern char *GOPHER_CACHE_ITEM;

/*
 *	HTTP
 */
extern int   HTTP_EXPIRE;

/*
 *	FTP
 */
extern int FTP_ACCEPT_TIMEOUT;

/*
 *	Proxy Telnet/FTP
 */
extern int LOGIN_TIMEOUT;

extern FILE *dirfopen();
extern FILE *expfopen();
extern char *cachedir();
extern char *getenv();

extern char *DELEGATE_ver();
extern char *DELEGATE_version();
extern char *DELEGATE_Ver();
extern char *DELEGATE_Version();
extern char *DELEGATE_verdate();
extern char *DELEGATE_copyright();
extern char *DELEGATE_homepage();

extern char *fgetsTIMEOUT();

extern char *mount_url_to();
extern char *mount_url_from();

#define PN_LONG		"host=%A (%H); port=%P;"
#define PN_ADDRHOSTPORT	"%A %H %P"
#define PN_HOSTPORT	"%H:%P"
#define PN_ADDRPORT	"%A:%P"
#define PN_HOST		"%H"
#define PN_PORT		"%P"
#define PN_ADDR		"%A"

extern int   DELEGATE_LISTEN;

extern char *fgetsFromCbuf();
extern double Time();
extern double StartTime;

#ifndef Verbose
extern int LOG_VERBOSE;
#define	Verbose	LOG_VERBOSE==0 ? 0 : sv1vlog
#endif

extern int LOG_GENERIC;

extern char *CCV_TOCL;
extern char *CCV_TOSV;


/*
 *
 */
#define RELAY_NO	0x00 /* no relay (work as an orignal server) */
#define RELAY_PROXY	0x01 /* by CERN (full URL) */
#define RELAY_DELEGATE	0x06 /* by DELEGATE */
#define RELAY_DELEGATE1	0x02 /* by /=@=URL rewriting (obsolete) */
#define RELAY_DELEGATE2	0x04 /* by /-_-URL rewriting */
#define RELAY_SELF	0x10 /* rewrite request only */
#define RELAY_INLINE	0x20 /* rewrite inline images in response */
#define RELAY_PROTO	0x30 /* rewrite URLs of the same protocols */
#define RELAY_SERVER	0x40 /* rewrite URLS of the same saver */
#define RELAY_ANY	0x50

/*
 *
 */
#define XF_FFROMCL	0x001
#define XF_FTOCL	0x002
#define XF_FCL		0x004
#define XF_FFROMSV	0x010
#define XF_FTOSV	0x020
#define XF_FSV		0x040
#define XF_FFROMMD	0x100
#define XF_FTOMD	0x200
#define XF_FMD		0x400

#define XF_CLIENT	(XF_FFROMCL|XF_FTOCL|XF_FCL)
#define XF_SERVER	(XF_FFROMSV|XF_FTOSV|XF_FSV)
#define XF_MASTER	(XF_FFROMMD|XF_FTOMD|XF_FMD)


#define STR_VOLA	0
#define STR_ALLOC	1
#define STR_OVWR	2

#define CONN_NOPROXY	1
#define CONN_NOMASTER	2

extern char D_OVERRIDE[];
extern char D_RPORT[];
extern char D_PATH[];

