/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1994 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, modify, and distribute this material for any
purpose and without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies, and
that the name of ETL not be used in advertising or publicity pertaining
to this material without the specific, prior written permission of an
authorized representative of ETL.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	ddi.c (DeleGate to DeleGate interface)
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	950218	extracted from conf.c and service.c
//////////////////////////////////////////////////////////////////////#*/
#include "delegate.h"
char *malloc();
char *strdup();
#define PEEKSIZE 0x2000

DDI_clearCbuf(Conn)
	Connection *Conn;
{
if( FromCpeak != FromCfill )
sv1log("#### CLEAR CBUF: %d %d\n",FromCpeak,FromCfill);

	if( FromCbuff != NULL ){
		free(FromCbuff);
		FromCbuff = NULL;
	}
	FromCpeak = 0;
	FromCfill = 0;
	FromCread = 0;
}

DDI_pushCbuf(Conn,req,len)
	Connection *Conn;
	char *req;
{
	FromCfill = len;
	FromCbuff = malloc(len+1);
	bcopy(req,FromCbuff,len);
	FromCbuff[len] = 0;
	FromCpeak = 0;
}
char *DDI_fgetsFromCbuf(Conn,str,size,fp)
	Connection *Conn;
	char *str;
	FILE *fp;
{	char ch;
	int dx;

	if( size == 0 )
		return NULL;
	if( size == 1 ){
		str[0] = 0;
		return str;
	}

	dx = 0;
	if( FromCbuff && FromCpeak < FromCfill ){
		while( FromCpeak < FromCfill ){
			if( size-1 <= dx ){
sv1log("#### DDI_fgetsFromCbuf: over flow! %d / %d\n",dx,size);
				AbortLog();
				break;
			}
			ch = str[dx++] = FromCbuff[FromCpeak++];
			if( ch == '\n' )
				break;
		}
		str[dx] = 0;
		if( FromCpeak == FromCfill ){
			/* don't DDI_proceedFromC(Conn) for Solaris... */
		}
		return str;
	}
	return NULL;
}
DDI_readyCbuf(Conn)
	Connection *Conn;
{
	return FromCbuff && FromCpeak < FromCfill;
}

DDI_flushCbuf(Conn,bbuff,bsize,fc)
	Connection *Conn;
	char *bbuff;
	FILE *fc;
{	int bn;

	bn = 0;
	while( 0 < DDI_readyCbuf(Conn) ){
		if( DDI_fgetsFromCbuf(Conn,bbuff+bn,bsize-bn,fc) == NULL )
			break;
		bn += strlen(bbuff+bn);
	}
	return bn;
}

extern char *fgetsTIMEOUT();

int PEEK_CLIENT_REQUEST = 0;

DDI_proceedFromC(Conn,fp)
	Connection *Conn;
	FILE *fp;
{	char buff[PEEKSIZE];
	int len,rrc,rcc;
	int rcode = 0;

	if( 0 < FromCread ){
		len = FromCpeak;
		rrc = 0;
		while( 0 < len && 0 < ready_cc(fp) ){
			if( getc(fp) == EOF )
				break;
			len--;
			rrc++;
		}
		rcc = reads(fileno(fp),buff,len);

		sv1log("-- discard %d+%d = %d /%d/%d Bytes of peeked request\n",
			rrc,rcc,FromCpeak,FromCfill,FromCread);

		if( rrc+rcc != FromCpeak ){
			sv1log("#### discard failed: %d + %d / %d\n",
				rrc,rcc,FromCpeak);
			rcode = -1;
		}
		DDI_clearCbuf(Conn);
	}
	return rcode;
}

char *DDI_fgetsFromC(Conn,req,size,fp)
	Connection *Conn;
	char *req;
	FILE *fp;
{	char *rcode;
	int len;
	char buff[PEEKSIZE+1];
	int cc;

	if( size <= 0 ){
		sv1log("#### Negative size for DDI_fgetsFromC(%x,%d)\n",
			req,size);
		AbortLog();
		abort();
	}

	rcode = DDI_fgetsFromCbuf(Conn,req,size,fp);
	if( rcode != NULL ){
		if( strchr(req,'\n') != NULL )
			return rcode;
		else{
			len = strlen(req);
			return DDI_fgetsFromC(Conn,req+len,size-len,fp);
		}
	}

	cc = 0;
	if( ready_cc(fp) <= 0 )
	if( PEEK_CLIENT_REQUEST ){
		DDI_proceedFromC(Conn,fp);
		buff[0] = 0; /* a charm against Solaris2.X CC -O bug? */
		cc = recvPeekTIMEOUT(fileno(fp),buff,sizeof(buff)-1);

		if( 0 < cc ){
			FromCread = cc;
			Verbose("++ peek %d Bytes of request.\n",cc);
		}
	}
/*
else
if( 0 < PollIn(fileno(fp),2000) ){
	setNonblockingIO(fileno(fp),1);
	cc = readTIMEOUT(fileno(fp),buff,sizeof(buff)-1);
	setNonblockingIO(fileno(fp),0);
}
*/
/* switching NonBlocking seems halmful... e.g. http://www.opentext.com */

	if( 0 < cc ){
		buff[cc] = 0;
		DDI_pushCbuf(Conn,buff,cc);
		return DDI_fgetsFromC(Conn,req,size,fp);
	}

	rcode = fgetsTIMEOUT(req,size,fp);
	if( rcode == NULL )
		return NULL;
	else	return rcode;
}

int HAS_MASTER;

char CLIF_HOSTPORT[256];
char CLIF_HOST[256];
int  CLIF_PORT;

char D_FROM[256];
char D_USER[256];
char D_SELECTOR[1024];
char D_GTYPE[2];
char MODIFIERS[256];

char D_PATH[512];
char D_RPORT[128];
char D_OVERRIDE[256];

char *CCV_TOCL = "tocl";
char *CCV_TOSV = "tosv";
extern int CodeConv_x;
CCV_clear(){ CodeConv_x = 0; }


ConnInit(Conn)
	Connection *Conn;
{
	bzero((char*)Conn,sizeof(Connection));
	Conn->cl_sock = -1;
	ToS = ToSX = FromS = FromSX = -1;
	RPORTsock = -1;
}

/*
 *	environment per client's connection
 */
clear_DGconn(Conn)
	Connection *Conn;
{
	CLIF_HOSTPORT[0] = 0;
	CLIF_HOST[0]   = 0;
	CLIF_PORT      = 0;

	D_SERVER[0]    = 0;
	D_SELECTOR[0]  = 0;
	D_USER[0]      = 0;
	D_FROM[0]      = 0;
	D_PATH[0]      = 0;

	clear_DGreq(Conn);
}
/*
 *	environment per request
 */
clear_DGreq(Conn)
	Connection *Conn;
{
	DDI_clearCbuf(Conn);
	if( headerX ) clear_DGheader(Conn);
	if( inputsX ) clear_DGinputs(Conn);
	CCV_clear();
	reset_MOUNTconds();

	MODIFIERS[0]   = 0;
	D_GTYPE[0]     = 0;
	D_HOPS         = 0;
	IAM_GATEWAY    = 0;
}
clear_DGclnt(Conn)
	Connection *Conn;
{
	Conn->cl_sock = -1;
	clear_DGreq(Conn);
}
/*
 *	constant through keep-alive
 */
restoreConn(dst,src)
	Connection *dst,*src;
{
	dst->sv_dflt        = src->sv_dflt;
	dst->sv_real        = src->sv_real;

	dst->cl.p_wantKeepAlive = src->cl.p_wantKeepAlive;
	dst->cl.p_willKeepAlive = src->cl.p_willKeepAlive;
	dst->cl_whyclosed[0] = '-';
	dst->cl_nocache     = src->cl_nocache;
	dst->cl_reqbuf      = NULL;

	dst->ca_dontread    = src->ca_dontread;
	dst->ca_dontwrite   = src->ca_dontwrite;
	dst->ca_curoff      = 0;
	dst->ca_mtime       = 0;

	dst->co_setup       = 0;
	dst->co_nonet       = src->co_nonet;
	dst->co_nointernal  = src->co_nointernal;

	dst->xf_filters     = src->xf_filters;

	dst->sv_viaCc       = 0;
	dst->sv_viaSocks    = 0;
	dst->sv_viaVSAP	    = 0;
	dst->co_type        = 0;

	dst->co_internal    = 0;
	dst->mo_options     = 0;

	dst->cl_noauth      = 0;
	dst->cl_auth_user[0] = 0;
	dst->no_dstcheck_proto = 0;

	CCXclear(dst->cc_ccxbuf[0]);
	CCXclear(dst->cc_ccxbuf[1]);
}

add_DGheader(Conn,head,fmt,a,b,c,d,e,f,g)
	Connection *Conn;
	char *head;
	char *fmt,*a,*b,*c,*d,*e,*f,*g;
{	char line[4096];

	if( head == D_SERVER ) sprintf(D_SERVER,fmt,a,b,c,d,e,f,g); else
	if( head == D_FROM   ) sprintf(D_FROM,  fmt,a,b,c,d,e,f,g); else
	if( head == D_USER   ) sprintf(D_USER,  fmt,a,b,c,d,e,f,g); else
	if( head == D_PATH   ) sprintf(D_PATH,  fmt,a,b,c,d,e,f,g); else
	if( head == D_EXPIRE ) sprintf(D_EXPIRE,fmt,a,b,c,d,e,f,g); else
	{
		sprintf(line,"%s ",head);
		sprintf(line+strlen(line),fmt,a,b,c,d,e,f,g);
		strcat(line,"\r\n");
		headerB[headerX++] = strdup(line);
	}
}
clear_DGheader(Conn)
	Connection *Conn;
{	int hi;

	if( headerX ){
		for( hi = 0; hi < headerX; hi++ ){
			free(headerB[hi]);
			headerB[hi] = 0;
		}
		headerX = 0;
	}
}
clear_DGinputs(Conn)
	Connection *Conn;
{	int hi;

	if( inputsX ){
		for( hi = 0; hi < inputsX; hi++ )
			free(inputsB[hi]);
		inputsX = 0;
	}
}

char *fgets_DGclient(Conn,str,size,fp)
	Connection *Conn;
	char *str;
	FILE *fp;
{	char *rcode;

	if( rcode = fgets(str,size,fp) )
		inputsB[inputsX++] = strdup(str);
	return rcode;
}
add_DGinputs(Conn,fmt,a,b,c,d,e,f,g)
	Connection *Conn;
	char *fmt,*a,*b,*c,*d,*e,*f,*g;
{	char line[4096];

	sprintf(line,fmt,a,b,c,d,e,f,g);
	Verbose("**** add_input: %s",line);
	inputsB[inputsX++] = strdup(line);
}


/*
 *	Transfer the local SPECIALIST's environment to the remote GENERALIST
 *	to act as a SPECIALIST for the local one.
 */
add_localheader(Conn,proxy)
	Connection *Conn;
{	char codeconv[128];

	if( proxy )
		add_DGheader(Conn,"LOCAL-PROXY","%d",1);

	if( !proxy ){
		char myhp[1024];

		ClientIF_HP(Conn,myhp);
		add_DGheader(Conn,"LOCAL-DELEGATE","%s",myhp);
	}
	if( DELEGATE_FLAGS[0] )
		add_DGheader(Conn,"LOCAL-FLAGS",   "%s",DELEGATE_FLAGS);

	/* why is this necessary? Gopher-Specialist DeleGate? */
	if( cur_codeconvCL(codeconv) )
		add_DGheader(Conn,"LOCAL-CHARCODE", "%s",codeconv);
}
del_DGlocalheader(Conn)
	Connection *Conn;
{
	clear_DGheader(Conn);
}
set_clientgtype(gtype)
{
	D_GTYPE[0] = gtype;
}
get_clientgtype()
{
	return D_GTYPE[0];
}

extern char *MY_HOSTPORT();
setProtoOfClient(Conn,proto)
	Connection *Conn;
	char *proto;
{
	strcpy(CLIENTS_PROTO,proto);
}
setProxyOfClient(Conn,proxy_client,url)
	Connection *Conn;
	char *url;
{
	if( proxy_client ){
		sscanf(url,"%[^:]",CLIENTS_PROTO);
		strcpy(CLIENTS_PROXY,MY_HOSTPORT());
	}else{
		ClientIF_HP(Conn,CLIENTS_PROXY);
	}
}
char *isSetProxyOfClient(Conn,cl_proto)
	Connection *Conn;
	char *cl_proto;
{
	if( CLIENTS_PROXY[0] ){
		strcpy(cl_proto,CLIENTS_PROTO);
		return CLIENTS_PROXY;
	}else	return 0;
}

initConnected(Conn,svsock,relay_input)
	Connection *Conn;
{
	if( relay_input ){
		DG_relayInput(Conn,svsock);
	}
	set_keepalive(svsock,1);
	FromS = ToS = svsock;
}

OpenServer(what,proto,host,port)
	char *what,*proto,*host;
{	char *server;
	int svsock;

	if( server = strchr(host,'@') )
		server = server + 1;
	else	server = host;
	svsock = client_open("ConnectToServer",proto,server,port);
	/*
	sv1log("connected to %s://%s:%d\n",DFLT_PROTO,server,DFLT_PORT);
	*/
	return svsock;
}

extern int CONNERR_CANTRESOLV;
extern int CONNERR_TIMEOUT;
extern int CONNERR_REFUSED;
extern int CONNERR_UNREACH;

ConnectToServer(Conn,relay_input)
	Connection *Conn;
{	int svsock;

	CONNERR_CANTRESOLV = 0;
	CONNERR_TIMEOUT = 0;
	CONNERR_REFUSED = 0;
	CONNERR_UNREACH = 0;

if( strcmp(DFLT_PROTO,REAL_PROTO)
 || DFLT_PORT != REAL_PORT
 || strcmp(DFLT_HOST,REAL_HOST)
 && gethostintMin(DFLT_HOST) != gethostintMin(REAL_HOST) )
sv1log("#### ConnectToServer: DFLT=%s://%s:%d REAL=%s://%s:%d\n",
DFLT_PROTO,DFLT_HOST,DFLT_PORT, REAL_PROTO,REAL_HOST,REAL_PORT);
/*	svsock = OpenServer("ConnectToServer",DFLT_PROTO,DFLT_HOST,DFLT_PORT); */
	svsock = OpenServer("ConnectToServer",DST_PROTO,DST_HOST,DST_PORT);

	if( 0 <= svsock ){
		initConnected(Conn,svsock,relay_input);
		return svsock;
	}

	if( CONNERR_CANTRESOLV ) Conn->co_error |= CO_CANTRESOLV;
	if( CONNERR_TIMEOUT    ) Conn->co_error |= CO_TIMEOUT;
	if( CONNERR_REFUSED    ) Conn->co_error |= CO_REFUSED;
	if( CONNERR_UNREACH    ) Conn->co_error |= CO_UNREACH;
	return -1;
}
DG_relayInput(Conn,fd)
	Connection *Conn;
{	int hi;

	if( inputsX ){
		for( hi = 0; hi < inputsX; hi++ )
			write(fd,inputsB[hi],strlen(inputsB[hi]));
	}
}

char *add_PATH(me,hostport,teleport)
	char *me,*hostport,*teleport;
{	char path[4096],*pp;

	strcpy(path,me);
	pp = path+strlen(path);

	if( D_PATH[0] == 0 ){
		*pp++ = '!';
		strcpy(pp,hostport);
		pp += strlen(pp);
	}

	if( teleport[0] ){
		*pp++ = '[';
		strcpy(pp,teleport);
		pp += strlen(pp);
		*pp++ = ']';
	}

	*pp++ = '!';
	if( D_PATH[0] ) /* D_PATH given from client DeleGate */
		strcpy(pp,D_PATH);
	else	sprintf(pp,"%s;%d",D_USER,time(0));

	strcpy(D_PATH,path);
	return D_PATH;
}
char *get_PATH(){
	return D_PATH;
}

static findPath1(path1,hostport)
	char *path1,*hostport;
{
	if( strcmp(path1,hostport) == 0 )
		return 1;
	return 0;
}
findInPath(host,port)
	char *host;
{	char *path,*pp;
	char hostport[256];

	path = get_PATH();
	sprintf(hostport,"%s:%d",host,port);
	return scan_List(path,'!',0,findPath1,hostport);
}

static match1(path1,user,hlid)
	char *path1,*user;
{	char host[1024];
	int port;

	if( sscanf(path1,"%[^:]:%d",host,&port) == 2 )
	if( matchPath1(hlid,user,host,port) )
		return 1;
	return 0;
}
matchPATH1(hlid,path,user)
	char *path,*user;
{
	if( path == NULL )
		path = D_PATH;
	return scan_List(path,'!',0,match1,user,hlid);
}
static matchs(path1,hlid)
	char *path1;
{	char host[1024];
	int port;

	if( sscanf(path1,"%[^:]:%d",host,&port) == 2 )
	if( matchPath1(hlid,"-",host,port) == 0 )
		return 1;
	return 0;
}
matchPATHs(hlid,path)
	char *path;
{
	if( path == NULL )
		path = D_PATH;
	return scan_List(path,'!',0,matchs,hlid) == 0;
}

setFROM(username,hostaddr,port)
	char *username,*hostaddr;
{
	sprintf(D_FROM,"%s@[%s] (port=%d; DeleGate%s)",
		username,hostaddr,port,DELEGATE_ver());
}
getFROM(username,hostaddr,ver)
	char *username,*hostaddr,*ver;
{	int port;

	username[0] = hostaddr[0] = 0;
	sscanf(D_FROM,"%[^@]@[%[^]]] (port=%d; DeleGate%s)",
		username,hostaddr,&port,ver);
	return port;
}

matchFROM(hlid)
{	char user[256],host[256],ver[256];
	int port;

	if( port = getFROM(user,host,ver) )
		return matchPath1(hlid,user,host,port);
	return 0;
}

getOriginator(ohost)
	char *ohost;
{	char tmp[1024],*dp;
	int oport;

	strcpy(tmp,D_PATH);
	if( dp = strrchr(tmp,'!') ){
		*dp = 0;
		if( dp = strrchr(tmp,'!') ){
			if( sscanf(dp+1,"%[^:]:%d",ohost,&oport) == 2 )
				return oport;
		}
	}
	*ohost = 0;
	return 0;
}

extern char *wordscan();
scan_header(Conn,fromC,name,value)
	Connection *Conn;
	char *name;
	char *value;
{
	if( streq(name,"MEDIATOR") ){
		D_HOPS++;
		add_DGheader(Conn,name,"%s",value);
	}else
	if( streq(name,"FTPHOPS")){D_FTPHOPS = atoi(value); }else
	if( streq(name,"FROM")   ){add_DGheader(Conn,D_FROM,"%s",value); }else
	if( streq(name,"PATH")   ){add_DGheader(Conn,D_PATH,"%s",value); }else
	if( streq(name,"EXPIRE") ){add_DGheader(Conn,D_EXPIRE,"%s",value); }else
	if( streq(name,"LOCAL-GTYPE") ){
		sv1log("LOCAL-GTYPE: %s\n",value);
		set_clientgtype(*value);
	}else
	if( streq(name,"USER") ){
		char user[256];
		wordscan(value,user);
		CLNT_USER = strdup(user);
		add_DGheader(Conn,D_USER,"%s",user);
	}else
	if( streq(name,"CALLER") ){
		char user[256];
		sscanf(value,"CALLER %s %s %d",user, CLNT_HOST, &CLNT_PORT);
		CLNT_USER = strdup(user);
		add_DGheader(Conn,name,"%s",value);
	}else
	if( streq(name,"HOSTS") ){
		scan_HOSTS(Conn,value);
	}else
	{
		add_DGheader(Conn,name,"%s",value);
	}
}

setREQUEST(Conn,req)
	Connection *Conn;
	char *req;
{	char *dp;

	if( D_REQUEST )
		free(D_REQUEST);
	D_REQUEST = strdup(req);
	if( dp = strpbrk(D_REQUEST,"\r\n") )
		*dp = 0;
}


int REQUEST_SERNO;
incRequestSerno(Conn)
	Connection *Conn;
{
	return REQUEST_SERNO = ++RequestSerno;
}

