/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1994-1998 Electrotechnical Laboratry (ETL), AIST, MITI
Copyright (c) 1994-1998 Yutaka Sato

Permission to use, copy, modify, and distribute this material for any
purpose and without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	croncom.c
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	981120	extracted from delegated.c (5.7.6)
//////////////////////////////////////////////////////////////////////#*/
#include "delegate.h"
#include "param.h"
extern char EXEC_PATH[];
extern int RESTART_NOW;
extern char *DELEGATE_getEnv();
extern char *wordscan();

/*
 *  sched_action is called by sched_eval(), and returns the list of
 *  finished actions....
 */
static dialogue(arg)
	char *arg;
{	int tome[2];
	FILE *tm,*fm;

	Socketpair(tome);
	if( Fork("DIALOG") == 0 ){
		close(tome[1]);
		callSelf(tome[0]);
	}else{
		close(tome[0]);
		/*
		 * the dialog command is invoked with 
		 * file-descriptor 1 bound to the DeleGate input, and
		 * file-descriptor 0 bound to the DeleGate output.
		 */
		if( arg[0] == '/' ){
			dup2(tome[1],0);
			dup2(tome[1],1);
			close(tome[1]);
			system(arg);
			/* FD-2 to the syslog recorder ... */
		}else{
			tm = fdopen(tome[1],"w");
			fprintf(tm,"GROUP etl.chat\r\n");
			fprintf(tm,"XCACHE FETCH\r\n");
			fprintf(tm,"QUIT\r\n");
			fflush(tm);
			fm = fdopen(tome[1],"r");
			simple_relayf(fm,stderr);
			/* it may become connection cache */
			/* wait(0); */
		}
	}
}
static int crons[256];
static int ncrons;
static int cronid;
static spawnv_self(aac,aav)
	char *aav[];
{	int pid;
	int ai,ac;
	char *av[32];

	if( 256 <= ncrons ){
		sv1log("#### too many cron children (%d)\n",ncrons);
		return 0;
	}
	ac = 0;
	av[ac++] = EXEC_PATH;
	for( ai = 0; ai < aac; ai++ )
		av[ac++] = aav[ai];
	av[ac] = NULL;

	pid = Spawnvp("SpawnSelf",EXEC_PATH,av);
	cronid++;
	crons[ncrons++] = pid;
	sv1log("CRON(%d) START [%s] cid=%d pid=%d\n",ncrons,av[1],cronid,pid);
	return pid;
}
static spawn_self(a0,a1)
	char *a0,*a1;
{	char *av[32];

	av[0] = a0;
	av[1] = a1;
	av[2] = NULL;
	return spawnv_self(2,av);
}
DELEGATE_cronExit(pid)
{	int pi,pj;

	for( pi = 0; pi < ncrons; pi++ ){
		if( crons[pi] == pid ){
			for( pj = pi; pj < ncrons-1; pj++ )
				crons[pj] = crons[pj+1];
			crons[pj] = 0;
			sv1log("CRON(%d) FINISH pid=%d\n",ncrons,pid);
			ncrons--;
			return pid;
		}
	}
	return 0;
}
extern char *Isnumber();
static internal_actions(action,act,arg)
	char *action,*act,*arg;
{	int pid;
	char *av[32],ab[8][128];
	int ac,ai,aj;

	pid = 0;
	if( act[0] == 0 ){
		ac = stoV(arg,32,av,' ');
		pid = spawnv_self(ac,av);
	}else
	if( act[0] == 'F' ){
		sprintf(ab[0],"-%s",act);
		av[0] = ab[0];
		ac = 1 + stoV(arg,32-1,&av[1],' ');
		pid = spawnv_self(ac,av);
	}else
	if( strcmp(act,"exit") == 0 ){
		Finish(atoi(arg));
	}else
	if( strcmp(act,"suspend") == 0 ){
		int sec = atoi(arg);
		sv1log("sleeping %d...\n",sec);
		sleep(sec);
	}else
	if( strcmp(act,"restart") == 0 ){
		RESTART_NOW = 1;
	}else
	if( strcmp(act,"expire") == 0 ){
		char period[32],log[1024],param[1024],*rem,*env;

		if( cachedir() == NULL )
			return 0;
		if( (env = DELEGATE_getEnv(P_EXPIRELOG)) == 0 )
			env = DELEGATE_EXPIRELOG;
		strcpy(log,env);
		DELEGATE_substfile(log,"",NULL,NULL,NULL);
		sprintf(param,"LOGFILE=%s",log);

		rem = arg;
		if( Isnumber(arg) )
			rem = wordscan(arg,period);
		else
		if( env = DELEGATE_getEnv(P_EXPIRE) )
			strcpy(period,env);
		else	strcpy(period,"+7d");

		ac = 0;
		av[ac++] = "-Fexpire";
		av[ac++] = cachedir();
		av[ac++] = "-rm";
		av[ac++] = "-atime";
		av[ac++] = period;
		av[ac++] = "-sum";
		av[ac++] = "-ign";
		av[ac++] = param;
		ai = sscanf(rem,"%s %s %s %s %s",ab[0],ab[1],ab[2],ab[3],ab[4]);
		for( aj = 0; aj < ai; aj++ )
			av[ac++] = ab[aj];
		av[ac] = NULL;
		pid = spawnv_self(ac,av);
	}else
	if( strcmp(act,"system") == 0 ){
		pid = spawn_self("-Fsystem",arg,NULL);
	}else
	if( strcmp(act,"fetch") == 0 ){
		pid = spawn_self("-Ffetch",arg,NULL);
	}else
	if( strcmp(act,"dialog") == 0 ){
		pid = spawn_self("-Fdialog",arg,NULL);
	}
	return pid;
}
DELEGATE_sched_action(Conn,action)
	Connection *Conn;
	char *action;
{	char act[1024],arg[1024];
	int pid;

	act[0] = arg[0] = 0;
	sscanf(action,"%s %[^\r\n]",act,arg);

	if( act[0] == '-' ){
		internal_actions(action+1,act+1,arg);
	}else
	if( isFullpath(act) ){
		sv1log("SYSTEM-COMMAND: %s\n",action);
		pid = spawn_self("-Fsystem",action,NULL);
	}else
	{
		sv1log("#### UNKNOWN ACTION: %s\n",action);
	}
}

static void *Cron;
extern void *sched_create();
DELEGATE_sched_execute(now,callback,Conn)
	int (*callback)();
	Connection *Conn;
{	int next;

	next = sched_eval(Cron,now,callback,Conn);
	return next;
}
scan_CRON(Conn,cronspec)
	Connection *Conn;
	char *cronspec;
{
	if( Cron == NULL )
		Cron = sched_create();
	sched_append(Cron,cronspec);
	return 0;
}
