/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1996 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, modify, and distribute this material for any
purpose and without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies, and
that the name of ETL not be used in advertising or publicity pertaining
to this material without the specific, prior written permission of an
authorized representative of ETL.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	cgi.c
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	960110	created
//////////////////////////////////////////////////////////////////////#*/
#include "delegate.h"
#include <ctype.h>
#define MY_HTTPVER	"1.0"
#define MY_CGIVER	"1.1"

extern char **environ;
extern char *getFieldValue2();
#define getFieldValue(str,fld,buf,siz) getFieldValue2(str,fld,buf,siz)
#define getFV(str,fld,buf)             getFieldValue2(str,fld,buf,sizeof(buf))

cgi_head2env(head,ec,ev,epp)
	char *head,*ev[],**epp;
{	char field[0x1000];
	char *ep;
	char accepts[2048],langs[256];
	char *fp,*np,*vp;

	accepts[0] = 0;
	langs[0] = 0;

	Strncpy(field,head,strlen(head));
	strcat(field,"\r\n");
	fp = field;
	ep = *epp;

	while( np = strpbrk(fp,"\r\n") ){
		*np++ = 0;
		for( vp = fp; *vp; vp++ ){
			if( *vp == ':' ){
				*vp++ = 0;
				if( isspace(*vp) )
					vp++;
				break;
			}
			if( islower(*vp) )
				*vp = toupper(*vp);
			else
			if( *vp == '-' )
				*vp = '_';
		}
		if( strcmp(fp,"ACCEPT_LANGUAGE") == 0 ){
			if( langs[0] != 0 )
				strcat(langs,", ");
			strcat(langs,vp);
		}else
		if( strcmp(fp,"ACCEPT") == 0 ){
			if( accepts[0] != 0 )
				strcat(accepts,", ");
			strcat(accepts,vp);
		}else{
			ev[ec++] = ep;
			sprintf(ep,"HTTP_%s=%s",fp,vp);
			ep += strlen(ep) + 1;
		}
		fp = np;
		while( *fp == '\r' || *fp == '\n' )
			fp++;
	}

	if( accepts[0] ){
		ev[ec++] = ep;
		sprintf(ep,"HTTP_ACCEPT=%s",accepts);
		ep += strlen(ep) + 1;
	}
	if( langs[0] ){
		ev[ec++] = ep;
		sprintf(ep,"HTTP_ACCEPT_LANGUAGE=%s",langs);
		ep += strlen(ep) + 1;
	}
	*epp = ep;
	return ec;
}

static char *cgienv;
scan_CGIENV(Conn,envlist)
	Connection *Conn;
	char *envlist;
{
	cgienv = strdup(envlist);
	return 0;
}

cgi_makeenv(conninfo,req,head,ourl,datapath,scripturl,extrapath,av,ev,eb)
	char *conninfo;
	char *req,*head;
	char *ourl,*datapath,*scripturl,*extrapath;
	char *av[],*ev[],*eb;
{	char *search;
	char *ep,*dp;
	char tmp[2048];
	int ac,ec,ei;
	char *es;
	char *fp,*np,*vp;
	char auth[1024],atype[128],auserpass[256],auser[256];
	char method[128];

	ec = 0;
	for( ei = 0; es = environ[ei]; ei++ ){
		if( cgienv == NULL || strmatch_list(es,cgienv,"^=",NULL,NULL) )
			ev[ec++] = es;
	}
	ep = eb;

	atype[0] = auser[0] = 0;
	if( getFV(head,"Authorization",auth) ){
		HTTP_decodeAuthorization(auth,atype,auserpass);
		sscanf(auserpass,"%[^:]",auser);
	}

	/* AUTH_TYPE */
	ev[ec++] = ep;
	sprintf(ep,"AUTH_TYPE=%s",atype);
	ep += strlen(ep) + 1;

	/* CONTENT_LENGTH */
	if( getFV(head,"Content-Length",tmp) == 0 )
		strcpy(tmp,"0");
	ev[ec++] = ep;
	sprintf(ep,"CONTENT_LENGTH=%d",atoi(tmp));
	ep += strlen(ep) + 1;

	/* CONTENT_TYPE */
	if( getFV(head,"Content-Type",tmp) == 0 )
		strcpy(tmp,"text/html");
	ev[ec++] = ep;
	sprintf(ep,"CONTENT_TYPE=%s",tmp);
	ep += strlen(ep) + 1;

	/* GATEWAY_INTERFACE */
	ev[ec++] = ep;
	sprintf(ep,"GATEWAY_INTERFACE=CGI/%s",MY_CGIVER);
	ep += strlen(ep) + 1;

	/* HTTP-* */
	ec = cgi_head2env(head,ec,ev,&ep);

	/* PATH_INFO */
	ev[ec++] = ep;
	sprintf(ep,"PATH_INFO=%s",extrapath);
	ep += strlen(ep) + 1;

	/* PATH_TRANSLATED */
	ev[ec++] = ep;
	sprintf(ep,"PATH_TRANSLATED=%s",*extrapath?datapath:"");
	ep += strlen(ep) + 1;
	Verbose("PATH_TRANSLATED=%s\n",*extrapath?datapath:"");

	/* QUERY STRING */
	ev[ec++] = ep;
	if( search = strchr(ourl,'?') )
		*search++ = 0;
	sprintf(ep,"QUERY_STRING=%s",search?search:"");
	ep += strlen(ep) + 1;

	/* REMOTE_ADDR */
	/* REMOTE_HOST */
	/* REMOTE_IDENT */
	/* REMOTE_USER */
	ev[ec++] = ep;
	sprintf(ep,"REMOTE_ADDR=");
	ep += strlen(ep);
	getFieldValue(conninfo,"Client-Addr",ep,1024);
	ep += strlen(ep) + 1;

	ev[ec++] = ep;
	sprintf(ep,"REMOTE_HOST=");
	ep += strlen(ep);
	getFieldValue(conninfo,"Client-Host",ep,1024);
	ep += strlen(ep) + 1;

	ev[ec++] = ep;
	sprintf(ep,"REMOTE_IDENT=");
	ep += strlen(ep);
	getFieldValue(conninfo,"Client-User-Ident",ep,1024);
	if( strcmp(ep,"-") == 0 )
		*ep++ = 0;
	else	ep += strlen(ep) + 1;

	ev[ec++] = ep;
	sprintf(ep,"REMOTE_USER=%s",auser);
	ep += strlen(ep) + 1;

	/* REQUEST_METHOD */
	wordscan(req,method);
	ev[ec++] = ep;
	sprintf(ep,"REQUEST_METHOD=%s",method);
	ep += strlen(ep) + 1;

	/* REQUEST_URL (extended for CFI) */
	ev[ec++] = ep;
	sprintf(ep,"REQUEST_URL=%s",ourl);
	ep += strlen(ep) + 1;

	/* SCRIPT_NAME */
	ev[ec++] = ep;
	sprintf(ep,"SCRIPT_NAME=%s",scripturl);
	ep += strlen(ep) + 1;

	/* SERVER_NAME */
	/* SERVER_PORT */
	/* SERVER_PROTOCOL */
	/* SERVER_SOFTWARE */
	{	char svhp[256],svhost[256];
		int svport;

		svhost[0] = 0;
		if( getFV(head,"Host",svhp) ){
			svport = 80;
			sscanf(svhp,"%[^:]:%d",svhost,&svport);
		}
		if( svhost[0] == 0 ){
			GetHostname(svhost,sizeof(svhost));
			svport = SERVER_PORT();
		}

		ev[ec++] = ep;
		sprintf(ep,"SERVER_NAME=");
		ep += strlen(ep);
		strcpy(ep,svhost);
		ep += strlen(ep) + 1;

		ev[ec++] = ep;
		sprintf(ep,"SERVER_PORT=");
		ep += strlen(ep);
		sprintf(ep,"%d",svport);
		ep += strlen(ep) + 1;

		ev[ec++] = ep;
		sprintf(ep,"SERVER_PROTOCOL=HTTP/%s",MY_HTTPVER);
		ep += strlen(ep) + 1;

		ev[ec++] = ep;
		sprintf(ep,"SERVER_SOFTWARE=DeleGate/%s",
			DELEGATE_ver());
		ep += strlen(ep) + 1;
	}
	ev[ec] = 0;

	if( av != NULL ){
		ac = 0;
		if( search ){
			fp = ep;
			strcpy(fp,search);
			strcat(fp,"+");
			while( np = strchr(fp,'+') ){
				av[ac++] = fp;
				*np = 0;
				fp = np + 1;
			}
		}
		av[ac] = 0;
	}
/*
for( ei = 0; ei < ac; ei++ ) fprintf(stderr,"#### ARG[%2d] %s\n",ei,av[ei]);
for( ei = 0; ei < ec; ei++ ) fprintf(stderr,"#### ENV[%2d] %s\n",ei,ev[ei]);
*/
}

cgi_response(Conn,ihead,in,out)
	Connection *Conn;
	char *ihead;
	FILE *in,*out;
{	char ohead[0x10000],*hp;
	char ctype[1024],status[1024];
	char location[1024];
	char field[1024],value[1024];
	char line[1024],*tp;
	int hleng,bleng,cleng,hcc;
	char ostat[1024];

	hp = ohead;

	strcpy(status,"200 CGI-OK");
	location[0] = 0;
	if( getFV(ihead,"Content-Type",ctype) )
		rmField(ihead,"Content-Type");
	else	strcpy(ctype,"text/plain");

	hcc = 0;
	cleng = -1;

	for(;;){
		if( fgets(line,sizeof(line),in) == NULL )
			break;
		hcc += strlen(line);

		if( tp = strpbrk(line,"\r\n") )
			*tp = 0;

		if( line[0] == 0 )
			break;

		if( strchr(line,':') == NULL )
		if( line[0] != ' ' && line[0] != '\t' )
			/* is folding supported in HTTP ? */
		{
			sv1log("NON header from CGI program? %s\n",line);
			break;
		}

		field[0] = value[0] = 0;
		sscanf(line,"%[^:]:%[^\r\n]",field,value);
		if( strcasecmp(field,"Status") == 0 ){
			linescan(value,status,sizeof(status));
			continue;
		}
		if( strcasecmp(field,"Location") == 0 ){
			linescan(value,location,sizeof(location));
			continue;
		}
		if( strcasecmp(field,"Content-Type") == 0 ){
			linescan(value,ctype,sizeof(ctype));
			continue;
		}
		if( strcasecmp(field,"Content-Length") == 0 )
			cleng = atoi(value);

		sprintf(hp,"%s\r\n",line);
		hp += strlen(hp);
	}
	if( hcc == 0 )
		return 0;

	if( getFV(ihead,"Server",line) == NULL ){
		sprintf(hp,"Server: DeleGate/%s\r\n",DELEGATE_ver());
		hp += strlen(hp);
	}

	if( location[0] ){
		char server[256];
		strcpy(status,"302 Moved (output of CGI)");
		if( location[0] == '/' ){
			if( Conn )
				ClientIF_HP(Conn,server);
			else{
				sprintf(server,"%s:%s",
					getenv("SERVER_NAME"),
					getenv("SERVER_PORT"));
			}
			sprintf(hp,"Location: http://%s%s\r\n",server,location);
		}else	sprintf(hp,"Location: %s\r\n",location);
		hp += strlen(hp);
	}
	sprintf(ostat,"HTTP/%s %s\r\n",MY_HTTPVER,status);
	sprintf(hp,"Content-Type: %s\r\n",ctype);
	hp += strlen(hp);

	if( 0 < cleng && file_size(fileno(in)) - ftell(in) == cleng ){
		if( Conn )
		if( getKeepAlive(Conn,hp) )
			hp += strlen(hp);
	}
	strcpy(hp,ihead);
	hp += strlen(hp);
	strcpy(hp,"\r\n");

	fputs(ostat,out);
	fputs(ohead,out);
	hleng = strlen(ostat) + strlen(ohead);

	if( 0 < cleng )
		bleng = copyfile1(in,out);
	else	bleng = simple_relayf(in,out);
	return hleng+bleng;
}

exec_cgi(Conn,req,reqhead,scriptpath,datapath,ourl,scripturl,extpath,fc,tc)
	Connection *Conn;
	char *req,*reqhead,*scriptpath,*datapath;
	char *ourl,*scripturl,*extpath;
	FILE *fc,*tc;
{	char workdir[1024];
	char *tp;
	FILE *pfp[2];
	int toCGI[2],fromCGI[2];
	char oreq[2048];
	char tmp[128];
	int leng;
	char *env;

	pipe(toCGI);
	pipe(fromCGI);

	if( Fork("CGI") == 0 ){
		char *av[32],*ev[128],eb[0x10000];
		int ec;
		char conninfo[4096];
		make_conninfo(Conn,conninfo,NULL);

		strcpy(workdir,datapath);
		if( tp = strrchr(workdir,'/') )
			*tp = 0;

		sv1log("chdir(%s)\n",workdir);
		chdir(workdir);
		close(toCGI[1]);   dup2(toCGI[0],0);
		close(fromCGI[0]); dup2(fromCGI[1],1);
		av[0] = scriptpath;
		ec = 0;
		cgi_makeenv(conninfo,req,reqhead,ourl,datapath,scripturl,extpath,
			&av[1],&ev[ec],eb);
		environ = ev;

		/* don't use Execvp() because it not returns even on error. */
		execvp(scriptpath,av);

		sv1log("#### FAILED EXEC: %s\n",scriptpath);
		if( env = getenv("PATH") )
			sv1log("#### PATH=%s\n",env);

		tc = fdopen(fromCGI[1],"w");
		fprintf(tc,"Status: 500 cannot execute\r\n");
		fprintf(tc,"Content-Type: text/plain\r\n");
		fprintf(tc,"\r\n");
		fprintf(tc,"Couldn't find or execte the CGI script.\r\n");
		Finish(-1);
	}
	close(toCGI[0]);   pfp[1] = fdopen(toCGI[1],"w");
	close(fromCGI[1]); pfp[0] = fdopen(fromCGI[0],"r");

	if( getFV(reqhead,"Content-Length",tmp) ){
		int leng,rcc,wcc;
		char body[0x10000];

		leng = atoi(tmp);
		rcc = fread(body,1,leng,fc);
		wcc = fwrite(body,1,rcc,pfp[1]);
		fflush(pfp[1]);
		body[leng] = 0;
		sv1log("## Sent message body data to CGI %d/%d\n",wcc,rcc);
	}
	fclose(pfp[1]);
	leng = cgi_response(Conn,"",pfp[0],tc);
	fclose(pfp[0]);
	return leng;
}

static dump(request)
	char *request;
{	int ei;
	char *env;

	printf("Content-Type: text/html\r\n\r\n");
	printf("<H2>DeleGate as a CGI program</H2>\n");
	printf("<PRE>\r\n");
	printf("%s\r\n",request);
	for( ei = 0; env = environ[ei]; ei++ )
		printf("%s\r\n",env);
	printf("</PRE>\r\n");
	fflush(stdout);
}

cgi_delegate(ac,av,Conn)
	char *av[];
	Connection *Conn;
{	char ei;
	char request[4096],*rp;
	char *env,*method,*url,*ver;
	char field[128],value[4096];
	char *host,*port,*path,server[1024],mount[1024],delegate[1024];
	char *leng,*type;
	char *query,qext[1024];
	char *chost,*caddr,*cuser;
	int fromHttpd[2],toHttpd[2];
	int wcc;

	method = getenv("REQUEST_METHOD");
	url = getenv("PATH_INFO");
	ver = getenv("SERVER_PROTOCOL");
	host = getenv("SERVER_NAME");
	port = getenv("SERVER_PORT");
	path = getenv("SCRIPT_NAME");
	query = getenv("QUERY_STRING");
	chost = getenv("REMOTE_HOST");
	caddr = getenv("REMOTE_ADDR");
	cuser = getenv("REMOTE_IDENT");

	if( method == 0 || host == 0 || port == 0 || path == 0 ){
		printf("Status: 500 CGI-DeleGate Error\r\n");
		return;
	}
	if( url == 0 ){
		printf("Status: 404 CGI-DeleGate Not Found\r\n");
		return;
	}
	if( url[0] == 0 )
		url = "/";

	sv1log("CGI-DeleGate accepted: %s@%s[%s]\n",
		cuser?cuser:"-",chost?chost:"",caddr?caddr:"");

	Conn->from_myself = 1;
	ACT_SPECIALIST = 1;
	if( chost && chost[0] )
		strcpy(CLNT_HOST,chost);
	else	strcpy(CLNT_HOST,caddr);

	sprintf(server,"%s://%s:%s%s","http",host,port,path);
	scan_SERVER(Conn,server);

/*
	sprintf(mount,"http://%s:%s%s",host,port,path);
	set_MOUNT(Conn,"/-","=","");
	set_MOUNT(Conn,"/*",mount,"");
*/

	sprintf(delegate,"%s:%s",host,port);
	scan_DELEGATE(Conn,delegate);
	strcpy(Conn->cl_urlbase,path);

	rp = request;
	if( query && *query )
		sprintf(qext,"?%s",query);
	else	qext[0] = 0;
	sprintf(rp,"%s %s%s %s\r\n",method,url,qext,ver?ver:"");
	rp += strlen(rp);

	for( ei = 0; env = environ[ei]; ei++ ){
		if( strncmp(env,"HTTP_",5) == 0 )
		if( sscanf(env+5,"%[^=]=%[^\n]",field,value) == 2 ){
			char *fp;

			for( fp = &field[1]; *fp; fp++ ){
				if( isupper(*fp) )
					*fp = tolower(*fp);
				if( *fp == '_' )
					*fp = '-';
			}
			if( strcasecmp(field,"Accept") == 0 ){
			}
			sprintf(rp,"%s: %s\r\n",field,value);
			rp += strlen(rp);
		}
	}

	/* dump(request); */

	Socketpair(fromHttpd);
	if( Fork("CGI-DeleGate-To") == 0 ){
		fclose(stdout);
		fclose(stderr);
		close(fromHttpd[0]);

		if( type = getenv("CONTENT_TYPE") ){
			sprintf(rp,"Content-Type: %s\r\n",type);
			rp += strlen(rp);
		}
		if( leng = getenv("CONTENT_LENGTH") ){
			sprintf(rp,"Content-Length: %s\r\n",leng);
			rp += strlen(rp);
		}
		strcpy(rp,"\r\n");
		write(fromHttpd[1],request,strlen(request));
		wcc = simple_relayTimeout(fileno(stdin),fromHttpd[1],1000);
		sv1log("CGI-DeleGate-To: relayed request body %d+%d bytes\n",
			strlen(request),wcc);
		Finish(0);
	}
	close(fromHttpd[1]);
	fclose(stdin);

	Socketpair(toHttpd);
	if( Fork("CGI-DeleGate-From") == 0 ){
		char stat[1024],*rcode,head1[4096];
		FILE *resp;
		int ch,hcc,bcc;

		close(toHttpd[1]);
		resp = fdopen(toHttpd[0],"r");
		fgets(stat,sizeof(stat),resp);
		hcc = strlen(stat);
		bcc = 0;

		if( strncmp(stat,"HTTP/",5) == 0 ){
		   if( rcode = strchr(stat,' ') ){
			fprintf(stdout,"Status: %s",rcode);
			while( fgets(head1,sizeof(head1),resp) != NULL ){
				hcc += strlen(head1);

				if( strncasecmp(head1,"Content-Type",12)==0
				 || strncasecmp(head1,"Last-Modified",13)==0
				){
					fputs(head1,stdout);
				}else
				if( head1[0] == '\r' || head1[0] == '\n' ){
					fputs(head1,stdout);
					break;
				}
			}
		    }
		}else	fputs(stat,stdout);
		while( 0 < ready_cc(resp) ){
			if( (ch = getc(resp)) == EOF )
				break;
			putc(ch,stdout);
			bcc++;
		}
		fflush(stdout);

		bcc += simple_relay(toHttpd[0],fileno(stdout));
		sv1log("CGI-DeleGate-From: relayed response %d+%d bytes\n",hcc,bcc);
		Finish(0);
	}
	close(toHttpd[0]);
	fclose(stderr);
	fclose(stdout);

	execGeneralist(Conn,fromHttpd[0],toHttpd[1],-1);
	close(fromHttpd[0]);
	close(toHttpd[1]);
	LOG_flushall();
}
